/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class NodeSource
implements ActiveSource {
    private final NodeInfo node;
    private String systemId;

    public NodeSource(NodeInfo node) {
        this.node = node;
        this.systemId = node.getSystemId();
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        Sender.sendDocumentInfo(this.node, receiver, new Loc(this.getSystemId(), -1, -1));
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        if (this.systemId == null) {
            return this.node.getSystemId();
        }
        return this.systemId;
    }

    public NodeInfo getNode() {
        return this.node;
    }
}

