/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CharactersFn;
import net.sf.saxon.functions.CodepointsToString;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.ParcelFn;
import net.sf.saxon.functions.Parts;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.UnparcelFn;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.SefFunction;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.ma.Parcel;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XPath40FunctionSet
extends BuiltInFunctionSet {
    private static final XPath40FunctionSet THE_INSTANCE = new XPath40FunctionSet();

    public static XPath40FunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private XPath40FunctionSet() {
        this.init();
    }

    private void init() {
        this.importFunctionSet(XPath31FunctionSet.getInstance());
        SpecificFunctionType predicate = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.SINGLE_BOOLEAN);
        SpecificFunctionType ft = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.ATOMIC_SEQUENCE);
        this.register("all", 2, SefFunction.class, BuiltInAtomicType.BOOLEAN, 16384, 513).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, predicate, 16384, null);
        this.register("characters", 1, CharactersFn.class, BuiltInAtomicType.STRING, 57344, 0).arg(0, BuiltInAtomicType.STRING, 16384, null);
        this.register("codepoints-to-string", 1, CodepointsToString.class, BuiltInAtomicType.STRING, 16384, 262144).arg(0, BuiltInAtomicType.INTEGER, 57344, null);
        this.register("concat", 1, Concat.class, BuiltInAtomicType.STRING, 16384, 262144).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, null);
        this.register("highest", 1, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null);
        this.register("highest", 2, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, BuiltInAtomicType.STRING, 24576, null);
        this.register("highest", 3, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, ft, 16384, null);
        this.register("identity", 1, SefFunction.class, AnyItemType.getInstance(), 57344, 513).arg(0, AnyItemType.getInstance(), 57344, null);
        this.register("index-where", 2, SefFunction.class, BuiltInAtomicType.INTEGER, 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 16384, null);
        this.register("in-scope-namespaces", 1, SefFunction.class, MapType.ANY_MAP_TYPE, 16384, 512).arg(0, NodeKindTest.ELEMENT, 57344, null);
        this.register("is-NaN", 1, SefFunction.class, BuiltInAtomicType.BOOLEAN, 16384, 512).arg(0, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
        this.register("items-before", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 16384, null);
        this.register("items-until", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 16384, null);
        this.register("items-from", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 16384, null);
        this.register("items-after", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 16384, null);
        this.register("lowest", 1, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null);
        this.register("lowest", 2, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, BuiltInAtomicType.STRING, 24576, null);
        this.register("lowest", 3, HighestOrLowest.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, ft, 16384, null);
        this.register("parcel", 1, ParcelFn.class, Parcel.TYPE, 16384, 0).arg(0, AnyItemType.getInstance(), 57344, null);
        this.register("parts", 1, Parts.class, new MapType(BuiltInAtomicType.STRING, SequenceType.ANY_SEQUENCE), 16384, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
        this.register("range", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 24576, null);
        this.register("range", 3, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 24576, null).arg(2, predicate, 24576, null);
        this.register("range", 4, SefFunction.class, AnyItemType.getInstance(), 57344, 512).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, predicate, 24576, null).arg(2, predicate, 24576, null).arg(3, MapType.ANY_MAP_TYPE, 16384, null);
        this.register("slice", 2, SefFunction.class, AnyItemType.getInstance(), 57344, 513).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, MapType.ANY_MAP_TYPE, 16384, null);
        this.register("some", 2, SefFunction.class, BuiltInAtomicType.BOOLEAN, 16384, 513).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, predicate, 16384, null);
        this.register("unparcel", 1, UnparcelFn.class, AnyItemType.getInstance(), 57344, 0).arg(0, Parcel.TYPE, 16384, null);
    }

    public static class HighestOrLowest
    extends SefFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            StringValue val;
            Sequence input = arguments[0];
            String collationUri = null;
            if (arguments.length >= 2 && (val = (StringValue)arguments[1].head()) != null) {
                try {
                    collationUri = ResolveURI.makeAbsolute(val.getStringValue(), this.getStaticBaseUriString()).toString();
                }
                catch (URISyntaxException e) {
                    throw new XPathException(e);
                }
            }
            if (collationUri == null) {
                collationUri = this.getRetainedStaticContext().getDefaultCollationName();
            }
            Function key = arguments.length >= 3 ? (Function)arguments[2].head() : SystemFunction.makeFunction("data", this.getRetainedStaticContext(), 1);
            SymbolicName.F delegate = new SymbolicName.F(new StructuredQName("", "http://ns.saxonica.com/xpath-functions", "mhk_highest"), 4);
            Sequence[] args = new Sequence[]{input.materialize(), new StringValue(collationUri), key, BooleanValue.get(this.getDetails().name.getLocalPart().equals("highest"))};
            return this.callFunction(context, delegate, args);
        }
    }
}

