/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class MildKeys<K, V>
implements Map<K, V> {
    final ReferenceQueue<K> queue = new ReferenceQueue();
    final Map<Reference<K>, V> map;
    private final boolean soft;

    MildKeys(Map<Reference<K>, V> map2, boolean soft) {
        this.map = map2;
        this.soft = soft;
    }

    @Override
    public final boolean containsKey(Object key2) {
        return this.map.containsKey(MildKeys.tempKey(key2));
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final V get(Object key2) {
        return this.map.get(MildKeys.tempKey(key2));
    }

    @Override
    public final V put(K key2, V value) {
        this.compact();
        return this.map.put(this.mildKey(key2), value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e2 : m.entrySet()) {
            this.map.put(this.mildKey(e2.getKey()), e2.getValue());
        }
    }

    @Override
    public final V remove(Object key2) {
        this.compact();
        return this.map.remove(MildKeys.tempKey(key2));
    }

    @Override
    public final void clear() {
        this.map.clear();
        this.compact();
    }

    @Override
    public final boolean isEmpty() {
        this.compact();
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        this.compact();
        return this.map.size();
    }

    @Override
    public final Set<K> keySet() {
        this.compact();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyItr();
            }

            @Override
            public int size() {
                return MildKeys.this.map.size();
            }
        };
    }

    @Override
    public final Collection<V> values() {
        this.compact();
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryItr();
            }

            @Override
            public int size() {
                return MildKeys.this.map.size();
            }
        };
    }

    final Reference<K> mildKey(K key2) {
        return this.soft ? new Soft<K>(key2, this.queue) : new Weak<K>(key2, this.queue);
    }

    static final <K> Reference<K> tempKey(K key2) {
        return new Weak<K>(key2, null);
    }

    final void compact() {
        Reference<K> ref2;
        while ((ref2 = this.queue.poll()) != null) {
            this.map.remove(ref2);
        }
    }

    final class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Reference<K>, V>> itr;
        private Map.Entry<Reference<K>, V> nextEntry;
        private K nextKey;

        EntryItr() {
            this.itr = MildKeys.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextKey == null && this.itr.hasNext()) {
                this.nextEntry = this.itr.next();
                this.nextKey = this.nextEntry.getKey().get();
            }
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                StrongEntry entry = new StrongEntry(this.nextEntry, this.nextKey);
                this.nextEntry = null;
                this.nextKey = null;
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    final class KeyItr
    implements Iterator<K> {
        private final Iterator<Reference<K>> itr;
        private K nextKey;

        KeyItr() {
            this.itr = MildKeys.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextKey == null && this.itr.hasNext()) {
                this.nextKey = this.itr.next().get();
            }
            return this.nextKey != null;
        }

        @Override
        public K next() {
            if (this.hasNext()) {
                Object key2 = this.nextKey;
                this.nextKey = null;
                return key2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static class Soft<T>
    extends SoftReference<T> {
        private final int hash;

        Soft(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (o != null && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }

    final class StrongEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<Reference<K>, V> entry;
        private final K key;

        StrongEntry(Map.Entry<Reference<K>, V> entry, K key2) {
            this.entry = entry;
            this.key = key2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }
    }

    static class Weak<T>
    extends WeakReference<T> {
        private final int hash;

        Weak(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (o != null && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }
}

