#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
author: Francisco Munoz (@fmunoz)
description:
  - Manage operation update of the resource devices _switch _warm _spare.
  - 'Update warm spare configuration for a switch. The spare will use the same L3
    configuration as the primary. Note that this will irreversibly destroy any existing
    L3 configuration on the spare.

    '
extends_documentation_fragment:
  - cisco.meraki.module
module: devices_switch_warm_spare
notes:
  - SDK Method used are switch.Switch.update_device_switch_warm_spare,
  - Paths used are put /devices/{serial}/switch/warmSpare,
options:
  enabled:
    description: Enable or disable warm spare for a switch.
    type: bool
  serial:
    description: Serial path parameter.
    type: str
  spareSerial:
    description: Serial number of the warm spare switch.
    type: str
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - description: Complete reference of the updateDeviceSwitchWarmSpare API.
    link: https://developer.cisco.com/meraki/api-v1/#!update-device-switch-warm-spare
    name: Cisco Meraki documentation for switch updateDeviceSwitchWarmSpare
short_description: Resource module for devices _switch _warm _spare
version_added: 2.16.0
"""

EXAMPLES = r"""
- name: Update all
  cisco.meraki.devices_switch_warm_spare:
    meraki_api_key: '{{ meraki_api_key }}'
    meraki_base_url: '{{ meraki_base_url }}'
    meraki_single_request_timeout: '{{ meraki_single_request_timeout }}'
    meraki_certificate_path: '{{ meraki_certificate_path }}'
    meraki_requests_proxy: '{{ meraki_requests_proxy }}'
    meraki_wait_on_rate_limit: '{{ meraki_wait_on_rate_limit }}'
    meraki_nginx_429_retry_wait_time: '{{ meraki_nginx_429_retry_wait_time }}'
    meraki_action_batch_retry_wait_time: '{{ meraki_action_batch_retry_wait_time }}'
    meraki_retry_4xx_error: '{{ meraki_retry_4xx_error }}'
    meraki_retry_4xx_error_wait_time: '{{ meraki_retry_4xx_error_wait_time }}'
    meraki_maximum_retries: '{{ meraki_maximum_retries }}'
    meraki_output_log: '{{ meraki_output_log }}'
    meraki_log_file_prefix: '{{ meraki_log_file_prefix }}'
    meraki_log_path: '{{ meraki_log_path }}'
    meraki_print_console: '{{ meraki_print_console }}'
    meraki_suppress_logging: '{{ meraki_suppress_logging }}'
    meraki_simulate: '{{ meraki_simulate }}'
    meraki_be_geo_id: '{{ meraki_be_geo_id }}'
    meraki_use_iterator_for_get_pages: '{{ meraki_use_iterator_for_get_pages }}'
    meraki_inherit_logging_config: '{{ meraki_inherit_logging_config }}'
    state: present
    enabled: true
    serial: string
    spareSerial: Q234-ABCD-0002
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "enabled": true,
      "primarySerial": "string",
      "spareSerial": "string"
    }
"""
