---
myst:
  html_meta:
    keywords: LaTeX
---
# Comment utiliser une police ?

## Avec pdflatex

:::{todo} Faire que les exemples compilent (ils fonctionnent si on les compile sur sa machine)
:::

Pour déclarer une police de caratères par défaut dans un document, on peut utiliser les commandes `\familydefault`, `\encodingdefault`, `\seriesdefault` et `\shapedefault`.

Exemple :

```
\documentclass{report}
\renewcommand{\familydefault}{cmtt}
\begin{document}
\verb=\renewcommand{\familydefault}{cmtt}=
dans le préambule d'un document permet de
sélectionner la police computer modern de
type machine à écrire pour tout le corps
du document.
\end{document}
```

```
\documentclass{report}
\begin{document}
\begin{verbatim}\renewcommand{\familydefault}{cmtt}\end{verbatim}
\texttt{dans le préambule d'un document permet de
sélectionner la police computer modern de
type machine à écrire pour tout le corps
du document.}
\end{document}
```

En LaTeX, un certain nombre de packages permettent de faire appel à une police particulière.

Exemple :

```
\documentclass{report}
\usepackage{helvet}
\begin{document}
\verb=\usepackage{helvet}= dans le préambule
d'un document permet de sélectionner la police
helvet pour tout le corps du document.
\end{document}
```

À un niveau plus bas, dans la création d'un style par exemple, la sélection d'une police peut se faire de la manière suivante :

```{noedit}
\fontfamily{ccr}\fontencoding{T1}\fontseries{c}%
\fontshape{sl}\fontsize{9}{11pt}\selectfont
```

ou encore :

```{noedit}
\fontsize{14}{16pt}\usefont{OT1}{cmdh}{bc}{it}
```

Pour définir une commande de changement de police, on peut utiliser `DeclareFixedFont`.

Exemple :

```{noedit}

 \DeclareFixedFont{\petitefonte}%
                  {\encodingdefault}%
                  {\familydefault}%
                  {\seriesdefault}%
                  {\shapedefault}%
                  {6pt}
 \newcommand{\petit}{\petitefonte}
```

## Avec Xe(La)TeX et Lua(La)TeX

:::{todo} Donner des exemples
:::

Utiliser l'extension <ctanpkg:fontspec> (éventuellement via <ctanpkg:polyglossia>).
