---
myst:
  html_meta:
    keywords: LaTeX, composiiton, illustrations, images
---

# Comment insérer une image ?

Donald Knuth, lors de la conception de la version de TeX au début 
des années 1980, n'avait pu déterminer aucune syntaxe standard pour décrire
les graphiques dans les documents. Il avait estimé que cet état 
ne pouvait pas persister indéfiniment mais qu'il serait insensé de sa part
de définir des primitives TeX permettant l'importation d'images. Il a donc
reporté la spécification des images aux auteurs de pilotes graphiques DVI.
Les documents TeX contrôleraient donc les pilotes au moyen de la commande 
`\special` (étudiée à la question 
"[](/5_fichiers/formats/postscript/commandes_special)").

Si vous saviez utiliser les commandes `\special` et que vous connaissiez bien
les pilotes graphiques, vous pouviez donc arriver à inclure des images. 
Cela restait cependant une solution accessible à peu de monde. Au fil des ans,
par conséquent, des extensions "d'inclusion graphique" ont vu le jour : 
la plupart ont été conçues pour l'inclusion d'images 
[PostScript encapsulés](/5_fichiers/formats/postscript/postscript_encapsule) 
(ou EPS) qui est longtemps restée le format de prédilection des utilisateurs
de TeX et LaTeX. Des solutions plus générales sont arrivées par la suite.


## Avec l'extension <ctanpkg:graphicx>

Solution incontournable, l'extension <ctanpkg:graphicx>, basée sur l'extension
<ctanpkg:graphics> décrite plus bas, fournit une commande `\includegraphics`, 
dont le nom est assez explicite. Cette commande prend en argument obligatoire
le nom du fichier contenant l'image :

- aux formats JPEG, PNG ou PDF en cas de compilation avec `pdftex`, `pdflatex`
  et autres moteurs plus récents ;
- au format EPS en cas de compilation avec `tex` ou `latex`. Indirectement, 
  cela inclut le format PS, comme le montre la question 
  "[](/3_composition/illustrations/images/convertir_du_ps_en_eps)".
- et quelques autres formats. En effet, certaines distributions LaTeX 
  modifient l'environnement à l'aide de la commande `\DeclareGraphicsRule`
  pour pouvoir utiliser d'autres formats d'image. En fait, LaTeX effectue 
  une conversion à la volée lors de la compilation à l'aide de la commande
  en dernier argument de `\DeclareGraphicsRule`. Le document 
  "[Utilisation de graphiques importés dans LaTeX2e](texdoc:fepslatex)" 
  détaille l'utilisation de cette commande.

L'exemple ci-dessous utilise une image PDF.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici mon prototype de caractère : 

\includegraphics{example-image-a}
\end{document}
```

La commande `\includegraphics` peut prendre de nombreux arguments optionnels,
afin de modifier la taille ou l'orientation de l'image, par exemple. 
Concernant les dimensions de l'image, quelques options sont décrites 
dans la réponse à la question 
"[](/3_composition/illustrations/images/changer_la_bounding_box_d_une_image)".
En voici quelques-unes :

- `[width=...]` permet de spécifier la taille de l'image, qui sera alors 
  agrandie ou rétrécie à la dimension voulue ;
- `[height=...]` permet de spécifier la hauteur de l'image ;
- `[keepaspectratio=false]` et `[keepaspectratio=true]` permettent, 
  dans les cas où on a spécifié à la fois la hauteur et la largeur de l'image,
  de déformer ou non, respectivement, l'image. Dans le cas où on choisit 
  de ne pas la déformer, elle sera réduite ou agrandie de telle sorte que 
  ses dimensions soient inférieures aux valeurs données ;
- `[scale=...]` permet de préciser le facteur d'agrandissement 
  qui doit être appliqué à l'image. Par défaut, c'est `1`, bien entendu. 
  Pour diviser les dimensions horizontales et verticales de l'image par deux, 
  il faut indiquer `[scale=0.5]` ;
- `[angle=...]` permet de spécifier l'angle dont doit être tournée la figure, 
  dans le sens inverse des aiguilles d'une montre, et en degrés. La figure est 
  alors tournée autour de son coin inférieur gauche ;
- `[origin=...]` permet de spécifier le point autour duquel l'image doit 
  être tournée. Cette origine doit contenir une ou deux lettres parmi `l`, `r`,
  `c`, `t` et `b` (qui signifient respectivement *left*, *right*, *center*, 
  *top* et *bottom*).

Ces options sont à séparer les unes des autres par des virgules. Par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici mon prototype de caractère : 

\includegraphics[width=0.5\linewidth,angle=53]{example-image-a}
\end{document}
```

La [documentation](texdoc:graphicx) comprend de nombreux exemples (en anglais).
L'article "[Stratégies pour inclure des graphiques dans des documents en LaTeX](https://www.gutenberg-asso.fr/IMG/pdf/Graphiques.pdf)"
propose une vue d'ensemble en français.

Pour les plus curieux, il faut noter que, par rapport à <ctanpkg:graphics>, 
<ctanpkg:graphicx> utilise une syntaxe de commande un peu plus sophistiquée 
pour sa version de la commande `\includegraphics`. Elle est également capable
de produire du code PostScript plus efficace et peut obtenir des résultats 
tout simplement inaccessibles à <ctanpkg:graphics>.

Enfin, si vous utilisez d'anciens [formats](/1_generalites/glossaire/format) 
de TeX, l'utilisation de <ctanpkg:graphicx> peut demander 
des manipulations complémentaires. Si les utilisateurs 
d’[Eplain](/1_generalites/glossaire/eplain) peuvent charger directement
<ctanpkg:graphicx>, les utilisateurs de Plain TeX doivent passer par l'une 
des deux méthodes suivantes :

- utiliser *l'émulateur* LaTeX <ctanpkg:miniltx> ;
- utiliser le fichier [graphicx.tex](ctanpkg:graphics-pln) qui permet 
  de charger <ctanpkg:graphicx>.


## Avec l'extension <ctanpkg:epsfig>

Si l'extension <ctanpkg:graphicx> est considérée comme la référence,
l'extension <ctanpkg:epsfig> fournit les mêmes fonctionnalités (elle appelle
d'ailleurs <ctanpkg:graphicx>) via une commande `\psfig` (ou `\epsfig`), 
afin d'émuler le comportement de l'ancienne extension <ctanpkg:psfig>. 
Elle fournit également une assistance simple pour les anciens utilisateurs
de l'extension <ctanpkg:epsf>.

Cette extension permet d'inclure une figure exportée par `xfig` 
au format combiné `eps`/LaTeX avec la commande `\input`.


:::{sources}
- [Documentation](texdoc:graphicx) de <ctanpkg:graphicx>
- [Stratégies pour inclure des graphiques dans des documents en LaTeX](https://www.gutenberg-asso.fr/IMG/pdf/Graphiques.pdf)
- [Documentation](texdoc:epsfig) de <ctanpkg:epsfig>
:::