Package ucph-revy
=================
v1.1.0

A class for typesetting scripts, containing both lyrics and prose, in
the style used by the student revues (revy) at the Faculties of
Science at the University of Copenhagen (uchp).

Installation
------------

To install the class, you should run the file

    ucph-revy.ins

through LaTeX. This will create the file `ucph-revy.cls`, which you
should place in a location searched by LaTeX. In the TeX Directory
Structure, it belongs in the folder `tex/latex/ucph-revy/`.

Generating documentation
------------------------

You may want to generate either the user manual (which will provide
instructions and examples on how to use the class) or the full
documentation (which will provide the user manual along with a full
source listing), in either danish or english.

For each of these options, there is an `.ins` file that can be run
through LaTeX. To get the indexes and citations right, you will need
to run some combination of `bibtex` and `makeindex`, and then run the
`.ins` file through LaTeX a few more times, until the references
settle down. The individual `.ins` files should output instructions on
the specific commands that need to be run to get them right, in their
console output.

The `.ins` files are:

#### `ucph-revy-man-da.ins` ####
- Creates the user manual in danish.

#### `ucph-revy-doc-da.ins` ####
- Creates the full documentation in danish.

#### `ucph-revy-man-en.ins` ####
- Creates the user manual in english.

#### `ucph-revy-doc-en.ins` ####
- Creates the full documentation in english.

There are a few more `.ins` files, that pull some example `.tex` files
out of the main `.dtx` file:

#### `ucph-revy-ex-da.ins` ####
- Creates `Eksempel.tex`, an example usage file in danish.

#### `ucph-revy-ex-en.ins` ####
- Creates `Example.tex`, and example usage file in english.

#### `ucph-revy-ex-thumb.ins` ####
- Creates `Thumbindex.tex`, a file that demonstrates how to use the
  thumb index feature to create a thumb index page.
  
Contact the author
------------------

As of 2024:

[Kristoffer Levin Hansen](mailto:kristoffer@levinhansen.dk)

License
-------

This file may be distributed and/or modified under the conditions of
the LaTeX Project Public License, either version 1.3 of this license
or (at your option) any later version. The latest version of this
license is in:

  <http://www.latex-project.org/lppl.txt>
  
and version 1.3 or later is part of all distributions of LaTeX version
2005/12/01 or later.
