/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.PlayerObjects;
import hughai.utils.Formatting;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogFile {
    public boolean AutoFlushOn = true;
    Logger logger = Logger.getLogger("general");
    PlayerObjects playerObjects;

    public LogFile(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
    }

    public LogFile Init(String string) {
        try {
            System.out.println("logfile init: [" + string + "]");
            this.setupLogger(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        return this;
    }

    void setupLogger(String string) throws Exception {
        FileHandler fileHandler = new FileHandler(string);
        this.logger.addHandler(fileHandler);
        StdInfoHandler stdInfoHandler = new StdInfoHandler();
        this.logger.addHandler(stdInfoHandler);
        for (Handler handler : this.logger.getHandlers()) {
            handler.setFormatter(new AILogFormatter());
        }
        this.logger.setUseParentHandlers(false);
    }

    public void Flush() {
        for (Handler handler : this.logger.getHandlers()) {
            handler.flush();
        }
    }

    public void WriteLine(Object object) {
        this.logger.info("" + object);
        if (this.AutoFlushOn) {
            this.Flush();
        }
    }

    public void writeLine(Object object) {
        this.WriteLine(object);
    }

    public void writeStackTrace(Exception exception) {
        String string = Formatting.exceptionToStackTrace(exception);
        this.WriteLine(string);
    }

    public void Shutdown() {
        this.Flush();
        LogManager.getLogManager().reset();
    }

    static class StdInfoHandler
    extends ConsoleHandler {
        public StdInfoHandler() {
            this.setOutputStream(System.out);
        }
    }

    private class AILogFormatter
    extends Formatter {
        private AILogFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LogFile.this.playerObjects.getTimeHelper().GetCurrentGameTimeString());
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getLevel().getName());
            stringBuffer.append(": ");
            stringBuffer.append(this.formatMessage(logRecord));
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

