/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;

public abstract class StdNodeBasedDeserializer<T>
extends StdDeserializer<T> {
    protected ValueDeserializer<Object> _treeDeserializer;

    protected StdNodeBasedDeserializer(JavaType targetType) {
        super(targetType);
    }

    protected StdNodeBasedDeserializer(Class<T> targetType) {
        super(targetType);
    }

    protected StdNodeBasedDeserializer(StdNodeBasedDeserializer<?> src) {
        super(src);
        this._treeDeserializer = src._treeDeserializer;
    }

    @Override
    public void resolve(DeserializationContext ctxt) {
        this._treeDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(JsonNode.class));
    }

    public abstract T convert(JsonNode var1, DeserializationContext var2) throws JacksonException;

    public T convert(JsonNode root, DeserializationContext ctxt, T newValue) throws JacksonException {
        ctxt.handleBadMerge(this);
        return this.convert(root, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonNode n = (JsonNode)this._treeDeserializer.deserialize(p, ctxt);
        return this.convert(n, ctxt);
    }

    @Override
    public T deserialize(JsonParser jp, DeserializationContext ctxt, T newValue) throws JacksonException {
        JsonNode n = (JsonNode)this._treeDeserializer.deserialize(jp, ctxt);
        return this.convert(n, ctxt, newValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer td) throws JacksonException {
        JsonNode n = (JsonNode)this._treeDeserializer.deserializeWithType(p, ctxt, td);
        return this.convert(n, ctxt);
    }
}

