/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.jndi.JndiAttrs;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.EZConnectResolver;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class AddrResolution {
    static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))";
    static final String CID_FORMAT = "(CID=(PROGRAM=%s)(HOST=__jdbc__)(USER=%s))";
    static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s)";
    static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s)";
    static final String SERVERMODE_FORMAT = "(SERVER=%s)";
    static final String EMPTY_STRING = "";
    static final String SID_KEY = "(SID=%s)";
    static final String SERVICE_NAME_KEY = "(SERVICE_NAME=%s)";
    private ConnStrategy cs;
    private Stack<ConnStrategy> connStrategyStack;
    private static final int MAX_CONNECTION_STRATEGY_COUNT = 20;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    static final List<String> SERVER_MODES;
    private boolean newSyntax;
    public boolean connection_revised;
    public boolean connection_redirected;
    private String TNSAddress;
    private final SSLContext sslContext;
    private final OracleHostnameResolver hostnameResolver;
    public String redirectConnectData;
    private static final boolean DEBUG = false;
    private static final Pattern HOST_INFO_PATTERN;
    private static final Pattern EZ_URL_PATTERN;
    private static final Pattern TNS_NAME_URL_PATTERN;
    private final SecuredLogger securedLogger;
    private static final Pattern pattern;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public AddrResolution(String TNSdesc, @Blind(value=PropertiesBlinder.class) Properties _up) throws NetException {
        this(TNSdesc, _up, null, null, SecuredLogger.noOpLogger());
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, AddrResolution.class, $$$methodRef$$$31, null, TNSdesc, TraceControllerImpl.blind(PropertiesBlinder.class, _up));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, AddrResolution.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AddrResolution.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AddrResolution.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String TNSdesc, @Blind(value=PropertiesBlinder.class) Properties _up, SSLContext sslContext, OracleHostnameResolver hostnameResolver, SecuredLogger securedLogger) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String prop;
            block14: {
                Vector<String> ldapUrlList;
                block15: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null, TNSdesc, TraceControllerImpl.blind(PropertiesBlinder.class, _up), sslContext, hostnameResolver, securedLogger);
                    }
                    this.cs = null;
                    this.connStrategyStack = new Stack();
                    this.newSyntax = true;
                    this.connection_revised = false;
                    this.connection_redirected = false;
                    this.securedLogger = securedLogger;
                    this.up = _up;
                    this.TNSAddress = TNSdesc;
                    if (!TNSdesc.startsWith("ldap:") && !TNSdesc.startsWith("ldaps:")) break block14;
                    boolean isLdapUrlList = false;
                    ldapUrlList = null;
                    if (TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
                        ldapUrlList = this.computeLdapList(TNSdesc);
                        if (ldapUrlList.size() > 1) {
                            isLdapUrlList = true;
                        } else {
                            int pos = TNSdesc.lastIndexOf(47);
                            if (pos == -1) {
                                NetException netException = new NetException(124);
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null, netException);
                                }
                                throw netException;
                            }
                            this.up.put("java.naming.provider.url", TNSdesc.substring(0, pos));
                            this.TNSAddress = TNSdesc.substring(pos + 1, TNSdesc.length());
                        }
                    }
                    if (isLdapUrlList) break block15;
                    String[] attrname = new String[1];
                    JndiAttrs ja = new JndiAttrs(this.up);
                    attrname[0] = service_attr_name;
                    Vector _service = null;
                    try {
                        _service = ja.getAttrs(this.TNSAddress, attrname);
                    }
                    catch (Throwable throwable) {
                        ja.close();
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null, throwable2);
                        }
                        throw throwable2;
                    }
                    ja.close();
                    this.TNSAddress = (String)_service.firstElement();
                    this.connection_revised = true;
                    break block14;
                }
                this.processLdapFailoverLoadblance(ldapUrlList);
            }
            if ((prop = this.up.getProperty("oracle.net.oldSyntax")) != null && (prop.equalsIgnoreCase("ON") || prop.equalsIgnoreCase("TRUE") || prop.equalsIgnoreCase("YES"))) {
                this.newSyntax = false;
            }
            this.sslContext = sslContext;
            this.hostnameResolver = hostnameResolver;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, AddrResolution.class, $$$methodRef$$$32, null, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Vector<String> computeLdapList(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tnsDesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, AddrResolution.class, $$$methodRef$$$0, this, string);
            }
            String[] ldapUrlS = pattern.split((CharSequence)tnsDesc);
            int nonEmptyLdapUrlsCount = 0;
            for (int i2 = 0; i2 < ldapUrlS.length; ++i2) {
                ldapUrlS[i2] = ldapUrlS[i2].trim();
                if (ldapUrlS[i2].length() == 0) continue;
                ++nonEmptyLdapUrlsCount;
            }
            Vector<String> ret = new Vector<String>(nonEmptyLdapUrlsCount);
            for (int i3 = 0; i3 < ldapUrlS.length; ++i3) {
                if (ldapUrlS[i3].length() == 0) continue;
                ret.add(ldapUrlS[i3]);
            }
            Vector<String> vector = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, AddrResolution.class, $$$methodRef$$$0, this, vector);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AddrResolution.class, $$$methodRef$$$0, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AddrResolution.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(Vector<String> vector) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            Vector urlList;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, vector);
            }
            boolean urlStart = false;
            if (urlList.size() <= 1) {
                NetException netException = new NetException(124);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, netException);
                }
                throw netException;
            }
            boolean ldapFailover = true;
            boolean ldapLoadbalance = true;
            String prop = this.up.getProperty("oracle.net.ldap_failover");
            if (prop != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
                ldapFailover = false;
            }
            if ((prop = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
                ldapLoadbalance = false;
            }
            if (urlList.size() > 1) {
                urlList = NavDescriptionList.setActiveChildren(urlList, ldapFailover, ldapLoadbalance);
            }
            StringBuilder sbJndiUrlList = new StringBuilder();
            int listSize = urlList.size();
            Hashtable<String, String> tabMapUrlToTns = new Hashtable<String, String>(listSize);
            for (int i2 = 0; i2 < listSize; ++i2) {
                String url = (String)urlList.elementAt(i2);
                int pos = url.lastIndexOf(47);
                if (pos == -1) {
                    NetException netException = new NetException(124);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, netException);
                    }
                    throw netException;
                }
                String jndiUrl = url.substring(0, pos);
                String tnsAddr = url.substring(pos + 1, url.length());
                sbJndiUrlList.append(jndiUrl);
                if (i2 < listSize - 1) {
                    sbJndiUrlList.append(' ');
                }
                tabMapUrlToTns.put(jndiUrl.substring(jndiUrl.indexOf(47)), tnsAddr);
            }
            String jndiUrlList = new String(sbJndiUrlList);
            this.up.put("java.naming.provider.url", jndiUrlList);
            JndiAttrs ja = new JndiAttrs(this.up);
            String ldapUlrConnected = ja.getLdapUrlUsed();
            this.TNSAddress = (String)tabMapUrlToTns.get(ldapUlrConnected.substring(ldapUlrConnected.indexOf(47)));
            Vector serviceList = null;
            String[] attrNames = new String[]{service_attr_name};
            try {
                serviceList = ja.getAttrs(this.TNSAddress, attrNames);
            }
            catch (Throwable throwable) {
                ja.close();
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable2;
            }
            ja.close();
            this.TNSAddress = (String)serviceList.firstElement();
            this.connection_revised = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AddrResolution.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    public String getTNSAddressInUpperCase() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, AddrResolution.class, $$$methodRef$$$2, this, new Object[0]);
            }
            String string = this.TNSAddress.toUpperCase();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, AddrResolution.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AddrResolution.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AddrResolution.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getTNSAddress() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, AddrResolution.class, $$$methodRef$$$3, this, new Object[0]);
            }
            String string = this.TNSAddress;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, AddrResolution.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AddrResolution.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AddrResolution.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initConnStrategy(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void TNSdesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, AddrResolution.class, $$$methodRef$$$4, this, string);
            }
            ConnStrategy orig_cs = this.cs;
            this.cs = new ConnStrategy(this.up, this.sslContext, this.hostnameResolver, this.securedLogger);
            if (this.connection_redirected) {
                this.configureConnStrategyAfterRedirect(orig_cs);
            }
            if (orig_cs != null) {
                this.connStrategyStack.push(orig_cs);
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$4, Level.INFO, this.getClass(), $$$methodRef$$$4, "Connection strategy " + orig_cs.toString() + " stored in stack, conn strategy updated to new conn strategy: " + this.cs.toString());
                }
            }
            this.resolveTNSAddress((String)TNSdesc);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, AddrResolution.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AddrResolution.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AddrResolution.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnOption resolveAndExecute(String string, DMSFactory.DMSNoun dMSNoun) throws NetException, IOException, InterruptedIOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dmsParent;
            void TNSdesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, AddrResolution.class, $$$methodRef$$$5, this, string, dMSNoun);
            }
            ConnOption connOption = this.resolveAndExecute((String)TNSdesc, false, (DMSFactory.DMSNoun)dmsParent);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, AddrResolution.class, $$$methodRef$$$5, this, connOption);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AddrResolution.class, $$$methodRef$$$5, this, null);
            }
            return connOption;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AddrResolution.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnOption resolveAndExecute(String string, boolean bl, DMSFactory.DMSNoun dMSNoun) throws NetException, IOException, InterruptedIOException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void TNSdesc;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, string, bl, dMSNoun);
            }
            if (TNSdesc != null && this.connStrategyStack.size() < 20) {
                this.initConnStrategy((String)TNSdesc);
            } else if (this.cs == null) {
                ConnOption connOption = null;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, connOption);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            ConnOption cOption = null;
            do {
                try {
                    void dmsParent;
                    void startNewOCTOInterruptTask;
                    cOption = null;
                    cOption = this.cs.execute((boolean)startNewOCTOInterruptTask, (DMSFactory.DMSNoun)dmsParent);
                }
                catch (NetException e2) {
                    if (this.connection_redirected && !this.connStrategyStack.empty()) {
                        if (bl2) {
                            OracleLog.debug($$$loggerRef$$$6, Level.INFO, this.getClass(), $$$methodRef$$$6, "Connection establishment with conn strategy: " + this.cs.toString() + " failed, trying previous conn strategy from stack");
                        }
                        this.cs = this.connStrategyStack.pop();
                        continue;
                    }
                    NetException netException = e2;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, netException);
                    }
                    throw netException;
                }
            } while (cOption == null);
            ConnOption connOption = cOption;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, connOption);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, null);
            }
            return connOption;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AddrResolution.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final CompletionStage<ConnOption> resolveAndExecuteAsync(String string, boolean bl, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void asyncExecutor;
            void outboundTimeoutHandler;
            void dmsParent;
            void startNewOCTOInterruptTask;
            void TNSdesc;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, string, bl, dMSNoun, asyncOutboundTimeoutHandler, executor);
            }
            if (TNSdesc != null) {
                try {
                    this.initConnStrategy((String)TNSdesc);
                }
                catch (NetException resolutionFailure) {
                    CompletionStage<ConnOption> completionStage = CompletionStageUtil.failedStage(resolutionFailure);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, null);
                    }
                    return completionStage;
                }
            } else if (this.cs == null) {
                CompletionStage<Object> completionStage = CompletionStageUtil.completedStage(null);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, null);
                }
                return completionStage;
            }
            CompletionStage<ConnOption> completionStage = this.cs.executeAsync((boolean)startNewOCTOInterruptTask, (DMSFactory.DMSNoun)dmsParent, (AsyncOutboundTimeoutHandler)outboundTimeoutHandler, (Executor)asyncExecutor);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AddrResolution.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureConnStrategyAfterRedirect(ConnStrategy connStrategy) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void redirectedConnStrategy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, AddrResolution.class, $$$methodRef$$$8, this, connStrategy);
            }
            this.cs.sdu = redirectedConnStrategy.sdu;
            this.cs.tdu = redirectedConnStrategy.tdu;
            this.cs.retryCount = redirectedConnStrategy.retryCount;
            this.cs.socketOptions = redirectedConnStrategy.socketOptions;
            this.cs.reuseOpt = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, AddrResolution.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AddrResolution.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AddrResolution.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void resolveTNSAddress(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String TNSdesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, AddrResolution.class, $$$methodRef$$$9, this, string);
            }
            if ((TNSdesc = TNSdesc.trim()).indexOf(41) == -1 || TNSdesc.indexOf(40) != 0) {
                if (TNSdesc.startsWith("//") || TNSdesc.matches("[\\w[.+*?!/;%@a~#'$&:|^()<>\\-\\\\\\\"]]*") && !TNSdesc.matches("[[\\w-]\\.]*:[\\d]*:[+]?+[[\\w\\$\\#-]\\.]*(?i)(:[\\w]*)?(?-i)") || TNSdesc.matches("[\\[[\\w:]*\\]]") || TNSdesc.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:[\\w]*)?(?-i)")) {
                    String tnsAdmin = this.up.getProperty("oracle.net.tns_admin");
                    NameResolver nr = NameResolverFactory.getNameResolver(tnsAdmin, this.cs.getOSUsername(), this.cs.getProgramName());
                    TNSdesc = TNSdesc.replaceAll("#", "\\\\#");
                    TNSdesc = TNSdesc.replaceAll("\\(", "\\\\(");
                    TNSdesc = TNSdesc.replaceAll("\\)", "\\\\)");
                    this.TNSAddress = nr.resolveName(TNSdesc);
                    if (this.TNSAddress.indexOf(41) == -1 || this.TNSAddress.indexOf(40) != 0) {
                        EZConnectResolver resolver = EZConnectResolver.newInstance(this.TNSAddress);
                        this.TNSAddress = resolver.getResolvedUrl();
                    }
                } else {
                    this.TNSAddress = this.resolveSimple(TNSdesc);
                }
                this.TNSAddress = this.addConnectionProperties(this.TNSAddress);
                this.resolveAddrTree(this.TNSAddress);
            } else if (this.newSyntax) {
                TNSdesc = this.addConnectionProperties(TNSdesc);
                this.resolveAddrTree(TNSdesc);
            } else {
                this.resolveAddr(TNSdesc);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, AddrResolution.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AddrResolution.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AddrResolution.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String addConnectionProperties(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String isAllowReadOnly;
            void TNSdesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, AddrResolution.class, $$$methodRef$$$10, this, string);
            }
            String newTNSdesc = TNSdesc;
            if (this.up.containsKey("oracle.jdbc.targetInstanceName")) {
                newTNSdesc = this.appendInstanceName((String)TNSdesc, this.up.getProperty("oracle.jdbc.targetInstanceName"));
            }
            if (this.up.containsKey("oracle.jdbc.targetServiceName")) {
                newTNSdesc = AddrResolution.replaceServiceName(newTNSdesc, this.up.getProperty("oracle.jdbc.targetServiceName"));
            }
            if (this.up.containsKey("oracle.jdbc.targetShardingKey")) {
                String superShardingKey = null;
                if (this.up.containsKey("oracle.jdbc.targetSuperShardingKey")) {
                    superShardingKey = this.up.getProperty("oracle.jdbc.targetSuperShardingKey");
                }
                newTNSdesc = this.appendShardKeys(newTNSdesc, this.up.getProperty("oracle.jdbc.targetShardingKey"), superShardingKey);
            }
            if (this.up.containsKey("oracle.jdbc.readOnlyInstanceAllowed") && "true".equalsIgnoreCase(isAllowReadOnly = this.up.getProperty("oracle.jdbc.readOnlyInstanceAllowed"))) {
                newTNSdesc = this.appendReadOnly(newTNSdesc);
            }
            String string2 = newTNSdesc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, AddrResolution.class, $$$methodRef$$$10, this, string2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AddrResolution.class, $$$methodRef$$$10, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AddrResolution.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String resolveSimple(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string2;
            block18: {
                void TNSdesc;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, string);
                }
                ConnOption co = new ConnOption();
                int fColon = 0;
                int sColon = 0;
                boolean tColon = false;
                int eColon = 0;
                int initialIndex = 0;
                boolean isIPV6Literal = false;
                boolean isServerModePresent = false;
                String serverMode = EMPTY_STRING;
                if (TNSdesc.startsWith("[")) {
                    initialIndex = TNSdesc.indexOf(93);
                    if (initialIndex == -1) {
                        NetException netException = new NetException(115);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, netException);
                        }
                        throw netException;
                    }
                    isIPV6Literal = true;
                }
                if ((fColon = TNSdesc.indexOf(58, initialIndex)) == -1 || (sColon = TNSdesc.indexOf(58, fColon + 1)) == -1) {
                    NetException netException = new NetException(115);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, netException);
                    }
                    throw netException;
                }
                eColon = TNSdesc.indexOf(58, sColon + 1);
                if (eColon != -1 && TNSdesc.length() > eColon + 6) {
                    serverMode = TNSdesc.substring(eColon + 1);
                    isServerModePresent = SERVER_MODES.contains(serverMode.toUpperCase());
                    if (isServerModePresent) {
                        co.sid = TNSdesc.substring(sColon + 1, eColon);
                        eColon = TNSdesc.indexOf(58, eColon + 1);
                    } else {
                        co.sid = TNSdesc.substring(sColon + 1);
                    }
                } else {
                    co.sid = TNSdesc.substring(sColon + 1);
                }
                if (eColon != -1) {
                    NetException netException = new NetException(115);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, netException);
                    }
                    throw netException;
                }
                try {
                    co.host = isIPV6Literal ? TNSdesc.substring(1, fColon - 1) : TNSdesc.substring(0, fColon);
                    co.port = Integer.parseInt(TNSdesc.substring(fColon + 1, sColon));
                    co.addr = String.format(ADDRESS_FORMAT, DEFAULT_CONNECT_PROTOCOL, co.host, co.port);
                    co.conn_data.append(String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, co.sid), isServerModePresent ? String.format(SERVERMODE_FORMAT, serverMode) : EMPTY_STRING, String.format(CID_FORMAT, this.cs.getProgramName(), this.cs.getOSUsername())), co.addr));
                    co.protocol = DEFAULT_CONNECT_PROTOCOL;
                    ConnectDescription desc = this.cs.newConnectDescription();
                    this.cs.currentDescription().addConnectOption(co);
                    this.cs.closeDescription();
                    string2 = String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, co.sid), isServerModePresent ? String.format(SERVERMODE_FORMAT, serverMode) : EMPTY_STRING, EMPTY_STRING), co.addr);
                    if (!bl) break block18;
                }
                catch (NumberFormatException nfe) {
                    NetException netException = new NetException(116);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, netException);
                    }
                    throw netException;
                }
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, string2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AddrResolution.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    private void resolveAddr(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String TNSdesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, string);
            }
            if (TNSdesc.startsWith("alias=")) {
                void desc = TNSdesc;
                TNSdesc = desc.substring(desc.indexOf("alias=") + 6, desc.length());
            }
            ConnOption co = new ConnOption();
            NVFactory nvf = new NVFactory();
            NVNavigator nvn = new NVNavigator();
            NVPair cid = null;
            NVPair addr = null;
            try {
                cid = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "CID");
                addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "address");
            }
            catch (NLException exp) {
                NetException ne = new NetException(101);
                ne.initCause(exp);
                NetException netException = ne;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            NVPair cnvp = nvn.findNVPair(addr, "protocol");
            if (cnvp == null) {
                NetException netException = new NetException(100);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            co.protocol = cnvp.getAtom();
            if (!(co.protocol.equals(DEFAULT_CONNECT_PROTOCOL) || co.protocol.equals("tcp") || co.protocol.equals("SSL") || co.protocol.equals("ssl") || co.protocol.equals("ANO") || co.protocol.equals("ano"))) {
                NetException netException = new NetException(102);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            cnvp = nvn.findNVPair(addr, "Host");
            if (cnvp == null) {
                NetException netException = new NetException(103);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            co.host = cnvp.getAtom();
            cnvp = nvn.findNVPair(addr, "Port");
            if (cnvp == null) {
                NetException netException = new NetException(104);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            co.port = Integer.parseInt(cnvp.getAtom());
            cnvp = nvn.findNVPair(addr, "sduSize");
            if (cnvp != null) {
                co.sdu = Integer.parseInt(cnvp.getAtom());
            }
            if ((cnvp = nvn.findNVPair(addr, "tduSize")) != null) {
                co.tdu = Integer.parseInt(cnvp.getAtom());
            }
            NVPair cdata = null;
            try {
                cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "connect_data");
            }
            catch (NLException exp) {
                NetException ne = new NetException(101);
                ne.initCause(exp);
                NetException netException = ne;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, netException);
                }
                throw netException;
            }
            co.conn_data = cdata != null ? this.insertCID(TNSdesc) : new StringBuilder(TNSdesc);
            co.addr = String.format(ADDRESS_FORMAT, DEFAULT_CONNECT_PROTOCOL, co.host, co.port);
            ConnectDescription desc = this.cs.newConnectDescription();
            this.cs.currentDescription().addConnectOption(co);
            this.cs.closeDescription();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AddrResolution.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resolveAddrTree(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this, string);
            }
            NavSchemaObjectFactory fac = new NavSchemaObjectFactory();
            NavServiceAlias sa = (NavServiceAlias)fac.create(4);
            try {
                void TNSdesc;
                String alias = TNSdesc.startsWith("alias=") ? TNSdesc : "alias=" + (String)TNSdesc;
                sa.initFromString(alias);
            }
            catch (NLException nle) {
                NetException netException = new NetException(501, nle.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this, netException);
                }
                throw netException;
            }
            catch (SOException soe) {
                NetException netException = new NetException(502, soe.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this, netException);
                }
                throw netException;
            }
            sa.navigate(this.cs, null);
            if (this.connection_redirected && this.redirectConnectData != null) {
                for (int i2 = 0; i2 < this.cs.getAllDescriptions().size(); ++i2) {
                    ConnectDescription desc = this.cs.getAllDescriptions().get(i2);
                    desc.getConnectOptions().forEach(connOption -> {
                        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
                        try {
                            if (bl) {
                                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, AddrResolution.class, $$$methodRef$$$30, this, connOption);
                            }
                            o.conn_data = new StringBuilder(this.redirectConnectData);
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, AddrResolution.class, $$$methodRef$$$30, this);
                                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AddrResolution.class, $$$methodRef$$$30, this, null);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (bl) {
                                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AddrResolution.class, $$$methodRef$$$30, this, throwable2);
                            }
                            throw throwable;
                        }
                    });
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AddrResolution.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder insertCID(String string) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, string);
            }
            NVFactory nvf = new NVFactory();
            NVNavigator nvn = new NVNavigator();
            StringBuilder tns = new StringBuilder(2048);
            NVPair desc = null;
            NVPair addrl = null;
            NVPair addr = null;
            NVPair cdata = null;
            NVPair sroute = null;
            try {
                void TNSaddr;
                desc = nvn.findNVPairRecurse(nvf.createNVPair((String)TNSaddr), "description");
                addrl = nvn.findNVPairRecurse(nvf.createNVPair((String)TNSaddr), "address_list");
                addr = nvn.findNVPairRecurse(nvf.createNVPair((String)TNSaddr), "address");
                cdata = nvn.findNVPairRecurse(nvf.createNVPair((String)TNSaddr), "connect_data");
                sroute = nvn.findNVPairRecurse(nvf.createNVPair((String)TNSaddr), "source_route");
            }
            catch (NLException exp) {
                NetException ne = new NetException(101);
                ne.initCause(exp);
                NetException netException = ne;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, netException);
                }
                throw netException;
            }
            NVPair sid = null;
            NVPair cid = null;
            NVPair sn = null;
            NVPair server = null;
            if (cdata == null) {
                NetException netException = new NetException(105);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, netException);
                }
                throw netException;
            }
            sid = nvn.findNVPair(cdata, "SID");
            cid = nvn.findNVPair(cdata, "CID");
            sn = nvn.findNVPair(cdata, "SERVICE_NAME");
            server = nvn.findNVPair(cdata, "SERVER");
            if (sid == null && sn == null) {
                NetException netException = new NetException(106);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, netException);
                }
                throw netException;
            }
            tns.append("(DESCRIPTION=");
            if (addrl != null && addrl.getListSize() > 0) {
                for (int i2 = 0; i2 < addrl.getListSize(); ++i2) {
                    NVPair nvp = addrl.getListElement(i2);
                    tns.append(nvp.toString());
                }
            } else if (addr != null) {
                tns.append(addr.toString());
            } else {
                NetException netException = new NetException(107);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, netException);
                }
                throw netException;
            }
            tns.append(String.format(CONNECT_DATA_FORMAT, (sn != null ? sn : sid).toString(), server != null ? server.toString() : EMPTY_STRING, String.format(CID_FORMAT, this.cs.getProgramName(), this.cs.getOSUsername())));
            if (sroute != null) {
                tns.append(sroute.toString());
            }
            tns.append(")");
            StringBuilder stringBuilder = tns;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, stringBuilder);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, null);
            }
            return stringBuilder;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AddrResolution.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getRedirectConnectData() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, AddrResolution.class, $$$methodRef$$$15, this, new Object[0]);
            }
            String string = this.redirectConnectData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, AddrResolution.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AddrResolution.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AddrResolution.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRedirectConnectData(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void redirectConnectData;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, AddrResolution.class, $$$methodRef$$$16, this, string);
            }
            this.redirectConnectData = redirectConnectData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, AddrResolution.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AddrResolution.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AddrResolution.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getUp() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, AddrResolution.class, $$$methodRef$$$17, this, new Object[0]);
            }
            Properties properties = this.up;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, AddrResolution.class, $$$methodRef$$$17, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AddrResolution.class, $$$methodRef$$$17, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AddrResolution.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getSocketOptions() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, AddrResolution.class, $$$methodRef$$$18, this, new Object[0]);
            }
            Properties properties = this.cs.socketOptions;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, AddrResolution.class, $$$methodRef$$$18, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AddrResolution.class, $$$methodRef$$$18, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AddrResolution.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, AddrResolution.class, $$$methodRef$$$19, this, new Object[0]);
            }
            boolean bl2 = this.cs.isConnectionSocketKeepAlive();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, AddrResolution.class, $$$methodRef$$$19, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AddrResolution.class, $$$methodRef$$$19, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AddrResolution.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String appendInstanceName(String string, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void TNSDesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, AddrResolution.class, $$$methodRef$$$20, this, string, string2);
            }
            Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
            Matcher matcher = pattern.matcher((CharSequence)TNSDesc);
            StringBuffer sb = new StringBuffer();
            boolean result = matcher.find();
            while (result) {
                void instanceName;
                matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + "(INSTANCE_NAME=" + (String)instanceName + ")"));
                result = matcher.find();
            }
            matcher.appendTail(sb);
            String string3 = sb.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, AddrResolution.class, $$$methodRef$$$20, this, string3);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AddrResolution.class, $$$methodRef$$$20, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AddrResolution.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String replaceServiceName(String string, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String TNSDesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, AddrResolution.class, $$$methodRef$$$21, null, string, string2);
            }
            Pattern pattern = Pattern.compile("\\([\\s]*SERVICE_NAME[\\s]*=([^)]+)\\)", 2);
            Matcher matcher = pattern.matcher(TNSDesc);
            StringBuffer sb = new StringBuffer();
            boolean result = matcher.find();
            while (result) {
                void newServiceName;
                matcher.appendReplacement(sb, Matcher.quoteReplacement("(SERVICE_NAME=" + (String)newServiceName + ")"));
                result = matcher.find();
            }
            matcher.appendTail(sb);
            String string3 = sb.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, AddrResolution.class, $$$methodRef$$$21, null, string3);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AddrResolution.class, $$$methodRef$$$21, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AddrResolution.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceServiceNameInUrl(String string, String string2, String string3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void catalogServiceName;
            String url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, string, string2, string3);
            }
            if (url.toUpperCase().contains("DESCRIPTION")) {
                String string4 = AddrResolution.replaceServiceName(url, (String)catalogServiceName);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, string4);
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, null);
                }
                return string4;
            }
            String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
            Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
            if (matcher.find()) {
                StringBuffer sb = new StringBuffer();
                int startIndex = matcher.start("servicename");
                int endIndex = matcher.end("servicename");
                sb.append(url.substring(0, startIndex));
                sb.append((String)catalogServiceName);
                if (endIndex != -1) {
                    sb.append(url.substring(endIndex));
                }
                String string5 = sb.toString();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, string5);
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, null);
                }
                return string5;
            }
            String string6 = url;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, string6);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, null);
            }
            return string6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AddrResolution.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    public static String getServiceName(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string2;
            String url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, string);
            }
            if (url.toUpperCase().contains("DESCRIPTION")) {
                String string3;
                Pattern pattern = Pattern.compile("(.*)\\([\\s]*SERVICE_NAME[\\s]*=([^)]+)\\)", 2);
                Matcher matcher = pattern.matcher(url);
                boolean result = matcher.find();
                String string4 = string3 = result ? matcher.group(2) : null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, null);
                }
                return string4;
            }
            String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
            Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
            String string5 = string2 = matcher.matches() ? matcher.group("servicename") : null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, string2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, null);
            }
            return string5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AddrResolution.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String resolveTNSAlias(String string, @Blind(value=PropertiesBlinder.class) Properties properties, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tnsAdmin;
            String aliasName;
            String url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, AddrResolution.class, $$$methodRef$$$24, null, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string2);
            }
            String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
            String newUrl = null;
            Matcher matcher = TNS_NAME_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
            if (matcher.matches() && (aliasName = matcher.group("tnsalias")) != null && tnsAdmin != null) {
                try {
                    void up;
                    String osuser = up.getProperty("oracle.jdbc.v$session.osuser");
                    String programName = up.getProperty("oracle.jdbc.v$session.program");
                    NameResolver nr = NameResolverFactory.getNameResolver((String)tnsAdmin, osuser, programName);
                    aliasName = aliasName.trim();
                    String aliasVal = nr.resolveName(aliasName);
                    int startIndex = matcher.start("tnsalias");
                    if (startIndex != -1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(url.substring(0, startIndex));
                        sb.append(aliasVal);
                        newUrl = sb.toString();
                    }
                }
                catch (NetException netException) {
                    // empty catch block
                }
            }
            String string3 = newUrl;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, AddrResolution.class, $$$methodRef$$$24, null, string3);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AddrResolution.class, $$$methodRef$$$24, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AddrResolution.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String appendShardKeys(String string, String string2, String string3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void TNSDesc;
            void superShardingKey;
            void shardingKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, AddrResolution.class, $$$methodRef$$$25, this, string, string2, string3);
            }
            Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
            String shardingKeyStr = (String)(shardingKey != null ? "(SHARDING_KEY_B64=" + (String)shardingKey + ")" : EMPTY_STRING) + (String)(superShardingKey != null ? "(SUPER_SHARDING_KEY_B64=" + (String)superShardingKey + ")" : EMPTY_STRING);
            Matcher matcher = pattern.matcher((CharSequence)TNSDesc);
            StringBuffer sb = new StringBuffer();
            boolean result = matcher.find();
            while (result) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + shardingKeyStr));
                result = matcher.find();
            }
            matcher.appendTail(sb);
            String string4 = sb.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, AddrResolution.class, $$$methodRef$$$25, this, string4);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AddrResolution.class, $$$methodRef$$$25, this, null);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AddrResolution.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String appendReadOnly(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void TNSDesc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, AddrResolution.class, $$$methodRef$$$26, this, string);
            }
            Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
            String readonlyTag = "(READONLY_OK=true)";
            Matcher matcher = pattern.matcher((CharSequence)TNSDesc);
            StringBuffer sb = new StringBuffer();
            boolean result = matcher.find();
            while (result) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + "(READONLY_OK=true)"));
                result = matcher.find();
            }
            matcher.appendTail(sb);
            String string2 = sb.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, AddrResolution.class, $$$methodRef$$$26, this, string2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AddrResolution.class, $$$methodRef$$$26, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AddrResolution.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    public ConnStrategy getConnStrategy() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, AddrResolution.class, $$$methodRef$$$27, this, new Object[0]);
            }
            ConnStrategy connStrategy = this.cs;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, AddrResolution.class, $$$methodRef$$$27, this, connStrategy);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AddrResolution.class, $$$methodRef$$$27, this, null);
            }
            return connStrategy;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AddrResolution.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isUsingCustomHostnameResolver() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, AddrResolution.class, $$$methodRef$$$28, this, new Object[0]);
            }
            boolean bl2 = this.cs.isUsingCustomHostnameResolver();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, AddrResolution.class, $$$methodRef$$$28, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AddrResolution.class, $$$methodRef$$$28, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AddrResolution.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    public void clearConnStrategyStack() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, AddrResolution.class, $$$methodRef$$$29, this, new Object[0]);
            }
            this.connStrategyStack.clear();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, AddrResolution.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AddrResolution.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AddrResolution.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$32 = AddrResolution.class.getDeclaredConstructor(String.class, Properties.class, SSLContext.class, OracleHostnameResolver.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$31 = AddrResolution.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$30 = AddrResolution.class.getDeclaredMethod("lambda$resolveAddrTree$0", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$29 = AddrResolution.class.getDeclaredMethod("clearConnStrategyStack", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$28 = AddrResolution.class.getDeclaredMethod("isUsingCustomHostnameResolver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$27 = AddrResolution.class.getDeclaredMethod("getConnStrategy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$26 = AddrResolution.class.getDeclaredMethod("appendReadOnly", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$25 = AddrResolution.class.getDeclaredMethod("appendShardKeys", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$24 = AddrResolution.class.getDeclaredMethod("resolveTNSAlias", String.class, Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$23 = AddrResolution.class.getDeclaredMethod("getServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$22 = AddrResolution.class.getDeclaredMethod("replaceServiceNameInUrl", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$21 = AddrResolution.class.getDeclaredMethod("replaceServiceName", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$20 = AddrResolution.class.getDeclaredMethod("appendInstanceName", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$19 = AddrResolution.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$18 = AddrResolution.class.getDeclaredMethod("getSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$17 = AddrResolution.class.getDeclaredMethod("getUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$16 = AddrResolution.class.getDeclaredMethod("setRedirectConnectData", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$15 = AddrResolution.class.getDeclaredMethod("getRedirectConnectData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$14 = AddrResolution.class.getDeclaredMethod("insertCID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = AddrResolution.class.getDeclaredMethod("resolveAddrTree", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = AddrResolution.class.getDeclaredMethod("resolveAddr", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = AddrResolution.class.getDeclaredMethod("resolveSimple", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = AddrResolution.class.getDeclaredMethod("addConnectionProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = AddrResolution.class.getDeclaredMethod("resolveTNSAddress", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = AddrResolution.class.getDeclaredMethod("configureConnStrategyAfterRedirect", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = AddrResolution.class.getDeclaredMethod("resolveAndExecuteAsync", String.class, Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = AddrResolution.class.getDeclaredMethod("resolveAndExecute", String.class, Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = AddrResolution.class.getDeclaredMethod("resolveAndExecute", String.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = AddrResolution.class.getDeclaredMethod("initConnStrategy", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = AddrResolution.class.getDeclaredMethod("getTNSAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = AddrResolution.class.getDeclaredMethod("getTNSAddressInUpperCase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = AddrResolution.class.getDeclaredMethod("processLdapFailoverLoadblance", Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = AddrResolution.class.getDeclaredMethod("computeLdapList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        SERVER_MODES = Arrays.asList("SHARED", "DEDICATED", "POOLED");
        HOST_INFO_PATTERN = Pattern.compile("(?<hostnames>([A-z0-9][A-z0-9._-]+,?)+)(:(?<port>\\d+))?");
        EZ_URL_PATTERN = Pattern.compile("(.*)@(//)?(?<hostinfo>(" + HOST_INFO_PATTERN.pattern() + ")+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?", 2);
        TNS_NAME_URL_PATTERN = Pattern.compile("(.*)@(?<tnsalias>[A-z][A-z0-9,-.]+)");
        pattern = Pattern.compile("(?=ldaps?://)");
    }
}

