/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.AdditionalDatabaseMetaData;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={DatabaseMetaData.class, ParameterMetaData.class, ResultSetMetaData.class, RowId.class, SQLData.class, SQLInput.class, SQLXML.class, AdditionalDatabaseMetaData.class, OracleParameterMetaData.class, OracleResultSetMetaData.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, oracle.jdbc.internal.OracleResultSetMetaData.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableBase
implements Replayable,
InvocationHandler,
Monitor {
    protected FailoverManagerImpl failoverMngr;
    protected FailoverManagerImpl.CallHistoryEntry headSameProxy;
    protected FailoverManagerImpl.CallHistoryEntry tailSameProxy;
    protected FailoverManagerImpl.CallHistoryEntry replayingCallEntry;
    protected SQLRecoverableException originalError;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE1 = 603;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE2 = 29791;
    protected boolean isClosedAndNoReplay;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    public NonTxnReplayableBase() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$18, null, new Object[0]);
            }
            this.headSameProxy = null;
            this.tailSameProxy = null;
            this.replayingCallEntry = null;
            this.originalError = null;
            this.isClosedAndNoReplay = false;
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$0, this, method, object, objectArray);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    void args;
                    void m2;
                    this.failoverMngr.record(this, (Method)m2, (Object[])args, "started");
                    break;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$1, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$2, this, method, object);
            }
            if (result instanceof NonTxnReplayableBase) {
                NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
                jdbcProxy.setFailoverManager(this.getFailoverManager());
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecording((Method)m2, result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplaying((Method)m2, result, null);
                }
            }
            void var5_5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$2, this, var5_5);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$2, this, null);
            }
            return var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPostWhenRecording(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlexc;
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$3, this, method, object, sQLException);
            }
            long checksum = 0L;
            long SCN = -1L;
            this.failoverMngr.update(this, null, result, "completed", 0L, -1L, (SQLException)sqlexc);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$4, this, method, object, sQLException);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$5, this, method, sQLException);
            }
            this.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, method, sQLException);
            }
            if (this.isClosedAndNoReplay) {
                void var6_4 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, (Throwable)var6_4);
                }
                throw var6_4;
            }
            if (error instanceof SQLRecoverableException) {
                FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                switch (lifecycle) {
                    case ENABLED_NOT_REPLAYING: 
                    case ALWAYS_DISABLED: 
                    case INTERNALLY_DISABLED: 
                    case EXTERNALLY_DISABLED: {
                        Object object = this.failoverMngr.replayAll((SQLRecoverableException)error);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, object);
                            ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, null);
                        }
                        return object;
                    }
                }
                void var6_5 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, (Throwable)var6_5);
                }
                throw var6_5;
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecording((Method)m2, null, (SQLException)error);
                    break;
                }
            }
            void var6_6 = error;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, (Throwable)var6_6);
            }
            throw var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$7, this, callHistoryEntry);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$8, this, callHistoryEntry, sQLRecoverableException);
            }
            Object result = null;
            try {
                FailoverManagerImpl.ReplayLifecycle _lifecycle;
                Object newResult;
                ((Replayable)entry.jdbcProxy).setReplayingCallContext((FailoverManagerImpl.CallHistoryEntry)entry, (SQLRecoverableException)origError);
                result = newResult = entry.method.invoke(entry.jdbcProxy, entry.args);
                if (newResult instanceof NonTxnReplayableBase && (_lifecycle = this.failoverMngr.getReplayLifecycle()) == FailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null) {
                    Object newDelegate = ((NonTxnReplayableBase)newResult).getDelegate();
                    ((NonTxnReplayableBase)entry.result).setDelegate(newDelegate);
                    result = entry.result;
                }
            }
            catch (InvocationTargetException targetException) {
                Throwable throwable = targetException.getCause();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "On {0}, replaying {1} got InvocationTargetException with cause: {2}", new Object[]{entry.jdbcProxy, entry.method, throwable});
                }
                if (throwable instanceof SQLRecoverableException) {
                    SQLRecoverableException sqlrexc;
                    SQLRecoverableException sQLRecoverableException2 = sqlrexc = (SQLRecoverableException)throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$8, this, sQLRecoverableException2);
                    }
                    throw sQLRecoverableException2;
                }
                if (throwable instanceof SQLException) {
                    SQLException sqlexc = (SQLException)throwable;
                    int errCode = sqlexc.getErrorCode();
                    if (errCode == 29791) {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$8, Level.WARNING, this.getClass(), $$$methodRef$$$8, "On {0}, replaying {1} receives ORA-29791", new Object[]{entry.jdbcProxy, entry.method});
                        }
                        this.failoverMngr.disableReplayAndThrowException(entry.method, 390, "Replay failed because of active transaction during replay", (SQLRecoverableException)origError);
                    } else if (entry.callException == null || errCode != entry.callException.getErrorCode()) {
                        this.failoverMngr.disableReplayAndThrowException(entry.method, 389, "Replay failed because of error code or message mismatch", (SQLRecoverableException)origError);
                    }
                } else {
                    this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", (SQLRecoverableException)origError);
                }
            }
            catch (Throwable otherThrowable) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "On {0}, replaying {1} caught throwable: {2}", new Object[]{entry.jdbcProxy, entry.method, otherThrowable});
                }
                otherThrowable.printStackTrace();
                this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", (SQLRecoverableException)origError);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case INTERNALLY_FAILED: 
                case INTERNALLY_DISABLED: {
                    this.failoverMngr.throwReplayExceptionInternal(0, null, null);
                }
            }
            Object object = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$8, this, object);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$8, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addToSameProxyList(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$9, this, callHistoryEntry);
            }
            entry.prevEntrySameProxy = this.tailSameProxy;
            entry.nextEntrySameProxy = null;
            if (this.tailSameProxy != null) {
                this.tailSameProxy.nextEntrySameProxy = entry;
            }
            this.tailSameProxy = entry;
            if (this.headSameProxy == null) {
                this.headSameProxy = entry;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeFromSameProxyList(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$10, this, callHistoryEntry);
            }
            if (entry.nextEntrySameProxy != null) {
                entry.nextEntrySameProxy.prevEntrySameProxy = entry.prevEntrySameProxy;
            }
            if (entry.prevEntrySameProxy != null) {
                entry.prevEntrySameProxy.nextEntrySameProxy = entry.nextEntrySameProxy;
            }
            if (this.headSameProxy == entry) {
                this.headSameProxy = entry.nextEntrySameProxy;
            }
            if (this.tailSameProxy == entry) {
                this.tailSameProxy = entry.prevEntrySameProxy;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeSameProxyList() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.failoverMngr != null) {
                HashSet<Object> visitedProxies = new HashSet<Object>();
                for (Object ancestor = this; ancestor != null && ancestor instanceof NonTxnReplayableBase && !(ancestor instanceof ReplayableConnection); ancestor = ((NonTxnReplayableBase)ancestor).getCreator()) {
                    visitedProxies.add(ancestor);
                }
                this.failoverMngr.purgeForSameProxy(visitedProxies, this.headSameProxy);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReplayingCallContext(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$12, this, callHistoryEntry, sQLRecoverableException);
            }
            this.replayingCallEntry = entry;
            this.originalError = origError;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFailoverManager(FailoverManagerImpl failoverManagerImpl) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$13, this, failoverManagerImpl);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void mngr;
                this.failoverMngr = mngr;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$13, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$13, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public FailoverManagerImpl getFailoverManager() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            FailoverManagerImpl failoverManagerImpl;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$14, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    FailoverManagerImpl failoverManagerImpl2 = this.failoverMngr;
                    if (lock != null) {
                        lock.close();
                    }
                    failoverManagerImpl = failoverManagerImpl2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$14, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$14, this, failoverManagerImpl);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$14, this, null);
            }
            return failoverManagerImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$14, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isReplayFailure(Throwable throwable) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            int errCode;
            void t2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$15, this, throwable);
            }
            boolean result = false;
            if (t2 instanceof SQLException && (errCode = ((SQLException)t2).getErrorCode()) >= 370 && errCode < 400) {
                result = true;
            }
            boolean bl2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$15, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$15, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$15, this, throwable3);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean assertThrowablesMatch(Throwable throwable, Throwable throwable2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean doThrowablesMatch;
            void currentT;
            void originalT;
            boolean areSameType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$16, this, throwable, throwable2);
            }
            boolean bl2 = areSameType = originalT == null ? false : currentT.getClass().getName().equals(originalT.getClass().getName());
            if (bl) {
                OracleLog.log($$$loggerRef$$$16, Level.FINEST, this.getClass(), $$$methodRef$$$16, "Errors at original execution and replay are of same type: {0}", areSameType);
            }
            if (currentT instanceof SQLException && areSameType) {
                boolean bl3 = doThrowablesMatch = ((SQLException)currentT).getErrorCode() == ((SQLException)originalT).getErrorCode();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$16, Level.FINEST, this.getClass(), $$$methodRef$$$16, "Errors at original execution and replay are SQLException, error codes match: {0}", doThrowablesMatch);
                }
            } else if (areSameType) {
                String currentMesg = currentT.getMessage();
                String originalMesg = originalT.getMessage();
                boolean bl4 = doThrowablesMatch = currentMesg == null && originalMesg == null || currentMesg != null && originalMesg != null && currentT.getMessage().equals(originalT.getMessage());
                if (bl) {
                    OracleLog.log($$$loggerRef$$$16, Level.FINEST, this.getClass(), $$$methodRef$$$16, "Errors at original execution and replay are same type but not SQLException, error messages match: {0}", doThrowablesMatch);
                }
            } else {
                doThrowablesMatch = false;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$16, Level.FINEST, this.getClass(), $$$methodRef$$$16, "Errors at original execution and replay match: {0}", doThrowablesMatch);
            }
            boolean bl5 = doThrowablesMatch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$16, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$16, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$16, this, throwable4);
            }
            throw throwable3;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$17, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$17, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$17, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableBase.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$18 = NonTxnReplayableBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = NonTxnReplayableBase.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableBase.class.getDeclaredMethod("assertThrowablesMatch", Throwable.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableBase.class.getDeclaredMethod("isReplayFailure", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableBase.class.getDeclaredMethod("getFailoverManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableBase.class.getDeclaredMethod("setFailoverManager", FailoverManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableBase.class.getDeclaredMethod("setReplayingCallContext", FailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableBase.class.getDeclaredMethod("purgeSameProxyList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableBase.class.getDeclaredMethod("removeFromSameProxyList", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableBase.class.getDeclaredMethod("addToSameProxyList", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableBase.class.getDeclaredMethod("replayOneCall", FailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableBase.class.getDeclaredMethod("fillInChecksum", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableBase.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableBase.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableBase.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableBase.class.getDeclaredMethod("doPostWhenRecording", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableBase.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

