/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.OdsVersion;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class DbMetadataMediator {
    private static final DatatypeCoder datatypeCoder = DefaultDatatypeCoder.forEncodingFactory(EncodingFactory.createInstance(StandardCharsets.UTF_8));

    public static RowDescriptorBuilder newRowDescriptorBuilder(int size) {
        return new RowDescriptorBuilder(size, datatypeCoder);
    }

    public abstract FirebirdSupportInfo getFirebirdSupportInfo();

    public abstract ResultSet performMetaDataQuery(MetadataQuery var1) throws SQLException;

    public abstract FBDatabaseMetaData getMetaData();

    public abstract GDSType getGDSType();

    public abstract boolean isUseCatalogAsPackage();

    public abstract Collection<String> getClientInfoPropertyNames();

    public abstract OdsVersion getOdsVersion();

    public static final class MetadataQuery {
        private final String queryText;
        private final List<String> parameters;
        private final boolean standalone;

        public MetadataQuery(String queryText, List<String> parameters) {
            this(queryText, parameters, false);
        }

        public MetadataQuery(String queryText, List<String> parameters, boolean standalone) {
            this.queryText = Objects.requireNonNull(queryText, "queryText");
            this.parameters = Objects.requireNonNull(parameters, "parameters");
            this.standalone = standalone;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean isStandalone() {
            return this.standalone;
        }
    }
}

