/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.BatchCompletionResponse;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FetchResponse;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;
import org.firebirdsql.gds.ng.wire.TransmitAction;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.jdbc.FBDriverNotCapableException;

public abstract class AbstractWireOperations
implements FbWireOperations {
    private static final System.Logger log = System.getLogger(AbstractWireOperations.class.getName());
    private final WireConnection<?, ?> connection;
    private final WarningMessageCallback defaultWarningMessageCallback;

    protected AbstractWireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.defaultWarningMessageCallback = Objects.requireNonNull(defaultWarningMessageCallback, "defaultWarningMessageCallback");
    }

    @Override
    public final XdrStreamAccess getXdrStreamAccess() {
        return this.connection.getXdrStreamAccess();
    }

    protected final Encoding getEncoding() {
        return this.connection.getEncoding();
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    protected final void withTransmitLock(TransmitAction transmitAction) throws IOException, SQLException {
        this.getXdrStreamAccess().withTransmitLock(transmitAction);
    }

    @Override
    public final SQLException readStatusVector() throws SQLException {
        return this.readStatusVector(this.getXdrIn());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final SQLException readStatusVector(XdrInputStream xdrIn) throws SQLException {
        FbExceptionBuilder builder = new FbExceptionBuilder();
        try {
            block9: while (true) {
                int arg = xdrIn.readInt();
                switch (arg) {
                    case 1: {
                        int errorCode = xdrIn.readInt();
                        if (errorCode == 0) continue block9;
                        builder.exception(errorCode);
                        continue block9;
                    }
                    case 18: {
                        int errorCode = xdrIn.readInt();
                        if (errorCode == 0) continue block9;
                        builder.warning(errorCode);
                        continue block9;
                    }
                    case 2: 
                    case 5: {
                        builder.messageParameter((Object)xdrIn.readString(this.getEncoding()));
                        continue block9;
                    }
                    case 19: {
                        builder.sqlState(xdrIn.readString(this.getEncoding()));
                        continue block9;
                    }
                    case 0: {
                        if (builder.isEmpty()) {
                            return null;
                        }
                        return builder.toFlatSQLException();
                    }
                }
                builder.messageParameter(xdrIn.readInt());
            }
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public final Response readResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.readOperationResponse(this.readNextOperation(), warningCallback);
    }

    @Override
    public final Response readOperationResponse(int operationCode, WarningMessageCallback warningCallback) throws SQLException, IOException {
        Response response = this.processOperation(operationCode);
        this.processResponseWarnings(response, warningCallback);
        this.processResponse(response);
        return response;
    }

    @Override
    public final int readNextOperation() throws SQLException, IOException {
        try (LockCloseable ignored = this.withLock();){
            this.processDeferredActions();
            int n = this.connection.readNextOperation();
            return n;
        }
    }

    protected final Response processOperation(int operation) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        return switch (operation) {
            case 9 -> new GenericResponse(xdrIn.readInt(), xdrIn.readLong(), xdrIn.readBuffer(), this.readStatusVector());
            case 66 -> new FetchResponse(xdrIn.readInt(), xdrIn.readInt());
            case 78 -> new SqlResponse(xdrIn.readInt());
            case 103 -> this.readBatchCompletionResponse(xdrIn);
            case 114 -> this.readInlineBlobResponse(xdrIn);
            default -> throw FbExceptionBuilder.forNonTransientException(337248276).messageParameter(operation).messageParameter((Object)"processOperation").toSQLException();
        };
    }

    protected BatchCompletionResponse readBatchCompletionResponse(XdrInputStream xdrIn) throws SQLException, IOException {
        throw new FBDriverNotCapableException("Reading batch completion response not supported by " + String.valueOf(this));
    }

    protected InlineBlobResponse readInlineBlobResponse(XdrInputStream xdrIn) throws SQLException, IOException {
        throw new FBDriverNotCapableException("Reading inline blob response not supported by " + String.valueOf(this));
    }

    @Override
    public final void processResponse(Response response) throws SQLException {
        GenericResponse genericResponse;
        SQLException exception;
        if (response instanceof GenericResponse && (exception = (genericResponse = (GenericResponse)response).exception()) != null && !(exception instanceof SQLWarning)) {
            throw exception;
        }
    }

    @Override
    public final void processResponseWarnings(Response response, WarningMessageCallback warningCallback) {
        GenericResponse genericResponse;
        SQLException sQLException;
        if (response instanceof GenericResponse && (sQLException = (genericResponse = (GenericResponse)response).exception()) instanceof SQLWarning) {
            SQLWarning warning = (SQLWarning)sQLException;
            Objects.requireNonNullElse(warningCallback, this.defaultWarningMessageCallback).processWarning(warning);
        }
    }

    @Override
    public final GenericResponse readGenericResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (GenericResponse)this.readResponse(warningCallback);
    }

    @Override
    public final SqlResponse readSqlResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (SqlResponse)this.readResponse(warningCallback);
    }

    @Override
    public void handleCryptKeyCallback(DbCryptCallback dbCryptCallback) throws IOException, SQLException {
        throw new FBDriverNotCapableException("Crypt key callbacks not supported in this protocol version");
    }

    @Override
    public final void consumePackets(int numberOfResponses, WarningMessageCallback warningCallback) {
        while (numberOfResponses-- > 0) {
            try {
                this.readResponse(warningCallback);
            }
            catch (Exception e) {
                Objects.requireNonNullElse(warningCallback, this.defaultWarningMessageCallback).processWarning(new SQLWarning(e));
                log.log(System.Logger.Level.WARNING, "Exception in consumePackets; see debug level for stacktrace");
                log.log(System.Logger.Level.DEBUG, "Exception in consumePackets", (Throwable)e);
            }
        }
    }

    @Override
    public final void writeDirect(byte[] data) throws IOException {
        this.connection.writeDirect(data);
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        if (milliseconds < 0) {
            throw FbExceptionBuilder.toException(337248296);
        }
        this.connection.setSoTimeout(milliseconds);
    }

    protected final LockCloseable withLock() {
        return this.connection.withLockProxy();
    }

    protected final void addServerKeys(byte[] serverKeys) throws SQLException {
        this.connection.addServerKeys(serverKeys);
    }

    protected final void clearServerKeys() {
        this.connection.clearServerKeys();
    }

    protected final ClientAuthBlock getClientAuthBlock() {
        return this.connection.getClientAuthBlock();
    }

    protected final IAttachProperties<?> getAttachProperties() {
        return this.connection.getAttachProperties().asImmutable();
    }

    protected final List<KnownServerKey.PluginSpecificData> getPluginSpecificData() {
        return this.connection.getPluginSpecificData();
    }

    protected final WireConnection<?, ?> getConnection() {
        return this.connection;
    }

    protected final WarningMessageCallback getDefaultWarningMessageCallback() {
        return this.defaultWarningMessageCallback;
    }
}

