/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation.options;

import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.tools.command.text.operation.options.Operation;

public enum OperationType implements Operation
{
    count("Row Count", "Show counts of rows in the tables", "SELECT COUNT(*) AS COUNT FROM ${table}"),
    dump("Dump", "Show data from all rows in the tables", "SELECT ${columns} FROM ${table} ORDER BY ${basiccolumns}"),
    tablesample("Table sample", "Show sample data from tables, but the samples are not the same from run to run", "SELECT ${basiccolumns} FROM ${table}", InformationSchemaKey.TABLESAMPLE);

    private final String description;
    private final String queryString;
    private final String title;
    private final InformationSchemaKey viewKey;

    private OperationType(String title, String description, String queryString) {
        this(title, description, queryString, null);
    }

    private OperationType(String title, String description, String queryString, InformationSchemaKey viewKey) {
        this.title = title;
        this.description = description;
        this.queryString = queryString;
        this.viewKey = viewKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Query getQuery(InformationSchemaViews views) {
        if (this.viewKey == null || views == null || !views.hasQuery(this.viewKey)) {
            return new Query(this.name(), this.queryString);
        }
        String overriddenQueryString = views.getQuery(this.viewKey).query();
        return new Query(this.name(), overriddenQueryString);
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

