/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.builtins;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodesFactory;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ForeignSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class ListNodes {

    @GenerateInline(value=false)
    public static abstract class GetNativeListStorage
    extends Node {
        public abstract NativeSequenceStorage execute(PythonAbstractNativeObject var1);

        @Specialization
        NativeSequenceStorage getNative(PythonAbstractNativeObject list, @Cached CStructAccess.ReadPointerNode getContents, @Cached CStructAccess.ReadI64Node readI64Node) {
            assert (IsSubtypeNode.getUncached().execute(GetClassNode.executeUncached(list), (Object)PythonBuiltinClassType.PList));
            Object array = getContents.readFromObj(list, CFields.PyListObject__ob_item);
            int size = (int)readI64Node.readFromObj(list, CFields.PyVarObject__ob_size);
            int allocated = (int)readI64Node.readFromObj(list, CFields.PyListObject__allocated);
            return NativeObjectSequenceStorage.create(array, size, allocated, false);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @OperationProxy.Proxyable
    public static abstract class AppendNode
    extends PNodeWithContext {
        private static final BranchProfile[] DISABLED = new BranchProfile[]{BranchProfile.getUncached()};

        public abstract void execute(Object var1, Object var2);

        @NeverDefault
        public static BranchProfile[] getUpdateStoreProfile() {
            return new BranchProfile[1];
        }

        public static BranchProfile[] getUpdateStoreProfileUncached() {
            return DISABLED;
        }

        @Specialization
        public static void appendObjectGeneric(PList list, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.AppendNode appendNode, @Cached(value="getUpdateStoreProfile()", uncached="getUpdateStoreProfileUncached()", dimensions=1) BranchProfile[] updateStoreProfile) {
            if (updateStoreProfile[0] == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                SequenceStorage newStore = SequenceStorageNodes.AppendNode.executeUncached(list.getSequenceStorage(), value, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                updateStoreProfile[0] = BranchProfile.create();
                list.setSequenceStorage(newStore);
                if (list.getOrigin() != null && newStore instanceof ArrayBasedSequenceStorage) {
                    ArrayBasedSequenceStorage newArrayBasedStore = (ArrayBasedSequenceStorage)newStore;
                    list.getOrigin().reportUpdatedCapacity(newArrayBasedStore);
                }
            } else {
                SequenceStorage newStore = appendNode.execute(inliningTarget, list.getSequenceStorage(), value, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                if (list.getSequenceStorage() != newStore) {
                    updateStoreProfile[0].enter();
                    list.setSequenceStorage(newStore);
                }
                if (CompilerDirectives.inInterpreter() && list.getOrigin() != null && newStore instanceof ArrayBasedSequenceStorage) {
                    ArrayBasedSequenceStorage newArrayBasedStore = (ArrayBasedSequenceStorage)newStore;
                    list.getOrigin().reportUpdatedCapacity(newArrayBasedStore);
                }
            }
        }

        @Fallback
        public static void appendObjectForeign(Object list, Object value, @Bind Node inliningTarget, @Cached GetListStorageNode getStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.AppendNode appendNode) {
            SequenceStorage storage = getStorageNode.execute(inliningTarget, list);
            SequenceStorage newStore = appendNode.execute(inliningTarget, storage, value, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
            assert (newStore == storage);
        }

        @NeverDefault
        public static AppendNode create() {
            return ListNodesFactory.AppendNodeGen.create();
        }

        public static AppendNode getUncached() {
            return ListNodesFactory.AppendNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FastConstructListNode
    extends PNodeWithContext {
        public abstract PList execute(Frame var1, Node var2, Object var3);

        @Specialization(guards={"isBuiltinList(value)"})
        protected static PList doPList(PList value) {
            return value;
        }

        @Fallback
        protected PList doGeneric(VirtualFrame frame, Object value, @Cached(inline=false) ConstructListNode constructListNode) {
            return constructListNode.execute((Frame)frame, value);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ConstructListNode
    extends PNodeWithContext {
        public abstract PList execute(Frame var1, Object var2);

        @Specialization(guards={"isNoValue(none)"})
        static PList none(PNone none, @Bind PythonLanguage language) {
            return PFactory.createList(language);
        }

        @Specialization(guards={"isBuiltinList(list)"})
        static PList fromList(PList list, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached SequenceStorageNodes.CopyNode copyNode) {
            return PFactory.createList(language, copyNode.execute(inliningTarget, list.getSequenceStorage()));
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PList listIterable(VirtualFrame frame, Object iterable, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode createStorageFromIteratorNode, @Bind PythonLanguage language) {
            Object iterObj = getIter.execute((Frame)frame, inliningTarget, iterable);
            SequenceStorage storage = createStorageFromIteratorNode.execute(frame, iterObj);
            return PFactory.createList(language, storage);
        }

        @NeverDefault
        public static ConstructListNode create() {
            return ListNodesFactory.ConstructListNodeGen.create();
        }

        public static ConstructListNode getUncached() {
            return ListNodesFactory.ConstructListNodeGen.getUncached();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetClassForNewListNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, Object var2);

        @Specialization
        static Object doPList(Node inliningTarget, PList list, @Cached GetClassNode.GetPythonObjectClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, list);
        }

        @Fallback
        static Object doForeign(Object list) {
            assert (InteropLibrary.getUncached().hasArrayElements(list));
            return PythonBuiltinClassType.PList;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ClearListStorageNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void doPList(PList list) {
            list.setSequenceStorage(EmptySequenceStorage.INSTANCE);
        }

        @Fallback
        static void doForeign(Node inliningTarget, Object list, @Cached GetListStorageNode getStorageNode, @Cached ForeignSequenceStorage.ClearNode clearNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            clearNode.execute(inliningTarget, (ForeignSequenceStorage)sequenceStorage);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class UpdateListStorageNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, Object var2, SequenceStorage var3, SequenceStorage var4);

        @Specialization
        static void doPList(Node inliningTarget, PList list, SequenceStorage oldStorage, SequenceStorage newStorage, @Cached.Exclusive @Cached InlinedConditionProfile generalizedProfile) {
            if (generalizedProfile.profile(inliningTarget, oldStorage != newStorage)) {
                list.setSequenceStorage(newStorage);
            }
        }

        @Fallback
        static void doForeign(Node inliningTarget, Object list, SequenceStorage oldStorage, SequenceStorage newStorage, @Cached.Exclusive @Cached InlinedConditionProfile generalizedProfile, @Cached ForeignSequenceStorage.ClearNode clearNode, @Cached(inline=false) SequenceStorageNodes.ConcatBaseNode concatNode) {
            if (generalizedProfile.profile(inliningTarget, oldStorage != newStorage)) {
                clearNode.execute(inliningTarget, (ForeignSequenceStorage)oldStorage);
                SequenceStorage afterExtendStorage = concatNode.execute(oldStorage, oldStorage, newStorage);
                assert (afterExtendStorage == oldStorage);
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetListStorageNode
    extends PNodeWithContext {
        public abstract SequenceStorage execute(Node var1, Object var2);

        @Specialization
        static SequenceStorage doPList(PList list) {
            return list.getSequenceStorage();
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, seq)", "interop.hasArrayElements(seq)"}, limit="1")
        static SequenceStorage doForeign(Node inliningTarget, Object seq, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached InlinedBranchProfile errorProfile) {
            try {
                long size = interop.getArraySize(seq);
                return new ForeignSequenceStorage(seq, PInt.long2int(inliningTarget, size, errorProfile));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static SequenceStorage doFallback(Node inliningTarget, Object seq) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "list", seq);
        }
    }
}

