/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.RuntimeEnv;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class PolymorphicCollectionSchema
extends PolymorphicSchema {
    static final int ID_EMPTY_SET = 1;
    static final int ID_EMPTY_LIST = 2;
    static final int ID_SINGLETON_SET = 3;
    static final int ID_SINGLETON_LIST = 4;
    static final int ID_SET_FROM_MAP = 5;
    static final int ID_COPIES_LIST = 6;
    static final int ID_UNMODIFIABLE_COLLECTION = 7;
    static final int ID_UNMODIFIABLE_SET = 8;
    static final int ID_UNMODIFIABLE_SORTED_SET = 9;
    static final int ID_UNMODIFIABLE_LIST = 10;
    static final int ID_UNMODIFIABLE_RANDOM_ACCESS_LIST = 11;
    static final int ID_SYNCHRONIZED_COLLECTION = 12;
    static final int ID_SYNCHRONIZED_SET = 13;
    static final int ID_SYNCHRONIZED_SORTED_SET = 14;
    static final int ID_SYNCHRONIZED_LIST = 15;
    static final int ID_SYNCHRONIZED_RANDOM_ACCESS_LIST = 16;
    static final int ID_CHECKED_COLLECTION = 17;
    static final int ID_CHECKED_SET = 18;
    static final int ID_CHECKED_SORTED_SET = 19;
    static final int ID_CHECKED_LIST = 20;
    static final int ID_CHECKED_RANDOM_ACCESS_LIST = 21;
    static final String STR_EMPTY_SET = "a";
    static final String STR_EMPTY_LIST = "b";
    static final String STR_SINGLETON_SET = "c";
    static final String STR_SINGLETON_LIST = "d";
    static final String STR_SET_FROM_MAP = "e";
    static final String STR_COPIES_LIST = "f";
    static final String STR_UNMODIFIABLE_COLLECTION = "g";
    static final String STR_UNMODIFIABLE_SET = "h";
    static final String STR_UNMODIFIABLE_SORTED_SET = "i";
    static final String STR_UNMODIFIABLE_LIST = "j";
    static final String STR_UNMODIFIABLE_RANDOM_ACCESS_LIST = "k";
    static final String STR_SYNCHRONIZED_COLLECTION = "l";
    static final String STR_SYNCHRONIZED_SET = "m";
    static final String STR_SYNCHRONIZED_SORTED_SET = "n";
    static final String STR_SYNCHRONIZED_LIST = "o";
    static final String STR_SYNCHRONIZED_RANDOM_ACCESS_LIST = "p";
    static final String STR_CHECKED_COLLECTION = "q";
    static final String STR_CHECKED_SET = "r";
    static final String STR_CHECKED_SORTED_SET = "s";
    static final String STR_CHECKED_LIST = "t";
    static final String STR_CHECKED_RANDOM_ACCESS_LIST = "u";
    static final IdentityHashMap<Class<?>, Integer> __nonPublicCollections = new IdentityHashMap();
    static final Field fSingletonSet_element;
    static final Field fSingletonList_element;
    static final Field fUnmodifiableCollection_c;
    static final Field fUnmodifiableSortedSet_ss;
    static final Field fUnmodifiableList_list;
    static final Field fSynchronizedCollection_c;
    static final Field fSynchronizedSortedSet_ss;
    static final Field fSynchronizedList_list;
    static final Field fSynchronizedCollection_mutex;
    static final Field fCheckedCollection_c;
    static final Field fCheckedSortedSet_ss;
    static final Field fCheckedList_list;
    static final Field fCheckedCollection_type;
    static final Field fSetFromMap_m;
    static final Field fSetFromMap_s;
    static final Field fCopiesList_n;
    static final Field fCopiesList_element;
    static final RuntimeEnv.Instantiator<?> iSingletonSet;
    static final RuntimeEnv.Instantiator<?> iSingletonList;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableCollection;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableSet;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableSortedSet;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableList;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableRandomAccessList;
    static final RuntimeEnv.Instantiator<?> iSynchronizedCollection;
    static final RuntimeEnv.Instantiator<?> iSynchronizedSet;
    static final RuntimeEnv.Instantiator<?> iSynchronizedSortedSet;
    static final RuntimeEnv.Instantiator<?> iSynchronizedList;
    static final RuntimeEnv.Instantiator<?> iSynchronizedRandomAccessList;
    static final RuntimeEnv.Instantiator<?> iCheckedCollection;
    static final RuntimeEnv.Instantiator<?> iCheckedSet;
    static final RuntimeEnv.Instantiator<?> iCheckedSortedSet;
    static final RuntimeEnv.Instantiator<?> iCheckedList;
    static final RuntimeEnv.Instantiator<?> iCheckedRandomAccessList;
    static final RuntimeEnv.Instantiator<?> iSetFromMap;
    static final RuntimeEnv.Instantiator<?> iCopiesList;
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            PolymorphicCollectionSchema.transferObject(this, pipe, input, output, PolymorphicCollectionSchema.this.strategy);
        }
    };

    private static Class<?> map(String className, int id) {
        Class clazz = RuntimeEnv.loadClass(className);
        __nonPublicCollections.put(clazz, id);
        return clazz;
    }

    static String name(int number) {
        switch (number) {
            case 1: {
                return STR_EMPTY_SET;
            }
            case 2: {
                return STR_EMPTY_LIST;
            }
            case 3: {
                return STR_SINGLETON_SET;
            }
            case 4: {
                return STR_SINGLETON_LIST;
            }
            case 5: {
                return STR_SET_FROM_MAP;
            }
            case 6: {
                return STR_COPIES_LIST;
            }
            case 7: {
                return STR_UNMODIFIABLE_COLLECTION;
            }
            case 8: {
                return STR_UNMODIFIABLE_SET;
            }
            case 9: {
                return STR_UNMODIFIABLE_SORTED_SET;
            }
            case 10: {
                return STR_UNMODIFIABLE_LIST;
            }
            case 11: {
                return STR_UNMODIFIABLE_RANDOM_ACCESS_LIST;
            }
            case 12: {
                return STR_SYNCHRONIZED_COLLECTION;
            }
            case 13: {
                return STR_SYNCHRONIZED_SET;
            }
            case 14: {
                return STR_SYNCHRONIZED_SORTED_SET;
            }
            case 15: {
                return STR_SYNCHRONIZED_LIST;
            }
            case 16: {
                return STR_SYNCHRONIZED_RANDOM_ACCESS_LIST;
            }
            case 17: {
                return STR_CHECKED_COLLECTION;
            }
            case 18: {
                return STR_CHECKED_SET;
            }
            case 19: {
                return STR_CHECKED_SORTED_SET;
            }
            case 20: {
                return STR_CHECKED_LIST;
            }
            case 21: {
                return STR_CHECKED_RANDOM_ACCESS_LIST;
            }
            case 22: {
                return "v";
            }
            case 24: {
                return "x";
            }
            case 25: {
                return "y";
            }
        }
        return null;
    }

    static int number(String name) {
        return name.length() != 1 ? 0 : PolymorphicCollectionSchema.number(name.charAt(0));
    }

    static int number(char c) {
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'j': {
                return 10;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 12;
            }
            case 'm': {
                return 13;
            }
            case 'n': {
                return 14;
            }
            case 'o': {
                return 15;
            }
            case 'p': {
                return 16;
            }
            case 'q': {
                return 17;
            }
            case 'r': {
                return 18;
            }
            case 's': {
                return 19;
            }
            case 't': {
                return 20;
            }
            case 'u': {
                return 21;
            }
            case 'v': {
                return 22;
            }
            case 'x': {
                return 24;
            }
            case 'y': {
                return 25;
            }
        }
        return 0;
    }

    public PolymorphicCollectionSchema(IdStrategy strategy) {
        super(strategy);
    }

    @Override
    public Pipe.Schema<Object> getPipeSchema() {
        return this.pipeSchema;
    }

    public String getFieldName(int number) {
        return PolymorphicCollectionSchema.name(number);
    }

    public int getFieldNumber(String name) {
        return PolymorphicCollectionSchema.number(name);
    }

    public String messageFullName() {
        return Collection.class.getName();
    }

    public String messageName() {
        return Collection.class.getSimpleName();
    }

    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(PolymorphicCollectionSchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    public void writeTo(Output output, Object value) throws IOException {
        PolymorphicCollectionSchema.writeObjectTo(output, value, this, this.strategy);
    }

    static int idFrom(Class<?> clazz) {
        Integer id = __nonPublicCollections.get(clazz);
        if (id == null) {
            throw new RuntimeException("Unknown collection: " + clazz);
        }
        return id;
    }

    static Object instanceFrom(int id) {
        switch (id) {
            case 1: {
                return Collections.EMPTY_SET;
            }
            case 2: {
                return Collections.EMPTY_LIST;
            }
            case 3: {
                return iSingletonSet.newInstance();
            }
            case 4: {
                return iSingletonList.newInstance();
            }
            case 5: {
                return iSetFromMap.newInstance();
            }
            case 6: {
                return iCopiesList.newInstance();
            }
            case 7: {
                return iUnmodifiableCollection.newInstance();
            }
            case 8: {
                return iUnmodifiableSet.newInstance();
            }
            case 9: {
                return iUnmodifiableSortedSet.newInstance();
            }
            case 10: {
                return iUnmodifiableList.newInstance();
            }
            case 11: {
                return iUnmodifiableRandomAccessList.newInstance();
            }
            case 12: {
                return iSynchronizedCollection.newInstance();
            }
            case 13: {
                return iSynchronizedSet.newInstance();
            }
            case 14: {
                return iSynchronizedSortedSet.newInstance();
            }
            case 15: {
                return iSynchronizedList.newInstance();
            }
            case 16: {
                return iSynchronizedRandomAccessList.newInstance();
            }
            case 17: {
                return iCheckedCollection.newInstance();
            }
            case 18: {
                return iCheckedSet.newInstance();
            }
            case 19: {
                return iCheckedSortedSet.newInstance();
            }
            case 20: {
                return iCheckedList.newInstance();
            }
            case 21: {
                return iCheckedRandomAccessList.newInstance();
            }
        }
        throw new RuntimeException("Unknown id: " + id);
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        if (Collections.class == value.getClass().getDeclaringClass()) {
            PolymorphicCollectionSchema.writeNonPublicCollectionTo(output, value, currentSchema, strategy);
            return;
        }
        if (EnumSet.class.isAssignableFrom(value.getClass())) {
            strategy.writeEnumIdTo(output, 22, EnumIO.getElementTypeFromEnumSet(value));
        } else {
            strategy.writeCollectionIdTo(output, 25, value.getClass());
        }
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(strategy.COLLECTION_SCHEMA, currentSchema);
        }
        strategy.COLLECTION_SCHEMA.writeTo(output, (Object)((Collection)value));
    }

    static void writeNonPublicCollectionTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Integer num = __nonPublicCollections.get(value.getClass());
        if (num == null) {
            throw new RuntimeException("Unknown collection: " + value.getClass());
        }
        int id = num;
        switch (id) {
            case 1: {
                output.writeUInt32(id, 0, false);
                break;
            }
            case 2: {
                output.writeUInt32(id, 0, false);
                break;
            }
            case 3: {
                Object element;
                output.writeUInt32(id, 0, false);
                try {
                    element = fSingletonSet_element.get(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                if (element == null) break;
                output.writeObject(1, element, strategy.OBJECT_SCHEMA, false);
                break;
            }
            case 4: {
                output.writeUInt32(id, 0, false);
                Object element = ((List)value).get(0);
                if (element == null) break;
                output.writeObject(1, element, strategy.OBJECT_SCHEMA, false);
                break;
            }
            case 5: {
                Object m;
                try {
                    m = fSetFromMap_m.get(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                output.writeObject(id, m, strategy.POLYMORPHIC_MAP_SCHEMA, false);
                break;
            }
            case 6: {
                Object element;
                output.writeUInt32(id, 0, false);
                int n = ((List)value).size();
                try {
                    element = fCopiesList_element.get(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                output.writeUInt32(1, n, false);
                if (element == null) break;
                output.writeObject(2, element, strategy.OBJECT_SCHEMA, false);
                break;
            }
            case 7: {
                PolymorphicCollectionSchema.writeUnmodifiableCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 8: {
                PolymorphicCollectionSchema.writeUnmodifiableCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 9: {
                PolymorphicCollectionSchema.writeUnmodifiableCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 10: {
                PolymorphicCollectionSchema.writeUnmodifiableCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 11: {
                PolymorphicCollectionSchema.writeUnmodifiableCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 12: {
                PolymorphicCollectionSchema.writeSynchronizedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 13: {
                PolymorphicCollectionSchema.writeSynchronizedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 14: {
                PolymorphicCollectionSchema.writeSynchronizedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 15: {
                PolymorphicCollectionSchema.writeSynchronizedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 16: {
                PolymorphicCollectionSchema.writeSynchronizedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 17: {
                PolymorphicCollectionSchema.writeCheckedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 18: {
                PolymorphicCollectionSchema.writeCheckedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 19: {
                PolymorphicCollectionSchema.writeCheckedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 20: {
                PolymorphicCollectionSchema.writeCheckedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 21: {
                PolymorphicCollectionSchema.writeCheckedCollectionTo(output, value, currentSchema, strategy, id);
                break;
            }
            default: {
                throw new RuntimeException("Should not happen.");
            }
        }
    }

    private static void writeUnmodifiableCollectionTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object c;
        try {
            c = fUnmodifiableCollection_c.get(value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        output.writeObject(id, c, strategy.POLYMORPHIC_COLLECTION_SCHEMA, false);
    }

    private static void writeSynchronizedCollectionTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object mutex;
        Object c;
        try {
            c = fSynchronizedCollection_c.get(value);
            mutex = fSynchronizedCollection_mutex.get(value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        if (mutex != value) {
            throw new RuntimeException("This exception is thrown to fail fast. Synchronized collections with a different mutex would only work if graph format is used, since the reference is retained.");
        }
        output.writeObject(id, c, strategy.POLYMORPHIC_COLLECTION_SCHEMA, false);
    }

    private static void writeCheckedCollectionTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object type;
        Object c;
        try {
            c = fCheckedCollection_c.get(value);
            type = fCheckedCollection_type.get(value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        output.writeObject(id, c, strategy.POLYMORPHIC_COLLECTION_SCHEMA, false);
        output.writeObject(1, type, strategy.CLASS_SCHEMA, false);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        return PolymorphicCollectionSchema.readObjectFrom(input, schema, owner, strategy, input.readFieldNumber(schema));
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, int number) throws IOException {
        boolean graph = input instanceof GraphInput;
        Object ret = null;
        switch (number) {
            case 1: {
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                if (graph) {
                    ((GraphInput)input).updateLast((Object)Collections.EMPTY_SET, owner);
                }
                ret = Collections.EMPTY_SET;
                break;
            }
            case 2: {
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                if (graph) {
                    ((GraphInput)input).updateLast((Object)Collections.EMPTY_LIST, owner);
                }
                ret = Collections.EMPTY_LIST;
                break;
            }
            case 3: {
                int next;
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                Object collection = iSingletonSet.newInstance();
                if (graph) {
                    ((GraphInput)input).updateLast(collection, owner);
                }
                if ((next = input.readFieldNumber(schema)) == 0) {
                    return collection;
                }
                if (next != 1) {
                    throw new ProtostuffException("Corrupt input");
                }
                IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
                Object element = input.mergeObject((Object)wrapper, strategy.OBJECT_SCHEMA);
                if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
                    element = wrapper.value;
                }
                try {
                    fSingletonSet_element.set(collection, element);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                ret = collection;
                break;
            }
            case 4: {
                int next;
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                Object collection = iSingletonList.newInstance();
                if (graph) {
                    ((GraphInput)input).updateLast(collection, owner);
                }
                if ((next = input.readFieldNumber(schema)) == 0) {
                    return collection;
                }
                if (next != 1) {
                    throw new ProtostuffException("Corrupt input.");
                }
                IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
                Object element = input.mergeObject((Object)wrapper, strategy.OBJECT_SCHEMA);
                if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
                    element = wrapper.value;
                }
                try {
                    fSingletonList_element.set(collection, element);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                ret = collection;
                break;
            }
            case 5: {
                Object collection = iSetFromMap.newInstance();
                if (graph) {
                    ((GraphInput)input).updateLast(collection, owner);
                }
                IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
                Object m = input.mergeObject((Object)wrapper, strategy.POLYMORPHIC_MAP_SCHEMA);
                if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
                    m = wrapper.value;
                }
                try {
                    fSetFromMap_m.set(collection, m);
                    fSetFromMap_s.set(collection, ((Map)m).keySet());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                ret = collection;
                break;
            }
            case 6: {
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                Object collection = iCopiesList.newInstance();
                if (graph) {
                    ((GraphInput)input).updateLast(collection, owner);
                }
                if (1 != input.readFieldNumber(schema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                int n = input.readUInt32();
                int next = input.readFieldNumber(schema);
                if (next == 0) {
                    try {
                        fCopiesList_n.setInt(collection, n);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    return collection;
                }
                if (next != 2) {
                    throw new ProtostuffException("Corrupt input.");
                }
                IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
                Object element = input.mergeObject((Object)wrapper, strategy.OBJECT_SCHEMA);
                if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
                    element = wrapper.value;
                }
                try {
                    fCopiesList_n.setInt(collection, n);
                    fCopiesList_element.set(collection, element);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                ret = collection;
                break;
            }
            case 7: {
                ret = PolymorphicCollectionSchema.readUnmodifiableCollectionFrom(input, schema, owner, strategy, graph, iUnmodifiableCollection.newInstance(), false, false);
                break;
            }
            case 8: {
                ret = PolymorphicCollectionSchema.readUnmodifiableCollectionFrom(input, schema, owner, strategy, graph, iUnmodifiableSet.newInstance(), false, false);
                break;
            }
            case 9: {
                ret = PolymorphicCollectionSchema.readUnmodifiableCollectionFrom(input, schema, owner, strategy, graph, iUnmodifiableSortedSet.newInstance(), true, false);
                break;
            }
            case 10: {
                ret = PolymorphicCollectionSchema.readUnmodifiableCollectionFrom(input, schema, owner, strategy, graph, iUnmodifiableList.newInstance(), false, true);
                break;
            }
            case 11: {
                ret = PolymorphicCollectionSchema.readUnmodifiableCollectionFrom(input, schema, owner, strategy, graph, iUnmodifiableRandomAccessList.newInstance(), false, true);
                break;
            }
            case 12: {
                ret = PolymorphicCollectionSchema.readSynchronizedCollectionFrom(input, schema, owner, strategy, graph, iSynchronizedCollection.newInstance(), false, false);
                break;
            }
            case 13: {
                ret = PolymorphicCollectionSchema.readSynchronizedCollectionFrom(input, schema, owner, strategy, graph, iSynchronizedSet.newInstance(), false, false);
                break;
            }
            case 14: {
                ret = PolymorphicCollectionSchema.readSynchronizedCollectionFrom(input, schema, owner, strategy, graph, iSynchronizedSortedSet.newInstance(), true, false);
                break;
            }
            case 15: {
                ret = PolymorphicCollectionSchema.readSynchronizedCollectionFrom(input, schema, owner, strategy, graph, iSynchronizedList.newInstance(), false, true);
                break;
            }
            case 16: {
                ret = PolymorphicCollectionSchema.readSynchronizedCollectionFrom(input, schema, owner, strategy, graph, iSynchronizedRandomAccessList.newInstance(), false, true);
                break;
            }
            case 17: {
                ret = PolymorphicCollectionSchema.readCheckedCollectionFrom(input, schema, owner, strategy, graph, iCheckedCollection.newInstance(), false, false);
                break;
            }
            case 18: {
                ret = PolymorphicCollectionSchema.readCheckedCollectionFrom(input, schema, owner, strategy, graph, iCheckedSet.newInstance(), false, false);
                break;
            }
            case 19: {
                ret = PolymorphicCollectionSchema.readCheckedCollectionFrom(input, schema, owner, strategy, graph, iCheckedSortedSet.newInstance(), true, false);
                break;
            }
            case 20: {
                ret = PolymorphicCollectionSchema.readCheckedCollectionFrom(input, schema, owner, strategy, graph, iCheckedList.newInstance(), false, true);
                break;
            }
            case 21: {
                ret = PolymorphicCollectionSchema.readCheckedCollectionFrom(input, schema, owner, strategy, graph, iCheckedRandomAccessList.newInstance(), false, true);
                break;
            }
            case 22: {
                EnumSet<?> es = strategy.resolveEnumFrom(input).newEnumSet();
                if (graph) {
                    ((GraphInput)input).updateLast(es, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, es);
                return es;
            }
            case 25: {
                Collection collection = strategy.resolveCollectionFrom(input).newMessage();
                if (graph) {
                    ((GraphInput)input).updateLast((Object)collection, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, (Object)collection);
                return collection;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (0 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        return ret;
    }

    private static Object readUnmodifiableCollectionFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object collection, boolean ss, boolean list) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(collection, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object c = input.mergeObject((Object)wrapper, strategy.POLYMORPHIC_COLLECTION_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            c = wrapper.value;
        }
        try {
            fUnmodifiableCollection_c.set(collection, c);
            if (ss) {
                fUnmodifiableSortedSet_ss.set(collection, c);
            }
            if (list) {
                fUnmodifiableList_list.set(collection, c);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return collection;
    }

    private static Object readSynchronizedCollectionFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object collection, boolean ss, boolean list) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(collection, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object c = input.mergeObject((Object)wrapper, strategy.POLYMORPHIC_COLLECTION_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            c = wrapper.value;
        }
        try {
            fSynchronizedCollection_c.set(collection, c);
            fSynchronizedCollection_mutex.set(collection, collection);
            if (ss) {
                fSynchronizedSortedSet_ss.set(collection, c);
            }
            if (list) {
                fSynchronizedList_list.set(collection, c);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return collection;
    }

    private static Object readCheckedCollectionFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object collection, boolean ss, boolean list) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(collection, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object c = input.mergeObject((Object)wrapper, strategy.POLYMORPHIC_COLLECTION_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            c = wrapper.value;
        }
        if (1 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        Object type = input.mergeObject((Object)wrapper, strategy.CLASS_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            type = wrapper.value;
        }
        try {
            fCheckedCollection_c.set(collection, c);
            fCheckedCollection_type.set(collection, type);
            if (ss) {
                fCheckedSortedSet_ss.set(collection, c);
            }
            if (list) {
                fCheckedList_list.set(collection, c);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return collection;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        PolymorphicCollectionSchema.transferObject(pipeSchema, pipe, input, output, strategy, input.readFieldNumber(pipeSchema.wrappedSchema));
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy, int number) throws IOException {
        switch (number) {
            case 1: {
                output.writeUInt32(number, input.readUInt32(), false);
                break;
            }
            case 2: {
                output.writeUInt32(number, input.readUInt32(), false);
                break;
            }
            case 3: 
            case 4: {
                output.writeUInt32(number, input.readUInt32(), false);
                int next = input.readFieldNumber(pipeSchema.wrappedSchema);
                if (next == 0) {
                    return;
                }
                if (next != 1) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(1, (Object)pipe, strategy.OBJECT_PIPE_SCHEMA, false);
                break;
            }
            case 5: {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                break;
            }
            case 6: {
                output.writeUInt32(number, input.readUInt32(), false);
                if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeUInt32(1, input.readUInt32(), false);
                int next = input.readFieldNumber(pipeSchema.wrappedSchema);
                if (next == 0) {
                    return;
                }
                if (next != 2) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(2, (Object)pipe, strategy.OBJECT_PIPE_SCHEMA, false);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_COLLECTION_PIPE_SCHEMA, false);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_COLLECTION_PIPE_SCHEMA, false);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_COLLECTION_PIPE_SCHEMA, false);
                if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(1, (Object)pipe, strategy.CLASS_PIPE_SCHEMA, false);
                break;
            }
            case 22: {
                strategy.transferEnumId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.COLLECTION_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.COLLECTION_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            case 25: {
                strategy.transferCollectionId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.COLLECTION_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.COLLECTION_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    static {
        PolymorphicCollectionSchema.map("java.util.Collections$EmptySet", 1);
        PolymorphicCollectionSchema.map("java.util.Collections$EmptyList", 2);
        Class<?> cSingletonSet = PolymorphicCollectionSchema.map("java.util.Collections$SingletonSet", 3);
        Class<?> cSingletonList = PolymorphicCollectionSchema.map("java.util.Collections$SingletonList", 4);
        Class<?> cSetFromMap = PolymorphicCollectionSchema.map("java.util.Collections$SetFromMap", 5);
        Class<?> cCopiesList = PolymorphicCollectionSchema.map("java.util.Collections$CopiesList", 6);
        Class<?> cUnmodifiableCollection = PolymorphicCollectionSchema.map("java.util.Collections$UnmodifiableCollection", 7);
        Class<?> cUnmodifiableSet = PolymorphicCollectionSchema.map("java.util.Collections$UnmodifiableSet", 8);
        Class<?> cUnmodifiableSortedSet = PolymorphicCollectionSchema.map("java.util.Collections$UnmodifiableSortedSet", 9);
        Class<?> cUnmodifiableList = PolymorphicCollectionSchema.map("java.util.Collections$UnmodifiableList", 10);
        Class<?> cUnmodifiableRandomAccessList = PolymorphicCollectionSchema.map("java.util.Collections$UnmodifiableRandomAccessList", 11);
        Class<?> cSynchronizedCollection = PolymorphicCollectionSchema.map("java.util.Collections$SynchronizedCollection", 12);
        Class<?> cSynchronizedSet = PolymorphicCollectionSchema.map("java.util.Collections$SynchronizedSet", 13);
        Class<?> cSynchronizedSortedSet = PolymorphicCollectionSchema.map("java.util.Collections$SynchronizedSortedSet", 14);
        Class<?> cSynchronizedList = PolymorphicCollectionSchema.map("java.util.Collections$SynchronizedList", 15);
        Class<?> cSynchronizedRandomAccessList = PolymorphicCollectionSchema.map("java.util.Collections$SynchronizedRandomAccessList", 16);
        Class<?> cCheckedCollection = PolymorphicCollectionSchema.map("java.util.Collections$CheckedCollection", 17);
        Class<?> cCheckedSet = PolymorphicCollectionSchema.map("java.util.Collections$CheckedSet", 18);
        Class<?> cCheckedSortedSet = PolymorphicCollectionSchema.map("java.util.Collections$CheckedSortedSet", 19);
        Class<?> cCheckedList = PolymorphicCollectionSchema.map("java.util.Collections$CheckedList", 20);
        Class<?> cCheckedRandomAccessList = PolymorphicCollectionSchema.map("java.util.Collections$CheckedRandomAccessList", 21);
        try {
            fSingletonSet_element = cSingletonSet.getDeclaredField("element");
            fSingletonList_element = cSingletonList.getDeclaredField("element");
            fSetFromMap_m = cSetFromMap.getDeclaredField(STR_SYNCHRONIZED_SET);
            fSetFromMap_s = cSetFromMap.getDeclaredField(STR_CHECKED_SORTED_SET);
            fCopiesList_n = cCopiesList.getDeclaredField(STR_SYNCHRONIZED_SORTED_SET);
            fCopiesList_element = cCopiesList.getDeclaredField("element");
            fUnmodifiableCollection_c = cUnmodifiableCollection.getDeclaredField(STR_SINGLETON_SET);
            fUnmodifiableSortedSet_ss = cUnmodifiableSortedSet.getDeclaredField("ss");
            fUnmodifiableList_list = cUnmodifiableList.getDeclaredField("list");
            fSynchronizedCollection_c = cSynchronizedCollection.getDeclaredField(STR_SINGLETON_SET);
            fSynchronizedCollection_mutex = cSynchronizedCollection.getDeclaredField("mutex");
            fSynchronizedSortedSet_ss = cSynchronizedSortedSet.getDeclaredField("ss");
            fSynchronizedList_list = cSynchronizedList.getDeclaredField("list");
            fCheckedCollection_c = cCheckedCollection.getDeclaredField(STR_SINGLETON_SET);
            fCheckedCollection_type = cCheckedCollection.getDeclaredField("type");
            fCheckedSortedSet_ss = cCheckedSortedSet.getDeclaredField("ss");
            fCheckedList_list = cCheckedList.getDeclaredField("list");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        fSingletonSet_element.setAccessible(true);
        fSingletonList_element.setAccessible(true);
        fSetFromMap_m.setAccessible(true);
        fSetFromMap_s.setAccessible(true);
        fCopiesList_n.setAccessible(true);
        fCopiesList_element.setAccessible(true);
        fUnmodifiableCollection_c.setAccessible(true);
        fUnmodifiableSortedSet_ss.setAccessible(true);
        fUnmodifiableList_list.setAccessible(true);
        fSynchronizedCollection_c.setAccessible(true);
        fSynchronizedCollection_mutex.setAccessible(true);
        fSynchronizedSortedSet_ss.setAccessible(true);
        fSynchronizedList_list.setAccessible(true);
        fCheckedCollection_c.setAccessible(true);
        fCheckedCollection_type.setAccessible(true);
        fCheckedSortedSet_ss.setAccessible(true);
        fCheckedList_list.setAccessible(true);
        iSingletonSet = RuntimeEnv.newInstantiator(cSingletonSet);
        iSingletonList = RuntimeEnv.newInstantiator(cSingletonList);
        iSetFromMap = RuntimeEnv.newInstantiator(cSetFromMap);
        iCopiesList = RuntimeEnv.newInstantiator(cCopiesList);
        iUnmodifiableCollection = RuntimeEnv.newInstantiator(cUnmodifiableCollection);
        iUnmodifiableSet = RuntimeEnv.newInstantiator(cUnmodifiableSet);
        iUnmodifiableSortedSet = RuntimeEnv.newInstantiator(cUnmodifiableSortedSet);
        iUnmodifiableList = RuntimeEnv.newInstantiator(cUnmodifiableList);
        iUnmodifiableRandomAccessList = RuntimeEnv.newInstantiator(cUnmodifiableRandomAccessList);
        iSynchronizedCollection = RuntimeEnv.newInstantiator(cSynchronizedCollection);
        iSynchronizedSet = RuntimeEnv.newInstantiator(cSynchronizedSet);
        iSynchronizedSortedSet = RuntimeEnv.newInstantiator(cSynchronizedSortedSet);
        iSynchronizedList = RuntimeEnv.newInstantiator(cSynchronizedList);
        iSynchronizedRandomAccessList = RuntimeEnv.newInstantiator(cSynchronizedRandomAccessList);
        iCheckedCollection = RuntimeEnv.newInstantiator(cCheckedCollection);
        iCheckedSet = RuntimeEnv.newInstantiator(cCheckedSet);
        iCheckedSortedSet = RuntimeEnv.newInstantiator(cCheckedSortedSet);
        iCheckedList = RuntimeEnv.newInstantiator(cCheckedList);
        iCheckedRandomAccessList = RuntimeEnv.newInstantiator(cCheckedRandomAccessList);
    }
}

