/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.ConstructorPart;

public class Constructor {
    private final List<ConstructorPart> parts;

    protected Constructor(BuilderImpl builder) {
        this.parts = builder.parts();
    }

    public List<ConstructorPart> parts() {
        return this.parts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<ConstructorPart> parts;

        protected BuilderImpl() {
        }

        protected BuilderImpl(Constructor model) {
            this.parts = model.parts();
        }

        @Override
        public Builder parts(List<ConstructorPart> parts) {
            this.parts = parts;
            return this;
        }

        @Override
        public List<ConstructorPart> parts() {
            return this.parts;
        }

        @Override
        public Constructor build() {
            if (Objects.isNull(this.parts())) {
                throw new IllegalArgumentException("Missing value for required field `parts`");
            }
            if (Objects.nonNull(this.parts()) && this.parts().size() < 1) {
                throw new IllegalArgumentException("The size of `parts` must be greater than or equal to 1");
            }
            return new Constructor(this);
        }
    }

    public static interface Builder {
        public Builder parts(List<ConstructorPart> var1);

        public List<ConstructorPart> parts();

        public Constructor build();
    }
}

