/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.TO_STRING)
public class MLToStringProcessor
extends AbstractMLProcessor {
    private final boolean escapeJson;

    public MLToStringProcessor(Map<String, Object> config) {
        super(config);
        this.escapeJson = Boolean.TRUE.equals(config.getOrDefault("escape_json", false));
    }

    @Override
    public Object process(Object input) {
        String text = StringUtils.toJson((Object)input);
        if (this.escapeJson) {
            return StringEscapeUtils.escapeJson((String)text);
        }
        return text;
    }
}

