/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;

public final class ForwardingDisabledProcessorContext
implements ProcessorContext {
    private final ProcessorContext delegate;
    private static final String EXPLANATION = "ProcessorContext#forward() is not supported from this context, as the framework must ensure the key is not changed (#forward allows changing the key on messages which are sent). Use KStream.process() if you need to change the key.";

    public ForwardingDisabledProcessorContext(ProcessorContext delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public String applicationId() {
        return this.delegate.applicationId();
    }

    @Override
    public TaskId taskId() {
        return this.delegate.taskId();
    }

    @Override
    public Serde<?> keySerde() {
        return this.delegate.keySerde();
    }

    @Override
    public Serde<?> valueSerde() {
        return this.delegate.valueSerde();
    }

    @Override
    public File stateDir() {
        return this.delegate.stateDir();
    }

    @Override
    public StreamsMetrics metrics() {
        return this.delegate.metrics();
    }

    @Override
    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.delegate.register(store, stateRestoreCallback);
    }

    @Override
    public <S extends StateStore> S getStateStore(String name) {
        return this.delegate.getStateStore(name);
    }

    @Override
    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        return this.delegate.schedule(interval, type, callback);
    }

    @Override
    public Cancellable schedule(Instant startTime, Duration interval, PunctuationType type, Punctuator callback) {
        return this.delegate.schedule(startTime, interval, type, callback);
    }

    @Override
    public <K, V> void forward(K key, V value) {
        throw new StreamsException(EXPLANATION);
    }

    @Override
    public <K, V> void forward(K key, V value, To to) {
        throw new StreamsException(EXPLANATION);
    }

    @Override
    public void commit() {
        this.delegate.commit();
    }

    @Override
    public String topic() {
        return this.delegate.topic();
    }

    @Override
    public int partition() {
        return this.delegate.partition();
    }

    @Override
    public long offset() {
        return this.delegate.offset();
    }

    @Override
    public Headers headers() {
        return this.delegate.headers();
    }

    @Override
    public long timestamp() {
        return this.delegate.timestamp();
    }

    @Override
    public Map<String, Object> appConfigs() {
        return this.delegate.appConfigs();
    }

    @Override
    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.delegate.appConfigsWithPrefix(prefix);
    }

    @Override
    public long currentSystemTimeMs() {
        return this.delegate.currentSystemTimeMs();
    }

    @Override
    public long currentStreamTimeMs() {
        return this.delegate.currentStreamTimeMs();
    }
}

