/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.metrics.DefaultClientTelemetryContext;
import org.apache.kafka.server.metrics.DefaultClientTelemetryPayload;
import org.apache.kafka.server.telemetry.ClientTelemetryContext;
import org.apache.kafka.server.telemetry.ClientTelemetryExporter;
import org.apache.kafka.server.telemetry.ClientTelemetryPayload;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;

public class ClientTelemetryExporterPlugin {
    private final List<ClientTelemetryReceiver> receivers = Collections.synchronizedList(new ArrayList());
    private final List<ClientTelemetryExporter> exporters = Collections.synchronizedList(new ArrayList());

    public boolean isEmpty() {
        return this.receivers.isEmpty() && this.exporters.isEmpty();
    }

    public void add(ClientTelemetryReceiver receiver) {
        this.receivers.add(receiver);
    }

    public void add(ClientTelemetryExporter exporter) {
        this.exporters.add(exporter);
    }

    public DefaultClientTelemetryPayload getPayLoad(PushTelemetryRequest request) {
        return new DefaultClientTelemetryPayload(request);
    }

    public void exportMetrics(RequestContext context, PushTelemetryRequest request, int pushIntervalMs) {
        DefaultClientTelemetryPayload payload = this.getPayLoad(request);
        for (ClientTelemetryReceiver receiver : this.receivers) {
            receiver.exportMetrics((AuthorizableRequestContext)context, (ClientTelemetryPayload)payload);
        }
        if (!this.exporters.isEmpty()) {
            DefaultClientTelemetryContext telemetryContext = new DefaultClientTelemetryContext(pushIntervalMs, (AuthorizableRequestContext)context);
            for (ClientTelemetryExporter exporter : this.exporters) {
                exporter.exportMetrics((ClientTelemetryContext)telemetryContext, (ClientTelemetryPayload)payload);
            }
        }
    }
}

