/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.scroll.SubstanceScrollButton;

public class ButtonVisualStateTracker {
    private RolloverButtonListener substanceButtonListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    public void installListeners(final AbstractButton b, boolean toInstallRolloverListener) {
        if (toInstallRolloverListener) {
            this.substanceButtonListener = new RolloverButtonListener(b);
            b.addMouseListener(this.substanceButtonListener);
            b.addMouseMotionListener(this.substanceButtonListener);
            b.addFocusListener(this.substanceButtonListener);
            b.addPropertyChangeListener(this.substanceButtonListener);
            b.addChangeListener(this.substanceButtonListener);
        }
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (ButtonVisualStateTracker.this.substanceFadeStateListener != null) {
                        ButtonVisualStateTracker.this.substanceFadeStateListener.unregisterListeners();
                    }
                    boolean toRepaintParent = b instanceof SubstanceScrollButton || b instanceof SubstanceSpinnerButton || b instanceof SubstanceComboBoxButton;
                    ButtonVisualStateTracker.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, toRepaintParent));
                    ButtonVisualStateTracker.this.substanceFadeStateListener.registerListeners(toRepaintParent);
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        boolean toRepaintParent = b instanceof SubstanceScrollButton || b instanceof SubstanceSpinnerButton || b instanceof SubstanceComboBoxButton;
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, toRepaintParent));
        this.substanceFadeStateListener.registerListeners(toRepaintParent);
    }

    public void uninstallListeners(AbstractButton b) {
        if (this.substanceButtonListener != null) {
            b.removeMouseListener(this.substanceButtonListener);
            b.removeMouseMotionListener(this.substanceButtonListener);
            b.removeFocusListener(this.substanceButtonListener);
            b.removePropertyChangeListener(this.substanceButtonListener);
            b.removeChangeListener(this.substanceButtonListener);
            this.substanceButtonListener = null;
        }
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }
}

