"use strict";angular.module("cell",["tooltip","services"]);
"use strict";angular.module("charts",["sizeWatcher","tooltip"]);
"use strict";angular.module("column",["overflowTooltip"]);
"use strict";angular.module("error-handling",["services"]).config(["$provide",r=>{r.decorator("$exceptionHandler",["$delegate","$injector",function(r,e){return function(o,n){r(o,n),e.has("logging")&&e.get("logging").log("error",n,o.message,o.stack)}}])}]).run(["logging",r=>window.addEventListener("error",(e=>r.log("error",e.error.stack,e.error.message)))]);
"use strict";angular.module("crashHandling",[]);
"use strict";angular.module("grid",["ui-session"]);
"use strict";angular.module("loading",[]);
"use strict";angular.module("metric",["tooltip"]);
"use strict";angular.module("modalDialog",[]);
"use strict";angular.module("metricPassport",[]);
"use strict";angular.module("notification",[]);
"use strict";angular.module("overflowTooltip",[]);
"use strict";angular.module("searchDialog",[]);
"use strict";(()=>{function o(o,n){return["$timeout","dropdownOpener",function(e,t){return{restrict:"C",require:["?ngModel"],scope:n,link:function(n,r,i,c){r.hasClass("ui")&&e((()=>{o(n,r,i,c[0],e,t)}))}}}]}angular.module("ng-semantic-ui",[]).directive("dropdown",o((function(o,n,e,t,r,i){let c,d;n.dropdown({onChange:function(o){c=o,o&&t&&o!==t.$modelValue&&t.$setViewValue(o)}});const[s]=n,u=s.getAttribute("dropdown-id");i.setOpener(u,(({top:o,left:e})=>{s.style.top=o,s.style.left=e,n.dropdown("toggle")})),t&&(d=o.$watch((()=>t.$modelValue),(function(){t.$modelValue&&t.$modelValue!==c&&r((function(){n.dropdown("set exactly",t.$modelValue)}),100)}))),n.on("remove",(function(){n.dropdown("destroy")})),o.$on("$destroy",(function(){d&&d()}))}))).directive("accordion",o((function(o,n){n.accordion({onOpen:o.onOpen}),n.on("remove",(function(){n.accordion("destroy")}))}),{onOpen:"=?"})).directive("progress",o((function(o,n){const e=o.$watch("barProgress",(function(){n.progress({percent:o.barProgress>0?o.barProgress:0})}));n.on("remove",(function(){n.progress("destroy")})),o.$on("$destroy",(function(){e&&e()}))}),{barProgress:"@"})).directive("input",o((function(o,n){if(n.hasClass("size-watch")){const e=n.find(".dropdown.button"),t=n.find(".dropdown .menu");e.on("click",(()=>{t.css("max-width",n.width())})),o.$on("$destroy",(function(){e.off("click")}))}})))})();
"use strict";angular.module("splitter",[]);
"use strict";angular.module("statistics",[]);
"use strict";angular.module("services",["ngRoute"]);
"use strict";angular.module("styleCheatSheet",["ngRoute"]).config(["$routeProvider",s=>{s.when("/style-cheat-sheet",{template:'<div class="style-cheat-sheet"><div class="ui container"><h2 class="ui header">Icons</h2><p>To place an icon, use the general class name <span class="tag"><span class="value">icon</span></span> and the icon\'s name (<span class="tag"><span class="value">copy</span></span> in example below).</p><p>Icons are good with any inline elements such as <span class="tag">&lt;<span class="title">span</span>&gt;</span>, <span class="tag">&lt;<span class="title">i</span>&gt;</span>, or <span class="tag">&lt;<span class="title">b</span>&gt;</span>. If you change the font-size of the icon\'s container, the icon gets bigger. Same things goes for color, drop shadow, and anything else that gets inherited using CSS. The basic usage is:</p><table class="ui celled table examples"><tbody><tr><td class="two wide column"><i class="icon copy"></i></td><td><div class="header">Basic usage</div><span class="tag">&lt;<span class="title">i</span> <span class="attribute">class</span>=<span class="value">"icon copy"</span>&gt;&lt;/<span class="title">i</span>&gt;</span></td></tr><tr><td><span class="icon circle-third spin"></span></td><td><div class="header">Animated icon</div><p>To rotate any icon add the <span class="tag"><span class="value">spin</span></span> class to the class list. There are several icons designed specifically to be spinned.</p><span class="tag">&lt;<span class="title">i</span> <span class="attribute">class</span>=<span class="value">"icon circle-third spin"</span>&gt;&lt;/<span class="title">i</span>&gt;</span></td></tr></tbody></table><h4 class="">Gallery of icons</h4><p>The most recent list of icons is avalable in the <span class="tag"><span class="title">iconfont</span></span> component. Please refer to it.</p><h2 class="ui header">Buttons</h2><p>Button style is based on Semantic UI style with little customization. Decoration is applied via adding <span class="tag"><span class="attribute">class</span></span> attribute to almost any element. However, it is recommended to use <span class="tag">&lt;<span class="title">button</span>&gt;</span> element as a basis for buttons. In many cases, the variety provided by Semantic UI library can be used "as is". Though, to prevent too many variations in the Amplifier GUI, the recommended combo options are listed below:</p><table class="ui celled table examples"><tbody><tr><td class="two wide column"><button class="ui borderless button">Borderless</button></td><td><div class="header">Borderless button</div><p>This is a case of button with minimal visibility. It is recomended to use with icon on the left side. Otherwise it looks like a floating text. Use <span class="tag"><span class="value">borderless</span></span> key class name to remove borders.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui borderless button"</span>&gt;Borderless&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><button class="ui basic button">Basic</button></td><td><div class="header">Basic button</div><p>This should be the most frequently used button decoration in the GUI. Basic button is less prominent than the Standard one. The "Basic" decoration should be used for the floating and auxiliary panels, toolbars, and notifications.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui basic button"</span>&gt;Basic&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><button class="ui button">Standard</button></td><td><div class="header">Standard button</div><p>"Standard" decoration is recommended for dialogs with white background where buttons play the major role (no grids/timelines/schemas). The Standard button is more prominent than the Basic one.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui button"</span>&gt;Standard&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><button class="ui primary button">Primary</button></td><td><div class="header">Primary button</div><p>The most prominent button on the screen. There should be only one (few) primary icon on the screen at any given moment of time.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui primary button"</span>&gt;Primary&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column dark"><button class="ui inverted borderless button">Inverted</button></td><td><div class="header">Inverted borderless button</div><p>"Inverted borderless" decoration is used for auxiliary buttons over dark backgrounds. It is recomended to use with icon on the left side. Otherwise button looks like a floating text.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui inverted borderless button"</span>&gt;Inverted&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column dark"><button class="ui inverted basic button">Inverted</button></td><td><div class="header">Inverted basic button</div><p>"Inverted Basic" decoration is used for auxiliary buttons on aside of a result area.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui inverted basic button"</span>&gt;Inverted&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column dark"><button class="ui inverted button">Inverted</button></td><td><div class="header">Inverted standard button</div><p>Common decoration for the majority of buttons on aside of result area.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui inverted button"</span>&gt;Inverted&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column dark"><button class="ui primary inverted button">Inverted</button></td><td><div class="header">Inverted primary button</div><p>Decoration of the most important single button on the screen at any given moment of time.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui primary inverted button"</span>&gt;Inverted&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><button class="ui basic icon button"><i class="icon play"></i></button></td><td><div class="header">Basic icon-based button</div><p>To convert text-based button into icon-based one, add <span class="tag"><span class="value">icon</span></span> class to the list of button classes, and insert icon as described above instead of text.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui basic icon button"</span>&gt;&lt;<span class="title">i</span> <span class="attribute">class</span>=<span class="value">"icon play"</span>&gt;&lt;/<span class="title">i</span>&gt;&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><button class="ui borderless icon button"><i class="icon save"></i></button></td><td><div class="header">Borderless icon-based button</div><p>The lightest variation of a basic icon-based icon. Use <span class="tag"><span class="value">borderless</span></span> key class name to remove borders around icon.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui borderless icon button"</span>&gt;&lt;<span class="title">i</span> <span class="attribute">class</span>=<span class="value">"icon save"</span>&gt;&lt;/<span class="title">i</span>&gt;&lt;/<span class="title">button</span>&gt;</span></td></tr><tr><td class="two wide column"><div class="ui buttons"><button class="ui icon button"><i class="icon plus"></i></button> <button class="ui icon button"><i class="icon minus"></i></button> <button class="ui icon button"><i class="icon hammer-and-screwdriver"></i></button></div></td><td><div class="header">Group of buttons</div><p>Buttons can be grouped into block. For that, the parent element with <span class="tag"><span class="value">ui buttons</span></span> classes is needed.</p><div><span class="tag">&lt;<span class="title">div</span> <span class="attribute">class</span>=<span class="value">"ui buttons"</span>&gt;</span></div><div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="tag">&lt;<span class="title">button</span> ... &gt;</span> ... <span class="tag">&lt;/<span class="title">button</span>&gt;</span></div><div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="tag">&lt;<span class="title">button</span> ... &gt;</span> ... <span class="tag">&lt;/<span class="title">button</span>&gt;</span></div><div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="tag">&lt;<span class="title">button</span> ... &gt;</span> ... <span class="tag">&lt;/<span class="title">button</span>&gt;</span></div><div><span class="tag">&lt;<span class="title">/div</span>&gt;</span></div></td></tr><tr><td class="two wide column"><button class="ui basic button" ng-class="{active: !basic_button_active1}" ng-click="basic_button_active1 = !basic_button_active1;">Toggle me</button></td><td><div class="header">Toggling of button</div><p>The <span class="tag"><span class="value">active</span></span> key class can be applied to any button type. Thereby a button may represent the "pressed down / up" states. Experiment with button on the left side.</p><span class="tag">&lt;<span class="title">button</span> <span class="attribute">class</span>=<span class="value">"ui basic button <i>active</i>"</span>&gt;Toggle me&lt;/<span class="title">button</span>&gt;</span></td></tr></tbody></table><div class="ui accordion styled fluid"><div class="title"><i class="ui dropdown icon"></i>Tests</div><div class="content"><table class="ui celled table demo-test"><tbody><tr><td><div class="ui borderless button" ng-class="{active: borderless_button_active}" ng-click="borderless_button_active = !borderless_button_active;">Borderless</div></td><td><div class="ui buttons"><div class="ui icon button borderless"><i class="icon plus"></i></div><div class="ui icon button borderless"><i class="icon minus"></i></div><div class="ui icon button borderless"><i class="icon hammer-and-screwdriver"></i></div></div></td><td><div class="ui button borderless disabled">Borderless</div></td><td class="dark"><div class="ui button borderless inverted" ng-class="{active: borderless_button_active}" ng-click="borderless_button_active = !borderless_button_active;">Borderless</div></td><td class="dark"><div class="ui buttons"><div class="ui icon button borderless inverted"><i class="icon plus"></i></div><div class="ui icon button borderless inverted"><i class="icon minus"></i></div><div class="ui icon button borderless inverted"><i class="icon hammer-and-screwdriver"></i></div></div></td><td class="dark"><div class="ui button borderless inverted disabled">Borderless</div></td></tr><tr><td><div class="ui basic button" ng-class="{active: basic_button_active}" ng-click="basic_button_active = !basic_button_active;">Basic</div></td><td><div class="ui buttons"><div class="ui basic icon button"><i class="icon plus"></i></div><div class="ui basic icon button"><i class="icon minus"></i></div><div class="ui basic icon button"><i class="icon hammer-and-screwdriver"></i></div></div></td><td><div class="ui basic button disabled">Basic</div></td><td class="dark"><div class="ui basic button inverted" ng-class="{active: basic_button_active}" ng-click="basic_button_active = !basic_button_active;">Basic</div></td><td class="dark"><div class="ui buttons"><div class="ui basic icon button inverted"><i class="icon plus"></i></div><div class="ui basic icon button inverted"><i class="icon minus"></i></div><div class="ui basic icon button inverted"><i class="icon hammer-and-screwdriver"></i></div></div></td><td class="dark"><div class="ui basic button inverted disabled">Basic</div></td></tr><tr><td><div class="ui button" ng-class="{active: standard_button_active}" ng-click="standard_button_active = !standard_button_active;">Standard</div></td><td><div class="ui buttons"><div class="ui icon button"><i class="icon plus"></i></div><div class="ui icon button"><i class="icon minus"></i></div><div class="ui icon button"><i class="icon hammer-and-screwdriver"></i></div></div></td><td><div class="ui button disabled">Standard</div></td><td class="dark"><div class="ui button inverted" ng-class="{active: standard_button_active}" ng-click="standard_button_active = !standard_button_active;">Standard</div></td><td class="dark"><div class="ui buttons"><div class="ui icon button inverted"><i class="icon plus"></i></div><div class="ui icon button inverted"><i class="icon minus"></i></div><div class="ui icon button inverted"><i class="icon hammer-and-screwdriver"></i></div></div></td><td class="dark"><div class="ui button inverted disabled">Standard</div></td></tr><tr><td><div class="ui button primary" ng-class="{active: primary_button_active}" ng-click="primary_button_active = !primary_button_active;">Primary</div></td><td><div class="ui buttons"><div class="ui icon button primary"><i class="icon plus"></i></div><div class="ui icon button primary"><i class="icon minus"></i></div><div class="ui icon button primary"><i class="icon hammer-and-screwdriver"></i></div></div></td><td><div class="ui button primary disabled">Primary</div></td><td class="dark"><div class="ui button primary inverted" ng-class="{active: primary_button_active}" ng-click="primary_button_active = !primary_button_active;">Primary</div></td><td class="dark"><div class="ui buttons"><div class="ui icon button primary inverted"><i class="icon plus"></i></div><div class="ui icon button primary inverted"><i class="icon minus"></i></div><div class="ui icon button primary inverted"><i class="icon hammer-and-screwdriver"></i></div></div></td><td class="dark"><div class="ui button primary inverted disabled">Primary</div></td></tr></tbody></table><br><br><div class="ui two column grid"><div class="ui column"><span class="ui circular basic icon button"><i class="icon plus"></i></span> <span class="ui circular icon button"><i class="icon plus"></i></span> <span class="ui circular primary icon button"><i class="icon plus"></i></span> <span class="ui circular basic icon massive button"><i class="icon gear"></i></span> <span class="ui circular icon massive button"><i class="icon gear"></i></span> <span class="ui circular primary icon massive button"><i class="icon gear"></i></span></div><div class="ui column dark"><span class="ui circular basic inverted icon button"><i class="icon plus"></i></span> <span class="ui circular inverted icon button"><i class="icon plus"></i></span> <span class="ui circular primary inverted icon button"><i class="icon plus"></i></span> <span class="ui circular basic inverted icon massive button"><i class="icon gear"></i></span> <span class="ui circular inverted icon massive button"><i class="icon gear"></i></span> <span class="ui circular primary inverted icon massive button"><i class="icon gear"></i></span></div></div></div></div><h2 class="ui header">Tooltips</h2><p>Tooltip can be specified for any element and set up via <span class="tag"><span class="attribute">tooltip</span></span> attribute. There are several common types of a tooltip used in the product:</p><table class="ui celled table examples"><tbody><tr><td class="two wide column"><div class="ui basic button" tooltip="A significant portion of Pipeline Slots is remaining empty due to issues in the Front-End">default</div></td><td><div class="header">Basic info tooltip</div><span class="tag">&lt;<span class="title">div</span> <span class="attribute">class</span>=<span class="value">"ui basic button"</span> <span class="attribute">tooltip</span>=<span class="value">"A significant portion of &hellip;"</span> &gt;default&lt;/<span class="title">div</span>&gt;</span></td></tr><tr><td><span class="icon flag cell issue" tooltip="<p><strong>Issue:</strong> A significant portion of Pipeline Slots is remaining empty due to issues in the Front-End.</p><p><strong>Tips:</strong>  Make sure the code working size is not too large, the code layout does not require too many memory accesses per cycle to get enough instructions for filling four pipeline slots, or check for microcode assists.</p>" tooltip-class="issue">30.35s</span></td><td><div class="header">Issue tooltip</div><p>Type of the tooltip regaulated via <span class="tag"><span class="attribute">tooltip-class</span></span> attribute. If some interesting value of data element can be explained more, set up issue tooltip as shown below. Please note that this type of tooltips can be pinned. The ability is not configurable - only <span class="tag"><span class="value">issue</span></span> tooltips can be pinned.</p><span class="tag">&lt;<span class="title">span</span> <span class="attribute">class</span>=<span class="value">"icon flag cell issue"</span> <span class="attribute">tooltip</span>=<span class="value">"&lt;b&gt;Issue:&lt;/b&gt; A significant portion of &hellip;"</span> <span class="attribute">tooltip-class</span>=<span class="value">"issue"</span>&gt;30.35s&lt;/<span class="title">span</span>&gt;</span></td></tr><tr><td><span class="low-confidence" tooltip="This metric cannot be reliably calculated due to multiplexing issues or a low number of collected PMU samples." tooltip-class="low-confidence">~2.3%</span></td><td><div class="header">Low-confidence tooltip</div><span class="tag">&lt;<span class="title">span</span> <span class="attribute">tooltip</span>=<span class="value">"This metric cannot be &hellip;"</span> <span class="attribute">tooltip-class</span>=<span class="value">"low-confidence"</span>&gt;~2.3%&lt;/<span class="title">span</span>&gt;</span></td></tr><tr><td><span class="icon help" tooltip="Elapsed time is the wall time from the beginning to the end of collection." tooltip-class="help" data-position="bottom right">hotspot</span></td><td><div class="header">Help tooltip</div><p>The special help type of tooltips reserved for the future usage.</p><span class="tag">&lt;<span class="title">span</span> <span class="attribute">class</span>=<span class="value">"icon help"</span> <span class="attribute">tooltip</span>=<span class="value">"Elapsed time is &hellip;"</span> <span class="attribute">tooltip-class</span>=<span class="value">"help"</span>&gt;hotspots&lt;/<span class="title">span</span>&gt;</span></td></tr></tbody></table><div class="ui accordion styled fluid"><div class="title"><i class="ui dropdown icon"></i>Tests</div><div class="content"><h4 class="">Positioning</h4><p>There is a basic test of tooltips positioning. By design the ability to position tooltip is not in the public API.</p><div class="ui doubling four column grid"><div class="ui column"><div class="ui segement tooltip-positioning-test"><span class="icon info" tooltip="Top Left" data-position="top left"></span> <span class="icon info" tooltip="Top Center" data-position="top center"></span> <span class="icon info" tooltip="Top Right" data-position="top right"></span> <span class="icon info" tooltip="Right Center" data-position="right center"></span> <span class="icon info" tooltip="Bottom Right" data-position="bottom right"></span> <span class="icon info" tooltip="Bottom Center" data-position="bottom center"></span> <span class="icon info" tooltip="Bottom Left" data-position="bottom left"></span> <span class="icon info" tooltip="Left Center" data-position="left center"></span></div></div><div class="ui column"><div class="ui segement tooltip-positioning-test"><span class="icon flag issue" tooltip="Top Left" data-position="top left" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Top Center" data-position="top center" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Top Right" data-position="top right" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Right Center" data-position="right center" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Bottom Right" data-position="bottom right" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Bottom Center" data-position="bottom center" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Bottom Left" data-position="bottom left" tooltip-class="issue"></span> <span class="icon flag issue" tooltip="Left Center" data-position="left center" tooltip-class="issue"></span></div></div><div class="ui column"><div class="ui segement tooltip-positioning-test"><span class="icon trash low-confidence" tooltip="Top Left" data-position="top left" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Top Center" data-position="top center" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Top Right" data-position="top right" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Right Center" data-position="right center" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Bottom Right" data-position="bottom right" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Bottom Center" data-position="bottom center" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Bottom Left" data-position="bottom left" tooltip-class="low-confidence"></span> <span class="icon trash low-confidence" tooltip="Left Center" data-position="left center" tooltip-class="low-confidence"></span></div></div><div class="ui column"><div class="ui segement tooltip-positioning-test"><span class="icon help" tooltip="Top Left" data-position="top left" tooltip-class="help"></span> <span class="icon help" tooltip="Top Center" data-position="top center" tooltip-class="help"></span> <span class="icon help" tooltip="Top Right" data-position="top right" tooltip-class="help"></span> <span class="icon help" tooltip="Right Center" data-position="right center" tooltip-class="help"></span> <span class="icon help" tooltip="Bottom Right" data-position="bottom right" tooltip-class="help"></span> <span class="icon help" tooltip="Bottom Center" data-position="bottom center" tooltip-class="help"></span> <span class="icon help" tooltip="Bottom Left" data-position="bottom left" tooltip-class="help"></span> <span class="icon help" tooltip="Left Center" data-position="left center" tooltip-class="help"></span></div></div></div><h4 class="">Short vs. Scrollable</h4><div class="ui basic button" tooltip="This is a typical short tooltip">Short</div><div class="ui basic button" tooltip="<p><strong>Issue:</strong>A significant fraction of cycles was stalled due to switches of uOp delivery to the Microcode Sequencer (MS). Commonly used instructions are optimized for delivery by the DSB or MITE pipelines. Certain operations cannot be handled natively by the execution pipeline, and must be performed by microcode (small programs injected into the execution stream). Switching to the MS too often can negatively impact performance. The MS is designated to deliver long uOp flows required by CISC instructions like CPUID, or uncommon conditions like Floating Point Assists when dealing with Denormals. Note that this metric value may be highlighted due to Microcode Sequencer issue.<p><strong>Tips:</strong><p>1. Use profile-guided optimization to reduce the size of hot code regions.</p><p>2. Consider compiler options to reorder functions so that hot functions are located together.</p><p>3. If your application makes significant use of macros, try to reduce this by either converting the relevant macros to functions or using linker options to eliminate repeated code.</p><p>4. Consider the Os/O1 optimization level or the following subset of optimizations to decrease your code footprint:</p><ul><li>use inlining only when it decreases the footprint</li><li>disable loop unrolling</li><li>disable intrinsic inlining</li></ul></p><p><strong>Optimization examples:</strong></p><p><a href=\'#\'>Instruction Cache Misses recipe</a></p>">Long (with vertical scrolling)</div></div></div><div class="spacer"></div></div></div>'})}]);
"use strict";angular.module("tooltip",[]);
"use strict";angular.module("ui-session",[]);
"use strict";angular.module("utube",["sizeWatcher"]);
"use strict";angular.module("widgets",[]);
"use strict";angular.module("sizeWatcher",[]);
"use strict";angular.module("recursiveDirectiveCompiler",[]);
"use strict";angular.module("utube",["ngRoute","utube"]).config(["$routeProvider",e=>{e.when("/sandbox/htmlutil/utube",{template:'<div class="ui container" style="margin-top: 2em;"><h2 class="ui header">µTube</h2><p>Area for testing of the µTube control</p><div class="ui two column grid"><div class="column"><utube utube-data="utubeData" re-calculate="reCalculate"></utube></div><div class="column"><form class="ui form utube-test-sandbox"><div class="field"><label>Front-End</label><div class="fields"><div class="four wide field"><input type="number" step="0.01" ng-model="utubeData.frontEnd.value" ng-change="reCalculate()"></div><div class="ten wide field"><input type="text" placeholder="Put issue text here..." ng-model="utubeData.frontEnd.issues" ng-change="reCalculate()"></div></div></div><div class="field"><label>Memory</label><div class="fields"><div class="four wide field"><input type="number" step="0.01" ng-model="utubeData.memory.value" ng-change="reCalculate()"></div><div class="ten wide field"><input type="text" placeholder="Put issue text here..." ng-model="utubeData.memory.issues" ng-change="reCalculate()"></div></div></div><div class="field"><label>Retiring</label><div class="fields"><div class="four wide field"><input type="number" step="0.01" ng-model="utubeData.retiring.value" ng-change="reCalculate()"></div><div class="ten wide field"></div></div></div><div class="field"><label>Core</label><div class="fields"><div class="four wide field"><input type="number" step="0.01" ng-model="utubeData.core.value" ng-change="reCalculate()"></div><div class="ten wide field"><input type="text" placeholder="Put issue text here..." ng-model="utubeData.core.issues" ng-change="reCalculate()"></div></div></div><div class="field"><label>Bad Speculation</label><div class="fields"><div class="four wide field"><input type="number" step="0.01" ng-model="utubeData.badSpec.value" ng-change="reCalculate()"></div><div class="ten wide field"><input type="text" placeholder="Put issue text here..." ng-model="utubeData.badSpec.issues" ng-change="reCalculate()"></div></div></div></form><div class="field"><button class="ui button" ng-click="onClickSet1Button()">Set 1</button> <button class="ui button" ng-click="onClickSet2Button()">Set 2</button> <button class="ui button" ng-click="onClickSet3Button()">Set 3</button> <button class="ui button" ng-click="onClickRandomButton()">Random</button></div></div></div><div style="height: 400px;"></div></div>',controller:"utubeTestSandboxController"})}]);
"use strict";angular.module("cell").controller("CellController",["$scope","$filter","issues","$compile","metricPassportConfiguration","$timeout",function(e,o,n,l,t,c){const i=e.$watch("column",(function(){if(void 0!==e.column&&(e.value=void 0,e.issue=void 0,e.tooltip=void 0,e.lowConfidence=void 0,e.row)){const o=e.row.cells[e.column.index-1];if(e.value=s(u(o)),e.column.result1Index&&e.column.result2Index){const n=e.row.cells[e.column.result1Index-1],l=e.row.cells[e.column.result2Index-1],t=s(u(n)),c=s(u(l));t!==c?"number"==typeof o.value?e.value=t+" - "+c+" = "+e.value:e.value=t+" | "+c:e.value="Not changed, "+t}e.lowConfidence=!1===o.confidence,e.issue=!1!==o.confidence&&!!o.issuesMask,e.metricPassport||(e.metricPassport=t.fill(e.row,e.column)),e.metricPassport&&!e.lowConfidence?function(){const[o]=l('<metric-passport metric-data="metricPassport"></metric-passport>')(e);o&&c((()=>{const n=new RegExp(' ng-[\\w-]+=\\"[^\\"]+\\"| *ng-binding| *ng-scope|\x3c!-- [^<]+ --\x3e',"g");e.tooltip=o.innerHTML.replace(n,"")}))}():function(o){let l=[];e.showColumnDetailsInTooltip&&(l.push(e.column.name),e.column.description&&l.push(e.column.description));e.suppressIssueTooltip||(l=l.concat(n.get(e.column,e.row)));!1===o.confidence&&e.column.confidenceText&&l.push(e.column.confidenceText);e.tooltip=l.join("\n\n")}(o),o.displayValue=e.value}}));function u(n){const l=e.valueFilter,t=e.valueFilterParams;if(!l)return n.formattedValue;const c=o(l),i=[n.value];return t&&(angular.isArray(t)?i.concat(t):i.push(t)),c(...i)}function s(o){const n=e.removePrefixSuffixSpaces?"":" ";return e.valuePrefix&&(o=e.valuePrefix+n+o),e.valueSuffix&&(o+=n+e.valueSuffix),o}e.$on("$destroy",(function(){i&&i()}))}]);
"use strict";angular.module("cell").directive("cell",(function(){return{restrict:"E",template:'<span tooltip="{{tooltip}}" tooltip-at="{{tooltipAt}}" tooltip-anchor="{{tooltipAnchor}}" tooltip-class="{{issue ? \'issue\' : (lowConfidence ? \'low-confidence\' : \'default\')}}" ng-class="{issue: issue, number: number, \'low-confidence\': lowConfidence}" class="cell" ng-if="value"><span class="value">{{value}}<span class="icon flag-o" ng-if="issue"></span></span></span>',controller:"CellController",scope:{column:"=",row:"=",valueFilter:"@",valueFilterParams:"=?",valuePrefix:"@",valueSuffix:"@",removePrefixSuffixSpaces:"=?",showColumnDetailsInTooltip:"=?",tooltipAt:"@",tooltipAnchor:"@",metricPassport:"<"}}}));
"use strict";angular.module("widgets").directive("autoFocus",(function(){return{restrict:"A",link:function(t,u){u.focus()}}}));
"use strict";angular.module("charts").factory("barChartOptions",(function(){return new function(){this.main={height:200},this.margin={top:20,right:20,bottom:0,left:0},this.bar={minSpace:10,maxSpace:70,marginShare:.2},this.axes={x:{height:40,padding:{left:20,right:20},label:{margin:{top:25}}},y:{width:80,margin:{right:10}}},this.knob={height:40,margin:{top:25},regions:{height:14},handle:{width:10,height:15,collapseShift:3}}}}));
"use strict";angular.module("charts").directive("barChart",["BarChartData","BarChartDimensions","barChartOptions","QuantitativeXStrategy","OrdinalXStrategy","SemiOrdinalXStrategy","chart","xAxis","yAxis","bars","markers","knobs","knobRegions","barTooltips","markerTooltips","knobTooltips","zIndexSorter","sizeWatcher",function(r,e,t,n,a,i,o,s,d,x,l,c,u,b,m,h,A,f){return{restrict:"E",scope:{xAxisLabel:"=",yAxisLabel:"=",xAxisFormat:"=",yAxisFormat:"=",xFormat:"=",yFormat:"=",dataSet:"=?set",markers:"=?",xAxisType:"=?",knobs:"=?",onKnobChanged:"=",thresholdTooltip:"="},template:'<div class="bar-chart"></div>',replace:!0,link:function(p,y,k){function F(){if(p.dataSet&&p.markers&&p.knobs){const k=(f=p.dataSet,"ordinal"===p.xAxisType?new a(T):n.isApplicable(f)?new n(T):i.isApplicable(f)?new i(f):new a(T)),F=new r(p.dataSet,p.markers,p.knobs,k);let S=new e(F,L(),t,k);if(!S.width)return;S.binningRequired&&(F.discretize(S),S=new e(F,L(),t,k));const v=o.render(y[0],S);s.render(v,F,S,p.xAxisLabel,T,k,p),d.render(v,F,S,p.yAxisLabel,w,p),x.render(v,F,S),l.render(v,F,S),c.render(v,F,S,p.onKnobChanged,C),u.render(v,F,S),b.render(y,F,p.xAxisLabel,p.yAxisLabel,C,g,p),m.render(y,C,p),h.render(y,p.thresholdTooltip,p),A.sort(v,S)}var f}const S=p.$watchGroup(["dataSet","markers","knobs"],F);function w(r){return k.yAxisFormat?p.yAxisFormat(r):g(r)}function g(r){return k.yFormat?p.yFormat(r):r}function T(r){return k.xAxisFormat?p.xAxisFormat(r):C(r)}function C(r){return k.xFormat?p.xFormat(r):r}function L(){return y[0].offsetWidth}f(y[0],p,F),y[0].refreshSize=function(){return F(),!1},p.$on("$destroy",(function(){S&&S(),delete y[0].refreshSize}))}}}]);
"use strict";angular.module("charts").factory("knobRenderer",(function(){return function(n){return{render:function(){n.enter().append("path")}}}}));
"use strict";angular.module("column").controller("ColumnController",["$scope","uiSession",function(o,e){o.showLink=o.href&&!1!==o.column.allowCollapse,void 0===o.showIcon&&(o.showIcon=!0),o.showDetails=function(){void 0===o.onHyperlink?o.href&&o.href.activate&&(o.href.activate.column=o.column.name,o.$emit("result:navigate",o.href),e.getPartitionSocket(o).then((function(e){e.emit("hyperlink",o.href)}))):o.onHyperlink(o.href)}}]);
"use strict";angular.module("column").directive("column",(function(){return{restrict:"E",replace:!0,scope:{column:"=",href:"=",tooltipAt:"@",tooltipAnchor:"@",showIcon:"=?",onHyperlink:"=?"},template:'<span class="grid-column" tooltip="{{column.description}}" tooltip-at="{{tooltipAt}}" tooltip-anchor="{{tooltipAnchor}}" ng-class="{\'has-tooltip\': !!column.description}"><span class="name"><a ng-click="showDetails()" ng-if="::showLink" href="">{{column.name}}</a><div ng-if="::!showLink">{{column.name}}</div></span><span class="icon help-circle light" ng-if="column.description && showIcon"></span></span>',controller:"ColumnController"}}));
"use strict";angular.module("crashHandling").controller("CrashHandlingDialogController",["$http","$scope","uiSession","fileDialog","localize","productMode","clipboard",function(e,a,s,i,o,n,t){function l(){return{params:{identity:a.identity}}}a.messages={},a.mailToLink="",a.reportTab={caption:"%crashHandlingDialog.crashReport",visible:!0,content:""},a.stacksTab={caption:"%crashHandlingDialog.resolvedStack",visible:!1,content:""},a.tabs=[a.reportTab,a.stacksTab],a.activeTab=a.reportTab,a.activateTab=e=>{a.activeTab=e},s.getSession().then((e=>{o(["%crashHandlingDialog.less","%crashHandlingDialog.more","%crashHandlingDialog.sendReport","%crashHandlingDialog.doNotSend","%crashHandlingDialog.saveReport","%crashHandlingDialog.resolveStacks","%crashHandlingDialog.debug","%crashHandlingDialog.ignore","%crashHandlingDialog.alwaysIgnore","%crashHandlingDialog.copyToClipboard","%crashHandlingDialog.downloadReport"],"htmlui1").then((e=>{Object.assign(a.messages,e)})),e.on("crash-handler:initialized",(e=>{a.identity===e.identity&&(Object.assign(a.messages,e),a.visible=!0,a.loading=!0,a.progress=e.collectingReportMessage)})),e.on("crash-handler:progress",(e=>{a.identity===e.identity&&(a.progress=e.progress)})),e.on("crash-handler:report",(e=>{a.identity===e.identity&&(a.reportTab.content=e.report)})),e.on("crash-handler:report:collected",(e=>{a.identity===e.identity&&(a.enabledOptions=e,a.enabledOptions.expandButtonEnabled=e.saveReportOptionAvailable||e.resolveStacksOptionAvailable||e.debugOptionAvailable||e.ignoreOptionAvailable||e.copyToClipboardAvailable||e.downloadReportOptionAvailable,a.loading=!1,a.progress="")})),e.on("crash-handler:report:send:result",(e=>{a.identity===e.identity&&(a.loading=!1,e.succeeded?a.close():(a.progress=a.messages.failedToSendReportMessage,a.saveReport()))})),e.on("crash-handler:stacks",(e=>{a.identity===e.identity&&(a.stacksTab.content=e.resolvedStacks,a.loading=!1,a.progress=a.messages.successfullyResolvedStackMessage,a.stacksTab.visible=!0,a.activateTab(a.stacksTab))}))})),a.isBrowserMode=n.isBrowserMode(),a.getMailToLink=()=>encodeURI(`mailto:${a.messages.emailAddress}?subject=${a.messages.emailSubject}&body=${a.messages.emailBodyHeader}`),a.resolveStacks=()=>{e.post("api/crash-handling/stack-resolve/run",{},l()),a.loading=!0},a.debug=()=>{e.post("api/crash-handling/debug",{},l()),a.visible=!1},a.ignore=(s=!1)=>{e.post("api/crash-handling/ignore",{always:s},l()),a.visible=!1},a.close=()=>{e.post("api/crash-handling/close",{},l()),a.onClose&&a.onClose(),a.visible=!1},a.copyToClipboard=e=>{t.copy(e)},a.saveReport=()=>i.showSaveDialog({title:a.messages.saveReportDialogTitle,defaultPath:a.messages.defaultReportFilename}).then((a=>{if(a)return e.post("api/crash-handling/report/save",{filename:a},l())}))}]);
"use strict";angular.module("crashHandling").directive("crashHandlingDialog",(function(){return{restrict:"E",scope:{identity:"=",position:"@?",onClose:"&?"},template:'<modal-dialog class="crash-handling-dialog" ng-if="visible" width="60em" height="50em" on-close="close" localize="localize" default-msg-catalog="htmlui1" ng-style="::{position: position}"><h4 class="ui dividing header">{{::messages.title}}</h4><div class="ui form"><div class="field"><div html-content="{{::messages.description}}"></div></div><div class="field progress"><div class="spinner" ng-show="loading"></div><div class="message">{{progress || messages[\'%crashHandlingDialog.progressPlaceHolder\']}}</div></div><div class="ui top attached tabular menu"><div ng-repeat="tab in tabs" ng-click="activateTab(tab)" class="item" ng-class="{ active: tab === activeTab }" ng-show="tab.visible">{{::localize(tab.caption)}}</div></div><div class="field message-area"><button class="ui basic icon button copy-to-clipboard-button" ng-click="copyToClipboard(activeTab.content)" ng-show="enabledOptions.copyToClipboardAvailable"><i class="icon copy"></i></button> <textarea class="crash-handler-message-text-box" readonly="readonly">{{activeTab.content}}</textarea></div><div class="modal-dialog-buttons field"><button class="ui button expand-button" ng-disabled="!enabledOptions.expandButtonEnabled" ng-click="isExpanded = !isExpanded">{{isExpanded ? messages[\'%crashHandlingDialog.less\'] : messages[\'%crashHandlingDialog.more\']}}</button> <a class="ui button primary" web-link="{{::getMailToLink()}}">{{::messages[\'%crashHandlingDialog.sendReport\']}} </a><button class="ui button" ng-click="close()">{{::messages[\'%crashHandlingDialog.doNotSend\']}}</button></div><div class="modal-dialog-buttons field" ng-show="isExpanded"><div class="buttons-holder"><button class="ui button" ng-click="saveReport()" ng-if="::!isBrowserMode" ng-show="enabledOptions.saveReportOptionAvailable">{{::messages[\'%crashHandlingDialog.saveReport\']}}</button> <a class="ui button" ng-if="::isBrowserMode" ng-href="api/crash-handling/report/download?identity={{identity}}" target="_self" ng-show="enabledOptions.downloadReportOptionAvailable">{{::messages[\'%crashHandlingDialog.downloadReport\']}} </a><button class="ui button" ng-click="resolveStacks()" ng-show="enabledOptions.resolveStacksOptionAvailable">{{::messages[\'%crashHandlingDialog.resolveStacks\']}}</button> <button class="ui button" ng-click="debug()" ng-show="enabledOptions.debugOptionAvailable">{{::messages[\'%crashHandlingDialog.debug\']}}</button> <button class="ui button" ng-click="ignore()" ng-show="enabledOptions.ignoreOptionAvailable">{{::messages[\'%crashHandlingDialog.ignore\']}}</button> <button class="ui button" ng-click="ignore(true)" ng-show="enabledOptions.ignoreOptionAvailable">{{::messages[\'%crashHandlingDialog.alwaysIgnore\']}}</button></div></div></div></modal-dialog>',controller:"CrashHandlingDialogController"}}));
"use strict";angular.module("grid").factory("gridCtxMenu",["uiSession","localize","jqueryCtxMenu","sourcepaneConstants","gridpaneConstants","productMode",function(e,o,t,n,l,a){return function(i,s){let c=[];const r=a.isBrowserMode(),p={getItems:()=>{const{gridType:e}=i.contextMenuOptions,o={};return e!==n.sourceGridModes.SOURCE_GRID&&e!==n.sourceGridModes.ASSEMBLY_GRID?(e!==l.gridTypes.CALLEES_GRID&&e!==l.gridTypes.CALLERS_GRID||(o.changeFocus={name:c["%ChangeFocusFunctionLabel"],default:!0,disabled:!i.contextMenuOptions.changeFocusFunctionApplicable(),click:i.contextMenuOptions.changeFocusFunction}),o.viewSource={name:c["%ViewSourceLabel"],default:!(e===l.gridTypes.CALLEES_GRID||e===l.gridTypes.CALLERS_GRID),disabled:!i.contextMenuOptions.isDivable(),click:i.contextMenuOptions.viewSource},o.nonSrcGridSeparator1={type:"cm_separator"}):(e===n.sourceGridModes.ASSEMBLY_GRID&&(o.instructionReference={name:c["%InstructionReferenceLabel"],default:!0,disabled:!i.contextMenuOptions.isCell()||!i.contextMenuOptions.instructionReferenceAvailable(),click:i.contextMenuOptions.openInstructionReference},o.srcGridSeparator={type:"cm_separator"}),o.setColumnForHotspotsNavigation={icon:"hotspot",name:c["%SetColumnForHotspotsNavigation"],disabled:!i.contextMenuOptions.isApplicableForHotspotsNavigation(),click:i.contextMenuOptions.setColumnAsHotspotsNavigationColumn}),o.showHelp={name:c["%ShowHelpLabel"],disabled:!i.contextMenuOptions.hasHelpKeyword(),click:i.contextMenuOptions.showHelp},i.contextMenuOptions.availableFormats&&i.contextMenuOptions.availableFormats.length&&(o.showDataAs={name:c["%ShowDataAsLabel"],items:Object.assign({},...i.contextMenuOptions.availableFormats.map(((e,o)=>({["format"+o]:{checked:e.id===i.contextMenuOptions.format,name:e.displayName,click:()=>i.contextMenuOptions.applyFormat(e.id)}}))))}),o.hideColumn={name:c["%HideColumnLabel"],disabled:!i.contextMenuOptions.canHideColumn(),click:i.contextMenuOptions.hideColumn},o.showAllColumns={name:c["%ShowAllColumnsLabel"],disabled:!i.contextMenuOptions.hasHiddenColumn(),click:i.contextMenuOptions.showAllColumns},o.selectAll={name:c["%SelectAllLabel"],click:i.contextMenuOptions.selectAll},e!==l.gridTypes.FUNCTIONS_GRID&&(o.functionsGridSeparator={type:"cm_separator"},o.collapseAll={name:c["%CollapseAllLabel"],click:i.contextMenuOptions.collapseAll},o.expandSelectedRows={name:c["%ExpandSelectedRowsLabel"],click:i.contextMenuOptions.expandSelectedRows}),o.commonSeparator={type:"cm_separator"},o.copyRowsToClipboard={name:c["%CopyRowsToClipboardLabel"],click:i.contextMenuOptions.copyRowsToClipboard},o.copyCellToClipboard={name:c["%CopyCellToClipboardLabel"],disabled:!i.contextMenuOptions.isCell(),click:i.contextMenuOptions.copyCellToClipboard},r||(o.exportToCsv={name:c["%ExportToCSVLabel"],click:i.actions.exportToCsv}),e!==n.sourceGridModes.SOURCE_GRID&&e!==n.sourceGridModes.ASSEMBLY_GRID?(o.nonSrcGridSeparator2={type:"cm_separator"},i.contextMenuOptions.allowLoadingDetails&&i.contextMenuOptions.allowLoadingDetails()&&(o.loadDetails={name:c["%LoadMoreDataLabel"],click:i.actions.loadMoreData}),o.filterIn={name:c["%FilterInLabel"],click:()=>i.actions.filterBySelection(!0)},o.filterOut={name:c["%FilterOutLabel"],click:()=>i.actions.filterBySelection(!1)}):e===n.sourceGridModes.SOURCE_GRID&&(o.copyFilePath={name:c["%CopySourceFilePathLabel"],click:i.contextMenuOptions.copyFilePath}),o}};return e.getPartitionSocket(i).then((()=>{Promise.all([o(["%ShowHelpLabel","%ShowDataAsLabel","%HideColumnLabel","%ShowAllColumnsLabel","%SelectAllLabel","%CollapseAllLabel","%ExpandSelectedRowsLabel","%CopyRowsToClipboardLabel","%CopyCellToClipboardLabel","%ExportToCSVLabel"],"viewmodelbase1"),o(["%ViewSourceLabel","%FilterInLabel","%FilterOutLabel","%LoadMoreDataLabel","%ChangeFocusFunctionLabel"],"gridpanes3"),o(["%InstructionReferenceLabel","%SetColumnForHotspotsNavigation","%CopySourceFilePathLabel"],"sourceviewapi1")]).then((e=>{c=Object.assign({},...e),t(s,p)}))})),p}}]);
"use strict";angular.module("grid").controller("GridController",["$scope","$http","$q","uiSession","error","bigNumber","$compile","localize","userAgent","Tracker","clipboard","productHelp","fileDialog",function(e,t,s,a,i,o,r,n,l,c,d,h,u){const p=s.defer(),m=`api/${e.gridDomain}`,g=new c;let f=-1;a.getPartitionSocket(e).then((()=>{n(["%LoadingLabel","%NoDataMsgTitle","%FailedToSaveFileLabel","%SearchTooltip","%ByLabel"],"viewmodelbase1").then((t=>{Object.assign(e.messages,t),e.messages["%SearchTooltip"]=`${e.messages["%SearchTooltip"]} ${l.isMac()?"⌘":"CTRL"}+F`}))})),void 0===e.setFocusAfterRefresh&&(e.setFocusAfterRefresh=!0),e.onSearch=()=>t.get(`${m}/search`,{params:this._makeParams({requestGroup:this.gridData.gridid,searchKey:e.searchData.searchKey}),timeout:p.promise}).then(this.processSearchResponse),e.actions.setStorageState=t=>{e.storageState=t},this.init=function(s,o){function r(){return this.clearSearchResults(),e.loading.start().then(this._requestMetadata).then(this._applyMetadata).then(this.postColumnState).then((function(){e.setFocusAfterRefresh&&e.actions.setFocus()})).catch(i.handle(e)).finally(e.loading.stop)}s&&(this.gridData?(this.gridData=s,r.call(this)):(this.gridData=s,a.getPartitionSocket(e).then((()=>{r.call(this)}))),this._requestMetadata=()=>{const e=this._makeParams({row:0,count:o,filter:"global"});return delete this.gridData.persistedSorting,t.get(`${m}/refresh`,{params:e,timeout:p.promise})},this._applyMetadata=t=>{const s=t.data;if(e.processMetadata&&e.processMetadata(s))return;const{sorting:a}=s&&s.view||{};this.dataResponseColumns=s&&s.columns,this.dataResponseColumns&&a&&this.dataResponseColumns[a.column]&&this.updateSortingDataForCli(this.dataResponseColumns[a.column],a.descending),this.gridData.responseColumns=this.dataResponseColumns&&this.dataResponseColumns.map((e=>e.query)),this._patchResponse(s),this.gridData.focusRowReferenceType||this.gridData.focusRowReferences||function(t){if(e.processDefaultSelection&&e.processDefaultSelection(s))return;t&&t.rows&&t.rows.length>0?t.rows[0].selected||(t.rows[0].selected=!0,this.selectRow(0,t.rows[0].id,{})):this.selectRow(void 0,void 0,{clear:!0})}.call(this,s),s.rows&&s.rows.length&&s.view?(e.noData=!1,this.refreshmetadata(s)):(e.noData=!0,e.noDataCallback&&e.noDataCallback(),this.refreshmetadata()),delete this.gridData.focusRowReference,delete this.gridData.focusRowReferenceType,delete this.gridData.focusColumnName,delete this.gridData.focusRowReferences})},this.onCollapseAll=()=>this.updateGridData("collapseAllRows",{},e.actions.onCollapseAll),this.onExpandRow=(t,s,a)=>this.updateGridData(a?"expand":"collapse",{row:t,rowId:s.id},e.actions.onExpandRow),this.onExpandSelectedRows=()=>this.updateGridData("expandSelectedRows",{},e.actions.onExpandSelectedRows),this.onSortColumn=(t,s)=>this.updateGridData("sort",{sortColumn:t,descending:s},e.actions.onSortColumn),this.onUpdateVisible=(e,t)=>this.updateGridData("scroll",{row:e,count:t}),this.postColumnState=()=>{const e=this.buildColumnState();if(e&&e.length)return t.post(`${m}/columnState`,{columnHierarchy:e},{params:this._makeParams({requestGroup:this.gridData.gridid}),timeout:p.promise})},this.updateGridData=(s,a,o)=>{"scroll"!==s&&this.clearSearchResults();const r=`${m}/${s}`;return t.get(r,{params:this._makeParams(a),timeout:p.promise}).then((t=>{const{data:i}=t;e.searchData.foundItems=i.search,this._patchResponse(i),o&&o(i,s),"sort"===s&&this.dataResponseColumns&&a&&a.sortColumn&&this.dataResponseColumns[a.sortColumn]&&this.updateSortingDataForCli(this.dataResponseColumns[a.sortColumn],a.descending),this.refreshVisible(i)})).catch(i.handle(e))},this.updateSortingDataForCli=(e,t)=>{const{isSelf:s,isTotal:a,caption:i}=e;this.gridData.sortedColumnDisplayName=i,this.gridData.sortedDesc=t,i.indexOf(":")>-1?this.gridData.sortedColumnDisplayName=i.split(":")[0]+":"+i.split(":")[1].trim():s?this.gridData.sortedColumnDisplayName=i+":Self":a&&(this.gridData.sortedColumnDisplayName=i+":Total")},this._makeParams=e=>{const t={};var s;return s=this.gridData,Object.keys(s).forEach((e=>{"responseColumns"!==e&&(t[e]=s[e])})),Object.assign(t,e||{}),t.gridid&&(t.requestGroup=t.gridid),t},this.selectRow=(s,a,o)=>{const r=++f;let n;n=o.clear?"clear":o.all?"all":o.shift?"addRange":o.toggle?"toggle":o.ctrl?"none":"setSingle",g.start().then(function(){return t.post(`${m}/selection`,{},{params:this._makeParams({row:s,rowId:a,selectionType:n}),timeout:p.promise})}.bind(this)).then(function(t){if(r!==f)return;const a=t.data;if(!a||(i=a,!Object.keys(i).length))return;var i;if(e.rowSelectionCallback&&a.view){const t=s-a.view.startRow;t>=0&&t<a.rows.length&&e.rowSelectionCallback(a.rows[t],n)}a.selectionUpdate=!0,this._patchResponse(a),this.refreshVisible(a)}.bind(this)).catch(i.handle(e)).finally(g.stop)},this._patchResponse=e=>{e&&(e.view&&e.view.sorting&&(e.view.sorting.col=e.view.sorting.column,delete e.view.sorting.column,e.view.sorting.forward=e.view.sorting.descending,delete e.view.sorting.descending),e.columns&&e.columns.forEach((e=>{e.backwardSorting=!e.descendingByDefault,delete e.descendingByDefault,e.sortable=e.isCollapsible,e.expansionText&&e.expansionText.length&&(e.shortCaption=e.caption)})))},this.getCellTooltip=(t,s)=>{if(t&&s&&s.isData){const a=t.cells?t.cells[s.id]:{};let i;if(a){if(!1===a.isReliable)return i=r(`<div>${s.confidenceText}</div>`)(e,(()=>{}))[0],i?i.innerHTML:void 0;const t=[];if(a.issueMask&&s.issues){const n=o(a.issueMask);if(n&&n.isGreaterThan(0)){n.toString(2).split("").reverse().forEach((function(e,a){if("1"!==e)return;const i=s.issues[a];i&&(i.issueText&&t.push(i.issueText),t.push(""))}))}return i=r(`<div>${t.join("<br>")}</div>`)(e,(()=>{}))[0],i?i.innerHTML:void 0}}}},this.viewSource=(s,a)=>e.viewSource?e.viewSource(s,a):t.get(`${m}/viewSource`,{params:this._makeParams({requestGroup:this.gridData.gridid,row:s,rowId:a.id}),timeout:p.promise}).then((t=>e.$emit("viewSource",t.data))),this.showHelp=t=>h.openHelpByKeyword(t,e),this.copyToClipboard=t=>{a.getPartitionSocket(e).then((function(e){e.emit("copyToClipboard",t)})),d.copy(t)},this.copyRowsToClipboard=()=>t.post(`${m}/copyRowsToClipboard`,{},{params:this._makeParams({requestGroup:this.gridData.gridid}),timeout:p.promise}).then(i.validateResponse).then((e=>{e&&e.copiedRows&&d.copy(e.copiedRows)})),this.exportToCsv=()=>n.spread(["%ExportToCSVLabel","%CSVFileFilter"],"viewpoint",(function(e,t){return u.showSaveDialog({dialogTitle:e,fileFilter:t,defaultFileName:"result.csv"})})).then((s=>{if(s)return t.post(`${m}/exportToCsv`,{filePath:s},{params:this._makeParams({requestGroup:this.gridData.gridid}),timeout:p.promise}).then((t=>{t.data&&t.data.error&&e.fileErrorCallback&&e.fileErrorCallback()}))})).catch((e=>console.log("error",e))),this.clearSearchResults=()=>{delete e.searchData.foundItems,delete e.searchData.currentFoundItem}}]);
"use strict";angular.module("grid").directive("grid",["$compile","popup","textFormat","color","gridCtxMenu",function(e,t,o,n,a){return{restrict:"E",scope:{actions:"=",centralColumnWidth:"@",changeFocusFunctionCallback:"=",contextMenuOptions:"=",fileErrorCallback:"=",gridData:"=",gridDomain:"=",loading:"=",messages:"=",noData:"=",noDataCallback:"=",numberOfPinnedColumns:"=?",onSearch:"=",persistState:"=",processMetadata:"=",processDefaultSelection:"=?",rowSelectionCallback:"=",searchData:"=",setFocusAfterRefresh:"=?",showSearchDialogCallback:"=",viewSource:"=?"},controller:"GridController",link:function(s,r,i,c){let l,u;require(["grid","vtgrid","hierarch_datamodel_virtual","utils","data_utils"],(function(i,d,f,m,h){r.addClass("grid");let g,w=!1,x=s.centralColumnWidth||"25%",p={row:void 0,col:void 0,target:{}};const I=function(){const e=m.em2px(1,r[0])+7;return Math.max(2*Math.round(screen.height/e),100)}(),C=void 0===s.numberOfPinnedColumns?0:s.numberOfPinnedColumns-1;let b=!1;const D={time:{textFormat:"time",showText:!0,showBar:!1},timeAndBar:{textFormat:"time",showText:!0,showBar:!0},timeScientific:{textFormat:"timeScientific",showText:!0,showBar:!1},timeScientificAndBar:{textFormat:"timeScientific",showText:!0,showBar:!0},count:{textFormat:"count",showText:!0,showBar:!1},countAndBar:{textFormat:"count",showText:!0,showBar:!0},integer:{textFormat:"integer",showText:!0,showBar:!1},integerAndBar:{textFormat:"integer",showText:!0,showBar:!0},number:{textFormat:"number",showText:!0,showBar:!1},numberAndBar:{textFormat:"number",showText:!0,showBar:!0},scientific:{textFormat:"scientific",showText:!0,showBar:!1},scientificAndBar:{textFormat:"scientific",showText:!0,showBar:!0},_double_:{textFormat:"double",showText:!0,showBar:!1},doubleAndBar:{textFormat:"double",showText:!0,showBar:!0},hex:{textFormat:"hex",showText:!0,showBar:!1},frequency:{textFormat:"frequency",showText:!0,showBar:!1},memory:{textFormat:"memory",showText:!0,showBar:!1},ratio:{textFormat:"ratio",showText:!0,showBar:!1},ratioAndBar:{textFormat:"ratio",showText:!0,showBar:!0},percent:{textFormat:"percent",showText:!0,showBar:!1},percent_by:{textFormat:"percent_by",showText:!0,showBar:!1},percentAndBar:{textFormat:"percent",showText:!0,showBar:!0},bar:{textFormat:"double",showText:!1,showBar:!0},string:{textFormat:"string",showText:!0,showBar:!1}};s.contextMenuOptions=s.contextMenuOptions||{},l=s.$watch("gridData",(function(e){c.init(e,I)})),u=s.$watch("searchData.showSearchDialog",(function(){if(s.searchData.foundItems&&s.searchData.foundItems.foundItemCount)if(!1===s.searchData.showSearchDialog){const e=JSON.parse(JSON.stringify(s.searchData.foundItems)),t=JSON.parse(JSON.stringify(s.searchData.currentFoundItem));c.clearSearchResults(),S.changed.raise([]),s.searchData.foundItems=e,s.searchData.currentFoundItem=t}else S.changed.raise([])}));const F=a(s,r);s.$on("pane:deactivated",A),s.$on("$destroy",(function(){l&&l(),u&&u(),y&&y.destroy(),F&&F.destroy(),A()})),s.actions.bringRowToView=e=>{y.centralGrid.gridBody.rowVisibleCenter(e)},s.actions.expandRowsRecursively=()=>{s.loading.start(),c.updateGridData("expandRowsRecursively").finally(s.loading.stop),s.actions.setFocus(),S.modifyVisibleRows((e=>(e.state=h.RowState.waiting,!0)))},s.actions.getBufferSize=()=>I,s.actions.getRowCount=()=>S.getRowCount(),s.actions.getContextMenuInfo=()=>{if(p.target.isRow||p.target.isHeader||p.target.isFooter)return{contextMenuItem:p,rowInfo:S.getRowInfo(p.row),columnInfo:S.getColumnInfo()[p.col]}},s.actions.exportToCsv=c.exportToCsv,s.actions.keyDown=e=>{67===e.keyCode&&(e.ctrlKey||e.metaKey)&&(b=!0),70===e.keyCode&&(e.ctrlKey||e.metaKey)&&(e.stopPropagation(),e.preventDefault(),s.searchData.showSearchDialog=!0,s.showSearchDialogCallback&&s.showSearchDialogCallback())},s.actions.keyUp=e=>{67===e.keyCode&&b&&(b=!1,c.copyRowsToClipboard())},s.actions.refreshColumns=e=>{if(!e)return;const t=[];e.forEach((e=>{t.push({col:e}),t.push({row:-1,col:e})})),S.changed.raise(t)},s.actions.reload=()=>{S.regetRowsBuffer()},s.actions.setCurrentRow=e=>{y.setCurrentRow(e)},s.actions.selectRow=c.selectRow,s.actions.setFocus=function(){y.rightGrid.gridBody.area.focus()},s.actions.update=c.updateGridData,s.actions.selectAll=function(){c.selectRow(void 0,void 0,{all:!0}),s.actions.setFocus(),S.modifyVisibleRows((e=>!e.selected&&(e.selected=!0,!0)))},s.actions.collapseAll=function(){c.onCollapseAll(),s.actions.setFocus(),S.modifyVisibleRows((e=>e.state===i.HeaderItemState.expanded&&(e.state=h.RowState.waiting,!0)))},s.actions.viewSource=function(e){const t=S.getRowInfo(e);T(t)&&c.viewSource(e,t)},s.contextMenuOptions.applyFormat=function(e){if(!p.target.isRow&&!p.target.isHeader&&!p.target.isFooter)return;const t=y.rightGrid.gridBody.getColumnByDataIndex(p.col,!0).getParentColumn();if(t&&S.getColumnInfo()[t.dataIndex].syncChildColumnsFormat)for(let e=0;e<t.visItem.getChildrenCount();e++)n(t.visItem.getChild(e).getDataIndex());else n(p.col);c.postColumnState();const o=O();function n(t){S.getColumnInfo()[t].format=e,s.searchData.foundItems?(c.clearSearchResults(),S.changed.raise([]),y.updateFooter()):S.changed.raise([{col:t},{col:t,row:-1}])}o&&(s.storageState.columns=o,s.persistState())},s.contextMenuOptions.canHideColumn=function(){if(!p.target.isRow&&!p.target.isHeader&&!p.target.isFooter)return;const e=S.getColumnInfo()[p.col];return e&&!e.isGrouping&&p.col>C&&y.canColumnBeHidden(p.col)},s.contextMenuOptions.changeFocusFunction=function(){if(!p.target.isRow||!s.changeFocusFunctionCallback)return!1;const e=S.getRowInfo(p.row);e.objectid&&s.changeFocusFunctionCallback(e.objectid)},s.contextMenuOptions.changeFocusFunctionApplicable=function(){return p.target.isRow&&s.changeFocusFunctionCallback},s.contextMenuOptions.collapseAll=s.actions.collapseAll,s.contextMenuOptions.copyCellToClipboard=function(){const e=S.getColumnInfo()[p.col],t=S.getRowInfo(p.row),o=R(t,e).textFormatter(t.cells[e.id].value);c.copyToClipboard(o),s.actions.setFocus()},s.contextMenuOptions.copyRowsToClipboard=c.copyRowsToClipboard,s.contextMenuOptions.expandSelectedRows=function(){c.onExpandSelectedRows(),s.actions.setFocus(),S.modifyVisibleRows((e=>!(!e.selected||e.state!==i.HeaderItemState.collapsed)&&(e.state=h.RowState.waiting,!0)))},s.contextMenuOptions.hasHelpKeyword=function(){if(!p.target.isRow&&!p.target.isHeader&&!p.target.isFooter)return;const e=S.getColumnInfo()[p.col];return e&&e.helpKeyword},s.contextMenuOptions.hasHiddenColumn=function(){return y.getInvisibleColumnsCount()>0},s.contextMenuOptions.hideColumn=function(){(p.target.isRow||p.target.isHeader||p.target.isFooter)&&(y.hideColumn(p.col),s.actions.setFocus())},s.contextMenuOptions.isDivable=function(){if(!p.target.isRow)return!1;return T(S.getRowInfo(p.row))},s.contextMenuOptions.isCell=function(){return p.target.isRow&&S.getColumnInfo()[p.col]&&S.getRowInfo(p.row)},s.contextMenuOptions.exportToCsv=c.exportToCsv,s.contextMenuOptions.selectAll=s.actions.selectAll,s.contextMenuOptions.showAllColumns=function(){y.showAllColumns(),s.actions.setFocus()},s.contextMenuOptions.showHelp=function(){if(!p.target.isRow&&!p.target.isHeader&&!p.target.isFooter)return;const e=S.getColumnInfo()[p.col];e&&e.helpKeyword&&(c.showHelp(e.helpKeyword),s.actions.setFocus())},s.contextMenuOptions.viewSource=function(){if(!p.target.isRow)return!1;const e=S.getRowInfo(p.row);T(e)&&c.viewSource(p.row,e)},s.searchData.next=function(){s.searchData.foundItemCount<=1||s.searchData.foundItems&&s.searchData.currentFoundItem&&function(e){const t=e.item.rowIndex;if(!M(t))return void H();e.entryIndex<e.item.entries.length-1?(++e.entryIndex,S.changed.raise([{row:t}])):k(e)&&(!function(e){++e.cellIndex,e.cellIndex>=s.searchData.foundItems.cells.length?s.searchData.foundItems.next?(e.cellIndex=-1,e.item=s.searchData.foundItems.next.cell):(e.cellIndex=0,e.item=s.searchData.foundItems.cells[e.cellIndex]):e.item=s.searchData.foundItems.cells[e.cellIndex];e.entryIndex=0}(e),v(e,t))}(s.searchData.currentFoundItem)},s.searchData.previous=function(){s.searchData.foundItemCount<=1||s.searchData.foundItems&&s.searchData.currentFoundItem&&function(e){const t=e.item.rowIndex;if(!M(t))return void function(){const e=y.rightGrid.gridBody.getVisibleRowsRange(),t=s.searchData.foundItems.cells?s.searchData.foundItems.cells.length-1:-1;s.searchData.currentFoundItem=void 0;for(let o=t;o>=0;--o){const{rowIndex:t}=s.searchData.foundItems.cells[o];if(t<=e.last){s.searchData.currentFoundItem={item:s.searchData.foundItems.cells[o],cellIndex:o,entryIndex:s.searchData.foundItems.cells[o].entries.length-1},t<e.first&&y.rightGrid.gridBody.rowVisibleCenter(t),S.changed.raise([]);break}}!s.searchData.currentFoundItem&&s.searchData.foundItems.previous&&(s.searchData.currentFoundItem={item:s.searchData.foundItems.previous.cell,cellIndex:-1,entryIndex:s.searchData.foundItems.previous.cell.entries.length-1},y.rightGrid.gridBody.rowVisibleCenter(s.searchData.currentFoundItem.item.rowIndex))}();e.entryIndex>0?(--e.entryIndex,S.changed.raise([{row:t}])):k(e)&&(!function(e){--e.cellIndex,e.cellIndex<0?s.searchData.foundItems.previous?(e.cellIndex=-1,e.item=s.searchData.foundItems.previous.cell):(e.cellIndex=s.searchData.foundItems.cells.length-1,e.item=s.searchData.foundItems.cells[e.cellIndex]):e.item=s.searchData.foundItems.cells[e.cellIndex];e.entryIndex=e.item.entries.length-1}(e),v(e,t))}(s.searchData.currentFoundItem)};const y=d.create(r[0],"0");y.rightGrid.gridBody.expandLastColumn(!1),s.actions.onCellMouseDown&&y.centralGrid.gridBody.area.addEventListener("mousedown",s.actions.onCellMouseDown,!0),y.onChangeCentralColumnWidth.subscribe(null,(function(e){e&&(s.storageState.splitterPosition=e,s.persistState())})),y.onContextMenu.subscribe(null,((e,t,o,n)=>{o.stopPropagation=!1,p={target:n,row:e,col:t},n.isRow||n.isHeader||n.isFooter?(s.contextMenuOptions.format=S.getColumnInfo()[t].format,s.contextMenuOptions.availableFormats=S.getColumnInfo()[t].availableFormats):(s.contextMenuOptions.format=void 0,s.contextMenuOptions.availableFormats=void 0),s.$apply()})),y.onDblClick.subscribe(null,(e=>{const t=S.getRowInfo(e);s.changeFocusFunctionCallback?t.objectid&&s.changeFocusFunctionCallback(t.objectid):s.actions.onCellDblClick?s.actions.onCellDblClick(e,t):T(t)&&c.viewSource(e,t)})),y.onSetFocus.subscribe(this,(()=>{s.actions.processSetFocus&&s.actions.processSetFocus()})),y.onShowTooltip.subscribe(this,((o,a,r,i,c,l,u)=>{const d=S.getColumnInfo()[c];i<0&&d&&d.barSegments&&(r+='<div class="ui list bar-segments-list">'+_.reduce(d.barSegments,((e,t)=>e+`<div class="item"><span class="bar" style="color: ${n.toRgba(t.color)}"></span>${t.caption}</div>`),"")+"</div>"),u.completed=!0;let f="grid-tooltip";const m=$(l),[h]=e(`<div>${r}</div>`)(s);if(m.hasClass("issue")?f="issue":m.hasClass("low_confidence")&&(f="low-confidence"),!g||g.row!==i||g.col!==c){V();const e=t(m,h,f);g={row:i,col:c},Object.assign(g,e),g.show()}}));const S=f.create(I);function v(e,t){M(e.item.rowIndex)||y.rightGrid.gridBody.rowVisibleCenter(e.item.rowIndex);const o=[{row:t}];e.item.rowIndex!==t&&o.push({row:e.item.rowIndex}),S.changed.raise(o)}function R(e,t){let n=t.format,a="";if(t.isGrouping){const o=t.levels||{},s=o[e.level]||o[o.length-1]||{};n=s.format,a=s.aliasForUnknown}const s=D[n]||{textFormat:"default",showText:!0,showBar:!1};return{textFormatter:o(s.textFormat,a,function(e,t,o){if(!t.cells)return;const n=t.cells[o.id];if(n)switch(e){case"percent":return n.percentageBaseDefault;case"percent_by":return n.percentageBaseCustomMetric;default:return o.maxPerUnitOfMeasure}}(s.textFormat,e,t)),showText:s.showText,showBar:s.showBar}}function B(e,t){if(s.searchData.foundItems){const o=s.searchData.foundItems.cells?s.searchData.foundItems.cells.length:0;for(let n=0;n<o;++n){const o=s.searchData.foundItems.cells[n];if(e===o.rowIndex&&t===o.columnIndex)return n}}return-1}function T(e){return e&&e.isDivable&&!S.isMultiSelection}function M(e){const t=y.rightGrid.gridBody.getVisibleRowsRange();return e>=t.first&&e<=t.last}function O(){const e=y.rightGrid.gridBody.columnsVisModel,[t]=S.getColumnInfo();if(!e||!t)return;return[{width:"0",autoSize:!0,format:"",expanded:!0,visible:!0,id:{query:t.query,flag:t.queryFlag}}].concat(function e(t){const o=[],n=t.getChildrenCount();for(let a=0;a<n;++a){const n=t.getChild(a),s=n.getDataIndex(),r=S.getColumnInfo()[s];r&&o.push({width:n.getWidth(),autoSize:n.isAutoSize(),format:r.format,expanded:n.getState()!==i.HeaderItemState.collapsed,visible:n.isVisible(),id:{query:r.query,flag:r.queryFlag},columns:e(n)})}return o}(e))}function H(){s.searchData.currentFoundItem=void 0;const e=y.rightGrid.gridBody.getVisibleRowsRange(),t=s.searchData.foundItems.cells?s.searchData.foundItems.cells.length:0;for(let o=0;o<t;++o){const{rowIndex:t}=s.searchData.foundItems.cells[o];if(t>=e.first){s.searchData.currentFoundItem={item:s.searchData.foundItems.cells[o],cellIndex:o,entryIndex:0},t>e.last&&s.actions.bringRowToView(t),S.changed.raise([]);break}}!s.searchData.currentFoundItem&&s.searchData.foundItems.next&&(s.searchData.currentFoundItem={item:s.searchData.foundItems.next.cell,cellIndex:-1,entryIndex:0},y.rightGrid.gridBody.rowVisibleCenter(s.searchData.currentFoundItem.item.rowIndex))}function k(e){return!(e.cellIndex<0||s.searchData.foundItems.cells.length<=e.cellIndex||e.item.rowIndex!==s.searchData.foundItems.cells[e.cellIndex].rowIndex||e.item.columnIndex!==s.searchData.foundItems.cells[e.cellIndex].columnIndex)||!s.searchData.foundItems.cells||s.searchData.foundItems.cells.some((function(t,o){return t.rowIndex===e.item.rowIndex&&t.columnIndex===e.item.columnIndex&&(e.cellIndex=o,!0)}))}function V(){g&&(g.remove(),g=void 0)}function A(){y.hideTooltip(),V()}S.doEscapeHTML=function(e){return e},S.getCell=function(e,t){const o=Object.getPrototypeOf(this).getCell.call(this,e,t);if(s.searchData.foundItems){if((s.searchData.showSearchDialog?B(e,t):-1)>-1){const n={innerHTML:o,style:{textOverflow:"clip"}},a=s.searchData.currentFoundItem;if(o&&a.item.rowIndex===e&&a.item.columnIndex===t){const e=h.getContentLayout(o,this.grid.area,!0),s=e.search[a.entryIndex];s.contentWidth=e.contentWidth,s.useScrollLeft=t>0,setTimeout((()=>{y.columnToVisible(t,s)}),10),t>0&&(n.scrollLeft=s.left)}return n}}return o},S.getCellData=function(e,t,o,a){const r=e.cells[t.id].value,{format:i,formattedValue:c}=function(o){const n=R(e,t);return{format:n,formattedValue:h.escapeHTML(n.showText?n.textFormatter(o):"")}}(r);return function(c){if(c=function(e,t,o){const n=s.searchData.showSearchDialog?B(t,o):-1;if(!e||-1===n||!s.searchData.foundItems)return e;const a=s.searchData.currentFoundItem,r=a&&a.item.rowIndex===t&&a.item.columnIndex===o?{currentIndex:a.entryIndex}:{},i=h.escapeHTML(s.searchData.searchKey);if(!i)return e;function c(e,t){const o=e.length;let n,a=0;const s=[];for(;(n=t.indexOf(e,a))>-1;)s.push({start:n,end:n+o}),a=n+o;return s}return e=h.decorateSearchPositions(e,c(i.toLowerCase(),e.toLowerCase()),r)}(c,o,a),i.showBar){const o=i.textFormatter(t.barMax).length+"ch";c=h.decorateValueEx(c,o,function(o){const a=t.barMax,s=e.cells[t.id];if(!a||!s)return[];let r;switch(t.barType){case"diff":return r=[{width:(o>=0?a:a-Math.abs(o))/(2*a)*100+"%",classes:["hidden","bar-segment"]},{width:Math.abs(o)/(2*a)*100+"%",color:n.toRgba(t.color),classes:["single","bar-segment"]}],r.classes=["diff","bar"],r;case"stacked":return r=(s.barSegments||[]).map((function(e){return{width:e.value/a*100+"%",color:n.toRgba(t.barSegments[e.id].color),classes:["bar-segment"]}})),r.classes=["bar"],r;default:return r=[{width:o/a*100+"%",color:n.toRgba(t.color),classes:["single","bar-segment"]}],r.classes=["bar"],r}}(r))}s.actions.addCellHTMLContent&&(c=s.actions.addCellHTMLContent(c,e,t,o));return c}(c)},S.getCellStyle=function(e,t,o,n,a){const r=[],i=S.getColumnInfo()[a],c=S.getRowInfo(n);if(!c||!i)return"";const l=c.cells&&c.cells[i.id]?c.cells[i.id]:{};return!1===l.isReliable?r.push("low_confidence"):l.issueMask>0&&r.push("issue"),s.actions.getCellStyle&&r.push(s.actions.getCellStyle(c,i)),c.isHighlighted&&r.push("idvcgrid_highlighted_row"),r.push(Object.getPrototypeOf(this).getCellStyle.call(this,e,t,o,n,a)),r.join(" ")},S.getCellTooltip=function(e,t){const o=S.getColumnInfo()[t],n=S.getRowInfo(e);return c.getCellTooltip(n,o)},S.getColumnCaption=function(e,t){const o=S.getColumnInfo()[e];if(!o)return;const a=o.barSegments&&t.state===i.HeaderItemState.collapsed&&D[o.format].showBar;o&&o.isData&&o.expansionText&&o.expansionText.length&&(o.caption=o.shortCaption,(t.state!==i.HeaderItemState.collapsed||a)&&(o.caption=[o.caption,s.messages["%ByLabel"],o.expansionText].join(" "))),a&&(t.height-=t.levelHeight);let r=Object.getPrototypeOf(this).getColumnCaption.call(this,e,t);if(s.actions.getColumnPrefix){const t=s.actions.getColumnPrefix(o,e);t&&(r=t+r)}if(a){const e=Object.keys(o.barSegments).map((function(e){const t=o.barSegments[e];return{color:n.toRgba(t.color),text:t.caption,colorClasses:["marker"],textClasses:["caption"]}}));e.classes=["legend"],r=h.buildHeaderWithLegend(r,e)}return r},S.getColumnDescription=function(e){const t=S.getColumnInfo()[e],o=[];let n;return o.push(t.caption),t.description&&(o.push(""),o.push(t.description)),t.formula&&o.push(s.messages["%FormulaLabel"]+t.formula),t.isSelf?n=s.messages["%SelfDataTooltip"]:t.isTotal&&(n=s.messages["%TotalDataTooltip"]),n&&(o.push(""),o.push(n)),o.join("<br/>")},S.getColumnLayout=function(e){const t=this.getColumnInfo()[e];let o;return s.actions.getColumnLayout&&(o=s.actions.getColumnLayout(t)),t&&t.isData&&"string"!==t.format&&(o=o||{},o.textAlign="right"),o},S.getFooter=function(e){const t=S.getColumnInfo()[e];return this.footerData&&t?function(e,t){if(!t.cells)return"";const o=t.cells[e.id];if(!o)return"";const n=o.value;if(null===n)return"";const a=R(t,e);return a.textFormatter(n)}(t,this.footerData):""},S.onChangeCurrentRow=function(e,t){const o=S.getRowInfo(e);c.selectRow(e,o?o.id:"",t)},S.onupdatevisible=c.onUpdateVisible,S.processExpandRow=c.onExpandRow,S.processSortColumn=function(e,t){c.onSortColumn(e,t).then((function(){const e=S.getColumnInfo()[S.sorting.col];e&&(s.storageState.sortOrderAscending=!S.sorting.forward,s.storageState.sortedColumn={query:e.query,flag:e.queryFlag},s.persistState())}))},c.buildColumnState=function(){const e=s(y.leftGrid.gridBody.columns),t=s(y.centralGrid.gridBody.columns),o=(n=y.rightGrid.gridBody.columnsVisModel)&&n.getChildrenCount()?a(n):[];var n;return[].concat(e,t,o);function a(e){const t=[],o=e.getChildrenCount();for(let n=0;n<o;++n){const o=e.getChild(n),s=o.getDataIndex();let r="";const c=S.getColumnInfo()[s];c&&(r=c.format),t.push({dataIndex:s,format:r,isCollapsed:o.getState()===i.HeaderItemState.collapsed,isHidden:!o.isVisible(),children:a(o)})}return t}function s(e){if(!e)return;const t=[];return e.forEach((e=>{t.push({dataIndex:e.dataIndex,format:"",isCollapsed:!1,isHidden:!1})})),t}},c.refreshmetadata=function(e){let t;if(!e)return S.setColumnInfo([]),void y.setDataModel(S,i.createHeaderVisModel(),C);e.columnHierarchy&&(t=i.createHeaderVisModel(),s.storageState&&function(e,t,o){if(!e.columns)return;const n=function(e,t,o){function n(e){const t=o[e.dataIndex];return t?t.queryFlag+t.query:""}function a(e){return e.id.flag+e.id.query}function s(e,t){return e.map((e=>{let o=t(e);return e.columns&&(o+=s(e.columns,t)),o})).sort().join(":")}if(void 0===e||void 0===t)return!1;return s(e,n)===s(t,a)}(e.columns,t,o);!function e(t,n,a){if(!t.columns)return;const s=[];n&&n.length>0&&n.forEach((n=>{let r,i=0;for(;i<t.columns.length;++i){const e=t.columns[i],a=o[e.dataIndex];if(a&&n.id.query===a.query&&n.id.flag===a.queryFlag){r=e;break}}void 0!==r&&(r.isHidden=!1===n.visible,r.width=n.width,r.autoSize=n.autoSize,r.isCollapsed=!n.expanded,function(e,t,o){if(void 0===e||""===e)return;const n=o[t];n&&n.availableFormats&&n.availableFormats.some((t=>t.id===e))&&(n.format=e)}(n.format,r.dataIndex,o),e(r,n.columns,a),a&&(s.push(r),t.columns.splice(i,1)))})),a&&(t.columns=s)}(e,t,n)}(e.columnHierarchy,s.storageState.columns,e.columns),function t(o,n){n.columns&&n.columns.forEach((n=>{if(n.dataIndex>C){const a=o.addChild(n.dataIndex);n.width&&a.setWidth(n.width),n.autoSize&&a.setAutoSize(n.autoSize),a.setMaxAutoSizeWidth("40em"),n.isHidden&&a.setVisible(!1);const s=e.columns[n.dataIndex];s.isCollapsible?n.isCollapsed&&a.setState(i.HeaderItemState.collapsed):a.setState(i.HeaderItemState.simple),s.barSegments&&(a.getHeight=function(){return this.getState()===i.HeaderItemState.collapsed?2:1}),t(a,n)}}))}(t,e.columnHierarchy),t.onChange.subscribe(void 0,(e=>{e&&(s.searchData.foundItems&&(c.clearSearchResults(),S.changed.raise([])),c.postColumnState());const t=O();t&&(s.storageState.columns=t,s.persistState())}))),s.storageState&&s.storageState.splitterPosition&&(x=s.storageState.splitterPosition),y.setDataModel(void 0,void 0,-1),S.setColumnInfo(e.columns),c.refreshVisible(e,!0),y.setDataModel(S,t,C),y.setCentralColumnWidth(x)},c.refreshVisible=function(e,t){if(!e)return;if(S.isMultiSelection=e.view&&e.view.multiselection,t=t||w,w=!1,e.selectionUpdate){S.testRows((e=>e.isHighlighted))?(S.forceUpdate(e.view.startRow),S.updateRowsBuffer(e.view,e.rows,t)):S.updateSelection(e.view,e.rows)}else S.updateRowsBuffer(e.view,e.rows,t);if(e.view&&e.view.focusColumnIndex&&setTimeout((()=>{y.columnToExpanded(e.view.focusColumnIndex).then((()=>{y.columnToVisible(e.view.focusColumnIndex)}))})),S.footerData||(S.footerData={}),!S.getColumnInfo()[C])return y.hideFooter();const o=S.getColumnInfo()[C].id,n=S.footerData.rowCount;e.footerRow&&e.footerRow.cells?Object.assign(S.footerData,e.footerRow):S.footerData={},S.footerData.rowCount!==n&&(S.footerData.rowCount?(S.footerData.cells[o].value=`Selected ${S.footerData.rowCount} rows:`,n||y.showFooter()):y.hideFooter(),y.updateFooter())},c.processSearchResponse=function(e){s.searchData.foundItems=e.data.search,s.searchData.foundItems&&s.searchData.foundItems.foundItemCount?H():S.changed.raise([])}}))}}}]);
"use strict";angular.module("services").factory("helpTour",["$compile","$rootScope","$http","$q","productConstants","localize","statistics",function(t,e,n,i,o,a,s){const r=new Map;let c,u,l,d,p,f,h,g=-1,m={};const v={};function y(){h||(h=new Promise((t=>n.get("api/global-storage",{params:{identity:o.commonIdentity,sectionName:"helptours",property:"passState"}}).then((e=>{e&&e.data&&(e.data.passState&&(m=e.data.passState),t())})))))}function P(t,e=15){return i((n=>{!function i(){const o=B(t);o||!e?n(o):(--e,setTimeout(i,3e3))}()}))}function w(t){const e=u[g];if(e.actions)if(t){if(e.actions.activatePane)return e.actions.activatePane(),P(e)}else if(e.actions.activatePreviousPane)return e.actions.activatePreviousPane(),P(e);return B(e)}function E(){if(l)return{description:u[g].description,element:l,stepNumber:g+1,totalSteps:u.length}}function S(){return i.resolve().then((async()=>{let t;for(;!t&&++g<u.length;)t=await w(!0);t?(l=t,p&&s.notifyFeatureUsage("helpTour.step"+g)):C()}))}function b(){return i.resolve().then((async()=>{let t;for(;!t&&--g>=0;)t=await w(!1);t?(l=t,p&&s.notifyFeatureUsage("helpTour.step"+g)):C()}))}function C(){c.hide(),g=-1,l=void 0,u=void 0,d=void 0,p=void 0}function T(){return n.post("api/global-storage",{value:m},{params:{identity:o.commonIdentity,sectionName:"helptours",property:"passState"}})}function $(t){u=r.get(t),u&&(p="gettingStarted"===t,S().then((()=>{l&&c.show(),d&&function(t){m[t]||(m[t]=!0,T())}(t)})))}function B(t){if(t.actions&&t.actions.findElement)return t.actions.findElement();if(t.id){const e=document.body.querySelectorAll(`[data-tour-item="${t.id}"]`);for(const n of e){if(D(n))continue;if(!(!!t.checkOverlapDepth&&x(n,t.checkOverlapDepth))&&k(n))return n}}}function R(t,e,n){setTimeout((()=>{!e.every((t=>B(t)))&&--n?R(t,e,n):f||$(t)}),3e3)}function k(t){const e=t.getBoundingClientRect();return e.top>=0&&e.bottom<=window.innerHeight+.3*e.height&&e.left>=0&&e.right<=window.innerWidth+.3*e.width}function x(t,e=5){const n=t.getBoundingClientRect();let i=e;for(;(t=t.parentElement)&&--i;){const e=t.getBoundingClientRect();if(!(e.width<1&&e.height<1)&&(n.x<e.left||n.x+n.width>e.right||n.y<e.top||n.y+n.height>e.bottom))return!0}return!1}function D(t){const e=t.getBoundingClientRect();return!(e.width&&e.height)}return function(){c=e.$new(!0),c.getItemData=E,c.next=S,c.previous=b,c.stop=C;const[n]=t("<tour-overlay></tour-overlay>")(c);document.body.appendChild(n)}(),{register(t,e){if(r.has(t))return;const n=e.map((t=>t.description));r.set(t,void 0),v[t]=a(n,"htmlutil1").then((n=>{e.forEach((t=>{t.description=n[t.description]})),r.set(t,e)}))},unregister(t){r.delete(t)},start(t,e=!0){d=e,y(),$(t)},autostart(t,e=!0){!u&&r.has(t)&&(f=void 0,d=e,y(),i.all([n.get("api/features/state",{params:{feature:"suppress-automatic-help-tours"}}).then((t=>t.data.enabled)),v[t],h]).then((([e])=>{if(!e&&!m[t]){const e=r.get(t).filter((t=>t.keyElement));R(t,e,10)}})))},stop(){f=!0,u&&C()},setTourStepActions(t,e,n){if(r.has(t)){const i=r.get(t).find((t=>t.id===e));i&&(i.actions?(n.activatePane&&(i.actions.activatePane=n.activatePane),n.findElement&&(i.actions.findElement=n.findElement),n.activatePreviousPane&&(i.actions.activatePreviousPane=n.activatePreviousPane)):i.actions=n)}},isElementWithinWindowBounds:k,isElementOverlapped:x,updatePassStates:function(t){t.forEach((t=>{m[t]=!0})),T()}}}]);
"use strict";angular.module("widgets").directive("startTour",["$timeout","helpTour",function(t,r){return{restrict:"A",link:function(n,i,o){function u(){return t((()=>r.start(o.startTour)))}i.on("click",u),n.$on("$destroy",(function(){i.off("click",u)}))}}}]);
"use strict";angular.module("extension-ui").factory("ideCallbacks",["$q",function(e){return new class{configureAnalysis(l={}){return e.resolve(window.ideCallbacks.configureAnalysis(l.analysisId))}openURLExternal(l){return e.resolve(window.ideCallbacks.openUrlExternal(l))}openResult(l){return e.resolve(window.ideCallbacks.openResult(l.result1Path,l.result2Path))}showOpenDialog(l={}){return e.resolve(window.ideCallbacks.showOpenDialog(l.dialogType,l.dialogTitle,l.defaultPath,l.defaultFileName,l.fileFilter,l.multiSelect))}showSaveDialog(l={}){return e.resolve(window.ideCallbacks.showSaveDialog(l.dialogTitle,l.defaultPath,l.defaultFileName,l.fileFilter))}onResultOpened(l){if(window.ideCallbacks.onResultOpened)return e.resolve(window.ideCallbacks.onResultOpened(l.result1Path,l.result2Path))}onSessionClose(){if(window.ideCallbacks.onSessionClose)return e.resolve(window.ideCallbacks.onSessionClose())}}}]);
"use strict";angular.module("extension-ui").factory("ideIntegrationManager",["$http","$q","error","fileDialog","ideCallbacks","localize","productConstants",function(e,t,n,o,s,r,a){return new class{configureAnalysis(e={}){return s.configureAnalysis(e)}constructResultCaption(e){const t=e.parentProject||r.synchronously("%NoProjectCaption","collectionapi");return t?`${e.name} [${t}]`:void 0}openRecentResult(t,o){return e.post("api/product/results/validate",{path:t.path},this._makeRequestParams()).then(n.validateResponse).then((e=>{if(e.isValid)return this.openResult({result1Path:t.path});o&&o(e)}))}openResult(e){return e&&e.result1Path?s.openResult(e):r("%ResultFileFilter","collectionapi").then((e=>this.showOpenDialog({dialogType:"open",fileFilter:e}))).then((e=>{e&&this.openResult({result1Path:e})}))}showOpenDialog(e={}){return o.showOpenDialog(e)}showSaveDialog(e={}){return o.showSaveDialog(e)}onResultOpened(e){return s?s.onResultOpened(e):t.resolve()}onSessionClose(){return s?s.onSessionClose():t.resolve()}_makeRequestParams(e){return{params:{identity:a.commonIdentity},...e}}}}]);
"use strict";angular.module("loading").directive("loading",(function(){return{restrict:"E",replace:!0,scope:{showWhen:"=",message:"@"},template:'<div ng-show="showWhen" class="loading control" localize="localize" default-msg-catalog="viewmodelbase1"><span class="icon circle-third spin"></span> {{::(message || localize(\'%LoadingLabel\'))}}</div>'}}));
"use strict";angular.module("metric").controller("MetricController",["$scope","$compile",function(e,t){e.issue=e.metricData&&!1!==e.metricData.confidence&&!!e.metricData.issuesMask,e.lowConfidence=e.metricData&&!1===e.metricData.confidence,(()=>{if(e.metricData){const[i]=t('<metric-tooltip tooltip-data="metricData"></metric-tooltip>')(e);i&&setTimeout((()=>{const t=new RegExp(' ng-\\w+=\\"[a-zA-Z0-9_ \\$:]+\\"| *ng-binding| *ng-scope|\x3c!-- [a-zA-Z0-9_ \\$:]+ --\x3e',"g");e.valueTooltip=i.innerHTML.replace(t,"")}))}})()}]);
"use strict";angular.module("metric").directive("metric",(function(){return{restrict:"E",scope:{metricData:"="},template:'<div class="metric-parent"><span ng-class="::{\'help-cursor\': metricData.description}" ng-if="::(!metricData.valueOnly)" tooltip="{{ ::metricData.description }}"><span class="name">{{ ::metricData.name }}</span> <span class="icon help-circle light" ng-show="::metricData.description"></span> <span class="delimiter">:</span> </span><span class="value help-cursor" ng-class="::{issue: issue, \'low-confidence\': lowConfidence}" tooltip-class="{{ ::(issue ? \'issue\' : (lowConfidence ? \'low-confidence\' : \'default\')) }}" tooltip="{{ ::valueTooltip }}">{{ ::metricData.formattedValue || N/A }} <span class="icon flag-o" ng-if="::issue"></span></span></div>',controller:"MetricController"}}));
"use strict";angular.module("modalDialog").directive("modalDialog",["$timeout",function(e){return{restrict:"E",replace:!0,transclude:!0,scope:{onClose:"<?"},link:function(o,t,i){function d(t){27===t.keyCode&&o.onClose&&e(o.onClose)}o.dialogStyle={},i.width&&(o.dialogStyle.width=i.width),i.height&&(o.dialogStyle.height=i.height),document.addEventListener("keydown",d),o.$on("$destroy",(function(){document.removeEventListener("keydown",d)}))},template:'<div class="modal-dialog-root overlay"><div class="modal-dialog-container" ng-style="::dialogStyle"><div class="modal-dialog-content" ng-transclude></div></div></div>'}}]);
"use strict";angular.module("services").factory("metricPassportConfiguration",["issues",function(e){return{fill(t,r){if(!r.description)return;const a=t.cells[r.index-1],i=e.get(r,t);let n,s;a.min||a.max?(n=a.min?parseFloat(a.min):0,s=a.max?parseFloat(a.max):1/0):["time","_double_","frequency","timeAndBar"].includes(r.format)?(n=0,s=1/0):"ratio"===r.format&&(n=0,s=100);return{name:r.name,value:a.formattedNum?parseFloat(a.formattedNum.replace(",","")):a.value,formattedValue:a.formattedValue,rangeMin:n,rangeMax:s,unit:a.unit,postfix:r.unitOfMeasure?r.unitOfMeasure.name:void 0,description:r.description,threshold:a.threshold?parseFloat(a.threshold.replace(",","")):void 0,minIsBetter:void 0!==a.minIsBetter&&null!==a.minIsBetter?a.minIsBetter:void 0,issue:i}}}}]);
"use strict";angular.module("metricPassport").controller("metricPassportController",["$scope",function(t){t.getRange=function(){if(t.metricData.rangeMax===1/0){let e=t.metricData.value;return void 0!==t.metricData.threshold&&t.metricData.threshold>e&&(e=t.metricData.threshold),100*(e-t.metricData.rangeMin)/60}return t.metricData.rangeMax-t.metricData.rangeMin},t.isMetricBarVisible=()=>void 0!==t.metricData.value&&null!==t.metricData.value&&void 0!==t.metricData.rangeMin&&void 0!==t.metricData.rangeMax&&t.metricData.rangeMin<=t.metricData.value&&t.metricData.value<=t.metricData.rangeMax,t.isRedFlagZone=()=>void 0!==t.metricData.minIsBetter&&void 0!==t.metricData.threshold&&t.metricData.rangeMin<t.metricData.threshold&&t.metricData.threshold<t.metricData.rangeMax,t.isTuningPotential=()=>t.isRedFlagZone()&&(t.metricData.minIsBetter&&t.metricData.value>=t.metricData.threshold||!t.metricData.minIsBetter&&t.metricData.value<=t.metricData.threshold),t.isMinIsBetter=()=>void 0!==t.metricData.minIsBetter&&t.metricData.minIsBetter,t.isMaxIsBetter=()=>void 0!==t.metricData.minIsBetter&&!t.metricData.minIsBetter,t.isIssue=()=>!!t.metricData.issue,t.getUnit=function(){return t.metricData.unit?t.metricData.unit:""},t.getFormattedUnit=function(){let e="";return void 0!==t.metricData.formattedUnit?e=t.metricData.formattedUnit:void 0!==t.metricData.unit&&(e=t.metricData.unit),void 0!==t.metricData.postfix&&(e=e+" "+t.metricData.postfix),e},t.getFormattedValue=()=>t.metricData.formattedValue?t.metricData.formattedValue:t.metricData.value+t.getUnit(),t.getName=function(){return t.metricData.name?t.metricData.name+(t.getFormattedUnit()?", "+t.getFormattedUnit():""):""},t.getMin=()=>t.metricData.rangeMin+t.getUnit(),t.getMax=function(){return t.metricData.rangeMax===1/0?"∞":t.metricData.rangeMax+t.getUnit()},t.getThreshold=()=>t.metricData.threshold+t.getUnit(),t.getTuningPotentialSize=function(){return t.isTuningPotential()?100*Math.abs(t.metricData.value-t.metricData.threshold)/t.getRange():0},t.getRedFlagZoneSize=()=>{let e=0;if(t.isRedFlagZone()){const a=100*(t.metricData.threshold-t.metricData.rangeMin)/t.getRange();return e=t.metricData.minIsBetter?100-a:a,t.isTuningPotential()?e-t.getTuningPotentialSize():e}return e},t.getGreenZoneSize=()=>{let e=100;if(t.isRedFlagZone()){const a=100*(t.metricData.threshold-t.metricData.rangeMin)/t.getRange();e=t.metricData.minIsBetter?a:100-a}return e},t.getValuePosition=function(){return 100*(t.metricData.value-t.metricData.rangeMin)/t.getRange()},t.getThresholdPosition=()=>100*(t.metricData.threshold-t.metricData.rangeMin)/t.getRange(),t.getIssues=function(){return Array.isArray(t.metricData.issue)?t.metricData.issue:[t.metricData.issue]},t.getAdvancedDescriptions=function(){return Array.isArray(t.metricData.advancedDescriptions)?t.metricData.advancedDescriptions:[t.metricData.advancedDescriptions]}}]);
"use strict";angular.module("metricPassport").directive("metricPassport",(function(){return{restrict:"E",scope:{metricData:"="},template:'<div class="metric-passport"><div class="name">{{ ::getName() }}</div><div class="range" ng-if="::isMetricBarVisible()" ng-class="::{ \'min-is-better\': isMinIsBetter() }"><div class="red-flag-zone" ng-if="::isRedFlagZone()" ng-class="::{ \'adjacent-tuning-potential\': isTuningPotential() }" ng-style="::{ \'width\': getRedFlagZoneSize() + \'%\' }"></div><div class="tuning-potential" ng-if="::isTuningPotential()" ng-style="::{ \'width\': getTuningPotentialSize() + \'%\' }"></div><div class="green-zone" ng-style="::{ \'width\': getGreenZoneSize() + \'%\' }"></div><div class="value-pointer" ng-style="::{ \'left\': getValuePosition() + \'%\' }"><div class="value">{{ ::getFormattedValue() }}</div><div class="caret"></div></div><div class="min" ng-value="::getMin()"></div><div class="threshold" ng-if="::isRedFlagZone()" ng-style="::{ \'left\': getThresholdPosition() + \'%\' }" ng-value="::getThreshold()"></div><div class="max" ng-value="::getMax()"></div></div><div class="legend" ng-if="::isMetricBarVisible()"><div ng-if="::isMinIsBetter()">&#8592;&nbsp;better</div><div class="red-flag-zone" ng-if="::isRedFlagZone()">red flag zone</div><div class="tuning-potential" ng-if="::isTuningPotential()">tuning potential</div><div ng-if="::isMaxIsBetter()">better&nbsp;&#8594;</div></div><div class="description padding" html-content="{{metricData.description}}"></div><div ng-if="metricData.advancedDescriptions"><ul><div ng-repeat="description in ::getAdvancedDescriptions()"><li><span ng-if="description.issue" class="description-issue icon flag-o"></span><span ng-class="{\'description-issue\': description.issue}" class="description-value" html-content="{{description.value}}"></span>&nbsp;<span class="description" html-content="{{description.text}}"></span></li></div></ul></div><div ng-if="::isIssue()"><div class="issue padding" ng-repeat="issue in ::getIssues()"><span class="icon flag-o"></span> <span html-content="{{issue}}"></span></div></div></div>',controller:"metricPassportController"}}));
"use strict";angular.module("notification").directive("notificationPosition",["$compile",function(i){return{restrict:"A",controller:()=>{},link:function(o,n,t,c){c.showNotification=(t,c,e)=>{let s;if(t){s=$("<div/>",{class:`notification ${c}`});const a=$("<div/>",{class:"icon cross",click:d}),l=i(`<div>${t}</div>`)(o)[0].childNodes;s.append(...l),s.append(a),n.append(s),e&&setTimeout(d,e)}function d(){s&&(s.remove(),s=void 0)}}}}}]);
"use strict";angular.module("notification").directive("notification",(function(){return{restrict:"E",replace:!0,transclude:!0,scope:{type:"=",message:"=?",onClose:"&"},template:'<div class="notification" ng-class="type"><div class="text">{{message}}<ng-transclude></ng-transclude></div><div class="icon cross" ng-click="onClose()"></div></div>'}}));
"use strict";angular.module("notification").directive("showNotification",(function(){return{restrict:"A",require:"^notificationPosition",link:function(i,t,o,n){i[o.showNotification]=(i,t,o)=>n.showNotification(i,t,o)}}}));
"use strict";angular.module("overflowTooltip").directive("overflowTooltip",(function(){return{restrict:"A",link:function(t,i){i.bind("mouseover",(function(){this.offsetWidth<this.scrollWidth&&!i.attr("title")&&i.attr("title",i.text())}))}}}));
"use strict";angular.module("ui").factory("productConstants",(function(){return{commonIdentity:"common",resultState:{init:"init",loading:"loading",ready:"ready",blocked:"blocked"}}}));
"use strict";angular.module("ui").factory("productExtensionEventHandlers",["$q","optionsDialogService","productManager",function(e,o,n){return{init(t,i={},c={}){const r={"analysis:configure:action":n.configureAnalysis,"import:open:action":n.importResult,"result:compare:action":n.compareResults,"result:open:action":n.openResult};for(const e in r)t.on(e,(o=>n.waitForInitialization().then((()=>r[e](o))).then((()=>t.emit(e+":complete")))));const a={"about:open:action":i.openAboutDialog,"options:open:action":()=>o.show()};for(const o in a)t.on(o,(()=>{a[o]?e.resolve(a[o]()).then((()=>t.emit(o+":complete"))):t.emit(o+":complete",{error:"No handler for corresponding action..."})}));t.on("result:refinalize:action",(e=>{c.refinalizeResult?c.refinalizeResult(e).then((()=>t.emit("result:refinalize:action:complete"))).catch((e=>t.emit("result:refinalize:action:complete",{error:e}))):t.emit("result:refinalize:action:complete",{error:"Result refinalization is unsupported..."})})),t.on("session:close:action",(()=>{c.onExit?(c.onExit(),t.emit("session:close:action:complete")):t.emit("session:close:action:complete",{error:"No handler for session close action..."})})),t.on("welcome:open:action",(()=>{i.openWelcomePane?i.openWelcomePane().then((()=>t.emit("welcome:open:action:complete"))):t.emit("welcome:open:action:complete",{error:"Welcome page is unavailable..."})}))}}}]);
"use strict";angular.module("ui").factory("productHelp",["$http","$q","productMode","productConstants","userAgent","ideCallbacks",function(t,e,n,o,r,i){const s="client.title_d";let l="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-vtune/top";if(!r.isUnknownOs()){const{os:t}=r;l+=`/${r.isMac()?t:t+"-os"}`}l+=".html";const a="file:///",p="http",c="mailto";function u(t){return t.startsWith(p)||t.startsWith(a)||t.startsWith(c)}function d(t){return w(t=t.startsWith(a)?t:a+t)}function w(t){return n.isElectronMode()?function(t){const n=window.el.openUrlExternal(t);return n?e.resolve():e.reject("Electron app was unable to open external url: "+t)}(t):n.isExtensionMode()?function(t){return i.openURLExternal(t)}(t):function(t){const n=t.startsWith(c)?"_parent":"_blank",o="noopener",r=window.open(t,n,o);return r?e.resolve():e.reject(new Error(`Failed to open ${t} via browser API`))}(t)}function h(e){return u(e)?m(e):t.get("api/product/help/link",{params:{identity:o.commonIdentity,keyword:e}}).then((t=>{if(t&&t.data)return w(t.data.helpLink||"https://www.intel.com/content/www/us/en/develop/documentation/vtune-help/top.html")}))}function m(e){return u(e)?w(e):t.get("api/product/help/documentation/path",{params:{identity:o.commonIdentity,fileName:e}}).then((t=>{if(t&&t.data&&t.data.filePath)return d(t.data.filePath)}))}return{getGettingStartedWebLink:()=>l,getProductHelpKeyword:()=>s,explainHWEvent(t){return this.openInstructionReference(t)},openDeveloperForumPage:()=>m("https://community.intel.com/t5/Analyzers/bd-p/analyzers"),openGettingStarted(){return m(this.getGettingStartedWebLink())},openHelpByKeyword:h,openHelpLink:h,openInstructionReference:t=>m("https://perfmon-events.intel.com/index.html"+(t||"")),openProductHelp(){return this.openHelpByKeyword(s)},openAssemblyInstructionReference:t=>n.isBrowserMode()?m("https://www.intel.com/content/www/us/en/developer/articles/technical/intel-sdm.html"):d(t.path),openTrainingsPage:()=>m("https://www.intel.com/content/www/us/en/developer/tools/oneapi/vtune-profiler.html#linklist_1681889240_"),openWebLink:m}}]);
"use strict";angular.module("ui").factory("productManager",["$http","$q","error","Events","localize","fileDialog","notifications","productConstants","projectItemType","statistics","releaseUpdate",function(e,t,n,r,o,a,u,s,c,i,l){const p=s.commonIdentity;let h=!1;const d=new r,f={},P={currentProjectName:"",currentProjectPath:""},m="project:changed",j="result:opened",R="project:renamed",g="result:renamed",y="result:created",C="results:deleted",w="items:deleted",v={init:function(e){return o(["%ResultFileFilter","%ProjectFileFilter"],"collectionapi").then((e=>Object.assign(f,e))),e.on("result:renamed",(e=>{d.emit(g,e.resultPath)})),e.on("project:renamed",(e=>{d.emit(R,e.projectPath)})),e.on("result:removed",(e=>{d.emit(w,[e.resultPath])})),e.on("workspace:items:removed",(e=>{const t=function(e){let t=[];e.projects&&Array.isArray(e.projects)&&(t=t.concat(e.projects));e.results&&Array.isArray(e.results)&&(t=t.concat(e.results));e.directories&&Array.isArray(e.directories)&&(t=t.concat(e.directories));return t}(e);d.emit(w,t)})),l.init(),t.all([O(),b(),F(),I()]).finally((()=>{h=!0,v.onInit&&v.onInit(),d.emit(m,P.currentProjectPath)}))},isInitialized:()=>h,closeAllResults:function(){if(v.onCloseAllResults)return v.onCloseAllResults()},closeCollectionTab:function(){if(v.onCloseCollectionTab)return v.onCloseCollectionTab()},closeCurrentProject:N,createAndOpenProject:function(t){return e.post("api/product/projects/new",{projectPath:t.projectPath,path:t.location,name:t.name},D()).then(n.validateResponse).then((e=>v.openProject(e.path)))},compareResults:function(e){if(v.onCompareResults)return v.onCompareResults(e)},configureAnalysis:A,constructAnalysisCaption:function(e){if(!e.isPaused)return e.name;const t=o.synchronously("%PausedCaption","collectionapi");return t?`${e.name} ${t}`:void 0},constructResultCaption:function(e){const t=e.parentProject||o.synchronously("%NoProjectCaption","collectionapi");return t?`${e.name} [${t}]`:void 0},createNewProject:function(e){if(v.onCreateNewProject)return v.onCreateNewProject(e)},deleteWorkspaceItems:async function(t){t.some((e=>e.type===c.project&&e.path===P.currentProjectPath))&&await N();const n=t.filter((e=>e.type===c.result)).map((e=>e.path));n.length&&await function(e){if(v.onCloseResults)return v.onCloseResults(e)}(n);return function(t){return e.post("api/product/workspace/items/delete",{items:t},D())}(t)},deleteProjects:function(e){return t.all(e.map((e=>e===P.currentProjectPath?N().then((()=>k(e))):k(e))))},deleteRecentResult:function(n){if(n)return e.post("api/product/recent/delete",{path:n},D()).then((()=>t.all([O(),b()])))},deleteResults:function(e){if(v.onDeleteResults)return v.onDeleteResults(e).then((t=>(d.emit(C,e),t)))},importResult:function(){if(i.notifyFeatureUsage("open.importResult"),P.currentProjectPath&&v.onImportResult)return v.onImportResult()},launchRecentAnalysis:function(e){return A({forceStart:!0,isPaused:e.isPaused,analysisName:e.name})},onProjectChanged:e=>d.on(m,e),onResultOpened:e=>d.on(j,e),onProjectRenamed:e=>d.on(R,e),onResultRenamed:e=>d.on(g,e),onResultCreated:e=>d.on(y,e),onResultsDeleted:e=>d.on(C,e),onItemsDeleted:e=>d.on(w,e),openProject:W,openRecentProject:function(t,n){return e.post("api/product/projects/validate",{path:t.path},D()).then((e=>{if(e.data){if(e.data.isValid)return W(e.data.path);n&&n(e)}}))},openRecentResult:function(t,n){return e.post("api/product/results/validate",{path:t.absolutePath||t.path},D()).then((e=>{if(e.data){if(e.data.isValid)return U({resultName:t.name,result1Path:t.path,resultAbsolutePath:t.absolutePath||""});n&&n(e)}}))},openResult:U,openResults:function(e){if(!e||!e.length)return t.when();if(1===e.length)return U({result1Path:e[0].path});const n=[...e];return t((e=>{function t(){n[0]?r(n.shift()):e()}function r(e){U({result1Path:e.path,activate:!n.length}).then(t)}r(n.shift())}))},processCollectionStart:function(e,n){return t.all([U({identity:n})])},processResultCreate:function(t){return e.post("api/product/results/open",{path:t},{params:{identity:p}}).then((e=>d.emit(y,e.data))).then(T)},processResultImport:function(e){return d.emit(y,{projectPath:P.currentProjectPath}),v.openResult(e)},renameProject:function(n,r){return(n===P.currentProjectPath?N:t.when)().then((()=>e.post("api/product/projects/rename",{path:n,name:r},D()))).then((()=>d.emit(R,n)))},renameResult:function(n,r){return function(e){return(v.onRenameResult?v.onRenameResult:t.when)(e)}(n).then((()=>e.post("api/product/results/rename",{path:n,name:r},D()))).then((()=>d.emit(g,n)))},state:P,waitForInitialization:function(){return h?t.resolve():t((e=>{v.onInit=()=>{e(),delete v.onInit}}))},openWelcomePage:function(){if(i.notifyFeatureUsage("open.welcomePage"),v.onOpenWelcomePage)return v.onOpenWelcomePage()}};function N(n=!0){return P.currentProjectPath?(v.onCurrentProjectClosure?v.onCurrentProjectClosure:t.resolve)().then((()=>e.post("api/product/projects/current/close",{},D()))).then((()=>{if(P.currentProjectName="",P.currentProjectPath="",n)return $()})):t.when()}function A(e){return i.notifyFeatureUsage("open.configureAnalysis"),P.currentProjectPath?v.onConfigureAnalysis?t.resolve(v.onConfigureAnalysis(e)):t.reject(new Error("No handler for requested action")):t.reject(new Error("Can't configure analysis without opened project"))}function F(){return e.get("api/product/projects/last",D()).then(n.validateResponse).then((e=>{e&&!P.currentProjectName&&(P.currentProjectName=void 0!==e.name?e.name:"",P.currentProjectPath=void 0!==e.path?e.path:"")}))}function I(){return e.get("api/product/name",D()).then((e=>{e.data&&e.data.names&&(P.productNames=e.data.names,v.onProductNameResolved&&v.onProductNameResolved(P.productNames.brandName))}))}function O(){return e.get("api/product/projects/recent",D()).then((e=>{e&&e.data&&e.data.projects&&(P.recentProjects=e.data.projects)}))}function b(){return e.get("api/product/results/recent",D()).then((e=>{e&&e.data&&e.data.results&&(P.recentResults=e.data.results)}))}function D(e){const t={params:{identity:p}};return Object.assign(t.params,e),t}function $(e){return O().finally((()=>{d.emit(m,e)}))}function T(){return b().finally((()=>{d.emit(j)}))}function W(r){return r?o(r):z("project").then((e=>{if(e)return o(e)}));function o(r){return r===P.currentProjectPath?t.resolve():N(!1).then((()=>e.post("api/product/projects/open",{path:r},D()))).then(n.validateResponse).then((e=>{if(e&&e.projectChanged)return P.currentProjectPath=e.projectPath,P.currentProjectName=e.projectName,$(P.currentProjectPath)})).catch((()=>{u.warning("%Warning.cannotOpenProject","htmlui1",r,5e3)}))}}function U(r){return r?o(r):(i.notifyFeatureUsage("open.openResultDialog"),z("result").then((e=>{if(e)return o(e)})));function o(r){const o="string"==typeof r?{result1Path:r}:r;return o.result1Path?e.get("api/product/results/project/path",D({resultPath:o.resultAbsolutePath||o.result1Path})).then(n.validateResponse).then((function(e){if(o.result2Path)return;if(e&&e.projectPath){if(!e.projectPath)return N();if(o.projectName=e.projectName||"",P.currentProjectPath!==e.projectPath)return W(e.projectPath)}})).then((function(){if(o.result2Path)return;return e.post("api/product/results/open",{path:o.resultAbsolutePath||o.result1Path},D())})).then((()=>{v.onOpenResult&&v.onOpenResult(o)})).then(T).catch((()=>{u.warning("%Warning.cannotOpenResult","htmlui1",o.result1Path,5e3)})):(v.onOpenResult&&v.onOpenResult(o),t.when())}}function k(t){return e.post("api/product/projects/delete",{path:t},D())}function z(e){return a.showOpenDialog({dialogType:"open",dialogTitle:`Select ${e}`,fileFilter:f["result"===e?"%ResultFileFilter":"%ProjectFileFilter"]},p)}return v}]);
"use strict";angular.module("ui").factory("productMode",(function(){return{isBrowserMode(){return!this.isElectronMode()&&!this.isExtensionMode()},isElectronMode:()=>null!=window.el,isExtensionMode:()=>null!=window.ideCallbacks,isSaaSMode(){return this.isBrowserMode()&&window.location.href.match("/saas-ui/")},getCommandlineParameters:()=>window.el?window.el.getStartupParams():Promise.resolve()}}));
"use strict";angular.module("ui").factory("productGlobalUserEventsHandlers",["$timeout","$http","productMode","productManager","productConstants","productHelp","userAgent",function(e,t,r,n,i,o,s){return{init:u=>{let a=!1;document.addEventListener("keydown",(function(c){const f=s.isMac()?c.metaKey:c.ctrlKey,{keyCode:l}=c,d=function(){if(f){if(-1!==["-","+","=","_"].indexOf(c.key))return()=>{};if(c.altKey&&c.shiftKey&&c.repeat&&!a){const e={67:"accessViolation",83:"assert",66:"abort"}[l];if(e)return a=!0,function(){return t.post("api/product/crash",{crashCause:e},{params:{identity:i.commonIdentity}})}}if(!r.isExtensionMode()){if(!r.isBrowserMode())if(c.altKey){if(78===l)return n.importResult}else if(c.shiftKey){if(79===l)return n.openProject}else if(79===l)return n.openResult;if(c.altKey){if(79===l)return n.compareResults}else if(c.shiftKey){if(78===l)return n.createNewProject}else switch(l){case 78:return n.configureAnalysis;case 81:return u.closeProduct;case 9:return u.switchToNextTab}}}else if(112===l&&u.getHelpKeyword){const e=u.getHelpKeyword();if(e)return function(){return o.openHelpByKeyword(e)}}}();if(d)return c.preventDefault(),c.stopPropagation(),e(d),!1}),!0),window.addEventListener("wheel",(function(e){(s.isMac()?e.metaKey:e.ctrlKey)&&e.preventDefault()})),window.onbeforeunload=(()=>{let e=!1;return function(n){if(r.isElectronMode()){if(n.preventDefault(),n.returnValue=!1,e)return;e=!0,t.post("api/service/stop",{},{params:{identity:i.commonIdentity}})}}})()}}}]);
"use strict";angular.module("ui").factory("releaseUpdate",["$q","$http","productMode","Events","productConstants","productHelp",function(e,t,n,a,o,s){const p=new a,r="release-update",i=o.commonIdentity;let d,u,c;const l={},f={params:{identity:i,sectionName:"suppressedUpdates",property:"suppressed"}};function g(){return function(){const a="https://software.intel.com/sites/products/vtune/updates.json?id="+Date.now().toString();return n.isElectronMode()?e.resolve().then((()=>window.el.externalRequest({url:a}))):t.get(a)}().then((e=>{const t=n.isElectronMode()?JSON.parse(new TextDecoder("utf-8").decode(e)):e.data;t&&(u=t)}))}function w(){return u&&d&&["public","nda"].includes(d.packageType)}function v(){l.suppressed=!0,p.emit(r,l),w()&&(void 0===c&&(c={}),c[d.packageType]=u[d.packageType],t.post("api/global-storage",{value:c},f))}return{init:function(){e.all([t.get("api/product/info",{params:{identity:i}}).then((e=>{e.data&&(d=e.data)})),g(),t.get("api/global-storage",f).then((e=>{e&&e.data&&e.data.suppressed&&(c=(e=>{const t={};return["public","nda"].forEach((n=>{e[n]&&"string"==typeof e[n]&&(t[n]=parseInt(e[n],10))})),t})(e.data.suppressed))}))]).finally((()=>{!function(){if(void 0===l.available)if(w()){const{packageType:e}=d;l.available=d.productBuild<u[e],l.suppressed=!!c&&c[e]===u[e]}else l.available=!1}(),l.available&&p.emit(r,l)}))},getProductUpdateState:function(){return l},onReleaseUpdate:function(e){return p.on(r,e)},openUpdatePage:function(){s.openWebLink("https://www.intel.com/content/www/us/en/developer/tools/oneapi/vtune-profiler-download.html"),v()}}}]);
"use strict";angular.module("searchDialog").controller("searchDialogController",["$scope","$element","$timeout","localize","uiSession",function(e,a,t,o,n){let s;n.getPartitionSocket(e).then((()=>{o(["%OfLabel"],"viewmodelbase1").then((a=>{e.messages=a}))})),e.searchData=e.searchData||{showSearchDialog:!1};const r=e.$watch("searchData.searchKey",(function(){void 0!==e.searchData.searchKey&&(s&&clearTimeout(s),s=setTimeout((()=>{h()}),300))})),c=e.$watch("searchData.showSearchDialog",(function(){e.searchData.showSearchDialog&&t((()=>{const e=a.find($(".search-text"));e&&e.length&&(e.focus(),e.select())}),0)}));function h(){delete e.searchData.foundItems,delete e.searchData.currentFoundItem,e.onSearch()}e.getCurrentStateLabel=()=>{if(!e.searchData.searchKey||!e.searchData.searchKey.length||!e.searchData.foundItems||void 0===e.searchData.foundItems.foundItemCount)return"";const a=e.searchData.currentFoundItem;if(!a)return"";const t=a.item.entries[a.entryIndex].foundItemNumber,o=e.searchData.foundItems.foundItemCount;return`${t} ${e.messages["%OfLabel"]} ${o}`},e.isNavigationDisabled=function(){return!e.searchData.foundItems||!e.searchData.foundItems.foundItemCount||0===e.searchData.foundItems.foundItemCount},e.onKeyDown=a=>{13===a.keyCode?h():27===a.keyCode&&(e.searchData.showSearchDialog=!1)},e.$on("$destroy",(function(){r&&r(),c&&c()}))}]);
"use strict";angular.module("searchDialog").directive("searchDialog",(function(){return{restrict:"E",replace:!0,scope:{onSearch:"=",searchData:"="},template:'<div class="search-dialog" ng-keydown="onKeyDown($event)" ng-show="searchData.showSearchDialog"><input class="search-text" ng-model="searchData.searchKey" type="text"><div class="search-result-summary" ng-show="searchData.foundItems !== undefined">{{getCurrentStateLabel()}}</div><button class="icon chevron-up" ng-click="searchData.previous()" ng-disabled="isNavigationDisabled()"></button> <button class="icon chevron-down" ng-click="searchData.next()" ng-disabled="isNavigationDisabled()"></button> <button class="icon cross" ng-click="searchData.showSearchDialog=false"></button></div>',controller:"searchDialogController"}}));
"use strict";angular.module("ng-semantic-ui").service("dropdownOpener",(function(){const n={};return{setOpener:function(e,u){null!=e&&null==n[e]&&(n[e]=u)},open:function(e,u){const t=n[e];null!=t&&t(u)}}}));
"use strict";angular.module("splitter").directive("splitter",["$timeout",function(e){return{restrict:"E",replace:!0,scope:{actions:"<?",addSash:"<?",config:"<?",createFolded:"<?",hideSplitter:"<?",idvcSplitter:"=?",isVertical:"<",minWidth:"@",primaryDiv:"@",refreshOnlyOnUserActions:"<?",secondaryDiv:"@",size:"@"},link:function(i,t){const r=!!i.hideSplitter,n=!i.refreshOnlyOnUserActions;let s,d=!1;require(["utils"],(o=>{let c,a=i.isVertical;const l=i.minWidth||40;s=i.$watch("isVertical",(function(){void 0!==i.isVertical&&i.isVertical!==a&&(c&&c.remove(),a=i.isVertical,e((()=>{S(),o.refreshSize(document.getElementById(i.primaryDiv)),o.refreshSize(document.getElementById(i.secondaryDiv))})))})),i.actions&&(i.actions.setSecondaryAreaHiddenState=e=>{if(c)if(e){if(c.isSecondaryFolded()&&c.isSplitterHidden()===r)return;c.foldSecondary(r,n||d)}else{if(!c.isSecondaryFolded())return;d?c.foldSecondary(!1,n||d):c.unfold(n)}});const[f]=t;let y=!1;function S(){const e=i.isVertical?o.createVertSplitter:o.createHorzSplitter;c=e({primaryDiv:i.primaryDiv,secondaryDiv:i.secondaryDiv},l,{refreshSizeByUserAction:!!i.refreshOnlyOnUserActions}),i.size&&c.setSize(i.size),i.addSash&&c.addSash(),c.onRefreshSize=()=>{setTimeout((()=>{window.dispatchEvent(new CustomEvent("splitter-resize",{detail:{primaryElementId:i.primaryDiv,secondaryElementId:i.secondaryDiv}}))}),0)},c.afterFoldSecondary=e=>{d=e},c.afterUnfold=()=>{d=!1},i.idvcSplitter=c,i.config&&(i.config.idvcSplitter=c)}function p(){S(),i.createFolded&&c.foldSecondary(r,n)}f.refreshSize=()=>{y&&(p(),y=!1)},f.offsetParent?p():y=!0})),i.$on("$destroy",(function(){s&&s(),delete i.idvcSplitter}))}}}]);
"use strict";angular.module("statistics").factory("statisticsService",["$http","error","productConstants",function(t,n,i){const s={consentGiven:void 0};let e=!1;const o=[];function a(t){e=t,t||(o.forEach((t=>{t&&t.onClose&&t.onClose()})),o.length=0)}return{getStatistic:()=>s,init:e=>t.get("api/statistics/consent",{params:{identity:i.commonIdentity}}).then(n.validateResponse).then((t=>{s.consentGiven=t.given,t.pending&&e&&e.openStatisticsDialog&&(e.openStatisticsDialog(),a(!0))})),saveUserConsent:n=>(s.consentGiven=n,t.post("api/statistics/consent",{given:n},{params:{identity:i.commonIdentity}})),isDialogShown:()=>e,setDialogState:a,subscribeOnDialogState(t){o.push(t)}}}]);
"use strict";angular.module("statistics").directive("statisticsWidget",["statisticsService",function(t){return{restrict:"E",scope:{actions:"=?",dropOptionsLink:"<?"},template:'<div class="statistics-content" localize="localize" test-marker="usage-statistics-consent-dialog" default-msg-catalog="htmlutil1"><p class="primary-content" html-content="{{::localize(\'%Statistics.content\')}}"></p><p class="options-link" ng-if="::!dropOptionsLink" html-content="{{::localize(\'%Statistics.optionsLink\')}}"></p><div class="ui form"><div class="grouped fields"><div class="field"><div class="ui radio checkbox"><input type="radio" ng-model="statistics.consentGiven" ng-value="true"> <label>{{::localize(\'%Statistics.consentGivenOptionLabel\')}}</label></div></div><div class="field"><div class="ui radio checkbox"><input type="radio" ng-model="statistics.consentGiven" ng-value="false"> <label>{{::localize(\'%Statistics.consentNotGivenOptionLabel\')}}</label></div></div></div></div></div>',replace:!0,controller:["$scope",function(i){i.actions&&(i.actions.save=()=>t.saveUserConsent(i.statistics.consentGiven),i.actions.validate=()=>void 0!==i.statistics.consentGiven,i.actions.setShowState=i=>t.setDialogState(i)),i.statistics={consentGiven:t.getStatistic().consentGiven}}]}}]);
"use strict";angular.module("services").factory("authenticator",["$http","$route","$q","sensitiveParameter",function(t,e,a,r){let s;return{authenticate:function(s){const n=s||e.current.params.passphrase;return n?t.post("api/auth/login/passphrase",{username:"anonymous",password:r(n)}):a.resolve({})},getUser:function(){return void 0!==s?s:t.get("api/auth/user").then((t=>(s=t.data&&t.data.user?t.data.user:"",s)))}}}]);
"use strict";angular.module("services").factory("clipboard",["diContainer",function(e){let r=null;return e.getContainer().then((e=>{r=e.get("IClipboardService")})),{copy(e){r.copyToClipboard(e)}}}]);
"use strict";angular.module("services").factory("color",(function(){return{toRgba:r=>`rgba(${(16711680&r)>>>16}, ${(65280&r)>>>8}, ${255&r}, ${((4278190080&r)>>>24)/255})`}}));
"use strict";angular.module("services").factory("Commands",(function(){function e(){const e=new Map;return{setHandler:function(n,r){if(e.has(n))throw new Error(`Handler for '${n}' command is already set.`);return e.set(n,r),function(){e.delete(n)}},execute:function(n,r){return new Promise(((t,o)=>{const s=e.get(n);s?t(s(r)):o(new Error(`Handler for '${n}' command is not set.`))}))}}}return e}));
"use strict";angular.module("services").factory("configuration",(function(){return{get:function(r,n){for(;n;){if(n[r])return n[r];n=n.$parent}}}}));
"use strict";angular.module("services").factory("error",["$q","messages","logging",function(r,e,t){return{handle:function(r,o){return function(s){o?o.stop():r&&!0===r.loading&&(r.loading=!1),0!==s.status&&202!==s.status&&(r&&(r.error=e.get("unexpectedError",r)||"Unexpected error occurred",r.dataNotApplicable=!0),t.log("error",s,"%s:"))}},logAndIgnore(r){0!==r.status&&202!==r.status&&t.log("debug",r,"%s:")},validateResponse:function(e){const{data:t}=e;return t.error?r.reject({type:"error",text:"Data source error: "+t.error.text}):401===e.status?r.reject(e):t}}}]);
"use strict";angular.module("services").factory("Events",(function(){function n(){const n=new Map;function t(t,e){const o=n.get(t)||n.set(t,[]).get(t);o.push(e);return()=>{const n=o.indexOf(e);-1!==n&&o.splice(n,1)}}return{emit:function(t,e){const o=n.get(t);if(o)for(const n of o)n(e)},on:t,once:function(n,e){const o=t(n,(n=>{e(n),o()}));return o}}}return n}));
"use strict";angular.module("services").factory("fileDialog",["diContainer","makeProxy",function(e,i){const t={};return e.getContainer().then((e=>{i(e.get("IFileDialogService"),t)})),t}]);
"use strict";angular.module("services").factory("globalConstants",(function(){return{delays:{tooltipShow:1e3,tooltipHide:100},notificationTypes:{WARNING:"warning",ERROR:"error"},notificationTimeout:5e3,OS:{WINDOWS:"windows",MACOS:"macos",LINUX:"linux",UNKNOWN:"unknown"}}}));
"use strict";angular.module("services").factory("grid",["$q",function(t){return{validateResponse:function(e){const n=e.data;return n.error?t.reject({type:"error",text:"Data source error: "+n.error.text}):n},sliceTotalColumn:function(t){return n(t)?(t.columns=t.columns.filter((t=>"grouping"!==t.columnType)),t):t},indicateIfDataIsNotApplicable:function(t){return function(e){return t.dataNotApplicable=!n(e),e}},indicateIfNoData:function(t){return function(n){return t.noData=!e(n),n}},sortColumns:function(t,n){return function(o){if("value"!==t)return o;if(!e(o))return o;const{columns:c}=o,[u]=o.rows;return r(c,u,n,0),o}},checkRowCount:function(e,n){return function(r){return r.rows?n&&r.rows.length<e||!n&&r.rows.length!==e?t.reject({type:"error",text:"Data contains "+r.rows.length+" rows. It differs from expected "+e}):r:t.reject({type:"error",text:"Data doesn`t contain rows. It differs from expected "+e})}},checkColumnCount:function(e,r){return function(o){return n(o)?r&&o.columns.length<e||!r&&o.columns.length!==e?t.reject({type:"error",text:"Data contains "+o.columns.length+" columns. It differs from expected "+e}):o:t.reject({type:"nodata",text:"Data doesn`t contain columns. It differs from expected "+e})}}};function e(t){return n(t)&&t.rows&&t.rows.length&&t.rows[0].cells&&t.rows[0].cells.length}function n(t){return t.columns&&t.columns.length}function r(t,e,n,o){t.forEach((t=>{t.columns&&r(t.columns,e,n,o+1)})),o>=n&&t.sort(((t,n)=>{const r=e.cells[t.index-1].value;return e.cells[n.index-1].value-r}))}}]);
"use strict";angular.module("services").factory("issues",(function(){return{get:function(e,s){if(!(e&&e.issues&&s&&s.cells))return[];const n=s.cells[e.index-1];return n?!1===n.confidence?[]:e.issues.filter((function(e,s){return 1<<s&n.issuesMask})).map((function(e){return e.issueText})):[]}}}));
"use strict";angular.module("services").factory("localize",["$http","error","$timeout","$q","$routeParams","productConstants",function(e,n,r,t,s,o){const i="",u={};function a(e,n){return Array.isArray(e)?c(e,n).then((n=>n.reduce(((n,r,t)=>(n[e[t]]=r,n)),{}))):m(e,n).promise}return a.synchronously=(e,n)=>m(e,n).message,a.spread=function(e,n,r){return Array.isArray(e)?c(e,n).then((function(e){return r.apply(this,e)})):m(e,n).promise},a;function c(e,n){return t.all(e.map((e=>m(e,n).promise)))}function m(t,a){return t?(u[a=a||i]=u[a]||function(t){const i={};let u,a;const c={promise:Promise.resolve()};return{localize:m};function m(e){return i[e]?n(c):a&&a.includes(e)?n(a):(u=u||l(),u.includes(e)||u.push(e),n(u));function n(n){return{message:i[e],promise:n.promise.then((()=>i[e])).catch((()=>{}))}}}function l(){const c=[],m={includes:e=>-1!==c.indexOf(e),push:e=>c.push(e),promise:new Promise(((e,s)=>{r((()=>{u=void 0,a=m,l(c,t).then(n.validateResponse).then((n=>{Object.assign(i,n.messages),a=void 0,e()})).catch(s)}))}))};return m;function l(n,r){return e.post("api/localization",{messageIds:n,messageCatalog:r},{params:{identity:s.identity||o.commonIdentity}})}}}(a),u[a].localize(t)):{message:void 0,promise:Promise.resolve(void 0)}}}]);
"use strict";angular.module("services").factory("logging",["diContainer","makeProxy",function(e,n){const t={};return e.getContainer().then((e=>{n(e.get("ILogger"),t)})),t}]);
"use strict";angular.module("services").factory("makeProxy",(function(){return function(t,n){const r=function(t){const n=[];for(;null!=t&&!t.hasOwnProperty("hasOwnProperty");)n.push(...Object.getOwnPropertyNames(t)),t=t.__proto__;return n}(t).filter((n=>"function"==typeof t[n]));for(const o of r)n[o]=function(...n){return t[o](...n)}}}));
"use strict";angular.module("services").factory("messages",["$q",function(e){const s=e.defer();return{get:function(e,s){for(;s;){if(s.messages&&s.messages[e])return s.messages[e].displayName||"Display name not set for message ["+e+"]";s=s.$parent}return"Message ["+e+"] not found"},set:function(e,n){n.messages=e,s.resolve()},whenReady:function(){return s.promise}}}]);
"use strict";angular.module("services").factory("polling",["$timeout","$q",function(n,o){return(e,c)=>{const l=c||{},t=void 0!==l.cooldownOnSuccessInMilliseconds?l.cooldownOnSuccessInMilliseconds:300,i=void 0!==l.cooldownOnFailureInMilliseconds?l.cooldownOnFailureInMilliseconds:1e3;let s,r=!1;return{start:function c(){return o.when().then(e).then((()=>r?o.reject("Polling stopped."):(s=n(c,t),s))).catch((()=>r?o.reject("Polling stopped."):(s=n(c,i),s)))},stop:function(){r=!0,n.cancel(s)}}}}]);
"use strict";angular.module("services").factory("popup",["globalConstants",function(o){return function(e,n,t,s){return e.popup({html:n,hoverable:!0,delay:{show:o.delays.tooltipShow,hide:o.delays.tooltipHide},observeChanges:!1,onCreate:function(){t&&this.addClass(t)},onShow:function(){if(!e[0].offsetParent)return!1;s&&s.onShow&&s.onShow()},onRemove:function(){s&&s.onRemove&&s.onRemove()}}),{hide:()=>e.popup("hide"),remove:()=>e.popup("destroy"),show:()=>e.popup("show")}}}]);
"use strict";angular.module("services").factory("requestIdentity",["$routeParams","productConstants",function(t,e){const n="REQUEST_IDENTITY",i={};return{get:function(r){let o=i[r.$id];if(void 0!==o)return o;let u=t.identity||e.commonIdentity,d=r;for(;d;){if(o=i[r.$id]||d[n],void 0!==o){u=o;break}d=d.$parent}return i[r.$id]=u,u},set:function(t,e){i[t.$id]=e,t[n]=e}}}]);
"use strict";angular.module("services").factory("sensitiveParameter",(function(){return e=>`sensitive(${e})sensitive`}));
"use strict";angular.module("services").factory("statistics",["$http","$routeParams","productConstants",function(t,e,a){return{notifyFeatureUsage(s){t.post("api/statistics/feature-usage",{featureName:s},{params:{identity:e.identity||a.commonIdentity}})}}}]);
"use strict";angular.module("services").factory("tasks",["$q",function(t){function s(){this.lastTask=new e(this)}s.prototype.registerNew=function(){return this.lastTask=new e(this),this.lastTask};let n=0;function e(t){this._id=++n,this._group=t}function i(){this._groups={}}e.prototype.isCanceled=function(){return this._group.lastTask!==this},e.prototype.cancelationReason=function(){return t.reject({status:0,text:"Task #"+this._id+"canceled by a subsequent task #"+this._group.lastTask._id})},i.prototype.get=function(t){return this._groups[t]=this._groups[t]||new s,this._groups[t]};const r=new i;return{group:function(t){return r.get(t)}}}]);
"use strict";angular.module("services").service("trace",["$http",function(t){const e={};let n=!1,r=0;function a(r){const a=e[r];a&&(a.then((function(e){const r=(e.data||{}).token;r?t.post("api/trace/endFrame",{},{params:{token:r,timestamp:(new Date).toISOString()}}):n=!0})),delete e[r])}return{startFrame:function(a){if(n)return null;const s=++r;return e[s]=t.post("api/trace/startFrame",{},{params:{name:a,timestamp:(new Date).toISOString()}}),s},endFrame:a,schedule:{endFrame:function(t){return function(){a(t)}}}}}]);
"use strict";angular.module("services").factory("Tracker",["$q","$timeout",function(t,e){return function(){let s,i=0;this.start=()=>(++i,s||(s=t.defer()),e((()=>{}),0)),this.stop=t=>(i>0&&(--i,0===i&&s&&(s.resolve("Stopped"),s=void 0)),t),this.isInProgress=()=>i>0,this.waitToComplete=()=>s?s.promise:t.when(),this.destroy=()=>{i=0,s=void 0}}}]);
"use strict";angular.module("services").factory("userAgent",["globalConstants",function(n){const i=window.navigator.userAgent,{platform:O}=window.navigator;let s=n.OS.UNKNOWN;return"MacIntel"===O||"MacPPC"===O||-1!==i.indexOf("OS X")?s=n.OS.MACOS:"Win32"===O||"Win64"===O||-1!==i.indexOf("Win")?s=n.OS.WINDOWS:-1!==O.indexOf("Linux")&&(s=n.OS.LINUX),{os:s,isMac:()=>s===n.OS.MACOS,isWin:()=>s===n.OS.WINDOWS,isLin:()=>s===n.OS.LINUX,isUnknownOs:()=>s===n.OS.UNKNOWN}}]);
"use strict";angular.module("services").factory("webApi",(function(){let e;require(["@analyzers/web-api"],(r=>{e=r}));const r=function(){const[e]=document.getElementsByTagName("base");return new URL("api",e.href).href}();return{createWebApi:()=>e.createWebApi(r)}}));
"use strict";angular.module("services").factory("dumpDispatcher",["localize",function(e){class t{constructor(){this._actionListeners=[],this._dumpListeners=[],this._initialized=!1}static get listenerTypes(){return{ACTION:"action",DUMP:"dump"}}_addListener(e,{paneId:n,$scope:i},a){if(!n)return;const r=e===t.listenerTypes.DUMP?this._dumpListeners:this._actionListeners,d=new s({paneId:n},a);r.push(d),i&&i.$on("$destroy",(()=>{r.splice(r.indexOf(d),1)}))}_getListener(e,{paneId:s}){if(!s)return;return(e===t.listenerTypes.DUMP?this._dumpListeners:this._actionListeners).find((e=>e.forPane(s)))}init(s){this._initialized||(this._initialized=!0,s.on("test-harness:localize",(t=>{const{messageCatalog:n,messageId:i,dumpId:a}=t;e([i],n).then((e=>{s.emit("test-harness:localize:complete",{data:e,dumpId:a})}))})),s.on("test-harness:dump",(e=>{const n=this._getListener(t.listenerTypes.DUMP,e),{dumpId:i}=e;if(n)n.callback(e).then((e=>{s.emit("test-harness:dump:complete",{data:e,dumpId:i})}));else{const{paneId:t}=e,n={paneId:t,dump:{message:`Pane '${t}' isn't yet initialized...`}};s.emit("test-harness:dump:complete",{data:n,dumpId:i})}})),s.on("test-harness:action",(e=>{const n=this._getListener(t.listenerTypes.ACTION,e),{dumpId:i}=e;n&&n.callback(e).then((e=>{s.emit("test-harness:action:complete",{data:e,dumpId:i})}))})))}addActionListener(e,s){return this._addListener(t.listenerTypes.ACTION,e,s)}addDumpListener(e,s){return this._addListener(t.listenerTypes.DUMP,e,s)}}class s{constructor({paneId:e},t){this._paneId=e,this._callback=async(...e)=>t(...e)}get callback(){return this._callback}forPane(e){return new RegExp(e,"i").test(this._paneId)}}return new t}]);
"use strict";angular.module("services").factory("dumpHelper",["$q","$timeout","$interval",function(e,n,t){function o(e){return n(e)}return{chooseOptionFromNativeSelector:function(e,n,t){if(e instanceof jQuery&&(e=e[0]),e)return e.selectedIndex=n,o((()=>{e.dispatchEvent(new Event("change")),t&&t()}))},dispatchElementMouseEvent:function(e,n){if(e=e||"click",n instanceof jQuery&&(n=n[0]),!n)return;const t=function(e){const n=e.getBoundingClientRect(),t=document.documentElement,o=window.pageYOffset||t.scrollTop,i=window.pageXOffset||t.scrollLeft,c=n.top+o-t.clientTop;return{x:n.left+i-t.clientLeft,y:c,width:n.width,height:n.height}}(n),i={x:t.x+t.width/2,y:t.y+t.height/2},c={view:window,bubbles:!0,cancelable:!0,screenX:i.x,screenY:i.y,clientX:i.x,clientY:i.y},r=new MouseEvent(e,c);return r.simulation=!0,o((()=>{n.dispatchEvent(r)}))},executeAsyncronously:o,generateActionURL:function(e,n){let t=`/test-harness/action?type=${e}`;return n&&(t+=`&paneId=${n}`),t},waitForLoadingToComplete:function(o){const i=e.defer(),c=t((()=>{$(o).is(":visible")&&(i.resolve(),t.cancel(c))}),100);return n((function(){t.cancel(c),i.reject("Timeout on waiting for loading to complete.")}),6e4),i.promise},waitForModalDialogClosing:function(){const o=e.defer(),i=t((()=>{$(".modal-dialog-content").is(":visible")||(o.resolve(),t.cancel(i))}),100);return n((function(){t.cancel(i),o.reject("Timeout on waiting for closing modal dialog.")}),15e3),o.promise}}}]);
"use strict";angular.module("tooltip").directive("tooltip",["$compile","globalConstants","popup",function(t,o,e){return{restrict:"A",link:function(o,i,n){const l={"<":"&lt;",">":"&gt;","&":"&amp;",'"':"&quot;"},p=[];let c,r,s;const a=n.$observe("tooltip",(function(a){if(a){r=n.tooltipClass||"default",c=n.tooltipContent||a,s=o.$new(!0),s.isTooltip=!0,s.actions={onShowTooltip:t=>p.push(t)},c=c.replace(/\n/g,"<br/>"),c=n.tooltipEscapeHtml?`<div>${c.replace(/[<>&"]/g,(t=>l[t]))}</div>`:t(`<div>${c}</div>`)(s)[0],n.tooltipTitle&&(c={title:n.tooltipTitle,text:a});const u=e(i,c,r,{onShow:d});s.$on("pane:deactivated",u.hide),s.$on("$destroy",u.remove),i.on("remove",u.remove)}}));function d(){p.length&&p.forEach((t=>t()))}o.$on("$destroy",(function(){s&&s.$destroy(),a&&a()}))}}}]);
"use strict";angular.module("ui-session").factory("frontendSession",["diContainer",function(n){return{getFrontendSession:async function(t,e){const o=(await n.getContainer()).get("ISessionStorage");return await o.getSession(t,e)}}}]);
"use strict";angular.module("ui-session").factory("resultApi",["uiSession","$http",function(s,e){return{openResult:function(t,n){return s.getSession().then((s=>e.post("api/results/open",{...t,sessionId:s.sessionId},n)))},closeResult:function(t,n){return s.getSession().then((s=>e.post("api/results/close",{...t,sessionId:s.sessionId},n)))},setPath:function(s,t){return e.put("api/results/path",{...s},t)}}}]);
"use strict";angular.module("ui-session").factory("triggerAuthentication",["$http","error","$q",function(e,t,r){let n=!1;function s(){return n?r.resolve(!0):(n=!0,e.get("service/web-sockets").then(t.validateResponse))}return s}]);
"use strict";angular.module("ui-session").constant("socketStatus",{initial:"initial",connected:"connected",disconnected:"disconnected"}),angular.module("ui-session").factory("uiSession",["$rootScope","triggerAuthentication","frontendSession","$routeParams","requestIdentity",function(t,e,n,s,i){const o=function(){const[t]=document.getElementsByTagName("base"),e=new URL(t.href);return e.protocol="https:"===e.protocol?"wss":"ws",e.href}();class r{constructor(t){this.partition=t}on(e,n){this.partition.on(e,(e=>t.$apply((()=>n(e)))))}once(e,n){this.partition.once(e,(e=>t.$apply((()=>n(e)))))}emit(t,e){this.partition.emit(t,e)}}class a extends r{constructor(t){super(t),this.session=t}get sessionId(){return this.session.sessionId}getPartition(t,e){return this.session.getPartition(t,e)}releasePartition(t,e){return this.session.releasePartition(t,e)}getScopePartition(t){const e=i.get(t),n=this.session.getPartition(e,t);return t.$on("$destroy",(()=>this.session.releasePartition(e,t))),new r(n)}}let c;function u(){return e().then((()=>(null!=c||(c=async function(){const t=await n.getFrontendSession(o,s.sessionId);return new a(t)}()),c)))}function l(t){return u().then((e=>e.getScopePartition(t)))}return{getSession:u,getPartition:l,getPartitionSocket:l}}]);
"use strict";angular.module("utube").directive("utube",["sizeWatcher","uiSession","localize",function(t,e,a){return{restrict:"E",template:'<div internalContainer ng-hide="utubeData && (!utubeData.isValid || utubeData.shortCollection)"><svg ng-if="utubeData" pointer-events="none" version="1.1" xmlns="http://www.w3.org/1999/xhtml" viewBox="0 0 350 200"><g ng-attr-transform="{{yPosition(y1)}}" ng-class="{issue: issues[0]}"><polygon ng-attr-points="{{wedgeUp(x1, w, h1)}}"/></g><g ng-attr-transform="{{yPosition(y2)}}" ng-class="{issue: issues[1]}"><polygon ng-attr-points="{{rect(x1, w, h2)}}"/><polygon ng-attr-points="{{wedgeUp(x2, w, h2)}}"/></g><g ng-attr-transform="{{yPosition(y3)}}" class="retiring"><polygon ng-attr-points="{{rect(x1, w, h3)}}"/><polygon ng-attr-points="{{rect(x2, w, h3)}}"/><polygon ng-attr-points="{{rect(x3, w, h3)}}"/></g><g ng-attr-transform="{{yPosition(y4)}}" ng-class="{issue: issues[2]}"><polygon ng-attr-points="{{rect(x1, w, h4)}}"/><polygon ng-attr-points="{{wedgeDown(x2, w, h4)}}"/></g><g ng-attr-transform="{{yPosition(y5)}}" ng-class="{issue: issues[3]}"><path ng-attr-d="{{outlet(x1, w, h5)}}"/></g><g ng-attr-transform="{{yPosition(y1)}}"><path class="outline pipe" ng-attr-d="{{pipeWedgeUp(x1, w, h1)}}"/><path class="solid" ng-attr-d="{{pipeWedgeUp(x1, w, h1)}}"/><polygon data-id="mn1" ng-attr-points="{{rect(x1, w - bh, h1)}}"/><polygon data-id="i1" ng-attr-points="{{rect2(x2, -pad, w, h1)}}"/></g><g ng-attr-transform="{{yPosition(y2)}}"><path class="outline" ng-attr-d="{{pipeWedgeUp(x2, w, h2)}}"/><path class="solid" ng-attr-d="{{pipeWedgeUp(x2, w, h2)}}"/><polygon data-id="mn2" ng-attr-points="{{rect(x1, w, h2)}}"/><polygon data-id="sl2" ng-attr-points="{{wedgeUp(x2, w, h2)}}"/><polygon data-id="i2" ng-attr-points="{{rect2(x3, -th2 * 3, w, h2)}}"/></g><g ng-attr-transform="{{yPosition(y5)}}"><path class="outline" ng-attr-d="{{pipeOutlet(x1, w, h5)}}"/><path class="solid" ng-attr-d="{{pipeOutlet(x1, w, h5)}}"/><polygon data-id="mn5" ng-attr-points="{{rect(x1, w - bh, h5)}}"/><polygon data-id="i5" ng-attr-points="{{rect2(x2, th2 * 3, w + pad - th2 * 3, h5)}}"/></g><g ng-attr-transform="{{yPosition(y4)}}"><path class="outline" ng-attr-d="{{pipeWedgeDown(x2, w, h4)}}"/><path class="solid" ng-attr-d="{{pipeWedgeDown(x2, w, h4)}}"/><polygon data-id="mn4" ng-attr-points="{{rect(x1, w, h4)}}"/><polygon data-id="sl4" ng-attr-points="{{wedgeDown(x2, w, h4)}}"/><polygon data-id="i4" ng-attr-points="{{rect2(x3, th2 * 3, w, h4)}}"/></g><g ng-attr-transform="{{yPosition(y3)}}"><path class="outline" ng-attr-d="{{pipeUp(x3, w, h3)}}"/><path class="solid" ng-attr-d="{{pipeUp(x3, w, h3)}}"/><path class="outline" ng-attr-d="{{pipeDown(x3, w, h3)}}"/><path class="solid" ng-attr-d="{{pipeDown(x3, w, h3)}}"/><polygon data-id="mn3" ng-attr-points="{{rect(x1, w, h3)}}"/><polygon data-id="sl3" ng-attr-points="{{rect(x2, w, h3)}}"/><polygon data-id="tl3" ng-attr-points="{{rect(x3, w, h3)}}"/></g></svg> <span class="metric" data-placeholder-id="mn1" tooltip="{{tooltips[0]}}"><span class="centered" ng-if="::!compactView">{{utubeData.frontEnd.value | percentage: 1}} - {{utubeData.frontEnd.name}}</span> </span><span class="metric" data-placeholder-id="mn2" tooltip="{{tooltips[1]}}"><span class="centered" ng-if="::!compactView">{{utubeData.memory.value | percentage: 1}} - {{utubeData.memory.name}}</span> </span><span class="metric" data-placeholder-id="mn3" tooltip="{{tooltips[2]}}"><span class="centered" ng-if="::!compactView">&nbsp;{{utubeData.retiring.value | percentage: 1}} - {{utubeData.retiring.name}}</span> </span><span class="metric" data-placeholder-id="mn4" tooltip="{{tooltips[3]}}"><span class="centered" ng-if="::!compactView">{{utubeData.core.value | percentage: 1}} - {{utubeData.core.name}}</span> </span><span class="metric" data-placeholder-id="mn5" tooltip="{{tooltips[4]}}"><span class="centered" ng-hide="::compactView">{{utubeData.badSpec.value | percentage: 1}} - {{utubeData.badSpec.name}}</span> </span><span data-placeholder-id="sl2" tooltip="{{tooltips[1]}}"></span> <span data-placeholder-id="sl3" tooltip="{{tooltips[2]}}"></span> <span data-placeholder-id="tl3" tooltip="{{tooltips[2]}}"></span> <span data-placeholder-id="sl4" tooltip="{{tooltips[3]}}"></span> <span class="issue" data-placeholder-id="i1" tooltip="{{issues[0]}}"><span class="centered" ng-if="::!compactView"><div html-content="{{issues[0]}}"></div></span></span><span class="issue" data-placeholder-id="i2" tooltip="{{issues[1]}}"><span class="centered" ng-if="::!compactView"><div html-content="{{issues[1]}}"></div></span></span><span class="issue" data-placeholder-id="i4" tooltip="{{issues[2]}}"><span class="centered" ng-if="::!compactView"><div html-content="{{issues[2]}}"></div></span></span><span class="issue" data-placeholder-id="i5" tooltip="{{issues[3]}}"><span class="centered" ng-if="::!compactView"><div html-content="{{issues[3]}}"></div></span></span></div><div class="no-data" ng-if="utubeData && utubeData.shortCollection">{{::localize(\'%ShortCollectionMuxRecommendationIssue\', \'viewpoint\')}}</div><div class="no-data" ng-if="utubeData && !utubeData.isValid && !utubeData.shortCollection">{{::localize(\'%uTubeNotValidData\', \'viewpoint\')}}</div><div class="header" localize="localize">{{::localize(utubeHeader, \'viewpoint\')}}</div><div class="description" ng-if="!compactView" html-content="{{::localize(utubeDescription, \'viewpoint\')}}"></div>',scope:{utubeData:"=",reCalculate:"=?",compactView:"=",utubeHeader:"=",utubeDescription:"="},link:function(n,i){const s=350,o=200,p=10,r=4,l=15,c=3,u=i.find("span.metric > span.centered")[0].clientHeight,d=i.find("span.metric")[0].clientHeight-i.find("span.metric > span.centered")[0].clientHeight,g=o-2*p,h=(s-p-2*r)/3,w=i.find("div[internalContainer]");function m(){if(0===i.find("svg").length)return;const t=i.find("svg")[0].getBoundingClientRect();i.find("span[data-placeholder-id]").each(((e,a)=>{const n=i.find("[data-id="+a.dataset.placeholderId+"]")[0].getBoundingClientRect();$(a).css({width:n.width,height:n.height,top:Math.round(n.top-t.top),left:Math.round(n.left-t.left)}),$(a).find("span.centered").css({maxHeight:Math.floor((n.height-d)/u)*u})}))}function f(t){return isNaN(t)||void 0===t?0:parseFloat(t)}function y(t){return Array.isArray(t)?0===t.length?"":t.join().replace(/\n/g,"<br/>"):t}function b(t){let e=`<p>${t.name}: ${(100*t.value).toFixed(2)}%</p><p>`;e+=n.messages?n.messages["%uTubeTooltip"]:"",e+=` ${t.name}.</p>`;return e+=y(t.issues)||t.description,e}e.getPartitionSocket(n).then((()=>{a(["%uTubeTooltip"]).then((t=>{n.messages=t}))})),n.x1=p,n.x2=n.x1+h+r,n.x3=n.x2+h+r,n.w=h,n.bh=l/2,n.pad=p,n.th2=c/2+1,n.reCalculate=function(){const t=function(t){const e=t.reduce(((t,e)=>t+e),0);return t.map((t=>t/e))}([f(n.utubeData.frontEnd.value),f(n.utubeData.memory.value),f(n.utubeData.retiring.value),f(n.utubeData.core.value),f(n.utubeData.badSpec.value)]);n.issues=[y(n.utubeData.frontEnd.issues),y(n.utubeData.memory.issues),y(n.utubeData.core.issues),y(n.utubeData.badSpec.issues)],n.tooltips=[b(n.utubeData.frontEnd),b(n.utubeData.memory),b(n.utubeData.retiring),b(n.utubeData.core),b(n.utubeData.badSpec)],n.y1=p,n.h1=g*t[0],n.y2=n.y1+n.h1,n.h2=g*t[1],n.y3=n.y2+n.h2,n.h3=g*t[2],n.y4=n.y3+n.h3,n.h4=g*t[3],n.y5=n.y4+n.h4,n.h5=g*t[4],setTimeout(m,50)},n.utubeData.refresh=n.reCalculate,n.yPosition=function(t){return`translate(0, ${t})`},n.rect=function(t,e,a){return`${t},0 ${t+e},0 ${t+e},${a} ${t},${a}`},n.rect2=function(t,e,a,n){return`${t},${e} ${t+a},${e} ${t+a},${e+n} ${t},${e+n}`},n.wedgeUp=function(t,e,a){return`${t},0 ${t+e-l},0 ${t+e},${a} ${t},${a}`},n.wedgeDown=function(t,e,a){return`${t},0 ${t+e},0 ${t+e-l},${a} ${t},${a}`},n.outlet=function(t,e,a){const n=e/2,i=a<e-n?a:e-n,s=a<p?a:p,o=a<e-n-p?a:e-n-p;return`M${t},0 h${e-i}A${i},${i} 0 0,1 ${t+e},${i} V${a+p} h${-o} ${a<p?"v"+(a-p):""}A${s},${s} 0 0,0 ${t+e-s-o},${a} H${t} z`},n.pipeWedgeUp=function(t,e,a){const n=c/2+1,i=r/2;return`M${t-i},${3*-n} h${i} L${t+r},${-n} h${e-l-r} l${l},${a} h${r}`},n.pipeWedgeDown=function(t,e,a){const n=c/2+1,i=r/2;return`M${t-i},${a+3*n} h${i} L${t+r},${a+n} h${e-l-r} l${l},${-a} h${r}`},n.pipeUp=function(t,e){const a=c/2+1,n=r/2;return`M${t-n},${3*-a} h${n} L${t+r},${-a} h`+(e-r)},n.pipeDown=function(t,e,a){const n=c/2+1,i=r/2;return`M${t-i},${a+3*n} h${i} L${t+r},${a+n} h`+(e-r)},n.pipeOutlet=function(t,e,a){const n=c/2+1,i=e/2,s=a<e-i?a:e-i,o=a<p?a:p,l=a<e-i-p?a:e-i-p;return`M${t+e+n},${n} h${-s+n}A${s},${s} 0 0,1 ${t+e},${s} V${a+p}M${t+e-l},${a+p} ${a<p?"v"+(a-p):""}A${o},${o} 0 0,0 ${t+e-o-l},${a} H${t+r} L${t},${a+2*n} h${-(r/2)}`},t(w[0],n,m);const D=n.$watch("utubeData",n.reCalculate);n.$on("$destroy",(function(){D&&D()}))}}}]);
"use strict";angular.module("cell").filter("dynamic-time-units",(function(){return function(e){return e>1?e.toFixed(3)+"s":e>.001?(1e3*e).toFixed(3)+"ms":0===e?e+"usec":(1e3*e*1e3).toFixed(3)+"usec"}}));
"use strict";angular.module("cell").filter("exponential",(function(){return function(n,e){return"number"==typeof n?n.toExponential(e||0):n}}));
"use strict";angular.module("cell").filter("largeNumber",["textFormat",function(r){return function(e){return r("LargeNumber")(e)}}]);
"use strict";angular.module("charts").factory("BarChartData",["GroupedSeries","binning",function(s,i){const e=window.d3_main||window.d3;function t(i,t,n,d){i.sort(o),t.sort(o),n.sort(m);const x=new s(i);this.series={original:{sorted:i,grouped:x.data,colors:x.colors,offsets:x.indexes,minStep:r(x),x:{min:e.min(i,h),max:e.max(i,h)}}},this.series.original.minStep||(0===this.series.original.x.min?this.series.original.minStep=1:this.series.original.minStep=Math.abs(.01*this.series.original.x.min)),this.series.processed={data:i,x:this.series.original.x},this.series.processed.positions=d.getNumberOfBars(this),this.markers={data:t,min:e.min(t,h),max:e.max(t,h)},this.knobs={data:a(n)},this._updateMinMax()}return t.prototype.discretize=function(s){const e=i.discretize(this,s);this.series.processed.data=e.data,this.series.processed.positions=e.positions,this._updateMinMax()},t.prototype._updateMinMax=function(){this.series.processed.x={min:e.min(this.series.processed.data,h),max:e.max(this.series.processed.data,h)};let s=(this.series.processed.x.max-this.series.processed.x.min)/(this.series.processed.positions-1);this.series.processed.x.min===this.series.processed.x.max&&(s=this.series.original.minStep),this.series.processed.x.min-=s/2,this.series.processed.x.max+=s/2,this.series.processed.y={min:e.min(this.series.processed.data,d),max:e.max(this.series.processed.data,d)},this.knobs.x={min:e.min([this.series.original.x.min,this.markers.min])-this.series.original.minStep/2,max:e.max([this.series.original.x.max,this.markers.max])+this.series.original.minStep/2},this.x={min:e.min([this.series.processed.x.min,this.markers.min,this.knobs.x.min]),max:e.max([this.series.processed.x.max,this.markers.max,this.knobs.x.max])},this.y={min:this.series.processed.y.min,max:this.series.processed.y.max}},t;function r(s){return s.data.map((function(s){const i=e.pairs(s.data.map(h)).map(n);return e.min(i)})).reduce((function(s,i){return Math.min(s,i)}),Number.MAX_VALUE)}function n(s){return s[1]-s[0]}function a(s){let i={threshold:{min:-1/0},readonly:!0};const e=s.map((function(s){return i.next={threshold:s,readonly:s.readonly},i.next.prev=i,i=i.next,i}));return i.next={threshold:{min:1/0},readonly:!0},e}function o(s,i){return s.x-i.x}function m(s,i){return s.min-i.min}function h(s){return s.x}function d(s){return s.y}}]);
"use strict";angular.module("charts").factory("BarChartDimensions",(function(){const i=window.d3_main||window.d3;function t(t,a,n,e){const r=this;r._data=t,r.yAxisOnLeft=.25*a>n.axes.y.width+n.margin.left+n.margin.right,r.margin=r.yAxisOnLeft?n.margin:{top:n.margin.top,right:0,bottom:n.margin.bottom,left:0};let h=a-(r.yAxisOnLeft?n.axes.y.width:0)-r.margin.left-r.margin.right-n.axes.x.padding.left-n.axes.x.padding.right;h=Math.max(h,n.bar.minSpace),r.bar=e.getBarDimensions(h,t,n),r.binningRequired=r.bar.space<n.bar.minSpace;const s=e.adjustXAxisSpace(h,r.bar.totalSpace);r.main={width:s+n.axes.x.padding.left+n.axes.x.padding.right,height:n.main.height},r.width=r.main.width+(r.yAxisOnLeft?n.axes.y.width:0)+r.margin.left+r.margin.right;const g=t.knobs.data.length>0;r.height=n.main.height+n.axes.x.height+r.margin.top+r.margin.bottom+(g?n.knob.height:0),r.axes={x:{scale:function(){const i=n.axes.x.padding.left,a=r.main.width-n.axes.x.padding.right;return e.buildXScale(i,a,r.bar.space,t)}(),label:{margin:{top:n.axes.x.label.margin.top+(g?n.knob.height:0)}}},y:{scale:function(){const a=r.main.height;return i.scaleLinear().range([a,0]).domain([0,t.y.max]).nice()}(),width:r.yAxisOnLeft?n.axes.y.width:0,margin:n.axes.y.margin}},r.knob=n.knob}return t.prototype.forBar=function(i){const t=this,a=t._data.series.original.offsets(i.series),n=t._data.series.original.grouped.length,e=t.bar.width/n;let r=t.axes.x.scale(i.x);r-=t.bar.width/2,r+=e*a;let h=t.axes.y.scale(i.y);i.y>0&&t.main.height-h<1.5&&(h=t.main.height-1.5);const s=t.main.height-h;return{x:r,y:h,width:e,height:s,hover:function(){const i=t.bar.margin/2,r={x:0,y:-h,width:e,height:t.main.height};0===a&&(r.x-=i);1===n?r.width+=2*i:0!==a&&a!==n-1||(r.width+=i);return r}()}},t}));
"use strict";angular.module("charts").factory("barTooltips",(function(){return{render:function(t,e,o,n,r,s,i){const a=t.find(".bar .hover");function c(){a.qtip("destroy",!0)}function d(t){return t.data?t.data.map(d).join("<br/><br/>"):o+": "+(t.xLabel||r(t.x))+"<br/>"+n+": "+s(t.y)}a.qtip({content:{text:function(){return d($(this).prop("__data__"))}},show:{delay:500},hide:{fixed:!0,delay:100},position:{viewport:!0,my:"top center",at:"bottom center",adjust:{method:"shift none"}},style:{tip:{corner:!0}},events:{show:function(t,o){const n=o.elements.target.prop("__data__");n.data&&0===n.data.length?t.preventDefault():(e.series.original.grouped.length>1&&o.set("content.title",n.series),o.set("style.classes",e.series.original.colors(n.series)+" histogram-tooltip"))}}}),a.on("remove",c),i.$on("$destroy",c)}}}));
"use strict";angular.module("charts").factory("bars",["chartUtils",function(t){const a=window.d3_main||window.d3;return{render:function(s,i,n){t.refresh(s.selectAll(".bar"),i.series.processed.data,(function(){const t=a.select(this);t.classed("bar",!0),t.append("rect").classed("fill",!0),t.append("rect").classed("hover",!0)}),(function(s){const o=a.select(this).transition(),c=n.forBar(s);let l,d;s.data?s.data.length>0&&(l=s.data.map(r).join(","),d=s.data.map(e).join(",")):({x:l,y:d}=s);o.attr("transform",t.translate(c.x,0)).attr("data-x",l).attr("data-y",d).attr("data-series",s.series),o.select(".fill").attr("class",i.series.original.colors(s.series)+" fill").attr("x",0).attr("y",c.y).attr("width",c.width).attr("height",c.height),o.select(".hover").attr("x",c.hover.x).attr("y",0).attr("width",c.hover.width).attr("height",c.hover.height)}))}};function r(t){return t.x}function e(t){return t.y}}]);
"use strict";angular.module("charts").factory("binning",(function(){const n=window.d3_main||window.d3;return{discretize:function(o,a){const{min:s}=o.x,{max:e}=o.x,r=a.axes.x.scale(s),c=a.axes.x.scale(e);let u=Math.floor((c-r)/a.bar.minSpace);u=Math.max(u,1);const f=[];if(u>0){const a=[s,e+o.series.original.minStep];o.series.original.grouped.forEach((function(o){const s=n.bin().domain(a).value(t).thresholds(function(n,t){const i=+n[0],o=(n[1]-i)/t;let a=-1;const s=[];for(;++a<=t-1;)s[a]=o*a+i;return s}(a,u))(o.data);s.forEach((function(t){f.push({x:t.x0+(t.x1-t.x0)/2,y:n.sum(t,i),data:t,series:o.name,isBin:!0})}))}))}return{data:f,positions:u}}};function t(n){return n.x}function i(n){return n.y}}));
"use strict";angular.module("charts").factory("chart",["chartUtils",function(t){const n=window.d3_main||window.d3;return{render:function(r,a){return function(t){const r=n.select(t);let a=r.select("svg");return a.size()||(a=r.append("svg"),a.append("g").attr("class","main")),a}(r).attr("width",a.width).attr("height",a.height).select(".main").attr("transform",t.translate(a.margin.left+a.axes.y.width,a.margin.top))}}}]);
"use strict";angular.module("charts").factory("GroupedSeries",(function(){const a=window.d3_main||window.d3;return function(n){this.data=a.groups(n,(a=>a.series)).sort(((n,o)=>a.ascending(n[0],o[0]))).map((([a,n])=>({name:a,data:n})));const o=this.data.map((a=>a.name));this.indexes=a.scaleOrdinal().domain(o).range(o.map(((a,n)=>n))),this.colors=a.scaleOrdinal().domain(o).range(["color1","color2"])}}));
"use strict";angular.module("charts").factory("knobMarker",["chartUtils",function(t){const e=window.d3_main||window.d3;return{render:function(i,n,r,s,a){t.refresh(i.selectAll(".knob-marker"),[n],(function(){const t=e.select(this).attr("class","knob-marker");t.append("line"),t.append("text")}),(function(t){const i=e.select(this);i.style("visibility","inherit"),i.select("line").attr("x1",s.axes.x.scale(t.threshold.min)).attr("y1",0).attr("x2",s.axes.x.scale(t.threshold.min)).attr("y2",s.main.height),i.select("text").text("> "+a(t.threshold.min-r.series.original.minStep/2)).attr("x",s.axes.x.scale(t.threshold.min)).attr("y",0).attr("dx",".5em").attr("dy",".75em")}))},hide:function(t){t.select(".knob-marker").style("visibility","hidden")}}}]);
"use strict";angular.module("charts").factory("knobRegions",["chartUtils",function(t){const e=window.d3_main||window.d3;return{render:function(n,o,a){const r=o.knobs.data;r&&r.length&&t.refresh(n.selectAll(".knob-region"),r,(function(){const t=e.select(this).attr("class","knob-region");t.append("rect"),t.append("foreignObject")}),(function(t){const n=e.select(this),o=a.axes.x.scale(t.positionX),r=a.main.height+a.knob.margin.top,i=a.axes.x.scale(t.next.positionX)-o,{height:s}=a.knob.regions;n.attr("data-from",t.positionX).attr("data-to",t.next.positionX).attr("data-readonly",t.readonly),n.select("rect").attr("fill",t.threshold.color).attr("x",o).attr("y",r).attr("width",i).attr("height",s),n.select("foreignObject").attr("x",o).attr("y",r).attr("width",i).attr("height",s).html('<div class="text">'+t.threshold.name+"</div>")}))}}}]);
"use strict";angular.module("charts").factory("knobShape",(function(){const n=window.d3_main||window.d3;return o;function o(o,t){const i=t.knob.handle.width/2,{height:e}=t.knob.handle,r=t.knob.handle.collapseShift;return x(o)&&y(o)||y(o)&&function n(o){return o.positionX===o.prev.positionX&&(o.prev.readonly||n(o.prev))}(o)||x(o)&&function n(o){return o.positionX===o.next.positionX&&(o.next.readonly||n(o.next))}(o)?u()([{x:0,y:0},{x:i,y:i},{x:i,y:e},{x:-i,y:e},{x:-i,y:i},{x:0,y:0}]):x(o)?u()([{x:-r,y:0},{x:-1.5,y:r-1.5},{x:-1.5,y:e},{x:-r-i,y:e},{x:-r-i,y:i},{x:-r,y:0}]):y(o)?u()([{x:r,y:0},{x:r+i,y:i},{x:r+i,y:e},{x:1.5,y:e},{x:1.5,y:r-1.5},{x:r,y:0}]):null;function x(n){return n.positionX>n.prev.positionX}function y(n){return n.positionX<n.next.positionX}function u(){return n.line().x((n=>n.x)).y((n=>n.y))}}}));
"use strict";angular.module("charts").factory("knobTooltips",(function(){return{render:function(t,o,e){const n=t.find(".knob-region div.text");function i(){n.qtip("destroy",!0)}n.qtip({content:o,show:{delay:500},position:{viewport:!0,my:"bottom center",at:"top center",adjust:{method:"shift none"}},style:{classes:"default tooltip"}}),n.on("remove",i),e.$on("$destroy",i)}}}));
"use strict";angular.module("charts").factory("knobs",["chartUtils","knobShape","knobRegions","knobMarker",function(n,t,e,o){const i=window.d3_main||window.d3;return{render:function(r,s,a,h,l){let c=s.knobs.data;if(!c||!c.length)return;const m=c.filter((function(n){return!n.readonly}));function u(){n.refresh(r.selectAll(".knob"),m,x,f)}function d(n){const t=function(n,t){const e=n.filter(t);return e.length>0?e[e.length-1]:null}(s.series.original.sorted,(function(t){return t.x<n})),e=function(n,t){let e=null;return n.some((n=>!!t(n)&&(e=n,!0))),e}(s.series.original.sorted,(function(t){return t.x>=n})),o=s.series.original.minStep,i=t?t.x+o/2:s.knobs.x.min,r=e?e.x-o/2:s.knobs.x.max,a=Math.round((n-i)/o);return Math.min(a*o+i,r)}function x(){i.select(this).attr("class","knob").append("path")}function f(c){const m=i.select(this);m.attr("transform",n.translate(a.axes.x.scale(c.positionX),a.main.height+a.knob.margin.top+a.knob.regions.height)).call(function(){const t=a.main.height+a.knob.margin.top+a.knob.regions.height;return i.drag().on("drag",(function(h,c){let m=a.axes.x.scale.invert(h.x);m=Math.max(m,c.prev.positionX),m=Math.min(m,c.next.positionX),i.select(this).attr("transform",n.translate(a.axes.x.scale(m),t)),c.positionX=d(m),c.threshold.min=c.positionX,c.threshold.min=Math.max(c.threshold.min,c.prev.threshold.min),c.threshold.min=Math.min(c.threshold.min,c.next.threshold.min),e.render(r,s,a),o.render(r,c,s,a,l)})).on("end",(function(e,s){i.select(this).attr("transform",n.translate(a.axes.x.scale(s.positionX),t)),o.hide(r),u(),h()}))}()),m.select("path").attr("d",t(c,a))}c=[c[0].prev].concat(c).concat([c[c.length-1].next]),c.forEach((function(n){let t=n.threshold.min;t=Math.max(t,s.knobs.x.min),t=Math.min(t,s.knobs.x.max),n.positionX=d(t)})),u()}}}]);
"use strict";angular.module("charts").factory("markerTooltips",(function(){return{render:function(t,e,o){const r=t.find(".marker");function i(){r.qtip("destroy",!0)}r.qtip({content:{text:function(){const t=$(this).prop("__data__");return t.label+": "+e(t.x)}},show:{delay:500},hide:{fixed:!0,delay:100},position:{viewport:!0,my:"middle left",at:"middle right",adjust:{method:"flip none"}},style:{classes:"marker-tooltip histogram-tooltip"}}),r.on("remove",i),o.$on("$destroy",i)}}}));
"use strict";angular.module("charts").factory("markers",["chartUtils",function(t){const e=window.d3_main||window.d3;return{render:function(a,r,n){const l=r.markers.data;function s(t){return n.axes.x.scale(t)}l&&l.length&&(!function(t){t[0].labelPos="left";for(let e=1;e<t.length;e++){const a=s(t[e].x)-s(t[e-1].x);t[e].labelPos=a<30?"right":"left"}}(l),t.refresh(a.selectAll(".marker"),l,(function(){const t=e.select(this);t.attr("class","marker"),t.append("line").attr("x1",0).attr("y1",0).attr("x2",0),t.append("text").attr("class","label").attr("dy","-.5em")}),(function(a){const r=e.select(this);r.attr("transform",t.translate(s(a.x),0)).attr("data-x",a.x),r.select("line").attr("y2",n.main.height),r.select(".label").attr("transform",function(t){return"left"===t.labelPos?"rotate(-90)":"rotate(90)"}(a)).style("text-anchor",function(t){return"left"===t.labelPos?"end":"start"}(a)).text(a.label)})))}}}]);
"use strict";angular.module("charts").factory("OrdinalXStrategy",(function(){const t=window.d3_main||window.d3;function e(t){this.format=t}return e.prototype.getNumberOfBars=function(t){return new Map(t.series.processed.data.map((t=>[t.x,t]))).size},e.prototype.buildXScale=function(e,r,o,a){return t.scalePoint().rangeRound([e+o/2,r-o/2]).domain(a.series.processed.data.map(n))},e.prototype.buildSelectionXAxis=function(e,n){return t.scalePoint().rangeRound(e).domain(n)},e.prototype.getBarDimensions=function(t,e,n){const r=e.series.processed.positions,o=n.bar.maxSpace,a=o*n.bar.marginShare,i=o*r;return{space:o,width:o-a,margin:a,binningRequired:n.bar.minSpace,totalSpace:i,minSpace:o,maxSpace:o}},e.prototype.adjustXAxisSpace=function(t,e){return e},e.prototype.buildFormatter=function(){return this.format},e;function n(t){return t.x}}));
"use strict";angular.module("charts").factory("QuantitativeXStrategy",(function(){const e=window.d3_main||window.d3;function i(e){this.format=e}return i.isApplicable=function(e){if(e.xStrategyType)return"quantitative"===e.xStrategyType;const i=e.every((function(e){return"number"==typeof e.x}));return i&&(e.xStrategyType="quantitative"),i},i.prototype.getNumberOfBars=function(e){return(e.series.original.x.max-e.series.original.x.min)/(e.series.original.minStep||1)+1},i.prototype.buildXScale=function(i,r,t,n){return e.scaleLinear().range([i,r]).domain([n.x.min,n.x.max])},i.prototype.buildSelectionXAxis=function(i,r){return e.scaleLinear().range(i).domain(r)},i.prototype.getXAxisSpace=function(e,i,r){const t=i.series.processed.x.max-i.series.processed.x.min,n=i.x.max-i.x.min,a=function(e){const t=Math.min(e/i.series.processed.positions,r.bar.maxSpace),n=t*r.bar.marginShare;return{space:t,width:t-n,margin:n,minSpace:r.bar.minSpace}}(t/n*e);return a.space*i.series.processed.positions*n/t},i.prototype.getBarDimensions=function(e,i,r){const t=(i.series.processed.x.max-i.series.processed.x.min)/(i.x.max-i.x.min),n=e*t,a=Math.min(n/i.series.processed.positions,r.bar.maxSpace),s=a*r.bar.marginShare;return{space:a,width:a-s,margin:s,binningRequired:a<r.bar.minSpace,totalSpace:a*i.series.processed.positions/t,minSpace:r.bar.minSpace,maxSpace:r.bar.maxSpace}},i.prototype.adjustXAxisSpace=function(e,i){return Math.min(e,i)},i.prototype.buildFormatter=function(){return this.format},i}));
"use strict";angular.module("charts").factory("SemiOrdinalXStrategy",["QuantitativeXStrategy",function(t){function e(t){const e={};t.forEach((function(t){void 0===t.xLabel&&(t.xLabel=t.x,t.x=r(t.x)),e[t.x]=t.xLabel})),this.labels=e}return e.isApplicable=function(e){if(e.xStrategyType)return"semi-ordinal"===e.xStrategyType;const o=e.map((t=>({x:r(t.x)}))),i=function(t){const e={};for(let r=0;r<t.length;++r){if(e.hasOwnProperty(t[r].x))return!1;e[t[r].x]=1}return!0}(o)&&t.isApplicable(o);return i&&(e.xStrategyType="semi-ordinal"),i},e.prototype.getNumberOfBars=t.prototype.getNumberOfBars,e.prototype.buildXScale=t.prototype.buildXScale,e.prototype.buildSelectionXAxis=t.prototype.buildSelectionXAxis,e.prototype.getXAxisSpace=t.prototype.getXAxisSpace,e.prototype.getBarDimensions=t.prototype.getBarDimensions,e.prototype.adjustXAxisSpace=t.prototype.adjustXAxisSpace,e.prototype.buildFormatter=function(){const{labels:t}=this;return function(e){return t[e]}},e;function r(t){const e=/\d+/.exec(t);return!!(e&&e.length>0)&&Number(e[0])}}]);
"use strict";angular.module("charts").factory("chartUtils",(function(){return{refresh:function(t,e,r,a){const n=t.data(e);n.exit().remove(),n.enter().append("g").each(r).merge(n).each(a)},translate:function(t,e){return"translate("+t+", "+e+")"}}}));
"use strict";angular.module("charts").factory("xAxis",["chartUtils",function(t){const e=window.d3_main||window.d3;return{render:function(a,i,s,n,r,o,c){const l=a.node();t.refresh(a.selectAll(".x.axis"),[{}],(function(){e.select(this).classed("x axis",!0).append("text").attr("dy",".75em").style("text-anchor","middle")}),(function(){const a=e.axisBottom(s.axes.x.scale).tickSizeOuter(0).tickFormat(o.buildFormatter());if(s.bar.space===s.bar.maxSpace){const t=i.series.processed.data.map((function(t){return t.x}));(function(t){const e={};let a=0;for(let i=0;i<t.length;++i)e.hasOwnProperty(t[i])||++a;return a})(t)*s.bar.space===Math.round(s.bar.totalSpace)?a.tickValues(t):a.ticks((i.x.max-i.x.min)/i.series.original.minStep)}else{let t=s.bar.totalSpace/(2*s.bar.maxSpace);t=Math.max(t,2),a.ticks(t)}e.select(this).attr("transform",t.translate(0,s.main.height)).call(a).select("text").attr("x",s.main.width/2).attr("y",s.axes.x.label.margin.top).text(n)})),t.refresh(a.selectAll(".auxiliary-x.axis"),[{}],(function(){e.select(this).attr("class","auxiliary-x axis")}),(function(){e.select(this).attr("transform",t.translate(0,s.main.height)).call(e.axisBottom(e.scaleLinear().range([0,s.main.width])).ticks(0).tickSizeOuter(0))}));const x=$(l).find(".x.axis > .tick").filter((function(){return $(this).text().includes("...")}));function d(){x.qtip("destroy",!0)}0!==x.length&&(x.qtip({content:{text:function(){return $(this).prop("__data__")}},show:{delay:500},hide:{fixed:!0,delay:100},position:{viewport:!0,my:"top center",at:"bottom center",adjust:{method:"shift none"}},style:{classes:"color1 histogram-tooltip",tip:{corner:!0}}}),x.on("remove",d),c.$on("$destroy",d))}}}]);
"use strict";angular.module("charts").factory("yAxis",["chartUtils",function(t){const e=window.d3_main||window.d3;return{render:function(n,s,i,o,r,a){const c=o,l=n.node();t.refresh(n.selectAll(".y.axis"),[{}],(function(){e.select(this).classed("y axis",!0).append("text").attr("transform","rotate(-90)").attr("y",6).attr("dy",".75em").style("text-anchor","end")}),(function(){const n=(i.yAxisOnLeft?e.axisLeft:e.axisRight)(i.axes.y.scale).ticks(6).tickSize(i.yAxisOnLeft?6:i.main.width).tickFormat(r),s=e.select(this).classed("over",!i.yAxisOnLeft).attr("transform",t.translate(i.yAxisOnLeft?-i.axes.y.margin.right:0,0)).transition().call(n);e.select(this).select("text").text(i.yAxisOnLeft?function(t){const e=document.createElementNS("http://www.w3.org/2000/svg","text"),n="Sample Text",s=document.createTextNode(n);e.appendChild(s),l.appendChild(e);const o=e.getBBox().width/11;l.removeChild(e);const r=Math.round(i.main.height/o);t.length>r&&(t=t.slice(0,r-4)+"...");return t}(o):""),i.yAxisOnLeft||(s.selectAll("g.tick text").tween("attr.x",null).tween("attr.dy",null),e.select(this).selectAll("g.tick text").attr("x",5).attr("dy",-5))}));const d=$(l).find(".y.axis > text").filter((function(){return $(this).text().includes("...")}));function x(){d.qtip("destroy",!0)}0!==d.length&&(d.qtip({content:{text:function(){$(this).prop("__data__");return c}},show:{delay:500},hide:{fixed:!0,delay:100},position:{target:"mouse",adjust:{mouse:!0}},style:{classes:"color1 histogram-tooltip",tip:{corner:!0}}}),d.on("remove",x),a.$on("$destroy",x))}}}]);
"use strict";angular.module("charts").factory("zIndexSorter",(function(){return{sort:function(e,t){const r=[".bar",".axis",".bar-label",".marker"];e.selectAll(".bar-label").datum(n),r.forEach((function(n,t){e.selectAll(n).each((n=>{n.zIndex=t}))}));const{scale:c}=t.axes.x;e.selectAll(r.join(", ")).sort((function(n,e){return n.zIndex!==e.zIndex?n.zIndex-e.zIndex:c(n.x)-c(e.x)}))}};function n(n){const e={};for(const t in n)n.hasOwnProperty(t)&&(e[t]=n[t]);return e}}));
"use strict";angular.module("services").factory("helpTourShapeLibrary",(function(){const c=[{width:75,height:75,path:"M7,30c-5.4,15.5,5.7,31.7,19,37c20,8,29.7-1.3,38-22C70.6,28.4,51,5,51,5S18.2-2,7,30z"},{width:200,height:75,path:"M190,22c8.7,11,3.6,35.9-9,40c-28,9-46.2,7.9-62,9c-15.3,1-32.7-6.7-48-7c-14.9-0.3-43.8,6.6-58,0c-8.9-4.1-7.1-28.8-6-37C8.7,14.8,17.9,10.7,29,9c12.8-2,40.2-6.4,53-5c13.2,1.4,31.5,11,53,8C160.4,8.5,175.6,3.8,190,22z"},{width:500,height:75,path:"M255,10.5c-15.9,0.4-42.9-3-59-5c-18-2.2-56.1,3.9-66,4c-15.1,0.1-29,6-44-3c-10.5-6.3-23.8,4.1-36,4c-9.8-0.1-32.4-3.1-40,3c-5.4,4.4-7.9,25.6-2,30c13.2,9.9,45.5,23.6,61,27c37.6,8.2,94.6-1.8,128,0c19.2,1,47.7-6.4,67-6c32.9,0.6,98.2,8.3,131,6c17.5-1.2,48.7-4.3,70-8c12.2-2.1,25.2-5,31-16c1.8-3.3-3.2-31.5-6-34c-10.7-9.5-47.5,0.6-59,0c-27.7-1.4-83.8-11.3-110-11C321,1.5,270,10.1,255,10.5z"},{width:850,height:75,path:"M291,5c-34.7-6.3-57.2-1.7-91,3c-28,3.9-54.3-3.5-82,1c-24.1,3.9-50-3.8-74-5C26.8,3.1,15,7,8.3,28.3C2.9,45.8,9,52.7,21,58c27.5,12.1,64.2,0,92,0c28.9,0,45.2,12.1,74,9c29.5-3.1,42-6.6,72-8c14.8-0.7,44.1,0.8,59,1c18.4,0.2,48.7-5,67-5c18.8,0,38.4,7.2,57,8c18.1,0.8,35.1-6.3,53-2c15.1,3.6,32.5,4.3,48,1c12.7-2.7,24.8,4.1,38,2c29.7-4.8,62.8,2.5,93,3c18.8,0.3,43.7-4.5,63-5c15.7-0.4,43.5,2.1,59,3c17.3,1,44.5,0.7,49-23c2.6-13.3-3.9-27.7-15-34c-21-11.9-71.5,1.1-94,0c-31.2-1.6-67.7,5.3-98-3c-16.8-4.6-35,0-53-1c-17.2-1-33.9,4-51,4c-14,0-26.8,5.3-40,0c-14.5-5.8-27.9-3.9-44-4c-10-0.1-21.2,1.6-30,3c-11.7,1.9-34.5-3.3-46-4C354.3,1.9,329.4,12,291,5z"},{width:1400,height:75,path:"M945,2c-16-1.2-35.8,0.7-52,0c-21.2-0.9-44.2,9.7-65,7c-24.9-3.3-58.2-6.4-83-4c-70,6.7-127.5,16.6-170,11c-26-3.4-60.5-12.2-87-14c-30.9-2.1-85.5,5.9-116,9c-33.3,3.4-33.7-9-67-9c-23.7,0-46.5,13.2-70,9c-16.2-2.9-16.6-9-33-9c-23,0-65,3.9-87,10c-18.5,5.1-32.9-8.8-52-7C45.4,6.7,20.7,2.4,10,20C3.7,30.2,4.8,46.4,7,58c1.7,8.6,18.8,8.2,28,10c18.7,3.7,43.2,5.8,62,6c31.7,0.3,76.2-9.9,105-11c112.6-4.2,195.9,17.9,308,5c58.7-6.8,129.6,2.9,188,5c28.6,1,38.7-2.4,67-8c26.2-5.2,37.1,7,64,7c20.9,0,58.4-4.1,79-4c15.2,0.1,101.6-7.5,117-7c32,1.1,4.8,13.6,37,11c19.9-1.6,78-10.1,98-9c30.1,1.6,94.4,9.5,126,9c44.7-0.7,79.9-2.3,100-17c9.8-7.2-5.5-25.7-14-34c-21.2-20.9-74.2-19.7-102-15c-31,5.2-56.5,7.7-88,9c-10.8,0.5-20.1-2.9-31-3c-14.3-0.2-29.7-0.6-44,0c-27.6,1.2-54.4,4.2-82,1C1004.9,10.6,965.1,3.5,945,2z"},{width:200,height:200,path:"M198,85c0.1-6.8-6.8-14.3-8-21c-2.6-14.1,6.3-12.7,6-28c-0.3-11.8,4.3-15.8-4-23c-8.7-7.5-24.3-8-39-4c-11.1,3-35.3-5.1-55-2c-19.4,3.1-23.7,1.3-45,0c-16.7-1-30.5-5.9-41,5c-7.8,8.2-7.3,29.7-7,45c0.2,11.4,12,26.7,2,39c-7.5,9.2,4.7,27.7,1,48c-4.1,22.8,4.5,32.9,10,42c4.3,7,27.2,7.8,35,8c19,0.5,46.3-5,56-6.7c14-2.3,14.7,10,32,10c4.6,0,26.7-4.7,31-6.3c7.2-2.7,14.5-25.1,17-33C195.9,135.5,197.8,103.5,198,85z"},{width:500,height:200,path:"M19,5.5c-5.6,3.5-8.2,53.1-10,62c-3.2,16.2,3.1,21.8,6,38c2.3,12.8-3.1,37.4,0,50c2.8,11.3,11.1,26.4,19,35c8.7,9.5,42.8-3.9,55,0c27.3,8.7,43.7,5.3,72,8c25.8,2.4,50.6-1.5,76-6c22.1-3.9,78.5,4,99,4c20.7,0,80.8-5.9,94-5c9.7,0.6,53.6-11.9,59-20c5-7.5,6.5-29.5,6-38c-1-14.9-8.3-36.2-10-51c-2.5-21.3,10-39.3-3-57c-6.2-8.4-46.5-16.7-52-18c-17-4-38.4,4.7-55,8c-38.9,7.7-79.6-9.4-119-8c-20.3,0.7-47.7,3.2-68,3c-20.1-0.2-30.1,9.3-50,6c-23.8-4-2-6.9-26-10C99.5,4.9,27.1,0.5,19,5.5z"},{width:850,height:200,path:"M610,7.5c32.3,2.1,66.6,8,99,8c28.6,0,55.4-9.3,84-7c23,1.9,36.5,15.9,46,38c4.4,10.4,9.3,27.8,9,39c-0.5,15.3-16.8,20.1-19,35c-2,13.7,8,18.2,6,32c-2.1,14.7-4,34-20,37c-20.5,3.8-51.2-4.5-72-2c-14.1,1.7-30.7,7.4-45,8c-13.4,0.6-29.6-6.2-43-6c-25.3,0.3-46.3,13-75,2c-31.3-12-54.4,7.8-88,6c-23.1-1.2-65-5.6-88-6c-23.6-0.4-42.7-0.2-66,3c-39.7,5.5-64.1-0.6-104,1c-19.8,0.8-73.2,7.3-93,8c-14.2,0.5-61.8-7.1-84-11c-8.3-1.5-15.7-11.4-22-17c-20.5-18-14-35.1-21-60c-4.3-15.5-5.1-27.2-3-43c2.2-16.8-1.3-44,15-50c12.9-4.7,31.5-13.6,45-12c21.2,2.6,43-3.1,64-6c18.1-2.5,37.9,7.3,56,5c44.9-5.7,80.9,8.6,126,6c41.6-2.4,82.3-9.9,124-10c24-0.1,50.9,2.9,75,6C539.2,14.5,610,7.5,610,7.5z"},{width:1400,height:200,path:"M206,7.5c-50.2-3.3-75.8-5.7-126-4c-10.7,0.4-44.3,8.9-50,14c-16.8,15-22.7,25.4-26,47c-3.5,22.9,6.5,30.5,11,65c3.5,27.4-10,54.3,0,63c7,6.1,34.8,4.4,43,3c36.1-6,73.4-10.4,110-10c16.6,0.2,35,2.6,51,7c38.6,10.6,84.2-5.6,124-3c73.1,4.8,140.1,1.5,213,6c96.9,5.9,192.3-1,289-5c45.1-1.9,91.1,9.2,136,4c34.8-4,72-8.8,107-7c34,1.8,58.2,8,92,3c28.2-4.2,61.2-10.1,90-10c21.8,0.1,78.2,19.8,98,10c27-13.4,23-54.2,24-83c0.9-26.7,11.5-54.6-6-77c-12.1-15.5-31.9-16.7-50-20c-31.1-5.6-63.4-9.8-95-8c-25.9,1.5-51.3,9.4-77,11c-12.9,0.8-29.1-5-42-5c-21.3,0-38.8,7.8-60,8c-82,0.7-218-3-296-9c-31.6-2.4-12.4,7.8-44,5c-57.2-5.1-114.7-2.4-172-2c-36.9,0.3-73.3-3.5-110,0c-40.6,3.9-79.3,5.9-120,4C292.2,13.2,233.8,9.4,206,7.5z"}];return{getShape(h,t){let e=0;return c.reduce(((c,i,a)=>{const r=Math.abs(i.width-h)+Math.abs(i.height-t);return r<c?(e=a,r):c}),h+t),c[e]}}}));
"use strict";angular.module("ui").directive("tourOverlayCanvas",["$timeout","helpTourShapeLibrary",function(t,e){return{restrict:"E",template:'<div ng-click="onOverlayClick($event)"><canvas class="tour-overlay-canvas" data-test-marker="help-tour"></canvas><div class="tour-close" localize="localize" default-msg-catalog="htmlutil1">{{::localize(\'%HelpTour.hotkeyToCancelHelpTour\')}} <span class="icon cross active" ng-click="onClose()"></span></div><div class="tour-callout" ng-show="::showOnStart" ng-class="{active:!isLoading}"><span class="tour-pointer"><div class="icon handdrawn-arrow-from-right-to-top"></div><div class="tour-navigation-panel"><span class="icon chevron-left active" ng-click="onPrevClick()"></span> {{itemData.stepNumber}}/{{itemData.totalSteps}} <span class="icon chevron-right active" ng-click="onNextClick()"></span></div></span><span class="tour-item-description" html-content="{{itemData.description}}"></span></div><loading show-when="isLoading"></loading></div>',link:function(i,n){const[a]=n.find("canvas"),o=a.getContext("2d"),[s]=n.find(".tour-callout");function l(e){switch(e.keyCode){case 27:t((()=>i.onClose()));break;case 32:case 39:t((()=>i.onNextClick()));break;case 37:t((()=>i.onPrevClick()))}}function c(){t((()=>{a.width=a.clientWidth,a.height=a.clientHeight,d(),r()}))}function r(){if(i.itemData&&i.itemData.element){const t=i.itemData.element.getBoundingClientRect();!function(t){const i=10;if(o){o.save();const n=i+t.width+i,a=i+t.height+i,s=e.getShape(n,a),l=new Path2D(s.path),c=n/s.width,r=a/s.height;o.transform(c,0,0,r,t.left-i,t.top-i),o.globalCompositeOperation="destination-out",o.fill(l),o.restore()}}(t),function(t){if(s){i.isLoading=!1;const e=s.getBoundingClientRect();s&&s.classList.remove("up","bottom","right","left"),window.innerHeight-t.bottom-e.height>0?(s.classList.add("bottom"),s.style.top=t.bottom+8+"px"):(s.classList.add("up"),s.style.top=t.top-e.height-8+"px"),window.innerWidth-t.left-e.width>0?(s.classList.add("left"),s.style.left=t.left+"px"):(s.classList.add("right"),s.style.left=t.right-e.width+"px")}}(t),i.showOnStart=!0}}function d(){i.isLoading=!0,o&&(o.fillStyle="#000",o.fillRect(0,0,o.canvas.width,o.canvas.height))}i.itemData=i.getItemData(),document.addEventListener("keydown",l),window.addEventListener("resize",c),i.$on("$destroy",(()=>{document.removeEventListener("keydown",l),window.removeEventListener("resize",c)})),i.onOverlayClick=t=>{t&&$(t.target).is("a")||i.onNextClick()},i.onNextClick=()=>{i.isLoading||(d(),i.next().then((()=>{i.itemData=i.getItemData(),t(r)})))},i.onPrevClick=()=>{i.isLoading||(d(),i.previous().then((()=>{i.itemData=i.getItemData(),t(r)})))},i.onClose=()=>{i.stop()},c()}}}]);
"use strict";angular.module("ui").directive("tourOverlay",(function(){return{restrict:"E",template:'<div ng-if="visible" class="tour-overlay"><tour-overlay-canvas></tour-overlay-canvas></div>',link:function(i){i.show=()=>{i.visible=!0},i.hide=()=>{i.visible=!1}}}}));
"use strict";angular.module("metric").controller("metricTooltipController",["$scope","bigNumber",function(t,o){const e=t.tooltipData&&!1===t.tooltipData.confidence;t.tooltipData&&(e?t.headerText=t.tooltipData.confidenceText:(t.headerText=t.tooltipData.description||t.tooltipData.name,t.issues=(()=>{const e=[];if(t.tooltipData.issuesMask&&t.tooltipData.issues){const s=o(t.tooltipData.issuesMask);s&&s.isGreaterThan(0)&&s.toString(2).split("").reverse().forEach(((o,s)=>{if("1"===o){const o=t.tooltipData.issues[s];o&&o.issueText&&e.push(o.issueText)}}))}return e})()))}]);
"use strict";angular.module("metric").directive("metricTooltip",(function(){return{restrict:"E",scope:{tooltipData:"="},template:'<div class="metric-tooltip"><div ng-if="::headerText">{{ ::headerText }}</div><div class="issue" ng-repeat="issue in ::issues track by $index"><span class="icon flag-o red-flag"></span> <span>{{ ::issue }}</span></div></div>',controller:"metricTooltipController"}}));
"use strict";angular.module("services").factory("diContainer",["$q",function(e){const n=e((e=>{require(["@analyzers/frontend-di-container"],(n=>e(n.createContainer())))}));return{getContainer:()=>n}}]);
"use strict";angular.module("services").factory("bigNumber",(function(){return function(e){if(null!=e)return new BigNumber("bigInt"===e.type?e.value:e.toString())}}));
"use strict";angular.module("services").factory("format",["standardFormat","histogramFormat",function(r,t){return function(a,n,o){return n&&-1!==n.indexOf("histogram")?t(a,n,o):r(a)}}]);
"use strict";angular.module("services").factory("histogramFormat",(function(){return function(e,t,a){let n;const i={time:r,timeAndBar:r,frequency:s},l=JSON.parse(JSON.stringify(a||{}));l.maxTotalLength=70,-1!==t.indexOf("axis")&&(l.maxTotalLength=8);const m=3,u=2;return e.name.indexOf("Frequency")>-1?s:i[e.format]||o;function r(e){return"number"!=typeof e?e:((!l.maxAbsValue||n&&Math.abs(e)*n.multiplier>l.maxAbsValue)&&(l.maxAbsValue=Math.abs(e),n=void 0),n||(n={},l.maxAbsValue>=1*u?(n.name="s",n.multiplier=1):l.maxAbsValue>=.001*u?(n.name="ms",n.multiplier=1e3):(n.name="usec",n.multiplier=1e6),l.maxAbsValue*=n.multiplier),0===e?"0"+n.name:o(e*n.multiplier,n.name.length,!1)+n.name)}function s(e){return"number"!=typeof e?e:((!l.maxAbsValue||n&&Math.abs(e)*n.multiplier>l.maxAbsValue)&&(l.maxAbsValue=Math.abs(e),n=void 0),n||(n={},l.maxAbsValue>=1e3*u*1e3*1e3?(n.name="GHz",n.multiplier=1e-9):l.maxAbsValue>=1e3*u*1e3?(n.name="MHz",n.multiplier=1e-6):l.maxAbsValue>=1e3*u?(n.name="KHz",n.multiplier=.001):(n.name="Hz",n.multiplier=1),l.maxAbsValue*=n.multiplier),0===e?"0"+n.name:(Number.isInteger(e*n.multiplier)||(l.valuesType="float"),o(e*n.multiplier,n.name.length,!1)+n.name))}function o(e,t,a){if(void 0===a&&(a=!0),void 0===t&&(t=0),0===e)return"0";if("number"!=typeof e){const{maxTotalLength:t}=l;return e&&e.length>t&&(e=e.slice(0,t-2)+"..."),e}(!l.maxAbsValue||Math.abs(e)>l.maxAbsValue)&&(l.maxAbsValue=Math.abs(e)),void 0===l.valuesType&&(l.valuesType=Number.isInteger(e)?"integer":"float");let n=l.maxTotalLength-t;e<0&&n--;const i=n-5;if("integer"===l.valuesType)return function(e){if(a&&l.maxAbsValue>=Math.pow(10,n))return e.toExponential(e.toExponential().length>n?Math.min(i,m):void 0);return e.toLocaleString("en")}(e);if("float"===l.valuesType)return function(e){if(a&&(l.maxAbsValue>=Math.pow(10,n)||l.maxAbsValue<.01))return e.toExponential(e.toExponential().length>n?Math.min(i,m):void 0);const t=e.toString().length,u=parseInt(e).toString().length,r=Number.isInteger(e)?0:Math.max(t-u-1,0),s=Math.min(r,Math.max(0,n-u-(Number.isInteger(e)?0:1)));return e.toFixed(Math.min(s,m))}(e)}}}));
"use strict";angular.module("services").factory("standardFormat",(function(){const e={time:t,timeAndBar:t};return function(t){return e[t.format]||r};function t(e){if("number"!=typeof e)return e;if(0===e)return"0s";let t="s";return e<1e-6?t="usec":e<.001&&(t="ms"),"ms"===t?e*=1e3:"usec"===t&&(e*=1e6),e.toFixed(3)+t}function r(e){return"number"!=typeof e?e:e.toFixed(0)===e?e.toFixed(0):e.toFixed(3)}}));
"use strict";angular.module("services").factory("textFormat",["bigNumber",function(e){const t={time:function(t,n){let i="s";t=e(t),(n=e(n))&&(n.isLessThan(.001)?i="usec":n.isLessThan(1)&&(i="ms"));if(t.isEqualTo(0))return"0"+i;"ms"===i?t=t.multipliedBy(1e3):"usec"===i&&(t=t.multipliedBy(1e6));return t.toFormat(r)+i},timeScientific:function(e){return a(e)+"s"},count:l,integer:l,number:l,double:function(t){return e(t).toFormat(r)},scientific:a,hex:function(t){return(t=e(t)).isEqualTo(0)?"0":c+t.toString(16)},memory:function(t){let n="";t<0&&(n="-",t=0-t);if((t=e(t)).isEqualTo(0))return"0 B";let r=0;for(;t.isGreaterThanOrEqualTo(1e3);)r++,t=t.dividedBy(1e3);return n+t.decimalPlaces(i,4)+[" B"," KB"," MB"," GB"," TB"," PB"," EB"," ZB"," YB"][r]},ratio:function(t){return e(t).multipliedBy(100).toFixed(n)+u},percent:f,percent_by:f,LargeNumber:function(t){let n="";t<0&&(n="-",t=0-t);t=e(t);const r=["","K","M","G","T","P","E","Z","Y"];let i=0,o=t;for(;o.isGreaterThanOrEqualTo(1e3);)i++,o=o.dividedBy(1e3);return i<r.length?n+o.decimalPlaces(0)+r[i]:n+t.toExponential(2)},frequency:function(t,n){if("number"!=typeof t)return t;let r="";t<0&&(r="-",t=0-t);t=e(t),n=e(n);let i=0;const u=[" Hz"," KHz"," MHz"," GHz"];let c=void 0===n?t:n;for(;c.isGreaterThanOrEqualTo(1e3)&&i<u.length-1;)i++,c=c.dividedBy(1e3);const l=t.dividedBy(Math.pow(1e3,i));return r+l.toFixed(o)+u[i]}},n=1,r=3,i=1,o=1,u="%",c="0x";return function(e,n,r){return function(i){if(null==i)return n;if("number"!=typeof i&&"bigInt"!==i.type)return i;!function(e){const t=BigNumber.config();t.FORMAT.groupSeparator="count"===e?",":""}(e);const o=t[e]?t[e](i,r):s(i);return BigNumber.config().FORMAT.groupSeparator=",",o}};function l(t){return e(t).toFormat(0)}function a(t){return e(t).toExponential(r)}function f(t,r){return null===r||0===r||0===r.value?s(t):(t=e(t),r=e(r),(t=t.multipliedBy(100).dividedBy(r)).toFixed(n)+u)}function s(t){return(t=e(t)).toFixed(0)===t.toString()?t.toFixed(0):t.toFixed(r)}}]);
"use strict";$((function(){$(document).keydown((e=>{if((e.ctrlKey||e.metaKey)&&65===e.keyCode&&!$(e.target).is("input"))return!1}))}));
"use strict";angular.module("sizeWatcher").factory("sizeWatcher",(function(){const e=new Set;return window.addEventListener("resize",(function(){if(e.size)for(const t of e)t.processWindowResize()}),!1),window.addEventListener("splitter-resize",(function(t){if(e.size)for(const s of e)s.processSplitterResize(t)})),function(t,s,i){const n=$(t);let o=t.offsetWidth,r=t.offsetHeight;const c={processWindowResize(){n.is(":visible")&&d()},processSplitterResize(e){n.is(":visible")&&(n.parents(`#${e.detail.primaryElementId}`).length||n.parents(`#${e.detail.secondaryElementId}`).length)&&d()}};function d(){const e=t.offsetWidth,s=t.offsetHeight;o===e&&r===s||(o=e,r=s,i())}e.add(c),s.$on("$destroy",(()=>{e.delete(c)}))}}));
"use strict";angular.module("recursiveDirectiveCompiler").factory("RecursiveDirectiveCompiler",["$compile",function(e){return{compile:function(r){const t=r.contents().remove();let i;return{post:function(r,c){i||(i=e(t)),i(r,(e=>{c.append(e)}))}}}}}]);
"use strict";angular.module("utube").controller("utubeTestSandboxController",["$scope",function(e){const t="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";e.utubeData={frontEnd:{name:"Front-End Bound",value:.2712,issues:"Issue text",description:"Description text"},memory:{name:"Memory Bound",value:.1489,issues:"",description:"Description text"},retiring:{name:"Retiring",value:.2407,description:"Description text"},core:{name:"Core Bound",value:.2189,issues:t,description:"Description text"},badSpec:{name:"Bad Speculation",value:.2612,issues:"",description:"Description text"}},e.onClickSet1Button=()=>{e.utubeData.frontEnd.value=.5712,e.utubeData.frontEnd.issues=t,e.utubeData.memory.value=.0535,e.utubeData.memory.issues="",e.utubeData.retiring.value=.1012,e.utubeData.core.value=.0323,e.utubeData.core.issues="",e.utubeData.badSpec.value=.0667,e.utubeData.badSpec.issues="",e.reCalculate()},e.onClickSet2Button=()=>{e.utubeData.frontEnd.value=.0123,e.utubeData.frontEnd.issues="",e.utubeData.memory.value=.6535,e.utubeData.memory.issues=t,e.utubeData.retiring.value=.0123,e.utubeData.core.value=.0323,e.utubeData.core.issues="",e.utubeData.badSpec.value=.1667,e.utubeData.badSpec.issues="",e.reCalculate()},e.onClickSet3Button=()=>{e.utubeData.frontEnd.value=.0567,e.utubeData.frontEnd.issues="",e.utubeData.memory.value=.1023,e.utubeData.memory.issues="",e.utubeData.retiring.value=.2567,e.utubeData.core.value=.2012,e.utubeData.core.issues=t,e.utubeData.badSpec.value=.4034,e.utubeData.badSpec.issues=t,e.reCalculate()},e.onClickRandomButton=()=>{let t=1;function u(e){const u=Math.random()*e*t;return t-=u,Math.round(100*u)/100}e.utubeData.frontEnd.value=u(1),e.utubeData.frontEnd.issues=e.utubeData.frontEnd.value>.15?"Issue text":"",e.utubeData.memory.value=u(.5),e.utubeData.memory.issues=e.utubeData.memory.value>.15?"Issue text":"",e.utubeData.retiring.value=u(.2),e.utubeData.core.value=u(.5),e.utubeData.core.issues=e.utubeData.core.value>.15?"Issue text":"",e.utubeData.badSpec.value=u(1),e.utubeData.badSpec.issues=e.utubeData.badSpec.value>.15?"Issue text":"",e.reCalculate()}}]);
"use strict";angular.module("widgets").controller("AnalysisTreeController",["$scope",function(e){const t=["CUSTOM ANALYSES","PERFORMANCE SNAPSHOT"];function o(t){for(let o=0;o<e.data.length;o++){const n=e.data[o];if(n.id===t)return n}}e.getTreeLevel=t=>"level-"+Math.ceil((e.nonCustomGroupsNumber-t)/2),e.nonCustomGroupsNumber=0,e.getIconClassName=e=>e.iconClassname||"gear10",e.getNonCustomGroups=()=>{const o=[];return e.data.forEach((e=>{t.includes(e.id)||o.push(e)})),e.nonCustomGroupsNumber=o.length,o},e.getCustomGroup=()=>{const e=o(t[0]);if(e&&e.types.length>0)return e},e.getPerfSnapshotGroup=()=>o(t[1]),e.getAnalysisType=t=>{for(const o of e.data)for(const e of o.types||[])if(e.id===t)return e}}]);
"use strict";angular.module("widgets").directive("analysisTree",(function(){return{restrict:"E",template:'<div class="analysis-tree"><div class="above-tree-group" ng-class="{\'odd\': (nonCustomGroupsNumber%2) }"><badge ng-repeat="type in getPerfSnapshotGroup().types track by type.id" ng-click="onClickHandler(type)" name="::type.name" tooltip="{{ ::type.tooltip }}" is-selected="type.id == selectedId" icon-class="::getIconClassName(type)" id="{{ ::type.id }}"></badge></div><div class="group" ng-class="[getTreeLevel($index), { \'even\': $even, \'odd\': $odd }]" ng-repeat="group in getNonCustomGroups() track by group.id"><div class="group-title" html-content="{{group.name}}"></div><div class="arrow"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 65 1200"><path d="M55,0v1120c0,11-9,20-20,20H25v-10l-25,35l25,35v-10c22.1,0,40-17.9,40-40V0H55z"/></svg></div><badge ng-repeat="type in group.types track by type.id" ng-click="onClickHandler(type)" name="::type.name" tooltip="{{ ::type.tooltip }}" is-selected="type.id == selectedId" is-spotlight="::type.isApplicable" icon-class="::getIconClassName(type)" id="{{ ::type.id }}">{{ type.isApplicable ? type.metric : \'\' }}</badge></div><div class="under-tree-group" ng-show="getCustomGroup()"><div class="group-title">{{ getCustomGroup().name }}</div><badge ng-repeat="type in getCustomGroup().types track by type.id" ng-click="onClickHandler(type)" name="::type.name" tooltip="{{ ::type.tooltip }}" is-selected="type.id == selectedId" icon-class="::getIconClassName(type)" id="{{ ::type.id }}"></badge></div></div>',controller:"AnalysisTreeController",scope:{data:"<",selectedId:"=",onClickHandler:"<"}}}));
"use strict";angular.module("widgets").directive("brandedHeader",["productManager",function(e){return{restrict:"E",transclude:!0,scope:{caption:"<"},template:'<div class="branded-header"><div class="title">{{::caption}}</div><ng-transclude></ng-transclude><div class="brand-name">{{::productState.productNames.brandName}}</div></div>',controller:["$scope",function(t){t.productState=e.state}]}}]);
"use strict";angular.module("widgets").directive("badge",(function(){return{restrict:"E",transclude:!0,scope:{name:"<",iconClass:"<",isSelected:"<",isActive:"<",isSpotlight:"<"},template:'<div class="badge" ng-class="{ selected: isSelected, spotlight: isSpotlight }" data-tour-item="PSAnalysisTypeTourItem"><span class="icon-slot"><span class="icon" ng-class="iconClass"></span></span><div class="name">{{ ::name }}</div><div class="extra" ng-transclude></div></div>'}}));
"use strict";angular.module("widgets").controller("confirmationButtonController",["$scope","$timeout",function(o,e){let n;o.onClick=()=>{o.confirmationNeeded?o.onConfirm():o.confirmationNeeded=!0},o.onMouseLeave=()=>{n=e((()=>{o.confirmationNeeded=!1}),1200)},o.onMouseEnter=()=>{n&&e.cancel(n)}}]);
"use strict";angular.module("widgets").directive("confirmationButton",(function(){return{restrict:"E",scope:{onConfirm:"&",icon:"@",confirmation:"=",disabled:"=",confirmationTooltip:"="},template:'<div class="ui big circular borderless button icon" ng-class="{confirmation: confirmationNeeded, disabled: disabled}" ng-click="onClick()" ng-mouseleave="onMouseLeave()" ng-mouseenter="onMouseEnter()"><i class="icon {{ ::icon }}" tooltip="{{ confirmationTooltip }}"></i> <span ng-show="confirmationNeeded">{{ confirmation }}</span></div>',controller:"confirmationButtonController"}}));
"use strict";angular.module("widgets").controller("ConfirmationDialogController",["$scope","confirmationDialog",function(e,i){e.visible=!1,e.show=i=>{e.visible=!0,e.headerMessage=i.headerMessage,e.descriptionMessage=i.descriptionMessage,e.confirm=()=>{e.visible=!1,i.onConfirm&&i.onConfirm()},e.cancel=()=>{e.visible=!1,i.onCancel&&i.onCancel()}},i.init(e.show)}]);
"use strict";angular.module("widgets").directive("confirmationDialog",(function(){return{restrict:"E",scope:{show:"="},template:'<modal-dialog ng-if="visible" width="auto" localize="localize" default-msg-catalog="htmlui1" on-close="cancel"><h4 class="ui dividing header">{{::localize(headerMessage)}}</h4><p html-content="{{::localize(descriptionMessage)}}"></p><div class="modal-dialog-buttons"><button class="ui primary button" ng-click="confirm()" auto-focus>{{::localize(\'%Yes\')}}</button> <button class="ui button" ng-click="cancel()">{{::localize(\'%No\')}}</button></div></modal-dialog>',controller:"ConfirmationDialogController"}}));
"use strict";angular.module("widgets").directive("ctxmenu",["jqueryCtxMenu",function(t){return{restrict:"A",link:function(n,e,u){const c=n.$watch((function(){return n.$eval(u.ctxmenu)}),(function(u){u&&(t(e,u),n.$on("$destroy",(function(){u&&u.destroy(),c&&c()})),c())}))}}}]);
"use strict";angular.module("widgets").factory("jqueryCtxMenu",["$timeout",function(e){const t=function*(){let e=1;for(;;)yield e++}();return function(n,o){const c="jquery-ctx-menu-"+t.next().value,i="."+c;let u;function s(){const e=document.getElementById("context-menu-layer");e&&($(e).off("mousedown"),e.addEventListener("mousedown",(t=>{n.contextMenu("hide"),$(e).hide();const o=document.elementFromPoint(t.clientX-window.scrollX,t.clientY-window.scrollY);o&&o.dispatchEvent(new MouseEvent("mousedown",t))}),!0))}function r(t){if("string"!=typeof t&&(t.className=t.default?"default ":"",void 0!==t.checked&&t.checked&&(t.icon="check"),t.isHtmlName=!0,t.name='<i class="icon '+t.icon+'"></i>'+t.name,t.icon=void 0,t.click&&(t.callback=function(t){return function(){e((()=>t.click()))}}(t)),t.items))for(const e in t.items)r(t.items[e])}n.addClass(c),$.contextMenu({selector:i,trigger:o.trigger||"right",build:function(){const e=o.getItems();if(!e||!Object.keys(e).length)return!1;for(const t in e)r(e[t]);return{items:e}},reposition:!1,events:{show:e=>{u=e,setTimeout(s)}},zIndex:15e3}),o.destroy=function(){return $.contextMenu("destroy",i)},o.hide=function(){return n.contextMenu("hide")},o.show=function(e){return n.contextMenu(e)},o.update=function(){u&&setTimeout((()=>$.contextMenu.op.update.call($(i),u)))},n.on("remove",(()=>{$.contextMenu("destroy",i)}))}}]);
"use strict";angular.module("widgets").controller("ExpanderController",["$scope",function(n){const e=n.$watch("[expandedByDefault, loading]",(function(){n.expanded=n.expandedByDefault&&!n.loading}));n.$on("$destroy",(function(){e&&e()}))}]);
"use strict";angular.module("widgets").directive("expander",(function(){return{replace:!0,scope:{expandedByDefault:"=",expanded:"=",loading:"=?"},template:'<div class="expander" ng-mousedown="expanded = !expanded"><span ng-if="loading" class="icon spin circle-third loading"></span> <span ng-if="!loading" class="icon angle-circle-right" ng-class="{expanded: expanded}"></span></div>',controller:"ExpanderController"}}));
"use strict";angular.module("widgets").filter("percentage",["$filter",function(e){return function(r,t){return e("number")(100*r,t)+"%"}}]);
"use strict";angular.module("widgets").directive("actionLink",["ideIntegrationManager","linkProvider","localize","productManager","productMode","productHelp",function(n,i,e,a,t,r){return{restrict:"A",link:function(o,s,l){i.bindLink(o,s,(function(){const s=i.parseActionLink(l.actionLink);if("navigate"===s.type)o.$emit("result:navigate",{activate:{tabId:s.tabId,handlerId:s.handlerId,grouping:s.grouping}});else if("collection"===s.type)return(d=s.analysisId,t.isExtensionMode()?n.configureAnalysis({analysisId:d}):e(d,"analysis_type").then((n=>a.configureAnalysis({analysisId:d,analysisName:n})))).catch((()=>{if(s.helpId)return r.openHelpLink(s.helpId)}));var d}))}}}]);
"use strict";angular.module("widgets").directive("helpLink",["linkProvider","productHelp",function(n,i){return{restrict:"A",link:function(e,r,t){n.bindLink(e,r,(function(){return i.openHelpLink(t.helpLink)}))}}}]);
"use strict";angular.module("widgets").factory("linkProvider",(function(){return{bindLink:function(o,n,i){function t(){$(n).on("click",i)}o.isTooltip&&o.actions&&o.actions.onShowTooltip?o.actions.onShowTooltip(t):t(),o.$on("$destroy",(function(){$(n).off("click",i)}))},parseActionLink(o){const n=new URL(o,"http://fake"),i={};return n.searchParams.forEach(((o,n)=>{i[n]=o})),i}}}));
"use strict";angular.module("widgets").directive("webLink",["linkProvider","productHelp",function(n,i){return{restrict:"A",link:function(e,r,t){n.bindLink(e,r,(function(){return i.openWebLink(t.webLink)}))}}}]);
"use strict";angular.module("widgets").directive("defaultMsgCatalog",(function(){return{restrict:"A",controller:()=>{},link:function(t,e,a,l){l.name=a.defaultMsgCatalog}}}));
"use strict";angular.module("widgets").directive("localize",["localize",function(e){return{restrict:"A",require:"^defaultMsgCatalog",link:function(i,l,t,n){i[t.localize]=(i,l)=>e.synchronously(i,l||n.name)}}}]);
"use strict";angular.module("widgets").directive("htmlContent",["$compile",function(t){return{restrict:"A",link:function(n,e,i){const o=i.$observe("htmlContent",(i=>{if(i){const[o]=t(`<div>${i}</div>`)(n,(()=>{}));e.empty(),e.append(o.childNodes)}}));n.$on("$destroy",(function(){o&&o()}))}}}]);
"use strict";angular.module("widgets").controller("NotificationsController",["$scope","notifications",function(o,t){t.addEventListener("update",(()=>{o.notification=t.top()})),o.close=()=>{t.pop()}}]);
"use strict";angular.module("widgets").directive("notifications",(function(){return{restrict:"E",scope:{},template:'<notification localize="localize" ng-if="notification" type="notification.type" on-close="close()" message="localize(notification.message, notification.messageCatalog)">{{localize(notification.description, notification.messageCatalog)}}</notification>',controller:"NotificationsController"}}));
"use strict";angular.module("widgets").factory("notifications",["$timeout",function(t){class i extends EventTarget{constructor(){super(),this._notifications=[]}info(t,i,n="",e){this._add("info",t,i,n,e)}warning(t,i,n="",e){this._add("warning",t,i,n,e)}_deleteItem(t){const i=this._notifications.indexOf(t);-1!==i&&this._notifications.splice(i,1),this._sendUpdateNotification()}_sendUpdateNotification(){this.dispatchEvent(new Event("update"))}_add(i,n,e,s,o){const a={type:i,message:n,messageCatalog:e,description:s,closeAfter:o};return this._notifications.push(a),this._sendUpdateNotification(),o&&t((()=>{this._deleteItem(a)}),o),a}pop(){this._notifications.pop(),this._sendUpdateNotification()}top(){return this._notifications.slice(-1)[0]}}return new i}]);
"use strict";angular.module("widgets").directive("overflowEllipsis",["sizeWatcher","$timeout",function(e,t){return{restrict:"A",link:function(i,s,r){const[o]=s;function l(){o.offsetWidth<o.scrollWidth?s.attr("title",s.text().replace(/\s+/g," ")):s.attr("title","")}s.addClass("overflow-ellipsis"),"onResize"===r.overflowEllipsis?(o.refreshSize=l,window.addEventListener("resize",l,!0),t(l,200),i.$on("$destroy",(function(){window.removeEventListener("resize",l,!0)}))):(s.addClass("overflow-ellipsis"),e(s[0],i,l))}}}]);
"use strict";angular.module("widgets").directive("overheadBarChart",(function(){return{restrict:"E",template:'<div class="label">{{::titleText}}</div><div class="bars"></div>',scope:{maxValue:"=",value:"=",titleText:"<?"},link:function(a,e){const t=e.find("div.bars");for(let e=1;e<=a.maxValue;e++){const l=$("<span/>",{class:"bar",height:100*Math.pow(e/a.maxValue,2)+"%"});t.append(l)}const l=a.$watch("value",(function(){e.find("span.bar").each(((e,t)=>{e<a.value?$(t).addClass("filled"):$(t).removeClass("filled")}))}));a.$on("$destroy",(function(){l&&l()}))}}}));
"use strict";angular.module("widgets").directive("scrollPositionMaintainer",(function(){return{restrict:"A",link:function(n,t){const[o]=t;let e=o.scrollTop;function i(){e=o.scrollTop}o.addEventListener("scroll",i),n.$on("pane:activated",(function(){o.scrollTop=e})),n.$on("$destroy",(function(){o.removeEventListener("scroll",i)}))}}}));
"use strict";angular.module("widgets").directive("sizeClassifier",["sizeWatcher",function(e){return{restrict:"A",link:function(i,t){let s;function n(){const e=(i=t[0].clientWidth)>2400?"XXL":i>1900?"XL":i>1500?"L":i>1200?"M":i>900?"S":i>700?"XS":"XXS";var i;t.removeClass(s).addClass(e),s=e}n(),e(t[0],i,n)}}}]);
"use strict";angular.module("widgets").directive("tabularMenu",["$timeout","sizeWatcher",function(e,t){return{restrict:"E",template:'<div class="tabular-menu-container"><span class="button-left icon chevron-left hidden" ng-click="shiftRight();"></span> <span class="central-zone"><ng-transclude></ng-transclude></span><span class="button-right icon chevron-right" ng-click="shiftLeft();"></span></div>',transclude:!0,scope:{config:"="},link:function(n,i){const d=i.find("ng-transclude"),h=i.find(".button-left"),s=i.find(".button-right"),l=s.outerWidth(!0);let c,a=0,o=[];function r(t){e((()=>{let e=0;o=[],d.children().each((function(){const t=$(this),n=Math.floor(t.outerWidth(!0));o.push({element:t,left:Math.floor(e),width:n,selected:t.hasClass("active"),hidden:t.hasClass("hidden")}),e+=n})),function(e){let t=!1,n=!1;if(!o||!o.length)return;if(e<0||e>o.length)return;c&&(clearTimeout(c),c=void 0);a=e;let f=i.outerWidth();if(f<=0)return;let u=!1;if(o.forEach(((i,d)=>{d<e||u?i.hidden=!0:(i.hidden=f<i.width,d<o.length-1&&!i.hidden&&f-l<i.width&&(i.hidden=!0),i.hidden?u=!0:f-=i.width),0===d&&(i.hidden&&(f-=l),t=!i.hidden),d===o.length-1&&(i.hidden&&(f-=l),n=!i.hidden),i.selected&&i.hidden&&(c=setTimeout((()=>{r(d)}),4e3))})),f>0&&e>0&&!u){for(let t=e-1;t>=0&&f>o[t].width;t--)o[t].hidden=!1,a=t,f-=o[t].width;t=!o[0].hidden}o.forEach((e=>{e.element.toggleClass("hidden",e.hidden)})),h.toggleClass("hidden",t),s.toggleClass("hidden",n),d.css({left:-o[a].left})}(t)}),0,!1)}n.config&&n.config.onTabsChange&&n.config.onTabsChange((()=>r(a))),n.shiftLeft=()=>{r(a+1)},n.shiftRight=()=>{r(a-1)},t(i[0],n,(()=>r(a)))}}}]);
"use strict";angular.module("widgets").controller("WarningDialogController",["$scope",function(e){e.visible=!1,e.show=i=>{e.visible=!0,e.message=i.message},e.hide=()=>{e.visible=!1}}]);
"use strict";angular.module("widgets").directive("warningDialog",(function(){return{restrict:"E",scope:{show:"="},template:'<modal-dialog ng-if="visible" width="auto" localize="localize" default-msg-catalog="htmlui1" on-close="hide"><h4 class="ui dividing header">{{::localize(\'%Warning\')}}</h4><div class="warning-message"><i class="icon warning big"></i> {{localize(message)}}</div><button class="modal-dialog-buttons ui primary button" ng-click="hide()" auto-focus>{{::localize(\'%Ok\')}}</button></modal-dialog>',controller:"WarningDialogController"}}));
"use strict";angular.module("services").factory("confirmationDialog",(function(){let i;return{init(t){i=t},show(t){i&&i(t)}}}));
//# sourceMappingURL=htmlutil-631030.js.map
