<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="BASEGroup">
                                <queryInherit>/BASE</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BASEGroupExpanded">
                                        <queryRef>/FP_Arith</queryRef>
                                        <queryRef>/OTHER</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <queryRef>/MicroSequencer</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ICacheMisses</queryRef>
                                        <queryRef>/ITLBOverhead</queryRef>
                                        <queryRef>/BACLEARS</queryRef>
                                        <queryRef>/BranchResteers</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthCisc</queryRef>
                                        <queryRef>/FEBandwidthDecode</queryRef>
                                        <queryRef>/PreDecodeWrong</queryRef>
                                        <queryRef>/FEOther</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>/BranchMispredict</queryRef>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <derivedQuery id="MachineClearsNukeGroup">
                                            <queryInherit>/MachineClearsNuke</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MachineClearsNukeGroupExpanded">
                                                    <queryRef>/SMCMachineClear</queryRef>
                                                    <queryRef>/MOMachineClear</queryRef>
                                                    <queryRef>/FPAssistMachineClear</queryRef>
                                                    <queryRef>/Disambiguation</queryRef>
                                                    <queryRef>/PageFaultMachineClear</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/FastMachineClear</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <queryRef>/CoreBound</queryRef>
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <queryRef>/StoresBound</queryRef>
                                        <derivedQuery id="L1BoundGroup">
                                            <queryInherit>/L1Bound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L1BoundGroupExpanded">
                                                    <queryRef>/LoadsBlockedbyStoreForwarding</queryRef>
                                                    <queryRef>/Load_STLB_Hit</queryRef>
                                                    <queryRef>/Load_STLB_Miss</queryRef>
                                                    <queryRef>/OtherL1</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L2Bound</queryRef>
                                        <queryRef>/L3Bound</queryRef>
                                        <queryRef>/DRAMBound</queryRef>
                                        <queryRef>/OtherLoadStore</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundAuxGroup">
                    <queryInherit>/BackendBoundAux</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundAuxGroupExpanded">
                            <derivedQuery id="ResourceBoundGroup">
                                <queryInherit>/ResourceBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="ResourceBoundGroupExpanded">
                                        <derivedQuery id="MemorySchedulerGroup">
                                            <queryInherit>/MemoryScheduler</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MemorySchedulerGroupExpanded">
                                                    <queryRef>/STBuffer</queryRef>
                                                    <queryRef>/LDBuffer</queryRef>
                                                    <queryRef>/RSV</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/NonMemoryScheduler</queryRef>
                                        <queryRef>/BERegister</queryRef>
                                        <queryRef>/BEReorderBuffer</queryRef>
                                        <queryRef>/BEAllocRestriction</queryRef>
                                        <queryRef>/Serializing_Operation</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="BASE">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]") ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BASE") >0.60 ) ) && ( ( query("/RetiredPipelineSlots") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FP_Arith") >0.20 ) ) && ( ( query("/BASE") >0.60 ) && ( query("/RetiredPipelineSlots") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]") ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OTHER") >0.30 ) ) && ( ( query("/BASE") >0.60 ) && ( query("/RetiredPipelineSlots") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MicroSequencer") >0.05 ) ) && ( ( query("/RetiredPipelineSlots") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FELatency") >0.15 ) ) && ( ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ICacheMisses") >0.05 ) ) && ( ( query("/FELatency") >0.15 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ITLBOverhead") >0.05 ) ) && ( ( query("/FELatency") >0.15 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="BACLEARS">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BACLEARS") >0.05 ) ) && ( ( query("/FELatency") >0.15 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchResteers") >0.05 ) ) && ( ( query("/FELatency") >0.15 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidth") >0.10 ) ) && ( ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="FEBandwidthCisc">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthCisc") >0.05 ) ) && ( ( query("/FEBandwidth") >0.10 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="FEBandwidthDecode">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthDecode") >0.05 ) ) && ( ( query("/FEBandwidth") >0.10 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="PreDecodeWrong">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PreDecodeWrong") >0.05 ) ) && ( ( query("/FEBandwidth") >0.10 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="FEOther">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEOther") >0.05 ) ) && ( ( query("/FEBandwidth") >0.10 ) && ( query("/FrontendBoundPipelineSlots") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/SLOTS") - ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") + query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]") ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchMispredict") >0.05 ) ) && ( ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClears") >0.05 ) ) && ( ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="MachineClearsNuke">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClearsNuke") >0.05 ) ) && ( ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="SMCMachineClear">
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SMC]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]") ) ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/SMCMachineClear") >0.02 ) ) && ( ( query("/MachineClearsNuke") >0.05 ) && ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="MOMachineClear">
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]") ) ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MOMachineClear") >0.02 ) ) && ( ( query("/MachineClearsNuke") >0.05 ) && ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="FPAssistMachineClear">
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]") ) ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FPAssistMachineClear") >0.02 ) ) && ( ( query("/MachineClearsNuke") >0.05 ) && ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="Disambiguation">
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]") ) ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Disambiguation") >0.02 ) ) && ( ( query("/MachineClearsNuke") >0.05 ) && ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="PageFaultMachineClear">
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]") ) ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PageFaultMachineClear") >0.02 ) ) && ( ( query("/MachineClearsNuke") >0.05 ) && ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="FastMachineClear">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FastMachineClear") >0.05 ) ) && ( ( query("/MachineClears") >0.05 ) && ( query("/CancelledPipelineSlots") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound") >0.10 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound") - query("/MemBound") if query("/BackendBound") - query("/MemBound") > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/CoreBound") >0.10 ) ) && ( ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") / query("/SLOTS") ) if ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") / query("/SLOTS") ) < ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]") / query("/DerivedClockticks") ) + query("/StoresBound") else ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]") / query("/DerivedClockticks") ) + query("/StoresBound") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemBound") >0.20 ) ) && ( ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") ) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/StoresBound") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L1Bound") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LoadsBlockedbyStoreForwarding") >0.05 ) ) && ( ( query("/L1Bound") >0.10 ) && ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Hit") >0.05 ) ) && ( ( query("/L1Bound") >0.10 ) && ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Miss") >0.05 ) ) && ( ( query("/L1Bound") >0.10 ) && ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="OtherL1">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.OTHER_AT_RET]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherL1") >0.05 ) ) && ( ( query("/L1Bound") >0.10 ) && ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") / query("/DerivedClockticks") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L2Bound") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") / query("/DerivedClockticks") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L3Bound") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") / query("/DerivedClockticks") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DRAMBound") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="OtherLoadStore">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound") - ( query("/StoresBound") + query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/DRAMBound") ) if query("/MemBound") - ( query("/StoresBound") + query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/DRAMBound") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherLoadStore") >0.10 ) ) && ( ( query("/MemBound") >0.20 ) && ( query("/BackendBound") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound") - ( ( ( ( query("/StoresBound") + query("/L1Bound") ) + query("/L2Bound") ) + query("/L3Bound") ) + query("/DRAMBound") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="BackendBoundAux">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound") ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBoundAux") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="ResourceBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound") ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ResourceBound") >0.20 ) ) && ( ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="MemoryScheduler">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemoryScheduler") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="STBuffer">
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") ) ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/STBuffer") >0.05 ) ) && ( ( query("/MemoryScheduler") >0.10 ) && ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="LDBuffer">
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler") * query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LDBuffer") >0.05 ) ) && ( ( query("/MemoryScheduler") >0.10 ) && ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="RSV">
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler") * query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RSV") >0.05 ) ) && ( ( query("/MemoryScheduler") >0.10 ) && ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="NonMemoryScheduler">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/NonMemoryScheduler") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="BERegister">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BERegister") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="BEReorderBuffer">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEReorderBuffer") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="BEAllocRestriction">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEAllocRestriction") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Serializing_Operation") >0.10 ) ) && ( ( query("/ResourceBound") >0.20 ) && ( query("/BackendBoundAux") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width") * query("/DerivedClockticks") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 5 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="MEM_BOUND_STALLS_AT_RET_CORRECTION">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) / query("/DerivedClockticks") if ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) / query("/DerivedClockticks") > 0 else 0 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBASEGroup">
                                            <queryInherit>/locatorBASE</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBASEGroupExpanded">
                                                    <queryRef>/locatorFP_Arith</queryRef>
                                                    <queryRef>/locatorOTHER</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/locatorMicroSequencer</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses</queryRef>
                                                    <queryRef>/locatorITLBOverhead</queryRef>
                                                    <queryRef>/locatorBACLEARS</queryRef>
                                                    <queryRef>/locatorBranchResteers</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthCisc</queryRef>
                                                    <queryRef>/locatorFEBandwidthDecode</queryRef>
                                                    <queryRef>/locatorPreDecodeWrong</queryRef>
                                                    <queryRef>/locatorFEOther</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>/locatorBranchMispredict</queryRef>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <derivedQuery id="locatorMachineClearsNukeGroup">
                                                        <queryInherit>/locatorMachineClearsNuke</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMachineClearsNukeGroupExpanded">
                                                                <queryRef>/locatorSMCMachineClear</queryRef>
                                                                <queryRef>/locatorMOMachineClear</queryRef>
                                                                <queryRef>/locatorFPAssistMachineClear</queryRef>
                                                                <queryRef>/locatorDisambiguation</queryRef>
                                                                <queryRef>/locatorPageFaultMachineClear</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorFastMachineClear</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <queryRef>/locatorCoreBound</queryRef>
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <queryRef>/locatorStoresBound</queryRef>
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>/locatorL1Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <queryRef>/locatorLoadsBlockedbyStoreForwarding</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Hit</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Miss</queryRef>
                                                                <queryRef>/locatorOtherL1</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL2Bound</queryRef>
                                                    <queryRef>/locatorL3Bound</queryRef>
                                                    <queryRef>/locatorDRAMBound</queryRef>
                                                    <queryRef>/locatorOtherLoadStore</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundAuxGroup">
                                <queryInherit>/locatorBackendBoundAux</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundAuxGroupExpanded">
                                        <derivedQuery id="locatorResourceBoundGroup">
                                            <queryInherit>/locatorResourceBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorResourceBoundGroupExpanded">
                                                    <derivedQuery id="locatorMemorySchedulerGroup">
                                                        <queryInherit>/locatorMemoryScheduler</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMemorySchedulerGroupExpanded">
                                                                <queryRef>/locatorSTBuffer</queryRef>
                                                                <queryRef>/locatorLDBuffer</queryRef>
                                                                <queryRef>/locatorRSV</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorNonMemoryScheduler</queryRef>
                                                    <queryRef>/locatorBERegister</queryRef>
                                                    <queryRef>/locatorBEReorderBuffer</queryRef>
                                                    <queryRef>/locatorBEAllocRestriction</queryRef>
                                                    <queryRef>/locatorSerializing_Operation</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RetiredPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="locatorBASE">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BASE") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBASE") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MicroSequencer") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FELatency") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ICacheMisses") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ITLBOverhead") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="locatorBACLEARS">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BACLEARS") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBACLEARS") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchResteers") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidth") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="locatorFEBandwidthCisc">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthCisc") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthCisc") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="locatorFEBandwidthDecode">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDecode") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDecode") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="locatorPreDecodeWrong">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PreDecodeWrong") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPreDecodeWrong") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="locatorFEOther">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEOther") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEOther") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchMispredict") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClears") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="locatorMachineClearsNuke">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClearsNuke") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClearsNuke") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="locatorSMCMachineClear">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SMCMachineClear") ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSMCMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="locatorMOMachineClear">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MOMachineClear") ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMOMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="locatorFPAssistMachineClear">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FPAssistMachineClear") ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFPAssistMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="locatorDisambiguation">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Disambiguation") ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDisambiguation") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="locatorPageFaultMachineClear">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/PageFaultMachineClear") ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPageFaultMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="locatorFastMachineClear">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FastMachineClear") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFastMachineClear") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound") ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/StoresBound") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L1Bound") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LoadsBlockedbyStoreForwarding") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoadsBlockedbyStoreForwarding") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Hit") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Hit") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Miss") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Miss") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="locatorOtherL1">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherL1") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherL1") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Bound") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3Bound") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/DRAMBound") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="locatorOtherLoadStore">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") ) / query("/DerivedClockticks") ) + query("/StoresBound") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_L2_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_LLC_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD_DRAM_HIT]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound") - ( ( ( ( query("/StoresBound") + query("/L1Bound") ) + query("/L2Bound") ) + query("/L3Bound") ) + query("/DRAMBound") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherLoadStore") ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherLoadStore") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="locatorBackendBoundAux">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBoundAux") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBoundAux") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="locatorResourceBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ResourceBound") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorResourceBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="locatorMemoryScheduler">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MemoryScheduler") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="locatorSTBuffer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/STBuffer") ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSTBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="locatorLDBuffer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LDBuffer") ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLDBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="locatorRSV">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/RSV") ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRSV") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="locatorNonMemoryScheduler">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/NonMemoryScheduler") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNonMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="locatorBERegister">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BERegister") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBERegister") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="locatorBEReorderBuffer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEReorderBuffer") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEReorderBuffer") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="locatorBEAllocRestriction">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEAllocRestriction") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEAllocRestriction") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Serializing_Operation") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="locatorPipeline_Width">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="locatorMEM_BOUND_STALLS_AT_RET_CORRECTION">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS.LOAD]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
