/*******************************************************************************
* Copyright (C) 2005 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
 *
 * dfftw_plan_dft_r2c_3d - FFTW3 Fortran 77 wrapper to Intel(R) oneAPI Math Kernel Library (Intel(R) oneMKL).
 *
 ******************************************************************************
 */

#include "fftw3_mkl_f77.h"
#ifdef DFT_ENABLE_OFFLOAD
#include "oneapi/mkl/export.hpp"
#include "fftw3_omp_offload_common.h"

DLL_EXPORT void
dfftw_plan_dft_r2c_3d_omp_offload(PLAN *p, INTEGER *nx, INTEGER *ny, INTEGER *nz,
                   CFI_cdesc_t *in, CFI_cdesc_t *out, INTEGER *flags,
                   void *interopObj)
{
    INTEGER three = 3;
    INTEGER n[3] = { *nx, *ny, *nz };

    dfftw_plan_dft_r2c_omp_offload_impl(p, &three, n, (REAL8 *)in->base_addr,
                              (COMPLEX16 *)out->base_addr, flags, interopObj);
}

DLL_EXPORT void
dfftw_plan_dft_r2c_3d_cpu(PLAN *p, INTEGER *nx, INTEGER *ny, INTEGER *nz, CFI_cdesc_t *in,
                      CFI_cdesc_t *out, INTEGER *flags)
{
    dfftw_plan_dft_r2c_3d(p, nx, ny, nz, (REAL8 *)in->base_addr,
                      (COMPLEX16 *)out->base_addr, flags);
}
#else
void
dfftw_plan_dft_r2c_3d(PLAN *p, INTEGER *nx, INTEGER *ny, INTEGER *nz,
                      REAL8 *in, COMPLEX16 *out, INTEGER *flags)
{
    INTEGER three = 3;
    INTEGER n[3] = { *nx, *ny, *nz };

    dfftw_plan_dft_r2c(p, &three, n, in, out, flags);
}
#endif
