/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.RemoveAudioCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.TrackInfo;

public class InsertAudioCmd
extends Command {
    private final AudioClip _audio;
    private final int _audioIndex;

    public InsertAudioCmd(AudioClip audioClip) {
        this(null, audioClip, -1);
    }

    InsertAudioCmd(Command command, AudioClip audioClip, int n) {
        super(command);
        this._audio = audioClip;
        this._audioIndex = n;
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._audio == null) {
            return false;
        }
        if (this._audioIndex < 0) {
            trackInfo.getAudioList().add(this._audio);
        } else {
            trackInfo.getAudioList().add(this._audio, this._audioIndex);
        }
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        int n = this._audioIndex < 0 ? trackInfo.getAudioList().getCount() : this._audioIndex;
        return new RemoveAudioCmd(this, n);
    }
}

