/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.EnumValueManager;

public class PostgreEnumValueManager
extends EnumValueManager {
    private static final Log log = Log.getLog(PostgreEnumValueManager.class);

    protected boolean isMultiValue(IValueController valueController) {
        return false;
    }

    protected List<String> getEnumValues(IValueController valueController) {
        DBSTypedObject attribute = valueController.getValueType();
        PostgreDataType dataType = null;
        if (attribute instanceof DBSDataType) {
            dataType = (PostgreDataType)attribute;
        } else if (attribute instanceof DBSTypedObjectEx) {
            dataType = (PostgreDataType)((DBSTypedObjectEx)attribute).getDataType();
        }
        if (dataType == null) {
            return null;
        }
        PostgreDataType finalDataType = dataType;
        Object[][] values = new Object[1][1];
        try {
            UIUtils.runInProgressService(monitor -> {
                values[0] = finalDataType.getEnumValues(monitor);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.debug((Object)("Can't read enum values from " + dataType.getFullTypeName()));
        }
        if (values[0] == null) {
            return null;
        }
        ArrayList<String> strValues = new ArrayList<String>(values[0].length);
        for (Object value : values[0]) {
            strValues.add(DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI));
        }
        return strValues;
    }

    protected List<String> getSetValues(IValueController valueController, Object value) {
        return null;
    }
}

