/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.sqlite.internal.SQLiteMessages;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableColumn;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class SQLiteTable
extends GenericTable
implements DBDPseudoAttributeContainer,
DBPNamedObject2 {
    private static final DBDPseudoAttribute PSEUDO_ATTR_ROWID = new DBDPseudoAttribute(DBDPseudoAttributeType.ROWID, "rowid", "$alias.rowid", null, SQLiteMessages.pseudo_column_rowid_description, true, DBDPseudoAttribute.PropagationPolicy.TABLE_LOCAL);
    private static final List<DBDPseudoAttribute> ALL_KNOWN_PSEUDO_ATTRS = Stream.of("rowid", "oid", "_rowid_").map(name -> new DBDPseudoAttribute(DBDPseudoAttributeType.ROWID, name, null, null, SQLiteMessages.pseudo_column_rowid_description, true, DBDPseudoAttribute.PropagationPolicy.TABLE_LOCAL)).toList();
    private DBDPseudoAttribute[] allPseudoAttributes = null;
    private boolean hasStrictTyping;

    public SQLiteTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        SQLiteDataSource dataSource;
        DBPDataSource dBPDataSource;
        this.hasStrictTyping = dbResult != null && (dBPDataSource = this.getDataSource()) instanceof SQLiteDataSource && (dataSource = (SQLiteDataSource)dBPDataSource).supportsStrictTyping() && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"STRICT");
    }

    protected boolean isTruncateSupported() {
        return false;
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (this.hasPrimaryKey()) {
            return null;
        }
        return new DBDPseudoAttribute[]{PSEUDO_ATTR_ROWID};
    }

    public DBDPseudoAttribute[] getAllPseudoAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.allPseudoAttributes == null) {
            boolean isWithoutRowId = this.obtainIsWithoutRowId(monitor);
            if (isWithoutRowId) {
                this.allPseudoAttributes = DBDPseudoAttribute.EMPTY_ARRAY;
            } else {
                Set columnNames = this.getAttributes(monitor).stream().map(a -> a.getName().toLowerCase()).collect(Collectors.toSet());
                this.allPseudoAttributes = (DBDPseudoAttribute[])ALL_KNOWN_PSEUDO_ATTRS.stream().filter(a -> !columnNames.contains(a.getName())).toArray(DBDPseudoAttribute[]::new);
            }
        }
        return this.allPseudoAttributes;
    }

    /*
     * Exception decompiling
     */
    private boolean obtainIsWithoutRowId(@NotNull DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasPrimaryKey() throws DBException {
        List constraints = this.getConstraints((DBRProgressMonitor)new VoidProgressMonitor());
        if (constraints != null) {
            for (DBSTableConstraint cons : constraints) {
                if (cons.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
                return true;
            }
        }
        return false;
    }

    @Property(visibleIf=TableStrictTypingValidator.class, viewable=true, editable=true, order=40)
    public boolean isHasStrictTyping() {
        return this.hasStrictTyping;
    }

    public void setHasStrictTyping(boolean hasStrictTyping) {
        this.hasStrictTyping = hasStrictTyping;
    }

    @Nullable
    public List<SQLiteTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    public Collection<SQLiteTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAssociations(monitor);
    }

    public SQLiteTableForeignKey getAssociation(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLiteTableForeignKey)super.getAssociation(monitor, name);
    }

    public Collection<SQLiteTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted() || !((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity() || monitor.isForceCacheUsage()) {
            return new ArrayList<SQLiteTableForeignKey>();
        }
        ArrayList<SQLiteTableForeignKey> list = new ArrayList<SQLiteTableForeignKey>();
        for (GenericTableBase table : ((GenericDataSource)this.getDataSource()).getTables(monitor)) {
            Collection tableForeignKeys = table.getAssociations(monitor);
            if (!Objects.nonNull(tableForeignKeys)) continue;
            tableForeignKeys.stream().filter(fk -> fk instanceof SQLiteTableForeignKey).map(fk -> (SQLiteTableForeignKey)((Object)fk)).filter(fk -> fk.refersToTable(this)).forEach(list::add);
        }
        return list;
    }

    public static class TableStrictTypingValidator
    implements IPropertyValueValidator<SQLiteTable, Object> {
        public boolean isValidValue(@NotNull SQLiteTable object, @Nullable Object value) throws IllegalArgumentException {
            SQLiteDataSource dataSource;
            DBPDataSource dBPDataSource = object.getDataSource();
            return dBPDataSource instanceof SQLiteDataSource && (dataSource = (SQLiteDataSource)dBPDataSource).supportsStrictTyping();
        }
    }
}

