import { neverAbortedSignal } from './common/abort';
import { ExecuteWrapper, returnOrThrow } from './common/Executor';
/**
 * A no-op policy, useful for unit tests and stubs.
 */
export class NoopPolicy {
    constructor() {
        this.executor = new ExecuteWrapper();
        this.onSuccess = this.executor.onSuccess;
        this.onFailure = this.executor.onFailure;
    }
    async execute(fn, signal = neverAbortedSignal) {
        return returnOrThrow(await this.executor.invoke(fn, { signal }));
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/cockatiel/dist/esm/NoopPolicy.js.map