// java wrapper for vtkDataRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPassInputTypeAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataRepresentation",dType)) { return me; }
  if ((res= vtkPassInputTypeAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInputConnection_14(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputConnection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetAnnotationLink_15(JNIEnv* env, jobject obj)
{
  vtkAnnotationLink * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationLink();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SetAnnotationLink_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAnnotationLink * temp0;
  temp0 = static_cast<vtkAnnotationLink*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnnotationLink(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_ApplyViewTheme_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewTheme * temp0;
  temp0 = static_cast<vtkViewTheme*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyViewTheme(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_Select_18(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkView * temp0;
  vtkSelection * temp1;
  temp0 = static_cast<vtkView*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Select(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_Select_19(JNIEnv* env, jobject obj,jobject id0,jobject id1,jboolean id2)
{
  vtkView * temp0;
  vtkSelection * temp1;
  bool   temp2;
  temp0 = static_cast<vtkView*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = (id2 != 0) ? true : false;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Select(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_Annotate_110(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkView * temp0;
  vtkAnnotationLayers * temp1;
  temp0 = static_cast<vtkView*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAnnotationLayers*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Annotate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_Annotate_111(JNIEnv* env, jobject obj,jobject id0,jobject id1,jboolean id2)
{
  vtkView * temp0;
  vtkAnnotationLayers * temp1;
  bool   temp2;
  temp0 = static_cast<vtkView*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAnnotationLayers*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = (id2 != 0) ? true : false;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Annotate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SetSelectable_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectable(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataRepresentation_GetSelectable_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SelectableOn_114(JNIEnv* env, jobject obj)
{

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SelectableOff_115(JNIEnv* env, jobject obj)
{

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_UpdateSelection_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelection * temp0;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateSelection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_UpdateSelection_117(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkSelection * temp0;
  bool   temp1;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateSelection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_UpdateAnnotations_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAnnotationLayers * temp0;
  temp0 = static_cast<vtkAnnotationLayers*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateAnnotations(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_UpdateAnnotations_119(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkAnnotationLayers * temp0;
  bool   temp1;
  temp0 = static_cast<vtkAnnotationLayers*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateAnnotations(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalAnnotationOutputPort_120(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalAnnotationOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalAnnotationOutputPort_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalAnnotationOutputPort(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalAnnotationOutputPort_122(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalAnnotationOutputPort(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalSelectionOutputPort_123(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalSelectionOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalSelectionOutputPort_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalSelectionOutputPort(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalSelectionOutputPort_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalSelectionOutputPort(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalOutputPort_126(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalOutputPort_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalOutputPort(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetInternalOutputPort_128(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalOutputPort(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SetSelectionType_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataRepresentation_GetSelectionType_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SetSelectionArrayNames_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionArrayNames(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_GetSelectionArrayNames_132(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionArrayNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataRepresentation_SetSelectionArrayName_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataRepresentation_GetSelectionArrayName_134(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataRepresentation_ConvertSelection_135(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkView * temp0;
  vtkSelection * temp1;
  vtkSelection * temp20;
  temp0 = static_cast<vtkView*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataRepresentation* op = static_cast<vtkDataRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertSelection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataRepresentation::New());
}
