// java wrapper for vtkWindowToImageFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWindowToImageFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWindowToImageFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWindowToImageFilter",dType)) { return me; }
  if ((res= vtkAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindowToImageFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindowToImageFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindowToImageFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindowToImageFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetInput_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindowToImageFilter_GetInput_15(JNIEnv* env, jobject obj)
{
  vtkWindow * temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetScale_16(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetScale_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindowToImageFilter_GetScale_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetScale_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetFixBoundary_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixBoundary(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWindowToImageFilter_GetFixBoundary_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFixBoundary();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_FixBoundaryOn_112(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->FixBoundaryOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_FixBoundaryOff_113(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->FixBoundaryOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_ReadFrontBufferOn_114(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFrontBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_ReadFrontBufferOff_115(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFrontBufferOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindowToImageFilter_GetReadFrontBuffer_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadFrontBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetReadFrontBuffer_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadFrontBuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_ShouldRerenderOn_118(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShouldRerenderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_ShouldRerenderOff_119(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShouldRerenderOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetShouldRerender_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShouldRerender(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindowToImageFilter_GetShouldRerender_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShouldRerender();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetViewport_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkWindowToImageFilter_GetViewport_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewport();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetInputBufferType_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputBufferType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindowToImageFilter_GetInputBufferType_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputBufferType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetInputBufferTypeToRGB_126(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputBufferTypeToRGB();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetInputBufferTypeToRGBA_127(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputBufferTypeToRGBA();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindowToImageFilter_SetInputBufferTypeToZBuffer_128(JNIEnv* env, jobject obj)
{

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputBufferTypeToZBuffer();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindowToImageFilter_GetOutput_129(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkWindowToImageFilter* op = static_cast<vtkWindowToImageFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWindowToImageFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWindowToImageFilter::New());
}
