// java wrapper for vtkContextDevice2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkContextDevice2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkContextDevice2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkContextDevice2D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContextDevice2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContextDevice2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContextDevice2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContextDevice2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_DrawEllipseWedge_14(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5,jfloat id6,jfloat id7)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  float   temp6;
  float   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawEllipseWedge(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_DrawEllipticArc_15(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawEllipticArc(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_ComputeStringBounds_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  vtkStdString temp0;
  float temp1[4];
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeStringBounds(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_ComputeJustifiedStringBounds_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[4];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeJustifiedStringBounds(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContextDevice2D_MathTextIsSupported_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MathTextIsSupported();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_DrawImage_19(JNIEnv* env, jobject obj,jfloatArray id0,jfloat id1,jobject id2)
{
  float temp0[2];
  float   temp1;
  vtkImageData * temp2;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawImage(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_DrawPolyData_110(JNIEnv* env, jobject obj,jfloatArray id0,jfloat id1,jobject id2,jobject id3,jint id4)
{
  float temp0[2];
  float   temp1;
  vtkPolyData * temp2;
  vtkUnsignedCharArray * temp3;
  int   temp4;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;
  temp2 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPolyData(temp0,temp1,temp2,temp3,temp4);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_ApplyPen_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContextDevice2D_GetPen_112(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_ApplyBrush_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyBrush(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContextDevice2D_GetBrush_114(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_ApplyTextProp_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyTextProp(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContextDevice2D_GetTextProp_116(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProp();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_SetTexture_117(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkImageData * temp0;
  int   temp1;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexture(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_SetPointSize_118(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointSize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_SetLineWidth_119(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineWidth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_SetLineType_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContextDevice2D_GetWidth_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContextDevice2D_GetHeight_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeight();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_SetMatrix_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_GetMatrix_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_MultiplyMatrix_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_PushMatrix_126(JNIEnv* env, jobject obj)
{

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_PopMatrix_127(JNIEnv* env, jobject obj)
{

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PopMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_DisableClipping_128(JNIEnv* env, jobject obj)
{

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableClipping();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_EnableClipping_129(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableClipping(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_Begin_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Begin(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_End_131(JNIEnv* env, jobject obj)
{

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->End();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContextDevice2D_GetBufferIdMode_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBufferIdMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_BufferIdModeBegin_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractContextBufferId * temp0;
  temp0 = static_cast<vtkAbstractContextBufferId*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BufferIdModeBegin(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContextDevice2D_BufferIdModeEnd_134(JNIEnv* env, jobject obj)
{

  vtkContextDevice2D* op = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BufferIdModeEnd();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkContextDevice2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkContextDevice2D::New());
}
