// java wrapper for vtkPSystemTools object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPSystemTools.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPSystemTools_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPSystemTools",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPSystemTools_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPSystemTools_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPSystemTools_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPSystemTools_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPSystemTools_BroadcastString_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  std::string temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  op->BroadcastString(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPSystemTools_CollapseFullPath_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CollapseFullPath(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPSystemTools_CollapseFullPath_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  std::string temp0;
  char * temp1;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CollapseFullPath(temp0,temp1);
  delete[] temp1;
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPSystemTools_FileExists_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  char * temp0;
  bool   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FileExists(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPSystemTools_FileExists_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FileExists(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPSystemTools_FileIsDirectory_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FileIsDirectory(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPSystemTools_FindProgramPath_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1, jbyteArray id2, jint len2, jbyteArray id3, jint len3, jbyteArray id4, jint len4, jbyteArray id5, jint len5)
{
  char * temp0;
  std::string temp1;
  std::string temp2;
  char * temp3;
  char * temp4;
  char * temp5;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = vtkJavaUTF8ToChars(env, id3, len3);
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);
  temp5 = vtkJavaUTF8ToChars(env, id5, len5);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindProgramPath(temp0,temp1,temp2,temp3,temp4,temp5);
  delete[] temp0;
  delete[] temp3;
  delete[] temp4;
  delete[] temp5;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPSystemTools_GetCurrentWorkingDirectory_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  std::string   temp20;
  temp0 = (id0 != 0) ? true : false;

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentWorkingDirectory(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPSystemTools_GetProgramPath_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPSystemTools* op = static_cast<vtkPSystemTools*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgramPath(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPSystemTools_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPSystemTools::New());
}
