// java wrapper for vtkSliderRepresentation3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSliderRepresentation3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSliderRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSliderRepresentation3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSliderRepresentation3D",dType)) { return me; }
  if ((res= vtkSliderRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetPoint1Coordinate_14(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetPoint1InWorldCoordinates_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1InWorldCoordinates(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetPoint2Coordinate_16(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetPoint2InWorldCoordinates_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2InWorldCoordinates(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetTitleText_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSliderRepresentation3D_GetTitleText_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetSliderShape_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliderShape(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_GetSliderShapeMinValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliderShapeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_GetSliderShapeMaxValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliderShapeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_GetSliderShape_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliderShape();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetSliderShapeToSphere_114(JNIEnv* env, jobject obj)
{

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliderShapeToSphere();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetSliderShapeToCylinder_115(JNIEnv* env, jobject obj)
{

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliderShapeToCylinder();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_SetRotation_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRotation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSliderRepresentation3D_GetRotation_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRotation();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetSliderProperty_118(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliderProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetTubeProperty_119(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTubeProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetCapProperty_120(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetSelectedProperty_121(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_PlaceWidget_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_BuildRepresentation_123(JNIEnv* env, jobject obj)
{

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_StartWidgetInteraction_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_WidgetInteraction_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_Highlight_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Highlight(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSliderRepresentation3D_GetBounds_127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_GetActors_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_ReleaseGraphicsResources_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_RenderOpaqueGeometry_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_RenderTranslucentPolygonalGeometry_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSliderRepresentation3D_HasTranslucentPolygonalGeometry_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSliderRepresentation3D_GetMTime_133(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSliderRepresentation3D_RegisterPickers_134(JNIEnv* env, jobject obj)
{

  vtkSliderRepresentation3D* op = static_cast<vtkSliderRepresentation3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RegisterPickers();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSliderRepresentation3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSliderRepresentation3D::New());
}
