// java wrapper for vtkImageCursor3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageCursor3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageInPlaceFilter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageCursor3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageCursor3D",dType)) { return me; }
  if ((res= vtkImageInPlaceFilter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCursor3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCursor3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCursor3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCursor3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCursor3D_SetCursorPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCursor3D_SetCursorPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageCursor3D_GetCursorPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCursor3D_SetCursorValue_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageCursor3D_GetCursorValue_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCursor3D_SetCursorRadius_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorRadius(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCursor3D_GetCursorRadius_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageCursor3D* op = static_cast<vtkImageCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorRadius();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageCursor3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageCursor3D::New());
}
