// java wrapper for vtkVideoSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVideoSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVideoSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVideoSource",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVideoSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVideoSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Record_14(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Record();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Play_15(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Play();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Stop_16(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Stop();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Rewind_17(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Rewind();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_FastForward_18(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->FastForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Seek_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Seek(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Grab_110(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Grab();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetRecording_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRecording();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetPlaying_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlaying();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetFrameSize_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameSize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetFrameSize_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameSize(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVideoSource_GetFrameSize_115(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetFrameRate_116(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameRate(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVideoSource_GetFrameRate_117(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameRate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputFormat_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputFormat(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputFormatToLuminance_119(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputFormatToLuminance();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputFormatToRGB_120(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputFormatToRGB();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputFormatToRGBA_121(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputFormatToRGBA();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetOutputFormat_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputFormat();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetFrameBufferSize_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBufferSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetFrameBufferSize_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameBufferSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetNumberOfOutputFrames_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfOutputFrames(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetNumberOfOutputFrames_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfOutputFrames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_AutoAdvanceOn_127(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAdvanceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_AutoAdvanceOff_128(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAdvanceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetAutoAdvance_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoAdvance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetAutoAdvance_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoAdvance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetClipRegion_131(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClipRegion(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetClipRegion_132(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClipRegion(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVideoSource_GetClipRegion_133(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClipRegion();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputWholeExtent_134(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputWholeExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOutputWholeExtent_135(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputWholeExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVideoSource_GetOutputWholeExtent_136(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputWholeExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetDataSpacing_137(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetDataSpacing_138(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVideoSource_GetDataSpacing_139(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetDataOrigin_140(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetDataOrigin_141(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVideoSource_GetDataOrigin_142(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetOpacity_143(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVideoSource_GetOpacity_144(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetFrameCount_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetFrameCount_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameCount(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetFrameIndex_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameIndex();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVideoSource_GetFrameTimeStamp_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameTimeStamp(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVideoSource_GetFrameTimeStamp_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameTimeStamp();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_Initialize_150(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVideoSource_GetInitialized_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialized();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_ReleaseSystemResources_152(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseSystemResources();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_InternalGrab_153(JNIEnv* env, jobject obj)
{

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalGrab();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVideoSource_SetStartTimeStamp_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartTimeStamp(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVideoSource_GetStartTimeStamp_155(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVideoSource* op = static_cast<vtkVideoSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartTimeStamp();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVideoSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVideoSource::New());
}
