// java wrapper for vtkMINCImageReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMINCImageReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMINCImageReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMINCImageReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMINCImageReader_GetFileExtensions_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMINCImageReader_GetDescriptiveName_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_CanReadFile_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageReader_GetDirectionCosines_18(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionCosines();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMINCImageReader_GetRescaleSlope_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleSlope();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMINCImageReader_GetRescaleIntercept_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleIntercept();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_SetRescaleRealValues_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRescaleRealValues(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_RescaleRealValuesOn_112(JNIEnv* env, jobject obj)
{

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RescaleRealValuesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_RescaleRealValuesOff_113(JNIEnv* env, jobject obj)
{

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RescaleRealValuesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_GetRescaleRealValues_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleRealValues();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMINCImageReader_GetDataRange_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_GetDataRange_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDataRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_GetNumberOfTimeSteps_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageReader_SetTimeStep_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageReader_GetTimeStep_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStep();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageReader_GetImageAttributes_120(JNIEnv* env, jobject obj)
{
  vtkMINCImageAttributes * temp20;

  vtkMINCImageReader* op = static_cast<vtkMINCImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageAttributes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMINCImageReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMINCImageReader::New());
}
