// java wrapper for vtkHDFReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHDFReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObjectAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHDFReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHDFReader",dType)) { return me; }
  if ((res= vtkDataObjectAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDFReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_CanReadFile_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetOutputAsDataSet_17(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputAsDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetOutputAsDataSet_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputAsDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetPointDataArraySelection_19(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetCellDataArraySelection_110(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetFieldDataArraySelection_111(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_GetNumberOfPointArrays_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_GetNumberOfCellArrays_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDFReader_GetPointArrayName_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDFReader_GetCellArrayName_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFReader_GetHasTransientData_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasTransientData();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFReader_GetHasTemporalData_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasTemporalData();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetNumberOfSteps_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSteps();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFReader_GetStep_119(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetStep_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStep(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHDFReader_GetTimeValue_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeValue();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFReader_GetUseCache_122(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseCache();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetUseCache_123(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseCache(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_UseCacheOn_124(JNIEnv* env, jobject obj)
{

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCacheOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_UseCacheOff_125(JNIEnv* env, jobject obj)
{

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCacheOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFReader_GetMergeParts_126(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeParts();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetMergeParts_127(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergeParts(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_MergePartsOn_128(JNIEnv* env, jobject obj)
{

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergePartsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_MergePartsOff_129(JNIEnv* env, jobject obj)
{

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergePartsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetMaximumLevelsToReadByDefaultForAMR_130(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumLevelsToReadByDefaultForAMR(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFReader_GetMaximumLevelsToReadByDefaultForAMR_131(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumLevelsToReadByDefaultForAMR();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDFReader_GetAttributeOriginalIdName_132(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeOriginalIdName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFReader_SetAttributeOriginalIdName_133(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  std::string temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkHDFReader* op = static_cast<vtkHDFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeOriginalIdName(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHDFReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHDFReader::New());
}
