// java wrapper for vtkJSONDataSetWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkJSONDataSetWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkJSONDataSetWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkJSONDataSetWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkJSONDataSetWriter_GetValidString_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValidString(temp0);
  delete[] temp0;
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkJSONDataSetWriter_WriteArrayContents_11(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkDataArray * temp0;
  char * temp1;
  bool   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->WriteArrayContents(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkJSONDataSetWriter_WriteArrayAsRAW_12(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkDataArray * temp0;
  char * temp1;
  bool   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->WriteArrayAsRAW(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkJSONDataSetWriter_IsTypeOf_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkJSONDataSetWriter_IsA_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetNumberOfGenerationsFromBaseType_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetNumberOfGenerationsFromBase_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetInput_17(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetInput_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkJSONDataSetWriter_SetArchiver_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkArchiver * temp0;
  temp0 = static_cast<vtkArchiver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArchiver(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetArchiver_110(JNIEnv* env, jobject obj)
{
  vtkArchiver * temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArchiver();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetPointArraySelection_111(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkJSONDataSetWriter_GetCellArraySelection_112(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkJSONDataSetWriter_Write_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->Write(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkJSONDataSetWriter_IsDataSetValid_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDataSetValid();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkJSONDataSetWriter_Write_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkJSONDataSetWriter* op = static_cast<vtkJSONDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkJSONDataSetWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkJSONDataSetWriter::New());
}
