// java wrapper for vtkLinearSelector object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLinearSelector.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSelectionAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLinearSelector_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLinearSelector",dType)) { return me; }
  if ((res= vtkSelectionAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLinearSelector_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLinearSelector_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearSelector_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearSelector_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetStartPoint_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetStartPoint_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearSelector_GetStartPoint_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetEndPoint_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEndPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetEndPoint_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEndPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearSelector_GetEndPoint_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEndPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetPoints_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearSelector_GetPoints_111(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetTolerance_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLinearSelector_GetTolerance_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetIncludeVertices_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncludeVertices(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkLinearSelector_GetIncludeVertices_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncludeVertices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_IncludeVerticesOn_116(JNIEnv* env, jobject obj)
{

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeVerticesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_IncludeVerticesOff_117(JNIEnv* env, jobject obj)
{

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeVerticesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearSelector_SetVertexEliminationTolerance_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexEliminationTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLinearSelector_GetVertexEliminationToleranceMinValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexEliminationToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLinearSelector_GetVertexEliminationToleranceMaxValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexEliminationToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLinearSelector_GetVertexEliminationTolerance_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLinearSelector* op = static_cast<vtkLinearSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexEliminationTolerance();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLinearSelector_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLinearSelector::New());
}
