// java wrapper for vtkMolecule object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMolecule.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUndirectedGraph_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMolecule_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMolecule",dType)) { return me; }
  if ((res= vtkUndirectedGraph_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetNumberOfAtoms_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAtoms();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetNumberOfBonds_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBonds();
  return temp20;

}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkMolecule_GetAtomAtomicNumber_18(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned short   temp20;
  temp0 = id0;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomAtomicNumber(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetAtomAtomicNumber_19(JNIEnv* env, jobject obj,jlong id0,jshort id1)
{
  long long   temp0;
   unsigned short   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomAtomicNumber(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetAtomPosition_110(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomPosition(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetAtomPosition_111(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_GetAtomPosition_112(JNIEnv* env, jobject obj,jlong id0,jfloatArray id1)
{
  long long   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAtomPosition(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_GetAtomPosition_113(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAtomPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetBondOrder_114(JNIEnv* env, jobject obj,jlong id0,jshort id1)
{
  long long   temp0;
   unsigned short   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondOrder(temp0,temp1);

}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkMolecule_GetBondOrder_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned short   temp20;
  temp0 = id0;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondOrder(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMolecule_GetBondLength_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double   temp20;
  temp0 = id0;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondLength(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetAtomicPositionArray_117(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicPositionArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetAtomicNumberArray_118(JNIEnv* env, jobject obj)
{
  vtkUnsignedShortArray * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicNumberArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetBondOrdersArray_119(JNIEnv* env, jobject obj)
{
  vtkUnsignedShortArray * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondOrdersArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetElectronicData_120(JNIEnv* env, jobject obj)
{
  vtkAbstractElectronicData * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElectronicData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetElectronicData_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractElectronicData * temp0;
  temp0 = static_cast<vtkAbstractElectronicData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElectronicData(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMolecule_CheckedShallowCopy_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckedShallowCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMolecule_CheckedDeepCopy_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  bool   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckedDeepCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_ShallowCopy_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_DeepCopy_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_ShallowCopyStructure_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_DeepCopyStructure_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_ShallowCopyAttributes_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopyAttributes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_DeepCopyAttributes_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopyAttributes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMolecule_HasLattice_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasLattice();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_ClearLattice_131(JNIEnv* env, jobject obj)
{

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLattice();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetLattice_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLattice(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetLattice_133(JNIEnv* env, jobject obj)
{
  vtkMatrix3x3 * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLattice();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetAtomGhostArray_134(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_AllocateAtomGhostArray_135(JNIEnv* env, jobject obj)
{

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllocateAtomGhostArray();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetBondGhostArray_136(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_AllocateBondGhostArray_137(JNIEnv* env, jobject obj)
{

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllocateBondGhostArray();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_Initialize_138(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkPoints * temp0;
  vtkDataArray * temp1;
  vtkDataSetAttributes * temp2;
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Initialize(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_Initialize_139(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints * temp0;
  vtkDataSetAttributes * temp1;
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Initialize(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMolecule_Initialize_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  int   temp20;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Initialize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetData_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkMolecule * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetData_142(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkMolecule * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetAtomData_143(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetBondData_144(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetBondId_145(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondId(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetAtomicNumberArrayName_146(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicNumberArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMolecule_GetAtomicNumberArrayName_147(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicNumberArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMolecule_SetBondOrdersArrayName_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondOrdersArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMolecule_GetBondOrdersArrayName_149(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondOrdersArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMolecule_GetActualMemorySize_150(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkMolecule* op = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMolecule_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMolecule::New());
}
