// java wrapper for vtkIncrementalOctreePointLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkIncrementalOctreePointLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkIncrementalPointLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkIncrementalOctreePointLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkIncrementalOctreePointLocator",dType)) { return me; }
  if ((res= vtkIncrementalPointLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_SetMaxPointsPerLeaf_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxPointsPerLeaf(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetMaxPointsPerLeaf_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxPointsPerLeaf();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_SetBuildCubicOctree_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBuildCubicOctree(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetBuildCubicOctree_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBuildCubicOctree();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_BuildCubicOctreeOn_18(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildCubicOctreeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_BuildCubicOctreeOff_19(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildCubicOctreeOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetLocatorPoints_110(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocatorPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_Initialize_111(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FreeSearchStructure_112(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetNumberOfPoints_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetNumberOfNodes_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindClosestInsertedPoint_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestInsertedPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GenerateRepresentation_116(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_BuildLocator_117(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_ForceBuildLocator_118(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindClosestPoint_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindClosestPoint_120(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindPointsWithinRadius_121(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindPointsWithinSquaredRadius_122(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinSquaredRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_FindClosestNPoints_123(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_InitPointInsertion_124(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkPoints * temp0;
  double temp1[6];
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitPointInsertion(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_InitPointInsertion_125(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jlong id2)
{
  vtkPoints * temp0;
  double temp1[6];
  long long   temp2;
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  temp2 = id2;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitPointInsertion(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_IsInsertedPoint_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsertedPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_IsInsertedPoint_127(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsertedPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_InsertPoint_128(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_InsertNextPoint_129(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetRoot_130(JNIEnv* env, jobject obj)
{
  vtkIncrementalOctreeNode * temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoot();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreePointLocator_GetNumberOfLevels_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreePointLocator* op = static_cast<vtkIncrementalOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLevels();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkIncrementalOctreePointLocator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkIncrementalOctreePointLocator::New());
}
