// java wrapper for vtkDataObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataObject",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetInformation_14(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_SetInformation_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetMTime_16(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_ReleaseData_18(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseData();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetDataReleased_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataReleased();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_SetGlobalReleaseDataFlag_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalReleaseDataFlag(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_GlobalReleaseDataFlagOn_111(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GlobalReleaseDataFlagOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_GlobalReleaseDataFlagOff_112(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GlobalReleaseDataFlagOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetGlobalReleaseDataFlag_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalReleaseDataFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_SetFieldData_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetFieldData_115(JNIEnv* env, jobject obj)
{
  vtkFieldData * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetDataObjectType_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetUpdateTime_117(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetActualMemorySize_118(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_CopyInformationFromPipeline_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyInformationFromPipeline(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_CopyInformationToPipeline_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyInformationToPipeline(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetActiveFieldInformation_121(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp2;
  vtkInformation * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveFieldInformation(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetNamedFieldInformation_122(JNIEnv* env, jobject obj,jobject id0,jint id1, jbyteArray id2, jint len2)
{
  vtkInformation * temp0;
  int   temp1;
  char * temp2;
  vtkInformation * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNamedFieldInformation(temp0,temp1,temp2);
  delete[] temp2;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_RemoveNamedFieldInformation_123(JNIEnv* env, jobject obj,jobject id0,jint id1, jbyteArray id2, jint len2)
{
  vtkInformation * temp0;
  int   temp1;
  char * temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNamedFieldInformation(temp0,temp1,temp2);
  delete[] temp2;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_SetActiveAttribute_124(JNIEnv* env, jobject obj,jobject id0,jint id1, jbyteArray id2, jint len2,jint id3)
{
  vtkInformation * temp0;
  int   temp1;
  char * temp2;
  int   temp3;
  vtkInformation * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);
  temp3 = id3;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveAttribute(temp0,temp1,temp2,temp3);
  delete[] temp2;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_SetActiveAttributeInfo_125(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2, jbyteArray id3, jint len3,jint id4,jint id5,jint id6)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp2;
  char * temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = vtkJavaUTF8ToChars(env, id3, len3);
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveAttributeInfo(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  delete[] temp3;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_SetPointDataActiveScalarInfo_126(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointDataActiveScalarInfo(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_DataHasBeenGenerated_127(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataHasBeenGenerated();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_PrepareForNewData_128(JNIEnv* env, jobject obj)
{

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareForNewData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_ShallowCopy_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObject_DeepCopy_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetExtentType_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetAttributes_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSetAttributes * temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributes(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetGhostArray_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataObject_SupportsGhostArray_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsGhostArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetAttributesAsFieldData_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkFieldData * temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributesAsFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetAttributeTypeForArray_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeTypeForArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetNumberOfElements_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObject_GetAssociationTypeAsString_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssociationTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObject_GetAssociationTypeFromString_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssociationTypeFromString(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1TYPE_1NAME_140(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_TYPE_NAME();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1OBJECT_141(JNIEnv* env, jobject obj)
{
  vtkInformationDataObjectKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_OBJECT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1EXTENT_1TYPE_142(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_EXTENT_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1EXTENT_143(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerPointerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_EXTENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_ALL_1PIECES_1EXTENT_144(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ALL_PIECES_EXTENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1PIECE_1NUMBER_145(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_PIECE_NUMBER();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1NUMBER_1OF_1PIECES_146(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_NUMBER_OF_PIECES();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1NUMBER_1OF_1GHOST_1LEVELS_147(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_NUMBER_OF_GHOST_LEVELS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DATA_1TIME_1STEP_148(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATA_TIME_STEP();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_POINT_1DATA_1VECTOR_149(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->POINT_DATA_VECTOR();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_CELL_1DATA_1VECTOR_150(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CELL_DATA_VECTOR();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_VERTEX_1DATA_1VECTOR_151(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->VERTEX_DATA_VECTOR();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_EDGE_1DATA_1VECTOR_152(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EDGE_DATA_VECTOR();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1ARRAY_1TYPE_153(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_ARRAY_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1ASSOCIATION_154(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_ASSOCIATION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1ATTRIBUTE_1TYPE_155(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_ATTRIBUTE_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1ACTIVE_1ATTRIBUTE_156(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_ACTIVE_ATTRIBUTE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1NUMBER_1OF_1COMPONENTS_157(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_NUMBER_OF_COMPONENTS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1NUMBER_1OF_1TUPLES_158(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_NUMBER_OF_TUPLES();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1OPERATION_159(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_OPERATION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1RANGE_160(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_RANGE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_PIECE_1EXTENT_161(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PIECE_EXTENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_FIELD_1NAME_162(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_NAME();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_ORIGIN_163(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ORIGIN();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_SPACING_164(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SPACING();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_DIRECTION_165(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DIRECTION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_BOUNDING_1BOX_166(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BOUNDING_BOX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_SIL_167(JNIEnv* env, jobject obj)
{
  vtkInformationDataObjectKey * temp20;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SIL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetData_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkDataObject * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObject_GetData_169(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkDataObject * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataObject* op = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataObject::New());
}
