// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_WdgF2Gradient.h"

const char *Basis_HGrad_WdgF2Gradient =
"RealT uu = 1.0 - rr - ss;\n"
"RealT rs = rr * ss;\n"
"RealT tp = 1. + tt;\n"
"RealT tm = 1. - tt;\n"
"\n"
"basisGradient[0] =\n"
"  -0.5 * tt * tm * (3 * ss - 2) * uu + 0.5 * tt * tm * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[1] =\n"
"  -0.5 * tt * tm * (3 * rr - 2) * uu + 0.5 * tt * tm * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[2] =\n"
"  0.5 * tt * uu * (3 * rs - 2 * rr - 2 * ss + 1) - 0.5 * tm * uu * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"\n"
"basisGradient[3] = -0.5 * tt * tm * (-3 * rs + 4 * rr + ss * (-3 * rr - 3 * ss + 3) - 1);\n"
"basisGradient[4] = -0.5 * tt * tm * (-3 * rs + rr * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[5] = 0.5 * tt * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr) -\n"
"  0.5 * tm * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr);\n"
"\n"
"basisGradient[6] = -0.5 * tt * tm * (-3 * rs + ss * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[7] = -0.5 * tt * tm * (-3 * rs + rr * (-3 * rr - 3 * ss + 3) + 4 * ss - 1);\n"
"basisGradient[8] = 0.5 * tt * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss) -\n"
"  0.5 * tm * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss);\n"
"\n"
"basisGradient[9] =\n"
"  0.5 * tt * (3 * ss - 2) * tp * uu - 0.5 * tt * tp * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[10] =\n"
"  0.5 * tt * (3 * rr - 2) * tp * uu - 0.5 * tt * tp * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[11] =\n"
"  0.5 * tt * uu * (3 * rs - 2 * rr - 2 * ss + 1) + 0.5 * tp * uu * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"\n"
"basisGradient[12] = 0.5 * tt * tp * (-3 * rs + 4 * rr + ss * (-3 * rr - 3 * ss + 3) - 1);\n"
"basisGradient[13] = 0.5 * tt * tp * (-3 * rs + rr * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[14] = 0.5 * tt * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr) +\n"
"  0.5 * tp * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr);\n"
"\n"
"basisGradient[15] = 0.5 * tt * tp * (-3 * rs + ss * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[16] = 0.5 * tt * tp * (-3 * rs + rr * (-3 * rr - 3 * ss + 3) + 4 * ss - 1);\n"
"basisGradient[17] = 0.5 * tt * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss) +\n"
"  0.5 * tp * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss);\n"
"\n"
"basisGradient[18] = -0.5 * tt * tm * (4 - 12 * ss) * uu + 0.5 * tt * tm * (-12 * rs + 4 * rr);\n"
"basisGradient[19] = 6.0 * rr * tt * tm * uu + 0.5 * tt * tm * (-12 * rs + 4 * rr);\n"
"basisGradient[20] = 0.5 * tt * (-12 * rs + 4 * rr) * uu - 0.5 * tm * (-12 * rs + 4 * rr) * uu;\n"
"\n"
"basisGradient[21] = -0.5 * tt * tm * (12 * rs - ss * (-12 * rr - 12 * ss + 12) + 4 * ss);\n"
"basisGradient[22] = -0.5 * tt * tm * (12 * rs - rr * (-12 * rr - 12 * ss + 12) + 4 * rr);\n"
"basisGradient[23] = 0.5 * tt * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs) -\n"
"  0.5 * tm * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs);\n"
"\n"
"basisGradient[24] = 6.0 * ss * tt * tm * uu + 0.5 * tt * tm * (-12 * rs + 4 * ss);\n"
"basisGradient[25] = -0.5 * tt * tm * (4 - 12 * rr) * uu + 0.5 * tt * tm * (-12 * rs + 4 * ss);\n"
"basisGradient[26] = 0.5 * tt * (-12 * rs + 4 * ss) * uu - 0.5 * tm * (-12 * rs + 4 * ss) * uu;\n"
"\n"
"basisGradient[27] = 0.5 * tt * (4 - 12 * ss) * tp * uu - 0.5 * tt * tp * (-12 * rs + 4 * rr);\n"
"basisGradient[28] = -6.0 * rr * tt * tp * uu - 0.5 * tt * tp * (-12 * rs + 4 * rr);\n"
"basisGradient[29] = 0.5 * tt * (-12 * rs + 4 * rr) * uu + 0.5 * tp * (-12 * rs + 4 * rr) * uu;\n"
"\n"
"basisGradient[30] = 0.5 * tt * tp * (12 * rs - ss * (-12 * rr - 12 * ss + 12) + 4 * ss);\n"
"basisGradient[31] = 0.5 * tt * tp * (12 * rs - rr * (-12 * rr - 12 * ss + 12) + 4 * rr);\n"
"basisGradient[32] = 0.5 * tt * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs) +\n"
"  0.5 * tp * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs);\n"
"\n"
"basisGradient[33] = -6.0 * ss * tt * tp * uu - 0.5 * tt * tp * (-12 * rs + 4 * ss);\n"
"basisGradient[34] = 0.5 * tt * (4 - 12 * rr) * tp * uu - 0.5 * tt * tp * (-12 * rs + 4 * ss);\n"
"basisGradient[35] = 0.5 * tt * (-12 * rs + 4 * ss) * uu + 0.5 * tp * (-12 * rs + 4 * ss) * uu;\n"
"\n"
"basisGradient[36] = tm * (3 * ss - 2) * tp * uu - tm * tp * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[37] = tm * (3 * rr - 2) * tp * uu - tm * tp * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"basisGradient[38] =\n"
"  tm * uu * (3 * rs - 2 * rr - 2 * ss + 1) - tp * uu * (3 * rs - 2 * rr - 2 * ss + 1);\n"
"\n"
"basisGradient[39] = tm * tp * (-3 * rs + 4 * rr + ss * (-3 * rr - 3 * ss + 3) - 1);\n"
"basisGradient[40] = tm * tp * (-3 * rs + rr * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[41] = tm * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr) -\n"
"  tp * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * rr * uu + rr);\n"
"\n"
"basisGradient[42] = tm * tp * (-3 * rs + ss * (-3 * rr - 3 * ss + 3));\n"
"basisGradient[43] = tm * tp * (-3 * rs + rr * (-3 * rr - 3 * ss + 3) + 4 * ss - 1);\n"
"basisGradient[44] = tm * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss) -\n"
"  tp * (rs * (-3 * rr - 3 * ss + 3) - 2 * rs - 2 * ss * uu + ss);\n"
"\n"
"basisGradient[45] = 13.5 * rs * tt * tm - 13.5 * ss * tt * tm * uu;\n"
"basisGradient[46] = 13.5 * rs * tt * tm - 13.5 * rr * tt * tm * uu;\n"
"basisGradient[47] = 13.5 * rs * tt * uu - 13.5 * rs * tm * uu;\n"
"\n"
"basisGradient[48] = -13.5 * rs * tt * tp + 13.5 * ss * tt * tp * uu;\n"
"basisGradient[49] = -13.5 * rs * tt * tp + 13.5 * rr * tt * tp * uu;\n"
"basisGradient[50] = 13.5 * rs * tt * uu + 13.5 * rs * tp * uu;\n"
"\n"
"basisGradient[51] = tm * (4 - 12 * ss) * tp * uu - tm * tp * (-12 * rs + 4 * rr);\n"
"basisGradient[52] = -12 * rr * tm * tp * uu - tm * tp * (-12 * rs + 4 * rr);\n"
"basisGradient[53] = tm * (-12 * rs + 4 * rr) * uu - tp * (-12 * rs + 4 * rr) * uu;\n"
"\n"
"basisGradient[54] = tm * tp * (12 * rs - ss * (-12 * rr - 12 * ss + 12) + 4 * ss);\n"
"basisGradient[55] = tm * tp * (12 * rs - rr * (-12 * rr - 12 * ss + 12) + 4 * rr);\n"
"basisGradient[56] =\n"
"  tm * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs) - tp * (-rs * (-12 * rr - 12 * ss + 12) + 4 * rs);\n"
"\n"
"basisGradient[57] = -12 * ss * tm * tp * uu - tm * tp * (-12 * rs + 4 * ss);\n"
"basisGradient[58] = tm * (4 - 12 * rr) * tp * uu - tm * tp * (-12 * rs + 4 * ss);\n"
"basisGradient[59] = tm * (-12 * rs + 4 * ss) * uu - tp * (-12 * rs + 4 * ss) * uu;\n"
"\n"
"basisGradient[60] = -rs * tm * (27 * tt + 27) + ss * tm * (27 * tt + 27) * uu;\n"
"basisGradient[61] = -rs * tm * (27 * tt + 27) + rr * tm * (27 * tt + 27) * uu;\n"
"basisGradient[62] = 27 * rs * tm * uu - rs * (27 * tt + 27) * uu;\n"
"";
