// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrC2Gradient.h"

const char *Basis_HGrad_PyrC2Gradient =
"const RealT ZERO = 0.;\n"
"const RealT HALF = 0.5;\n"
"const RealT FOURTH = 0.25;\n"
"const RealT NINTH = 1. / 9.;\n"
"const RealT FOURNINTHS = 4. / 9.;\n"
"const RealT ONE = 1.;\n"
"const RealT TWO = 2.;\n"
"const RealT FOUR = 4.;\n"
"const RealT EIGHT = 9.;\n"
"const RealT TWENTYSEVEN = 27.;\n"
"\n"
"const RealT K1 = -FOURTH;\n"
"const RealT K5 = ONE;\n"
"const RealT K6 = -HALF;\n"
"const RealT K10 = -ONE;\n"
"const RealT K14 = ONE;\n"
"const RealT K15A = TWENTYSEVEN / EIGHT;\n"
"const RealT K15B = -TWENTYSEVEN / EIGHT;\n"
"\n"
"// Evaluate common rr,ss,tt multiplication terms\n"
"RealT r2 = rr * rr;\n"
"RealT s2 = ss * ss;\n"
"RealT t2 = tt * tt;\n"
"RealT rs = rr * ss;\n"
"RealT rt = rr * tt;\n"
"RealT st = ss * tt;\n"
"RealT r2s = r2 * ss;\n"
"RealT rs2 = rr * s2;\n"
"RealT r2s2 = r2 * s2;\n"
"\n"
"// Evaluate numerical values of (tt-1), (tt-1)^2, (tt-1)^3, and (tt-1)^4\n"
"RealT tm = tt - ONE;\n"
"RealT tm2 = tm * tm;\n"
"RealT tm3 = tm2 * tm;\n"
"RealT tm4 = tm3 * tm;\n"
"\n"
"// Evaluate numerical value of 1/(tt-1)\n"
"RealT mt = abs(tm) > eps ? ONE / tm : ZERO;\n"
"RealT m2t = abs(tm2) > eps ? ONE / tm2 : ZERO;\n"
"RealT m3t = abs(tm3) > eps ? ONE / tm3 : ZERO;\n"
"RealT m4t = abs(tm4) > eps ? ONE / tm4 : ZERO;\n"
"\n"
"// BASELINE DHDR\n"
"basisGradient[0] = K1 * (rs * mt - rr - ss + tt + (ss * mt - ONE) * (rr + ss - ONE) - ONE);\n"
"basisGradient[3] = K1 * (rs * mt - rr + ss - tt + (-ss * mt + ONE) * (-rr + ss - ONE) + ONE);\n"
"basisGradient[6] = K1 * (-rs * mt - rr - ss - tt + (ss * mt + ONE) * (-rr - ss - ONE) + ONE);\n"
"basisGradient[9] = K1 * (-rs * mt - rr + ss + tt + (-ss * mt - ONE) * (rr - ss - ONE) - ONE);\n"
"basisGradient[12] = ZERO;\n"
"basisGradient[15] = K6 * (-TWO * rs * mt + TWO * rr);\n"
"basisGradient[18] = K6 * (s2 * mt - tt + ONE);\n"
"basisGradient[21] = K6 * (TWO * rs * mt + TWO * rr);\n"
"basisGradient[24] = K6 * (-s2 * mt + tt - ONE);\n"
"basisGradient[27] = K10 * (ss + ss * mt - tt);\n"
"basisGradient[30] = K10 * (-ss - ss * mt + tt);\n"
"basisGradient[33] = K10 * (ss + ss * mt + tt);\n"
"basisGradient[36] = K10 * (-ss - ss * mt - tt);\n"
"basisGradient[39] = K14 * (TWO * rs2 * m2t - TWO * rr);\n"
"basisGradient[42] = K15A * (TWO * rs + TWO * rs * mt - TWO * rs2 * mt - TWO * rs2 * m2t);\n"
"basisGradient[45] = K15B * (TWO * rs2 * mt + TWO * rs2 * m2t - TWO * rt + s2 + s2 * mt + tt - t2);\n"
"basisGradient[48] = K15B * (TWO * rs + TWO * rs * mt + TWO * rs2 * mt + TWO * rs2 * m2t);\n"
"basisGradient[51] = K15A * (-TWO * rs2 * mt - TWO * rs2 * m2t + TWO * rt + s2 + s2 * mt + tt - t2);\n"
"\n"
"// BASELINE DHDS\n"
"\n"
"basisGradient[1] = K1 * (rs * mt - rr - ss + tt + (rr * mt - ONE) * (rr + ss - ONE) - ONE);\n"
"basisGradient[4] = K1 * (-rs * mt + rr - ss + tt + (-rr * mt - ONE) * (-rr + ss - ONE) - ONE);\n"
"basisGradient[7] = K1 * (-rs * mt - rr - ss - tt + (rr * mt + ONE) * (-rr - ss - ONE) + ONE);\n"
"basisGradient[10] = K1 * (rs * mt + rr - ss - tt + (-rr * mt + ONE) * (rr - ss - ONE) + ONE);\n"
"basisGradient[13] = ZERO;\n"
"basisGradient[16] = K6 * (-r2 * mt + tt - ONE);\n"
"basisGradient[19] = K6 * (TWO * rs * mt + TWO * ss);\n"
"basisGradient[22] = K6 * (r2 * mt - tt + ONE);\n"
"basisGradient[25] = K6 * (-TWO * rs * mt + TWO * ss);\n"
"basisGradient[28] = K10 * (rr + rr * mt - tt);\n"
"basisGradient[31] = K10 * (-rr - rr * mt - tt);\n"
"basisGradient[34] = K10 * (rr + rr * mt + tt);\n"
"basisGradient[37] = K10 * (-rr - rr * mt + tt);\n"
"basisGradient[40] = K14 * (TWO * r2s * m2t - TWO * ss);\n"
"basisGradient[43] = K15A * (-TWO * r2s * mt - TWO * r2s * m2t + r2 + r2 * mt + TWO * st + tt - t2);\n"
"basisGradient[46] = K15B * (TWO * rs + TWO * rs * mt + TWO * r2s * mt + TWO * r2s * m2t);\n"
"basisGradient[49] = K15B * (TWO * r2s * mt + TWO * r2s * m2t + r2 + r2 * mt - TWO * st + tt - t2);\n"
"basisGradient[52] = K15A * (TWO * rs + TWO * rs * mt - TWO * r2s * mt - TWO * r2s * m2t);\n"
"\n"
"// BASELINE DHDT\n"
"\n"
"basisGradient[2] = K1 * (-rs * m2t + ONE) * (rr + ss - ONE);\n"
"basisGradient[5] = K1 * (rs * m2t + ONE) * (-rr + ss - ONE);\n"
"basisGradient[8] = K1 * (-rs * m2t + ONE) * (-rr - ss - ONE);\n"
"basisGradient[11] = K1 * (rs * m2t + ONE) * (rr - ss - ONE);\n"
"basisGradient[14] = K5 * (FOUR * tt - ONE);\n"
"basisGradient[17] = K6 * (r2s * m2t + ss - TWO * tt + TWO);\n"
"basisGradient[20] = K6 * (-rs2 * m2t - rr - TWO * tt + TWO);\n"
"basisGradient[23] = K6 * (-r2s * m2t - ss - TWO * tt + TWO);\n"
"basisGradient[26] = K6 * (rs2 * m2t + rr - TWO * tt + TWO);\n"
"basisGradient[29] = K10 * (-rs * m2t - rr - ss + TWO * tt - ONE);\n"
"basisGradient[32] = K10 * (rs * m2t + rr - ss + TWO * tt - ONE);\n"
"basisGradient[35] = K10 * (-rs * m2t + rr + ss + TWO * tt - ONE);\n"
"basisGradient[38] = K10 * (rs * m2t - rr + ss + TWO * tt - ONE);\n"
"basisGradient[41] = K14 * (-TWO * r2s2 * m3t + TWO * tt - TWO);\n"
"basisGradient[44] =\n"
"  K15A * (-r2s * m2t - r2s2 * (-TWO * tt + TWO) * m4t + r2s2 * m2t - TWO * st + ss + s2);\n"
"basisGradient[47] =\n"
"  K15B * (-rs2 * m2t - TWO * rt + rr + r2s2 * (-TWO * tt + TWO) * m4t - r2s2 * m2t - r2);\n"
"basisGradient[50] =\n"
"  K15B * (-r2s * m2t + r2s2 * (-TWO * tt + TWO) * m4t - r2s2 * m2t - TWO * st + ss - s2);\n"
"basisGradient[53] =\n"
"  K15A * (-rs2 * m2t - TWO * rt + rr - r2s2 * (-TWO * tt + TWO) * m4t + r2s2 * m2t + r2);\n"
"\n"
"// MODIFICATIONS TO DHDR\n"
"\n"
"basisGradient[0] =\n"
"  basisGradient[0] + basisGradient[39] * FOURTH + NINTH * (basisGradient[42] + basisGradient[51]);\n"
"basisGradient[3] =\n"
"  basisGradient[3] + basisGradient[39] * FOURTH + NINTH * (basisGradient[42] + basisGradient[45]);\n"
"basisGradient[6] =\n"
"  basisGradient[6] + basisGradient[39] * FOURTH + NINTH * (basisGradient[45] + basisGradient[48]);\n"
"basisGradient[9] =\n"
"  basisGradient[9] + basisGradient[39] * FOURTH + NINTH * (basisGradient[48] + basisGradient[51]);\n"
"basisGradient[12] = basisGradient[12] +\n"
"  NINTH * (basisGradient[42] + basisGradient[45] + basisGradient[48] + basisGradient[51]);\n"
"basisGradient[15] = basisGradient[15] - basisGradient[39] * HALF - basisGradient[42] * FOURNINTHS;\n"
"basisGradient[18] = basisGradient[18] - basisGradient[39] * HALF - basisGradient[45] * FOURNINTHS;\n"
"basisGradient[21] = basisGradient[21] - basisGradient[39] * HALF - basisGradient[48] * FOURNINTHS;\n"
"basisGradient[24] = basisGradient[24] - basisGradient[39] * HALF - basisGradient[51] * FOURNINTHS;\n"
"basisGradient[27] = basisGradient[27] + FOURNINTHS * (-basisGradient[42] - basisGradient[51]);\n"
"basisGradient[30] = basisGradient[30] + FOURNINTHS * (-basisGradient[42] - basisGradient[45]);\n"
"basisGradient[33] = basisGradient[33] + FOURNINTHS * (-basisGradient[45] - basisGradient[48]);\n"
"basisGradient[36] = basisGradient[36] + FOURNINTHS * (-basisGradient[48] - basisGradient[51]);\n"
"\n"
"// MODIFICATIONS TO DHDS\n"
"\n"
"basisGradient[1] =\n"
"  basisGradient[1] + basisGradient[40] * FOURTH + NINTH * (basisGradient[43] + basisGradient[52]);\n"
"basisGradient[4] =\n"
"  basisGradient[4] + basisGradient[40] * FOURTH + NINTH * (basisGradient[43] + basisGradient[46]);\n"
"basisGradient[7] =\n"
"  basisGradient[7] + basisGradient[40] * FOURTH + NINTH * (basisGradient[46] + basisGradient[49]);\n"
"basisGradient[10] =\n"
"  basisGradient[10] + basisGradient[40] * FOURTH + NINTH * (basisGradient[49] + basisGradient[52]);\n"
"basisGradient[13] = basisGradient[13] +\n"
"  NINTH * (basisGradient[43] + basisGradient[46] + basisGradient[49] + basisGradient[52]);\n"
"basisGradient[16] = basisGradient[16] - basisGradient[40] * HALF - basisGradient[43] * FOURNINTHS;\n"
"basisGradient[19] = basisGradient[19] - basisGradient[40] * HALF - basisGradient[46] * FOURNINTHS;\n"
"basisGradient[22] = basisGradient[22] - basisGradient[40] * HALF - basisGradient[49] * FOURNINTHS;\n"
"basisGradient[25] = basisGradient[25] - basisGradient[40] * HALF - basisGradient[52] * FOURNINTHS;\n"
"basisGradient[28] = basisGradient[28] + FOURNINTHS * (-basisGradient[43] - basisGradient[52]);\n"
"basisGradient[31] = basisGradient[31] + FOURNINTHS * (-basisGradient[43] - basisGradient[46]);\n"
"basisGradient[34] = basisGradient[34] + FOURNINTHS * (-basisGradient[46] - basisGradient[49]);\n"
"basisGradient[37] = basisGradient[37] + FOURNINTHS * (-basisGradient[49] - basisGradient[52]);\n"
"\n"
"// MODIFICATIONS TO DHDT\n"
"\n"
"basisGradient[2] =\n"
"  basisGradient[2] + basisGradient[41] * FOURTH + NINTH * (basisGradient[44] + basisGradient[53]);\n"
"basisGradient[5] =\n"
"  basisGradient[5] + basisGradient[41] * FOURTH + NINTH * (basisGradient[44] + basisGradient[47]);\n"
"basisGradient[8] =\n"
"  basisGradient[8] + basisGradient[41] * FOURTH + NINTH * (basisGradient[47] + basisGradient[50]);\n"
"basisGradient[11] =\n"
"  basisGradient[11] + basisGradient[41] * FOURTH + NINTH * (basisGradient[50] + basisGradient[53]);\n"
"basisGradient[14] = basisGradient[14] +\n"
"  NINTH * (basisGradient[44] + basisGradient[47] + basisGradient[50] + basisGradient[53]);\n"
"basisGradient[17] = basisGradient[17] - basisGradient[41] * HALF - basisGradient[44] * FOURNINTHS;\n"
"basisGradient[20] = basisGradient[20] - basisGradient[41] * HALF - basisGradient[47] * FOURNINTHS;\n"
"basisGradient[23] = basisGradient[23] - basisGradient[41] * HALF - basisGradient[50] * FOURNINTHS;\n"
"basisGradient[26] = basisGradient[26] - basisGradient[41] * HALF - basisGradient[53] * FOURNINTHS;\n"
"basisGradient[29] = basisGradient[29] + FOURNINTHS * (-basisGradient[44] - basisGradient[53]);\n"
"basisGradient[32] = basisGradient[32] + FOURNINTHS * (-basisGradient[44] - basisGradient[47]);\n"
"basisGradient[35] = basisGradient[35] + FOURNINTHS * (-basisGradient[47] - basisGradient[50]);\n"
"basisGradient[38] = basisGradient[38] + FOURNINTHS * (-basisGradient[50] - basisGradient[53]);\n"
"";
