// python wrapper for vtkMySQLDatabase
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkMySQLDatabase.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMySQLDatabase(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMySQLDatabase_ClassNew(); }


static PyObject *
PyvtkMySQLDatabase_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkMySQLDatabase::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkMySQLDatabase::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkMySQLDatabase *tempr = vtkMySQLDatabase::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMySQLDatabase *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkMySQLDatabase::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkMySQLDatabase::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkMySQLDatabase::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_Open(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Open");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    bool tempr = (ap.IsBound() ?
      op->Open(temp0) :
      op->vtkMySQLDatabase::Open(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_Close(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Close");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Close();
    }
    else
    {
      op->vtkMySQLDatabase::Close();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_IsOpen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsOpen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsOpen() :
      op->vtkMySQLDatabase::IsOpen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetQueryInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQueryInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSQLQuery *tempr = (ap.IsBound() ?
      op->GetQueryInstance() :
      op->vtkMySQLDatabase::GetQueryInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetTables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetTables() :
      op->vtkMySQLDatabase::GetTables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetRecord(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRecord");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetRecord(temp0) :
      op->vtkMySQLDatabase::GetRecord(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_IsSupported(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSupported");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsSupported(temp0) :
      op->vtkMySQLDatabase::IsSupported(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_HasError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasError() :
      op->vtkMySQLDatabase::HasError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetLastErrorText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastErrorText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLastErrorText() :
      op->vtkMySQLDatabase::GetLastErrorText());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetDatabaseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDatabaseType() :
      op->vtkMySQLDatabase::GetDatabaseType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHostName(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetHostName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetHostName() :
      op->vtkMySQLDatabase::GetHostName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetUser(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUser");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUser(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetUser(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetUser(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUser");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetUser() :
      op->vtkMySQLDatabase::GetUser());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetPassword(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassword");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassword(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetPassword(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDatabaseName(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetDatabaseName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetDatabaseName() :
      op->vtkMySQLDatabase::GetDatabaseName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetReconnect(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReconnect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReconnect(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetReconnect(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetReconnect(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReconnect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReconnect() :
      op->vtkMySQLDatabase::GetReconnect());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_ReconnectOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReconnectOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReconnectOn();
    }
    else
    {
      op->vtkMySQLDatabase::ReconnectOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_ReconnectOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReconnectOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReconnectOff();
    }
    else
    {
      op->vtkMySQLDatabase::ReconnectOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_SetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerPort(temp0);
    }
    else
    {
      op->vtkMySQLDatabase::SetServerPort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetServerPortMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPortMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPortMinValue() :
      op->vtkMySQLDatabase::GetServerPortMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetServerPortMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPortMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPortMaxValue() :
      op->vtkMySQLDatabase::GetServerPortMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPort() :
      op->vtkMySQLDatabase::GetServerPort());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetURL() :
      op->vtkMySQLDatabase::GetURL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetTablePreamble(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTablePreamble");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetTablePreamble(temp0) :
      op->vtkMySQLDatabase::GetTablePreamble(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetColumnSpecification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnSpecification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  vtkSQLDatabaseSchema *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSQLDatabaseSchema") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetColumnSpecification(temp0, temp1, temp2) :
      op->vtkMySQLDatabase::GetColumnSpecification(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_GetIndexSpecification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIndexSpecification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  vtkSQLDatabaseSchema *temp0 = nullptr;
  int temp1;
  int temp2;
  bool temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSQLDatabaseSchema") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetIndexSpecification(temp0, temp1, temp2, temp3) :
      op->vtkMySQLDatabase::GetIndexSpecification(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(3, temp3);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_CreateDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->CreateDatabase(temp0, temp1) :
      op->vtkMySQLDatabase::CreateDatabase(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_DropDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DropDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->DropDatabase(temp0) :
      op->vtkMySQLDatabase::DropDatabase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMySQLDatabase_ParseURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMySQLDatabase *op = static_cast<vtkMySQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ParseURL(temp0) :
      op->vtkMySQLDatabase::ParseURL(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMySQLDatabase_Methods[] = {
  {"IsTypeOf", PyvtkMySQLDatabase_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkMySQLDatabase_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkMySQLDatabase_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkMySQLDatabase\nC++: static vtkMySQLDatabase *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkMySQLDatabase_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkMySQLDatabase\nC++: vtkMySQLDatabase *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkMySQLDatabase_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkMySQLDatabase_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Open", PyvtkMySQLDatabase_Open, METH_VARARGS,
   "Open(self, password:str=...) -> bool\nC++: bool Open(const char *password=nullptr) override;\n\nOpen a new connection to the database.  You need to set the\nfilename before calling this function.  Returns true if the\ndatabase was opened successfully; false otherwise.\n"},
  {"Close", PyvtkMySQLDatabase_Close, METH_VARARGS,
   "Close(self) -> None\nC++: void Close() override;\n\nClose the connection to the database.\n"},
  {"IsOpen", PyvtkMySQLDatabase_IsOpen, METH_VARARGS,
   "IsOpen(self) -> bool\nC++: bool IsOpen() override;\n\nReturn whether the database has an open connection\n"},
  {"GetQueryInstance", PyvtkMySQLDatabase_GetQueryInstance, METH_VARARGS,
   "GetQueryInstance(self) -> vtkSQLQuery\nC++: vtkSQLQuery *GetQueryInstance() override;\n\nReturn an empty query on this database.\n"},
  {"GetTables", PyvtkMySQLDatabase_GetTables, METH_VARARGS,
   "GetTables(self) -> vtkStringArray\nC++: vtkStringArray *GetTables() override;\n\nGet the list of tables from the database\n"},
  {"GetRecord", PyvtkMySQLDatabase_GetRecord, METH_VARARGS,
   "GetRecord(self, table:str) -> vtkStringArray\nC++: vtkStringArray *GetRecord(const char *table) override;\n\nGet the list of fields for a particular table\n"},
  {"IsSupported", PyvtkMySQLDatabase_IsSupported, METH_VARARGS,
   "IsSupported(self, feature:int) -> bool\nC++: bool IsSupported(int feature) override;\n\nReturn whether a feature is supported by the database.\n"},
  {"HasError", PyvtkMySQLDatabase_HasError, METH_VARARGS,
   "HasError(self) -> bool\nC++: bool HasError() override;\n\nDid the last operation generate an error\n"},
  {"GetLastErrorText", PyvtkMySQLDatabase_GetLastErrorText, METH_VARARGS,
   "GetLastErrorText(self) -> str\nC++: const char *GetLastErrorText() override;\n\nGet the last error text from the database\n"},
  {"GetDatabaseType", PyvtkMySQLDatabase_GetDatabaseType, METH_VARARGS,
   "GetDatabaseType(self) -> str\nC++: const char *GetDatabaseType() override;\n\nString representing database type (e.g. \"mysql\").\n"},
  {"SetHostName", PyvtkMySQLDatabase_SetHostName, METH_VARARGS,
   "SetHostName(self, _arg:str) -> None\nC++: virtual void SetHostName(const char *_arg)\n\nThe database server host name.\n"},
  {"GetHostName", PyvtkMySQLDatabase_GetHostName, METH_VARARGS,
   "GetHostName(self) -> str\nC++: virtual char *GetHostName()\n\n"},
  {"SetUser", PyvtkMySQLDatabase_SetUser, METH_VARARGS,
   "SetUser(self, _arg:str) -> None\nC++: virtual void SetUser(const char *_arg)\n\nThe user name for connecting to the database server.\n"},
  {"GetUser", PyvtkMySQLDatabase_GetUser, METH_VARARGS,
   "GetUser(self) -> str\nC++: virtual char *GetUser()\n\n"},
  {"SetPassword", PyvtkMySQLDatabase_SetPassword, METH_VARARGS,
   "SetPassword(self, _arg:str) -> None\nC++: virtual void SetPassword(const char *_arg)\n\nThe user's password for connecting to the database server.\n"},
  {"SetDatabaseName", PyvtkMySQLDatabase_SetDatabaseName, METH_VARARGS,
   "SetDatabaseName(self, _arg:str) -> None\nC++: virtual void SetDatabaseName(const char *_arg)\n\nThe name of the database to connect to.\n"},
  {"GetDatabaseName", PyvtkMySQLDatabase_GetDatabaseName, METH_VARARGS,
   "GetDatabaseName(self) -> str\nC++: virtual char *GetDatabaseName()\n\n"},
  {"SetReconnect", PyvtkMySQLDatabase_SetReconnect, METH_VARARGS,
   "SetReconnect(self, _arg:int) -> None\nC++: virtual void SetReconnect(int _arg)\n\nShould automatic reconnection be enabled? This defaults to true.\nIf you change its value, you must do so before any call to\nOpen().\n"},
  {"GetReconnect", PyvtkMySQLDatabase_GetReconnect, METH_VARARGS,
   "GetReconnect(self) -> int\nC++: virtual int GetReconnect()\n\n"},
  {"ReconnectOn", PyvtkMySQLDatabase_ReconnectOn, METH_VARARGS,
   "ReconnectOn(self) -> None\nC++: virtual void ReconnectOn()\n\n"},
  {"ReconnectOff", PyvtkMySQLDatabase_ReconnectOff, METH_VARARGS,
   "ReconnectOff(self) -> None\nC++: virtual void ReconnectOff()\n\n"},
  {"SetServerPort", PyvtkMySQLDatabase_SetServerPort, METH_VARARGS,
   "SetServerPort(self, _arg:int) -> None\nC++: virtual void SetServerPort(int _arg)\n\nThe port used for connecting to the database.\n"},
  {"GetServerPortMinValue", PyvtkMySQLDatabase_GetServerPortMinValue, METH_VARARGS,
   "GetServerPortMinValue(self) -> int\nC++: virtual int GetServerPortMinValue()\n\n"},
  {"GetServerPortMaxValue", PyvtkMySQLDatabase_GetServerPortMaxValue, METH_VARARGS,
   "GetServerPortMaxValue(self) -> int\nC++: virtual int GetServerPortMaxValue()\n\n"},
  {"GetServerPort", PyvtkMySQLDatabase_GetServerPort, METH_VARARGS,
   "GetServerPort(self) -> int\nC++: virtual int GetServerPort()\n\n"},
  {"GetURL", PyvtkMySQLDatabase_GetURL, METH_VARARGS,
   "GetURL(self) -> str\nC++: vtkStdString GetURL() override;\n\nGet the URL of the database.\n"},
  {"GetTablePreamble", PyvtkMySQLDatabase_GetTablePreamble, METH_VARARGS,
   "GetTablePreamble(self, b:bool) -> str\nC++: vtkStdString GetTablePreamble(bool b) override;\n\nReturn the SQL string with the syntax of the preamble following a \"CREATE\nTABLE\" SQL statement. NB: this method implements the\nMySQL-specific IF NOT EXISTS syntax, used when b = false.\n"},
  {"GetColumnSpecification", PyvtkMySQLDatabase_GetColumnSpecification, METH_VARARGS,
   "GetColumnSpecification(self, schema:vtkSQLDatabaseSchema,\n    tblHandle:int, colHandle:int) -> str\nC++: vtkStdString GetColumnSpecification(\n    vtkSQLDatabaseSchema *schema, int tblHandle, int colHandle)\n    override;\n\nReturn the SQL string with the syntax to create a column inside a \"CREATE\nTABLE\" SQL statement. NB1: this method implements the\nMySQL-specific syntax:\n `<column name>` <column type> <column attributes>\n  NB2: if a column has type SERIAL in the schema, this will be\nturned into INT NOT nullptr AUTO_INCREMENT. Therefore, one should\nnot pass NOT nullptr as an attribute of a column whose type is\nSERIAL.\n"},
  {"GetIndexSpecification", PyvtkMySQLDatabase_GetIndexSpecification, METH_VARARGS,
   "GetIndexSpecification(self, schema:vtkSQLDatabaseSchema,\n    tblHandle:int, idxHandle:int, skipped:bool) -> str\nC++: vtkStdString GetIndexSpecification(\n    vtkSQLDatabaseSchema *schema, int tblHandle, int idxHandle,\n    bool &skipped) override;\n\nReturn the SQL string with the syntax to create an index inside a \"CREATE\nTABLE\" SQL statement. NB1: this method implements the\nMySQL-specific syntax:\n <index type> [<index name>]  (`<column name 1>`,... )\n  NB2: since MySQL supports INDEX creation within a CREATE TABLE\nstatement, skipped is always returned false.\n"},
  {"CreateDatabase", PyvtkMySQLDatabase_CreateDatabase, METH_VARARGS,
   "CreateDatabase(self, dbName:str, dropExisting:bool) -> bool\nC++: bool CreateDatabase(const char *dbName, bool dropExisting)\n\nCreate a new database, optionally dropping any existing database\nof the same name. Returns true when the database is properly\ncreated and false on failure.\n"},
  {"DropDatabase", PyvtkMySQLDatabase_DropDatabase, METH_VARARGS,
   "DropDatabase(self, dbName:str) -> bool\nC++: bool DropDatabase(const char *dbName)\n\nDrop a database if it exists. Returns true on success and false\non failure.\n"},
  {"ParseURL", PyvtkMySQLDatabase_ParseURL, METH_VARARGS,
   "ParseURL(self, url:str) -> bool\nC++: bool ParseURL(const char *url) override;\n\nOverridden to determine connection parameters given the URL. This\nis called by CreateFromURL() to initialize the instance. Look at\nCreateFromURL() for details about the URL format.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMySQLDatabase_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("host_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetHostName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetHostName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetHostName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHostName/SetHostName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetUser(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetUser(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetUser(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUser/SetUser\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("password"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetPassword(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetPassword(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPassword\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetDatabaseName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetDatabaseName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetDatabaseName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDatabaseName/SetDatabaseName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reconnect"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetReconnect(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetReconnect(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetReconnect(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReconnect/SetReconnect\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_port"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetServerPort(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMySQLDatabase_SetServerPort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMySQLDatabase_SetServerPort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetServerPort/SetServerPort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetDatabaseType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDatabaseType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("query_instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetQueryInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetQueryInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetTables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_error_text"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetLastErrorText(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastErrorText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("url"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMySQLDatabase_GetURL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetURL\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkMySQLDatabase_Doc =
  "vtkMySQLDatabase - maintain a connection to a MySQL database\n\n"
  "Superclass: vtkSQLDatabase\n\n"
  "This class provides a VTK interface to MySQL (http://www.mysql.com). \n"
  "Unlike file-based databases like SQLite, you talk to MySQL through a\n"
  "client/server connection.  You must specify the hostname, (optional)\n"
  "port to connect to, username, password and database name in order to\n"
  "connect.\n\n"
  "@sa\n"
  "vtkMySQLQuery\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMySQLDatabase_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOMySQL.vtkMySQLDatabase", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkMySQLDatabase_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkMySQLDatabase_StaticNew()
{
  return vtkMySQLDatabase::New();
}

PyObject *PyvtkMySQLDatabase_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkMySQLDatabase_Type, PyvtkMySQLDatabase_Methods,
    "vtkMySQLDatabase",
 &PyvtkMySQLDatabase_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSQLDatabase");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkMySQLDatabase_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMySQLDatabase(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMySQLDatabase_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkMySQLDatabase", o) != 0)
  {
    Py_DECREF(o);
  }

}

