// python wrapper for vtkObject
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkPythonCommand.h"
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkObject.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkObject(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkObject_ClassNew(); }

#ifndef DECLARED_PyvtkObjectBase_ClassNew
extern "C" { PyObject *PyvtkObjectBase_ClassNew(); }
#define DECLARED_PyvtkObjectBase_ClassNew
#endif
static PyObject *
PyvtkObject_AddObserver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0s = nullptr;
  int temp0i = 0;
  PyObject *temp1 = nullptr;
  float temp2 = 0.0f;
  unsigned long tempr;
  PyObject *result = nullptr;
  int argtype = 0;

  if (op)
  {
    if (ap.CheckArgCount(2,3) &&
        ap.GetValue(temp0i) &&
        ap.GetFunction(temp1) &&
        (ap.NoArgsLeft() || ap.GetValue(temp2)))
    {
      argtype = 1;
    }
  }

  if (op && !argtype)
  {
    PyErr_Clear();
    ap.Reset();

    if (ap.CheckArgCount(2,3) &&
        ap.GetValue(temp0s) &&
        ap.GetFunction(temp1) &&
        (ap.NoArgsLeft() || ap.GetValue(temp2)))
    {
      argtype = 2;
    }
  }

  if (argtype)
  {
    vtkPythonCommand *cbc = vtkPythonCommand::New();
    cbc->SetObject(temp1);
    cbc->SetThreadState(PyThreadState_Get());

    if (argtype == 1)
    {
      if (ap.IsBound())
      {
        tempr = op->AddObserver(temp0i, cbc, temp2);
      }
      else
      {
        tempr = op->vtkObject::AddObserver(temp0i, cbc, temp2);
      }
    }
    else
    {
      if (ap.IsBound())
      {
        tempr = op->AddObserver(temp0s, cbc, temp2);
      }
      else
      {
        tempr = op->vtkObject::AddObserver(temp0s, cbc, temp2);
      }
    }
    PyVTKObject_AddObserver(self, tempr);

    cbc->Delete();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

// This collection of methods that handle InvokeEvent are
// generated by a special case in vtkWrapPythonMethodDef.c
// The last characters of the method name indicate the type signature
// of the overload they handle: for example, "_zd" indicates that
// the event type is specified by string and the calldata is a double
static PyObject *
PyvtkObject_InvokeEvent_Lz(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long event;
  const char *calldata = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, const_cast<char *>(calldata));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_zz(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *event = nullptr;
  const char *calldata = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, const_cast<char *>(calldata));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_L(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long event;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(event))
  {
    int tempr = op->InvokeEvent(event);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_z(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *event = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(event))
  {
    int tempr = op->InvokeEvent(event);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_Li(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long event;
  long calldata;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, &calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_zi(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *event = nullptr;
  long calldata;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, &calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_Ld(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long event;
  double calldata;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, &calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_zd(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *event = nullptr;
  double calldata;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetValue(calldata))
  {
    int tempr = op->InvokeEvent(event, &calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_LV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long event;
  vtkObjectBase *calldata = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetVTKObject(calldata, "vtkObject"))
  {
    int tempr = op->InvokeEvent(event, calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyObject *
PyvtkObject_InvokeEvent_zV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvokeEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *event = nullptr;
  vtkObjectBase *calldata = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(event) &&
      ap.GetVTKObject(calldata, "vtkObject"))
  {
    int tempr = op->InvokeEvent(event, calldata);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }
  return result;
}

static PyMethodDef PyvtkObject_InvokeEvent_Methods[] = {
  {"InvokeEvent", PyvtkObject_InvokeEvent_Lz, METH_VARARGS,
   "@Lz"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_zz, METH_VARARGS,
   "@zz"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_L, METH_VARARGS,
   "@L"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_z, METH_VARARGS,
   "@z"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_Li, METH_VARARGS,
   "@Li"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_zi, METH_VARARGS,
   "@zi"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_Ld, METH_VARARGS,
   "@Ld"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_zd, METH_VARARGS,
   "@zd"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_LV, METH_VARARGS,
   "@LV *vtkObjectBase"},
  {"InvokeEvent", PyvtkObject_InvokeEvent_zV, METH_VARARGS,
   "@zV *vtkObjectBase"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkObject_InvokeEvent(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkObject_InvokeEvent_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InvokeEvent");
  return nullptr;
}

static PyObject *
PyvtkObject_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkObject::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkObject::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkObject *tempr = vtkObject::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkObject *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkObject::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkObject::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkObject::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_DebugOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DebugOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DebugOn();
    }
    else
    {
      op->vtkObject::DebugOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_DebugOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DebugOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DebugOff();
    }
    else
    {
      op->vtkObject::DebugOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetDebug(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDebug");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDebug() :
      op->vtkObject::GetDebug());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_SetDebug(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDebug");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDebug(temp0);
    }
    else
    {
      op->vtkObject::SetDebug(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_BreakOnError(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "BreakOnError");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkObject::BreakOnError();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_Modified(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Modified");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Modified();
    }
    else
    {
      op->vtkObject::Modified();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkObject::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_SetGlobalWarningDisplay(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetGlobalWarningDisplay");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkObject::SetGlobalWarningDisplay(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GlobalWarningDisplayOn(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GlobalWarningDisplayOn");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkObject::GlobalWarningDisplayOn();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GlobalWarningDisplayOff(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GlobalWarningDisplayOff");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkObject::GlobalWarningDisplayOff();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetGlobalWarningDisplay(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetGlobalWarningDisplay");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkObject::GetGlobalWarningDisplay();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetCommand(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCommand");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkCommand *tempr = (ap.IsBound() ?
      op->GetCommand(temp0) :
      op->vtkObject::GetCommand(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_RemoveObserver_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  vtkCommand *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCommand"))
  {
    if (ap.IsBound())
    {
      op->RemoveObserver(temp0);
    }
    else
    {
      op->vtkObject::RemoveObserver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkObject_RemoveObserver_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveObserver(temp0);
    }
    else
    {
      op->vtkObject::RemoveObserver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkObject_RemoveObserver_Methods[] = {
  {"RemoveObserver", PyvtkObject_RemoveObserver_s1, METH_VARARGS,
   "@V *vtkCommand"},
  {"RemoveObserver", PyvtkObject_RemoveObserver_s2, METH_VARARGS,
   "@L"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkObject_RemoveObserver(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkObject_RemoveObserver_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RemoveObserver");
  return nullptr;
}


static PyObject *
PyvtkObject_RemoveObservers_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObservers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  vtkCommand *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkCommand"))
  {
    if (ap.IsBound())
    {
      op->RemoveObservers(temp0, temp1);
    }
    else
    {
      op->vtkObject::RemoveObservers(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkObject_RemoveObservers_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObservers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  vtkCommand *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkCommand"))
  {
    if (ap.IsBound())
    {
      op->RemoveObservers(temp0, temp1);
    }
    else
    {
      op->vtkObject::RemoveObservers(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkObject_RemoveObservers_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObservers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveObservers(temp0);
    }
    else
    {
      op->vtkObject::RemoveObservers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkObject_RemoveObservers_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveObservers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveObservers(temp0);
    }
    else
    {
      op->vtkObject::RemoveObservers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkObject_RemoveObservers_Methods[] = {
  {"RemoveObservers", PyvtkObject_RemoveObservers_s1, METH_VARARGS,
   "@LV *vtkCommand"},
  {"RemoveObservers", PyvtkObject_RemoveObservers_s2, METH_VARARGS,
   "@zV *vtkCommand"},
  {"RemoveObservers", PyvtkObject_RemoveObservers_s3, METH_VARARGS,
   "@L"},
  {"RemoveObservers", PyvtkObject_RemoveObservers_s4, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkObject_RemoveObservers(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkObject_RemoveObservers_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RemoveObservers");
  return nullptr;
}


static PyObject *
PyvtkObject_HasObserver_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  vtkCommand *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkCommand"))
  {
    int tempr = (ap.IsBound() ?
      op->HasObserver(temp0, temp1) :
      op->vtkObject::HasObserver(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkObject_HasObserver_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  vtkCommand *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkCommand"))
  {
    int tempr = (ap.IsBound() ?
      op->HasObserver(temp0, temp1) :
      op->vtkObject::HasObserver(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkObject_HasObserver_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->HasObserver(temp0) :
      op->vtkObject::HasObserver(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkObject_HasObserver_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasObserver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->HasObserver(temp0) :
      op->vtkObject::HasObserver(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkObject_HasObserver_Methods[] = {
  {"HasObserver", PyvtkObject_HasObserver_s1, METH_VARARGS,
   "@LV *vtkCommand"},
  {"HasObserver", PyvtkObject_HasObserver_s2, METH_VARARGS,
   "@zV *vtkCommand"},
  {"HasObserver", PyvtkObject_HasObserver_s3, METH_VARARGS,
   "@L"},
  {"HasObserver", PyvtkObject_HasObserver_s4, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkObject_HasObserver(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkObject_HasObserver_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "HasObserver");
  return nullptr;
}


static PyObject *
PyvtkObject_RemoveAllObservers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllObservers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllObservers();
    }
    else
    {
      op->vtkObject::RemoveAllObservers();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_SetObjectName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetObjectName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetObjectName(temp0);
    }
    else
    {
      op->vtkObject::SetObjectName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetObjectName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetObjectName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetObjectName() :
      op->vtkObject::GetObjectName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkObject_GetObjectDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetObjectDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkObject *op = static_cast<vtkObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetObjectDescription() :
      op->vtkObject::GetObjectDescription());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkObject_Methods[] = {
  {"IsTypeOf", PyvtkObject_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkObject_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkObject_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkObject\nC++: static vtkObject *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkObject_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkObject\nC++: vtkObject *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkObject_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkObject_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"DebugOn", PyvtkObject_DebugOn, METH_VARARGS,
   "DebugOn(self) -> None\nC++: virtual void DebugOn()\n\nTurn debugging output on.\n"},
  {"DebugOff", PyvtkObject_DebugOff, METH_VARARGS,
   "DebugOff(self) -> None\nC++: virtual void DebugOff()\n\nTurn debugging output off.\n"},
  {"GetDebug", PyvtkObject_GetDebug, METH_VARARGS,
   "GetDebug(self) -> bool\nC++: bool GetDebug()\n\nGet the value of the debug flag.\n"},
  {"SetDebug", PyvtkObject_SetDebug, METH_VARARGS,
   "SetDebug(self, debugFlag:bool) -> None\nC++: void SetDebug(bool debugFlag)\n\nSet the value of the debug flag. A true value turns debugging on.\n"},
  {"BreakOnError", PyvtkObject_BreakOnError, METH_VARARGS,
   "BreakOnError() -> None\nC++: static void BreakOnError()\n\nThis method is called when vtkErrorMacro executes. It allows the\ndebugger to break on error.\n"},
  {"Modified", PyvtkObject_Modified, METH_VARARGS,
   "Modified(self) -> None\nC++: virtual void Modified()\n\nUpdate the modification time for this object. Many filters rely\non the modification time to determine if they need to recompute\ntheir data. The modification time is a unique monotonically\nincreasing unsigned long integer.\n"},
  {"GetMTime", PyvtkObject_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: virtual vtkMTimeType GetMTime()\n\nReturn this object's modified time.\n"},
  {"SetGlobalWarningDisplay", PyvtkObject_SetGlobalWarningDisplay, METH_VARARGS,
   "SetGlobalWarningDisplay(val:int) -> None\nC++: static void SetGlobalWarningDisplay(vtkTypeBool val)\n\nThis is a global flag that controls whether any debug, warning or\nerror messages are displayed.\n"},
  {"GlobalWarningDisplayOn", PyvtkObject_GlobalWarningDisplayOn, METH_VARARGS,
   "GlobalWarningDisplayOn() -> None\nC++: static void GlobalWarningDisplayOn()\n\n"},
  {"GlobalWarningDisplayOff", PyvtkObject_GlobalWarningDisplayOff, METH_VARARGS,
   "GlobalWarningDisplayOff() -> None\nC++: static void GlobalWarningDisplayOff()\n\n"},
  {"GetGlobalWarningDisplay", PyvtkObject_GetGlobalWarningDisplay, METH_VARARGS,
   "GetGlobalWarningDisplay() -> int\nC++: static vtkTypeBool GetGlobalWarningDisplay()\n\n"},
  {"GetCommand", PyvtkObject_GetCommand, METH_VARARGS,
   "GetCommand(self, tag:int) -> vtkCommand\nC++: vtkCommand *GetCommand(unsigned long tag)\n\n"},
  {"RemoveObserver", PyvtkObject_RemoveObserver, METH_VARARGS,
   "RemoveObserver(self, __a:vtkCommand) -> None\nC++: void RemoveObserver(vtkCommand *)\nRemoveObserver(self, tag:int) -> None\nC++: void RemoveObserver(unsigned long tag)\n\n"},
  {"RemoveObservers", PyvtkObject_RemoveObservers, METH_VARARGS,
   "RemoveObservers(self, event:int, __b:vtkCommand) -> None\nC++: void RemoveObservers(unsigned long event, vtkCommand *)\nRemoveObservers(self, event:str, __b:vtkCommand) -> None\nC++: void RemoveObservers(const char *event, vtkCommand *)\nRemoveObservers(self, event:int) -> None\nC++: void RemoveObservers(unsigned long event)\nRemoveObservers(self, event:str) -> None\nC++: void RemoveObservers(const char *event)\n\n"},
  {"HasObserver", PyvtkObject_HasObserver, METH_VARARGS,
   "HasObserver(self, event:int, __b:vtkCommand) -> int\nC++: vtkTypeBool HasObserver(unsigned long event, vtkCommand *)\nHasObserver(self, event:str, __b:vtkCommand) -> int\nC++: vtkTypeBool HasObserver(const char *event, vtkCommand *)\nHasObserver(self, event:int) -> int\nC++: vtkTypeBool HasObserver(unsigned long event)\nHasObserver(self, event:str) -> int\nC++: vtkTypeBool HasObserver(const char *event)\n\n"},
  {"RemoveAllObservers", PyvtkObject_RemoveAllObservers, METH_VARARGS,
   "RemoveAllObservers(self) -> None\nC++: void RemoveAllObservers()\n\n"},
  {"SetObjectName", PyvtkObject_SetObjectName, METH_VARARGS,
   "SetObjectName(self, objectName:str) -> None\nC++: virtual void SetObjectName(const std::string &objectName)\n\nSet/get the name of this object for reporting purposes. The name\nappears in warning and debug messages and in the Print output.\nSetting the object name does not change the MTime and does not\ninvoke a ModifiedEvent. Derived classes implementing copying\nmethods are expected not to copy the ObjectName.\n"},
  {"GetObjectName", PyvtkObject_GetObjectName, METH_VARARGS,
   "GetObjectName(self) -> str\nC++: virtual std::string GetObjectName()\n\n"},
  {"GetObjectDescription", PyvtkObject_GetObjectDescription, METH_VARARGS,
   "GetObjectDescription(self) -> str\nC++: std::string GetObjectDescription() override;\n\nThe object description printed in messages and PrintSelf output.\nTo be used only for reporting purposes.\n"},
  {"AddObserver",  PyvtkObject_AddObserver, 1,
   "AddObserver(self, event:int, command:Callback, priority:float=0.0) -> int\nC++: unsigned long AddObserver(const char* event,\n    vtkCommand* command, float priority=0.0f)\n\nAdd an event callback command(o:vtkObject, event:int) for an event type.\nReturns a handle that can be used with RemoveEvent(event:int)."},
{"InvokeEvent", PyvtkObject_InvokeEvent, METH_VARARGS,
   "InvokeEvent(self, event:int, callData:Any) -> int\nC++: int InvokeEvent(unsigned long event, void* callData)\nInvokeEvent(self, event:str, callData:Any) -> int\nC++: int InvokeEvent(const char* event, void* callData)\nInvokeEvent(self, event:int) -> int\nC++: int InvokeEvent(unsigned long event)\nInvokeEvent(self, event:str) -> int\nC++: int InvokeEvent(const char* event)\n\nThis method invokes an event and returns whether the event was\naborted or not. If the event was aborted, the return value is 1,\notherwise it is 0."
},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkObject_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("debug"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkObject_GetDebug(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkObject_SetDebug(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkObject_SetDebug(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDebug/SetDebug\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_warning_display"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkObject_GetGlobalWarningDisplay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkObject_SetGlobalWarningDisplay(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkObject_SetGlobalWarningDisplay(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGlobalWarningDisplay/SetGlobalWarningDisplay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("object_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkObject_GetObjectName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkObject_SetObjectName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkObject_SetObjectName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetObjectName/SetObjectName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkObject_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("object_description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkObject_GetObjectDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetObjectDescription\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkObject_Doc =
  "vtkObject - abstract base class for most VTK objects\n\n"
  "Superclass: vtkObjectBase\n\n"
  "vtkObject is the base class for most objects in the visualization\n"
  "toolkit. vtkObject provides methods for tracking modification time,\n"
  "debugging, printing, and event callbacks. Most objects created within\n"
  "the VTK framework should be a subclass of vtkObject or one of its\n"
  "children.  The few exceptions tend to be very small helper classes\n"
  "that usually never get instantiated or situations where multiple\n"
  "inheritance gets in the way.  vtkObject also performs reference\n"
  "counting: objects that are reference counted exist as long as another\n"
  "object uses them. Once the last reference to a reference counted\n"
  "object is removed, the object will spontaneously destruct.\n\n"
  "@warning\n"
  "Note: in VTK objects should always be created with the New() method\n"
  "and deleted with the Delete() method. VTK objects cannot be allocated\n"
  "off the stack (i.e., automatic objects) because the constructor is a\n"
  "protected method.\n\n"
  "@sa\n"
  "vtkCommand vtkTimeStamp\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkObject_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkObject", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkObject_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkObject_StaticNew()
{
  return vtkObject::New();
}

PyObject *PyvtkObject_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkObject_Type, PyvtkObject_Methods,
    "vtkObject",
 &PyvtkObject_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkObjectBase_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkObject_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkObject(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkObject_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkObject", o) != 0)
  {
    Py_DECREF(o);
  }

}

