// SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause)
//
// THIS FILE IS AUTOGENERATED BY CARGO-LIBBPF-GEN!

pub use self::imp::*;

#[allow(dead_code)]
#[allow(non_snake_case)]
#[allow(non_camel_case_types)]
#[allow(clippy::absolute_paths)]
#[allow(clippy::transmute_ptr_to_ref)]
#[allow(clippy::upper_case_acronyms)]
#[warn(single_use_lifetimes)]
mod imp {
    #[allow(unused_imports)]
    use super::*;
    use libbpf_rs::libbpf_sys;
    use libbpf_rs::skel::OpenSkel;
    use libbpf_rs::skel::Skel;
    use libbpf_rs::skel::SkelBuilder;

    fn build_skel_config(
    ) -> libbpf_rs::Result<libbpf_rs::__internal_skel::ObjectSkeletonConfig<'static>> {
        let mut builder = libbpf_rs::__internal_skel::ObjectSkeletonConfigBuilder::new(DATA);
        builder.name("attach_bpf").prog("attach_prog");

        builder.build()
    }

    #[derive(Default)]
    pub struct AttachSkelBuilder {
        pub obj_builder: libbpf_rs::ObjectBuilder,
    }

    impl<'a> SkelBuilder<'a> for AttachSkelBuilder {
        type Output = OpenAttachSkel<'a>;
        fn open(self) -> libbpf_rs::Result<OpenAttachSkel<'a>> {
            let opts = *self.obj_builder.opts();
            self.open_opts(opts)
        }

        fn open_opts(
            self,
            open_opts: libbpf_sys::bpf_object_open_opts,
        ) -> libbpf_rs::Result<OpenAttachSkel<'a>> {
            let mut skel_config = build_skel_config()?;

            let ret =
                unsafe { libbpf_sys::bpf_object__open_skeleton(skel_config.get(), &open_opts) };
            if ret != 0 {
                return Err(libbpf_rs::Error::from_raw_os_error(-ret));
            }

            let obj = unsafe { libbpf_rs::OpenObject::from_ptr(skel_config.object_ptr())? };

            #[allow(unused_mut)]
            let mut skel = OpenAttachSkel {
                obj,
                // SAFETY: Our `struct_ops` type contains only pointers,
                //         which are allowed to be NULL.
                // TODO: Generate and use a `Default` representation
                //       instead, to cut down on unsafe code.
                struct_ops: unsafe { std::mem::zeroed() },
                skel_config,
            };

            Ok(skel)
        }

        fn object_builder(&self) -> &libbpf_rs::ObjectBuilder {
            &self.obj_builder
        }
        fn object_builder_mut(&mut self) -> &mut libbpf_rs::ObjectBuilder {
            &mut self.obj_builder
        }
    }

    pub struct OpenAttachProgs<'a> {
        inner: &'a libbpf_rs::OpenObject,
    }

    impl OpenAttachProgs<'_> {
        pub fn attach_prog(&self) -> &libbpf_rs::OpenProgram {
            self.inner.prog("attach_prog").unwrap()
        }
    }

    pub struct OpenAttachProgsMut<'a> {
        inner: &'a mut libbpf_rs::OpenObject,
    }

    impl OpenAttachProgsMut<'_> {
        pub fn attach_prog(&mut self) -> &mut libbpf_rs::OpenProgram {
            self.inner.prog_mut("attach_prog").unwrap()
        }
    }

    pub mod attach_types {
        #[allow(unused_imports)]
        use super::*;

        #[derive(Debug, Clone)]
        #[repr(C)]
        pub struct struct_ops {}

        impl struct_ops {}
    }

    pub struct OpenAttachSkel<'a> {
        pub obj: libbpf_rs::OpenObject,
        pub struct_ops: attach_types::struct_ops,
        skel_config: libbpf_rs::__internal_skel::ObjectSkeletonConfig<'a>,
    }

    impl<'a> OpenSkel for OpenAttachSkel<'a> {
        type Output = AttachSkel<'a>;
        fn load(mut self) -> libbpf_rs::Result<AttachSkel<'a>> {
            let ret = unsafe { libbpf_sys::bpf_object__load_skeleton(self.skel_config.get()) };
            if ret != 0 {
                return Err(libbpf_rs::Error::from_raw_os_error(-ret));
            }

            let obj = unsafe { libbpf_rs::Object::from_ptr(self.obj.take_ptr())? };

            Ok(AttachSkel {
                obj,
                struct_ops: self.struct_ops,
                skel_config: self.skel_config,
                links: AttachLinks::default(),
            })
        }

        fn open_object(&self) -> &libbpf_rs::OpenObject {
            &self.obj
        }

        fn open_object_mut(&mut self) -> &mut libbpf_rs::OpenObject {
            &mut self.obj
        }
    }
    impl OpenAttachSkel<'_> {
        pub fn progs_mut(&mut self) -> OpenAttachProgsMut<'_> {
            OpenAttachProgsMut {
                inner: &mut self.obj,
            }
        }

        pub fn progs(&self) -> OpenAttachProgs<'_> {
            OpenAttachProgs { inner: &self.obj }
        }
    }

    pub struct AttachProgs<'a> {
        inner: &'a libbpf_rs::Object,
    }

    impl AttachProgs<'_> {
        pub fn attach_prog(&self) -> &libbpf_rs::Program {
            self.inner.prog("attach_prog").unwrap()
        }
    }

    pub struct AttachProgsMut<'a> {
        inner: &'a mut libbpf_rs::Object,
    }

    impl AttachProgsMut<'_> {
        pub fn attach_prog(&mut self) -> &mut libbpf_rs::Program {
            self.inner.prog_mut("attach_prog").unwrap()
        }
    }

    #[derive(Default)]
    pub struct AttachLinks {
        pub attach_prog: Option<libbpf_rs::Link>,
    }

    pub struct AttachSkel<'a> {
        pub obj: libbpf_rs::Object,
        struct_ops: attach_types::struct_ops,
        skel_config: libbpf_rs::__internal_skel::ObjectSkeletonConfig<'a>,
        pub links: AttachLinks,
    }

    unsafe impl Send for AttachSkel<'_> {}
    unsafe impl Sync for AttachSkel<'_> {}

    impl Skel for AttachSkel<'_> {
        fn object(&self) -> &libbpf_rs::Object {
            &self.obj
        }

        fn object_mut(&mut self) -> &mut libbpf_rs::Object {
            &mut self.obj
        }

        fn attach(&mut self) -> libbpf_rs::Result<()> {
            let ret = unsafe { libbpf_sys::bpf_object__attach_skeleton(self.skel_config.get()) };
            if ret != 0 {
                return Err(libbpf_rs::Error::from_raw_os_error(-ret));
            }

            self.links = AttachLinks {
                attach_prog: core::ptr::NonNull::new(self.skel_config.prog_link_ptr(0)?)
                    .map(|ptr| unsafe { libbpf_rs::Link::from_ptr(ptr) }),
            };

            Ok(())
        }
    }
    impl AttachSkel<'_> {
        pub fn progs_mut(&mut self) -> AttachProgsMut<'_> {
            AttachProgsMut {
                inner: &mut self.obj,
            }
        }

        pub fn progs(&self) -> AttachProgs<'_> {
            AttachProgs { inner: &self.obj }
        }
    }

    const DATA: &[u8] = &[
        127, 69, 76, 70, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 247, 0, 1, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0,
        64, 0, 9, 0, 1, 0, 0, 46, 115, 116, 114, 116, 97, 98, 0, 46, 115, 121, 109, 116, 97, 98, 0,
        115, 121, 115, 99, 97, 108, 108, 0, 108, 105, 99, 101, 110, 115, 101, 0, 118, 101, 114,
        115, 105, 111, 110, 0, 97, 116, 116, 97, 99, 104, 46, 98, 112, 102, 46, 99, 0, 97, 116,
        116, 97, 99, 104, 95, 112, 114, 111, 103, 0, 104, 105, 100, 95, 98, 112, 102, 95, 97, 116,
        116, 97, 99, 104, 95, 112, 114, 111, 103, 0, 95, 108, 105, 99, 101, 110, 115, 101, 0, 95,
        118, 101, 114, 115, 105, 111, 110, 0, 46, 114, 101, 108, 115, 121, 115, 99, 97, 108, 108,
        0, 46, 66, 84, 70, 0, 46, 66, 84, 70, 46, 101, 120, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 4, 0, 241, 255, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 18, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0,
        0, 0, 0, 0, 66, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86,
        0, 0, 0, 17, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 95, 0, 0, 0, 17, 0,
        5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 191, 22, 0, 0, 0, 0, 0, 0, 97, 98, 0,
        0, 0, 0, 0, 0, 97, 97, 4, 0, 0, 0, 0, 0, 180, 3, 0, 0, 0, 0, 0, 0, 133, 16, 0, 0, 255, 255,
        255, 255, 99, 6, 8, 0, 0, 0, 0, 0, 180, 0, 0, 0, 0, 0, 0, 0, 149, 0, 0, 0, 0, 0, 0, 0, 71,
        80, 76, 0, 1, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 4, 0, 0, 0, 159, 235, 1, 0,
        24, 0, 0, 0, 0, 0, 0, 0, 100, 1, 0, 0, 100, 1, 0, 0, 114, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
        2, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 4, 12, 0, 0, 0, 18, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 26,
        0, 0, 0, 4, 0, 0, 0, 32, 0, 0, 0, 30, 0, 0, 0, 3, 0, 0, 0, 64, 0, 0, 0, 37, 0, 0, 0, 0, 0,
        0, 1, 4, 0, 0, 0, 32, 0, 0, 1, 41, 0, 0, 0, 0, 0, 0, 1, 4, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0,
        0, 1, 0, 0, 13, 3, 0, 0, 0, 54, 0, 0, 0, 1, 0, 0, 0, 58, 0, 0, 0, 1, 0, 0, 12, 5, 0, 0, 0,
        0, 0, 0, 0, 3, 0, 0, 13, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
        0, 0, 8, 0, 0, 0, 70, 0, 0, 0, 0, 0, 0, 8, 9, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 8, 4, 0, 0, 0,
        80, 0, 0, 0, 2, 0, 0, 12, 7, 0, 0, 0, 100, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 8, 0, 0, 1, 0,
        0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 11, 0, 0, 0, 13, 0, 0, 0, 4, 0, 0, 0, 105, 0, 0, 0, 0, 0,
        0, 1, 4, 0, 0, 0, 32, 0, 0, 0, 125, 0, 0, 0, 0, 0, 0, 14, 12, 0, 0, 0, 1, 0, 0, 0, 134, 0,
        0, 0, 0, 0, 0, 14, 8, 0, 0, 0, 1, 0, 0, 0, 83, 1, 0, 0, 1, 0, 0, 15, 4, 0, 0, 0, 14, 0, 0,
        0, 0, 0, 0, 0, 4, 0, 0, 0, 91, 1, 0, 0, 1, 0, 0, 15, 4, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 99, 1, 0, 0, 1, 0, 0, 15, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        97, 116, 116, 97, 99, 104, 95, 112, 114, 111, 103, 95, 97, 114, 103, 115, 0, 112, 114, 111,
        103, 95, 102, 100, 0, 104, 105, 100, 0, 114, 101, 116, 118, 97, 108, 0, 105, 110, 116, 0,
        117, 110, 115, 105, 103, 110, 101, 100, 32, 105, 110, 116, 0, 99, 116, 120, 0, 97, 116,
        116, 97, 99, 104, 95, 112, 114, 111, 103, 0, 117, 51, 50, 0, 95, 95, 117, 51, 50, 0, 104,
        105, 100, 95, 98, 112, 102, 95, 97, 116, 116, 97, 99, 104, 95, 112, 114, 111, 103, 0, 99,
        104, 97, 114, 0, 95, 95, 65, 82, 82, 65, 89, 95, 83, 73, 90, 69, 95, 84, 89, 80, 69, 95,
        95, 0, 95, 108, 105, 99, 101, 110, 115, 101, 0, 95, 118, 101, 114, 115, 105, 111, 110, 0,
        47, 98, 117, 105, 108, 100, 47, 117, 100, 101, 118, 45, 104, 105, 100, 45, 98, 112, 102,
        47, 115, 114, 99, 47, 117, 100, 101, 118, 45, 104, 105, 100, 45, 98, 112, 102, 45, 50, 46,
        49, 46, 48, 45, 50, 48, 50, 52, 48, 55, 48, 52, 47, 115, 114, 99, 47, 98, 112, 102, 47, 97,
        116, 116, 97, 99, 104, 46, 98, 112, 102, 46, 99, 0, 105, 110, 116, 32, 97, 116, 116, 97,
        99, 104, 95, 112, 114, 111, 103, 40, 115, 116, 114, 117, 99, 116, 32, 97, 116, 116, 97, 99,
        104, 95, 112, 114, 111, 103, 95, 97, 114, 103, 115, 32, 42, 99, 116, 120, 41, 0, 9, 9, 9,
        9, 9, 32, 32, 99, 116, 120, 45, 62, 112, 114, 111, 103, 95, 102, 100, 44, 0, 9, 99, 116,
        120, 45, 62, 114, 101, 116, 118, 97, 108, 32, 61, 32, 104, 105, 100, 95, 98, 112, 102, 95,
        97, 116, 116, 97, 99, 104, 95, 112, 114, 111, 103, 40, 99, 116, 120, 45, 62, 104, 105, 100,
        44, 0, 9, 114, 101, 116, 117, 114, 110, 32, 48, 59, 0, 108, 105, 99, 101, 110, 115, 101, 0,
        118, 101, 114, 115, 105, 111, 110, 0, 46, 107, 115, 121, 109, 115, 0, 115, 121, 115, 99,
        97, 108, 108, 0, 0, 0, 159, 235, 1, 0, 32, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 20, 0, 0, 0,
        108, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 106, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
        6, 0, 0, 0, 16, 0, 0, 0, 106, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 143, 0, 0, 0, 216, 0, 0, 0,
        0, 52, 0, 0, 8, 0, 0, 0, 143, 0, 0, 0, 6, 1, 0, 0, 13, 64, 0, 0, 16, 0, 0, 0, 143, 0, 0, 0,
        27, 1, 0, 0, 41, 60, 0, 0, 24, 0, 0, 0, 143, 0, 0, 0, 27, 1, 0, 0, 16, 60, 0, 0, 40, 0, 0,
        0, 143, 0, 0, 0, 27, 1, 0, 0, 14, 60, 0, 0, 48, 0, 0, 0, 143, 0, 0, 0, 72, 1, 0, 0, 2, 72,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 0, 0, 0, 0, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 1, 0, 0, 0, 6, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 1, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 1, 0, 0, 0, 3,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 1, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 1,
        0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 1, 0, 0, 0, 0, 0, 0, 4, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104,
        0, 0, 0, 9, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 1, 0, 0, 0, 0,
        0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0,
        0, 0, 0, 0, 116, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200,
        1, 0, 0, 0, 0, 0, 0, 238, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 184, 4, 0, 0, 0, 0, 0, 0, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    ];
}
