/* Visualizer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Visualizer.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <adwaita.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <graphene-gobject.h>
#include <gsk/gsk.h>

#define TUBA_WIDGETS_AUDIO_VISUALIZER_SQR ((gfloat) 256)
#define TUBA_WIDGETS_AUDIO_VISUALIZER_MAX_CIRCLE_HEIGHT 800
#define TUBA_WIDGETS_AUDIO_VISUALIZER_ALPHA 0.5f
#define TUBA_WIDGETS_AUDIO_VISUALIZER_ANIMATION_DURATION ((guint) 100)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER (tuba_widgets_audio_visualizer_get_type ())
#define TUBA_WIDGETS_AUDIO_VISUALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizer))
#define TUBA_WIDGETS_AUDIO_VISUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizerClass))
#define TUBA_WIDGETS_AUDIO_IS_VISUALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER))
#define TUBA_WIDGETS_AUDIO_IS_VISUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER))
#define TUBA_WIDGETS_AUDIO_VISUALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizerClass))

typedef struct _TubaWidgetsAudioVisualizer TubaWidgetsAudioVisualizer;
typedef struct _TubaWidgetsAudioVisualizerClass TubaWidgetsAudioVisualizerClass;
typedef struct _TubaWidgetsAudioVisualizerPrivate TubaWidgetsAudioVisualizerPrivate;
enum  {
	TUBA_WIDGETS_AUDIO_VISUALIZER_0_PROPERTY,
	TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY,
	TUBA_WIDGETS_AUDIO_VISUALIZER_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_audio_visualizer_properties[TUBA_WIDGETS_AUDIO_VISUALIZER_NUM_PROPERTIES];
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TUBA_UTILS_BLURHASH_TYPE_AVERAGE_COLOR (tuba_utils_blurhash_average_color_get_type ())
typedef struct _TubaUtilsBlurhashAverageColor TubaUtilsBlurhashAverageColor;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define __vala_graphene_rect_t_free0(var) ((var == NULL) ? NULL : (var = (_vala_graphene_rect_t_free (var), NULL)))
#define __vala_graphene_point_t_free0(var) ((var == NULL) ? NULL : (var = (_vala_graphene_point_t_free (var), NULL)))

struct _TubaWidgetsAudioVisualizer {
	GtkWidget parent_instance;
	TubaWidgetsAudioVisualizerPrivate * priv;
};

struct _TubaWidgetsAudioVisualizerClass {
	GtkWidgetClass parent_class;
};

struct _TubaWidgetsAudioVisualizerPrivate {
	cairo_t* context;
	GdkRGBA color;
	GdkTexture* cover_texture;
	AdwTimedAnimation* visualizer_animation;
	gboolean animations_enabled;
	gdouble _level;
};

struct _TubaUtilsBlurhashAverageColor {
	gint r;
	gint g;
	gint b;
};

static gint TubaWidgetsAudioVisualizer_private_offset;
static gpointer tuba_widgets_audio_visualizer_parent_class = NULL;

VALA_EXTERN GType tuba_widgets_audio_visualizer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsAudioVisualizer, g_object_unref)
static void tuba_widgets_audio_visualizer_animation_target_cb (TubaWidgetsAudioVisualizer* self,
                                                        gdouble value);
VALA_EXTERN TubaWidgetsAudioVisualizer* tuba_widgets_audio_visualizer_new (GdkTexture* texture,
                                                               const gchar* blurhash);
VALA_EXTERN TubaWidgetsAudioVisualizer* tuba_widgets_audio_visualizer_construct (GType object_type,
                                                                     GdkTexture* texture,
                                                                     const gchar* blurhash);
VALA_EXTERN GType tuba_utils_blurhash_average_color_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaUtilsBlurhashAverageColor* tuba_utils_blurhash_average_color_dup (const TubaUtilsBlurhashAverageColor* self);
VALA_EXTERN void tuba_utils_blurhash_average_color_free (TubaUtilsBlurhashAverageColor* self);
VALA_EXTERN void tuba_utils_blurhash_get_blurhash_average_color (const gchar* blurhash,
                                                     TubaUtilsBlurhashAverageColor* result);
static void tuba_widgets_audio_visualizer_update_accent_color (TubaWidgetsAudioVisualizer* self);
static void _tuba_widgets_audio_visualizer_update_accent_color_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
static void tuba_widgets_audio_visualizer_real_snapshot (GtkWidget* base,
                                                  GtkSnapshot* snapshot);
static graphene_point_t* _vala_graphene_point_t_copy (graphene_point_t* self);
static graphene_rect_t* _vala_graphene_rect_t_copy (graphene_rect_t* self);
static GskRoundedRect* _gsk_rounded_rect_dup (GskRoundedRect* self);
static void _vala_graphene_rect_t_free (graphene_rect_t* self);
static void _vala_graphene_point_t_free (graphene_point_t* self);
VALA_EXTERN gdouble tuba_widgets_audio_visualizer_get_level (TubaWidgetsAudioVisualizer* self);
VALA_EXTERN void tuba_widgets_audio_visualizer_set_level (TubaWidgetsAudioVisualizer* self,
                                              gdouble value);
static GObject * tuba_widgets_audio_visualizer_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _tuba_widgets_audio_visualizer_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                                   gpointer self);
static void tuba_widgets_audio_visualizer_finalize (GObject * obj);
static GType tuba_widgets_audio_visualizer_get_type_once (void);
static void _vala_tuba_widgets_audio_visualizer_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_tuba_widgets_audio_visualizer_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
tuba_widgets_audio_visualizer_get_instance_private (TubaWidgetsAudioVisualizer* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsAudioVisualizer_private_offset);
}

static void
tuba_widgets_audio_visualizer_animation_target_cb (TubaWidgetsAudioVisualizer* self,
                                                   gdouble value)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tuba_widgets_audio_visualizer_update_accent_color_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	tuba_widgets_audio_visualizer_update_accent_color ((TubaWidgetsAudioVisualizer*) self);
}

TubaWidgetsAudioVisualizer*
tuba_widgets_audio_visualizer_construct (GType object_type,
                                         GdkTexture* texture,
                                         const gchar* blurhash)
{
	TubaWidgetsAudioVisualizer * self = NULL;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkTexture* _tmp22_;
	self = (TubaWidgetsAudioVisualizer*) g_object_new (object_type, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) TUBA_WIDGETS_AUDIO_VISUALIZER_SQR, (gint) TUBA_WIDGETS_AUDIO_VISUALIZER_SQR);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	_cairo_destroy0 (self->priv->context);
	self->priv->context = _tmp2_;
	if (blurhash != NULL) {
		_tmp3_ = g_strcmp0 (blurhash, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TubaUtilsBlurhashAverageColor avg = {0};
		TubaUtilsBlurhashAverageColor _tmp4_ = {0};
		TubaUtilsBlurhashAverageColor _tmp5_;
		TubaUtilsBlurhashAverageColor _tmp6_;
		TubaUtilsBlurhashAverageColor _tmp7_;
		GdkRGBA _tmp8_ = {0};
		GdkRGBA _tmp9_;
		GdkRGBA _tmp10_;
		GdkRGBA _tmp11_;
		tuba_utils_blurhash_get_blurhash_average_color (blurhash, &_tmp4_);
		avg = _tmp4_;
		_tmp5_ = avg;
		_tmp6_ = avg;
		_tmp7_ = avg;
		_tmp8_.red = _tmp5_.r / 255.0f;
		_tmp8_.green = _tmp6_.g / 255.0f;
		_tmp8_.blue = _tmp7_.b / 255.0f;
		_tmp8_.alpha = TUBA_WIDGETS_AUDIO_VISUALIZER_ALPHA;
		self->priv->color = _tmp8_;
		_tmp9_ = self->priv->color;
		_tmp10_ = self->priv->color;
		_tmp11_ = self->priv->color;
		if ((((0.2126f * _tmp9_.red) + (0.7152f * _tmp10_.green)) + (0.0722f * _tmp11_.blue)) < 0.156862745f) {
			GdkRGBA _tmp12_;
			GdkRGBA _tmp13_;
			GdkRGBA _tmp14_;
			_tmp12_ = self->priv->color;
			self->priv->color.red = MIN ((gfloat) 1, _tmp12_.red + 0.3f);
			_tmp13_ = self->priv->color;
			self->priv->color.green = MIN ((gfloat) 1, _tmp13_.green + 0.3f);
			_tmp14_ = self->priv->color;
			self->priv->color.blue = MIN ((gfloat) 1, _tmp14_.blue + 0.3f);
		}
	} else {
		AdwStyleManager* default_sm = NULL;
		AdwStyleManager* _tmp15_;
		AdwStyleManager* _tmp16_;
		AdwStyleManager* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp15_ = adw_style_manager_get_default ();
		_tmp16_ = _g_object_ref0 (_tmp15_);
		default_sm = _tmp16_;
		_tmp17_ = default_sm;
		_tmp18_ = adw_style_manager_get_system_supports_accent_colors (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			AdwStyleManager* _tmp20_;
			_tmp20_ = default_sm;
			g_signal_connect_object ((GObject*) _tmp20_, "notify::accent-color-rgba", (GCallback) _tuba_widgets_audio_visualizer_update_accent_color_g_object_notify, self, 0);
			tuba_widgets_audio_visualizer_update_accent_color (self);
		} else {
			GdkRGBA _tmp21_ = {0};
			_tmp21_.red = 120 / 255.0f;
			_tmp21_.green = 174 / 255.0f;
			_tmp21_.blue = 237 / 255.0f;
			_tmp21_.alpha = TUBA_WIDGETS_AUDIO_VISUALIZER_ALPHA;
			self->priv->color = _tmp21_;
		}
		_g_object_unref0 (default_sm);
	}
	_tmp22_ = _g_object_ref0 (texture);
	_g_object_unref0 (self->priv->cover_texture);
	self->priv->cover_texture = _tmp22_;
	_cairo_surface_destroy0 (surface);
	return self;
}

TubaWidgetsAudioVisualizer*
tuba_widgets_audio_visualizer_new (GdkTexture* texture,
                                   const gchar* blurhash)
{
	return tuba_widgets_audio_visualizer_construct (TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, texture, blurhash);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
tuba_widgets_audio_visualizer_update_accent_color (TubaWidgetsAudioVisualizer* self)
{
	AdwStyleManager* _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = adw_style_manager_get_default ();
	_tmp1_ = adw_style_manager_get_accent_color_rgba (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->color = *_tmp2_;
	__vala_GdkRGBA_free0 (_tmp2_);
	self->priv->color.alpha = TUBA_WIDGETS_AUDIO_VISUALIZER_ALPHA;
}

static graphene_point_t*
_vala_graphene_point_t_copy (graphene_point_t* self)
{
	return g_boxed_copy (graphene_point_get_type (), self);
}

static gpointer
__vala_graphene_point_t_copy0 (gpointer self)
{
	return self ? _vala_graphene_point_t_copy (self) : NULL;
}

static graphene_rect_t*
_vala_graphene_rect_t_copy (graphene_rect_t* self)
{
	return g_boxed_copy (graphene_rect_get_type (), self);
}

static gpointer
__vala_graphene_rect_t_copy0 (gpointer self)
{
	return self ? _vala_graphene_rect_t_copy (self) : NULL;
}

static GskRoundedRect*
_gsk_rounded_rect_dup (GskRoundedRect* self)
{
	GskRoundedRect* dup;
	dup = g_new0 (GskRoundedRect, 1);
	memcpy (dup, self, sizeof (GskRoundedRect));
	return dup;
}

static gpointer
__gsk_rounded_rect_dup0 (gpointer self)
{
	return self ? _gsk_rounded_rect_dup (self) : NULL;
}

static void
_vala_graphene_rect_t_free (graphene_rect_t* self)
{
	g_boxed_free (graphene_rect_get_type (), self);
}

static void
_vala_graphene_point_t_free (graphene_point_t* self)
{
	g_boxed_free (graphene_point_get_type (), self);
}

static void
tuba_widgets_audio_visualizer_real_snapshot (GtkWidget* base,
                                             GtkSnapshot* snapshot)
{
	TubaWidgetsAudioVisualizer * self;
	gint win_w = 0;
	gint win_h = 0;
	gint new_center_w = 0;
	gint new_center_h = 0;
	graphene_point_t* point = NULL;
	graphene_point_t _tmp0_ = {0};
	graphene_point_t* _tmp1_;
	graphene_point_t* _tmp2_;
	graphene_point_t _tmp3_;
	GdkTexture* _tmp18_;
	self = (TubaWidgetsAudioVisualizer*) base;
	g_return_if_fail (snapshot != NULL);
	win_w = gtk_widget_get_width ((GtkWidget*) self);
	win_h = gtk_widget_get_height ((GtkWidget*) self);
	new_center_w = win_w / 2;
	new_center_h = win_h / 2;
	memset (&_tmp0_, 0, sizeof (graphene_point_t));
	_tmp1_ = __vala_graphene_point_t_copy0 (graphene_point_init (&_tmp0_, (gfloat) new_center_w, (gfloat) new_center_h));
	point = _tmp1_;
	_tmp2_ = point;
	_tmp3_ = *_tmp2_;
	gtk_snapshot_translate (snapshot, &_tmp3_);
	if (self->priv->animations_enabled) {
		gfloat res = 0.0F;
		AdwTimedAnimation* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		graphene_rect_t* rect = NULL;
		graphene_rect_t _tmp7_ = {0};
		graphene_rect_t* _tmp8_;
		GskRoundedRect* rounded_rect = NULL;
		GskRoundedRect _tmp9_ = {0};
		graphene_rect_t* _tmp10_;
		graphene_rect_t _tmp11_;
		GskRoundedRect* _tmp12_;
		GskRoundedRect* _tmp13_;
		GskRoundedRect _tmp14_;
		GdkRGBA _tmp15_;
		graphene_rect_t* _tmp16_;
		graphene_rect_t _tmp17_;
		_tmp4_ = self->priv->visualizer_animation;
		_tmp5_ = adw_animation_get_value ((AdwAnimation*) _tmp4_);
		_tmp6_ = _tmp5_;
		res = (((gfloat) _tmp6_) * (MIN (TUBA_WIDGETS_AUDIO_VISUALIZER_MAX_CIRCLE_HEIGHT, win_h) - TUBA_WIDGETS_AUDIO_VISUALIZER_SQR)) + TUBA_WIDGETS_AUDIO_VISUALIZER_SQR;
		memset (&_tmp7_, 0, sizeof (graphene_rect_t));
		_tmp8_ = __vala_graphene_rect_t_copy0 (graphene_rect_init (&_tmp7_, (-res) / 2, (-res) / 2, res, res));
		rect = _tmp8_;
		memset (&_tmp9_, 0, sizeof (GskRoundedRect));
		_tmp10_ = rect;
		_tmp11_ = *_tmp10_;
		_tmp12_ = __gsk_rounded_rect_dup0 (gsk_rounded_rect_init_from_rect (&_tmp9_, &_tmp11_, (gfloat) 9999));
		rounded_rect = _tmp12_;
		_tmp13_ = rounded_rect;
		_tmp14_ = *_tmp13_;
		gtk_snapshot_push_rounded_clip (snapshot, &_tmp14_);
		_tmp15_ = self->priv->color;
		_tmp16_ = rect;
		_tmp17_ = *_tmp16_;
		gtk_snapshot_append_color (snapshot, &_tmp15_, &_tmp17_);
		gtk_snapshot_pop (snapshot);
		_g_free0 (rounded_rect);
		__vala_graphene_rect_t_free0 (rect);
	}
	_tmp18_ = self->priv->cover_texture;
	if (_tmp18_ != NULL) {
		graphene_rect_t* cover_rect = NULL;
		graphene_rect_t _tmp19_ = {0};
		graphene_rect_t* _tmp20_;
		GskRoundedRect* rounded_cover_rect = NULL;
		GskRoundedRect _tmp21_ = {0};
		graphene_rect_t* _tmp22_;
		graphene_rect_t _tmp23_;
		GskRoundedRect* _tmp24_;
		GskRoundedRect* _tmp25_;
		GskRoundedRect _tmp26_;
		GdkTexture* _tmp27_;
		graphene_rect_t* _tmp28_;
		graphene_rect_t _tmp29_;
		memset (&_tmp19_, 0, sizeof (graphene_rect_t));
		_tmp20_ = __vala_graphene_rect_t_copy0 (graphene_rect_init (&_tmp19_, (-TUBA_WIDGETS_AUDIO_VISUALIZER_SQR) / 2, (-TUBA_WIDGETS_AUDIO_VISUALIZER_SQR) / 2, TUBA_WIDGETS_AUDIO_VISUALIZER_SQR, TUBA_WIDGETS_AUDIO_VISUALIZER_SQR));
		cover_rect = _tmp20_;
		memset (&_tmp21_, 0, sizeof (GskRoundedRect));
		_tmp22_ = cover_rect;
		_tmp23_ = *_tmp22_;
		_tmp24_ = __gsk_rounded_rect_dup0 (gsk_rounded_rect_init_from_rect (&_tmp21_, &_tmp23_, TUBA_WIDGETS_AUDIO_VISUALIZER_SQR));
		rounded_cover_rect = _tmp24_;
		_tmp25_ = rounded_cover_rect;
		_tmp26_ = *_tmp25_;
		gtk_snapshot_push_rounded_clip (snapshot, &_tmp26_);
		_tmp27_ = self->priv->cover_texture;
		_tmp28_ = cover_rect;
		_tmp29_ = *_tmp28_;
		gtk_snapshot_append_texture (snapshot, _tmp27_, &_tmp29_);
		gtk_snapshot_pop (snapshot);
		_g_free0 (rounded_cover_rect);
		__vala_graphene_rect_t_free0 (cover_rect);
	}
	__vala_graphene_point_t_free0 (point);
}

gdouble
tuba_widgets_audio_visualizer_get_level (TubaWidgetsAudioVisualizer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_level;
	return result;
}

void
tuba_widgets_audio_visualizer_set_level (TubaWidgetsAudioVisualizer* self,
                                         gdouble value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->animations_enabled) {
		AdwTimedAnimation* _tmp0_;
		AdwTimedAnimation* _tmp1_;
		AdwTimedAnimation* _tmp2_;
		_tmp0_ = self->priv->visualizer_animation;
		adw_timed_animation_set_value_from (_tmp0_, self->priv->_level);
		_tmp1_ = self->priv->visualizer_animation;
		adw_timed_animation_set_value_to (_tmp1_, value);
		_tmp2_ = self->priv->visualizer_animation;
		adw_animation_play ((AdwAnimation*) _tmp2_);
	}
	self->priv->_level = value;
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_visualizer_properties[TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY]);
}

static void
_tuba_widgets_audio_visualizer_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                              gpointer self)
{
	tuba_widgets_audio_visualizer_animation_target_cb ((TubaWidgetsAudioVisualizer*) self, value);
}

static GObject *
tuba_widgets_audio_visualizer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsAudioVisualizer * self;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	AdwCallbackAnimationTarget* target = NULL;
	AdwCallbackAnimationTarget* _tmp6_;
	AdwCallbackAnimationTarget* _tmp7_;
	AdwAnimationTarget* _tmp8_;
	AdwTimedAnimation* _tmp9_;
	parent_class = G_OBJECT_CLASS (tuba_widgets_audio_visualizer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizer);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtk_settings = _tmp1_;
	_tmp2_ = gtk_settings;
	if (_tmp2_ != NULL) {
		GtkSettings* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = gtk_settings;
		g_object_get (_tmp3_, "gtk-enable-animations", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		self->priv->animations_enabled = _tmp5_;
	}
	_tmp6_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_tuba_widgets_audio_visualizer_animation_target_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	target = _tmp6_;
	_tmp7_ = target;
	_tmp8_ = _g_object_ref0 ((AdwAnimationTarget*) _tmp7_);
	_tmp9_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, 0.0, 1.0, TUBA_WIDGETS_AUDIO_VISUALIZER_ANIMATION_DURATION, _tmp8_);
	_g_object_unref0 (self->priv->visualizer_animation);
	self->priv->visualizer_animation = _tmp9_;
	_g_object_unref0 (target);
	_g_object_unref0 (gtk_settings);
	return obj;
}

static void
tuba_widgets_audio_visualizer_class_init (TubaWidgetsAudioVisualizerClass * klass,
                                          gpointer klass_data)
{
	tuba_widgets_audio_visualizer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsAudioVisualizer_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) tuba_widgets_audio_visualizer_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_audio_visualizer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_audio_visualizer_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_audio_visualizer_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_audio_visualizer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY, tuba_widgets_audio_visualizer_properties[TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY] = g_param_spec_double ("level", "level", "level", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tuba_widgets_audio_visualizer_instance_init (TubaWidgetsAudioVisualizer * self,
                                             gpointer klass)
{
	self->priv = tuba_widgets_audio_visualizer_get_instance_private (self);
	self->priv->animations_enabled = TRUE;
	self->priv->_level = 0.0;
}

static void
tuba_widgets_audio_visualizer_finalize (GObject * obj)
{
	TubaWidgetsAudioVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizer);
	g_debug ("Visualizer.vala:115: Destroying AudioVisualizer");
	_cairo_destroy0 (self->priv->context);
	_g_object_unref0 (self->priv->cover_texture);
	_g_object_unref0 (self->priv->visualizer_animation);
	G_OBJECT_CLASS (tuba_widgets_audio_visualizer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_audio_visualizer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsAudioVisualizerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_audio_visualizer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsAudioVisualizer), 0, (GInstanceInitFunc) tuba_widgets_audio_visualizer_instance_init, NULL };
	GType tuba_widgets_audio_visualizer_type_id;
	tuba_widgets_audio_visualizer_type_id = g_type_register_static (gtk_widget_get_type (), "TubaWidgetsAudioVisualizer", &g_define_type_info, 0);
	TubaWidgetsAudioVisualizer_private_offset = g_type_add_instance_private (tuba_widgets_audio_visualizer_type_id, sizeof (TubaWidgetsAudioVisualizerPrivate));
	return tuba_widgets_audio_visualizer_type_id;
}

GType
tuba_widgets_audio_visualizer_get_type (void)
{
	static gsize tuba_widgets_audio_visualizer_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_audio_visualizer_type_id__once)) {
		GType tuba_widgets_audio_visualizer_type_id;
		tuba_widgets_audio_visualizer_type_id = tuba_widgets_audio_visualizer_get_type_once ();
		g_once_init_leave (&tuba_widgets_audio_visualizer_type_id__once, tuba_widgets_audio_visualizer_type_id);
	}
	return tuba_widgets_audio_visualizer_type_id__once;
}

static void
_vala_tuba_widgets_audio_visualizer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	TubaWidgetsAudioVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizer);
	switch (property_id) {
		case TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY:
		g_value_set_double (value, tuba_widgets_audio_visualizer_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_audio_visualizer_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	TubaWidgetsAudioVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_AUDIO_TYPE_VISUALIZER, TubaWidgetsAudioVisualizer);
	switch (property_id) {
		case TUBA_WIDGETS_AUDIO_VISUALIZER_LEVEL_PROPERTY:
		tuba_widgets_audio_visualizer_set_level (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

