/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_SCREENSAVER_V1_SERVER_PROTOCOL_H
#define TREELAND_SCREENSAVER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_screensaver_v1 The treeland_screensaver_v1 protocol
 * @section page_ifaces_treeland_screensaver_v1 Interfaces
 * - @subpage page_iface_treeland_screensaver_v1 - Simple idle inhibit protocol
 * @section page_copyright_treeland_screensaver_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_screensaver_v1;

#ifndef TREELAND_SCREENSAVER_V1_INTERFACE
#define TREELAND_SCREENSAVER_V1_INTERFACE
/**
 * @page page_iface_treeland_screensaver_v1 treeland_screensaver_v1
 * @section page_iface_treeland_screensaver_v1_desc Description
 *
 * This object implements a simple idle inhibit protocol used
 * to implement org.freedesktop.ScreenSaver D-Bus interface.
 *
 * Call inhibit to prevent treeland from entering idle state.
 * Call uninhibit or disconnect from the global to release
 * the inhibit.
 *
 * If the client disconnects from the compositor, the inhibit
 * associated with that client is automatically released.
 *
 * There can be only one inhibit per client per time. Calling
 * inhibit multiple times will raise an error. Call uninhibit
 * before inhibit to update application_name and reason
 * recorded.
 *
 * Warning! The protocol described in this file is currently
 * in the testing phase. Backward compatible changes may be
 * added together with the corresponding interface version
 * bump. Backward incompatible changes can only be done by
 * creating a new major version of the extension.
 * @section page_iface_treeland_screensaver_v1_api API
 * See @ref iface_treeland_screensaver_v1.
 */
/**
 * @defgroup iface_treeland_screensaver_v1 The treeland_screensaver_v1 interface
 *
 * This object implements a simple idle inhibit protocol used
 * to implement org.freedesktop.ScreenSaver D-Bus interface.
 *
 * Call inhibit to prevent treeland from entering idle state.
 * Call uninhibit or disconnect from the global to release
 * the inhibit.
 *
 * If the client disconnects from the compositor, the inhibit
 * associated with that client is automatically released.
 *
 * There can be only one inhibit per client per time. Calling
 * inhibit multiple times will raise an error. Call uninhibit
 * before inhibit to update application_name and reason
 * recorded.
 *
 * Warning! The protocol described in this file is currently
 * in the testing phase. Backward compatible changes may be
 * added together with the corresponding interface version
 * bump. Backward incompatible changes can only be done by
 * creating a new major version of the extension.
 */
extern const struct wl_interface treeland_screensaver_v1_interface;
#endif

#ifndef TREELAND_SCREENSAVER_V1_ERROR_ENUM
#define TREELAND_SCREENSAVER_V1_ERROR_ENUM
enum treeland_screensaver_v1_error {
	/**
	 * Trying to uninhibit but no active inhibit existed
	 */
	TREELAND_SCREENSAVER_V1_ERROR_NOT_YET_INHIBITED = 0,
	/**
	 * Trying to inhibit with an active inhibit existed
	 */
	TREELAND_SCREENSAVER_V1_ERROR_ALREADY_INHIBITED = 1,
};
#endif /* TREELAND_SCREENSAVER_V1_ERROR_ENUM */

#ifndef TREELAND_SCREENSAVER_V1_ERROR_ENUM_IS_VALID
#define TREELAND_SCREENSAVER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_screensaver_v1
 * Validate a treeland_screensaver_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_screensaver_v1_error
 */
static inline bool
treeland_screensaver_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SCREENSAVER_V1_ERROR_NOT_YET_INHIBITED:
		return version >= 1;
	case TREELAND_SCREENSAVER_V1_ERROR_ALREADY_INHIBITED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SCREENSAVER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_screensaver_v1
 * @struct treeland_screensaver_v1_interface
 */
struct treeland_screensaver_v1_interface {
	/**
	 * Inhibit idleness
	 *
	 * Inhibit idleness with given application_name and
	 * reason_for_inhibit.
	 */
	void (*inhibit)(struct wl_client *client,
			struct wl_resource *resource,
			const char *application_name,
			const char *reason_for_inhibit);
	/**
	 * Uninhibit idleness
	 *
	 * Uninhibit idleness previously inhibited by inhibit request.
	 */
	void (*uninhibit)(struct wl_client *client,
			  struct wl_resource *resource);
};


/**
 * @ingroup iface_treeland_screensaver_v1
 */
#define TREELAND_SCREENSAVER_V1_INHIBIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_screensaver_v1
 */
#define TREELAND_SCREENSAVER_V1_UNINHIBIT_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
