/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ARM.td                                                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands,
                       const SmallBitVector &OptionalOperandsMask);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                SmallVectorImpl<NearMissInfo> *NearMisses,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_AlignedMemory16,
  Match_AlignedMemory32,
  Match_AlignedMemory64,
  Match_AlignedMemory64or128,
  Match_AlignedMemory64or128or256,
  Match_AlignedMemoryNone,
  Match_ComplexRotationEven,
  Match_ComplexRotationOdd,
  Match_CondCodeRestrictedFP,
  Match_CondCodeRestrictedI,
  Match_CondCodeRestrictedS,
  Match_CondCodeRestrictedU,
  Match_DPR,
  Match_DPR_8,
  Match_DPR_RegList,
  Match_DPR_VFP2,
  Match_DupAlignedMemory16,
  Match_DupAlignedMemory32,
  Match_DupAlignedMemory64,
  Match_DupAlignedMemory64or128,
  Match_DupAlignedMemoryNone,
  Match_GPR,
  Match_GPRnoip,
  Match_GPRnopc,
  Match_GPRnosp,
  Match_GPRsp,
  Match_GPRwithAPSR,
  Match_GPRwithAPSR_NZCVnosp,
  Match_GPRwithZR,
  Match_GPRwithZRnosp,
  Match_Imm0_1,
  Match_Imm0_15,
  Match_Imm0_239,
  Match_Imm0_255,
  Match_Imm0_255Expr,
  Match_Imm0_3,
  Match_Imm0_31,
  Match_Imm0_32,
  Match_Imm0_4095,
  Match_Imm0_63,
  Match_Imm0_65535,
  Match_Imm0_65535Expr,
  Match_Imm0_7,
  Match_Imm11b,
  Match_Imm12b,
  Match_Imm13b,
  Match_Imm16,
  Match_Imm1_15,
  Match_Imm1_31,
  Match_Imm1_7,
  Match_Imm24bit,
  Match_Imm256_65535Expr,
  Match_Imm32,
  Match_Imm3b,
  Match_Imm4b,
  Match_Imm6b,
  Match_Imm7b,
  Match_Imm8,
  Match_Imm8_255,
  Match_Imm9b,
  Match_ImmRange1_16,
  Match_ImmRange1_32,
  Match_ImmThumbSR,
  Match_LELabel,
  Match_MVELongShift,
  Match_MVEShiftImm1_15,
  Match_MVEShiftImm1_7,
  Match_MVEVcvtImm16,
  Match_MVEVcvtImm32,
  Match_MveSaturate,
  Match_PKHLSLImm,
  Match_QPR,
  Match_QPR_8,
  Match_QPR_VFP2,
  Match_SPR,
  Match_SPRRegList,
  Match_SPR_8,
  Match_SetEndImm,
  Match_ShrImm16,
  Match_ShrImm32,
  Match_ShrImm64,
  Match_ShrImm8,
  Match_VIDUP_imm,
  Match_VecListFourMQ,
  Match_VecListTwoMQ,
  Match_WLSLabel,
  Match_hGPR,
  Match_rGPR,
  Match_tGPR,
  Match_tGPREven,
  Match_tGPROdd,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasV4TBit = 35,
  Feature_HasV5TBit = 36,
  Feature_HasV5TEBit = 37,
  Feature_HasV6Bit = 38,
  Feature_HasV6MBit = 40,
  Feature_HasV8MBaselineBit = 45,
  Feature_HasV8MMainlineBit = 46,
  Feature_HasV8_1MMainlineBit = 47,
  Feature_HasMVEIntBit = 26,
  Feature_HasMVEFloatBit = 25,
  Feature_HasCDEBit = 4,
  Feature_HasFPRegsBit = 18,
  Feature_HasFPRegs16Bit = 19,
  Feature_HasNoFPRegs16Bit = 29,
  Feature_HasFPRegs64Bit = 20,
  Feature_HasFPRegsV8_1MBit = 21,
  Feature_HasV6T2Bit = 41,
  Feature_HasV6KBit = 39,
  Feature_HasV7Bit = 42,
  Feature_HasV8Bit = 44,
  Feature_PreV8Bit = 64,
  Feature_HasV8_1aBit = 48,
  Feature_HasV8_2aBit = 49,
  Feature_HasV8_3aBit = 50,
  Feature_HasV8_4aBit = 51,
  Feature_HasV8_5aBit = 52,
  Feature_HasV8_6aBit = 53,
  Feature_HasV8_7aBit = 54,
  Feature_HasVFP2Bit = 55,
  Feature_HasVFP3Bit = 56,
  Feature_HasVFP4Bit = 57,
  Feature_HasDPVFPBit = 10,
  Feature_HasFPARMv8Bit = 17,
  Feature_HasNEONBit = 28,
  Feature_HasSHA2Bit = 33,
  Feature_HasAESBit = 1,
  Feature_HasCryptoBit = 7,
  Feature_HasDotProdBit = 14,
  Feature_HasCRCBit = 6,
  Feature_HasRASBit = 31,
  Feature_HasLOBBit = 23,
  Feature_HasPACBTIBit = 30,
  Feature_HasFP16Bit = 15,
  Feature_HasFullFP16Bit = 22,
  Feature_HasFP16FMLBit = 16,
  Feature_HasBF16Bit = 3,
  Feature_HasMatMulInt8Bit = 27,
  Feature_HasDivideInThumbBit = 13,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 11,
  Feature_HasDBBit = 8,
  Feature_HasDFBBit = 9,
  Feature_HasV7ClrexBit = 43,
  Feature_HasAcquireReleaseBit = 2,
  Feature_HasMPBit = 24,
  Feature_HasVirtualizationBit = 58,
  Feature_HasTrustZoneBit = 34,
  Feature_Has8MSecExtBit = 0,
  Feature_IsThumbBit = 62,
  Feature_IsThumb2Bit = 63,
  Feature_IsMClassBit = 60,
  Feature_IsNotMClassBit = 61,
  Feature_IsARMBit = 59,
  Feature_UseNaClTrapBit = 65,
  Feature_UseNegativeImmediatesBit = 66,
  Feature_HasSBBit = 32,
  Feature_HasCLRBHBBit = 5,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 45 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::D0;	 // "d0"
      case '1':	 // 1 string to match.
        return ARM::D1;	 // "d1"
      case '2':	 // 1 string to match.
        return ARM::D2;	 // "d2"
      case '3':	 // 1 string to match.
        return ARM::D3;	 // "d3"
      case '4':	 // 1 string to match.
        return ARM::D4;	 // "d4"
      case '5':	 // 1 string to match.
        return ARM::D5;	 // "d5"
      case '6':	 // 1 string to match.
        return ARM::D6;	 // "d6"
      case '7':	 // 1 string to match.
        return ARM::D7;	 // "d7"
      case '8':	 // 1 string to match.
        return ARM::D8;	 // "d8"
      case '9':	 // 1 string to match.
        return ARM::D9;	 // "d9"
      }
      break;
    case 'l':	 // 1 string to match.
      if (Name[1] != 'r')
        break;
      return ARM::LR;	 // "lr"
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::P0;	 // "p0"
      case 'c':	 // 1 string to match.
        return ARM::PC;	 // "pc"
      }
      break;
    case 'q':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::Q0;	 // "q0"
      case '1':	 // 1 string to match.
        return ARM::Q1;	 // "q1"
      case '2':	 // 1 string to match.
        return ARM::Q2;	 // "q2"
      case '3':	 // 1 string to match.
        return ARM::Q3;	 // "q3"
      case '4':	 // 1 string to match.
        return ARM::Q4;	 // "q4"
      case '5':	 // 1 string to match.
        return ARM::Q5;	 // "q5"
      case '6':	 // 1 string to match.
        return ARM::Q6;	 // "q6"
      case '7':	 // 1 string to match.
        return ARM::Q7;	 // "q7"
      case '8':	 // 1 string to match.
        return ARM::Q8;	 // "q8"
      case '9':	 // 1 string to match.
        return ARM::Q9;	 // "q9"
      }
      break;
    case 'r':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::R0;	 // "r0"
      case '1':	 // 1 string to match.
        return ARM::R1;	 // "r1"
      case '2':	 // 1 string to match.
        return ARM::R2;	 // "r2"
      case '3':	 // 1 string to match.
        return ARM::R3;	 // "r3"
      case '4':	 // 1 string to match.
        return ARM::R4;	 // "r4"
      case '5':	 // 1 string to match.
        return ARM::R5;	 // "r5"
      case '6':	 // 1 string to match.
        return ARM::R6;	 // "r6"
      case '7':	 // 1 string to match.
        return ARM::R7;	 // "r7"
      case '8':	 // 1 string to match.
        return ARM::R8;	 // "r8"
      case '9':	 // 1 string to match.
        return ARM::R9;	 // "r9"
      }
      break;
    case 's':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::S0;	 // "s0"
      case '1':	 // 1 string to match.
        return ARM::S1;	 // "s1"
      case '2':	 // 1 string to match.
        return ARM::S2;	 // "s2"
      case '3':	 // 1 string to match.
        return ARM::S3;	 // "s3"
      case '4':	 // 1 string to match.
        return ARM::S4;	 // "s4"
      case '5':	 // 1 string to match.
        return ARM::S5;	 // "s5"
      case '6':	 // 1 string to match.
        return ARM::S6;	 // "s6"
      case '7':	 // 1 string to match.
        return ARM::S7;	 // "s7"
      case '8':	 // 1 string to match.
        return ARM::S8;	 // "s8"
      case '9':	 // 1 string to match.
        return ARM::S9;	 // "s9"
      case 'p':	 // 1 string to match.
        return ARM::SP;	 // "sp"
      }
      break;
    case 'z':	 // 1 string to match.
      if (Name[1] != 'r')
        break;
      return ARM::ZR;	 // "zr"
    }
    break;
  case 3:	 // 54 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::D10;	 // "d10"
        case '1':	 // 1 string to match.
          return ARM::D11;	 // "d11"
        case '2':	 // 1 string to match.
          return ARM::D12;	 // "d12"
        case '3':	 // 1 string to match.
          return ARM::D13;	 // "d13"
        case '4':	 // 1 string to match.
          return ARM::D14;	 // "d14"
        case '5':	 // 1 string to match.
          return ARM::D15;	 // "d15"
        case '6':	 // 1 string to match.
          return ARM::D16;	 // "d16"
        case '7':	 // 1 string to match.
          return ARM::D17;	 // "d17"
        case '8':	 // 1 string to match.
          return ARM::D18;	 // "d18"
        case '9':	 // 1 string to match.
          return ARM::D19;	 // "d19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::D20;	 // "d20"
        case '1':	 // 1 string to match.
          return ARM::D21;	 // "d21"
        case '2':	 // 1 string to match.
          return ARM::D22;	 // "d22"
        case '3':	 // 1 string to match.
          return ARM::D23;	 // "d23"
        case '4':	 // 1 string to match.
          return ARM::D24;	 // "d24"
        case '5':	 // 1 string to match.
          return ARM::D25;	 // "d25"
        case '6':	 // 1 string to match.
          return ARM::D26;	 // "d26"
        case '7':	 // 1 string to match.
          return ARM::D27;	 // "d27"
        case '8':	 // 1 string to match.
          return ARM::D28;	 // "d28"
        case '9':	 // 1 string to match.
          return ARM::D29;	 // "d29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::D30;	 // "d30"
        case '1':	 // 1 string to match.
          return ARM::D31;	 // "d31"
        }
        break;
      }
      break;
    case 'q':	 // 6 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::Q10;	 // "q10"
      case '1':	 // 1 string to match.
        return ARM::Q11;	 // "q11"
      case '2':	 // 1 string to match.
        return ARM::Q12;	 // "q12"
      case '3':	 // 1 string to match.
        return ARM::Q13;	 // "q13"
      case '4':	 // 1 string to match.
        return ARM::Q14;	 // "q14"
      case '5':	 // 1 string to match.
        return ARM::Q15;	 // "q15"
      }
      break;
    case 'r':	 // 3 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::R10;	 // "r10"
      case '1':	 // 1 string to match.
        return ARM::R11;	 // "r11"
      case '2':	 // 1 string to match.
        return ARM::R12;	 // "r12"
      }
      break;
    case 's':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::S10;	 // "s10"
        case '1':	 // 1 string to match.
          return ARM::S11;	 // "s11"
        case '2':	 // 1 string to match.
          return ARM::S12;	 // "s12"
        case '3':	 // 1 string to match.
          return ARM::S13;	 // "s13"
        case '4':	 // 1 string to match.
          return ARM::S14;	 // "s14"
        case '5':	 // 1 string to match.
          return ARM::S15;	 // "s15"
        case '6':	 // 1 string to match.
          return ARM::S16;	 // "s16"
        case '7':	 // 1 string to match.
          return ARM::S17;	 // "s17"
        case '8':	 // 1 string to match.
          return ARM::S18;	 // "s18"
        case '9':	 // 1 string to match.
          return ARM::S19;	 // "s19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::S20;	 // "s20"
        case '1':	 // 1 string to match.
          return ARM::S21;	 // "s21"
        case '2':	 // 1 string to match.
          return ARM::S22;	 // "s22"
        case '3':	 // 1 string to match.
          return ARM::S23;	 // "s23"
        case '4':	 // 1 string to match.
          return ARM::S24;	 // "s24"
        case '5':	 // 1 string to match.
          return ARM::S25;	 // "s25"
        case '6':	 // 1 string to match.
          return ARM::S26;	 // "s26"
        case '7':	 // 1 string to match.
          return ARM::S27;	 // "s27"
        case '8':	 // 1 string to match.
          return ARM::S28;	 // "s28"
        case '9':	 // 1 string to match.
          return ARM::S29;	 // "s29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return ARM::S30;	 // "s30"
        case '1':	 // 1 string to match.
          return ARM::S31;	 // "s31"
        }
        break;
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pr", 2) != 0)
        break;
      return ARM::VPR;	 // "vpr"
    }
    break;
  case 4:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return ARM::APSR;	 // "apsr"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return ARM::CPSR;	 // "cpsr"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psr", 3) != 0)
        break;
      return ARM::SPSR;	 // "spsr"
    }
    break;
  case 5:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 3 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+3, "xc", 2) != 0)
          break;
        return ARM::FPEXC;	 // "fpexc"
      case 's':	 // 2 strings to match.
        switch (Name[3]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (Name[4] != 'r')
            break;
          return ARM::FPSCR;	 // "fpscr"
        case 'i':	 // 1 string to match.
          if (Name[4] != 'd')
            break;
          return ARM::FPSID;	 // "fpsid"
        }
        break;
      }
      break;
    case 'm':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "vfr", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return ARM::MVFR0;	 // "mvfr0"
      case '1':	 // 1 string to match.
        return ARM::MVFR1;	 // "mvfr1"
      case '2':	 // 1 string to match.
        return ARM::MVFR2;	 // "mvfr2"
      }
      break;
    }
    break;
  case 6:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "fp", 2) != 0)
      break;
    switch (Name[2]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+3, "xts", 3) != 0)
        break;
      return ARM::FPCXTS;	 // "fpcxts"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+3, "nst", 3) != 0)
        break;
      return ARM::FPINST;	 // "fpinst"
    }
    break;
  case 7:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 2 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+3, "xtns", 4) != 0)
          break;
        return ARM::FPCXTNS;	 // "fpcxtns"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+3, "nst2", 4) != 0)
          break;
        return ARM::FPINST2;	 // "fpinst2"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tstate", 6) != 0)
        break;
      return ARM::ITSTATE;	 // "itstate"
    }
    break;
  case 9:	 // 1 string to match.
    if (memcmp(Name.data()+0, "apsr_nzcv", 9) != 0)
      break;
    return ARM::APSR_NZCV;	 // "apsr_nzcv"
  case 10:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fpscr_nzcv", 10) != 0)
      break;
    return ARM::FPSCR_NZCV;	 // "fpscr_nzcv"
  case 12:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pscr_nzcvqc", 11) != 0)
        break;
      return ARM::FPSCR_NZCVQC;	 // "fpscr_nzcvqc"
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "a_auth_code", 11) != 0)
        break;
      return ARM::RA_AUTH_CODE;	 // "ra_auth_code"
    }
    break;
  }
  return ARM::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasV4TBit: return "armv4t";
  case Feature_HasV5TBit: return "armv5t";
  case Feature_HasV5TEBit: return "armv5te";
  case Feature_HasV6Bit: return "armv6";
  case Feature_HasV6MBit: return "armv6m or armv6t2";
  case Feature_HasV8MBaselineBit: return "armv8m.base";
  case Feature_HasV8MMainlineBit: return "armv8m.main";
  case Feature_HasV8_1MMainlineBit: return "armv8.1m.main";
  case Feature_HasMVEIntBit: return "mve";
  case Feature_HasMVEFloatBit: return "mve.fp";
  case Feature_HasCDEBit: return "cde";
  case Feature_HasFPRegsBit: return "fp registers";
  case Feature_HasFPRegs16Bit: return "16-bit fp registers";
  case Feature_HasNoFPRegs16Bit: return "16-bit fp registers";
  case Feature_HasFPRegs64Bit: return "64-bit fp registers";
  case Feature_HasFPRegsV8_1MBit: return "armv8.1m.main with FP or MVE";
  case Feature_HasV6T2Bit: return "armv6t2";
  case Feature_HasV6KBit: return "armv6k";
  case Feature_HasV7Bit: return "armv7";
  case Feature_HasV8Bit: return "armv8";
  case Feature_PreV8Bit: return "armv7 or earlier";
  case Feature_HasV8_1aBit: return "armv8.1a";
  case Feature_HasV8_2aBit: return "armv8.2a";
  case Feature_HasV8_3aBit: return "armv8.3a";
  case Feature_HasV8_4aBit: return "armv8.4a";
  case Feature_HasV8_5aBit: return "armv8.5a";
  case Feature_HasV8_6aBit: return "armv8.6a";
  case Feature_HasV8_7aBit: return "armv8.7a";
  case Feature_HasVFP2Bit: return "VFP2";
  case Feature_HasVFP3Bit: return "VFP3";
  case Feature_HasVFP4Bit: return "VFP4";
  case Feature_HasDPVFPBit: return "double precision VFP";
  case Feature_HasFPARMv8Bit: return "FPARMv8";
  case Feature_HasNEONBit: return "NEON";
  case Feature_HasSHA2Bit: return "sha2";
  case Feature_HasAESBit: return "aes";
  case Feature_HasCryptoBit: return "crypto";
  case Feature_HasDotProdBit: return "dotprod";
  case Feature_HasCRCBit: return "crc";
  case Feature_HasRASBit: return "ras";
  case Feature_HasLOBBit: return "lob";
  case Feature_HasPACBTIBit: return "pacbti";
  case Feature_HasFP16Bit: return "half-float conversions";
  case Feature_HasFullFP16Bit: return "full half-float";
  case Feature_HasFP16FMLBit: return "full half-float fml";
  case Feature_HasBF16Bit: return "BFloat16 floating point extension";
  case Feature_HasMatMulInt8Bit: return "8-bit integer matrix multiply";
  case Feature_HasDivideInThumbBit: return "divide in THUMB";
  case Feature_HasDivideInARMBit: return "divide in ARM";
  case Feature_HasDSPBit: return "dsp";
  case Feature_HasDBBit: return "data-barriers";
  case Feature_HasDFBBit: return "full-data-barrier";
  case Feature_HasV7ClrexBit: return "v7 clrex";
  case Feature_HasAcquireReleaseBit: return "acquire/release";
  case Feature_HasMPBit: return "mp-extensions";
  case Feature_HasVirtualizationBit: return "virtualization-extensions";
  case Feature_HasTrustZoneBit: return "TrustZone";
  case Feature_Has8MSecExtBit: return "ARMv8-M Security Extensions";
  case Feature_IsThumbBit: return "thumb";
  case Feature_IsThumb2Bit: return "thumb2";
  case Feature_IsMClassBit: return "armv*m";
  case Feature_IsNotMClassBit: return "!armv*m";
  case Feature_IsARMBit: return "arm-mode";
  case Feature_UseNaClTrapBit: return "NaCl";
  case Feature_UseNegativeImmediatesBit: return "NegativeImmediates";
  case Feature_HasSBBit: return "sb";
  case Feature_HasCLRBHBBit: return "clrbhb";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 3:	 // 4 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "fe", 2) != 0)
        break;
      Mnemonic = "rfeia";	 // "rfe"
      return;
    case 's':	 // 3 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (Mnemonic[2] != 'i')
          break;
        Mnemonic = "smc";	 // "smi"
        return;
      case 'r':	 // 1 string to match.
        if (Mnemonic[2] != 's')
          break;
        Mnemonic = "srsia";	 // "srs"
        return;
      case 'w':	 // 1 string to match.
        if (Mnemonic[2] != 'i')
          break;
        Mnemonic = "svc";	 // "swi"
        return;
      }
      break;
    }
    break;
  case 4:	 // 10 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 2 strings to match.
        if (Mnemonic[2] != 'd')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fldd"
            Mnemonic = "vldr";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "flds"
            Mnemonic = "vldr";
          return;
        }
        break;
      case 'm':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'r':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmrs"
              Mnemonic = "vmov";
            return;
          case 'x':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmrx"
              Mnemonic = "vmrs";
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (Mnemonic[3] != 'r')
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fmsr"
            Mnemonic = "vmov";
          return;
        case 'x':	 // 1 string to match.
          if (Mnemonic[3] != 'r')
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fmxr"
            Mnemonic = "vmsr";
          return;
        }
        break;
      case 's':	 // 2 strings to match.
        if (Mnemonic[2] != 't')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fstd"
            Mnemonic = "vstr";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fsts"
            Mnemonic = "vstr";
          return;
        }
        break;
      }
      break;
    case 'v':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "dm", 2) != 0)
          break;
        Mnemonic = "vldmia";	 // "vldm"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "tm", 2) != 0)
          break;
        Mnemonic = "vstmia";	 // "vstm"
        return;
      }
      break;
    }
    break;
  case 5:	 // 51 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 18 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "dd", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "faddd"
            Mnemonic = "vadd.f64";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fadds"
            Mnemonic = "vadd.f32";
          return;
        }
        break;
      case 'c':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'm':	 // 2 strings to match.
          if (Mnemonic[3] != 'p')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fcmpd"
              Mnemonic = "vcmp.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fcmps"
              Mnemonic = "vcmp.f32";
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (Mnemonic[3] != 'y')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fcpyd"
              Mnemonic = "vmov.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fcpys"
              Mnemonic = "vmov.f32";
            return;
          }
          break;
        }
        break;
      case 'd':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "iv", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fdivd"
            Mnemonic = "vdiv.f64";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fdivs"
            Mnemonic = "vdiv.f32";
          return;
        }
        break;
      case 'm':	 // 8 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 2 strings to match.
          if (Mnemonic[3] != 'c')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmacd"
              Mnemonic = "vmla.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmacs"
              Mnemonic = "vmla.f32";
            return;
          }
          break;
        case 'd':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "rr", 2) != 0)
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fmdrr"
            Mnemonic = "vmov";
          return;
        case 'r':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'd':	 // 2 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'd':	 // 1 string to match.
              if (Features.test(Feature_HasVFP2Bit))	 // "fmrdd"
                Mnemonic = "vmov";
              return;
            case 's':	 // 1 string to match.
              if (Features.test(Feature_HasVFP2Bit))	 // "fmrds"
                Mnemonic = "vmov";
              return;
            }
            break;
          case 'r':	 // 1 string to match.
            if (Mnemonic[4] != 'd')
              break;
            if (Features.test(Feature_HasVFP2Bit))	 // "fmrrd"
              Mnemonic = "vmov";
            return;
          }
          break;
        case 'u':	 // 2 strings to match.
          if (Mnemonic[3] != 'l')
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmuld"
              Mnemonic = "vmul.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "fmuls"
              Mnemonic = "vmul.f32";
            return;
          }
          break;
        }
        break;
      case 'n':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "eg", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fnegd"
            Mnemonic = "vneg.f64";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fnegs"
            Mnemonic = "vneg.f32";
          return;
        }
        break;
      }
      break;
    case 'l':	 // 3 strings to match.
      if (memcmp(Mnemonic.data()+1, "dm", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (Mnemonic[4] != 'a')
          break;
        Mnemonic = "ldmdb";	 // "ldmea"
        return;
      case 'f':	 // 1 string to match.
        if (Mnemonic[4] != 'd')
          break;
        Mnemonic = "ldm";	 // "ldmfd"
        return;
      case 'i':	 // 1 string to match.
        if (Mnemonic[4] != 'a')
          break;
        Mnemonic = "ldm";	 // "ldmia"
        return;
      }
      break;
    case 'r':	 // 4 strings to match.
      if (memcmp(Mnemonic.data()+1, "fe", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "rfedb";	 // "rfeea"
          return;
        case 'd':	 // 1 string to match.
          Mnemonic = "rfeib";	 // "rfeed"
          return;
        }
        break;
      case 'f':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "rfeda";	 // "rfefa"
          return;
        case 'd':	 // 1 string to match.
          Mnemonic = "rfeia";	 // "rfefd"
          return;
        }
        break;
      }
      break;
    case 's':	 // 7 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'r':	 // 4 strings to match.
        if (Mnemonic[2] != 's')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            Mnemonic = "srsia";	 // "srsea"
            return;
          case 'd':	 // 1 string to match.
            Mnemonic = "srsda";	 // "srsed"
            return;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            Mnemonic = "srsib";	 // "srsfa"
            return;
          case 'd':	 // 1 string to match.
            Mnemonic = "srsdb";	 // "srsfd"
            return;
          }
          break;
        }
        break;
      case 't':	 // 3 strings to match.
        if (Mnemonic[2] != 'm')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stm";	 // "stmea"
          return;
        case 'f':	 // 1 string to match.
          if (Mnemonic[4] != 'd')
            break;
          Mnemonic = "stmdb";	 // "stmfd"
          return;
        case 'i':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stm";	 // "stmia"
          return;
        }
        break;
      }
      break;
    case 'v':	 // 19 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 3 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "sq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vabsq"
            Mnemonic = "vabs";
          return;
        case 'd':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "dq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vaddq"
            Mnemonic = "vadd";
          return;
        case 'n':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "dq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vandq"
            Mnemonic = "vand";
          return;
        }
        break;
      case 'b':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "icq", 3) != 0)
          break;
        if (Features.test(Feature_HasNEONBit))	 // "vbicq"
          Mnemonic = "vbic";
        return;
      case 'c':	 // 3 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "qq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vceqq"
            Mnemonic = "vceq";
          return;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "eq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vcleq"
            Mnemonic = "vcle";
          return;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "tq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vcvtq"
            Mnemonic = "vcvt";
          return;
        }
        break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "orq", 3) != 0)
          break;
        if (Features.test(Feature_HasNEONBit))	 // "veorq"
          Mnemonic = "veor";
        return;
      case 'm':	 // 5 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "xq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmaxq"
            Mnemonic = "vmax";
          return;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "nq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vminq"
            Mnemonic = "vmin";
          return;
        case 'o':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "vq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmovq"
            Mnemonic = "vmov";
          return;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "lq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmulq"
            Mnemonic = "vmul";
          return;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "nq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmvnq"
            Mnemonic = "vmvn";
          return;
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "rrq", 3) != 0)
          break;
        if (Features.test(Feature_HasNEONBit))	 // "vorrq"
          Mnemonic = "vorr";
        return;
      case 's':	 // 4 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (Mnemonic[4] != 'q')
              break;
            if (Features.test(Feature_HasNEONBit))	 // "vshlq"
              Mnemonic = "vshl";
            return;
          case 'r':	 // 1 string to match.
            if (Mnemonic[4] != 'q')
              break;
            if (Features.test(Feature_HasNEONBit))	 // "vshrq"
              Mnemonic = "vshr";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "bq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vsubq"
            Mnemonic = "vsub";
          return;
        case 'w':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "pq", 2) != 0)
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vswpq"
            Mnemonic = "vswp";
          return;
        }
        break;
      case 'z':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ipq", 3) != 0)
          break;
        if (Features.test(Feature_HasNEONBit))	 // "vzipq"
          Mnemonic = "vzip";
        return;
      }
      break;
    }
    break;
  case 6:	 // 10 strings to match.
    if (Mnemonic[0] != 'f')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 's':	 // 4 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+3, "to", 2) != 0)
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fsitod"
            Mnemonic = "vcvt.f64.s32";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fsitos"
            Mnemonic = "vcvt.f32.s32";
          return;
        }
        break;
      case 'q':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+3, "rt", 2) != 0)
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fsqrtd"
            Mnemonic = "vsqrt";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "fsqrts"
            Mnemonic = "vsqrt";
          return;
        }
        break;
      }
      break;
    case 't':	 // 4 strings to match.
      if (Mnemonic[2] != 'o')
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 's':	 // 2 strings to match.
        if (Mnemonic[4] != 'i')
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "ftosid"
            Mnemonic = "vcvtr.s32.f64";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "ftosis"
            Mnemonic = "vcvtr.s32.f32";
          return;
        }
        break;
      case 'u':	 // 2 strings to match.
        if (Mnemonic[4] != 'i')
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "ftouid"
            Mnemonic = "vcvtr.u32.f64";
          return;
        case 's':	 // 1 string to match.
          if (Features.test(Feature_HasVFP2Bit))	 // "ftouis"
            Mnemonic = "vcvtr.u32.f32";
          return;
        }
        break;
      }
      break;
    case 'u':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+2, "ito", 3) != 0)
        break;
      switch (Mnemonic[5]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (Features.test(Feature_HasVFP2Bit))	 // "fuitod"
          Mnemonic = "vcvt.f64.u32";
        return;
      case 's':	 // 1 string to match.
        if (Features.test(Feature_HasVFP2Bit))	 // "fuitos"
          Mnemonic = "vcvt.f32.u32";
        return;
      }
      break;
    }
    break;
  case 7:	 // 9 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "dm", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, "ax", 2) != 0)
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fldmeax"
            Mnemonic = "fldmdbx";
          return;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, "dx", 2) != 0)
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fldmfdx"
            Mnemonic = "fldmiax";
          return;
        }
        break;
      case 's':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "tm", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, "ax", 2) != 0)
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fstmeax"
            Mnemonic = "fstmiax";
          return;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, "dx", 2) != 0)
            break;
          if (Features.test(Feature_HasVFP2Bit))	 // "fstmfdx"
            Mnemonic = "fstmdbx";
          return;
        }
        break;
      case 't':	 // 4 strings to match.
        if (Mnemonic[2] != 'o')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 's':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+4, "iz", 2) != 0)
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "ftosizd"
              Mnemonic = "vcvt.s32.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "ftosizs"
              Mnemonic = "vcvt.s32.f32";
            return;
          }
          break;
        case 'u':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+4, "iz", 2) != 0)
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "ftouizd"
              Mnemonic = "vcvt.u32.f64";
            return;
          case 's':	 // 1 string to match.
            if (Features.test(Feature_HasVFP2Bit))	 // "ftouizs"
              Mnemonic = "vcvt.u32.f32";
            return;
          }
          break;
        }
        break;
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ldrb.8", 6) != 0)
        break;
      Mnemonic = "vldrb.u8";	 // "vldrb.8"
      return;
    }
    break;
  case 8:	 // 13 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'q':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "subaddx", 7) != 0)
        break;
      Mnemonic = "qsax";	 // "qsubaddx"
      return;
    case 's':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ddsubx", 6) != 0)
          break;
        Mnemonic = "sasx";	 // "saddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ubaddx", 6) != 0)
          break;
        Mnemonic = "ssax";	 // "ssubaddx"
        return;
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ddsubx", 6) != 0)
          break;
        Mnemonic = "uasx";	 // "uaddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "ubaddx", 6) != 0)
          break;
        Mnemonic = "usax";	 // "usubaddx"
        return;
      }
      break;
    case 'v':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 6 strings to match.
        if (memcmp(Mnemonic.data()+2, "dr", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'b':	 // 3 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case '.':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, "s8", 2) != 0)
              break;
            Mnemonic = "vldrb.u8";	 // "vldrb.s8"
            return;
          case 'e':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".8", 2) != 0)
              break;
            Mnemonic = "vldrbe.u8";	 // "vldrbe.8"
            return;
          case 't':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".8", 2) != 0)
              break;
            Mnemonic = "vldrbt.u8";	 // "vldrbt.8"
            return;
          }
          break;
        case 'd':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".64", 3) != 0)
            break;
          Mnemonic = "vldrd.u64";	 // "vldrd.64"
          return;
        case 'h':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".16", 3) != 0)
            break;
          Mnemonic = "vldrh.u16";	 // "vldrh.16"
          return;
        case 'w':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".32", 3) != 0)
            break;
          Mnemonic = "vldrw.u32";	 // "vldrw.32"
          return;
        }
        break;
      case 's':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "trb.", 4) != 0)
          break;
        switch (Mnemonic[6]) {
        default: break;
        case 's':	 // 1 string to match.
          if (Mnemonic[7] != '8')
            break;
          Mnemonic = "vstrb.8";	 // "vstrb.s8"
          return;
        case 'u':	 // 1 string to match.
          if (Mnemonic[7] != '8')
            break;
          Mnemonic = "vstrb.8";	 // "vstrb.u8"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 9:	 // 35 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 's':	 // 2 strings to match.
      if (Mnemonic[1] != 'h')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
          break;
        Mnemonic = "shasx";	 // "shaddsubx"
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
          break;
        Mnemonic = "shsax";	 // "shsubaddx"
        return;
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'h':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
            break;
          Mnemonic = "uhasx";	 // "uhaddsubx"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
            break;
          Mnemonic = "uhsax";	 // "uhsubaddx"
          return;
        }
        break;
      case 'q':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ddsubx", 6) != 0)
            break;
          Mnemonic = "uqasx";	 // "uqaddsubx"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "ubaddx", 6) != 0)
            break;
          Mnemonic = "uqsax";	 // "uqsubaddx"
          return;
        }
        break;
      }
      break;
    case 'v':	 // 29 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 14 strings to match.
        if (memcmp(Mnemonic.data()+2, "dr", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'b':	 // 2 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".s8", 3) != 0)
              break;
            Mnemonic = "vldrbe.u8";	 // "vldrbe.s8"
            return;
          case 't':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".s8", 3) != 0)
              break;
            Mnemonic = "vldrbt.u8";	 // "vldrbt.s8"
            return;
          }
          break;
        case 'd':	 // 4 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case '.':	 // 2 strings to match.
            switch (Mnemonic[6]) {
            default: break;
            case 'f':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "64", 2) != 0)
                break;
              Mnemonic = "vldrd.u64";	 // "vldrd.f64"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "64", 2) != 0)
                break;
              Mnemonic = "vldrd.u64";	 // "vldrd.s64"
              return;
            }
            break;
          case 'e':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".64", 3) != 0)
              break;
            Mnemonic = "vldrde.u64";	 // "vldrde.64"
            return;
          case 't':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".64", 3) != 0)
              break;
            Mnemonic = "vldrdt.u64";	 // "vldrdt.64"
            return;
          }
          break;
        case 'h':	 // 4 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case '.':	 // 2 strings to match.
            switch (Mnemonic[6]) {
            default: break;
            case 'f':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "16", 2) != 0)
                break;
              Mnemonic = "vldrh.u16";	 // "vldrh.f16"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "16", 2) != 0)
                break;
              Mnemonic = "vldrh.u16";	 // "vldrh.s16"
              return;
            }
            break;
          case 'e':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".16", 3) != 0)
              break;
            Mnemonic = "vldrhe.u16";	 // "vldrhe.16"
            return;
          case 't':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".16", 3) != 0)
              break;
            Mnemonic = "vldrht.u16";	 // "vldrht.16"
            return;
          }
          break;
        case 'w':	 // 4 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case '.':	 // 2 strings to match.
            switch (Mnemonic[6]) {
            default: break;
            case 'f':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "32", 2) != 0)
                break;
              Mnemonic = "vldrw.u32";	 // "vldrw.f32"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+7, "32", 2) != 0)
                break;
              Mnemonic = "vldrw.u32";	 // "vldrw.s32"
              return;
            }
            break;
          case 'e':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".32", 3) != 0)
              break;
            Mnemonic = "vldrwe.u32";	 // "vldrwe.32"
            return;
          case 't':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+6, ".32", 3) != 0)
              break;
            Mnemonic = "vldrwt.u32";	 // "vldrwt.32"
            return;
          }
          break;
        }
        break;
      case 'm':	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+2, "ovq.f", 5) != 0)
          break;
        switch (Mnemonic[7]) {
        default: break;
        case '3':	 // 1 string to match.
          if (Mnemonic[8] != '2')
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmovq.f32"
            Mnemonic = "vmov.f32";
          return;
        case '6':	 // 1 string to match.
          if (Mnemonic[8] != '4')
            break;
          if (Features.test(Feature_HasNEONBit))	 // "vmovq.f64"
            Mnemonic = "vmov.f64";
          return;
        }
        break;
      case 's':	 // 13 strings to match.
        if (memcmp(Mnemonic.data()+2, "tr", 2) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 'b':	 // 4 strings to match.
          switch (Mnemonic[5]) {
          default: break;
          case 'e':	 // 2 strings to match.
            if (Mnemonic[6] != '.')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 's':	 // 1 string to match.
              if (Mnemonic[8] != '8')
                break;
              Mnemonic = "vstrbe.8";	 // "vstrbe.s8"
              return;
            case 'u':	 // 1 string to match.
              if (Mnemonic[8] != '8')
                break;
              Mnemonic = "vstrbe.8";	 // "vstrbe.u8"
              return;
            }
            break;
          case 't':	 // 2 strings to match.
            if (Mnemonic[6] != '.')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 's':	 // 1 string to match.
              if (Mnemonic[8] != '8')
                break;
              Mnemonic = "vstrbt.8";	 // "vstrbt.s8"
              return;
            case 'u':	 // 1 string to match.
              if (Mnemonic[8] != '8')
                break;
              Mnemonic = "vstrbt.8";	 // "vstrbt.u8"
              return;
            }
            break;
          }
          break;
        case 'd':	 // 3 strings to match.
          if (Mnemonic[5] != '.')
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "64", 2) != 0)
              break;
            Mnemonic = "vstrd.64";	 // "vstrd.f64"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "64", 2) != 0)
              break;
            Mnemonic = "vstrd.64";	 // "vstrd.s64"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "64", 2) != 0)
              break;
            Mnemonic = "vstrd.64";	 // "vstrd.u64"
            return;
          }
          break;
        case 'h':	 // 3 strings to match.
          if (Mnemonic[5] != '.')
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "16", 2) != 0)
              break;
            Mnemonic = "vstrh.16";	 // "vstrh.f16"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "16", 2) != 0)
              break;
            Mnemonic = "vstrh.16";	 // "vstrh.s16"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "16", 2) != 0)
              break;
            Mnemonic = "vstrh.16";	 // "vstrh.u16"
            return;
          }
          break;
        case 'w':	 // 3 strings to match.
          if (Mnemonic[5] != '.')
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "32", 2) != 0)
              break;
            Mnemonic = "vstrw.32";	 // "vstrw.f32"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "32", 2) != 0)
              break;
            Mnemonic = "vstrw.32";	 // "vstrw.s32"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+7, "32", 2) != 0)
              break;
            Mnemonic = "vstrw.32";	 // "vstrw.u32"
            return;
          }
          break;
        }
        break;
      }
      break;
    }
    break;
  case 10:	 // 30 strings to match.
    if (Mnemonic[0] != 'v')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'l':	 // 12 strings to match.
      if (memcmp(Mnemonic.data()+2, "dr", 2) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'd':	 // 4 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vldrde.u64";	 // "vldrde.f64"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vldrde.u64";	 // "vldrde.s64"
            return;
          }
          break;
        case 't':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vldrdt.u64";	 // "vldrdt.f64"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vldrdt.u64";	 // "vldrdt.s64"
            return;
          }
          break;
        }
        break;
      case 'h':	 // 4 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vldrhe.u16";	 // "vldrhe.f16"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vldrhe.u16";	 // "vldrhe.s16"
            return;
          }
          break;
        case 't':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vldrht.u16";	 // "vldrht.f16"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vldrht.u16";	 // "vldrht.s16"
            return;
          }
          break;
        }
        break;
      case 'w':	 // 4 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vldrwe.u32";	 // "vldrwe.f32"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vldrwe.u32";	 // "vldrwe.s32"
            return;
          }
          break;
        case 't':	 // 2 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vldrwt.u32";	 // "vldrwt.f32"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vldrwt.u32";	 // "vldrwt.s32"
            return;
          }
          break;
        }
        break;
      }
      break;
    case 's':	 // 18 strings to match.
      if (memcmp(Mnemonic.data()+2, "tr", 2) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'd':	 // 6 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrde.64";	 // "vstrde.f64"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrde.64";	 // "vstrde.s64"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrde.64";	 // "vstrde.u64"
            return;
          }
          break;
        case 't':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrdt.64";	 // "vstrdt.f64"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrdt.64";	 // "vstrdt.s64"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "64", 2) != 0)
              break;
            Mnemonic = "vstrdt.64";	 // "vstrdt.u64"
            return;
          }
          break;
        }
        break;
      case 'h':	 // 6 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrhe.16";	 // "vstrhe.f16"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrhe.16";	 // "vstrhe.s16"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrhe.16";	 // "vstrhe.u16"
            return;
          }
          break;
        case 't':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrht.16";	 // "vstrht.f16"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrht.16";	 // "vstrht.s16"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "16", 2) != 0)
              break;
            Mnemonic = "vstrht.16";	 // "vstrht.u16"
            return;
          }
          break;
        }
        break;
      case 'w':	 // 6 strings to match.
        switch (Mnemonic[5]) {
        default: break;
        case 'e':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwe.32";	 // "vstrwe.f32"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwe.32";	 // "vstrwe.s32"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwe.32";	 // "vstrwe.u32"
            return;
          }
          break;
        case 't':	 // 3 strings to match.
          if (Mnemonic[6] != '.')
            break;
          switch (Mnemonic[7]) {
          default: break;
          case 'f':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwt.32";	 // "vstrwt.f32"
            return;
          case 's':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwt.32";	 // "vstrwt.s32"
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+8, "32", 2) != 0)
              break;
            Mnemonic = "vstrwt.32";	 // "vstrwt.u32"
            return;
          }
          break;
        }
        break;
      }
      break;
    }
    break;
  case 11:	 // 2 strings to match.
    if (memcmp(Mnemonic.data()+0, "vrecpeq.", 8) != 0)
      break;
    switch (Mnemonic[8]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+9, "32", 2) != 0)
        break;
      if (Features.test(Feature_HasNEONBit))	 // "vrecpeq.f32"
        Mnemonic = "vrecpe.f32";
      return;
    case 'u':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+9, "32", 2) != 0)
        break;
      if (Features.test(Feature_HasNEONBit))	 // "vrecpeq.u32"
        Mnemonic = "vrecpe.u32";
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_2_4,
  Tie0_3_3,
  Tie0_4_4,
  Tie0_4_5,
  Tie1_1_1,
  Tie1_2_2,
  Tie1_3_3,
  Tie1_4_4,
  Tie2_4_4,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_2_4 */ { 0, 2, 4 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_4_4 */ { 0, 4, 4 },
  /* Tie0_4_5 */ { 0, 4, 5 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie1_2_2 */ { 1, 2, 2 },
  /* Tie1_3_3 */ { 1, 3, 3 },
  /* Tie1_4_4 */ { 1, 4, 4 },
  /* Tie2_4_4 */ { 2, 4, 4 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_Reg,
  CVT_95_addCCOutOperands_95_defaultCCOutOp,
  CVT_95_addCondCodeOperands_95_defaultCondCodeOp,
  CVT_95_addRegShiftedImmOperands,
  CVT_95_addImmOperands,
  CVT_95_addT2SOImmNotOperands,
  CVT_95_addRegShiftedRegOperands,
  CVT_95_addModImmOperands,
  CVT_95_addModImmNotOperands,
  CVT_95_addImm0_95_508s4Operands,
  CVT_regSP,
  CVT_95_addImm0_95_508s4NegOperands,
  CVT_95_addThumbModImmNeg8_95_255Operands,
  CVT_95_addImm0_95_1020s4Operands,
  CVT_95_addThumbModImmNeg1_95_7Operands,
  CVT_95_addImm0_95_4095NegOperands,
  CVT_95_addT2SOImmNegOperands,
  CVT_95_addModImmNegOperands,
  CVT_95_addUnsignedOffset_95_b8s2Operands,
  CVT_95_addAdrLabelOperands,
  CVT_imm_95_45,
  CVT_cvtThumbBranches,
  CVT_95_addARMBranchTargetOperands,
  CVT_95_addBitfieldOperands,
  CVT_95_addITCondCodeOperands,
  CVT_imm_95_0,
  CVT_95_addThumbBranchTargetOperands,
  CVT_imm_95_15,
  CVT_95_addCoprocNumOperands,
  CVT_95_addCoprocRegOperands,
  CVT_95_addITCondCodeInvOperands,
  CVT_imm_95_22,
  CVT_95_addRegListWithAPSROperands,
  CVT_95_addProcIFlagsOperands,
  CVT_imm_95_20,
  CVT_regZR,
  CVT_imm_95_12,
  CVT_95_addMemBarrierOptOperands,
  CVT_imm_95_16,
  CVT_95_addFPImmOperands,
  CVT_95_addDPRRegListOperands,
  CVT_imm_95_1,
  CVT_95_addInstSyncBarrierOptOperands,
  CVT_95_addITMaskOperands,
  CVT_95_addMemNoOffsetOperands,
  CVT_95_addAddrMode5Operands,
  CVT_95_addCoprocOptionOperands,
  CVT_95_addPostIdxImm8s4Operands,
  CVT_95_addRegListOperands,
  CVT_95_addThumbMemPCOperands,
  CVT_95_addMemThumbRIs4Operands,
  CVT_95_addMemThumbRROperands,
  CVT_95_addMemThumbSPIOperands,
  CVT_95_addConstPoolAsmImmOperands,
  CVT_95_addMemImm12OffsetOperands,
  CVT_95_addMemImmOffsetOperands,
  CVT_95_addMemRegOffsetOperands,
  CVT_95_addMemUImm12OffsetOperands,
  CVT_95_addT2MemRegOffsetOperands,
  CVT_95_addMemPCRelImm12Operands,
  CVT_95_addAM2OffsetImmOperands,
  CVT_95_addPostIdxRegShiftedOperands,
  CVT_95_addMemThumbRIs1Operands,
  CVT_95_addMemImm8s4OffsetOperands,
  CVT_95_addAddrMode3Operands,
  CVT_95_addAM3OffsetOperands,
  CVT_95_addMemImm0_95_1020s4OffsetOperands,
  CVT_95_addMemThumbRIs2Operands,
  CVT_95_addPostIdxRegOperands,
  CVT_95_addPostIdxImm8Operands,
  CVT_reg0,
  CVT_regCPSR,
  CVT_imm_95_14,
  CVT_95_addBankedRegOperands,
  CVT_95_addMSRMaskOperands,
  CVT_cvtThumbMultiply,
  CVT_regR8,
  CVT_regR0,
  CVT_imm_95_29,
  CVT_imm_95_13,
  CVT_95_addPKHASRImmOperands,
  CVT_imm_95_4,
  CVT_95_addImm1_95_32Operands,
  CVT_imm_95_5,
  CVT_95_addMveSaturateOperands,
  CVT_95_addShifterImmOperands,
  CVT_95_addImm1_95_16Operands,
  CVT_95_addRotImmOperands,
  CVT_95_addMemTBBOperands,
  CVT_95_addMemTBHOperands,
  CVT_95_addTraceSyncBarrierOptOperands,
  CVT_95_addVPTPredNOperands_95_defaultVPTPredOp,
  CVT_95_addVPTPredROperands_95_defaultVPTPredOp,
  CVT_95_addNEONi16splatNotOperands,
  CVT_95_addNEONi32splatNotOperands,
  CVT_95_addNEONi16splatOperands,
  CVT_95_addNEONi32splatOperands,
  CVT_95_addComplexRotationOddOperands,
  CVT_95_addComplexRotationEvenOperands,
  CVT_95_addVectorIndex64Operands,
  CVT_95_addVectorIndex32Operands,
  CVT_95_addFBits16Operands,
  CVT_95_addFBits32Operands,
  CVT_95_addPowerTwoOperands,
  CVT_95_addVectorIndex16Operands,
  CVT_95_addVectorIndex8Operands,
  CVT_95_addVecListOperands,
  CVT_95_addDupAlignedMemory16Operands,
  CVT_95_addAlignedMemory64or128Operands,
  CVT_95_addAlignedMemory64or128or256Operands,
  CVT_95_addAlignedMemory64Operands,
  CVT_95_addVecListIndexedOperands,
  CVT_95_addAlignedMemory16Operands,
  CVT_95_addDupAlignedMemory32Operands,
  CVT_95_addAlignedMemory32Operands,
  CVT_95_addDupAlignedMemoryNoneOperands,
  CVT_95_addAlignedMemoryNoneOperands,
  CVT_95_addAlignedMemoryOperands,
  CVT_95_addDupAlignedMemory64Operands,
  CVT_95_addMVEVecListOperands,
  CVT_95_addMemNoOffsetT2Operands,
  CVT_95_addMemNoOffsetT2NoSpOperands,
  CVT_95_addDupAlignedMemory64or128Operands,
  CVT_95_addSPRRegListOperands,
  CVT_95_addMemImm7s4OffsetOperands,
  CVT_95_addAddrMode5FP16Operands,
  CVT_95_addImm7s4Operands,
  CVT_95_addMemRegRQOffsetOperands,
  CVT_95_addMemNoOffsetTOperands,
  CVT_95_addImm7Shift0Operands,
  CVT_95_addImm7Shift1Operands,
  CVT_95_addImm7Shift2Operands,
  CVT_95_addNEONi32vmovOperands,
  CVT_95_addNEONvmovi8ReplicateOperands,
  CVT_95_addNEONvmovi16ReplicateOperands,
  CVT_95_addNEONi32vmovNegOperands,
  CVT_95_addNEONvmovi32ReplicateOperands,
  CVT_95_addNEONi64splatOperands,
  CVT_95_addNEONi8splatOperands,
  CVT_95_addMVEVectorIndexOperands,
  CVT_95_addMVEPairVectorIndexOperands,
  CVT_cvtMVEVMOVQtoDReg,
  CVT_95_addNEONinvi8ReplicateOperands,
  CVT_95_addFPDRegListWithVPROperands,
  CVT_95_addFPSRegListWithVPROperands,
  CVT_imm_95_2,
  CVT_imm_95_3,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1,
  Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0,
  Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_255Expr1_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1,
  Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0,
  Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1,
  Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0,
  Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0,
  Convert__Reg1_1__Imm0_40951_3__CondCode2_0,
  Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0,
  Convert__Reg1_1__Imm1_2__CondCode2_0,
  Convert__Reg1_1__AdrLabel1_2__CondCode2_0,
  Convert__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2,
  Convert__Reg1_1__Reg1_2,
  Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1,
  Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0,
  Convert__imm_95_45__CondCode2_0,
  Convert__CondCode2_0__Reg1_1__Reg1_2__Reg1_3,
  ConvertCustom_cvtThumbBranches,
  Convert__ARMBranchTarget1_1__CondCode2_0,
  Convert__Imm1_1__Imm1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0,
  Convert__Imm1_0__Imm1_1__Imm1_2__CondCodeNoAL1_3,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0,
  Convert__Imm1_1__Reg1_2__CondCode2_0,
  Convert__imm_95_0,
  Convert__Imm0_2551_0,
  Convert__Imm0_655351_0,
  Convert__ARMBranchTarget1_0,
  Convert__CondCode2_0__ThumbBranchTarget1_1,
  Convert__CondCode2_0__ThumbBranchTarget1_2,
  Convert__CondCode2_0__Reg1_1,
  Convert__Reg1_0,
  Convert__ThumbBranchTarget1_0,
  Convert__Reg1_1__CondCode2_0,
  Convert__CondCode2_0__ARMBranchTarget1_1,
  Convert__imm_95_15__CondCode2_0,
  Convert__CondCode2_0,
  Convert__Reg1_0__ThumbBranchTarget1_1,
  Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__Reg1_0__Reg1_1__Reg1_1__CondCodeNoALInv1_2,
  Convert__imm_95_22__CondCode2_0,
  Convert__CondCode2_0__RegListWithAPSR1_1,
  Convert__Reg1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_1__ModImmNeg1_2__CondCode2_0,
  Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0,
  Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0,
  Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0,
  Convert__Reg1_1__ModImm1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0,
  Convert__Reg1_1__Imm0_2551_2__CondCode2_0,
  Convert__Imm1_0__ProcIFlags1_1,
  Convert__Imm0_311_0,
  Convert__Imm0_311_1,
  Convert__Imm1_0__ProcIFlags1_2,
  Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2,
  Convert__Imm1_0__ProcIFlags1_1__Imm1_2,
  Convert__Imm1_0__ProcIFlags1_2__Imm1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__imm_95_20__CondCode2_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3,
  Convert__Reg1_0__regZR__regZR__CondCodeNoALInv1_1,
  Convert__Reg1_1__CoprocNum1_0__Imm13b1_2,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm13b1_3__CondCode2_0,
  Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm9b1_3,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm9b1_4__CondCode2_0,
  Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm6b1_4,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm6b1_5__CondCode2_0,
  Convert__Imm0_151_1__CondCode2_0,
  Convert__Imm0_151_2__CondCode2_0,
  Convert__imm_95_12,
  Convert__imm_95_12__CondCode2_0,
  Convert__Reg1_0__Reg1_1,
  Convert__imm_95_15,
  Convert__MemBarrierOpt1_0,
  Convert__MemBarrierOpt1_1__CondCode2_0,
  Convert__MemBarrierOpt1_2__CondCode2_0,
  Convert__imm_95_0__CondCode2_0,
  Convert__imm_95_16__CondCode2_0,
  Convert__Reg1_1__FPImm1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3,
  Convert__Reg1_1__CondCode2_0__DPRRegList1_2,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Imm0_2391_1__CondCode2_0,
  Convert__Imm0_2391_2__CondCode2_0,
  Convert__Imm0_631_0,
  Convert__Imm0_655351_1,
  Convert__InstSyncBarrierOpt1_0,
  Convert__InstSyncBarrierOpt1_1__CondCode2_0,
  Convert__InstSyncBarrierOpt1_2__CondCode2_0,
  Convert__ITCondCode1_1__ITMask1_0,
  Convert__Reg1_1__MemNoOffset1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0,
  Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0,
  Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2,
  Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3,
  Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3,
  Convert__Reg1_1__CondCode2_0__RegList1_2,
  Convert__Reg1_1__CondCode2_0__RegList1_3,
  Convert__Reg1_2__CondCode2_0__RegList1_3,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3,
  Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4,
  Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRR2_2__CondCode2_0,
  Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0,
  Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0,
  Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0,
  Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0,
  Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0,
  Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0,
  Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0,
  Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0,
  Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0,
  Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0,
  Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0,
  Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0,
  Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0,
  Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0,
  Convert__Reg1_1__AddrMode33_2__CondCode2_0,
  Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0,
  Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0,
  Convert__LELabel1_0,
  Convert__imm_95_0__Reg1_0__LELabel1_1,
  Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1,
  Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1,
  Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0,
  Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0,
  Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0,
  Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0,
  Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4,
  Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__CCOut1_0__Imm0_255Expr1_3__CondCode2_1,
  Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0,
  Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0,
  Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0,
  Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0,
  Convert__Reg1_2__Reg1_3__CondCode2_0__reg0,
  Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_0__regCPSR__Imm0_255Expr1_1__imm_95_14__reg0,
  Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR,
  Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR,
  Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR,
  Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0,
  Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0,
  Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0,
  Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0,
  Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5,
  Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4,
  Convert__Reg1_1__BankedReg1_2__CondCode2_0,
  Convert__Reg1_1__MSRMask1_2__CondCode2_0,
  Convert__BankedReg1_1__Reg1_2__CondCode2_0,
  Convert__MSRMask1_1__Reg1_2__CondCode2_0,
  Convert__MSRMask1_1__ModImm1_2__CondCode2_0,
  ConvertCustom_cvtThumbMultiply,
  Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1,
  Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0,
  Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0,
  Convert__regR8__regR8__imm_95_14__reg0,
  Convert__regR0__regR0__CondCode2_0__reg0,
  Convert__imm_95_29__CondCode2_0,
  Convert__imm_95_13__CondCode2_0,
  Convert__Reg1_1__CondCode2_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0,
  Convert__MemImm12Offset2_0,
  Convert__MemRegOffset3_0,
  Convert__Imm1_1__CondCode2_0,
  Convert__MemNegImm8Offset2_1__CondCode2_0,
  Convert__MemUImm12Offset2_1__CondCode2_0,
  Convert__T2MemRegOffset3_1__CondCode2_0,
  Convert__MemPCRelImm121_1__CondCode2_0,
  Convert__Imm1_2__CondCode2_0,
  Convert__MemNegImm8Offset2_2__CondCode2_0,
  Convert__MemUImm12Offset2_2__CondCode2_0,
  Convert__T2MemRegOffset3_2__CondCode2_0,
  Convert__MemPCRelImm121_2__CondCode2_0,
  Convert__CondCode2_0__RegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2,
  Convert__imm_95_4__imm_95_14__reg0,
  Convert__imm_95_4,
  Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0,
  Convert__SetEndImm1_0,
  Convert__Imm0_11_0,
  Convert__imm_95_4__CondCode2_0,
  Convert__imm_95_5__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3,
  Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_4__MveSaturate1_3__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0,
  Convert__Imm0_311_2,
  Convert__Imm0_311_1__CondCode2_0,
  Convert__Imm0_311_2__CondCode2_0,
  Convert__Imm0_311_3__CondCode2_0,
  Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0,
  Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0,
  Convert__imm_95_0__imm_95_14__reg0,
  Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0,
  Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0,
  Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0,
  Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0,
  Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0,
  Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0,
  Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0,
  Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1,
  Convert__Imm0_2551_3__CondCode2_0,
  Convert__Imm0_2551_1__CondCode2_0,
  Convert__Imm24bit1_1__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0,
  Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0,
  Convert__MemTBB2_1__CondCode2_0,
  Convert__MemTBH2_1__CondCode2_0,
  Convert__TraceSyncBarrierOpt1_0,
  Convert__TraceSyncBarrierOpt1_1__CondCode2_0,
  Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0,
  Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0,
  Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0,
  Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__imm_95_0__VPTPredR4_0,
  Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0,
  Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0,
  Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0,
  Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0,
  Convert__Reg1_2__Tie0_3_3__NEONi16splatNot1_3__VPTPredN3_0,
  Convert__Reg1_2__Tie0_3_3__NEONi32splatNot1_3__VPTPredN3_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredR4_0,
  Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0,
  Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__NEONi16splat1_3__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__NEONi32splat1_3__VPTPredN3_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4,
  Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0,
  Convert__Reg1_2__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5,
  Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredN3_0,
  Convert__Reg1_2__CondCode2_0,
  Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0,
  Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0,
  Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0,
  Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredR4_0,
  Convert__imm_95_0__Reg1_2__VPTPredN3_0,
  Convert__Reg1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Reg1_4__VPTPredR4_0,
  Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0,
  Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0,
  Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0,
  Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_4__VPTPredN3_0,
  Convert__Reg1_1__CoprocNum1_0__Imm11b1_2,
  Convert__Reg1_2__CoprocNum1_1__Imm12b1_3__VPTPredR4_0,
  Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Imm11b1_2,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm12b1_3__VPTPredN3_0,
  Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm6b1_3,
  Convert__Reg1_2__CoprocNum1_1__Reg1_3__Imm7b1_4__VPTPredR4_0,
  Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Imm6b1_3,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm7b1_4__VPTPredN3_0,
  Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm3b1_4,
  Convert__Reg1_2__CoprocNum1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredR4_0,
  Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Reg1_3__Imm3b1_4,
  Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4,
  Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex161_4,
  Convert__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex161_4,
  Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex321_4,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0,
  Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0,
  Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0,
  Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0,
  Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0,
  Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2,
  Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3,
  Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0,
  Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0,
  Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0,
  Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0,
  Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0,
  Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0,
  Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2,
  Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3,
  Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3,
  Convert__Reg1_1__CondCode2_0__SPRRegList1_2,
  Convert__MemImm7s4Offset2_2__CondCode2_0,
  Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0,
  Convert__Reg1_1__AddrMode52_2__CondCode2_0,
  Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0,
  Convert__Reg1_2__AddrMode52_3__CondCode2_0,
  Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0,
  Convert__imm_95_0__imm_95_0__MemImm7s4Offset2_2__CondCode2_0,
  Convert__imm_95_0__MemNoOffsetT21_2__Tie1_3_3__Imm7s41_3__CondCode2_0,
  Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemImm7Shift0Offset2_3__VPTPredN3_0,
  Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__MemImm7Shift0OffsetWB2_3__VPTPredN3_0,
  Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0,
  Convert__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemRegRQS3Offset2_3__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemRegRQS1Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemImm7Shift1Offset2_3__VPTPredN3_0,
  Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__MemImm7Shift1OffsetWB2_3__VPTPredN3_0,
  Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0,
  Convert__Reg1_2__MemImm7Shift2Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0,
  Convert__Reg1_2__MemRegRQS2Offset2_3__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__MemImm7Shift2OffsetWB2_3__VPTPredN3_0,
  Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift21_4__VPTPredN3_0,
  Convert__imm_95_0__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0,
  Convert__Reg1_1__CondCode2_0__imm_95_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__Reg1_5__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__Reg1_4__Reg1_5__VPTPredN3_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__VPTPredN3_0,
  Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Reg1_2__VPTPredR4_0,
  Convert__Reg1_2__FPImm1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0,
  Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi16splat1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64splat1_3__CondCode2_0,
  Convert__Reg1_2__NEONi8splat1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__VectorIndex321_3__CondCode2_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_3__VectorIndex321_2__CondCode2_0,
  Convert__Reg1_2__FPImm1_3__VPTPredR4_0,
  Convert__Reg1_2__NEONi16splat1_3__VPTPredR4_0,
  Convert__Reg1_2__NEONi32vmov1_3__VPTPredR4_0,
  Convert__Reg1_2__NEONi64splat1_3__VPTPredR4_0,
  Convert__Reg1_2__NEONi8splat1_3__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__MVEVectorIndex81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__MVEVectorIndex161_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex81_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex161_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex41_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__MVEVectorIndex41_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex321_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex161_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex81_3__CondCode2_0,
  Convert__Reg1_1__Tie0_2_4__Reg1_5__Reg1_6__MVEPairVectorIndex21_2__MVEPairVectorIndex01_4__CondCode2_0,
  ConvertCustom_cvtMVEVMOVQtoDReg,
  Convert__Reg1_1__imm_95_0__CondCode2_0,
  Convert__imm_95_0__Reg1_2__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0,
  Convert__Reg1_1__Reg1_2__VPTPredR4_0,
  Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0,
  Convert__imm_95_0__imm_95_0__VPTPredN3_0,
  Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1,
  Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2,
  Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2,
  Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredN3_0,
  Convert__ITMask1_0,
  Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2,
  Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2,
  Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2,
  Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2,
  Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__VPTPredN3_0,
  Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm0_151_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__Imm0_311_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__Imm0_71_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0,
  Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__ShrImm161_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__ShrImm321_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__ShrImm81_4__VPTPredR4_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0,
  Convert__CondCode2_0__FPDRegListWithVPR1_1,
  Convert__CondCode2_0__FPSRegListWithVPR1_1,
  Convert__Reg1_2__Reg1_1__Tie1_2_2__Tie0_3_3__MVELongShift1_3__VPTPredN3_0,
  Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm161_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm321_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Imm81_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__MVEShiftImm1_151_4__VPTPredR4_0,
  Convert__Reg1_2__Reg1_3__MVEShiftImm1_71_4__VPTPredR4_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_151_4__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_311_4__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_71_4__VPTPredN3_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__VPTPredN3_0,
  Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0,
  Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0,
  Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0,
  Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0,
  Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0,
  Convert__Reg1_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0,
  Convert__imm_95_0__Reg1_8__Imm1_9__Imm1_10__Reg1_3__Imm1_5__CondCode2_0,
  Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0,
  Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0,
  Convert__VecListTwoMQ1_1__MemNoOffsetT21_2,
  Convert__MemNoOffsetT2NoSp1_2__VecListTwoMQ1_1__Tie0_3_3,
  Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0,
  Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0,
  Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0,
  Convert__VecListFourMQ1_1__MemNoOffsetT21_2,
  Convert__MemNoOffsetT2NoSp1_2__VecListFourMQ1_1__Tie0_3_3,
  Convert__MemNoOffsetT21_2__imm_95_0__Tie0_3_3__Imm7s41_3__CondCode2_0,
  Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0,
  Convert__Reg1_2__VecListDPair1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListFourD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListOneD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__VecListThreeD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListDPair1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListFourD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListOneD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Tie0_1_1__VecListThreeD1_3__Reg1_4__CondCode2_0,
  Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0,
  Convert__imm_95_2__CondCode2_0,
  Convert__imm_95_3__CondCode2_0,
  Convert__Reg1_0__Reg1_1__WLSLabel1_2,
  Convert__Reg1_1__Reg1_2__WLSLabel1_3,
  Convert__imm_95_1__CondCode2_0,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][17] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addT2SOImmNotOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmNotOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addT2SOImmNotOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRegShiftedRegOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmNotOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addRegShiftedImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4NegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_255Expr1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Tied, Tie0_3_3, CVT_95_addThumbModImmNeg8_95_255Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addImm0_95_508s4NegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImm0_95_1020s4Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_addThumbModImmNeg1_95_7Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImm0_95_4095NegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addT2SOImmNegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addModImmNegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImm0_95_4095NegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_40951_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addT2SOImmNegOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addT2SOImmNegOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addModImmNegOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addT2SOImmNegOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addUnsignedOffset_95_b8s2Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__AdrLabel1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAdrLabelOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_2
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addT2SOImmNotOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addT2SOImmNotOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_45__CondCode2_0
  { CVT_imm_95_45, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // ConvertCustom_cvtThumbBranches
  { CVT_cvtThumbBranches, 0, CVT_Done },
  // Convert__ARMBranchTarget1_1__CondCode2_0
  { CVT_95_addARMBranchTargetOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm1_1__Imm1_2__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addBitfieldOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm1_0__Imm1_1__Imm1_2__CondCodeNoAL1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addITCondCodeOperands, 4, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addBitfieldOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm1_1__Reg1_2__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0
  { CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm0_2551_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_655351_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ARMBranchTarget1_0
  { CVT_95_addARMBranchTargetOperands, 1, CVT_Done },
  // Convert__CondCode2_0__ThumbBranchTarget1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addThumbBranchTargetOperands, 2, CVT_Done },
  // Convert__CondCode2_0__ThumbBranchTarget1_2
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addThumbBranchTargetOperands, 3, CVT_Done },
  // Convert__CondCode2_0__Reg1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__ThumbBranchTarget1_0
  { CVT_95_addThumbBranchTargetOperands, 1, CVT_Done },
  // Convert__Reg1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0__ARMBranchTarget1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addARMBranchTargetOperands, 2, CVT_Done },
  // Convert__imm_95_15__CondCode2_0
  { CVT_imm_95_15, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_0__ThumbBranchTarget1_1
  { CVT_95_Reg, 1, CVT_95_addThumbBranchTargetOperands, 2, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__CondCodeNoALInv1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addITCondCodeInvOperands, 3, CVT_Done },
  // Convert__imm_95_22__CondCode2_0
  { CVT_imm_95_22, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0__RegListWithAPSR1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListWithAPSROperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__ModImmNeg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addModImmNegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addT2SOImmNegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addRegShiftedImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addRegShiftedRegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__ModImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addModImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_2551_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_Done },
  // Convert__Imm0_311_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_311_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_1__Imm1_2
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm1_0__ProcIFlags1_2__Imm1_3
  { CVT_95_addImmOperands, 1, CVT_95_addProcIFlagsOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__imm_95_20__CondCode2_0
  { CVT_imm_95_20, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addITCondCodeOperands, 4, CVT_Done },
  // Convert__Reg1_0__regZR__regZR__CondCodeNoALInv1_1
  { CVT_95_Reg, 1, CVT_regZR, 0, CVT_regZR, 0, CVT_95_addITCondCodeInvOperands, 2, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Imm13b1_2
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm13b1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm9b1_3
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm9b1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm6b1_4
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm6b1_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_151_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_151_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_12
  { CVT_imm_95_12, 0, CVT_Done },
  // Convert__imm_95_12__CondCode2_0
  { CVT_imm_95_12, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__imm_95_15
  { CVT_imm_95_15, 0, CVT_Done },
  // Convert__MemBarrierOpt1_0
  { CVT_95_addMemBarrierOptOperands, 1, CVT_Done },
  // Convert__MemBarrierOpt1_1__CondCode2_0
  { CVT_95_addMemBarrierOptOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemBarrierOpt1_2__CondCode2_0
  { CVT_95_addMemBarrierOptOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_16__CondCode2_0
  { CVT_imm_95_16, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__FPImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addFPImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addDPRRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__DPRRegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addDPRRegListOperands, 3, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_2391_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_2391_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_631_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_655351_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__InstSyncBarrierOpt1_0
  { CVT_95_addInstSyncBarrierOptOperands, 1, CVT_Done },
  // Convert__InstSyncBarrierOpt1_1__CondCode2_0
  { CVT_95_addInstSyncBarrierOptOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__InstSyncBarrierOpt1_2__CondCode2_0
  { CVT_95_addInstSyncBarrierOptOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__ITCondCode1_1__ITMask1_0
  { CVT_95_addITCondCodeOperands, 2, CVT_95_addITMaskOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addAddrMode5Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addCoprocOptionOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addCoprocRegOperands, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addPostIdxImm8s4Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addAddrMode5Operands, 3, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addCoprocOptionOperands, 4, CVT_Done },
  // Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addCoprocRegOperands, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_95_addPostIdxImm8s4Operands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__RegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 3, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__RegList1_3
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_2__CondCode2_0__RegList1_3
  { CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 4, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 5, CVT_Done },
  // Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addThumbMemPCOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs4Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRR2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRROperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbSPIOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addConstPoolAsmImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImmOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemUImm12OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addT2MemRegOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemPCRelImm12Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addConstPoolAsmImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemUImm12OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addT2MemRegOffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemPCRelImm12Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemImmOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addAM2OffsetImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxRegShiftedOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs1Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImmOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_Tied, Tie2_4_4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemNoOffsetOperands, 4, CVT_Tied, Tie2_4_4, CVT_95_addAM3OffsetOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemImm0_95_1020s4OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemThumbRIs2Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__AddrMode33_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addAM3OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxRegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMemNoOffsetOperands, 3, CVT_Tied, Tie1_3_3, CVT_95_addPostIdxImm8Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__LELabel1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_0__LELabel1_1
  { CVT_imm_95_0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0
  { CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4
  { CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCoprocRegOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Imm0_255Expr1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0
  { CVT_95_Reg, 2, CVT_95_addT2SOImmNotOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addModImmNotOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addModImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addRegShiftedRegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0__reg0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_0__regCPSR__Imm0_255Expr1_1__imm_95_14__reg0
  { CVT_95_Reg, 1, CVT_regCPSR, 0, CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_regCPSR, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 5, CVT_95_addCoprocRegOperands, 6, CVT_95_addImmOperands, 7, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 4, CVT_95_addCoprocRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addCoprocRegOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addCoprocRegOperands, 5, CVT_Done },
  // Convert__Reg1_1__BankedReg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addBankedRegOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__MSRMask1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addMSRMaskOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__BankedReg1_1__Reg1_2__CondCode2_0
  { CVT_95_addBankedRegOperands, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MSRMask1_1__Reg1_2__CondCode2_0
  { CVT_95_addMSRMaskOperands, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MSRMask1_1__ModImm1_2__CondCode2_0
  { CVT_95_addMSRMaskOperands, 2, CVT_95_addModImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // ConvertCustom_cvtThumbMultiply
  { CVT_cvtThumbMultiply, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_addT2SOImmNotOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 4, CVT_95_addRegShiftedImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__regR8__regR8__imm_95_14__reg0
  { CVT_regR8, 0, CVT_regR8, 0, CVT_imm_95_14, 0, CVT_reg0, 0, CVT_Done },
  // Convert__regR0__regR0__CondCode2_0__reg0
  { CVT_regR0, 0, CVT_regR0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_reg0, 0, CVT_Done },
  // Convert__imm_95_29__CondCode2_0
  { CVT_imm_95_29, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_13__CondCode2_0
  { CVT_imm_95_13, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addPKHASRImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemImm12Offset2_0
  { CVT_95_addMemImm12OffsetOperands, 1, CVT_Done },
  // Convert__MemRegOffset3_0
  { CVT_95_addMemRegOffsetOperands, 1, CVT_Done },
  // Convert__Imm1_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNegImm8Offset2_1__CondCode2_0
  { CVT_95_addMemImmOffsetOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemUImm12Offset2_1__CondCode2_0
  { CVT_95_addMemUImm12OffsetOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__T2MemRegOffset3_1__CondCode2_0
  { CVT_95_addT2MemRegOffsetOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemPCRelImm121_1__CondCode2_0
  { CVT_95_addMemPCRelImm12Operands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm1_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNegImm8Offset2_2__CondCode2_0
  { CVT_95_addMemImmOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemUImm12Offset2_2__CondCode2_0
  { CVT_95_addMemUImm12OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__T2MemRegOffset3_2__CondCode2_0
  { CVT_95_addT2MemRegOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemPCRelImm121_2__CondCode2_0
  { CVT_95_addMemPCRelImm12Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0__RegList1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addRegListOperands, 3, CVT_Done },
  // Convert__imm_95_4__imm_95_14__reg0
  { CVT_imm_95_4, 0, CVT_imm_95_14, 0, CVT_reg0, 0, CVT_Done },
  // Convert__imm_95_4
  { CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addImm1_95_32Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__SetEndImm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm0_11_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__imm_95_4__CondCode2_0
  { CVT_imm_95_4, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_5__CondCode2_0
  { CVT_imm_95_5, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Tied, Tie0_3_3, CVT_Tied, Tie1_4_4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_4__MveSaturate1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_Reg, 5, CVT_95_addMveSaturateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_311_2
  { CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm0_311_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_311_2__CondCode2_0
  { CVT_95_addImmOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_311_3__CondCode2_0
  { CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_32Operands, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_32Operands, 3, CVT_95_Reg, 4, CVT_95_addShifterImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImm1_95_16Operands, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__imm_95_14__reg0
  { CVT_imm_95_0, 0, CVT_imm_95_14, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemNoOffsetOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemImmOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemImm12OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addAM2OffsetImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxRegShiftedOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addMemRegOffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm8s4OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAddrMode3Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addAM3OffsetOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemImm0_95_1020s4OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_95_addAddrMode3Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addAM3OffsetOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxImm8Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0
  { CVT_95_addMemNoOffsetOperands, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_95_addPostIdxRegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1
  { CVT_95_Reg, 3, CVT_95_addCCOutOperands_95_defaultCCOutOp, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 2, CVT_Done },
  // Convert__Imm0_2551_3__CondCode2_0
  { CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm0_2551_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Imm24bit1_1__CondCode2_0
  { CVT_95_addImmOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRotImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRotImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addRotImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemTBB2_1__CondCode2_0
  { CVT_95_addMemTBBOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemTBH2_1__CondCode2_0
  { CVT_95_addMemTBHOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__TraceSyncBarrierOpt1_0
  { CVT_95_addTraceSyncBarrierOptOperands, 1, CVT_Done },
  // Convert__TraceSyncBarrierOpt1_1__CondCode2_0
  { CVT_95_addTraceSyncBarrierOptOperands, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addShifterImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__imm_95_0__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_imm_95_0, 0, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_Reg, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatNotOperands, 4, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32splatNotOperands, 4, CVT_Tied, Tie0_3_3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__NEONi16splatNot1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addNEONi16splatNotOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__NEONi32splatNot1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addNEONi32splatNotOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredR4_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatOperands, 4, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32splatOperands, 4, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__NEONi16splat1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addNEONi16splatOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__NEONi32splat1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addNEONi32splatOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addComplexRotationOddOperands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addComplexRotationOddOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addComplexRotationEvenOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex64Operands, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addComplexRotationEvenOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__VPTPredR4_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_5, CVT_95_addFBits16Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_5, CVT_95_addFBits32Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_4__VPTPredN3_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Imm11b1_2
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Imm12b1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_95_addImmOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Imm11b1_2
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm12b1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm6b1_3
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Reg1_3__Imm7b1_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Imm6b1_3
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm7b1_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm3b1_4
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Reg1_3__Imm3b1_4
  { CVT_95_Reg, 2, CVT_95_addCoprocNumOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addCoprocNumOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie1_1_1, CVT_95_addPowerTwoOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex8Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie1_1_1, CVT_95_Reg, 5, CVT_95_addPowerTwoOperands, 6, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex161_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex161_4
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex321_4
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_addAlignedMemoryOperands, 9, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory16Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2
  { CVT_95_addMVEVecListOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemNoOffsetT2Operands, 3, CVT_Done },
  // Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3
  { CVT_95_addMVEVecListOperands, 2, CVT_95_addMemNoOffsetT2NoSpOperands, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemoryNoneOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addImmOperands, 9, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_addAlignedMemoryOperands, 14, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_imm_95_0, 0, CVT_95_addDupAlignedMemory64Operands, 14, CVT_95_addImmOperands, 15, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListIndexedOperands, 3, CVT_95_addAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0
  { CVT_95_addVecListOperands, 3, CVT_95_addDupAlignedMemory32Operands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_Reg, 13, CVT_95_addAlignedMemoryOperands, 17, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0
  { CVT_95_Reg, 4, CVT_95_Reg, 7, CVT_95_Reg, 10, CVT_95_Reg, 13, CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 17, CVT_95_addImmOperands, 18, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2
  { CVT_95_addMVEVecListOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemNoOffsetT2Operands, 3, CVT_Done },
  // Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3
  { CVT_95_addMVEVecListOperands, 2, CVT_95_addMemNoOffsetT2NoSpOperands, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addSPRRegListOperands, 4, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__SPRRegList1_2
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addSPRRegListOperands, 3, CVT_Done },
  // Convert__MemImm7s4Offset2_2__CondCode2_0
  { CVT_95_addMemImm7s4OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addMemImm7s4OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__AddrMode52_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_addAddrMode5Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addAddrMode5FP16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__AddrMode52_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addAddrMode5Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0
  { CVT_95_addMemNoOffsetT2Operands, 3, CVT_Tied, Tie0_3_3, CVT_95_addImm7s4Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__imm_95_0__MemImm7s4Offset2_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_imm_95_0, 0, CVT_95_addMemImm7s4OffsetOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__MemNoOffsetT21_2__Tie1_3_3__Imm7s41_3__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addMemNoOffsetT2Operands, 3, CVT_Tied, Tie1_3_3, CVT_95_addImm7s4Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemRegRQOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemImm7Shift0Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0
  { CVT_95_addMemNoOffsetTOperands, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImm7Shift0Operands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__MemImm7Shift0OffsetWB2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0
  { CVT_95_addMemNoOffsetT2NoSpOperands, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImm7Shift0Operands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegRQS3Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemRegRQOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegRQS1Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemRegRQOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemImm7Shift1Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0
  { CVT_95_addMemNoOffsetTOperands, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImm7Shift1Operands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__MemImm7Shift1OffsetWB2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0
  { CVT_95_addMemNoOffsetT2NoSpOperands, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImm7Shift1Operands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemImm7Shift2Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__MemRegRQS2Offset2_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_addMemRegRQOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__MemImm7Shift2OffsetWB2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift21_4__VPTPredN3_0
  { CVT_95_addMemNoOffsetT2NoSpOperands, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_4_4, CVT_95_addImm7Shift2Operands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addMemImmOffsetOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__CondCode2_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__Reg1_5__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__Reg1_4__Reg1_5__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_3_3, CVT_Tied, Tie1_4_4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_2__VPTPredR4_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__FPImm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addFPImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmov1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32vmovOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovi16Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi16ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmovNeg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32vmovNegOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi16Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi16ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64vmovi32Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONvmovi32ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi64splatOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi8splat1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONi8splatOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__VectorIndex321_3__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addVectorIndex32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_3__VectorIndex321_2__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__FPImm1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addFPImmOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16splat1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addNEONi16splatOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32vmov1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addNEONi32vmovOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64splat1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addNEONi64splatOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi8splat1_3__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_addNEONi8splatOperands, 4, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__MVEVectorIndex81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMVEVectorIndexOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__MVEVectorIndex161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMVEVectorIndexOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMVEVectorIndexOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex41_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMVEVectorIndexOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__MVEVectorIndex41_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMVEVectorIndexOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__MVEVectorIndex161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMVEVectorIndexOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__VectorIndex81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addVectorIndex8Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_4__Reg1_5__Reg1_6__MVEPairVectorIndex21_2__MVEPairVectorIndex01_4__CondCode2_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_4, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addMVEPairVectorIndexOperands, 3, CVT_95_addMVEPairVectorIndexOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // ConvertCustom_cvtMVEVMOVQtoDReg
  { CVT_cvtMVEVMOVQtoDReg, 0, CVT_Done },
  // Convert__Reg1_1__imm_95_0__CondCode2_0
  { CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex32Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVectorIndex16Operands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex32Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addVectorIndex16Operands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__VPTPredR4_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi16invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi32invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__NEONi64invi8Replicate1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addNEONinvi8ReplicateOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__imm_95_0__VPTPredN3_0
  { CVT_imm_95_0, 0, CVT_imm_95_0, 0, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addDPRRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_1
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addSPRRegListOperands, 2, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__DPRRegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addDPRRegListOperands, 3, CVT_Done },
  // Convert__regSP__Tie0_1_1__CondCode2_0__SPRRegList1_2
  { CVT_regSP, 0, CVT_Tied, Tie0_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addSPRRegListOperands, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredN3_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__ITMask1_0
  { CVT_95_addITMaskOperands, 1, CVT_Done },
  // Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2
  { CVT_95_addITMaskOperands, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_Done },
  // Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2
  { CVT_95_addITMaskOperands, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_Done },
  // Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2
  { CVT_95_addITMaskOperands, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_Done },
  // Convert__ITMask1_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2
  { CVT_95_addITMaskOperands, 1, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addITCondCodeOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_151_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_311_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm0_71_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm641_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_2__ShrImm81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm641_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm161_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm321_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__ShrImm81_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm161_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm321_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm641_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__ShrImm81_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm641_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__CondCode2_0__FPDRegListWithVPR1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addFPDRegListWithVPROperands, 2, CVT_Done },
  // Convert__CondCode2_0__FPSRegListWithVPR1_1
  { CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_95_addFPSRegListWithVPROperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie1_2_2__Tie0_3_3__MVELongShift1_3__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie1_2_2, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 4, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_151_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm1_71_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm161_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm321_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Imm81_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__MVEShiftImm1_151_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__MVEShiftImm1_71_4__VPTPredR4_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredROperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_2__Imm1_3__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_151_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_311_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__Imm0_71_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_3__ShrImm321_4__VPTPredN3_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_95_addVPTPredNOperands_95_defaultVPTPredOp, 1, CVT_Done },
  // Convert__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory642_3__VecListOneD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0
  { CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPair1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPair1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or128or2562_3__VecListFourD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__VecListFourD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128or256Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__VecListOneD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListOneD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__VecListThreeD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory642_3__Reg1_4__VecListThreeD1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory2_8__Reg1_3__Imm1_5__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 9, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_8__Imm1_9__Reg1_3__Imm1_5__CondCode2_0
  { CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__Reg1_8__Imm1_9__Imm1_10__Reg1_3__Imm1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_Reg, 9, CVT_95_addImmOperands, 10, CVT_95_addImmOperands, 11, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0
  { CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__VecListDPairSpaced1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory64or1282_3__Reg1_4__VecListDPairSpaced1_2__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemory64or128Operands, 4, CVT_95_Reg, 5, CVT_95_addVecListOperands, 3, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListTwoMQ1_1__MemNoOffsetT21_2
  { CVT_95_addMVEVecListOperands, 2, CVT_95_addMemNoOffsetT2Operands, 3, CVT_Done },
  // Convert__MemNoOffsetT2NoSp1_2__VecListTwoMQ1_1__Tie0_3_3
  { CVT_95_addMemNoOffsetT2NoSpOperands, 3, CVT_95_addMVEVecListOperands, 2, CVT_Tied, Tie0_3_3, CVT_Done },
  // Convert__AlignedMemory2_7__Reg1_3__Reg1_4__Reg1_5__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 8, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_7__Imm1_8__Reg1_3__Reg1_4__Reg1_5__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 8, CVT_95_addImmOperands, 9, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__AlignedMemory2_8__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0
  { CVT_95_addAlignedMemoryOperands, 9, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_0__AlignedMemory2_8__Imm1_9__Reg1_3__Reg1_4__Reg1_5__Reg1_6__CondCode2_0
  { CVT_imm_95_0, 0, CVT_95_addAlignedMemoryOperands, 9, CVT_95_addImmOperands, 10, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__VecListFourMQ1_1__MemNoOffsetT21_2
  { CVT_95_addMVEVecListOperands, 2, CVT_95_addMemNoOffsetT2Operands, 3, CVT_Done },
  // Convert__MemNoOffsetT2NoSp1_2__VecListFourMQ1_1__Tie0_3_3
  { CVT_95_addMemNoOffsetT2NoSpOperands, 3, CVT_95_addMVEVecListOperands, 2, CVT_Tied, Tie0_3_3, CVT_Done },
  // Convert__MemNoOffsetT21_2__imm_95_0__Tie0_3_3__Imm7s41_3__CondCode2_0
  { CVT_95_addMemNoOffsetT2Operands, 3, CVT_imm_95_0, 0, CVT_Tied, Tie0_3_3, CVT_95_addImm7s4Operands, 4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_3_3__Tie1_4_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_3_3, CVT_Tied, Tie1_4_4, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__VecListDPair1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__VecListFourD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__VecListOneD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__VecListThreeD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListDPair1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListFourD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListOneD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__VecListThreeD1_3__Reg1_4__CondCode2_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addVecListOperands, 4, CVT_95_Reg, 5, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__CondCode2_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_2__CondCode2_0
  { CVT_imm_95_2, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__imm_95_3__CondCode2_0
  { CVT_imm_95_3, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__WLSLabel1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_2__WLSLabel1_3
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__imm_95_1__CondCode2_0
  { CVT_imm_95_1, 0, CVT_95_addCondCodeOperands_95_defaultCondCodeOp, 1, CVT_Done },
};

void ARMAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands,
                const SmallBitVector &OptionalOperandsMask) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned DefaultsOffset[19] = { 0 };
  assert(OptionalOperandsMask.size() == 18);
  for (unsigned i = 0, NumDefaults = 0; i < 18; ++i) {
    DefaultsOffset[i + 1] = NumDefaults;
    NumDefaults += (OptionalOperandsMask[i] ? 1 : 0);
  }
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1) - DefaultsOffset[*(p + 1)];
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_Reg:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addCCOutOperands_95_defaultCCOutOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultCCOutOp()->addCCOutOperands(Inst, 1);
      } else {
        static_cast<ARMOperand &>(*Operands[OpIdx]).addCCOutOperands(Inst, 1);
      }
      break;
    case CVT_95_addCondCodeOperands_95_defaultCondCodeOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultCondCodeOp()->addCondCodeOperands(Inst, 2);
      } else {
        static_cast<ARMOperand &>(*Operands[OpIdx]).addCondCodeOperands(Inst, 2);
      }
      break;
    case CVT_95_addRegShiftedImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegShiftedImmOperands(Inst, 2);
      break;
    case CVT_95_addImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addT2SOImmNotOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addT2SOImmNotOperands(Inst, 1);
      break;
    case CVT_95_addRegShiftedRegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegShiftedRegOperands(Inst, 3);
      break;
    case CVT_95_addModImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addModImmOperands(Inst, 1);
      break;
    case CVT_95_addModImmNotOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addModImmNotOperands(Inst, 1);
      break;
    case CVT_95_addImm0_95_508s4Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm0_508s4Operands(Inst, 1);
      break;
    case CVT_regSP:
      Inst.addOperand(MCOperand::createReg(ARM::SP));
      break;
    case CVT_95_addImm0_95_508s4NegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm0_508s4NegOperands(Inst, 1);
      break;
    case CVT_95_addThumbModImmNeg8_95_255Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addThumbModImmNeg8_255Operands(Inst, 1);
      break;
    case CVT_95_addImm0_95_1020s4Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm0_1020s4Operands(Inst, 1);
      break;
    case CVT_95_addThumbModImmNeg1_95_7Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addThumbModImmNeg1_7Operands(Inst, 1);
      break;
    case CVT_95_addImm0_95_4095NegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm0_4095NegOperands(Inst, 1);
      break;
    case CVT_95_addT2SOImmNegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addT2SOImmNegOperands(Inst, 1);
      break;
    case CVT_95_addModImmNegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addModImmNegOperands(Inst, 1);
      break;
    case CVT_95_addUnsignedOffset_95_b8s2Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addUnsignedOffset_b8s2Operands(Inst, 1);
      break;
    case CVT_95_addAdrLabelOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAdrLabelOperands(Inst, 1);
      break;
    case CVT_imm_95_45:
      Inst.addOperand(MCOperand::createImm(45));
      break;
    case CVT_cvtThumbBranches:
      cvtThumbBranches(Inst, Operands);
      break;
    case CVT_95_addARMBranchTargetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addARMBranchTargetOperands(Inst, 1);
      break;
    case CVT_95_addBitfieldOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addBitfieldOperands(Inst, 1);
      break;
    case CVT_95_addITCondCodeOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addITCondCodeOperands(Inst, 1);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addThumbBranchTargetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addThumbBranchTargetOperands(Inst, 1);
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addCoprocNumOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addCoprocNumOperands(Inst, 1);
      break;
    case CVT_95_addCoprocRegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addCoprocRegOperands(Inst, 1);
      break;
    case CVT_95_addITCondCodeInvOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addITCondCodeInvOperands(Inst, 1);
      break;
    case CVT_imm_95_22:
      Inst.addOperand(MCOperand::createImm(22));
      break;
    case CVT_95_addRegListWithAPSROperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegListWithAPSROperands(Inst, 1);
      break;
    case CVT_95_addProcIFlagsOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addProcIFlagsOperands(Inst, 1);
      break;
    case CVT_imm_95_20:
      Inst.addOperand(MCOperand::createImm(20));
      break;
    case CVT_regZR:
      Inst.addOperand(MCOperand::createReg(ARM::ZR));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_95_addMemBarrierOptOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemBarrierOptOperands(Inst, 1);
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_95_addFPImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_95_addDPRRegListOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDPRRegListOperands(Inst, 1);
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_95_addInstSyncBarrierOptOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addInstSyncBarrierOptOperands(Inst, 1);
      break;
    case CVT_95_addITMaskOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addITMaskOperands(Inst, 1);
      break;
    case CVT_95_addMemNoOffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemNoOffsetOperands(Inst, 1);
      break;
    case CVT_95_addAddrMode5Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAddrMode5Operands(Inst, 2);
      break;
    case CVT_95_addCoprocOptionOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addCoprocOptionOperands(Inst, 1);
      break;
    case CVT_95_addPostIdxImm8s4Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPostIdxImm8s4Operands(Inst, 1);
      break;
    case CVT_95_addRegListOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRegListOperands(Inst, 1);
      break;
    case CVT_95_addThumbMemPCOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addThumbMemPCOperands(Inst, 1);
      break;
    case CVT_95_addMemThumbRIs4Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemThumbRIs4Operands(Inst, 2);
      break;
    case CVT_95_addMemThumbRROperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemThumbRROperands(Inst, 2);
      break;
    case CVT_95_addMemThumbSPIOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemThumbSPIOperands(Inst, 2);
      break;
    case CVT_95_addConstPoolAsmImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addConstPoolAsmImmOperands(Inst, 1);
      break;
    case CVT_95_addMemImm12OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemImm12OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemImmOffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemImmOffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemRegOffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemRegOffsetOperands(Inst, 3);
      break;
    case CVT_95_addMemUImm12OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemUImm12OffsetOperands(Inst, 2);
      break;
    case CVT_95_addT2MemRegOffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addT2MemRegOffsetOperands(Inst, 3);
      break;
    case CVT_95_addMemPCRelImm12Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemPCRelImm12Operands(Inst, 1);
      break;
    case CVT_95_addAM2OffsetImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAM2OffsetImmOperands(Inst, 2);
      break;
    case CVT_95_addPostIdxRegShiftedOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPostIdxRegShiftedOperands(Inst, 2);
      break;
    case CVT_95_addMemThumbRIs1Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemThumbRIs1Operands(Inst, 2);
      break;
    case CVT_95_addMemImm8s4OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemImm8s4OffsetOperands(Inst, 2);
      break;
    case CVT_95_addAddrMode3Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAddrMode3Operands(Inst, 3);
      break;
    case CVT_95_addAM3OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAM3OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemImm0_95_1020s4OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemImm0_1020s4OffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemThumbRIs2Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemThumbRIs2Operands(Inst, 2);
      break;
    case CVT_95_addPostIdxRegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPostIdxRegOperands(Inst, 2);
      break;
    case CVT_95_addPostIdxImm8Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPostIdxImm8Operands(Inst, 1);
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_regCPSR:
      Inst.addOperand(MCOperand::createReg(ARM::CPSR));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_95_addBankedRegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addBankedRegOperands(Inst, 1);
      break;
    case CVT_95_addMSRMaskOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMSRMaskOperands(Inst, 1);
      break;
    case CVT_cvtThumbMultiply:
      cvtThumbMultiply(Inst, Operands);
      break;
    case CVT_regR8:
      Inst.addOperand(MCOperand::createReg(ARM::R8));
      break;
    case CVT_regR0:
      Inst.addOperand(MCOperand::createReg(ARM::R0));
      break;
    case CVT_imm_95_29:
      Inst.addOperand(MCOperand::createImm(29));
      break;
    case CVT_imm_95_13:
      Inst.addOperand(MCOperand::createImm(13));
      break;
    case CVT_95_addPKHASRImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPKHASRImmOperands(Inst, 1);
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_95_addImm1_95_32Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm1_32Operands(Inst, 1);
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_95_addMveSaturateOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMveSaturateOperands(Inst, 1);
      break;
    case CVT_95_addShifterImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addShifterImmOperands(Inst, 1);
      break;
    case CVT_95_addImm1_95_16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm1_16Operands(Inst, 1);
      break;
    case CVT_95_addRotImmOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addRotImmOperands(Inst, 1);
      break;
    case CVT_95_addMemTBBOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemTBBOperands(Inst, 2);
      break;
    case CVT_95_addMemTBHOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemTBHOperands(Inst, 2);
      break;
    case CVT_95_addTraceSyncBarrierOptOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addTraceSyncBarrierOptOperands(Inst, 1);
      break;
    case CVT_95_addVPTPredNOperands_95_defaultVPTPredOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultVPTPredOp()->addVPTPredNOperands(Inst, 3);
      } else {
        static_cast<ARMOperand &>(*Operands[OpIdx]).addVPTPredNOperands(Inst, 3);
      }
      break;
    case CVT_95_addVPTPredROperands_95_defaultVPTPredOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultVPTPredOp()->addVPTPredROperands(Inst, 4);
      } else {
        static_cast<ARMOperand &>(*Operands[OpIdx]).addVPTPredROperands(Inst, 4);
      }
      break;
    case CVT_95_addNEONi16splatNotOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi16splatNotOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32splatNotOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi32splatNotOperands(Inst, 1);
      break;
    case CVT_95_addNEONi16splatOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi16splatOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32splatOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi32splatOperands(Inst, 1);
      break;
    case CVT_95_addComplexRotationOddOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addComplexRotationOddOperands(Inst, 1);
      break;
    case CVT_95_addComplexRotationEvenOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addComplexRotationEvenOperands(Inst, 1);
      break;
    case CVT_95_addVectorIndex64Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVectorIndex64Operands(Inst, 1);
      break;
    case CVT_95_addVectorIndex32Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVectorIndex32Operands(Inst, 1);
      break;
    case CVT_95_addFBits16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addFBits16Operands(Inst, 1);
      break;
    case CVT_95_addFBits32Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addFBits32Operands(Inst, 1);
      break;
    case CVT_95_addPowerTwoOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addPowerTwoOperands(Inst, 1);
      break;
    case CVT_95_addVectorIndex16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVectorIndex16Operands(Inst, 1);
      break;
    case CVT_95_addVectorIndex8Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVectorIndex8Operands(Inst, 1);
      break;
    case CVT_95_addVecListOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVecListOperands(Inst, 1);
      break;
    case CVT_95_addDupAlignedMemory16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDupAlignedMemory16Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64or128Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemory64or128Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64or128or256Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemory64or128or256Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory64Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemory64Operands(Inst, 2);
      break;
    case CVT_95_addVecListIndexedOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addVecListIndexedOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemory16Operands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemory32Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDupAlignedMemory32Operands(Inst, 2);
      break;
    case CVT_95_addAlignedMemory32Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemory32Operands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemoryNoneOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDupAlignedMemoryNoneOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemoryNoneOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemoryNoneOperands(Inst, 2);
      break;
    case CVT_95_addAlignedMemoryOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAlignedMemoryOperands(Inst, 2);
      break;
    case CVT_95_addDupAlignedMemory64Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDupAlignedMemory64Operands(Inst, 2);
      break;
    case CVT_95_addMVEVecListOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMVEVecListOperands(Inst, 1);
      break;
    case CVT_95_addMemNoOffsetT2Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemNoOffsetT2Operands(Inst, 1);
      break;
    case CVT_95_addMemNoOffsetT2NoSpOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemNoOffsetT2NoSpOperands(Inst, 1);
      break;
    case CVT_95_addDupAlignedMemory64or128Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addDupAlignedMemory64or128Operands(Inst, 2);
      break;
    case CVT_95_addSPRRegListOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addSPRRegListOperands(Inst, 1);
      break;
    case CVT_95_addMemImm7s4OffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemImm7s4OffsetOperands(Inst, 2);
      break;
    case CVT_95_addAddrMode5FP16Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addAddrMode5FP16Operands(Inst, 2);
      break;
    case CVT_95_addImm7s4Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm7s4Operands(Inst, 1);
      break;
    case CVT_95_addMemRegRQOffsetOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemRegRQOffsetOperands(Inst, 2);
      break;
    case CVT_95_addMemNoOffsetTOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMemNoOffsetTOperands(Inst, 1);
      break;
    case CVT_95_addImm7Shift0Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm7Shift0Operands(Inst, 1);
      break;
    case CVT_95_addImm7Shift1Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm7Shift1Operands(Inst, 1);
      break;
    case CVT_95_addImm7Shift2Operands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addImm7Shift2Operands(Inst, 1);
      break;
    case CVT_95_addNEONi32vmovOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi32vmovOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi8ReplicateOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONvmovi8ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi16ReplicateOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONvmovi16ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONi32vmovNegOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi32vmovNegOperands(Inst, 1);
      break;
    case CVT_95_addNEONvmovi32ReplicateOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONvmovi32ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addNEONi64splatOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi64splatOperands(Inst, 1);
      break;
    case CVT_95_addNEONi8splatOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONi8splatOperands(Inst, 1);
      break;
    case CVT_95_addMVEVectorIndexOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMVEVectorIndexOperands(Inst, 1);
      break;
    case CVT_95_addMVEPairVectorIndexOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addMVEPairVectorIndexOperands(Inst, 1);
      break;
    case CVT_cvtMVEVMOVQtoDReg:
      cvtMVEVMOVQtoDReg(Inst, Operands);
      break;
    case CVT_95_addNEONinvi8ReplicateOperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addNEONinvi8ReplicateOperands(Inst, 1);
      break;
    case CVT_95_addFPDRegListWithVPROperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addFPDRegListWithVPROperands(Inst, 1);
      break;
    case CVT_95_addFPSRegListWithVPROperands:
      static_cast<ARMOperand &>(*Operands[OpIdx]).addFPSRegListWithVPROperands(Inst, 1);
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    }
  }
}

void ARMAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addCCOutOperands_95_defaultCCOutOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCondCodeOperands_95_defaultCondCodeOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addRegShiftedImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addT2SOImmNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegShiftedRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addModImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addModImmNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_508s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regSP:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addImm0_95_508s4NegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbModImmNeg8_95_255Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_1020s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbModImmNeg1_95_7Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm0_95_4095NegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addT2SOImmNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addModImmNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addUnsignedOffset_95_b8s2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAdrLabelOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_45:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addARMBranchTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBitfieldOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addITCondCodeOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addThumbBranchTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addCoprocNumOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCoprocRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addITCondCodeInvOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_22:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addRegListWithAPSROperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addProcIFlagsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_20:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regZR:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addMemBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDPRRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addInstSyncBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addITMaskOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemNoOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAddrMode5Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addCoprocOptionOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addPostIdxImm8s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addThumbMemPCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemThumbRIs4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRROperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbSPIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addConstPoolAsmImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemImm12OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImmOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemRegOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addMemUImm12OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addT2MemRegOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addMemPCRelImm12Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAM2OffsetImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxRegShiftedOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRIs1Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImm8s4OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAddrMode3Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addAM3OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemImm0_95_1020s4OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemThumbRIs2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addPostIdxImm8Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regCPSR:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addBankedRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMSRMaskOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regR8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regR0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_29:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_13:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addPKHASRImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImm1_95_32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addMveSaturateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addShifterImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm1_95_16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRotImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemTBBOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemTBHOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addTraceSyncBarrierOptOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVPTPredNOperands_95_defaultVPTPredOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addVPTPredROperands_95_defaultVPTPredOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 4;
      break;
    case CVT_95_addNEONi16splatNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32splatNotOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi16splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addComplexRotationOddOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addComplexRotationEvenOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFBits16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFBits32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addPowerTwoOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVectorIndex8Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addVecListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDupAlignedMemory16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64or128Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64or128or256Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addVecListIndexedOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemory32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemory32Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemoryNoneOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemoryNoneOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAlignedMemoryOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addDupAlignedMemory64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMVEVecListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemNoOffsetT2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemNoOffsetT2NoSpOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDupAlignedMemory64or128Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addSPRRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemImm7s4OffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addAddrMode5FP16Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addImm7s4Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemRegRQOffsetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMemNoOffsetTOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm7Shift0Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm7Shift1Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addImm7Shift2Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32vmovOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi8ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi16ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi32vmovNegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONvmovi32ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi64splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONi8splatOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMVEVectorIndexOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMVEPairVectorIndexOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addNEONinvi8ReplicateOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPDRegListWithVPROperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPSRegListWithVPROperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__DOT_d, // '.d'
  MCK__DOT_f, // '.f'
  MCK__DOT_s16, // '.s16'
  MCK__DOT_s32, // '.s32'
  MCK__DOT_s64, // '.s64'
  MCK__DOT_s8, // '.s8'
  MCK__DOT_u16, // '.u16'
  MCK__DOT_u32, // '.u32'
  MCK__DOT_u64, // '.u64'
  MCK__DOT_u8, // '.u8'
  MCK__DOT_f32, // '.f32'
  MCK__DOT_f64, // '.f64'
  MCK__DOT_i16, // '.i16'
  MCK__DOT_i32, // '.i32'
  MCK__DOT_i64, // '.i64'
  MCK__DOT_i8, // '.i8'
  MCK__DOT_p16, // '.p16'
  MCK__DOT_p8, // '.p8'
  MCK__EXCLAIM_, // '!'
  MCK__HASH_0, // '#0'
  MCK__HASH_16, // '#16'
  MCK__HASH_8, // '#8'
  MCK__DOT_16, // '.16'
  MCK__DOT_32, // '.32'
  MCK__DOT_64, // '.64'
  MCK__DOT_8, // '.8'
  MCK__DOT_bf16, // '.bf16'
  MCK__DOT_f16, // '.f16'
  MCK__DOT_p64, // '.p64'
  MCK__DOT_w, // '.w'
  MCK__91_, // '['
  MCK__93_, // ']'
  MCK__94_, // '^'
  MCK__123_, // '{'
  MCK__125_, // '}'
  MCK_LAST_TOKEN = MCK__125_,
  MCK_Reg107, // derived register class
  MCK_Reg91, // derived register class
  MCK_APSR, // register class 'APSR'
  MCK_APSR_NZCV, // register class 'APSR_NZCV'
  MCK_CCR, // register class 'CCR,CPSR'
  MCK_FPCXTRegs, // register class 'FPCXTRegs,FPCXTNS'
  MCK_FPCXTS, // register class 'FPCXTS'
  MCK_FPEXC, // register class 'FPEXC'
  MCK_FPINST, // register class 'FPINST'
  MCK_FPINST2, // register class 'FPINST2'
  MCK_FPSCR, // register class 'FPSCR'
  MCK_FPSCR_NZCVQC, // register class 'FPSCR_NZCVQC'
  MCK_FPSID, // register class 'FPSID'
  MCK_GPRlr, // register class 'GPRlr,LR'
  MCK_GPRsp, // register class 'GPRsp,SP'
  MCK_MVFR0, // register class 'MVFR0'
  MCK_MVFR1, // register class 'MVFR1'
  MCK_MVFR2, // register class 'MVFR2'
  MCK_P0, // register class 'P0'
  MCK_PC, // register class 'PC'
  MCK_R12, // register class 'R12'
  MCK_SPSR, // register class 'SPSR'
  MCK_VCCR, // register class 'VCCR,VPR'
  MCK_cl_FPSCR_NZCV, // register class 'cl_FPSCR_NZCV'
  MCK_Reg132, // derived register class
  MCK_Reg105, // derived register class
  MCK_Reg100, // derived register class
  MCK_Reg92, // derived register class
  MCK_Reg35, // derived register class
  MCK_Reg33, // derived register class
  MCK_Reg22, // derived register class
  MCK_Reg17, // derived register class
  MCK_Reg133, // derived register class
  MCK_Reg120, // derived register class
  MCK_Reg115, // derived register class
  MCK_Reg106, // derived register class
  MCK_Reg104, // derived register class
  MCK_Reg93, // derived register class
  MCK_Reg77, // derived register class
  MCK_Reg21, // derived register class
  MCK_Reg134, // derived register class
  MCK_Reg125, // derived register class
  MCK_Reg121, // derived register class
  MCK_Reg116, // derived register class
  MCK_Reg101, // derived register class
  MCK_Reg94, // derived register class
  MCK_Reg78, // derived register class
  MCK_Reg34, // derived register class
  MCK_Reg25, // derived register class
  MCK_Reg23, // derived register class
  MCK_Reg18, // derived register class
  MCK_QPR_8, // register class 'QPR_8'
  MCK_tcGPRnotr12, // register class 'tcGPRnotr12'
  MCK_Reg89, // derived register class
  MCK_Reg32, // derived register class
  MCK_Reg30, // derived register class
  MCK_MQQQQPR, // register class 'MQQQQPR'
  MCK_tcGPR, // register class 'tcGPR'
  MCK_Reg135, // derived register class
  MCK_Reg126, // derived register class
  MCK_Reg108, // derived register class
  MCK_Reg96, // derived register class
  MCK_Reg90, // derived register class
  MCK_Reg72, // derived register class
  MCK_Reg31, // derived register class
  MCK_Reg28, // derived register class
  MCK_Reg19, // derived register class
  MCK_GPRPairnosp, // register class 'GPRPairnosp'
  MCK_tGPROdd, // register class 'tGPROdd'
  MCK_Reg136, // derived register class
  MCK_Reg122, // derived register class
  MCK_Reg117, // derived register class
  MCK_Reg109, // derived register class
  MCK_Reg97, // derived register class
  MCK_Reg87, // derived register class
  MCK_Reg52, // derived register class
  MCK_Reg29, // derived register class
  MCK_Reg26, // derived register class
  MCK_GPRPair, // register class 'GPRPair'
  MCK_MQQPR, // register class 'MQQPR'
  MCK_Reg137, // derived register class
  MCK_Reg127, // derived register class
  MCK_Reg123, // derived register class
  MCK_Reg118, // derived register class
  MCK_Reg110, // derived register class
  MCK_Reg98, // derived register class
  MCK_Reg88, // derived register class
  MCK_Reg80, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg53, // derived register class
  MCK_DPR_8, // register class 'DPR_8'
  MCK_MQPR, // register class 'MQPR,QPR_VFP2'
  MCK_hGPR, // register class 'hGPR'
  MCK_tGPR, // register class 'tGPR'
  MCK_tGPREven, // register class 'tGPREven'
  MCK_tGPRwithpc, // register class 'tGPRwithpc'
  MCK_Reg128, // derived register class
  MCK_Reg2, // derived register class
  MCK_Reg85, // derived register class
  MCK_Reg14, // derived register class
  MCK_Reg12, // derived register class
  MCK_QQQQPR, // register class 'QQQQPR'
  MCK_Reg138, // derived register class
  MCK_Reg129, // derived register class
  MCK_Reg111, // derived register class
  MCK_Reg86, // derived register class
  MCK_Reg74, // derived register class
  MCK_GPRnoip, // register class 'GPRnoip'
  MCK_rGPR, // register class 'rGPR'
  MCK_Reg124, // derived register class
  MCK_Reg119, // derived register class
  MCK_Reg112, // derived register class
  MCK_Reg83, // derived register class
  MCK_Reg50, // derived register class
  MCK_GPRnopc, // register class 'GPRnopc'
  MCK_GPRnosp, // register class 'GPRnosp'
  MCK_GPRwithAPSR_NZCVnosp, // register class 'GPRwithAPSR_NZCVnosp'
  MCK_GPRwithAPSRnosp, // register class 'GPRwithAPSRnosp'
  MCK_GPRwithZRnosp, // register class 'GPRwithZRnosp'
  MCK_QQPR, // register class 'QQPR'
  MCK_Reg130, // derived register class
  MCK_Reg113, // derived register class
  MCK_Reg84, // derived register class
  MCK_Reg75, // derived register class
  MCK_Reg51, // derived register class
  MCK_DPR_VFP2, // register class 'DPR_VFP2'
  MCK_GPR, // register class 'GPR'
  MCK_GPRwithAPSR, // register class 'GPRwithAPSR'
  MCK_GPRwithZR, // register class 'GPRwithZR'
  MCK_QPR, // register class 'QPR'
  MCK_SPR_8, // register class 'SPR_8'
  MCK_DTripleSpc, // register class 'DTripleSpc,DQuadSpc'
  MCK_DQuad, // register class 'DQuad'
  MCK_DPairSpc, // register class 'DPairSpc'
  MCK_DTriple, // register class 'DTriple'
  MCK_DPair, // register class 'DPair'
  MCK_DPR, // register class 'DPR'
  MCK_HPR, // register class 'HPR,SPR'
  MCK_FPWithVPR, // register class 'FPWithVPR'
  MCK_LAST_REGISTER = MCK_FPWithVPR,
  MCK_AM2OffsetImm, // user defined class 'AM2OffsetImmAsmOperand'
  MCK_AM3Offset, // user defined class 'AM3OffsetAsmOperand'
  MCK_ARMBranchTarget, // user defined class 'ARMBranchTarget'
  MCK_AddrMode3, // user defined class 'AddrMode3AsmOperand'
  MCK_AddrMode5, // user defined class 'AddrMode5AsmOperand'
  MCK_AddrMode5FP16, // user defined class 'AddrMode5FP16AsmOperand'
  MCK_AlignedMemory16, // user defined class 'AddrMode6Align16AsmOperand'
  MCK_AlignedMemory32, // user defined class 'AddrMode6Align32AsmOperand'
  MCK_AlignedMemory64, // user defined class 'AddrMode6Align64AsmOperand'
  MCK_AlignedMemory64or128, // user defined class 'AddrMode6Align64or128AsmOperand'
  MCK_AlignedMemory64or128or256, // user defined class 'AddrMode6Align64or128or256AsmOperand'
  MCK_AlignedMemoryNone, // user defined class 'AddrMode6AlignNoneAsmOperand'
  MCK_AlignedMemory, // user defined class 'AddrMode6AsmOperand'
  MCK_DupAlignedMemory16, // user defined class 'AddrMode6dupAlign16AsmOperand'
  MCK_DupAlignedMemory32, // user defined class 'AddrMode6dupAlign32AsmOperand'
  MCK_DupAlignedMemory64, // user defined class 'AddrMode6dupAlign64AsmOperand'
  MCK_DupAlignedMemory64or128, // user defined class 'AddrMode6dupAlign64or128AsmOperand'
  MCK_DupAlignedMemoryNone, // user defined class 'AddrMode6dupAlignNoneAsmOperand'
  MCK_AdrLabel, // user defined class 'AdrLabelAsmOperand'
  MCK_BankedReg, // user defined class 'BankedRegOperand'
  MCK_Bitfield, // user defined class 'BitfieldAsmOperand'
  MCK_CCOut, // user defined class 'CCOutOperand'
  MCK_CondCode, // user defined class 'CondCodeOperand'
  MCK_CoprocNum, // user defined class 'CoprocNumAsmOperand'
  MCK_CoprocOption, // user defined class 'CoprocOptionAsmOperand'
  MCK_CoprocReg, // user defined class 'CoprocRegAsmOperand'
  MCK_DPRRegList, // user defined class 'DPRRegListAsmOperand'
  MCK_FPDRegListWithVPR, // user defined class 'FPDRegListWithVPRAsmOperand'
  MCK_FPImm, // user defined class 'FPImmOperand'
  MCK_FPSRegListWithVPR, // user defined class 'FPSRegListWithVPRAsmOperand'
  MCK_Imm0_15, // user defined class 'Imm0_15AsmOperand'
  MCK_Imm0_1, // user defined class 'Imm0_1AsmOperand'
  MCK_Imm0_239, // user defined class 'Imm0_239AsmOperand'
  MCK_Imm0_255, // user defined class 'Imm0_255AsmOperand'
  MCK_Imm0_255Expr, // user defined class 'Imm0_255ExprAsmOperand'
  MCK_Imm0_31, // user defined class 'Imm0_31AsmOperand'
  MCK_Imm0_32, // user defined class 'Imm0_32AsmOperand'
  MCK_Imm0_3, // user defined class 'Imm0_3AsmOperand'
  MCK_Imm0_63, // user defined class 'Imm0_63AsmOperand'
  MCK_Imm0_65535, // user defined class 'Imm0_65535AsmOperand'
  MCK_Imm0_65535Expr, // user defined class 'Imm0_65535ExprAsmOperand'
  MCK_Imm0_7, // user defined class 'Imm0_7AsmOperand'
  MCK_Imm16, // user defined class 'Imm16AsmOperand'
  MCK_Imm1_15, // user defined class 'Imm1_15AsmOperand'
  MCK_Imm1_16, // user defined class 'Imm1_16AsmOperand'
  MCK_Imm1_31, // user defined class 'Imm1_31AsmOperand'
  MCK_Imm1_32, // user defined class 'Imm1_32AsmOperand'
  MCK_Imm1_7, // user defined class 'Imm1_7AsmOperand'
  MCK_Imm24bit, // user defined class 'Imm24bitAsmOperand'
  MCK_Imm256_65535Expr, // user defined class 'Imm256_65535ExprAsmOperand'
  MCK_Imm32, // user defined class 'Imm32AsmOperand'
  MCK_Imm8, // user defined class 'Imm8AsmOperand'
  MCK_Imm8_255, // user defined class 'Imm8_255AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_InstSyncBarrierOpt, // user defined class 'InstSyncBarrierOptOperand'
  MCK_MSRMask, // user defined class 'MSRMaskOperand'
  MCK_MVEShiftImm1_15, // user defined class 'MVEShiftImm1_15AsmOperand'
  MCK_MVEShiftImm1_7, // user defined class 'MVEShiftImm1_7AsmOperand'
  MCK_VIDUP_imm, // user defined class 'MVE_VIDUP_imm_asmoperand'
  MCK_MemBarrierOpt, // user defined class 'MemBarrierOptOperand'
  MCK_MemImm0_1020s4Offset, // user defined class 'MemImm0_1020s4OffsetAsmOperand'
  MCK_MemImm12Offset, // user defined class 'MemImm12OffsetAsmOperand'
  MCK_MemImm7Shift0Offset, // user defined class 'MemImm7Shift0OffsetAsmOperand'
  MCK_MemImm7Shift0OffsetWB, // user defined class 'MemImm7Shift0OffsetWBAsmOperand'
  MCK_MemImm7Shift1Offset, // user defined class 'MemImm7Shift1OffsetAsmOperand'
  MCK_MemImm7Shift1OffsetWB, // user defined class 'MemImm7Shift1OffsetWBAsmOperand'
  MCK_MemImm7Shift2Offset, // user defined class 'MemImm7Shift2OffsetAsmOperand'
  MCK_MemImm7Shift2OffsetWB, // user defined class 'MemImm7Shift2OffsetWBAsmOperand'
  MCK_MemImm7s4Offset, // user defined class 'MemImm7s4OffsetAsmOperand'
  MCK_MemImm8Offset, // user defined class 'MemImm8OffsetAsmOperand'
  MCK_MemImm8s4Offset, // user defined class 'MemImm8s4OffsetAsmOperand'
  MCK_MemNegImm8Offset, // user defined class 'MemNegImm8OffsetAsmOperand'
  MCK_MemNoOffset, // user defined class 'MemNoOffsetAsmOperand'
  MCK_MemNoOffsetT2, // user defined class 'MemNoOffsetT2AsmOperand'
  MCK_MemNoOffsetT2NoSp, // user defined class 'MemNoOffsetT2NoSpAsmOperand'
  MCK_MemNoOffsetT, // user defined class 'MemNoOffsetTAsmOperand'
  MCK_MemPosImm8Offset, // user defined class 'MemPosImm8OffsetAsmOperand'
  MCK_MemRegOffset, // user defined class 'MemRegOffsetAsmOperand'
  MCK_MemRegQS2Offset, // user defined class 'MemRegQS2OffsetAsmOperand'
  MCK_MemRegQS3Offset, // user defined class 'MemRegQS3OffsetAsmOperand'
  MCK_MemRegRQS0Offset, // user defined class 'MemRegRQS0OffsetAsmOperand'
  MCK_MemRegRQS1Offset, // user defined class 'MemRegRQS1OffsetAsmOperand'
  MCK_MemRegRQS2Offset, // user defined class 'MemRegRQS2OffsetAsmOperand'
  MCK_MemRegRQS3Offset, // user defined class 'MemRegRQS3OffsetAsmOperand'
  MCK_ModImm, // user defined class 'ModImmAsmOperand'
  MCK_ModImmNeg, // user defined class 'ModImmNegAsmOperand'
  MCK_ModImmNot, // user defined class 'ModImmNotAsmOperand'
  MCK_MveSaturate, // user defined class 'MveSaturateOperand'
  MCK_PKHASRImm, // user defined class 'PKHASRAsmOperand'
  MCK_PKHLSLImm, // user defined class 'PKHLSLAsmOperand'
  MCK_PostIdxImm8, // user defined class 'PostIdxImm8AsmOperand'
  MCK_PostIdxImm8s4, // user defined class 'PostIdxImm8s4AsmOperand'
  MCK_PostIdxReg, // user defined class 'PostIdxRegAsmOperand'
  MCK_PostIdxRegShifted, // user defined class 'PostIdxRegShiftedAsmOperand'
  MCK_ProcIFlags, // user defined class 'ProcIFlagsOperand'
  MCK_RegList, // user defined class 'RegListAsmOperand'
  MCK_RegListWithAPSR, // user defined class 'RegListWithAPSRAsmOperand'
  MCK_RotImm, // user defined class 'RotImmAsmOperand'
  MCK_SPRRegList, // user defined class 'SPRRegListAsmOperand'
  MCK_SetEndImm, // user defined class 'SetEndAsmOperand'
  MCK_RegShiftedImm, // user defined class 'ShiftedImmAsmOperand'
  MCK_RegShiftedReg, // user defined class 'ShiftedRegAsmOperand'
  MCK_ShifterImm, // user defined class 'ShifterImmAsmOperand'
  MCK_ThumbBranchTarget, // user defined class 'ThumbBranchTarget'
  MCK_ThumbMemPC, // user defined class 'ThumbMemPC'
  MCK_ThumbModImmNeg1_7, // user defined class 'ThumbModImmNeg1_7AsmOperand'
  MCK_ThumbModImmNeg8_255, // user defined class 'ThumbModImmNeg8_255AsmOperand'
  MCK_ImmThumbSR, // user defined class 'ThumbSRImmAsmOperand'
  MCK_TraceSyncBarrierOpt, // user defined class 'TraceSyncBarrierOptOperand'
  MCK_UnsignedOffset_b8s2, // user defined class 'UnsignedOffset_b8s2'
  MCK_VPTPredN, // user defined class 'VPTPredNOperand'
  MCK_VPTPredR, // user defined class 'VPTPredROperand'
  MCK_VecListTwoMQ, // user defined class 'VecList2QAsmOperand'
  MCK_VecListFourMQ, // user defined class 'VecList4QAsmOperand'
  MCK_VecListDPairAllLanes, // user defined class 'VecListDPairAllLanesAsmOperand'
  MCK_VecListDPair, // user defined class 'VecListDPairAsmOperand'
  MCK_VecListDPairSpacedAllLanes, // user defined class 'VecListDPairSpacedAllLanesAsmOperand'
  MCK_VecListDPairSpaced, // user defined class 'VecListDPairSpacedAsmOperand'
  MCK_VecListFourDAllLanes, // user defined class 'VecListFourDAllLanesAsmOperand'
  MCK_VecListFourD, // user defined class 'VecListFourDAsmOperand'
  MCK_VecListFourDByteIndexed, // user defined class 'VecListFourDByteIndexAsmOperand'
  MCK_VecListFourDHWordIndexed, // user defined class 'VecListFourDHWordIndexAsmOperand'
  MCK_VecListFourDWordIndexed, // user defined class 'VecListFourDWordIndexAsmOperand'
  MCK_VecListFourQAllLanes, // user defined class 'VecListFourQAllLanesAsmOperand'
  MCK_VecListFourQ, // user defined class 'VecListFourQAsmOperand'
  MCK_VecListFourQHWordIndexed, // user defined class 'VecListFourQHWordIndexAsmOperand'
  MCK_VecListFourQWordIndexed, // user defined class 'VecListFourQWordIndexAsmOperand'
  MCK_VecListOneDAllLanes, // user defined class 'VecListOneDAllLanesAsmOperand'
  MCK_VecListOneD, // user defined class 'VecListOneDAsmOperand'
  MCK_VecListOneDByteIndexed, // user defined class 'VecListOneDByteIndexAsmOperand'
  MCK_VecListOneDHWordIndexed, // user defined class 'VecListOneDHWordIndexAsmOperand'
  MCK_VecListOneDWordIndexed, // user defined class 'VecListOneDWordIndexAsmOperand'
  MCK_VecListThreeDAllLanes, // user defined class 'VecListThreeDAllLanesAsmOperand'
  MCK_VecListThreeD, // user defined class 'VecListThreeDAsmOperand'
  MCK_VecListThreeDByteIndexed, // user defined class 'VecListThreeDByteIndexAsmOperand'
  MCK_VecListThreeDHWordIndexed, // user defined class 'VecListThreeDHWordIndexAsmOperand'
  MCK_VecListThreeDWordIndexed, // user defined class 'VecListThreeDWordIndexAsmOperand'
  MCK_VecListThreeQAllLanes, // user defined class 'VecListThreeQAllLanesAsmOperand'
  MCK_VecListThreeQ, // user defined class 'VecListThreeQAsmOperand'
  MCK_VecListThreeQHWordIndexed, // user defined class 'VecListThreeQHWordIndexAsmOperand'
  MCK_VecListThreeQWordIndexed, // user defined class 'VecListThreeQWordIndexAsmOperand'
  MCK_VecListTwoDByteIndexed, // user defined class 'VecListTwoDByteIndexAsmOperand'
  MCK_VecListTwoDHWordIndexed, // user defined class 'VecListTwoDHWordIndexAsmOperand'
  MCK_VecListTwoDWordIndexed, // user defined class 'VecListTwoDWordIndexAsmOperand'
  MCK_VecListTwoQHWordIndexed, // user defined class 'VecListTwoQHWordIndexAsmOperand'
  MCK_VecListTwoQWordIndexed, // user defined class 'VecListTwoQWordIndexAsmOperand'
  MCK_VectorIndex16, // user defined class 'VectorIndex16Operand'
  MCK_VectorIndex32, // user defined class 'VectorIndex32Operand'
  MCK_VectorIndex64, // user defined class 'VectorIndex64Operand'
  MCK_VectorIndex8, // user defined class 'VectorIndex8Operand'
  MCK_MemTBB, // user defined class 'addrmode_tbb_asmoperand'
  MCK_MemTBH, // user defined class 'addrmode_tbh_asmoperand'
  MCK_MVEVectorIndex4, // user defined class 'anonymous_10969'
  MCK_MVEVectorIndex8, // user defined class 'anonymous_10971'
  MCK_MVEVectorIndex16, // user defined class 'anonymous_10973'
  MCK_MVEVcvtImm32, // user defined class 'anonymous_11733'
  MCK_MVEVcvtImm16, // user defined class 'anonymous_11735'
  MCK_TMemImm7Shift2Offset, // user defined class 'anonymous_11980'
  MCK_TMemImm7Shift0Offset, // user defined class 'anonymous_12727'
  MCK_TMemImm7Shift1Offset, // user defined class 'anonymous_12730'
  MCK_Imm3b, // user defined class 'anonymous_13262'
  MCK_Imm4b, // user defined class 'anonymous_13263'
  MCK_Imm6b, // user defined class 'anonymous_13264'
  MCK_Imm7b, // user defined class 'anonymous_13265'
  MCK_Imm9b, // user defined class 'anonymous_13266'
  MCK_Imm11b, // user defined class 'anonymous_13267'
  MCK_Imm12b, // user defined class 'anonymous_13268'
  MCK_Imm13b, // user defined class 'anonymous_13269'
  MCK_MVEPairVectorIndex0, // user defined class 'anonymous_8300'
  MCK_MVEPairVectorIndex2, // user defined class 'anonymous_8301'
  MCK_ComplexRotationEven, // user defined class 'anonymous_8310'
  MCK_ComplexRotationOdd, // user defined class 'anonymous_8311'
  MCK_NEONi16vmovi8Replicate, // user defined class 'anonymous_9655'
  MCK_NEONi16invi8Replicate, // user defined class 'anonymous_9657'
  MCK_NEONi32vmovi8Replicate, // user defined class 'anonymous_9660'
  MCK_NEONi32invi8Replicate, // user defined class 'anonymous_9662'
  MCK_NEONi64vmovi8Replicate, // user defined class 'anonymous_9669'
  MCK_NEONi64invi8Replicate, // user defined class 'anonymous_9671'
  MCK_NEONi32vmovi16Replicate, // user defined class 'anonymous_9682'
  MCK_NEONi64vmovi16Replicate, // user defined class 'anonymous_9685'
  MCK_NEONi64vmovi32Replicate, // user defined class 'anonymous_9692'
  MCK_ConstPoolAsmImm, // user defined class 'const_pool_asm_operand'
  MCK_FBits16, // user defined class 'fbits16_asm_operand'
  MCK_FBits32, // user defined class 'fbits32_asm_operand'
  MCK_Imm0_4095, // user defined class 'imm0_4095_asmoperand'
  MCK_Imm0_4095Neg, // user defined class 'imm0_4095_neg_asmoperand'
  MCK_ITMask, // user defined class 'it_mask_asmoperand'
  MCK_ITCondCode, // user defined class 'it_pred_asmoperand'
  MCK_LELabel, // user defined class 'lelabel_u11_asmoperand'
  MCK_MVELongShift, // user defined class 'mve_shift_imm'
  MCK_NEONi16splat, // user defined class 'nImmSplatI16AsmOperand'
  MCK_NEONi32splat, // user defined class 'nImmSplatI32AsmOperand'
  MCK_NEONi64splat, // user defined class 'nImmSplatI64AsmOperand'
  MCK_NEONi8splat, // user defined class 'nImmSplatI8AsmOperand'
  MCK_NEONi16splatNot, // user defined class 'nImmSplatNotI16AsmOperand'
  MCK_NEONi32splatNot, // user defined class 'nImmSplatNotI32AsmOperand'
  MCK_NEONi32vmov, // user defined class 'nImmVMOVI32AsmOperand'
  MCK_NEONi32vmovNeg, // user defined class 'nImmVMOVI32NegAsmOperand'
  MCK_CondCodeNoAL, // user defined class 'pred_noal_asmoperand'
  MCK_CondCodeNoALInv, // user defined class 'pred_noal_inv_asmoperand'
  MCK_CondCodeRestrictedFP, // user defined class 'pred_restricted_fp_asmoperand'
  MCK_CondCodeRestrictedI, // user defined class 'pred_restricted_i_asmoperand'
  MCK_CondCodeRestrictedS, // user defined class 'pred_restricted_s_asmoperand'
  MCK_CondCodeRestrictedU, // user defined class 'pred_restricted_u_asmoperand'
  MCK_ShrImm16, // user defined class 'shr_imm16_asm_operand'
  MCK_ShrImm32, // user defined class 'shr_imm32_asm_operand'
  MCK_ShrImm64, // user defined class 'shr_imm64_asm_operand'
  MCK_ShrImm8, // user defined class 'shr_imm8_asm_operand'
  MCK_T2SOImm, // user defined class 't2_so_imm_asmoperand'
  MCK_T2SOImmNeg, // user defined class 't2_so_imm_neg_asmoperand'
  MCK_T2SOImmNot, // user defined class 't2_so_imm_not_asmoperand'
  MCK_MemUImm12Offset, // user defined class 't2addrmode_imm12_asmoperand'
  MCK_T2MemRegOffset, // user defined class 't2addrmode_so_reg_asmoperand'
  MCK_Imm7s4, // user defined class 't2am_imm7s4_offset_asmoperand'
  MCK_Imm7Shift0, // user defined class 't2am_imm7shift0OffsetAsmOperand'
  MCK_Imm7Shift1, // user defined class 't2am_imm7shift1OffsetAsmOperand'
  MCK_Imm7Shift2, // user defined class 't2am_imm7shift2OffsetAsmOperand'
  MCK_Imm8s4, // user defined class 't2am_imm8s4_offset_asmoperand'
  MCK_MemPCRelImm12, // user defined class 't2ldr_pcrel_imm12_asmoperand'
  MCK_MemThumbRIs1, // user defined class 't_addrmode_is1_asm_operand'
  MCK_MemThumbRIs2, // user defined class 't_addrmode_is2_asm_operand'
  MCK_MemThumbRIs4, // user defined class 't_addrmode_is4_asm_operand'
  MCK_MemThumbRR, // user defined class 't_addrmode_rr_asm_operand'
  MCK_MemThumbSPI, // user defined class 't_addrmode_sp_asm_operand'
  MCK_Imm0_1020s4, // user defined class 't_imm0_1020s4_asmoperand'
  MCK_Imm0_508s4, // user defined class 't_imm0_508s4_asmoperand'
  MCK_Imm0_508s4Neg, // user defined class 't_imm0_508s4_neg_asmoperand'
  MCK_WLSLabel, // user defined class 'wlslabel_u11_asmoperand'
  NumMatchClassKinds
};

} // end anonymous namespace

static const char *getMatchKindDiag(ARMAsmParser::ARMMatchResultTy MatchResult) {
  switch (MatchResult) {
  case ARMAsmParser::Match_GPRsp:
    return "operand must be a register sp";
  case ARMAsmParser::Match_QPR_8:
    return "operand must be a register in range [q0, q3]";
  case ARMAsmParser::Match_tGPROdd:
    return "operand must be an odd-numbered register in range [r1,r11]";
  case ARMAsmParser::Match_DPR_8:
    return "operand must be a register in range [d0, d7]";
  case ARMAsmParser::Match_QPR_VFP2:
    return "operand must be a register in range [q0, q7]";
  case ARMAsmParser::Match_hGPR:
    return "operand must be a register in range [r8, r15]";
  case ARMAsmParser::Match_tGPR:
    return "operand must be a register in range [r0, r7]";
  case ARMAsmParser::Match_tGPREven:
    return "operand must be an even-numbered register";
  case ARMAsmParser::Match_GPRnoip:
    return "operand must be a register in range [r0, r14]";
  case ARMAsmParser::Match_GPRnopc:
    return "operand must be a register in range [r0, r14]";
  case ARMAsmParser::Match_GPRnosp:
    return "operand must be a register in range [r0, r12] or LR or PC";
  case ARMAsmParser::Match_GPRwithAPSR_NZCVnosp:
    return "operand must be a register in the range [r0, r12], r14 or apsr_nzcv";
  case ARMAsmParser::Match_GPRwithZRnosp:
    return "operand must be a register in range [r0, r12] or r14 or zr";
  case ARMAsmParser::Match_DPR_VFP2:
    return "operand must be a register in range [d0, d15]";
  case ARMAsmParser::Match_GPR:
    return "operand must be a register in range [r0, r15]";
  case ARMAsmParser::Match_GPRwithAPSR:
    return "operand must be a register in range [r0, r14] or apsr_nzcv";
  case ARMAsmParser::Match_GPRwithZR:
    return "operand must be a register in range [r0, r14] or zr";
  case ARMAsmParser::Match_QPR:
    return "operand must be a register in range [q0, q15]";
  case ARMAsmParser::Match_SPR_8:
    return "operand must be a register in range [s0, s15]";
  case ARMAsmParser::Match_SPR:
    return "operand must be a register in range [s0, s31]";
  case ARMAsmParser::Match_AlignedMemory16:
    return "alignment must be 16 or omitted";
  case ARMAsmParser::Match_AlignedMemory32:
    return "alignment must be 32 or omitted";
  case ARMAsmParser::Match_AlignedMemory64:
    return "alignment must be 64 or omitted";
  case ARMAsmParser::Match_AlignedMemory64or128:
    return "alignment must be 64, 128 or omitted";
  case ARMAsmParser::Match_AlignedMemory64or128or256:
    return "alignment must be 64, 128, 256 or omitted";
  case ARMAsmParser::Match_AlignedMemoryNone:
    return "alignment must be omitted";
  case ARMAsmParser::Match_DupAlignedMemory16:
    return "alignment must be 16 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory32:
    return "alignment must be 32 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory64:
    return "alignment must be 64 or omitted";
  case ARMAsmParser::Match_DupAlignedMemory64or128:
    return "alignment must be 64, 128 or omitted";
  case ARMAsmParser::Match_DupAlignedMemoryNone:
    return "alignment must be omitted";
  case ARMAsmParser::Match_Imm0_15:
    return "operand must be an immediate in the range [0,15]";
  case ARMAsmParser::Match_Imm0_1:
    return "operand must be an immediate in the range [0,1]";
  case ARMAsmParser::Match_Imm0_239:
    return "operand must be an immediate in the range [0,239]";
  case ARMAsmParser::Match_Imm0_255:
    return "operand must be an immediate in the range [0,255]";
  case ARMAsmParser::Match_Imm0_255Expr:
    return "operand must be an immediate in the range [0,255] or a relocatable expression";
  case ARMAsmParser::Match_Imm0_31:
    return "operand must be an immediate in the range [0,31]";
  case ARMAsmParser::Match_Imm0_32:
    return "operand must be an immediate in the range [0,32]";
  case ARMAsmParser::Match_Imm0_3:
    return "operand must be an immediate in the range [0,3]";
  case ARMAsmParser::Match_Imm0_63:
    return "operand must be an immediate in the range [0,63]";
  case ARMAsmParser::Match_Imm0_65535:
    return "operand must be an immediate in the range [0,65535]";
  case ARMAsmParser::Match_Imm0_65535Expr:
    return "operand must be an immediate in the range [0,0xffff] or a relocatable expression";
  case ARMAsmParser::Match_Imm0_7:
    return "operand must be an immediate in the range [0,7]";
  case ARMAsmParser::Match_Imm16:
    return "operand must be an immediate in the range [16,16]";
  case ARMAsmParser::Match_Imm1_15:
    return "operand must be an immediate in the range [1,15]";
  case ARMAsmParser::Match_ImmRange1_16:
    return "operand must be an immediate in the range [1,16]";
  case ARMAsmParser::Match_Imm1_31:
    return "operand must be an immediate in the range [1,31]";
  case ARMAsmParser::Match_ImmRange1_32:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_Imm1_7:
    return "operand must be an immediate in the range [1,7]";
  case ARMAsmParser::Match_Imm24bit:
    return "operand must be an immediate in the range [0,0xffffff]";
  case ARMAsmParser::Match_Imm256_65535Expr:
    return "operand must be an immediate in the range [256,65535]";
  case ARMAsmParser::Match_Imm32:
    return "operand must be an immediate in the range [32,32]";
  case ARMAsmParser::Match_Imm8:
    return "operand must be an immediate in the range [8,8]";
  case ARMAsmParser::Match_Imm8_255:
    return "operand must be an immediate in the range [8,255]";
  case ARMAsmParser::Match_MVEShiftImm1_15:
    return "operand must be an immediate in the range [1,16]";
  case ARMAsmParser::Match_MVEShiftImm1_7:
    return "operand must be an immediate in the range [1,8]";
  case ARMAsmParser::Match_VIDUP_imm:
    return "vector increment immediate must be 1, 2, 4 or 8";
  case ARMAsmParser::Match_MveSaturate:
    return "saturate operand must be 48 or 64";
  case ARMAsmParser::Match_PKHLSLImm:
    return "operand must be an immediate in the range [0,31]";
  case ARMAsmParser::Match_SPRRegList:
    return "operand must be a list of registers in range [s0, s31]";
  case ARMAsmParser::Match_SetEndImm:
    return "operand must be an immediate in the range [0,1]";
  case ARMAsmParser::Match_ImmThumbSR:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_VecListTwoMQ:
    return "operand must be a list of two consecutive q-registers in range [q0,q7]";
  case ARMAsmParser::Match_VecListFourMQ:
    return "operand must be a list of four consecutive q-registers in range [q0,q7]";
  case ARMAsmParser::Match_MVEVcvtImm32:
    return "MVE fixed-point immediate operand must be between 1 and 32";
  case ARMAsmParser::Match_MVEVcvtImm16:
    return "MVE fixed-point immediate operand must be between 1 and 16";
  case ARMAsmParser::Match_Imm3b:
    return "operand must be an immediate in the range [0,7]";
  case ARMAsmParser::Match_Imm4b:
    return "operand must be an immediate in the range [0,15]";
  case ARMAsmParser::Match_Imm6b:
    return "operand must be an immediate in the range [0,63]";
  case ARMAsmParser::Match_Imm7b:
    return "operand must be an immediate in the range [0,127]";
  case ARMAsmParser::Match_Imm9b:
    return "operand must be an immediate in the range [0,511]";
  case ARMAsmParser::Match_Imm11b:
    return "operand must be an immediate in the range [0,2047]";
  case ARMAsmParser::Match_Imm12b:
    return "operand must be an immediate in the range [0,4095]";
  case ARMAsmParser::Match_Imm13b:
    return "operand must be an immediate in the range [0,8191]";
  case ARMAsmParser::Match_ComplexRotationEven:
    return "complex rotation must be 0, 90, 180 or 270";
  case ARMAsmParser::Match_ComplexRotationOdd:
    return "complex rotation must be 90 or 270";
  case ARMAsmParser::Match_Imm0_4095:
    return "operand must be an immediate in the range [0,4095]";
  case ARMAsmParser::Match_LELabel:
    return "loop start is out of range or not a negative multiple of 2";
  case ARMAsmParser::Match_MVELongShift:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_CondCodeRestrictedFP:
    return "condition code for floating-point comparison must be EQ, NE, LT, GT, LE or GE";
  case ARMAsmParser::Match_CondCodeRestrictedI:
    return "condition code for sign-independent integer comparison must be EQ or NE";
  case ARMAsmParser::Match_CondCodeRestrictedS:
    return "condition code for signed integer comparison must be EQ, NE, LT, GT, LE or GE";
  case ARMAsmParser::Match_CondCodeRestrictedU:
    return "condition code for unsigned integer comparison must be EQ, NE, HS or HI";
  case ARMAsmParser::Match_ShrImm16:
    return "operand must be an immediate in the range [1,16]";
  case ARMAsmParser::Match_ShrImm32:
    return "operand must be an immediate in the range [1,32]";
  case ARMAsmParser::Match_ShrImm64:
    return "operand must be an immediate in the range [1,64]";
  case ARMAsmParser::Match_ShrImm8:
    return "operand must be an immediate in the range [1,8]";
  case ARMAsmParser::Match_WLSLabel:
    return "loop end is out of range or not a positive multiple of 2";
  default:
    return nullptr;
  }
}

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  switch (RegisterClass) {
  case MCK_GPRsp:
    return ARMAsmParser::Match_GPRsp;
  case MCK_QPR_8:
    return ARMAsmParser::Match_QPR_8;
  case MCK_tGPROdd:
    return ARMAsmParser::Match_tGPROdd;
  case MCK_DPR_8:
    return ARMAsmParser::Match_DPR_8;
  case MCK_MQPR:
    return ARMAsmParser::Match_QPR_VFP2;
  case MCK_hGPR:
    return ARMAsmParser::Match_hGPR;
  case MCK_tGPR:
    return ARMAsmParser::Match_tGPR;
  case MCK_tGPREven:
    return ARMAsmParser::Match_tGPREven;
  case MCK_GPRnoip:
    return ARMAsmParser::Match_GPRnoip;
  case MCK_rGPR:
    return ARMAsmParser::Match_rGPR;
  case MCK_GPRnopc:
    return ARMAsmParser::Match_GPRnopc;
  case MCK_GPRnosp:
    return ARMAsmParser::Match_GPRnosp;
  case MCK_GPRwithAPSR_NZCVnosp:
    return ARMAsmParser::Match_GPRwithAPSR_NZCVnosp;
  case MCK_GPRwithZRnosp:
    return ARMAsmParser::Match_GPRwithZRnosp;
  case MCK_DPR_VFP2:
    return ARMAsmParser::Match_DPR_VFP2;
  case MCK_GPR:
    return ARMAsmParser::Match_GPR;
  case MCK_GPRwithAPSR:
    return ARMAsmParser::Match_GPRwithAPSR;
  case MCK_GPRwithZR:
    return ARMAsmParser::Match_GPRwithZR;
  case MCK_QPR:
    return ARMAsmParser::Match_QPR;
  case MCK_SPR_8:
    return ARMAsmParser::Match_SPR_8;
  case MCK_DPR:
    return ARMAsmParser::Match_DPR;
  case MCK_HPR:
    return ARMAsmParser::Match_SPR;
  default:
    return MCTargetAsmParser::Match_InvalidOperand;
  }
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case '!':	 // 1 string to match.
      return MCK__EXCLAIM_;	 // "!"
    case '[':	 // 1 string to match.
      return MCK__91_;	 // "["
    case ']':	 // 1 string to match.
      return MCK__93_;	 // "]"
    case '^':	 // 1 string to match.
      return MCK__94_;	 // "^"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 2:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case '#':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return MCK__HASH_0;	 // "#0"
      case '8':	 // 1 string to match.
        return MCK__HASH_8;	 // "#8"
      }
      break;
    case '.':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return MCK__DOT_8;	 // ".8"
      case 'd':	 // 1 string to match.
        return MCK__DOT_d;	 // ".d"
      case 'f':	 // 1 string to match.
        return MCK__DOT_f;	 // ".f"
      case 'w':	 // 1 string to match.
        return MCK__DOT_w;	 // ".w"
      }
      break;
    }
    break;
  case 3:	 // 8 strings to match.
    switch (Name[0]) {
    default: break;
    case '#':	 // 1 string to match.
      if (memcmp(Name.data()+1, "16", 2) != 0)
        break;
      return MCK__HASH_16;	 // "#16"
    case '.':	 // 7 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[2] != '6')
          break;
        return MCK__DOT_16;	 // ".16"
      case '3':	 // 1 string to match.
        if (Name[2] != '2')
          break;
        return MCK__DOT_32;	 // ".32"
      case '6':	 // 1 string to match.
        if (Name[2] != '4')
          break;
        return MCK__DOT_64;	 // ".64"
      case 'i':	 // 1 string to match.
        if (Name[2] != '8')
          break;
        return MCK__DOT_i8;	 // ".i8"
      case 'p':	 // 1 string to match.
        if (Name[2] != '8')
          break;
        return MCK__DOT_p8;	 // ".p8"
      case 's':	 // 1 string to match.
        if (Name[2] != '8')
          break;
        return MCK__DOT_s8;	 // ".s8"
      case 'u':	 // 1 string to match.
        if (Name[2] != '8')
          break;
        return MCK__DOT_u8;	 // ".u8"
      }
      break;
    }
    break;
  case 4:	 // 14 strings to match.
    if (Name[0] != '.')
      break;
    switch (Name[1]) {
    default: break;
    case 'f':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_f16;	 // ".f16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_f32;	 // ".f32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_f64;	 // ".f64"
      }
      break;
    case 'i':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_i16;	 // ".i16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_i32;	 // ".i32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_i64;	 // ".i64"
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_p16;	 // ".p16"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_p64;	 // ".p64"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_s16;	 // ".s16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_s32;	 // ".s32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_s64;	 // ".s64"
      }
      break;
    case 'u':	 // 3 strings to match.
      switch (Name[2]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[3] != '6')
          break;
        return MCK__DOT_u16;	 // ".u16"
      case '3':	 // 1 string to match.
        if (Name[3] != '2')
          break;
        return MCK__DOT_u32;	 // ".u32"
      case '6':	 // 1 string to match.
        if (Name[3] != '4')
          break;
        return MCK__DOT_u64;	 // ".u64"
      }
      break;
    }
    break;
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, ".bf16", 5) != 0)
      break;
    return MCK__DOT_bf16;	 // ".bf16"
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK__DOT_d:
    switch (B) {
    default: return false;
    case MCK__DOT_f64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_f:
    switch (B) {
    default: return false;
    case MCK__DOT_f32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_s16:
    switch (B) {
    default: return false;
    case MCK__DOT_i16: return true;
    case MCK__DOT_16: return true;
    }

  case MCK__DOT_s32:
    switch (B) {
    default: return false;
    case MCK__DOT_i32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_s64:
    switch (B) {
    default: return false;
    case MCK__DOT_i64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_s8:
    switch (B) {
    default: return false;
    case MCK__DOT_i8: return true;
    case MCK__DOT_8: return true;
    }

  case MCK__DOT_u16:
    switch (B) {
    default: return false;
    case MCK__DOT_i16: return true;
    case MCK__DOT_16: return true;
    }

  case MCK__DOT_u32:
    switch (B) {
    default: return false;
    case MCK__DOT_i32: return true;
    case MCK__DOT_32: return true;
    }

  case MCK__DOT_u64:
    switch (B) {
    default: return false;
    case MCK__DOT_i64: return true;
    case MCK__DOT_64: return true;
    }

  case MCK__DOT_u8:
    switch (B) {
    default: return false;
    case MCK__DOT_i8: return true;
    case MCK__DOT_8: return true;
    }

  case MCK__DOT_f32:
    return B == MCK__DOT_32;

  case MCK__DOT_f64:
    return B == MCK__DOT_64;

  case MCK__DOT_i16:
    return B == MCK__DOT_16;

  case MCK__DOT_i32:
    return B == MCK__DOT_32;

  case MCK__DOT_i64:
    return B == MCK__DOT_64;

  case MCK__DOT_i8:
    return B == MCK__DOT_8;

  case MCK__DOT_p16:
    return B == MCK__DOT_16;

  case MCK__DOT_p8:
    return B == MCK__DOT_8;

  case MCK_Reg107:
    switch (B) {
    default: return false;
    case MCK_Reg106: return true;
    case MCK_Reg104: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg91:
    switch (B) {
    default: return false;
    case MCK_Reg92: return true;
    case MCK_Reg93: return true;
    case MCK_Reg94: return true;
    case MCK_MQQQQPR: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_APSR:
    return B == MCK_GPRwithAPSRnosp;

  case MCK_APSR_NZCV:
    switch (B) {
    default: return false;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSR: return true;
    }

  case MCK_GPRlr:
    switch (B) {
    default: return false;
    case MCK_Reg34: return true;
    case MCK_Reg28: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_GPRsp:
    switch (B) {
    default: return false;
    case MCK_Reg30: return true;
    case MCK_Reg31: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_PC:
    switch (B) {
    default: return false;
    case MCK_Reg32: return true;
    case MCK_Reg31: return true;
    case MCK_Reg29: return true;
    case MCK_hGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg14: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPR: return true;
    }

  case MCK_R12:
    switch (B) {
    default: return false;
    case MCK_Reg21: return true;
    case MCK_Reg34: return true;
    case MCK_tcGPR: return true;
    case MCK_Reg28: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_VCCR:
    return B == MCK_FPWithVPR;

  case MCK_Reg132:
    switch (B) {
    default: return false;
    case MCK_Reg133: return true;
    case MCK_Reg134: return true;
    case MCK_Reg89: return true;
    case MCK_Reg135: return true;
    case MCK_Reg90: return true;
    case MCK_Reg136: return true;
    case MCK_Reg87: return true;
    case MCK_Reg137: return true;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg138: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg105:
    switch (B) {
    default: return false;
    case MCK_Reg106: return true;
    case MCK_GPRPairnosp: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg100:
    switch (B) {
    default: return false;
    case MCK_Reg104: return true;
    case MCK_Reg101: return true;
    case MCK_GPRPairnosp: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg92:
    switch (B) {
    default: return false;
    case MCK_Reg93: return true;
    case MCK_Reg94: return true;
    case MCK_MQQQQPR: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg35:
    switch (B) {
    default: return false;
    case MCK_Reg25: return true;
    case MCK_Reg32: return true;
    case MCK_Reg30: return true;
    case MCK_Reg31: return true;
    case MCK_Reg28: return true;
    case MCK_tGPROdd: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg33:
    switch (B) {
    default: return false;
    case MCK_Reg34: return true;
    case MCK_Reg25: return true;
    case MCK_Reg32: return true;
    case MCK_Reg30: return true;
    case MCK_Reg31: return true;
    case MCK_Reg28: return true;
    case MCK_Reg19: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg22:
    switch (B) {
    default: return false;
    case MCK_Reg23: return true;
    case MCK_tcGPRnotr12: return true;
    case MCK_tcGPR: return true;
    case MCK_tGPROdd: return true;
    case MCK_tGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg17:
    switch (B) {
    default: return false;
    case MCK_Reg21: return true;
    case MCK_Reg18: return true;
    case MCK_tcGPRnotr12: return true;
    case MCK_tcGPR: return true;
    case MCK_Reg19: return true;
    case MCK_tGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg133:
    switch (B) {
    default: return false;
    case MCK_Reg134: return true;
    case MCK_Reg135: return true;
    case MCK_Reg90: return true;
    case MCK_Reg136: return true;
    case MCK_Reg87: return true;
    case MCK_Reg137: return true;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg138: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg120:
    switch (B) {
    default: return false;
    case MCK_Reg121: return true;
    case MCK_Reg108: return true;
    case MCK_Reg122: return true;
    case MCK_Reg109: return true;
    case MCK_Reg123: return true;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg124: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg115:
    switch (B) {
    default: return false;
    case MCK_Reg116: return true;
    case MCK_Reg108: return true;
    case MCK_Reg117: return true;
    case MCK_Reg109: return true;
    case MCK_Reg118: return true;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg119: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg106:
    return B == MCK_GPRPair;

  case MCK_Reg104:
    return B == MCK_GPRPair;

  case MCK_Reg93:
    switch (B) {
    default: return false;
    case MCK_Reg94: return true;
    case MCK_MQQQQPR: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg77:
    switch (B) {
    default: return false;
    case MCK_Reg78: return true;
    case MCK_Reg89: return true;
    case MCK_Reg90: return true;
    case MCK_Reg87: return true;
    case MCK_MQQPR: return true;
    case MCK_Reg88: return true;
    case MCK_Reg80: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_QQPR: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg21:
    switch (B) {
    default: return false;
    case MCK_tcGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg134:
    switch (B) {
    default: return false;
    case MCK_Reg135: return true;
    case MCK_Reg136: return true;
    case MCK_Reg137: return true;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg138: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg125:
    switch (B) {
    default: return false;
    case MCK_Reg126: return true;
    case MCK_Reg127: return true;
    case MCK_Reg128: return true;
    case MCK_Reg129: return true;
    case MCK_Reg130: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg121:
    switch (B) {
    default: return false;
    case MCK_Reg122: return true;
    case MCK_Reg123: return true;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg124: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg116:
    switch (B) {
    default: return false;
    case MCK_Reg117: return true;
    case MCK_Reg109: return true;
    case MCK_Reg118: return true;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg119: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg101:
    switch (B) {
    default: return false;
    case MCK_GPRPairnosp: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg94:
    switch (B) {
    default: return false;
    case MCK_MQQQQPR: return true;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg78:
    switch (B) {
    default: return false;
    case MCK_Reg87: return true;
    case MCK_MQQPR: return true;
    case MCK_Reg88: return true;
    case MCK_Reg80: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_QQPR: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg34:
    switch (B) {
    default: return false;
    case MCK_Reg28: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg25:
    switch (B) {
    default: return false;
    case MCK_Reg32: return true;
    case MCK_Reg30: return true;
    case MCK_Reg31: return true;
    case MCK_Reg28: return true;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg23:
    switch (B) {
    default: return false;
    case MCK_tGPROdd: return true;
    case MCK_tGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg18:
    switch (B) {
    default: return false;
    case MCK_Reg19: return true;
    case MCK_tGPR: return true;
    case MCK_tGPREven: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_QPR_8:
    switch (B) {
    default: return false;
    case MCK_Reg52: return true;
    case MCK_Reg53: return true;
    case MCK_MQPR: return true;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_QPR: return true;
    case MCK_DPair: return true;
    }

  case MCK_tcGPRnotr12:
    switch (B) {
    default: return false;
    case MCK_tcGPR: return true;
    case MCK_tGPR: return true;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg89:
    switch (B) {
    default: return false;
    case MCK_Reg90: return true;
    case MCK_Reg87: return true;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg32:
    switch (B) {
    default: return false;
    case MCK_Reg31: return true;
    case MCK_Reg29: return true;
    case MCK_hGPR: return true;
    case MCK_Reg14: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg30:
    switch (B) {
    default: return false;
    case MCK_Reg31: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_MQQQQPR:
    switch (B) {
    default: return false;
    case MCK_Reg96: return true;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_tcGPR:
    switch (B) {
    default: return false;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg135:
    switch (B) {
    default: return false;
    case MCK_Reg136: return true;
    case MCK_Reg137: return true;
    case MCK_Reg85: return true;
    case MCK_Reg138: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg126:
    switch (B) {
    default: return false;
    case MCK_Reg127: return true;
    case MCK_Reg128: return true;
    case MCK_Reg129: return true;
    case MCK_Reg130: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg108:
    switch (B) {
    default: return false;
    case MCK_Reg109: return true;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg96:
    switch (B) {
    default: return false;
    case MCK_Reg97: return true;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg90:
    switch (B) {
    default: return false;
    case MCK_Reg87: return true;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg72:
    switch (B) {
    default: return false;
    case MCK_Reg73: return true;
    case MCK_Reg74: return true;
    case MCK_Reg75: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_Reg31:
    switch (B) {
    default: return false;
    case MCK_hGPR: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg28:
    switch (B) {
    default: return false;
    case MCK_Reg29: return true;
    case MCK_Reg26: return true;
    case MCK_hGPR: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg19:
    switch (B) {
    default: return false;
    case MCK_tGPREven: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_GPRPairnosp:
    return B == MCK_GPRPair;

  case MCK_tGPROdd:
    switch (B) {
    default: return false;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg136:
    switch (B) {
    default: return false;
    case MCK_Reg137: return true;
    case MCK_Reg138: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg122:
    switch (B) {
    default: return false;
    case MCK_Reg123: return true;
    case MCK_Reg111: return true;
    case MCK_Reg124: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg117:
    switch (B) {
    default: return false;
    case MCK_Reg118: return true;
    case MCK_Reg111: return true;
    case MCK_Reg119: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg109:
    switch (B) {
    default: return false;
    case MCK_Reg110: return true;
    case MCK_Reg111: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg97:
    switch (B) {
    default: return false;
    case MCK_Reg98: return true;
    case MCK_QQQQPR: return true;
    }

  case MCK_Reg87:
    switch (B) {
    default: return false;
    case MCK_Reg88: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg52:
    switch (B) {
    default: return false;
    case MCK_Reg53: return true;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_DPair: return true;
    }

  case MCK_Reg29:
    switch (B) {
    default: return false;
    case MCK_hGPR: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg26:
    switch (B) {
    default: return false;
    case MCK_hGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_MQQPR:
    switch (B) {
    default: return false;
    case MCK_Reg80: return true;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_QQPR: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg137:
    switch (B) {
    default: return false;
    case MCK_Reg138: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg127:
    switch (B) {
    default: return false;
    case MCK_Reg128: return true;
    case MCK_Reg129: return true;
    case MCK_Reg130: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg123:
    switch (B) {
    default: return false;
    case MCK_Reg124: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg118:
    switch (B) {
    default: return false;
    case MCK_Reg119: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg110:
    switch (B) {
    default: return false;
    case MCK_Reg111: return true;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg98:
    return B == MCK_QQQQPR;

  case MCK_Reg88:
    switch (B) {
    default: return false;
    case MCK_Reg85: return true;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg80:
    switch (B) {
    default: return false;
    case MCK_Reg83: return true;
    case MCK_QQPR: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg73:
    switch (B) {
    default: return false;
    case MCK_Reg74: return true;
    case MCK_Reg75: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_Reg53:
    switch (B) {
    default: return false;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_DPair: return true;
    }

  case MCK_DPR_8:
    switch (B) {
    default: return false;
    case MCK_DPR_VFP2: return true;
    case MCK_DPR: return true;
    case MCK_FPWithVPR: return true;
    }

  case MCK_MQPR:
    switch (B) {
    default: return false;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_QPR: return true;
    case MCK_DPair: return true;
    }

  case MCK_hGPR:
    return B == MCK_GPR;

  case MCK_tGPR:
    switch (B) {
    default: return false;
    case MCK_tGPRwithpc: return true;
    case MCK_Reg2: return true;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_tGPREven:
    switch (B) {
    default: return false;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_tGPRwithpc:
    switch (B) {
    default: return false;
    case MCK_Reg14: return true;
    case MCK_GPRnoip: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg128:
    switch (B) {
    default: return false;
    case MCK_Reg129: return true;
    case MCK_Reg130: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg2:
    switch (B) {
    default: return false;
    case MCK_Reg14: return true;
    case MCK_Reg12: return true;
    case MCK_GPRnoip: return true;
    case MCK_rGPR: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg85:
    switch (B) {
    default: return false;
    case MCK_Reg86: return true;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg14:
    switch (B) {
    default: return false;
    case MCK_GPRnoip: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPR: return true;
    }

  case MCK_Reg12:
    switch (B) {
    default: return false;
    case MCK_GPRnoip: return true;
    case MCK_GPRnopc: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg138:
    return B == MCK_DQuad;

  case MCK_Reg129:
    switch (B) {
    default: return false;
    case MCK_Reg130: return true;
    case MCK_DTripleSpc: return true;
    }

  case MCK_Reg111:
    switch (B) {
    default: return false;
    case MCK_Reg112: return true;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg86:
    switch (B) {
    default: return false;
    case MCK_Reg83: return true;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg74:
    switch (B) {
    default: return false;
    case MCK_Reg75: return true;
    case MCK_DPairSpc: return true;
    }

  case MCK_GPRnoip:
    return B == MCK_GPR;

  case MCK_rGPR:
    switch (B) {
    default: return false;
    case MCK_GPRnopc: return true;
    case MCK_GPRnosp: return true;
    case MCK_GPRwithAPSR_NZCVnosp: return true;
    case MCK_GPRwithAPSRnosp: return true;
    case MCK_GPRwithZRnosp: return true;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_Reg124:
    return B == MCK_DTriple;

  case MCK_Reg119:
    return B == MCK_DTriple;

  case MCK_Reg112:
    switch (B) {
    default: return false;
    case MCK_Reg113: return true;
    case MCK_DTriple: return true;
    }

  case MCK_Reg83:
    switch (B) {
    default: return false;
    case MCK_Reg84: return true;
    case MCK_DQuad: return true;
    }

  case MCK_Reg50:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_DPair: return true;
    }

  case MCK_GPRnopc:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRwithAPSR: return true;
    case MCK_GPRwithZR: return true;
    }

  case MCK_GPRnosp:
    return B == MCK_GPR;

  case MCK_GPRwithAPSR_NZCVnosp:
    return B == MCK_GPRwithAPSR;

  case MCK_GPRwithZRnosp:
    return B == MCK_GPRwithZR;

  case MCK_QQPR:
    return B == MCK_DQuad;

  case MCK_Reg130:
    return B == MCK_DTripleSpc;

  case MCK_Reg113:
    return B == MCK_DTriple;

  case MCK_Reg84:
    return B == MCK_DQuad;

  case MCK_Reg75:
    return B == MCK_DPairSpc;

  case MCK_Reg51:
    return B == MCK_DPair;

  case MCK_DPR_VFP2:
    switch (B) {
    default: return false;
    case MCK_DPR: return true;
    case MCK_FPWithVPR: return true;
    }

  case MCK_QPR:
    return B == MCK_DPair;

  case MCK_SPR_8:
    switch (B) {
    default: return false;
    case MCK_HPR: return true;
    case MCK_FPWithVPR: return true;
    }

  case MCK_DPR:
    return B == MCK_FPWithVPR;

  case MCK_HPR:
    return B == MCK_FPWithVPR;

  case MCK_CCOut:
    return B == OptionalMatchClass;

  case MCK_CondCode:
    return B == OptionalMatchClass;

  case MCK_VPTPredN:
    return B == OptionalMatchClass;

  case MCK_VPTPredR:
    return B == OptionalMatchClass;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  ARMOperand &Operand = (ARMOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AM2OffsetImm' class
  case MCK_AM2OffsetImm: {
    DiagnosticPredicate DP(Operand.isAM2OffsetImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AM3Offset' class
  case MCK_AM3Offset: {
    DiagnosticPredicate DP(Operand.isAM3Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ARMBranchTarget' class
  case MCK_ARMBranchTarget: {
    DiagnosticPredicate DP(Operand.isARMBranchTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode3' class
  case MCK_AddrMode3: {
    DiagnosticPredicate DP(Operand.isAddrMode3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode5' class
  case MCK_AddrMode5: {
    DiagnosticPredicate DP(Operand.isAddrMode5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AddrMode5FP16' class
  case MCK_AddrMode5FP16: {
    DiagnosticPredicate DP(Operand.isAddrMode5FP16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AlignedMemory16' class
  case MCK_AlignedMemory16: {
    DiagnosticPredicate DP(Operand.isAlignedMemory16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory16;
    break;
    }
  // 'AlignedMemory32' class
  case MCK_AlignedMemory32: {
    DiagnosticPredicate DP(Operand.isAlignedMemory32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory32;
    break;
    }
  // 'AlignedMemory64' class
  case MCK_AlignedMemory64: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64;
    break;
    }
  // 'AlignedMemory64or128' class
  case MCK_AlignedMemory64or128: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64or128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64or128;
    break;
    }
  // 'AlignedMemory64or128or256' class
  case MCK_AlignedMemory64or128or256: {
    DiagnosticPredicate DP(Operand.isAlignedMemory64or128or256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemory64or128or256;
    break;
    }
  // 'AlignedMemoryNone' class
  case MCK_AlignedMemoryNone: {
    DiagnosticPredicate DP(Operand.isAlignedMemoryNone());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_AlignedMemoryNone;
    break;
    }
  // 'AlignedMemory' class
  case MCK_AlignedMemory: {
    DiagnosticPredicate DP(Operand.isAlignedMemory());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DupAlignedMemory16' class
  case MCK_DupAlignedMemory16: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory16;
    break;
    }
  // 'DupAlignedMemory32' class
  case MCK_DupAlignedMemory32: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory32;
    break;
    }
  // 'DupAlignedMemory64' class
  case MCK_DupAlignedMemory64: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory64;
    break;
    }
  // 'DupAlignedMemory64or128' class
  case MCK_DupAlignedMemory64or128: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemory64or128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemory64or128;
    break;
    }
  // 'DupAlignedMemoryNone' class
  case MCK_DupAlignedMemoryNone: {
    DiagnosticPredicate DP(Operand.isDupAlignedMemoryNone());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DupAlignedMemoryNone;
    break;
    }
  // 'AdrLabel' class
  case MCK_AdrLabel: {
    DiagnosticPredicate DP(Operand.isAdrLabel());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'BankedReg' class
  case MCK_BankedReg: {
    DiagnosticPredicate DP(Operand.isBankedReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Bitfield' class
  case MCK_Bitfield: {
    DiagnosticPredicate DP(Operand.isBitfield());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CCOut' class
  case MCK_CCOut: {
    DiagnosticPredicate DP(Operand.isCCOut());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CondCode' class
  case MCK_CondCode: {
    DiagnosticPredicate DP(Operand.isCondCode());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocNum' class
  case MCK_CoprocNum: {
    DiagnosticPredicate DP(Operand.isCoprocNum());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocOption' class
  case MCK_CoprocOption: {
    DiagnosticPredicate DP(Operand.isCoprocOption());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CoprocReg' class
  case MCK_CoprocReg: {
    DiagnosticPredicate DP(Operand.isCoprocReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DPRRegList' class
  case MCK_DPRRegList: {
    DiagnosticPredicate DP(Operand.isDPRRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_DPR_RegList;
    break;
    }
  // 'FPDRegListWithVPR' class
  case MCK_FPDRegListWithVPR: {
    DiagnosticPredicate DP(Operand.isFPDRegListWithVPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FPImm' class
  case MCK_FPImm: {
    DiagnosticPredicate DP(Operand.isFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FPSRegListWithVPR' class
  case MCK_FPSRegListWithVPR: {
    DiagnosticPredicate DP(Operand.isFPSRegListWithVPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_15' class
  case MCK_Imm0_15: {
    DiagnosticPredicate DP(Operand.isImmediate<0,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_15;
    break;
    }
  // 'Imm0_1' class
  case MCK_Imm0_1: {
    DiagnosticPredicate DP(Operand.isImmediate<0,1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_1;
    break;
    }
  // 'Imm0_239' class
  case MCK_Imm0_239: {
    DiagnosticPredicate DP(Operand.isImmediate<0,239>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_239;
    break;
    }
  // 'Imm0_255' class
  case MCK_Imm0_255: {
    DiagnosticPredicate DP(Operand.isImmediate<0,255>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_255;
    break;
    }
  // 'Imm0_255Expr' class
  case MCK_Imm0_255Expr: {
    DiagnosticPredicate DP(Operand.isImm0_255Expr());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_255Expr;
    break;
    }
  // 'Imm0_31' class
  case MCK_Imm0_31: {
    DiagnosticPredicate DP(Operand.isImmediate<0,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_31;
    break;
    }
  // 'Imm0_32' class
  case MCK_Imm0_32: {
    DiagnosticPredicate DP(Operand.isImmediate<0,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_32;
    break;
    }
  // 'Imm0_3' class
  case MCK_Imm0_3: {
    DiagnosticPredicate DP(Operand.isImmediate<0,3>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_3;
    break;
    }
  // 'Imm0_63' class
  case MCK_Imm0_63: {
    DiagnosticPredicate DP(Operand.isImmediate<0,63>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_63;
    break;
    }
  // 'Imm0_65535' class
  case MCK_Imm0_65535: {
    DiagnosticPredicate DP(Operand.isImmediate<0,65535>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_65535;
    break;
    }
  // 'Imm0_65535Expr' class
  case MCK_Imm0_65535Expr: {
    DiagnosticPredicate DP(Operand.isImm0_65535Expr());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_65535Expr;
    break;
    }
  // 'Imm0_7' class
  case MCK_Imm0_7: {
    DiagnosticPredicate DP(Operand.isImmediate<0,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_7;
    break;
    }
  // 'Imm16' class
  case MCK_Imm16: {
    DiagnosticPredicate DP(Operand.isImmediate<16,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm16;
    break;
    }
  // 'Imm1_15' class
  case MCK_Imm1_15: {
    DiagnosticPredicate DP(Operand.isImmediate<1,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_15;
    break;
    }
  // 'Imm1_16' class
  case MCK_Imm1_16: {
    DiagnosticPredicate DP(Operand.isImmediate<1,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmRange1_16;
    break;
    }
  // 'Imm1_31' class
  case MCK_Imm1_31: {
    DiagnosticPredicate DP(Operand.isImmediate<1,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_31;
    break;
    }
  // 'Imm1_32' class
  case MCK_Imm1_32: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmRange1_32;
    break;
    }
  // 'Imm1_7' class
  case MCK_Imm1_7: {
    DiagnosticPredicate DP(Operand.isImmediate<1,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm1_7;
    break;
    }
  // 'Imm24bit' class
  case MCK_Imm24bit: {
    DiagnosticPredicate DP(Operand.isImmediate<0,16777215>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm24bit;
    break;
    }
  // 'Imm256_65535Expr' class
  case MCK_Imm256_65535Expr: {
    DiagnosticPredicate DP(Operand.isImmediate<256,65535>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm256_65535Expr;
    break;
    }
  // 'Imm32' class
  case MCK_Imm32: {
    DiagnosticPredicate DP(Operand.isImmediate<32,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm32;
    break;
    }
  // 'Imm8' class
  case MCK_Imm8: {
    DiagnosticPredicate DP(Operand.isImmediate<8,8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm8;
    break;
    }
  // 'Imm8_255' class
  case MCK_Imm8_255: {
    DiagnosticPredicate DP(Operand.isImmediate<8,255>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm8_255;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'InstSyncBarrierOpt' class
  case MCK_InstSyncBarrierOpt: {
    DiagnosticPredicate DP(Operand.isInstSyncBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MSRMask' class
  case MCK_MSRMask: {
    DiagnosticPredicate DP(Operand.isMSRMask());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEShiftImm1_15' class
  case MCK_MVEShiftImm1_15: {
    DiagnosticPredicate DP(Operand.isImmediate<1,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MVEShiftImm1_15;
    break;
    }
  // 'MVEShiftImm1_7' class
  case MCK_MVEShiftImm1_7: {
    DiagnosticPredicate DP(Operand.isImmediate<1,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MVEShiftImm1_7;
    break;
    }
  // 'VIDUP_imm' class
  case MCK_VIDUP_imm: {
    DiagnosticPredicate DP(Operand.isPowerTwoInRange<1,8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_VIDUP_imm;
    break;
    }
  // 'MemBarrierOpt' class
  case MCK_MemBarrierOpt: {
    DiagnosticPredicate DP(Operand.isMemBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm0_1020s4Offset' class
  case MCK_MemImm0_1020s4Offset: {
    DiagnosticPredicate DP(Operand.isMemImm0_1020s4Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm12Offset' class
  case MCK_MemImm12Offset: {
    DiagnosticPredicate DP(Operand.isMemImm12Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift0Offset' class
  case MCK_MemImm7Shift0Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<0,ARM::GPRnopcRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift0OffsetWB' class
  case MCK_MemImm7Shift0OffsetWB: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<0,ARM::rGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift1Offset' class
  case MCK_MemImm7Shift1Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<1,ARM::GPRnopcRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift1OffsetWB' class
  case MCK_MemImm7Shift1OffsetWB: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<1,ARM::rGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift2Offset' class
  case MCK_MemImm7Shift2Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<2,ARM::GPRnopcRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7Shift2OffsetWB' class
  case MCK_MemImm7Shift2OffsetWB: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<2,ARM::rGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm7s4Offset' class
  case MCK_MemImm7s4Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7s4Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm8Offset' class
  case MCK_MemImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemImm8s4Offset' class
  case MCK_MemImm8s4Offset: {
    DiagnosticPredicate DP(Operand.isMemImm8s4Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNegImm8Offset' class
  case MCK_MemNegImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemNegImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNoOffset' class
  case MCK_MemNoOffset: {
    DiagnosticPredicate DP(Operand.isMemNoOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNoOffsetT2' class
  case MCK_MemNoOffsetT2: {
    DiagnosticPredicate DP(Operand.isMemNoOffsetT2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNoOffsetT2NoSp' class
  case MCK_MemNoOffsetT2NoSp: {
    DiagnosticPredicate DP(Operand.isMemNoOffsetT2NoSp());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemNoOffsetT' class
  case MCK_MemNoOffsetT: {
    DiagnosticPredicate DP(Operand.isMemNoOffsetT());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemPosImm8Offset' class
  case MCK_MemPosImm8Offset: {
    DiagnosticPredicate DP(Operand.isMemPosImm8Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegOffset' class
  case MCK_MemRegOffset: {
    DiagnosticPredicate DP(Operand.isMemRegOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegQS2Offset' class
  case MCK_MemRegQS2Offset: {
    DiagnosticPredicate DP(Operand.isMemRegQOffset<2>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegQS3Offset' class
  case MCK_MemRegQS3Offset: {
    DiagnosticPredicate DP(Operand.isMemRegQOffset<3>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegRQS0Offset' class
  case MCK_MemRegRQS0Offset: {
    DiagnosticPredicate DP(Operand.isMemRegRQOffset<0>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegRQS1Offset' class
  case MCK_MemRegRQS1Offset: {
    DiagnosticPredicate DP(Operand.isMemRegRQOffset<1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegRQS2Offset' class
  case MCK_MemRegRQS2Offset: {
    DiagnosticPredicate DP(Operand.isMemRegRQOffset<2>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemRegRQS3Offset' class
  case MCK_MemRegRQS3Offset: {
    DiagnosticPredicate DP(Operand.isMemRegRQOffset<3>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImm' class
  case MCK_ModImm: {
    DiagnosticPredicate DP(Operand.isModImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImmNeg' class
  case MCK_ModImmNeg: {
    DiagnosticPredicate DP(Operand.isModImmNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ModImmNot' class
  case MCK_ModImmNot: {
    DiagnosticPredicate DP(Operand.isModImmNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MveSaturate' class
  case MCK_MveSaturate: {
    DiagnosticPredicate DP(Operand.isMveSaturateOp());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MveSaturate;
    break;
    }
  // 'PKHASRImm' class
  case MCK_PKHASRImm: {
    DiagnosticPredicate DP(Operand.isPKHASRImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PKHLSLImm' class
  case MCK_PKHLSLImm: {
    DiagnosticPredicate DP(Operand.isImmediate<0,31>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_PKHLSLImm;
    break;
    }
  // 'PostIdxImm8' class
  case MCK_PostIdxImm8: {
    DiagnosticPredicate DP(Operand.isPostIdxImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxImm8s4' class
  case MCK_PostIdxImm8s4: {
    DiagnosticPredicate DP(Operand.isPostIdxImm8s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxReg' class
  case MCK_PostIdxReg: {
    DiagnosticPredicate DP(Operand.isPostIdxReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PostIdxRegShifted' class
  case MCK_PostIdxRegShifted: {
    DiagnosticPredicate DP(Operand.isPostIdxRegShifted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ProcIFlags' class
  case MCK_ProcIFlags: {
    DiagnosticPredicate DP(Operand.isProcIFlags());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RegList' class
  case MCK_RegList: {
    DiagnosticPredicate DP(Operand.isRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RegListWithAPSR' class
  case MCK_RegListWithAPSR: {
    DiagnosticPredicate DP(Operand.isRegListWithAPSR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RotImm' class
  case MCK_RotImm: {
    DiagnosticPredicate DP(Operand.isRotImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SPRRegList' class
  case MCK_SPRRegList: {
    DiagnosticPredicate DP(Operand.isSPRRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_SPRRegList;
    break;
    }
  // 'SetEndImm' class
  case MCK_SetEndImm: {
    DiagnosticPredicate DP(Operand.isImmediate<0,1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_SetEndImm;
    break;
    }
  // 'RegShiftedImm' class
  case MCK_RegShiftedImm: {
    DiagnosticPredicate DP(Operand.isRegShiftedImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'RegShiftedReg' class
  case MCK_RegShiftedReg: {
    DiagnosticPredicate DP(Operand.isRegShiftedReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ShifterImm' class
  case MCK_ShifterImm: {
    DiagnosticPredicate DP(Operand.isShifterImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbBranchTarget' class
  case MCK_ThumbBranchTarget: {
    DiagnosticPredicate DP(Operand.isThumbBranchTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbMemPC' class
  case MCK_ThumbMemPC: {
    DiagnosticPredicate DP(Operand.isThumbMemPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbModImmNeg1_7' class
  case MCK_ThumbModImmNeg1_7: {
    DiagnosticPredicate DP(Operand.isThumbModImmNeg1_7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ThumbModImmNeg8_255' class
  case MCK_ThumbModImmNeg8_255: {
    DiagnosticPredicate DP(Operand.isThumbModImmNeg8_255());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmThumbSR' class
  case MCK_ImmThumbSR: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ImmThumbSR;
    break;
    }
  // 'TraceSyncBarrierOpt' class
  case MCK_TraceSyncBarrierOpt: {
    DiagnosticPredicate DP(Operand.isTraceSyncBarrierOpt());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'UnsignedOffset_b8s2' class
  case MCK_UnsignedOffset_b8s2: {
    DiagnosticPredicate DP(Operand.isUnsignedOffset<8, 2>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VPTPredN' class
  case MCK_VPTPredN: {
    DiagnosticPredicate DP(Operand.isVPTPred());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VPTPredR' class
  case MCK_VPTPredR: {
    DiagnosticPredicate DP(Operand.isVPTPred());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoMQ' class
  case MCK_VecListTwoMQ: {
    DiagnosticPredicate DP(Operand.isVecListTwoMQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_VecListTwoMQ;
    break;
    }
  // 'VecListFourMQ' class
  case MCK_VecListFourMQ: {
    DiagnosticPredicate DP(Operand.isVecListFourMQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_VecListFourMQ;
    break;
    }
  // 'VecListDPairAllLanes' class
  case MCK_VecListDPairAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListDPairAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPair' class
  case MCK_VecListDPair: {
    DiagnosticPredicate DP(Operand.isVecListDPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPairSpacedAllLanes' class
  case MCK_VecListDPairSpacedAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListDPairSpacedAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListDPairSpaced' class
  case MCK_VecListDPairSpaced: {
    DiagnosticPredicate DP(Operand.isVecListDPairSpaced());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDAllLanes' class
  case MCK_VecListFourDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListFourDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourD' class
  case MCK_VecListFourD: {
    DiagnosticPredicate DP(Operand.isVecListFourD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDByteIndexed' class
  case MCK_VecListFourDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDHWordIndexed' class
  case MCK_VecListFourDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourDWordIndexed' class
  case MCK_VecListFourDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQAllLanes' class
  case MCK_VecListFourQAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListFourQAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQ' class
  case MCK_VecListFourQ: {
    DiagnosticPredicate DP(Operand.isVecListFourQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQHWordIndexed' class
  case MCK_VecListFourQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListFourQWordIndexed' class
  case MCK_VecListFourQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListFourQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDAllLanes' class
  case MCK_VecListOneDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListOneDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneD' class
  case MCK_VecListOneD: {
    DiagnosticPredicate DP(Operand.isVecListOneD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDByteIndexed' class
  case MCK_VecListOneDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDHWordIndexed' class
  case MCK_VecListOneDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListOneDWordIndexed' class
  case MCK_VecListOneDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListOneDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDAllLanes' class
  case MCK_VecListThreeDAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListThreeDAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeD' class
  case MCK_VecListThreeD: {
    DiagnosticPredicate DP(Operand.isVecListThreeD());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDByteIndexed' class
  case MCK_VecListThreeDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDHWordIndexed' class
  case MCK_VecListThreeDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeDWordIndexed' class
  case MCK_VecListThreeDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQAllLanes' class
  case MCK_VecListThreeQAllLanes: {
    DiagnosticPredicate DP(Operand.isVecListThreeQAllLanes());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQ' class
  case MCK_VecListThreeQ: {
    DiagnosticPredicate DP(Operand.isVecListThreeQ());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQHWordIndexed' class
  case MCK_VecListThreeQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListThreeQWordIndexed' class
  case MCK_VecListThreeQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListThreeQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDByteIndexed' class
  case MCK_VecListTwoDByteIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDByteIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDHWordIndexed' class
  case MCK_VecListTwoDHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoDWordIndexed' class
  case MCK_VecListTwoDWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoDWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoQHWordIndexed' class
  case MCK_VecListTwoQHWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoQHWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VecListTwoQWordIndexed' class
  case MCK_VecListTwoQWordIndexed: {
    DiagnosticPredicate DP(Operand.isVecListTwoQWordIndexed());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex16' class
  case MCK_VectorIndex16: {
    DiagnosticPredicate DP(Operand.isVectorIndex16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex32' class
  case MCK_VectorIndex32: {
    DiagnosticPredicate DP(Operand.isVectorIndex32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex64' class
  case MCK_VectorIndex64: {
    DiagnosticPredicate DP(Operand.isVectorIndex64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VectorIndex8' class
  case MCK_VectorIndex8: {
    DiagnosticPredicate DP(Operand.isVectorIndex8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemTBB' class
  case MCK_MemTBB: {
    DiagnosticPredicate DP(Operand.isMemTBB());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemTBH' class
  case MCK_MemTBH: {
    DiagnosticPredicate DP(Operand.isMemTBH());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEVectorIndex4' class
  case MCK_MVEVectorIndex4: {
    DiagnosticPredicate DP(Operand.isVectorIndexInRange<4>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEVectorIndex8' class
  case MCK_MVEVectorIndex8: {
    DiagnosticPredicate DP(Operand.isVectorIndexInRange<8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEVectorIndex16' class
  case MCK_MVEVectorIndex16: {
    DiagnosticPredicate DP(Operand.isVectorIndexInRange<16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEVcvtImm32' class
  case MCK_MVEVcvtImm32: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MVEVcvtImm32;
    break;
    }
  // 'MVEVcvtImm16' class
  case MCK_MVEVcvtImm16: {
    DiagnosticPredicate DP(Operand.isImmediate<1,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MVEVcvtImm16;
    break;
    }
  // 'TMemImm7Shift2Offset' class
  case MCK_TMemImm7Shift2Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<2,ARM::tGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TMemImm7Shift0Offset' class
  case MCK_TMemImm7Shift0Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<0,ARM::tGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TMemImm7Shift1Offset' class
  case MCK_TMemImm7Shift1Offset: {
    DiagnosticPredicate DP(Operand.isMemImm7ShiftedOffset<1,ARM::tGPRRegClassID>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm3b' class
  case MCK_Imm3b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,7>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm3b;
    break;
    }
  // 'Imm4b' class
  case MCK_Imm4b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,15>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm4b;
    break;
    }
  // 'Imm6b' class
  case MCK_Imm6b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,63>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm6b;
    break;
    }
  // 'Imm7b' class
  case MCK_Imm7b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,127>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm7b;
    break;
    }
  // 'Imm9b' class
  case MCK_Imm9b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,511>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm9b;
    break;
    }
  // 'Imm11b' class
  case MCK_Imm11b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,2047>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm11b;
    break;
    }
  // 'Imm12b' class
  case MCK_Imm12b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,4095>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm12b;
    break;
    }
  // 'Imm13b' class
  case MCK_Imm13b: {
    DiagnosticPredicate DP(Operand.isImmediate<0,8191>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm13b;
    break;
    }
  // 'MVEPairVectorIndex0' class
  case MCK_MVEPairVectorIndex0: {
    DiagnosticPredicate DP(Operand.isMVEPairVectorIndex<0, 1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MVEPairVectorIndex2' class
  case MCK_MVEPairVectorIndex2: {
    DiagnosticPredicate DP(Operand.isMVEPairVectorIndex<2, 3>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ComplexRotationEven' class
  case MCK_ComplexRotationEven: {
    DiagnosticPredicate DP(Operand.isComplexRotation<90, 0>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ComplexRotationEven;
    break;
    }
  // 'ComplexRotationOdd' class
  case MCK_ComplexRotationOdd: {
    DiagnosticPredicate DP(Operand.isComplexRotation<180, 90>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ComplexRotationOdd;
    break;
    }
  // 'NEONi16vmovi8Replicate' class
  case MCK_NEONi16vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi16invi8Replicate' class
  case MCK_NEONi16invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovi8Replicate' class
  case MCK_NEONi32vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32invi8Replicate' class
  case MCK_NEONi32invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi8Replicate' class
  case MCK_NEONi64vmovi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<8, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64invi8Replicate' class
  case MCK_NEONi64invi8Replicate: {
    DiagnosticPredicate DP(Operand.isNEONinvReplicate<8, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovi16Replicate' class
  case MCK_NEONi32vmovi16Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<16, 32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi16Replicate' class
  case MCK_NEONi64vmovi16Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<16, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64vmovi32Replicate' class
  case MCK_NEONi64vmovi32Replicate: {
    DiagnosticPredicate DP(Operand.isNEONmovReplicate<32, 64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ConstPoolAsmImm' class
  case MCK_ConstPoolAsmImm: {
    DiagnosticPredicate DP(Operand.isConstPoolAsmImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FBits16' class
  case MCK_FBits16: {
    DiagnosticPredicate DP(Operand.isFBits16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FBits32' class
  case MCK_FBits32: {
    DiagnosticPredicate DP(Operand.isFBits32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_4095' class
  case MCK_Imm0_4095: {
    DiagnosticPredicate DP(Operand.isImmediate<0,4095>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_Imm0_4095;
    break;
    }
  // 'Imm0_4095Neg' class
  case MCK_Imm0_4095Neg: {
    DiagnosticPredicate DP(Operand.isImm0_4095Neg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ITMask' class
  case MCK_ITMask: {
    DiagnosticPredicate DP(Operand.isITMask());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ITCondCode' class
  case MCK_ITCondCode: {
    DiagnosticPredicate DP(Operand.isITCondCode());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'LELabel' class
  case MCK_LELabel: {
    DiagnosticPredicate DP(Operand.isLEOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_LELabel;
    break;
    }
  // 'MVELongShift' class
  case MCK_MVELongShift: {
    DiagnosticPredicate DP(Operand.isMVELongShift());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_MVELongShift;
    break;
    }
  // 'NEONi16splat' class
  case MCK_NEONi16splat: {
    DiagnosticPredicate DP(Operand.isNEONi16splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32splat' class
  case MCK_NEONi32splat: {
    DiagnosticPredicate DP(Operand.isNEONi32splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi64splat' class
  case MCK_NEONi64splat: {
    DiagnosticPredicate DP(Operand.isNEONi64splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi8splat' class
  case MCK_NEONi8splat: {
    DiagnosticPredicate DP(Operand.isNEONi8splat());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi16splatNot' class
  case MCK_NEONi16splatNot: {
    DiagnosticPredicate DP(Operand.isNEONi16splatNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32splatNot' class
  case MCK_NEONi32splatNot: {
    DiagnosticPredicate DP(Operand.isNEONi32splatNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmov' class
  case MCK_NEONi32vmov: {
    DiagnosticPredicate DP(Operand.isNEONi32vmov());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'NEONi32vmovNeg' class
  case MCK_NEONi32vmovNeg: {
    DiagnosticPredicate DP(Operand.isNEONi32vmovNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CondCodeNoAL' class
  case MCK_CondCodeNoAL: {
    DiagnosticPredicate DP(Operand.isITCondCodeNoAL());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CondCodeNoALInv' class
  case MCK_CondCodeNoALInv: {
    DiagnosticPredicate DP(Operand.isITCondCodeNoAL());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CondCodeRestrictedFP' class
  case MCK_CondCodeRestrictedFP: {
    DiagnosticPredicate DP(Operand.isITCondCodeRestrictedFP());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_CondCodeRestrictedFP;
    break;
    }
  // 'CondCodeRestrictedI' class
  case MCK_CondCodeRestrictedI: {
    DiagnosticPredicate DP(Operand.isITCondCodeRestrictedI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_CondCodeRestrictedI;
    break;
    }
  // 'CondCodeRestrictedS' class
  case MCK_CondCodeRestrictedS: {
    DiagnosticPredicate DP(Operand.isITCondCodeRestrictedS());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_CondCodeRestrictedS;
    break;
    }
  // 'CondCodeRestrictedU' class
  case MCK_CondCodeRestrictedU: {
    DiagnosticPredicate DP(Operand.isITCondCodeRestrictedU());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_CondCodeRestrictedU;
    break;
    }
  // 'ShrImm16' class
  case MCK_ShrImm16: {
    DiagnosticPredicate DP(Operand.isImmediate<1,16>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm16;
    break;
    }
  // 'ShrImm32' class
  case MCK_ShrImm32: {
    DiagnosticPredicate DP(Operand.isImmediate<1,32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm32;
    break;
    }
  // 'ShrImm64' class
  case MCK_ShrImm64: {
    DiagnosticPredicate DP(Operand.isImmediate<1,64>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm64;
    break;
    }
  // 'ShrImm8' class
  case MCK_ShrImm8: {
    DiagnosticPredicate DP(Operand.isImmediate<1,8>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_ShrImm8;
    break;
    }
  // 'T2SOImm' class
  case MCK_T2SOImm: {
    DiagnosticPredicate DP(Operand.isT2SOImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2SOImmNeg' class
  case MCK_T2SOImmNeg: {
    DiagnosticPredicate DP(Operand.isT2SOImmNeg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2SOImmNot' class
  case MCK_T2SOImmNot: {
    DiagnosticPredicate DP(Operand.isT2SOImmNot());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemUImm12Offset' class
  case MCK_MemUImm12Offset: {
    DiagnosticPredicate DP(Operand.isMemUImm12Offset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'T2MemRegOffset' class
  case MCK_T2MemRegOffset: {
    DiagnosticPredicate DP(Operand.isT2MemRegOffset());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm7s4' class
  case MCK_Imm7s4: {
    DiagnosticPredicate DP(Operand.isImm7s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm7Shift0' class
  case MCK_Imm7Shift0: {
    DiagnosticPredicate DP(Operand.isImm7Shift0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm7Shift1' class
  case MCK_Imm7Shift1: {
    DiagnosticPredicate DP(Operand.isImm7Shift1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm7Shift2' class
  case MCK_Imm7Shift2: {
    DiagnosticPredicate DP(Operand.isImm7Shift2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm8s4' class
  case MCK_Imm8s4: {
    DiagnosticPredicate DP(Operand.isImm8s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemPCRelImm12' class
  case MCK_MemPCRelImm12: {
    DiagnosticPredicate DP(Operand.isMemPCRelImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs1' class
  case MCK_MemThumbRIs1: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs2' class
  case MCK_MemThumbRIs2: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRIs4' class
  case MCK_MemThumbRIs4: {
    DiagnosticPredicate DP(Operand.isMemThumbRIs4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbRR' class
  case MCK_MemThumbRR: {
    DiagnosticPredicate DP(Operand.isMemThumbRR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemThumbSPI' class
  case MCK_MemThumbSPI: {
    DiagnosticPredicate DP(Operand.isMemThumbSPI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_1020s4' class
  case MCK_Imm0_1020s4: {
    DiagnosticPredicate DP(Operand.isImm0_1020s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_508s4' class
  case MCK_Imm0_508s4: {
    DiagnosticPredicate DP(Operand.isImm0_508s4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm0_508s4Neg' class
  case MCK_Imm0_508s4Neg: {
    DiagnosticPredicate DP(Operand.isImm0_508s4Neg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'WLSLabel' class
  case MCK_WLSLabel: {
    DiagnosticPredicate DP(Operand.isUnsignedOffset<11, 1>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return ARMAsmParser::Match_WLSLabel;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg().id()) {
    default: OpKind = InvalidMatchClass; break;
    case ARM::R0: OpKind = MCK_Reg17; break;
    case ARM::R1: OpKind = MCK_Reg22; break;
    case ARM::R2: OpKind = MCK_Reg17; break;
    case ARM::R3: OpKind = MCK_Reg22; break;
    case ARM::R4: OpKind = MCK_Reg18; break;
    case ARM::R5: OpKind = MCK_Reg23; break;
    case ARM::R6: OpKind = MCK_Reg18; break;
    case ARM::R7: OpKind = MCK_Reg23; break;
    case ARM::R8: OpKind = MCK_Reg33; break;
    case ARM::R9: OpKind = MCK_Reg35; break;
    case ARM::R10: OpKind = MCK_Reg33; break;
    case ARM::R11: OpKind = MCK_Reg35; break;
    case ARM::R12: OpKind = MCK_R12; break;
    case ARM::SP: OpKind = MCK_GPRsp; break;
    case ARM::LR: OpKind = MCK_GPRlr; break;
    case ARM::PC: OpKind = MCK_PC; break;
    case ARM::S0: OpKind = MCK_SPR_8; break;
    case ARM::S1: OpKind = MCK_SPR_8; break;
    case ARM::S2: OpKind = MCK_SPR_8; break;
    case ARM::S3: OpKind = MCK_SPR_8; break;
    case ARM::S4: OpKind = MCK_SPR_8; break;
    case ARM::S5: OpKind = MCK_SPR_8; break;
    case ARM::S6: OpKind = MCK_SPR_8; break;
    case ARM::S7: OpKind = MCK_SPR_8; break;
    case ARM::S8: OpKind = MCK_SPR_8; break;
    case ARM::S9: OpKind = MCK_SPR_8; break;
    case ARM::S10: OpKind = MCK_SPR_8; break;
    case ARM::S11: OpKind = MCK_SPR_8; break;
    case ARM::S12: OpKind = MCK_SPR_8; break;
    case ARM::S13: OpKind = MCK_SPR_8; break;
    case ARM::S14: OpKind = MCK_SPR_8; break;
    case ARM::S15: OpKind = MCK_SPR_8; break;
    case ARM::S16: OpKind = MCK_HPR; break;
    case ARM::S17: OpKind = MCK_HPR; break;
    case ARM::S18: OpKind = MCK_HPR; break;
    case ARM::S19: OpKind = MCK_HPR; break;
    case ARM::S20: OpKind = MCK_HPR; break;
    case ARM::S21: OpKind = MCK_HPR; break;
    case ARM::S22: OpKind = MCK_HPR; break;
    case ARM::S23: OpKind = MCK_HPR; break;
    case ARM::S24: OpKind = MCK_HPR; break;
    case ARM::S25: OpKind = MCK_HPR; break;
    case ARM::S26: OpKind = MCK_HPR; break;
    case ARM::S27: OpKind = MCK_HPR; break;
    case ARM::S28: OpKind = MCK_HPR; break;
    case ARM::S29: OpKind = MCK_HPR; break;
    case ARM::S30: OpKind = MCK_HPR; break;
    case ARM::S31: OpKind = MCK_HPR; break;
    case ARM::D0: OpKind = MCK_DPR_8; break;
    case ARM::D1: OpKind = MCK_DPR_8; break;
    case ARM::D2: OpKind = MCK_DPR_8; break;
    case ARM::D3: OpKind = MCK_DPR_8; break;
    case ARM::D4: OpKind = MCK_DPR_8; break;
    case ARM::D5: OpKind = MCK_DPR_8; break;
    case ARM::D6: OpKind = MCK_DPR_8; break;
    case ARM::D7: OpKind = MCK_DPR_8; break;
    case ARM::D8: OpKind = MCK_DPR_VFP2; break;
    case ARM::D9: OpKind = MCK_DPR_VFP2; break;
    case ARM::D10: OpKind = MCK_DPR_VFP2; break;
    case ARM::D11: OpKind = MCK_DPR_VFP2; break;
    case ARM::D12: OpKind = MCK_DPR_VFP2; break;
    case ARM::D13: OpKind = MCK_DPR_VFP2; break;
    case ARM::D14: OpKind = MCK_DPR_VFP2; break;
    case ARM::D15: OpKind = MCK_DPR_VFP2; break;
    case ARM::D16: OpKind = MCK_DPR; break;
    case ARM::D17: OpKind = MCK_DPR; break;
    case ARM::D18: OpKind = MCK_DPR; break;
    case ARM::D19: OpKind = MCK_DPR; break;
    case ARM::D20: OpKind = MCK_DPR; break;
    case ARM::D21: OpKind = MCK_DPR; break;
    case ARM::D22: OpKind = MCK_DPR; break;
    case ARM::D23: OpKind = MCK_DPR; break;
    case ARM::D24: OpKind = MCK_DPR; break;
    case ARM::D25: OpKind = MCK_DPR; break;
    case ARM::D26: OpKind = MCK_DPR; break;
    case ARM::D27: OpKind = MCK_DPR; break;
    case ARM::D28: OpKind = MCK_DPR; break;
    case ARM::D29: OpKind = MCK_DPR; break;
    case ARM::D30: OpKind = MCK_DPR; break;
    case ARM::D31: OpKind = MCK_DPR; break;
    case ARM::Q0: OpKind = MCK_QPR_8; break;
    case ARM::Q1: OpKind = MCK_QPR_8; break;
    case ARM::Q2: OpKind = MCK_QPR_8; break;
    case ARM::Q3: OpKind = MCK_QPR_8; break;
    case ARM::Q4: OpKind = MCK_MQPR; break;
    case ARM::Q5: OpKind = MCK_MQPR; break;
    case ARM::Q6: OpKind = MCK_MQPR; break;
    case ARM::Q7: OpKind = MCK_MQPR; break;
    case ARM::Q8: OpKind = MCK_QPR; break;
    case ARM::Q9: OpKind = MCK_QPR; break;
    case ARM::Q10: OpKind = MCK_QPR; break;
    case ARM::Q11: OpKind = MCK_QPR; break;
    case ARM::Q12: OpKind = MCK_QPR; break;
    case ARM::Q13: OpKind = MCK_QPR; break;
    case ARM::Q14: OpKind = MCK_QPR; break;
    case ARM::Q15: OpKind = MCK_QPR; break;
    case ARM::CPSR: OpKind = MCK_CCR; break;
    case ARM::APSR: OpKind = MCK_APSR; break;
    case ARM::APSR_NZCV: OpKind = MCK_APSR_NZCV; break;
    case ARM::SPSR: OpKind = MCK_SPSR; break;
    case ARM::FPSCR: OpKind = MCK_FPSCR; break;
    case ARM::FPSCR_NZCV: OpKind = MCK_cl_FPSCR_NZCV; break;
    case ARM::FPSID: OpKind = MCK_FPSID; break;
    case ARM::MVFR2: OpKind = MCK_MVFR2; break;
    case ARM::MVFR1: OpKind = MCK_MVFR1; break;
    case ARM::MVFR0: OpKind = MCK_MVFR0; break;
    case ARM::FPEXC: OpKind = MCK_FPEXC; break;
    case ARM::FPINST: OpKind = MCK_FPINST; break;
    case ARM::FPINST2: OpKind = MCK_FPINST2; break;
    case ARM::VPR: OpKind = MCK_VCCR; break;
    case ARM::FPSCR_NZCVQC: OpKind = MCK_FPSCR_NZCVQC; break;
    case ARM::P0: OpKind = MCK_P0; break;
    case ARM::FPCXTNS: OpKind = MCK_FPCXTRegs; break;
    case ARM::FPCXTS: OpKind = MCK_FPCXTS; break;
    case ARM::ZR: OpKind = MCK_GPRwithZRnosp; break;
    case ARM::D0_D2: OpKind = MCK_Reg72; break;
    case ARM::D1_D3: OpKind = MCK_Reg72; break;
    case ARM::D2_D4: OpKind = MCK_Reg72; break;
    case ARM::D3_D5: OpKind = MCK_Reg72; break;
    case ARM::D4_D6: OpKind = MCK_Reg72; break;
    case ARM::D5_D7: OpKind = MCK_Reg72; break;
    case ARM::D6_D8: OpKind = MCK_Reg73; break;
    case ARM::D7_D9: OpKind = MCK_Reg73; break;
    case ARM::D8_D10: OpKind = MCK_Reg74; break;
    case ARM::D9_D11: OpKind = MCK_Reg74; break;
    case ARM::D10_D12: OpKind = MCK_Reg74; break;
    case ARM::D11_D13: OpKind = MCK_Reg74; break;
    case ARM::D12_D14: OpKind = MCK_Reg74; break;
    case ARM::D13_D15: OpKind = MCK_Reg74; break;
    case ARM::D14_D16: OpKind = MCK_Reg75; break;
    case ARM::D15_D17: OpKind = MCK_Reg75; break;
    case ARM::D16_D18: OpKind = MCK_DPairSpc; break;
    case ARM::D17_D19: OpKind = MCK_DPairSpc; break;
    case ARM::D18_D20: OpKind = MCK_DPairSpc; break;
    case ARM::D19_D21: OpKind = MCK_DPairSpc; break;
    case ARM::D20_D22: OpKind = MCK_DPairSpc; break;
    case ARM::D21_D23: OpKind = MCK_DPairSpc; break;
    case ARM::D22_D24: OpKind = MCK_DPairSpc; break;
    case ARM::D23_D25: OpKind = MCK_DPairSpc; break;
    case ARM::D24_D26: OpKind = MCK_DPairSpc; break;
    case ARM::D25_D27: OpKind = MCK_DPairSpc; break;
    case ARM::D26_D28: OpKind = MCK_DPairSpc; break;
    case ARM::D27_D29: OpKind = MCK_DPairSpc; break;
    case ARM::D28_D30: OpKind = MCK_DPairSpc; break;
    case ARM::D29_D31: OpKind = MCK_DPairSpc; break;
    case ARM::Q0_Q1: OpKind = MCK_Reg77; break;
    case ARM::Q1_Q2: OpKind = MCK_Reg77; break;
    case ARM::Q2_Q3: OpKind = MCK_Reg77; break;
    case ARM::Q3_Q4: OpKind = MCK_Reg78; break;
    case ARM::Q4_Q5: OpKind = MCK_MQQPR; break;
    case ARM::Q5_Q6: OpKind = MCK_MQQPR; break;
    case ARM::Q6_Q7: OpKind = MCK_MQQPR; break;
    case ARM::Q7_Q8: OpKind = MCK_Reg80; break;
    case ARM::Q8_Q9: OpKind = MCK_QQPR; break;
    case ARM::Q9_Q10: OpKind = MCK_QQPR; break;
    case ARM::Q10_Q11: OpKind = MCK_QQPR; break;
    case ARM::Q11_Q12: OpKind = MCK_QQPR; break;
    case ARM::Q12_Q13: OpKind = MCK_QQPR; break;
    case ARM::Q13_Q14: OpKind = MCK_QQPR; break;
    case ARM::Q14_Q15: OpKind = MCK_QQPR; break;
    case ARM::Q0_Q1_Q2_Q3: OpKind = MCK_Reg91; break;
    case ARM::Q1_Q2_Q3_Q4: OpKind = MCK_Reg92; break;
    case ARM::Q2_Q3_Q4_Q5: OpKind = MCK_Reg93; break;
    case ARM::Q3_Q4_Q5_Q6: OpKind = MCK_Reg94; break;
    case ARM::Q4_Q5_Q6_Q7: OpKind = MCK_MQQQQPR; break;
    case ARM::Q5_Q6_Q7_Q8: OpKind = MCK_Reg96; break;
    case ARM::Q6_Q7_Q8_Q9: OpKind = MCK_Reg97; break;
    case ARM::Q7_Q8_Q9_Q10: OpKind = MCK_Reg98; break;
    case ARM::Q8_Q9_Q10_Q11: OpKind = MCK_QQQQPR; break;
    case ARM::Q9_Q10_Q11_Q12: OpKind = MCK_QQQQPR; break;
    case ARM::Q10_Q11_Q12_Q13: OpKind = MCK_QQQQPR; break;
    case ARM::Q11_Q12_Q13_Q14: OpKind = MCK_QQQQPR; break;
    case ARM::Q12_Q13_Q14_Q15: OpKind = MCK_QQQQPR; break;
    case ARM::R0_R1: OpKind = MCK_Reg100; break;
    case ARM::R2_R3: OpKind = MCK_Reg100; break;
    case ARM::R4_R5: OpKind = MCK_Reg101; break;
    case ARM::R6_R7: OpKind = MCK_Reg101; break;
    case ARM::R8_R9: OpKind = MCK_Reg105; break;
    case ARM::R10_R11: OpKind = MCK_Reg105; break;
    case ARM::R12_SP: OpKind = MCK_Reg107; break;
    case ARM::D0_D1_D2: OpKind = MCK_Reg115; break;
    case ARM::D1_D2_D3: OpKind = MCK_Reg120; break;
    case ARM::D2_D3_D4: OpKind = MCK_Reg115; break;
    case ARM::D3_D4_D5: OpKind = MCK_Reg120; break;
    case ARM::D4_D5_D6: OpKind = MCK_Reg115; break;
    case ARM::D5_D6_D7: OpKind = MCK_Reg120; break;
    case ARM::D6_D7_D8: OpKind = MCK_Reg116; break;
    case ARM::D7_D8_D9: OpKind = MCK_Reg121; break;
    case ARM::D8_D9_D10: OpKind = MCK_Reg117; break;
    case ARM::D9_D10_D11: OpKind = MCK_Reg122; break;
    case ARM::D10_D11_D12: OpKind = MCK_Reg117; break;
    case ARM::D11_D12_D13: OpKind = MCK_Reg122; break;
    case ARM::D12_D13_D14: OpKind = MCK_Reg117; break;
    case ARM::D13_D14_D15: OpKind = MCK_Reg122; break;
    case ARM::D14_D15_D16: OpKind = MCK_Reg118; break;
    case ARM::D15_D16_D17: OpKind = MCK_Reg123; break;
    case ARM::D16_D17_D18: OpKind = MCK_Reg119; break;
    case ARM::D17_D18_D19: OpKind = MCK_Reg124; break;
    case ARM::D18_D19_D20: OpKind = MCK_Reg119; break;
    case ARM::D19_D20_D21: OpKind = MCK_Reg124; break;
    case ARM::D20_D21_D22: OpKind = MCK_Reg119; break;
    case ARM::D21_D22_D23: OpKind = MCK_Reg124; break;
    case ARM::D22_D23_D24: OpKind = MCK_Reg119; break;
    case ARM::D23_D24_D25: OpKind = MCK_Reg124; break;
    case ARM::D24_D25_D26: OpKind = MCK_Reg119; break;
    case ARM::D25_D26_D27: OpKind = MCK_Reg124; break;
    case ARM::D26_D27_D28: OpKind = MCK_Reg119; break;
    case ARM::D27_D28_D29: OpKind = MCK_Reg124; break;
    case ARM::D28_D29_D30: OpKind = MCK_Reg119; break;
    case ARM::D29_D30_D31: OpKind = MCK_Reg124; break;
    case ARM::D0_D2_D4: OpKind = MCK_Reg125; break;
    case ARM::D1_D3_D5: OpKind = MCK_Reg125; break;
    case ARM::D2_D4_D6: OpKind = MCK_Reg125; break;
    case ARM::D3_D5_D7: OpKind = MCK_Reg125; break;
    case ARM::D4_D6_D8: OpKind = MCK_Reg126; break;
    case ARM::D5_D7_D9: OpKind = MCK_Reg126; break;
    case ARM::D6_D8_D10: OpKind = MCK_Reg127; break;
    case ARM::D7_D9_D11: OpKind = MCK_Reg127; break;
    case ARM::D8_D10_D12: OpKind = MCK_Reg128; break;
    case ARM::D9_D11_D13: OpKind = MCK_Reg128; break;
    case ARM::D10_D12_D14: OpKind = MCK_Reg128; break;
    case ARM::D11_D13_D15: OpKind = MCK_Reg128; break;
    case ARM::D12_D14_D16: OpKind = MCK_Reg129; break;
    case ARM::D13_D15_D17: OpKind = MCK_Reg129; break;
    case ARM::D14_D16_D18: OpKind = MCK_Reg130; break;
    case ARM::D15_D17_D19: OpKind = MCK_Reg130; break;
    case ARM::D16_D18_D20: OpKind = MCK_DTripleSpc; break;
    case ARM::D17_D19_D21: OpKind = MCK_DTripleSpc; break;
    case ARM::D18_D20_D22: OpKind = MCK_DTripleSpc; break;
    case ARM::D19_D21_D23: OpKind = MCK_DTripleSpc; break;
    case ARM::D20_D22_D24: OpKind = MCK_DTripleSpc; break;
    case ARM::D21_D23_D25: OpKind = MCK_DTripleSpc; break;
    case ARM::D22_D24_D26: OpKind = MCK_DTripleSpc; break;
    case ARM::D23_D25_D27: OpKind = MCK_DTripleSpc; break;
    case ARM::D24_D26_D28: OpKind = MCK_DTripleSpc; break;
    case ARM::D25_D27_D29: OpKind = MCK_DTripleSpc; break;
    case ARM::D26_D28_D30: OpKind = MCK_DTripleSpc; break;
    case ARM::D27_D29_D31: OpKind = MCK_DTripleSpc; break;
    case ARM::D1_D2: OpKind = MCK_Reg52; break;
    case ARM::D3_D4: OpKind = MCK_Reg52; break;
    case ARM::D5_D6: OpKind = MCK_Reg52; break;
    case ARM::D7_D8: OpKind = MCK_Reg53; break;
    case ARM::D9_D10: OpKind = MCK_Reg50; break;
    case ARM::D11_D12: OpKind = MCK_Reg50; break;
    case ARM::D13_D14: OpKind = MCK_Reg50; break;
    case ARM::D15_D16: OpKind = MCK_Reg51; break;
    case ARM::D17_D18: OpKind = MCK_DPair; break;
    case ARM::D19_D20: OpKind = MCK_DPair; break;
    case ARM::D21_D22: OpKind = MCK_DPair; break;
    case ARM::D23_D24: OpKind = MCK_DPair; break;
    case ARM::D25_D26: OpKind = MCK_DPair; break;
    case ARM::D27_D28: OpKind = MCK_DPair; break;
    case ARM::D29_D30: OpKind = MCK_DPair; break;
    case ARM::D1_D2_D3_D4: OpKind = MCK_Reg132; break;
    case ARM::D3_D4_D5_D6: OpKind = MCK_Reg132; break;
    case ARM::D5_D6_D7_D8: OpKind = MCK_Reg133; break;
    case ARM::D7_D8_D9_D10: OpKind = MCK_Reg134; break;
    case ARM::D9_D10_D11_D12: OpKind = MCK_Reg135; break;
    case ARM::D11_D12_D13_D14: OpKind = MCK_Reg135; break;
    case ARM::D13_D14_D15_D16: OpKind = MCK_Reg136; break;
    case ARM::D15_D16_D17_D18: OpKind = MCK_Reg137; break;
    case ARM::D17_D18_D19_D20: OpKind = MCK_Reg138; break;
    case ARM::D19_D20_D21_D22: OpKind = MCK_Reg138; break;
    case ARM::D21_D22_D23_D24: OpKind = MCK_Reg138; break;
    case ARM::D23_D24_D25_D26: OpKind = MCK_Reg138; break;
    case ARM::D25_D26_D27_D28: OpKind = MCK_Reg138; break;
    case ARM::D27_D28_D29_D30: OpKind = MCK_Reg138; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__DOT_d: return "MCK__DOT_d";
  case MCK__DOT_f: return "MCK__DOT_f";
  case MCK__DOT_s16: return "MCK__DOT_s16";
  case MCK__DOT_s32: return "MCK__DOT_s32";
  case MCK__DOT_s64: return "MCK__DOT_s64";
  case MCK__DOT_s8: return "MCK__DOT_s8";
  case MCK__DOT_u16: return "MCK__DOT_u16";
  case MCK__DOT_u32: return "MCK__DOT_u32";
  case MCK__DOT_u64: return "MCK__DOT_u64";
  case MCK__DOT_u8: return "MCK__DOT_u8";
  case MCK__DOT_f32: return "MCK__DOT_f32";
  case MCK__DOT_f64: return "MCK__DOT_f64";
  case MCK__DOT_i16: return "MCK__DOT_i16";
  case MCK__DOT_i32: return "MCK__DOT_i32";
  case MCK__DOT_i64: return "MCK__DOT_i64";
  case MCK__DOT_i8: return "MCK__DOT_i8";
  case MCK__DOT_p16: return "MCK__DOT_p16";
  case MCK__DOT_p8: return "MCK__DOT_p8";
  case MCK__EXCLAIM_: return "MCK__EXCLAIM_";
  case MCK__HASH_0: return "MCK__HASH_0";
  case MCK__HASH_16: return "MCK__HASH_16";
  case MCK__HASH_8: return "MCK__HASH_8";
  case MCK__DOT_16: return "MCK__DOT_16";
  case MCK__DOT_32: return "MCK__DOT_32";
  case MCK__DOT_64: return "MCK__DOT_64";
  case MCK__DOT_8: return "MCK__DOT_8";
  case MCK__DOT_bf16: return "MCK__DOT_bf16";
  case MCK__DOT_f16: return "MCK__DOT_f16";
  case MCK__DOT_p64: return "MCK__DOT_p64";
  case MCK__DOT_w: return "MCK__DOT_w";
  case MCK__91_: return "MCK__91_";
  case MCK__93_: return "MCK__93_";
  case MCK__94_: return "MCK__94_";
  case MCK__123_: return "MCK__123_";
  case MCK__125_: return "MCK__125_";
  case MCK_Reg107: return "MCK_Reg107";
  case MCK_Reg91: return "MCK_Reg91";
  case MCK_APSR: return "MCK_APSR";
  case MCK_APSR_NZCV: return "MCK_APSR_NZCV";
  case MCK_CCR: return "MCK_CCR";
  case MCK_FPCXTRegs: return "MCK_FPCXTRegs";
  case MCK_FPCXTS: return "MCK_FPCXTS";
  case MCK_FPEXC: return "MCK_FPEXC";
  case MCK_FPINST: return "MCK_FPINST";
  case MCK_FPINST2: return "MCK_FPINST2";
  case MCK_FPSCR: return "MCK_FPSCR";
  case MCK_FPSCR_NZCVQC: return "MCK_FPSCR_NZCVQC";
  case MCK_FPSID: return "MCK_FPSID";
  case MCK_GPRlr: return "MCK_GPRlr";
  case MCK_GPRsp: return "MCK_GPRsp";
  case MCK_MVFR0: return "MCK_MVFR0";
  case MCK_MVFR1: return "MCK_MVFR1";
  case MCK_MVFR2: return "MCK_MVFR2";
  case MCK_P0: return "MCK_P0";
  case MCK_PC: return "MCK_PC";
  case MCK_R12: return "MCK_R12";
  case MCK_SPSR: return "MCK_SPSR";
  case MCK_VCCR: return "MCK_VCCR";
  case MCK_cl_FPSCR_NZCV: return "MCK_cl_FPSCR_NZCV";
  case MCK_Reg132: return "MCK_Reg132";
  case MCK_Reg105: return "MCK_Reg105";
  case MCK_Reg100: return "MCK_Reg100";
  case MCK_Reg92: return "MCK_Reg92";
  case MCK_Reg35: return "MCK_Reg35";
  case MCK_Reg33: return "MCK_Reg33";
  case MCK_Reg22: return "MCK_Reg22";
  case MCK_Reg17: return "MCK_Reg17";
  case MCK_Reg133: return "MCK_Reg133";
  case MCK_Reg120: return "MCK_Reg120";
  case MCK_Reg115: return "MCK_Reg115";
  case MCK_Reg106: return "MCK_Reg106";
  case MCK_Reg104: return "MCK_Reg104";
  case MCK_Reg93: return "MCK_Reg93";
  case MCK_Reg77: return "MCK_Reg77";
  case MCK_Reg21: return "MCK_Reg21";
  case MCK_Reg134: return "MCK_Reg134";
  case MCK_Reg125: return "MCK_Reg125";
  case MCK_Reg121: return "MCK_Reg121";
  case MCK_Reg116: return "MCK_Reg116";
  case MCK_Reg101: return "MCK_Reg101";
  case MCK_Reg94: return "MCK_Reg94";
  case MCK_Reg78: return "MCK_Reg78";
  case MCK_Reg34: return "MCK_Reg34";
  case MCK_Reg25: return "MCK_Reg25";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_Reg18: return "MCK_Reg18";
  case MCK_QPR_8: return "MCK_QPR_8";
  case MCK_tcGPRnotr12: return "MCK_tcGPRnotr12";
  case MCK_Reg89: return "MCK_Reg89";
  case MCK_Reg32: return "MCK_Reg32";
  case MCK_Reg30: return "MCK_Reg30";
  case MCK_MQQQQPR: return "MCK_MQQQQPR";
  case MCK_tcGPR: return "MCK_tcGPR";
  case MCK_Reg135: return "MCK_Reg135";
  case MCK_Reg126: return "MCK_Reg126";
  case MCK_Reg108: return "MCK_Reg108";
  case MCK_Reg96: return "MCK_Reg96";
  case MCK_Reg90: return "MCK_Reg90";
  case MCK_Reg72: return "MCK_Reg72";
  case MCK_Reg31: return "MCK_Reg31";
  case MCK_Reg28: return "MCK_Reg28";
  case MCK_Reg19: return "MCK_Reg19";
  case MCK_GPRPairnosp: return "MCK_GPRPairnosp";
  case MCK_tGPROdd: return "MCK_tGPROdd";
  case MCK_Reg136: return "MCK_Reg136";
  case MCK_Reg122: return "MCK_Reg122";
  case MCK_Reg117: return "MCK_Reg117";
  case MCK_Reg109: return "MCK_Reg109";
  case MCK_Reg97: return "MCK_Reg97";
  case MCK_Reg87: return "MCK_Reg87";
  case MCK_Reg52: return "MCK_Reg52";
  case MCK_Reg29: return "MCK_Reg29";
  case MCK_Reg26: return "MCK_Reg26";
  case MCK_GPRPair: return "MCK_GPRPair";
  case MCK_MQQPR: return "MCK_MQQPR";
  case MCK_Reg137: return "MCK_Reg137";
  case MCK_Reg127: return "MCK_Reg127";
  case MCK_Reg123: return "MCK_Reg123";
  case MCK_Reg118: return "MCK_Reg118";
  case MCK_Reg110: return "MCK_Reg110";
  case MCK_Reg98: return "MCK_Reg98";
  case MCK_Reg88: return "MCK_Reg88";
  case MCK_Reg80: return "MCK_Reg80";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg53: return "MCK_Reg53";
  case MCK_DPR_8: return "MCK_DPR_8";
  case MCK_MQPR: return "MCK_MQPR";
  case MCK_hGPR: return "MCK_hGPR";
  case MCK_tGPR: return "MCK_tGPR";
  case MCK_tGPREven: return "MCK_tGPREven";
  case MCK_tGPRwithpc: return "MCK_tGPRwithpc";
  case MCK_Reg128: return "MCK_Reg128";
  case MCK_Reg2: return "MCK_Reg2";
  case MCK_Reg85: return "MCK_Reg85";
  case MCK_Reg14: return "MCK_Reg14";
  case MCK_Reg12: return "MCK_Reg12";
  case MCK_QQQQPR: return "MCK_QQQQPR";
  case MCK_Reg138: return "MCK_Reg138";
  case MCK_Reg129: return "MCK_Reg129";
  case MCK_Reg111: return "MCK_Reg111";
  case MCK_Reg86: return "MCK_Reg86";
  case MCK_Reg74: return "MCK_Reg74";
  case MCK_GPRnoip: return "MCK_GPRnoip";
  case MCK_rGPR: return "MCK_rGPR";
  case MCK_Reg124: return "MCK_Reg124";
  case MCK_Reg119: return "MCK_Reg119";
  case MCK_Reg112: return "MCK_Reg112";
  case MCK_Reg83: return "MCK_Reg83";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_GPRnopc: return "MCK_GPRnopc";
  case MCK_GPRnosp: return "MCK_GPRnosp";
  case MCK_GPRwithAPSR_NZCVnosp: return "MCK_GPRwithAPSR_NZCVnosp";
  case MCK_GPRwithAPSRnosp: return "MCK_GPRwithAPSRnosp";
  case MCK_GPRwithZRnosp: return "MCK_GPRwithZRnosp";
  case MCK_QQPR: return "MCK_QQPR";
  case MCK_Reg130: return "MCK_Reg130";
  case MCK_Reg113: return "MCK_Reg113";
  case MCK_Reg84: return "MCK_Reg84";
  case MCK_Reg75: return "MCK_Reg75";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_DPR_VFP2: return "MCK_DPR_VFP2";
  case MCK_GPR: return "MCK_GPR";
  case MCK_GPRwithAPSR: return "MCK_GPRwithAPSR";
  case MCK_GPRwithZR: return "MCK_GPRwithZR";
  case MCK_QPR: return "MCK_QPR";
  case MCK_SPR_8: return "MCK_SPR_8";
  case MCK_DTripleSpc: return "MCK_DTripleSpc";
  case MCK_DQuad: return "MCK_DQuad";
  case MCK_DPairSpc: return "MCK_DPairSpc";
  case MCK_DTriple: return "MCK_DTriple";
  case MCK_DPair: return "MCK_DPair";
  case MCK_DPR: return "MCK_DPR";
  case MCK_HPR: return "MCK_HPR";
  case MCK_FPWithVPR: return "MCK_FPWithVPR";
  case MCK_AM2OffsetImm: return "MCK_AM2OffsetImm";
  case MCK_AM3Offset: return "MCK_AM3Offset";
  case MCK_ARMBranchTarget: return "MCK_ARMBranchTarget";
  case MCK_AddrMode3: return "MCK_AddrMode3";
  case MCK_AddrMode5: return "MCK_AddrMode5";
  case MCK_AddrMode5FP16: return "MCK_AddrMode5FP16";
  case MCK_AlignedMemory16: return "MCK_AlignedMemory16";
  case MCK_AlignedMemory32: return "MCK_AlignedMemory32";
  case MCK_AlignedMemory64: return "MCK_AlignedMemory64";
  case MCK_AlignedMemory64or128: return "MCK_AlignedMemory64or128";
  case MCK_AlignedMemory64or128or256: return "MCK_AlignedMemory64or128or256";
  case MCK_AlignedMemoryNone: return "MCK_AlignedMemoryNone";
  case MCK_AlignedMemory: return "MCK_AlignedMemory";
  case MCK_DupAlignedMemory16: return "MCK_DupAlignedMemory16";
  case MCK_DupAlignedMemory32: return "MCK_DupAlignedMemory32";
  case MCK_DupAlignedMemory64: return "MCK_DupAlignedMemory64";
  case MCK_DupAlignedMemory64or128: return "MCK_DupAlignedMemory64or128";
  case MCK_DupAlignedMemoryNone: return "MCK_DupAlignedMemoryNone";
  case MCK_AdrLabel: return "MCK_AdrLabel";
  case MCK_BankedReg: return "MCK_BankedReg";
  case MCK_Bitfield: return "MCK_Bitfield";
  case MCK_CCOut: return "MCK_CCOut";
  case MCK_CondCode: return "MCK_CondCode";
  case MCK_CoprocNum: return "MCK_CoprocNum";
  case MCK_CoprocOption: return "MCK_CoprocOption";
  case MCK_CoprocReg: return "MCK_CoprocReg";
  case MCK_DPRRegList: return "MCK_DPRRegList";
  case MCK_FPDRegListWithVPR: return "MCK_FPDRegListWithVPR";
  case MCK_FPImm: return "MCK_FPImm";
  case MCK_FPSRegListWithVPR: return "MCK_FPSRegListWithVPR";
  case MCK_Imm0_15: return "MCK_Imm0_15";
  case MCK_Imm0_1: return "MCK_Imm0_1";
  case MCK_Imm0_239: return "MCK_Imm0_239";
  case MCK_Imm0_255: return "MCK_Imm0_255";
  case MCK_Imm0_255Expr: return "MCK_Imm0_255Expr";
  case MCK_Imm0_31: return "MCK_Imm0_31";
  case MCK_Imm0_32: return "MCK_Imm0_32";
  case MCK_Imm0_3: return "MCK_Imm0_3";
  case MCK_Imm0_63: return "MCK_Imm0_63";
  case MCK_Imm0_65535: return "MCK_Imm0_65535";
  case MCK_Imm0_65535Expr: return "MCK_Imm0_65535Expr";
  case MCK_Imm0_7: return "MCK_Imm0_7";
  case MCK_Imm16: return "MCK_Imm16";
  case MCK_Imm1_15: return "MCK_Imm1_15";
  case MCK_Imm1_16: return "MCK_Imm1_16";
  case MCK_Imm1_31: return "MCK_Imm1_31";
  case MCK_Imm1_32: return "MCK_Imm1_32";
  case MCK_Imm1_7: return "MCK_Imm1_7";
  case MCK_Imm24bit: return "MCK_Imm24bit";
  case MCK_Imm256_65535Expr: return "MCK_Imm256_65535Expr";
  case MCK_Imm32: return "MCK_Imm32";
  case MCK_Imm8: return "MCK_Imm8";
  case MCK_Imm8_255: return "MCK_Imm8_255";
  case MCK_Imm: return "MCK_Imm";
  case MCK_InstSyncBarrierOpt: return "MCK_InstSyncBarrierOpt";
  case MCK_MSRMask: return "MCK_MSRMask";
  case MCK_MVEShiftImm1_15: return "MCK_MVEShiftImm1_15";
  case MCK_MVEShiftImm1_7: return "MCK_MVEShiftImm1_7";
  case MCK_VIDUP_imm: return "MCK_VIDUP_imm";
  case MCK_MemBarrierOpt: return "MCK_MemBarrierOpt";
  case MCK_MemImm0_1020s4Offset: return "MCK_MemImm0_1020s4Offset";
  case MCK_MemImm12Offset: return "MCK_MemImm12Offset";
  case MCK_MemImm7Shift0Offset: return "MCK_MemImm7Shift0Offset";
  case MCK_MemImm7Shift0OffsetWB: return "MCK_MemImm7Shift0OffsetWB";
  case MCK_MemImm7Shift1Offset: return "MCK_MemImm7Shift1Offset";
  case MCK_MemImm7Shift1OffsetWB: return "MCK_MemImm7Shift1OffsetWB";
  case MCK_MemImm7Shift2Offset: return "MCK_MemImm7Shift2Offset";
  case MCK_MemImm7Shift2OffsetWB: return "MCK_MemImm7Shift2OffsetWB";
  case MCK_MemImm7s4Offset: return "MCK_MemImm7s4Offset";
  case MCK_MemImm8Offset: return "MCK_MemImm8Offset";
  case MCK_MemImm8s4Offset: return "MCK_MemImm8s4Offset";
  case MCK_MemNegImm8Offset: return "MCK_MemNegImm8Offset";
  case MCK_MemNoOffset: return "MCK_MemNoOffset";
  case MCK_MemNoOffsetT2: return "MCK_MemNoOffsetT2";
  case MCK_MemNoOffsetT2NoSp: return "MCK_MemNoOffsetT2NoSp";
  case MCK_MemNoOffsetT: return "MCK_MemNoOffsetT";
  case MCK_MemPosImm8Offset: return "MCK_MemPosImm8Offset";
  case MCK_MemRegOffset: return "MCK_MemRegOffset";
  case MCK_MemRegQS2Offset: return "MCK_MemRegQS2Offset";
  case MCK_MemRegQS3Offset: return "MCK_MemRegQS3Offset";
  case MCK_MemRegRQS0Offset: return "MCK_MemRegRQS0Offset";
  case MCK_MemRegRQS1Offset: return "MCK_MemRegRQS1Offset";
  case MCK_MemRegRQS2Offset: return "MCK_MemRegRQS2Offset";
  case MCK_MemRegRQS3Offset: return "MCK_MemRegRQS3Offset";
  case MCK_ModImm: return "MCK_ModImm";
  case MCK_ModImmNeg: return "MCK_ModImmNeg";
  case MCK_ModImmNot: return "MCK_ModImmNot";
  case MCK_MveSaturate: return "MCK_MveSaturate";
  case MCK_PKHASRImm: return "MCK_PKHASRImm";
  case MCK_PKHLSLImm: return "MCK_PKHLSLImm";
  case MCK_PostIdxImm8: return "MCK_PostIdxImm8";
  case MCK_PostIdxImm8s4: return "MCK_PostIdxImm8s4";
  case MCK_PostIdxReg: return "MCK_PostIdxReg";
  case MCK_PostIdxRegShifted: return "MCK_PostIdxRegShifted";
  case MCK_ProcIFlags: return "MCK_ProcIFlags";
  case MCK_RegList: return "MCK_RegList";
  case MCK_RegListWithAPSR: return "MCK_RegListWithAPSR";
  case MCK_RotImm: return "MCK_RotImm";
  case MCK_SPRRegList: return "MCK_SPRRegList";
  case MCK_SetEndImm: return "MCK_SetEndImm";
  case MCK_RegShiftedImm: return "MCK_RegShiftedImm";
  case MCK_RegShiftedReg: return "MCK_RegShiftedReg";
  case MCK_ShifterImm: return "MCK_ShifterImm";
  case MCK_ThumbBranchTarget: return "MCK_ThumbBranchTarget";
  case MCK_ThumbMemPC: return "MCK_ThumbMemPC";
  case MCK_ThumbModImmNeg1_7: return "MCK_ThumbModImmNeg1_7";
  case MCK_ThumbModImmNeg8_255: return "MCK_ThumbModImmNeg8_255";
  case MCK_ImmThumbSR: return "MCK_ImmThumbSR";
  case MCK_TraceSyncBarrierOpt: return "MCK_TraceSyncBarrierOpt";
  case MCK_UnsignedOffset_b8s2: return "MCK_UnsignedOffset_b8s2";
  case MCK_VPTPredN: return "MCK_VPTPredN";
  case MCK_VPTPredR: return "MCK_VPTPredR";
  case MCK_VecListTwoMQ: return "MCK_VecListTwoMQ";
  case MCK_VecListFourMQ: return "MCK_VecListFourMQ";
  case MCK_VecListDPairAllLanes: return "MCK_VecListDPairAllLanes";
  case MCK_VecListDPair: return "MCK_VecListDPair";
  case MCK_VecListDPairSpacedAllLanes: return "MCK_VecListDPairSpacedAllLanes";
  case MCK_VecListDPairSpaced: return "MCK_VecListDPairSpaced";
  case MCK_VecListFourDAllLanes: return "MCK_VecListFourDAllLanes";
  case MCK_VecListFourD: return "MCK_VecListFourD";
  case MCK_VecListFourDByteIndexed: return "MCK_VecListFourDByteIndexed";
  case MCK_VecListFourDHWordIndexed: return "MCK_VecListFourDHWordIndexed";
  case MCK_VecListFourDWordIndexed: return "MCK_VecListFourDWordIndexed";
  case MCK_VecListFourQAllLanes: return "MCK_VecListFourQAllLanes";
  case MCK_VecListFourQ: return "MCK_VecListFourQ";
  case MCK_VecListFourQHWordIndexed: return "MCK_VecListFourQHWordIndexed";
  case MCK_VecListFourQWordIndexed: return "MCK_VecListFourQWordIndexed";
  case MCK_VecListOneDAllLanes: return "MCK_VecListOneDAllLanes";
  case MCK_VecListOneD: return "MCK_VecListOneD";
  case MCK_VecListOneDByteIndexed: return "MCK_VecListOneDByteIndexed";
  case MCK_VecListOneDHWordIndexed: return "MCK_VecListOneDHWordIndexed";
  case MCK_VecListOneDWordIndexed: return "MCK_VecListOneDWordIndexed";
  case MCK_VecListThreeDAllLanes: return "MCK_VecListThreeDAllLanes";
  case MCK_VecListThreeD: return "MCK_VecListThreeD";
  case MCK_VecListThreeDByteIndexed: return "MCK_VecListThreeDByteIndexed";
  case MCK_VecListThreeDHWordIndexed: return "MCK_VecListThreeDHWordIndexed";
  case MCK_VecListThreeDWordIndexed: return "MCK_VecListThreeDWordIndexed";
  case MCK_VecListThreeQAllLanes: return "MCK_VecListThreeQAllLanes";
  case MCK_VecListThreeQ: return "MCK_VecListThreeQ";
  case MCK_VecListThreeQHWordIndexed: return "MCK_VecListThreeQHWordIndexed";
  case MCK_VecListThreeQWordIndexed: return "MCK_VecListThreeQWordIndexed";
  case MCK_VecListTwoDByteIndexed: return "MCK_VecListTwoDByteIndexed";
  case MCK_VecListTwoDHWordIndexed: return "MCK_VecListTwoDHWordIndexed";
  case MCK_VecListTwoDWordIndexed: return "MCK_VecListTwoDWordIndexed";
  case MCK_VecListTwoQHWordIndexed: return "MCK_VecListTwoQHWordIndexed";
  case MCK_VecListTwoQWordIndexed: return "MCK_VecListTwoQWordIndexed";
  case MCK_VectorIndex16: return "MCK_VectorIndex16";
  case MCK_VectorIndex32: return "MCK_VectorIndex32";
  case MCK_VectorIndex64: return "MCK_VectorIndex64";
  case MCK_VectorIndex8: return "MCK_VectorIndex8";
  case MCK_MemTBB: return "MCK_MemTBB";
  case MCK_MemTBH: return "MCK_MemTBH";
  case MCK_MVEVectorIndex4: return "MCK_MVEVectorIndex4";
  case MCK_MVEVectorIndex8: return "MCK_MVEVectorIndex8";
  case MCK_MVEVectorIndex16: return "MCK_MVEVectorIndex16";
  case MCK_MVEVcvtImm32: return "MCK_MVEVcvtImm32";
  case MCK_MVEVcvtImm16: return "MCK_MVEVcvtImm16";
  case MCK_TMemImm7Shift2Offset: return "MCK_TMemImm7Shift2Offset";
  case MCK_TMemImm7Shift0Offset: return "MCK_TMemImm7Shift0Offset";
  case MCK_TMemImm7Shift1Offset: return "MCK_TMemImm7Shift1Offset";
  case MCK_Imm3b: return "MCK_Imm3b";
  case MCK_Imm4b: return "MCK_Imm4b";
  case MCK_Imm6b: return "MCK_Imm6b";
  case MCK_Imm7b: return "MCK_Imm7b";
  case MCK_Imm9b: return "MCK_Imm9b";
  case MCK_Imm11b: return "MCK_Imm11b";
  case MCK_Imm12b: return "MCK_Imm12b";
  case MCK_Imm13b: return "MCK_Imm13b";
  case MCK_MVEPairVectorIndex0: return "MCK_MVEPairVectorIndex0";
  case MCK_MVEPairVectorIndex2: return "MCK_MVEPairVectorIndex2";
  case MCK_ComplexRotationEven: return "MCK_ComplexRotationEven";
  case MCK_ComplexRotationOdd: return "MCK_ComplexRotationOdd";
  case MCK_NEONi16vmovi8Replicate: return "MCK_NEONi16vmovi8Replicate";
  case MCK_NEONi16invi8Replicate: return "MCK_NEONi16invi8Replicate";
  case MCK_NEONi32vmovi8Replicate: return "MCK_NEONi32vmovi8Replicate";
  case MCK_NEONi32invi8Replicate: return "MCK_NEONi32invi8Replicate";
  case MCK_NEONi64vmovi8Replicate: return "MCK_NEONi64vmovi8Replicate";
  case MCK_NEONi64invi8Replicate: return "MCK_NEONi64invi8Replicate";
  case MCK_NEONi32vmovi16Replicate: return "MCK_NEONi32vmovi16Replicate";
  case MCK_NEONi64vmovi16Replicate: return "MCK_NEONi64vmovi16Replicate";
  case MCK_NEONi64vmovi32Replicate: return "MCK_NEONi64vmovi32Replicate";
  case MCK_ConstPoolAsmImm: return "MCK_ConstPoolAsmImm";
  case MCK_FBits16: return "MCK_FBits16";
  case MCK_FBits32: return "MCK_FBits32";
  case MCK_Imm0_4095: return "MCK_Imm0_4095";
  case MCK_Imm0_4095Neg: return "MCK_Imm0_4095Neg";
  case MCK_ITMask: return "MCK_ITMask";
  case MCK_ITCondCode: return "MCK_ITCondCode";
  case MCK_LELabel: return "MCK_LELabel";
  case MCK_MVELongShift: return "MCK_MVELongShift";
  case MCK_NEONi16splat: return "MCK_NEONi16splat";
  case MCK_NEONi32splat: return "MCK_NEONi32splat";
  case MCK_NEONi64splat: return "MCK_NEONi64splat";
  case MCK_NEONi8splat: return "MCK_NEONi8splat";
  case MCK_NEONi16splatNot: return "MCK_NEONi16splatNot";
  case MCK_NEONi32splatNot: return "MCK_NEONi32splatNot";
  case MCK_NEONi32vmov: return "MCK_NEONi32vmov";
  case MCK_NEONi32vmovNeg: return "MCK_NEONi32vmovNeg";
  case MCK_CondCodeNoAL: return "MCK_CondCodeNoAL";
  case MCK_CondCodeNoALInv: return "MCK_CondCodeNoALInv";
  case MCK_CondCodeRestrictedFP: return "MCK_CondCodeRestrictedFP";
  case MCK_CondCodeRestrictedI: return "MCK_CondCodeRestrictedI";
  case MCK_CondCodeRestrictedS: return "MCK_CondCodeRestrictedS";
  case MCK_CondCodeRestrictedU: return "MCK_CondCodeRestrictedU";
  case MCK_ShrImm16: return "MCK_ShrImm16";
  case MCK_ShrImm32: return "MCK_ShrImm32";
  case MCK_ShrImm64: return "MCK_ShrImm64";
  case MCK_ShrImm8: return "MCK_ShrImm8";
  case MCK_T2SOImm: return "MCK_T2SOImm";
  case MCK_T2SOImmNeg: return "MCK_T2SOImmNeg";
  case MCK_T2SOImmNot: return "MCK_T2SOImmNot";
  case MCK_MemUImm12Offset: return "MCK_MemUImm12Offset";
  case MCK_T2MemRegOffset: return "MCK_T2MemRegOffset";
  case MCK_Imm7s4: return "MCK_Imm7s4";
  case MCK_Imm7Shift0: return "MCK_Imm7Shift0";
  case MCK_Imm7Shift1: return "MCK_Imm7Shift1";
  case MCK_Imm7Shift2: return "MCK_Imm7Shift2";
  case MCK_Imm8s4: return "MCK_Imm8s4";
  case MCK_MemPCRelImm12: return "MCK_MemPCRelImm12";
  case MCK_MemThumbRIs1: return "MCK_MemThumbRIs1";
  case MCK_MemThumbRIs2: return "MCK_MemThumbRIs2";
  case MCK_MemThumbRIs4: return "MCK_MemThumbRIs4";
  case MCK_MemThumbRR: return "MCK_MemThumbRR";
  case MCK_MemThumbSPI: return "MCK_MemThumbSPI";
  case MCK_Imm0_1020s4: return "MCK_Imm0_1020s4";
  case MCK_Imm0_508s4: return "MCK_Imm0_508s4";
  case MCK_Imm0_508s4Neg: return "MCK_Imm0_508s4Neg";
  case MCK_WLSLabel: return "MCK_WLSLabel";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset ARMAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[ARM::HasV4TOps])
    Features.set(Feature_HasV4TBit);
  if (FB[ARM::HasV5TOps])
    Features.set(Feature_HasV5TBit);
  if (FB[ARM::HasV5TEOps])
    Features.set(Feature_HasV5TEBit);
  if (FB[ARM::HasV6Ops])
    Features.set(Feature_HasV6Bit);
  if (FB[ARM::HasV6MOps])
    Features.set(Feature_HasV6MBit);
  if (FB[ARM::HasV8MBaselineOps])
    Features.set(Feature_HasV8MBaselineBit);
  if (FB[ARM::HasV8MMainlineOps])
    Features.set(Feature_HasV8MMainlineBit);
  if (FB[ARM::HasV8_1MMainlineOps])
    Features.set(Feature_HasV8_1MMainlineBit);
  if (FB[ARM::HasMVEIntegerOps])
    Features.set(Feature_HasMVEIntBit);
  if (FB[ARM::HasMVEFloatOps])
    Features.set(Feature_HasMVEFloatBit);
  if (FB[ARM::HasCDEOps])
    Features.set(Feature_HasCDEBit);
  if (FB[ARM::FeatureFPRegs])
    Features.set(Feature_HasFPRegsBit);
  if (FB[ARM::FeatureFPRegs16])
    Features.set(Feature_HasFPRegs16Bit);
  if (!FB[ARM::FeatureFPRegs16])
    Features.set(Feature_HasNoFPRegs16Bit);
  if (FB[ARM::FeatureFPRegs64])
    Features.set(Feature_HasFPRegs64Bit);
  if (FB[ARM::FeatureFPRegs] && FB[ARM::HasV8_1MMainlineOps])
    Features.set(Feature_HasFPRegsV8_1MBit);
  if (FB[ARM::HasV6T2Ops])
    Features.set(Feature_HasV6T2Bit);
  if (FB[ARM::HasV6KOps])
    Features.set(Feature_HasV6KBit);
  if (FB[ARM::HasV7Ops])
    Features.set(Feature_HasV7Bit);
  if (FB[ARM::HasV8Ops])
    Features.set(Feature_HasV8Bit);
  if (!FB[ARM::HasV8Ops])
    Features.set(Feature_PreV8Bit);
  if (FB[ARM::HasV8_1aOps])
    Features.set(Feature_HasV8_1aBit);
  if (FB[ARM::HasV8_2aOps])
    Features.set(Feature_HasV8_2aBit);
  if (FB[ARM::HasV8_3aOps])
    Features.set(Feature_HasV8_3aBit);
  if (FB[ARM::HasV8_4aOps])
    Features.set(Feature_HasV8_4aBit);
  if (FB[ARM::HasV8_5aOps])
    Features.set(Feature_HasV8_5aBit);
  if (FB[ARM::HasV8_6aOps])
    Features.set(Feature_HasV8_6aBit);
  if (FB[ARM::HasV8_7aOps])
    Features.set(Feature_HasV8_7aBit);
  if (FB[ARM::FeatureVFP2_SP])
    Features.set(Feature_HasVFP2Bit);
  if (FB[ARM::FeatureVFP3_D16_SP])
    Features.set(Feature_HasVFP3Bit);
  if (FB[ARM::FeatureVFP4_D16_SP])
    Features.set(Feature_HasVFP4Bit);
  if (FB[ARM::FeatureFP64])
    Features.set(Feature_HasDPVFPBit);
  if (FB[ARM::FeatureFPARMv8_D16_SP])
    Features.set(Feature_HasFPARMv8Bit);
  if (FB[ARM::FeatureNEON])
    Features.set(Feature_HasNEONBit);
  if (FB[ARM::FeatureSHA2])
    Features.set(Feature_HasSHA2Bit);
  if (FB[ARM::FeatureAES])
    Features.set(Feature_HasAESBit);
  if (FB[ARM::FeatureCrypto])
    Features.set(Feature_HasCryptoBit);
  if (FB[ARM::FeatureDotProd])
    Features.set(Feature_HasDotProdBit);
  if (FB[ARM::FeatureCRC])
    Features.set(Feature_HasCRCBit);
  if (FB[ARM::FeatureRAS])
    Features.set(Feature_HasRASBit);
  if (FB[ARM::FeatureLOB])
    Features.set(Feature_HasLOBBit);
  if (FB[ARM::FeaturePACBTI])
    Features.set(Feature_HasPACBTIBit);
  if (FB[ARM::FeatureFP16])
    Features.set(Feature_HasFP16Bit);
  if (FB[ARM::FeatureFullFP16])
    Features.set(Feature_HasFullFP16Bit);
  if (FB[ARM::FeatureFP16FML])
    Features.set(Feature_HasFP16FMLBit);
  if (FB[ARM::FeatureBF16])
    Features.set(Feature_HasBF16Bit);
  if (FB[ARM::FeatureMatMulInt8])
    Features.set(Feature_HasMatMulInt8Bit);
  if (FB[ARM::FeatureHWDivThumb])
    Features.set(Feature_HasDivideInThumbBit);
  if (FB[ARM::FeatureHWDivARM])
    Features.set(Feature_HasDivideInARMBit);
  if (FB[ARM::FeatureDSP])
    Features.set(Feature_HasDSPBit);
  if (FB[ARM::FeatureDB])
    Features.set(Feature_HasDBBit);
  if (FB[ARM::FeatureDFB])
    Features.set(Feature_HasDFBBit);
  if (FB[ARM::FeatureV7Clrex])
    Features.set(Feature_HasV7ClrexBit);
  if (FB[ARM::FeatureAcquireRelease])
    Features.set(Feature_HasAcquireReleaseBit);
  if (FB[ARM::FeatureMP])
    Features.set(Feature_HasMPBit);
  if (FB[ARM::FeatureVirtualization])
    Features.set(Feature_HasVirtualizationBit);
  if (FB[ARM::FeatureTrustZone])
    Features.set(Feature_HasTrustZoneBit);
  if (FB[ARM::Feature8MSecExt])
    Features.set(Feature_Has8MSecExtBit);
  if (FB[ARM::ModeThumb])
    Features.set(Feature_IsThumbBit);
  if (FB[ARM::ModeThumb] && FB[ARM::FeatureThumb2])
    Features.set(Feature_IsThumb2Bit);
  if (FB[ARM::FeatureMClass])
    Features.set(Feature_IsMClassBit);
  if (!FB[ARM::FeatureMClass])
    Features.set(Feature_IsNotMClassBit);
  if (!FB[ARM::ModeThumb])
    Features.set(Feature_IsARMBit);
  if (FB[ARM::FeatureNaClTrap])
    Features.set(Feature_UseNaClTrapBit);
  if (!FB[ARM::FeatureNoNegativeImmediates])
    Features.set(Feature_UseNegativeImmediatesBit);
  if (FB[ARM::FeatureSB])
    Features.set(Feature_HasSBBit);
  if (FB[ARM::FeatureCLRBHB])
    Features.set(Feature_HasCLRBHBBit);
  return Features;
}

static const char MnemonicTable[] =
    "\t__brkdiv0\003adc\003add\004addw\003adr\004aesd\004aese\006aesimc\005a"
    "esmc\003and\003asr\004asrl\003aut\004autg\001b\002bf\003bfc\006bfcsel\003"
    "bfi\003bfl\004bflx\003bfx\003bic\004bkpt\002bl\003blx\005blxns\003bti\002"
    "bx\005bxaut\003bxj\004bxns\004cbnz\003cbz\003cdp\004cdp2\004cinc\004cin"
    "v\006clrbhb\005clrex\004clrm\003clz\003cmn\003cmp\004cneg\003cps\006crc"
    "32b\007crc32cb\007crc32ch\007crc32cw\006crc32h\006crc32w\004csdb\004cse"
    "l\004cset\005csetm\005csinc\005csinv\005csneg\003cx1\004cx1a\004cx1d\005"
    "cx1da\003cx2\004cx2a\004cx2d\005cx2da\003cx3\004cx3a\004cx3d\005cx3da\003"
    "dbg\005dcps1\005dcps2\005dcps3\003dfb\003dls\005dlstp\003dmb\003dsb\003"
    "eor\004eret\003esb\005faddd\005fadds\006fcmpzd\006fcmpzs\007fconstd\007"
    "fconsts\007fldmdbx\007fldmiax\005fmdhr\005fmdlr\006fmstat\007fstmdbx\007"
    "fstmiax\005fsubd\005fsubs\004hint\003hlt\003hvc\003isb\002it\004lctp\003"
    "lda\004ldab\005ldaex\006ldaexb\006ldaexd\006ldaexh\004ldah\003ldc\004ld"
    "c2\005ldc2l\004ldcl\003ldm\005ldmda\005ldmdb\005ldmib\003ldr\004ldrb\005"
    "ldrbt\004ldrd\005ldrex\006ldrexb\006ldrexd\006ldrexh\004ldrh\005ldrht\005"
    "ldrsb\006ldrsbt\005ldrsh\006ldrsht\004ldrt\002le\004letp\003lsl\004lsll"
    "\003lsr\004lsrl\003mcr\004mcr2\004mcrr\005mcrr2\003mla\003mls\003mov\004"
    "movs\004movt\004movw\003mrc\004mrc2\004mrrc\005mrrc2\003mrs\003msr\003m"
    "ul\003mvn\003neg\003nop\003orn\003orr\003pac\006pacbti\004pacg\005pkhbt"
    "\005pkhtb\003pld\004pldw\003pli\003pop\005pssbb\004push\004qadd\006qadd"
    "16\005qadd8\004qasx\005qdadd\005qdsub\004qsax\004qsub\006qsub16\005qsub"
    "8\004rbit\003rev\005rev16\005revsh\005rfeda\005rfedb\005rfeia\005rfeib\003"
    "ror\003rrx\003rsb\003rsc\006sadd16\005sadd8\004sasx\002sb\003sbc\004sbf"
    "x\004sdiv\003sel\006setend\006setpan\003sev\004sevl\002sg\005sha1c\005s"
    "ha1h\005sha1m\005sha1p\007sha1su0\007sha1su1\007sha256h\010sha256h2\tsh"
    "a256su0\tsha256su1\007shadd16\006shadd8\005shasx\005shsax\007shsub16\006"
    "shsub8\003smc\006smlabb\006smlabt\005smlad\006smladx\005smlal\007smlalb"
    "b\007smlalbt\006smlald\007smlaldx\007smlaltb\007smlaltt\006smlatb\006sm"
    "latt\006smlawb\006smlawt\005smlsd\006smlsdx\006smlsld\007smlsldx\005smm"
    "la\006smmlar\005smmls\006smmlsr\005smmul\006smmulr\005smuad\006smuadx\006"
    "smulbb\006smulbt\005smull\006smultb\006smultt\006smulwb\006smulwt\005sm"
    "usd\006smusdx\006sqrshr\007sqrshrl\005sqshl\006sqshll\005srsda\005srsdb"
    "\005srshr\006srshrl\005srsia\005srsib\004ssat\006ssat16\004ssax\004ssbb"
    "\006ssub16\005ssub8\003stc\004stc2\005stc2l\004stcl\003stl\004stlb\005s"
    "tlex\006stlexb\006stlexd\006stlexh\004stlh\003stm\005stmda\005stmdb\005"
    "stmib\003str\004strb\005strbt\004strd\005strex\006strexb\006strexd\006s"
    "trexh\004strh\005strht\004strt\003sub\004subs\004subw\003svc\003swp\004"
    "swpb\005sxtab\007sxtab16\005sxtah\004sxtb\006sxtb16\004sxth\003tbb\003t"
    "bh\003teq\004trap\003tsb\003tst\002tt\003tta\004ttat\003ttt\006uadd16\005"
    "uadd8\004uasx\004ubfx\003udf\004udiv\007uhadd16\006uhadd8\005uhasx\005u"
    "hsax\007uhsub16\006uhsub8\005umaal\005umlal\005umull\007uqadd16\006uqad"
    "d8\005uqasx\006uqrshl\007uqrshll\005uqsax\005uqshl\006uqshll\007uqsub16"
    "\006uqsub8\005urshr\006urshrl\005usad8\006usada8\004usat\006usat16\004u"
    "sax\006usub16\005usub8\005uxtab\007uxtab16\005uxtah\004uxtb\006uxtb16\004"
    "uxth\004vaba\005vabal\005vabav\004vabd\005vabdl\004vabs\005vacge\005vac"
    "gt\005vacle\005vaclt\004vadc\005vadci\004vadd\006vaddhn\005vaddl\006vad"
    "dlv\007vaddlva\005vaddv\006vaddva\005vaddw\004vand\004vbic\004vbif\004v"
    "bit\005vbrsr\004vbsl\005vcadd\004vceq\004vcge\004vcgt\004vcle\004vcls\004"
    "vclt\004vclz\005vcmla\004vcmp\005vcmpe\005vcmul\004vcnt\004vctp\004vcvt"
    "\005vcvta\005vcvtb\005vcvtm\005vcvtn\005vcvtp\005vcvtr\005vcvtt\004vcx1"
    "\005vcx1a\004vcx2\005vcx2a\004vcx3\005vcx3a\005vddup\004vdiv\004vdot\004"
    "vdup\006vdwdup\004veor\004vext\004vfma\005vfmab\005vfmal\005vfmas\005vf"
    "mat\004vfms\005vfmsl\005vfnma\005vfnms\005vhadd\006vhcadd\005vhsub\005v"
    "idup\004vins\006viwdup\005vjcvt\004vld1\004vld2\005vld20\005vld21\004vl"
    "d3\004vld4\005vld40\005vld41\005vld42\005vld43\006vldmdb\006vldmia\004v"
    "ldr\005vldrb\005vldrd\005vldrh\005vldrw\005vlldm\005vlstm\004vmax\005vm"
    "axa\006vmaxav\006vmaxnm\007vmaxnma\010vmaxnmav\007vmaxnmv\005vmaxv\004v"
    "min\005vmina\006vminav\006vminnm\007vminnma\010vminnmav\007vminnmv\005v"
    "minv\004vmla\007vmladav\010vmladava\tvmladavax\010vmladavx\005vmlal\010"
    "vmlaldav\tvmlaldava\nvmlaldavax\tvmlaldavx\006vmlalv\007vmlalva\005vmla"
    "s\005vmlav\006vmlava\004vmls\007vmlsdav\010vmlsdava\tvmlsdavax\010vmlsd"
    "avx\005vmlsl\010vmlsldav\tvmlsldava\nvmlsldavax\tvmlsldavx\005vmmla\004"
    "vmov\005vmovl\006vmovlb\006vmovlt\005vmovn\006vmovnb\006vmovnt\005vmovx"
    "\004vmrs\004vmsr\004vmul\005vmulh\005vmull\006vmullb\006vmullt\004vmvn\004"
    "vneg\005vnmla\005vnmls\005vnmul\004vorn\004vorr\006vpadal\005vpadd\006v"
    "paddl\005vpmax\005vpmin\005vpnot\004vpop\005vpsel\004vpst\003vpt\005vpu"
    "sh\005vqabs\005vqadd\010vqdmladh\tvqdmladhx\007vqdmlah\007vqdmlal\010vq"
    "dmlash\010vqdmlsdh\tvqdmlsdhx\007vqdmlsl\007vqdmulh\007vqdmull\010vqdmu"
    "llb\010vqdmullt\006vqmovn\007vqmovnb\007vqmovnt\007vqmovun\010vqmovunb\010"
    "vqmovunt\005vqneg\tvqrdmladh\nvqrdmladhx\010vqrdmlah\tvqrdmlash\tvqrdml"
    "sdh\nvqrdmlsdhx\010vqrdmlsh\010vqrdmulh\006vqrshl\007vqrshrn\010vqrshrn"
    "b\010vqrshrnt\010vqrshrun\tvqrshrunb\tvqrshrunt\005vqshl\006vqshlu\006v"
    "qshrn\007vqshrnb\007vqshrnt\007vqshrun\010vqshrunb\010vqshrunt\005vqsub"
    "\007vraddhn\006vrecpe\006vrecps\006vrev16\006vrev32\006vrev64\006vrhadd"
    "\006vrinta\006vrintm\006vrintn\006vrintp\006vrintr\006vrintx\006vrintz\n"
    "vrmlaldavh\013vrmlaldavha\014vrmlaldavhax\013vrmlaldavhx\010vrmlalvh\tv"
    "rmlalvha\nvrmlsldavh\013vrmlsldavha\014vrmlsldavhax\013vrmlsldavhx\006v"
    "rmulh\005vrshl\005vrshr\006vrshrn\007vrshrnb\007vrshrnt\007vrsqrte\007v"
    "rsqrts\005vrsra\007vrsubhn\004vsbc\005vsbci\007vscclrm\005vsdot\006vsel"
    "eq\006vselge\006vselgt\006vselvs\004vshl\005vshlc\005vshll\006vshllb\006"
    "vshllt\004vshr\005vshrn\006vshrnb\006vshrnt\004vsli\006vsmmla\005vsqrt\004"
    "vsra\004vsri\004vst1\004vst2\005vst20\005vst21\004vst3\004vst4\005vst40"
    "\005vst41\005vst42\005vst43\006vstmdb\006vstmia\004vstr\005vstrb\005vst"
    "rd\005vstrh\005vstrw\004vsub\006vsubhn\005vsubl\005vsubw\006vsudot\004v"
    "swp\004vtbl\004vtbx\004vtrn\004vtst\005vudot\006vummla\006vusdot\007vus"
    "mmla\004vuzp\004vzip\003wfe\003wfi\003wls\005wlstp\005yield";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_Has8MSecExt,
  AMFBS_HasBF16,
  AMFBS_HasCDE,
  AMFBS_HasDB,
  AMFBS_HasDFB,
  AMFBS_HasDotProd,
  AMFBS_HasFP16,
  AMFBS_HasFPARMv8,
  AMFBS_HasFPRegs,
  AMFBS_HasFPRegs16,
  AMFBS_HasFPRegs64,
  AMFBS_HasFPRegsV8_1M,
  AMFBS_HasFullFP16,
  AMFBS_HasMVEFloat,
  AMFBS_HasMVEInt,
  AMFBS_HasMatMulInt8,
  AMFBS_HasNEON,
  AMFBS_HasV8_1MMainline,
  AMFBS_HasVFP2,
  AMFBS_HasVFP3,
  AMFBS_HasVFP4,
  AMFBS_IsARM,
  AMFBS_IsThumb,
  AMFBS_IsThumb2,
  AMFBS_HasBF16_HasNEON,
  AMFBS_HasCDE_HasFPRegs,
  AMFBS_HasCDE_HasMVEInt,
  AMFBS_HasDB_IsThumb2,
  AMFBS_HasDSP_IsThumb2,
  AMFBS_HasFPARMv8_HasDPVFP,
  AMFBS_HasFPARMv8_HasNEON,
  AMFBS_HasFPARMv8_HasV8_3a,
  AMFBS_HasFPRegs_HasV8_1MMainline,
  AMFBS_HasMVEInt_IsThumb,
  AMFBS_HasNEON_HasFP16,
  AMFBS_HasNEON_HasFP16FML,
  AMFBS_HasNEON_HasFullFP16,
  AMFBS_HasNEON_HasV8_1a,
  AMFBS_HasNEON_HasV8_3a,
  AMFBS_HasNEON_HasVFP4,
  AMFBS_HasV7_IsMClass,
  AMFBS_HasV8_HasAES,
  AMFBS_HasV8_HasNEON,
  AMFBS_HasV8_HasSHA2,
  AMFBS_HasV8MMainline_Has8MSecExt,
  AMFBS_HasV8_1MMainline_Has8MSecExt,
  AMFBS_HasV8_1MMainline_HasFPRegs,
  AMFBS_HasV8_1MMainline_HasMVEInt,
  AMFBS_HasVFP2_HasDPVFP,
  AMFBS_HasVFP3_HasDPVFP,
  AMFBS_HasVFP4_HasDPVFP,
  AMFBS_IsARM_HasAcquireRelease,
  AMFBS_IsARM_HasCRC,
  AMFBS_IsARM_HasDB,
  AMFBS_IsARM_HasDFB,
  AMFBS_IsARM_HasDivideInARM,
  AMFBS_IsARM_HasRAS,
  AMFBS_IsARM_HasSB,
  AMFBS_IsARM_HasTrustZone,
  AMFBS_IsARM_HasV4T,
  AMFBS_IsARM_HasV5T,
  AMFBS_IsARM_HasV5TE,
  AMFBS_IsARM_HasV6,
  AMFBS_IsARM_HasV6K,
  AMFBS_IsARM_HasV6T2,
  AMFBS_IsARM_HasV7,
  AMFBS_IsARM_HasV8,
  AMFBS_IsARM_HasV8_4a,
  AMFBS_IsARM_HasVirtualization,
  AMFBS_IsARM_PreV8,
  AMFBS_IsARM_UseNaClTrap,
  AMFBS_IsARM_UseNegativeImmediates,
  AMFBS_IsThumb_Has8MSecExt,
  AMFBS_IsThumb_HasAcquireRelease,
  AMFBS_IsThumb_HasDB,
  AMFBS_IsThumb_HasV5T,
  AMFBS_IsThumb_HasV6,
  AMFBS_IsThumb_HasV6M,
  AMFBS_IsThumb_HasV7Clrex,
  AMFBS_IsThumb_HasV8,
  AMFBS_IsThumb_HasV8MBaseline,
  AMFBS_IsThumb_HasV8_4a,
  AMFBS_IsThumb_HasVirtualization,
  AMFBS_IsThumb_IsMClass,
  AMFBS_IsThumb_IsNotMClass,
  AMFBS_IsThumb_UseNegativeImmediates,
  AMFBS_IsThumb2_HasCRC,
  AMFBS_IsThumb2_HasDSP,
  AMFBS_IsThumb2_HasRAS,
  AMFBS_IsThumb2_HasSB,
  AMFBS_IsThumb2_HasTrustZone,
  AMFBS_IsThumb2_HasV7,
  AMFBS_IsThumb2_HasV8,
  AMFBS_IsThumb2_HasVirtualization,
  AMFBS_IsThumb2_IsNotMClass,
  AMFBS_IsThumb2_PreV8,
  AMFBS_IsThumb2_UseNegativeImmediates,
  AMFBS_PreV8_IsThumb2,
  AMFBS_HasDivideInThumb_IsThumb_HasV8MBaseline,
  AMFBS_HasFPARMv8_HasNEON_HasFullFP16,
  AMFBS_HasNEON_HasV8_3a_HasFullFP16,
  AMFBS_HasV8_HasNEON_HasFullFP16,
  AMFBS_IsARM_HasAcquireRelease_HasV7Clrex,
  AMFBS_IsARM_HasV7_HasMP,
  AMFBS_IsARM_HasV8_HasCLRBHB,
  AMFBS_IsARM_HasV8_HasV8_1a,
  AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex,
  AMFBS_IsThumb_HasV5T_IsNotMClass,
  AMFBS_IsThumb2_HasV7_HasMP,
  AMFBS_IsThumb2_HasV8_HasCLRBHB,
  AMFBS_IsThumb2_HasV8_HasV8_1a,
  AMFBS_IsThumb2_HasV8_1MMainline_HasLOB,
  AMFBS_IsThumb2_HasV8_1MMainline_HasPACBTI,
  AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex_IsNotMClass,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_Has8MSecExtBit, },
  {Feature_HasBF16Bit, },
  {Feature_HasCDEBit, },
  {Feature_HasDBBit, },
  {Feature_HasDFBBit, },
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFPRegs16Bit, },
  {Feature_HasFPRegs64Bit, },
  {Feature_HasFPRegsV8_1MBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasV8_1MMainlineBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasCDEBit, Feature_HasFPRegsBit, },
  {Feature_HasCDEBit, Feature_HasMVEIntBit, },
  {Feature_HasDBBit, Feature_IsThumb2Bit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasFPARMv8Bit, Feature_HasDPVFPBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasV8_3aBit, },
  {Feature_HasFPRegsBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsThumbBit, },
  {Feature_HasNEONBit, Feature_HasFP16Bit, },
  {Feature_HasNEONBit, Feature_HasFP16FMLBit, },
  {Feature_HasNEONBit, Feature_HasFullFP16Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasV7Bit, Feature_IsMClassBit, },
  {Feature_HasV8Bit, Feature_HasAESBit, },
  {Feature_HasV8Bit, Feature_HasNEONBit, },
  {Feature_HasV8Bit, Feature_HasSHA2Bit, },
  {Feature_HasV8MMainlineBit, Feature_Has8MSecExtBit, },
  {Feature_HasV8_1MMainlineBit, Feature_Has8MSecExtBit, },
  {Feature_HasV8_1MMainlineBit, Feature_HasFPRegsBit, },
  {Feature_HasV8_1MMainlineBit, Feature_HasMVEIntBit, },
  {Feature_HasVFP2Bit, Feature_HasDPVFPBit, },
  {Feature_HasVFP3Bit, Feature_HasDPVFPBit, },
  {Feature_HasVFP4Bit, Feature_HasDPVFPBit, },
  {Feature_IsARMBit, Feature_HasAcquireReleaseBit, },
  {Feature_IsARMBit, Feature_HasCRCBit, },
  {Feature_IsARMBit, Feature_HasDBBit, },
  {Feature_IsARMBit, Feature_HasDFBBit, },
  {Feature_IsARMBit, Feature_HasDivideInARMBit, },
  {Feature_IsARMBit, Feature_HasRASBit, },
  {Feature_IsARMBit, Feature_HasSBBit, },
  {Feature_IsARMBit, Feature_HasTrustZoneBit, },
  {Feature_IsARMBit, Feature_HasV4TBit, },
  {Feature_IsARMBit, Feature_HasV5TBit, },
  {Feature_IsARMBit, Feature_HasV5TEBit, },
  {Feature_IsARMBit, Feature_HasV6Bit, },
  {Feature_IsARMBit, Feature_HasV6KBit, },
  {Feature_IsARMBit, Feature_HasV6T2Bit, },
  {Feature_IsARMBit, Feature_HasV7Bit, },
  {Feature_IsARMBit, Feature_HasV8Bit, },
  {Feature_IsARMBit, Feature_HasV8_4aBit, },
  {Feature_IsARMBit, Feature_HasVirtualizationBit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsARMBit, Feature_UseNaClTrapBit, },
  {Feature_IsARMBit, Feature_UseNegativeImmediatesBit, },
  {Feature_IsThumbBit, Feature_Has8MSecExtBit, },
  {Feature_IsThumbBit, Feature_HasAcquireReleaseBit, },
  {Feature_IsThumbBit, Feature_HasDBBit, },
  {Feature_IsThumbBit, Feature_HasV5TBit, },
  {Feature_IsThumbBit, Feature_HasV6Bit, },
  {Feature_IsThumbBit, Feature_HasV6MBit, },
  {Feature_IsThumbBit, Feature_HasV7ClrexBit, },
  {Feature_IsThumbBit, Feature_HasV8Bit, },
  {Feature_IsThumbBit, Feature_HasV8MBaselineBit, },
  {Feature_IsThumbBit, Feature_HasV8_4aBit, },
  {Feature_IsThumbBit, Feature_HasVirtualizationBit, },
  {Feature_IsThumbBit, Feature_IsMClassBit, },
  {Feature_IsThumbBit, Feature_IsNotMClassBit, },
  {Feature_IsThumbBit, Feature_UseNegativeImmediatesBit, },
  {Feature_IsThumb2Bit, Feature_HasCRCBit, },
  {Feature_IsThumb2Bit, Feature_HasDSPBit, },
  {Feature_IsThumb2Bit, Feature_HasRASBit, },
  {Feature_IsThumb2Bit, Feature_HasSBBit, },
  {Feature_IsThumb2Bit, Feature_HasTrustZoneBit, },
  {Feature_IsThumb2Bit, Feature_HasV7Bit, },
  {Feature_IsThumb2Bit, Feature_HasV8Bit, },
  {Feature_IsThumb2Bit, Feature_HasVirtualizationBit, },
  {Feature_IsThumb2Bit, Feature_IsNotMClassBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseNegativeImmediatesBit, },
  {Feature_PreV8Bit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInThumbBit, Feature_IsThumbBit, Feature_HasV8MBaselineBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, Feature_HasFullFP16Bit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, Feature_HasFullFP16Bit, },
  {Feature_HasV8Bit, Feature_HasNEONBit, Feature_HasFullFP16Bit, },
  {Feature_IsARMBit, Feature_HasAcquireReleaseBit, Feature_HasV7ClrexBit, },
  {Feature_IsARMBit, Feature_HasV7Bit, Feature_HasMPBit, },
  {Feature_IsARMBit, Feature_HasV8Bit, Feature_HasCLRBHBBit, },
  {Feature_IsARMBit, Feature_HasV8Bit, Feature_HasV8_1aBit, },
  {Feature_IsThumbBit, Feature_HasAcquireReleaseBit, Feature_HasV7ClrexBit, },
  {Feature_IsThumbBit, Feature_HasV5TBit, Feature_IsNotMClassBit, },
  {Feature_IsThumb2Bit, Feature_HasV7Bit, Feature_HasMPBit, },
  {Feature_IsThumb2Bit, Feature_HasV8Bit, Feature_HasCLRBHBBit, },
  {Feature_IsThumb2Bit, Feature_HasV8Bit, Feature_HasV8_1aBit, },
  {Feature_IsThumb2Bit, Feature_HasV8_1MMainlineBit, Feature_HasLOBBit, },
  {Feature_IsThumb2Bit, Feature_HasV8_1MMainlineBit, Feature_HasPACBTIBit, },
  {Feature_IsThumbBit, Feature_HasAcquireReleaseBit, Feature_HasV7ClrexBit, Feature_IsNotMClassBit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint16_t Classes[18];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* __brkdiv0 */, ARM::t__brkdiv0, Convert_NoOperands, AMFBS_IsThumb, {  }, },
  { 10 /* adc */, ARM::tADC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 10 /* adc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 10 /* adc */, ARM::ADCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 10 /* adc */, ARM::ADCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 10 /* adc */, ARM::ADCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 10 /* adc */, ARM::SBCri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 10 /* adc */, ARM::ADCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 10 /* adc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 10 /* adc */, ARM::ADCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 10 /* adc */, ARM::ADCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10 /* adc */, ARM::ADCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 10 /* adc */, ARM::SBCri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 10 /* adc */, ARM::ADCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 10 /* adc */, ARM::t2ADCrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 10 /* adc */, ARM::t2ADCrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::tADDspr, Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPR }, },
  { 14 /* add */, ARM::tADDspi, Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 14 /* add */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_2__CondCode2_0, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4Neg }, },
  { 14 /* add */, ARM::tADDhirr, Convert__Reg1_1__Tie0_1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::tADDrr, Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 14 /* add */, ARM::tADDi8, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_255Expr1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255Expr }, },
  { 14 /* add */, ARM::tSUBi8, Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ThumbModImmNeg8_255 }, },
  { 14 /* add */, ARM::tADDspi, Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 14 /* add */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s4Neg1_3__CondCode2_0, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4Neg }, },
  { 14 /* add */, ARM::tADDrSPi, Convert__Reg1_1__Reg1_2__Imm0_1020s41_3__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_GPRsp, MCK_Imm0_1020s4 }, },
  { 14 /* add */, ARM::tADDrSP, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPRsp, MCK_GPR }, },
  { 14 /* add */, ARM::tADDrr, Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 14 /* add */, ARM::tADDi3, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_7 }, },
  { 14 /* add */, ARM::tSUBi3, Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ThumbModImmNeg1_7 }, },
  { 14 /* add */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::t2ADDspImm, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::ADDri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 14 /* add */, ARM::SUBri, Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNeg }, },
  { 14 /* add */, ARM::ADDrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 14 /* add */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::t2ADR, Convert__Reg1_1__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_PC, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095 }, },
  { 14 /* add */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 14 /* add */, ARM::t2ADDspImm, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDspImm, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14 /* add */, ARM::ADDri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 14 /* add */, ARM::SUBri, Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNeg }, },
  { 14 /* add */, ARM::ADDrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 14 /* add */, ARM::ADDrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 14 /* add */, ARM::t2ADDspImm, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBspImm, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImm }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 14 /* add */, ARM::t2ADDrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 14 /* add */, ARM::t2ADDrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 18 /* addw */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 18 /* addw */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095 }, },
  { 18 /* addw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_4095Neg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 18 /* addw */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_4095Neg }, },
  { 18 /* addw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095 }, },
  { 23 /* adr */, ARM::tADR, Convert__Reg1_1__UnsignedOffset_b8s21_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_UnsignedOffset_b8s2 }, },
  { 23 /* adr */, ARM::t2ADR, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 23 /* adr */, ARM::ADR, Convert__Reg1_1__AdrLabel1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AdrLabel }, },
  { 23 /* adr */, ARM::t2ADR, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm }, },
  { 27 /* aesd */, ARM::AESD, Convert__Reg1_1__Tie0_1_1__Reg1_2, AMFBS_HasV8_HasAES, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 32 /* aese */, ARM::AESE, Convert__Reg1_1__Tie0_1_1__Reg1_2, AMFBS_HasV8_HasAES, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 37 /* aesimc */, ARM::AESIMC, Convert__Reg1_1__Reg1_2, AMFBS_HasV8_HasAES, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 44 /* aesmc */, ARM::AESMC, Convert__Reg1_1__Reg1_2, AMFBS_HasV8_HasAES, { MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 50 /* and */, ARM::tAND, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::ANDrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 50 /* and */, ARM::ANDri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 50 /* and */, ARM::BICri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 50 /* and */, ARM::ANDrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::ANDrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 50 /* and */, ARM::ANDrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 50 /* and */, ARM::ANDri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 50 /* and */, ARM::BICri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 50 /* and */, ARM::ANDrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::ANDrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 50 /* and */, ARM::t2ANDrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 50 /* and */, ARM::t2ANDrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 50 /* and */, ARM::t2ANDri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 50 /* and */, ARM::t2BICri, Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 54 /* asr */, ARM::tASRrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 54 /* asr */, ARM::tASRri, Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::tASRri, Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::ASRr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 54 /* asr */, ARM::ASRi, Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_32 }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 54 /* asr */, ARM::ASRr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 54 /* asr */, ARM::ASRi, Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_32 }, },
  { 54 /* asr */, ARM::t2ASRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 54 /* asr */, ARM::t2ASRri, Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 58 /* asrl */, ARM::MVE_ASRLr, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_rGPR }, },
  { 58 /* asrl */, ARM::MVE_ASRLi, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 63 /* aut */, ARM::t2AUT, Convert_NoOperands, AMFBS_HasV7_IsMClass, { MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 63 /* aut */, ARM::t2HINT, Convert__imm_95_45__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 67 /* autg */, ARM::t2AUTG, Convert__CondCode2_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_IsThumb2_HasV8_1MMainline_HasPACBTI, { MCK_CondCode, MCK_GPRnosp, MCK_GPRnopc, MCK_GPRnopc }, },
  { 72 /* b */, ARM::tB, ConvertCustom_cvtThumbBranches, AMFBS_IsThumb, { MCK_CondCode, MCK_Imm }, },
  { 72 /* b */, ARM::tBcc, ConvertCustom_cvtThumbBranches, AMFBS_IsThumb, { MCK_CondCode, MCK_ThumbBranchTarget }, },
  { 72 /* b */, ARM::Bcc, Convert__ARMBranchTarget1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 72 /* b */, ARM::t2Bcc, ConvertCustom_cvtThumbBranches, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm }, },
  { 72 /* b */, ARM::t2B, ConvertCustom_cvtThumbBranches, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK__DOT_w, MCK_ThumbBranchTarget }, },
  { 74 /* bf */, ARM::t2BFi, Convert__Imm1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_CondCode, MCK_Imm, MCK_Imm }, },
  { 77 /* bfc */, ARM::t2BFC, Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Bitfield }, },
  { 77 /* bfc */, ARM::BFC, Convert__Reg1_1__Tie0_1_1__Bitfield1_2__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Bitfield }, },
  { 81 /* bfcsel */, ARM::t2BFic, Convert__Imm1_0__Imm1_1__Imm1_2__CondCodeNoAL1_3, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_Imm, MCK_Imm, MCK_Imm, MCK_CondCodeNoAL }, },
  { 88 /* bfi */, ARM::t2BFI, Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Bitfield }, },
  { 88 /* bfi */, ARM::BFI, Convert__Reg1_1__Tie0_1_1__Reg1_2__Bitfield1_3__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_Bitfield }, },
  { 92 /* bfl */, ARM::t2BFLi, Convert__Imm1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_CondCode, MCK_Imm, MCK_Imm }, },
  { 96 /* bflx */, ARM::t2BFLr, Convert__Imm1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_CondCode, MCK_Imm, MCK_rGPR }, },
  { 101 /* bfx */, ARM::t2BFr, Convert__Imm1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_CondCode, MCK_Imm, MCK_rGPR }, },
  { 105 /* bic */, ARM::tBIC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 105 /* bic */, ARM::t2BICrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 105 /* bic */, ARM::t2BICrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::t2BICri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 105 /* bic */, ARM::t2ANDri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 105 /* bic */, ARM::BICrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 105 /* bic */, ARM::BICri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 105 /* bic */, ARM::ANDri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 105 /* bic */, ARM::BICrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::BICrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 105 /* bic */, ARM::t2BICrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 105 /* bic */, ARM::t2BICrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::t2BICri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 105 /* bic */, ARM::t2ANDri, Convert__Reg1_3__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImmNot }, },
  { 105 /* bic */, ARM::t2BICrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 105 /* bic */, ARM::t2BICrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::t2BICri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 105 /* bic */, ARM::t2ANDri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 105 /* bic */, ARM::BICrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 105 /* bic */, ARM::BICri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 105 /* bic */, ARM::ANDri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 105 /* bic */, ARM::BICrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::BICrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 105 /* bic */, ARM::t2BICrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 105 /* bic */, ARM::t2BICrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 105 /* bic */, ARM::t2BICri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 105 /* bic */, ARM::t2ANDri, Convert__Reg1_3__Reg1_4__T2SOImmNot1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 109 /* bkpt */, ARM::tBKPT, Convert__imm_95_0, AMFBS_IsThumb, {  }, },
  { 109 /* bkpt */, ARM::tBKPT, Convert__Imm0_2551_0, AMFBS_IsThumb, { MCK_Imm0_255 }, },
  { 109 /* bkpt */, ARM::BKPT, Convert__imm_95_0, AMFBS_IsARM, {  }, },
  { 109 /* bkpt */, ARM::BKPT, Convert__Imm0_655351_0, AMFBS_IsARM, { MCK_Imm0_65535 }, },
  { 114 /* bl */, ARM::BL, Convert__ARMBranchTarget1_0, AMFBS_IsARM, { MCK_ARMBranchTarget }, },
  { 114 /* bl */, ARM::BL_pred, Convert__ARMBranchTarget1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 114 /* bl */, ARM::tBL, Convert__CondCode2_0__ThumbBranchTarget1_1, AMFBS_IsThumb, { MCK_CondCode, MCK_ThumbBranchTarget }, },
  { 114 /* bl */, ARM::tBL, Convert__CondCode2_0__ThumbBranchTarget1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_ThumbBranchTarget }, },
  { 117 /* blx */, ARM::tBLXr, Convert__CondCode2_0__Reg1_1, AMFBS_IsThumb_HasV5T, { MCK_CondCode, MCK_GPR }, },
  { 117 /* blx */, ARM::BLX, Convert__Reg1_0, AMFBS_IsARM_HasV5T, { MCK_GPR }, },
  { 117 /* blx */, ARM::BLXi, Convert__ThumbBranchTarget1_0, AMFBS_IsARM_HasV5T, { MCK_ThumbBranchTarget }, },
  { 117 /* blx */, ARM::BLX_pred, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM_HasV5T, { MCK_CondCode, MCK_GPR }, },
  { 117 /* blx */, ARM::tBLXi, Convert__CondCode2_0__ARMBranchTarget1_1, AMFBS_IsThumb_HasV5T_IsNotMClass, { MCK_CondCode, MCK_ARMBranchTarget }, },
  { 121 /* blxns */, ARM::tBLXNSr, Convert__CondCode2_0__Reg1_1, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 127 /* bti */, ARM::t2BTI, Convert_NoOperands, AMFBS_HasV7_IsMClass, {  }, },
  { 127 /* bti */, ARM::t2HINT, Convert__imm_95_15__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode }, },
  { 131 /* bx */, ARM::tBX, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPR }, },
  { 131 /* bx */, ARM::BX, Convert__Reg1_0, AMFBS_IsARM_HasV4T, { MCK_GPR }, },
  { 131 /* bx */, ARM::BX_RET, Convert__CondCode2_0, AMFBS_IsARM_HasV4T, { MCK_CondCode, MCK_GPRlr }, },
  { 131 /* bx */, ARM::BX_pred, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM_HasV4T, { MCK_CondCode, MCK_GPR }, },
  { 134 /* bxaut */, ARM::t2BXAUT, Convert__CondCode2_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_IsThumb2_HasV8_1MMainline_HasPACBTI, { MCK_CondCode, MCK_GPRnosp, MCK_rGPR, MCK_GPRnopc }, },
  { 140 /* bxj */, ARM::t2BXJ, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPRnopc }, },
  { 140 /* bxj */, ARM::BXJ, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR }, },
  { 144 /* bxns */, ARM::tBXNS, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_GPR }, },
  { 149 /* cbnz */, ARM::tCBNZ, Convert__Reg1_0__ThumbBranchTarget1_1, AMFBS_IsThumb_HasV8MBaseline, { MCK_tGPR, MCK_ThumbBranchTarget }, },
  { 154 /* cbz */, ARM::tCBZ, Convert__Reg1_0__ThumbBranchTarget1_1, AMFBS_IsThumb_HasV8MBaseline, { MCK_tGPR, MCK_ThumbBranchTarget }, },
  { 158 /* cdp */, ARM::CDP, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsARM_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 158 /* cdp */, ARM::t2CDP, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 162 /* cdp2 */, ARM::CDP2, Convert__CoprocNum1_0__Imm0_151_1__CoprocReg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 162 /* cdp2 */, ARM::t2CDP2, Convert__CoprocNum1_1__Imm0_151_2__CoprocReg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_CoprocReg, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 167 /* cinc */, ARM::t2CSINC, Convert__Reg1_0__Reg1_1__Reg1_1__CondCodeNoALInv1_2, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_CondCodeNoALInv }, },
  { 172 /* cinv */, ARM::t2CSINV, Convert__Reg1_0__Reg1_1__Reg1_1__CondCodeNoALInv1_2, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_CondCodeNoALInv }, },
  { 177 /* clrbhb */, ARM::HINT, Convert__imm_95_22__CondCode2_0, AMFBS_IsARM_HasV8_HasCLRBHB, { MCK_CondCode }, },
  { 177 /* clrbhb */, ARM::t2HINT, Convert__imm_95_22__CondCode2_0, AMFBS_IsThumb2_HasV8_HasCLRBHB, { MCK_CondCode }, },
  { 177 /* clrbhb */, ARM::HINT, Convert__imm_95_22__CondCode2_0, AMFBS_IsARM_HasV8, { MCK_CondCode }, },
  { 177 /* clrbhb */, ARM::t2HINT, Convert__imm_95_22__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode }, },
  { 184 /* clrex */, ARM::CLREX, Convert_NoOperands, AMFBS_IsARM_HasV6K, {  }, },
  { 184 /* clrex */, ARM::t2CLREX, Convert__CondCode2_0, AMFBS_IsThumb_HasV7Clrex, { MCK_CondCode }, },
  { 190 /* clrm */, ARM::t2CLRM, Convert__CondCode2_0__RegListWithAPSR1_1, AMFBS_HasV8_1MMainline, { MCK_CondCode, MCK_RegListWithAPSR }, },
  { 195 /* clz */, ARM::t2CLZ, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 195 /* clz */, ARM::CLZ, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasV5T, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 199 /* cmn */, ARM::tCMNz, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 199 /* cmn */, ARM::CMPri, Convert__Reg1_1__ModImmNeg1_2__CondCode2_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_ModImmNeg }, },
  { 199 /* cmn */, ARM::t2CMPri, Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 199 /* cmn */, ARM::t2CMNzrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 199 /* cmn */, ARM::t2CMNzrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 199 /* cmn */, ARM::CMNzrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 199 /* cmn */, ARM::t2CMNri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 199 /* cmn */, ARM::CMNzrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 199 /* cmn */, ARM::CMNri, Convert__Reg1_1__ModImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 199 /* cmn */, ARM::CMNzrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 199 /* cmn */, ARM::t2CMNzrr, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 199 /* cmn */, ARM::t2CMNzrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 199 /* cmn */, ARM::t2CMNri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 203 /* cmp */, ARM::tCMPr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 203 /* cmp */, ARM::tCMPi8, Convert__Reg1_1__Imm0_2551_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 203 /* cmp */, ARM::tCMPhir, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 203 /* cmp */, ARM::CMNri, Convert__Reg1_1__ModImmNeg1_2__CondCode2_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_ModImmNeg }, },
  { 203 /* cmp */, ARM::t2CMNri, Convert__Reg1_1__T2SOImmNeg1_2__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNeg }, },
  { 203 /* cmp */, ARM::t2CMPrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 203 /* cmp */, ARM::CMPrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 203 /* cmp */, ARM::t2CMPri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_T2SOImm }, },
  { 203 /* cmp */, ARM::CMPrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 203 /* cmp */, ARM::CMPri, Convert__Reg1_1__ModImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 203 /* cmp */, ARM::CMPrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 203 /* cmp */, ARM::t2CMPrr, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 203 /* cmp */, ARM::t2CMPrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 203 /* cmp */, ARM::t2CMPri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2SOImm }, },
  { 207 /* cneg */, ARM::t2CSNEG, Convert__Reg1_0__Reg1_1__Reg1_1__CondCodeNoALInv1_2, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_CondCodeNoALInv }, },
  { 212 /* cps */, ARM::tCPS, Convert__Imm1_0__ProcIFlags1_1, AMFBS_IsThumb, { MCK_Imm, MCK_ProcIFlags }, },
  { 212 /* cps */, ARM::t2CPS1p, Convert__Imm0_311_0, AMFBS_IsThumb2_IsNotMClass, { MCK_Imm0_31 }, },
  { 212 /* cps */, ARM::CPS1p, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31 }, },
  { 212 /* cps */, ARM::t2CPS1p, Convert__Imm0_311_1, AMFBS_IsThumb2, { MCK__DOT_w, MCK_Imm0_31 }, },
  { 212 /* cps */, ARM::CPS2p, Convert__Imm1_0__ProcIFlags1_1, AMFBS_IsARM, { MCK_Imm, MCK_ProcIFlags }, },
  { 212 /* cps */, ARM::t2CPS2p, Convert__Imm1_0__ProcIFlags1_2, AMFBS_IsThumb2_IsNotMClass, { MCK_Imm, MCK__DOT_w, MCK_ProcIFlags }, },
  { 212 /* cps */, ARM::CPS3p, Convert__Imm1_0__ProcIFlags1_1__Imm0_311_2, AMFBS_IsARM, { MCK_Imm, MCK_ProcIFlags, MCK_Imm0_31 }, },
  { 212 /* cps */, ARM::t2CPS3p, Convert__Imm1_0__ProcIFlags1_1__Imm1_2, AMFBS_IsThumb2_IsNotMClass, { MCK_Imm, MCK_ProcIFlags, MCK_Imm }, },
  { 212 /* cps */, ARM::t2CPS3p, Convert__Imm1_0__ProcIFlags1_2__Imm1_3, AMFBS_IsThumb2, { MCK_Imm, MCK__DOT_w, MCK_ProcIFlags, MCK_Imm }, },
  { 216 /* crc32b */, ARM::t2CRC32B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 216 /* crc32b */, ARM::CRC32B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 223 /* crc32cb */, ARM::t2CRC32CB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 223 /* crc32cb */, ARM::CRC32CB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 231 /* crc32ch */, ARM::t2CRC32CH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 231 /* crc32ch */, ARM::CRC32CH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 239 /* crc32cw */, ARM::t2CRC32CW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 239 /* crc32cw */, ARM::CRC32CW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 247 /* crc32h */, ARM::t2CRC32H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 247 /* crc32h */, ARM::CRC32H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 254 /* crc32w */, ARM::t2CRC32W, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsThumb2_HasCRC, { MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 254 /* crc32w */, ARM::CRC32W, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsARM_HasCRC, { MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 261 /* csdb */, ARM::HINT, Convert__imm_95_20__CondCode2_0, AMFBS_IsARM_HasV6K, { MCK_CondCode }, },
  { 261 /* csdb */, ARM::t2HINT, Convert__imm_95_20__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode }, },
  { 261 /* csdb */, ARM::t2HINT, Convert__imm_95_20__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 266 /* csel */, ARM::t2CSEL, Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_GPRwithZRnosp, MCK_CondCodeNoAL }, },
  { 271 /* cset */, ARM::t2CSINC, Convert__Reg1_0__regZR__regZR__CondCodeNoALInv1_1, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_CondCodeNoALInv }, },
  { 276 /* csetm */, ARM::t2CSINV, Convert__Reg1_0__regZR__regZR__CondCodeNoALInv1_1, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_CondCodeNoALInv }, },
  { 282 /* csinc */, ARM::t2CSINC, Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_GPRwithZRnosp, MCK_CondCodeNoAL }, },
  { 288 /* csinv */, ARM::t2CSINV, Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_GPRwithZRnosp, MCK_CondCodeNoAL }, },
  { 294 /* csneg */, ARM::t2CSNEG, Convert__Reg1_0__Reg1_1__Reg1_2__CondCodeNoAL1_3, AMFBS_HasV8_1MMainline, { MCK_rGPR, MCK_GPRwithZRnosp, MCK_GPRwithZRnosp, MCK_CondCodeNoAL }, },
  { 300 /* cx1 */, ARM::CDE_CX1, Convert__Reg1_1__CoprocNum1_0__Imm13b1_2, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm13b }, },
  { 304 /* cx1a */, ARM::CDE_CX1A, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm13b1_3__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm13b }, },
  { 309 /* cx1d */, ARM::CDE_CX1D, Convert__Reg1_1__CoprocNum1_0__Imm13b1_2, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRPairnosp, MCK_Imm13b }, },
  { 314 /* cx1da */, ARM::CDE_CX1DA, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm13b1_3__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRPairnosp, MCK_Imm13b }, },
  { 320 /* cx2 */, ARM::CDE_CX2, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm9b1_3, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm9b }, },
  { 324 /* cx2a */, ARM::CDE_CX2A, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm9b1_4__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm9b }, },
  { 329 /* cx2d */, ARM::CDE_CX2D, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm9b1_3, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRPairnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm9b }, },
  { 334 /* cx2da */, ARM::CDE_CX2DA, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm9b1_4__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRPairnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm9b }, },
  { 340 /* cx3 */, ARM::CDE_CX3, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm6b1_4, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm6b }, },
  { 344 /* cx3a */, ARM::CDE_CX3A, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm6b1_5__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm6b }, },
  { 349 /* cx3d */, ARM::CDE_CX3D, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm6b1_4, AMFBS_HasCDE, { MCK_CoprocNum, MCK_GPRPairnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm6b }, },
  { 354 /* cx3da */, ARM::CDE_CX3DA, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm6b1_5__CondCode2_0, AMFBS_HasCDE, { MCK_CondCode, MCK_CoprocNum, MCK_GPRPairnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_GPRwithAPSR_NZCVnosp, MCK_Imm6b }, },
  { 360 /* dbg */, ARM::DBG, Convert__Imm0_151_1__CondCode2_0, AMFBS_IsARM_HasV7, { MCK_CondCode, MCK_Imm0_15 }, },
  { 360 /* dbg */, ARM::t2DBG, Convert__Imm0_151_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_15 }, },
  { 360 /* dbg */, ARM::t2DBG, Convert__Imm0_151_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm0_15 }, },
  { 364 /* dcps1 */, ARM::t2DCPS1, Convert__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode }, },
  { 370 /* dcps2 */, ARM::t2DCPS2, Convert__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode }, },
  { 376 /* dcps3 */, ARM::t2DCPS3, Convert__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode }, },
  { 382 /* dfb */, ARM::DSB, Convert__imm_95_12, AMFBS_IsARM_HasDFB, {  }, },
  { 382 /* dfb */, ARM::t2DSB, Convert__imm_95_12__CondCode2_0, AMFBS_HasDFB, { MCK_CondCode }, },
  { 386 /* dls */, ARM::t2DLS, Convert__Reg1_0__Reg1_1, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_GPRlr, MCK_rGPR }, },
  { 390 /* dlstp */, ARM::MVE_DLSTP_16, Convert__Reg1_1__Reg1_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_GPRlr, MCK_rGPR }, },
  { 390 /* dlstp */, ARM::MVE_DLSTP_32, Convert__Reg1_1__Reg1_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_GPRlr, MCK_rGPR }, },
  { 390 /* dlstp */, ARM::MVE_DLSTP_64, Convert__Reg1_1__Reg1_2, AMFBS_HasMVEInt, { MCK__DOT_64, MCK_GPRlr, MCK_rGPR }, },
  { 390 /* dlstp */, ARM::MVE_DLSTP_8, Convert__Reg1_1__Reg1_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_GPRlr, MCK_rGPR }, },
  { 396 /* dmb */, ARM::DMB, Convert__imm_95_15, AMFBS_IsARM_HasDB, {  }, },
  { 396 /* dmb */, ARM::t2DMB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode }, },
  { 396 /* dmb */, ARM::DMB, Convert__MemBarrierOpt1_0, AMFBS_IsARM_HasDB, { MCK_MemBarrierOpt }, },
  { 396 /* dmb */, ARM::t2DMB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w }, },
  { 396 /* dmb */, ARM::t2DMB, Convert__MemBarrierOpt1_1__CondCode2_0, AMFBS_IsThumb_HasDB, { MCK_CondCode, MCK_MemBarrierOpt }, },
  { 396 /* dmb */, ARM::t2DMB, Convert__MemBarrierOpt1_2__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w, MCK_MemBarrierOpt }, },
  { 400 /* dsb */, ARM::DSB, Convert__imm_95_15, AMFBS_IsARM_HasDB, {  }, },
  { 400 /* dsb */, ARM::t2DSB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode }, },
  { 400 /* dsb */, ARM::DSB, Convert__MemBarrierOpt1_0, AMFBS_IsARM_HasDB, { MCK_MemBarrierOpt }, },
  { 400 /* dsb */, ARM::t2DSB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w }, },
  { 400 /* dsb */, ARM::t2DSB, Convert__MemBarrierOpt1_1__CondCode2_0, AMFBS_IsThumb_HasDB, { MCK_CondCode, MCK_MemBarrierOpt }, },
  { 400 /* dsb */, ARM::t2DSB, Convert__MemBarrierOpt1_2__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w, MCK_MemBarrierOpt }, },
  { 404 /* eor */, ARM::tEOR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 404 /* eor */, ARM::t2EORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 404 /* eor */, ARM::t2EORrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::t2EORri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 404 /* eor */, ARM::EORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 404 /* eor */, ARM::EORri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 404 /* eor */, ARM::EORrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::EORrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 404 /* eor */, ARM::t2EORrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 404 /* eor */, ARM::t2EORrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::t2EORri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 404 /* eor */, ARM::t2EORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 404 /* eor */, ARM::t2EORrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::t2EORri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 404 /* eor */, ARM::EORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 404 /* eor */, ARM::EORri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 404 /* eor */, ARM::EORrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::EORrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 404 /* eor */, ARM::t2EORrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 404 /* eor */, ARM::t2EORrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 404 /* eor */, ARM::t2EORri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 408 /* eret */, ARM::ERET, Convert__CondCode2_0, AMFBS_IsARM_HasVirtualization, { MCK_CondCode }, },
  { 408 /* eret */, ARM::t2SUBS_PC_LR, Convert__imm_95_0__CondCode2_0, AMFBS_IsThumb2_HasVirtualization, { MCK_CondCode }, },
  { 413 /* esb */, ARM::HINT, Convert__imm_95_16__CondCode2_0, AMFBS_IsARM_HasRAS, { MCK_CondCode }, },
  { 413 /* esb */, ARM::t2HINT, Convert__imm_95_16__CondCode2_0, AMFBS_IsThumb2_HasRAS, { MCK_CondCode }, },
  { 413 /* esb */, ARM::t2HINT, Convert__imm_95_16__CondCode2_0, AMFBS_IsThumb2_HasRAS, { MCK_CondCode, MCK__DOT_w }, },
  { 417 /* faddd */, ARM::VADDD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 423 /* fadds */, ARM::VADDS, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 429 /* fcmpzd */, ARM::VCMPZD, Convert__Reg1_1__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK_DPR }, },
  { 436 /* fcmpzs */, ARM::VCMPZS, Convert__Reg1_1__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK_HPR }, },
  { 443 /* fconstd */, ARM::FCONSTD, Convert__Reg1_1__FPImm1_2__CondCode2_0, AMFBS_HasVFP3, { MCK_CondCode, MCK_DPR, MCK_FPImm }, },
  { 451 /* fconsts */, ARM::FCONSTS, Convert__Reg1_1__FPImm1_2__CondCode2_0, AMFBS_HasVFP3, { MCK_CondCode, MCK_HPR, MCK_FPImm }, },
  { 459 /* fldmdbx */, ARM::FLDMXDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 467 /* fldmiax */, ARM::FLDMXIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 467 /* fldmiax */, ARM::FLDMXIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 475 /* fmdhr */, ARM::VSETLNi32, Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_1__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_GPR }, },
  { 481 /* fmdlr */, ARM::VSETLNi32, Convert__Reg1_1__Tie0_2_2__Reg1_2__imm_95_0__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK_DPR, MCK_GPR }, },
  { 487 /* fmstat */, ARM::FMSTAT, Convert__CondCode2_0, AMFBS_HasFPRegs, { MCK_CondCode }, },
  { 494 /* fstmdbx */, ARM::FSTMXDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 502 /* fstmiax */, ARM::FSTMXIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 502 /* fstmiax */, ARM::FSTMXIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 510 /* fsubd */, ARM::VSUBD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 516 /* fsubs */, ARM::VSUBS, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 522 /* hint */, ARM::tHINT, Convert__Imm0_151_1__CondCode2_0, AMFBS_IsThumb_HasV6M, { MCK_CondCode, MCK_Imm0_15 }, },
  { 522 /* hint */, ARM::HINT, Convert__Imm0_2391_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_Imm0_239 }, },
  { 522 /* hint */, ARM::t2HINT, Convert__Imm0_2391_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_239 }, },
  { 522 /* hint */, ARM::t2HINT, Convert__Imm0_2391_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm0_239 }, },
  { 527 /* hlt */, ARM::tHLT, Convert__Imm0_631_0, AMFBS_IsThumb_HasV8, { MCK_Imm0_63 }, },
  { 527 /* hlt */, ARM::HLT, Convert__Imm0_655351_0, AMFBS_IsARM_HasV8, { MCK_Imm0_65535 }, },
  { 531 /* hvc */, ARM::HVC, Convert__Imm0_655351_0, AMFBS_IsARM_HasVirtualization, { MCK_Imm0_65535 }, },
  { 531 /* hvc */, ARM::t2HVC, Convert__Imm0_655351_0, AMFBS_IsThumb2, { MCK_Imm0_65535 }, },
  { 531 /* hvc */, ARM::t2HVC, Convert__Imm0_655351_1, AMFBS_IsThumb2_HasVirtualization, { MCK__DOT_w, MCK_Imm0_65535 }, },
  { 535 /* isb */, ARM::ISB, Convert__imm_95_15, AMFBS_IsARM_HasDB, {  }, },
  { 535 /* isb */, ARM::t2ISB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode }, },
  { 535 /* isb */, ARM::ISB, Convert__InstSyncBarrierOpt1_0, AMFBS_IsARM_HasDB, { MCK_InstSyncBarrierOpt }, },
  { 535 /* isb */, ARM::t2ISB, Convert__imm_95_15__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w }, },
  { 535 /* isb */, ARM::t2ISB, Convert__InstSyncBarrierOpt1_1__CondCode2_0, AMFBS_IsThumb_HasDB, { MCK_CondCode, MCK_InstSyncBarrierOpt }, },
  { 535 /* isb */, ARM::t2ISB, Convert__InstSyncBarrierOpt1_2__CondCode2_0, AMFBS_HasDB, { MCK_CondCode, MCK__DOT_w, MCK_InstSyncBarrierOpt }, },
  { 539 /* it */, ARM::t2IT, Convert__ITCondCode1_1__ITMask1_0, AMFBS_IsThumb2, { MCK_ITMask, MCK_ITCondCode }, },
  { 539 /* it */, ARM::ITasm, Convert__ITCondCode1_1__ITMask1_0, AMFBS_IsARM, { MCK_ITMask, MCK_ITCondCode }, },
  { 542 /* lctp */, ARM::MVE_LCTP, Convert__CondCode2_0, AMFBS_HasMVEInt, { MCK_CondCode }, },
  { 547 /* lda */, ARM::t2LDA, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 547 /* lda */, ARM::LDA, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 551 /* ldab */, ARM::t2LDAB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 551 /* ldab */, ARM::LDAB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 556 /* ldaex */, ARM::t2LDAEX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 556 /* ldaex */, ARM::LDAEX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 562 /* ldaexb */, ARM::t2LDAEXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 562 /* ldaexb */, ARM::LDAEXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 569 /* ldaexd */, ARM::LDAEXD, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPRPair, MCK_MemNoOffset }, },
  { 569 /* ldaexd */, ARM::t2LDAEXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 576 /* ldaexh */, ARM::t2LDAEXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 576 /* ldaexh */, ARM::LDAEXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 583 /* ldah */, ARM::t2LDAH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 583 /* ldah */, ARM::LDAH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 588 /* ldc */, ARM::LDC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 588 /* ldc */, ARM::t2LDC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 588 /* ldc */, ARM::LDC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 588 /* ldc */, ARM::t2LDC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 588 /* ldc */, ARM::LDC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 588 /* ldc */, ARM::t2LDC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 588 /* ldc */, ARM::LDC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 588 /* ldc */, ARM::t2LDC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 592 /* ldc2 */, ARM::LDC2_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 592 /* ldc2 */, ARM::t2LDC2_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 592 /* ldc2 */, ARM::LDC2_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 592 /* ldc2 */, ARM::LDC2_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 592 /* ldc2 */, ARM::LDC2_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 592 /* ldc2 */, ARM::t2LDC2_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 592 /* ldc2 */, ARM::t2LDC2_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 592 /* ldc2 */, ARM::t2LDC2_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 597 /* ldc2l */, ARM::LDC2L_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 597 /* ldc2l */, ARM::t2LDC2L_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 597 /* ldc2l */, ARM::LDC2L_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 597 /* ldc2l */, ARM::LDC2L_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 597 /* ldc2l */, ARM::LDC2L_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 597 /* ldc2l */, ARM::t2LDC2L_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 597 /* ldc2l */, ARM::t2LDC2L_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 597 /* ldc2l */, ARM::t2LDC2L_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 603 /* ldcl */, ARM::LDCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 603 /* ldcl */, ARM::t2LDCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 603 /* ldcl */, ARM::LDCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 603 /* ldcl */, ARM::t2LDCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 603 /* ldcl */, ARM::LDCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 603 /* ldcl */, ARM::t2LDCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 603 /* ldcl */, ARM::LDCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 603 /* ldcl */, ARM::t2LDCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 608 /* ldm */, ARM::tLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_RegList }, },
  { 608 /* ldm */, ARM::tLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_3, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 608 /* ldm */, ARM::LDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 608 /* ldm */, ARM::t2LDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 608 /* ldm */, ARM::t2LDMIA, Convert__Reg1_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 608 /* ldm */, ARM::LDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 608 /* ldm */, ARM::t2LDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 608 /* ldm */, ARM::sysLDMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 608 /* ldm */, ARM::t2LDMIA_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 608 /* ldm */, ARM::sysLDMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 612 /* ldmda */, ARM::LDMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 612 /* ldmda */, ARM::LDMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 612 /* ldmda */, ARM::sysLDMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 612 /* ldmda */, ARM::sysLDMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 618 /* ldmdb */, ARM::LDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::t2LDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::t2LDMDB, Convert__Reg1_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::LDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::t2LDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::sysLDMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 618 /* ldmdb */, ARM::t2LDMDB_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 618 /* ldmdb */, ARM::sysLDMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 624 /* ldmib */, ARM::LDMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 624 /* ldmib */, ARM::LDMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 624 /* ldmib */, ARM::sysLDMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 624 /* ldmib */, ARM::sysLDMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 630 /* ldr */, ARM::tLDRpci, Convert__Reg1_1__ThumbMemPC1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_ThumbMemPC }, },
  { 630 /* ldr */, ARM::tLDRi, Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs4 }, },
  { 630 /* ldr */, ARM::tLDRr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 630 /* ldr */, ARM::tLDRspi, Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbSPI }, },
  { 630 /* ldr */, ARM::tLDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_ConstPoolAsmImm }, },
  { 630 /* ldr */, ARM::t2LDRpci, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_Imm }, },
  { 630 /* ldr */, ARM::LDRi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset }, },
  { 630 /* ldr */, ARM::t2LDRi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 630 /* ldr */, ARM::LDRrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset }, },
  { 630 /* ldr */, ARM::LDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_ConstPoolAsmImm }, },
  { 630 /* ldr */, ARM::t2LDRConstPool, Convert__Reg1_1__ConstPoolAsmImm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_ConstPoolAsmImm }, },
  { 630 /* ldr */, ARM::t2LDRi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemUImm12Offset }, },
  { 630 /* ldr */, ARM::t2LDRs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_T2MemRegOffset }, },
  { 630 /* ldr */, ARM::t2LDRpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemPCRelImm12 }, },
  { 630 /* ldr */, ARM::t2LDRConstPool, Convert__Reg1_2__ConstPoolAsmImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_ConstPoolAsmImm }, },
  { 630 /* ldr */, ARM::t2LDRpci, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_Imm }, },
  { 630 /* ldr */, ARM::t2LDRi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemUImm12Offset }, },
  { 630 /* ldr */, ARM::t2LDRs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_T2MemRegOffset }, },
  { 630 /* ldr */, ARM::t2LDRpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemPCRelImm12 }, },
  { 630 /* ldr */, ARM::LDR_PRE_IMM, Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 630 /* ldr */, ARM::t2LDR_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 630 /* ldr */, ARM::LDR_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 630 /* ldr */, ARM::t2LDR_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 630 /* ldr */, ARM::LDR_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 630 /* ldr */, ARM::LDR_PRE_REG, Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 630 /* ldr */, ARM::t2LDR_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 630 /* ldr */, ARM::t2LDR_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 634 /* ldrb */, ARM::tLDRBi, Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs1 }, },
  { 634 /* ldrb */, ARM::tLDRBr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 634 /* ldrb */, ARM::t2LDRBpci, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 634 /* ldrb */, ARM::t2LDRBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 634 /* ldrb */, ARM::t2LDRBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 634 /* ldrb */, ARM::LDRBi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm12Offset }, },
  { 634 /* ldrb */, ARM::t2LDRBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 634 /* ldrb */, ARM::LDRBrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemRegOffset }, },
  { 634 /* ldrb */, ARM::t2LDRBpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 634 /* ldrb */, ARM::t2LDRBpci, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 634 /* ldrb */, ARM::t2LDRBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 634 /* ldrb */, ARM::t2LDRBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 634 /* ldrb */, ARM::t2LDRBpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 634 /* ldrb */, ARM::t2LDRB_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 634 /* ldrb */, ARM::LDRB_PRE_IMM, Convert__Reg1_1__imm_95_0__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 634 /* ldrb */, ARM::t2LDRB_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 634 /* ldrb */, ARM::LDRB_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 634 /* ldrb */, ARM::t2LDRB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 634 /* ldrb */, ARM::LDRB_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 634 /* ldrb */, ARM::LDRB_PRE_REG, Convert__Reg1_1__imm_95_0__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 634 /* ldrb */, ARM::t2LDRB_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 634 /* ldrb */, ARM::t2LDRB_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 639 /* ldrbt */, ARM::t2LDRBT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 639 /* ldrbt */, ARM::LDRBT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 639 /* ldrbt */, ARM::LDRBT_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 639 /* ldrbt */, ARM::LDRBT_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 645 /* ldrd */, ARM::t2LDRDi8, Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset }, },
  { 645 /* ldrd */, ARM::LDRD, Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3 }, },
  { 645 /* ldrd */, ARM::t2LDRD_PRE, Convert__Reg1_1__Reg1_2__imm_95_0__MemImm8s4Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset, MCK__EXCLAIM_ }, },
  { 645 /* ldrd */, ARM::t2LDRD_POST, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 645 /* ldrd */, ARM::LDRD_PRE, Convert__Reg1_1__Reg1_2__imm_95_0__AddrMode33_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 645 /* ldrd */, ARM::LDRD_POST, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__Tie2_4_4__AM3Offset2_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 650 /* ldrex */, ARM::t2LDREX, Convert__Reg1_1__MemImm0_1020s4Offset2_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemImm0_1020s4Offset }, },
  { 650 /* ldrex */, ARM::LDREX, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 656 /* ldrexb */, ARM::t2LDREXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 656 /* ldrexb */, ARM::LDREXB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 663 /* ldrexd */, ARM::LDREXD, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRPair, MCK_MemNoOffset }, },
  { 663 /* ldrexd */, ARM::t2LDREXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 670 /* ldrexh */, ARM::t2LDREXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 670 /* ldrexh */, ARM::LDREXH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 677 /* ldrh */, ARM::tLDRHi, Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs2 }, },
  { 677 /* ldrh */, ARM::tLDRHr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 677 /* ldrh */, ARM::t2LDRHpci, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 677 /* ldrh */, ARM::t2LDRHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 677 /* ldrh */, ARM::t2LDRHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 677 /* ldrh */, ARM::t2LDRHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 677 /* ldrh */, ARM::t2LDRHpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 677 /* ldrh */, ARM::LDRH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 677 /* ldrh */, ARM::t2LDRHpci, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 677 /* ldrh */, ARM::t2LDRHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 677 /* ldrh */, ARM::t2LDRHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 677 /* ldrh */, ARM::t2LDRHpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 677 /* ldrh */, ARM::t2LDRH_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 677 /* ldrh */, ARM::LDRH_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 677 /* ldrh */, ARM::t2LDRH_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 677 /* ldrh */, ARM::LDRH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 677 /* ldrh */, ARM::t2LDRH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 677 /* ldrh */, ARM::t2LDRH_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 677 /* ldrh */, ARM::t2LDRH_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 682 /* ldrht */, ARM::t2LDRHT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 682 /* ldrht */, ARM::LDRHTii, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 682 /* ldrht */, ARM::LDRHTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 682 /* ldrht */, ARM::LDRHTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 688 /* ldrsb */, ARM::tLDRSB, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 688 /* ldrsb */, ARM::t2LDRSBpci, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 688 /* ldrsb */, ARM::t2LDRSBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 688 /* ldrsb */, ARM::t2LDRSBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 688 /* ldrsb */, ARM::t2LDRSBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 688 /* ldrsb */, ARM::t2LDRSBpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 688 /* ldrsb */, ARM::LDRSB, Convert__Reg1_1__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 688 /* ldrsb */, ARM::t2LDRSBpci, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 688 /* ldrsb */, ARM::t2LDRSBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 688 /* ldrsb */, ARM::t2LDRSBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 688 /* ldrsb */, ARM::t2LDRSBpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 688 /* ldrsb */, ARM::t2LDRSB_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 688 /* ldrsb */, ARM::LDRSB_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 688 /* ldrsb */, ARM::t2LDRSB_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 688 /* ldrsb */, ARM::LDRSB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 688 /* ldrsb */, ARM::t2LDRSB_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 688 /* ldrsb */, ARM::t2LDRSB_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 688 /* ldrsb */, ARM::t2LDRSB_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 694 /* ldrsbt */, ARM::t2LDRSBT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 694 /* ldrsbt */, ARM::LDRSBTii, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 694 /* ldrsbt */, ARM::LDRSBTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 694 /* ldrsbt */, ARM::LDRSBTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 701 /* ldrsh */, ARM::tLDRSH, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 701 /* ldrsh */, ARM::t2LDRSHpci, Convert__Reg1_1__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm }, },
  { 701 /* ldrsh */, ARM::t2LDRSHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 701 /* ldrsh */, ARM::t2LDRSHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 701 /* ldrsh */, ARM::t2LDRSHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNegImm8Offset }, },
  { 701 /* ldrsh */, ARM::t2LDRSHpcrel, Convert__Reg1_1__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 701 /* ldrsh */, ARM::LDRSH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 701 /* ldrsh */, ARM::t2LDRSHpci, Convert__Reg1_2__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_Imm }, },
  { 701 /* ldrsh */, ARM::t2LDRSHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemUImm12Offset }, },
  { 701 /* ldrsh */, ARM::t2LDRSHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_T2MemRegOffset }, },
  { 701 /* ldrsh */, ARM::t2LDRSHpcrel, Convert__Reg1_2__MemPCRelImm121_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_MemPCRelImm12 }, },
  { 701 /* ldrsh */, ARM::t2LDRSH_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 701 /* ldrsh */, ARM::LDRSH_PRE, Convert__Reg1_1__imm_95_0__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 701 /* ldrsh */, ARM::t2LDRSH_PRE, Convert__Reg1_1__imm_95_0__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 701 /* ldrsh */, ARM::LDRSH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM3Offset2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 701 /* ldrsh */, ARM::t2LDRSH_POST, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 701 /* ldrsh */, ARM::t2LDRSH_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 701 /* ldrsh */, ARM::t2LDRSH_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 707 /* ldrsht */, ARM::t2LDRSHT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 707 /* ldrsht */, ARM::LDRSHTii, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 707 /* ldrsht */, ARM::LDRSHTr, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxReg2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 707 /* ldrsht */, ARM::LDRSHTi, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxImm81_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 714 /* ldrt */, ARM::t2LDRT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 714 /* ldrt */, ARM::LDRT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 714 /* ldrt */, ARM::LDRT_POST_IMM, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 714 /* ldrt */, ARM::LDRT_POST_REG, Convert__Reg1_1__MemNoOffset1_2__Tie1_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 719 /* le */, ARM::t2LE, Convert__LELabel1_0, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_LELabel }, },
  { 719 /* le */, ARM::t2LEUpdate, Convert__imm_95_0__Reg1_0__LELabel1_1, AMFBS_IsThumb2_HasV8_1MMainline_HasLOB, { MCK_GPRlr, MCK_LELabel }, },
  { 722 /* letp */, ARM::MVE_LETP, Convert__imm_95_0__Reg1_0__LELabel1_1, AMFBS_HasMVEInt, { MCK_GPRlr, MCK_LELabel }, },
  { 727 /* lsl */, ARM::tLSLrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 727 /* lsl */, ARM::tLSLri, Convert__Reg1_2__CCOut1_0__Reg1_2__Imm0_311_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_31 }, },
  { 727 /* lsl */, ARM::tLSLri, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_311_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_31 }, },
  { 727 /* lsl */, ARM::t2LSLrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 727 /* lsl */, ARM::t2LSLri, Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_Imm1_31 }, },
  { 727 /* lsl */, ARM::LSLr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 727 /* lsl */, ARM::LSLi, Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_31 }, },
  { 727 /* lsl */, ARM::t2LSLrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 727 /* lsl */, ARM::t2LSLri, Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm1_31 }, },
  { 727 /* lsl */, ARM::t2LSLrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 727 /* lsl */, ARM::t2LSLri, Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 727 /* lsl */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK__HASH_0 }, },
  { 727 /* lsl */, ARM::LSLr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 727 /* lsl */, ARM::LSLi, Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_31 }, },
  { 727 /* lsl */, ARM::t2LSLrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 727 /* lsl */, ARM::t2LSLri, Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 727 /* lsl */, ARM::t2MOVr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK__HASH_0 }, },
  { 731 /* lsll */, ARM::MVE_LSLLr, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_rGPR }, },
  { 731 /* lsll */, ARM::MVE_LSLLi, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 736 /* lsr */, ARM::tLSRrr, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 736 /* lsr */, ARM::tLSRri, Convert__Reg1_2__CCOut1_0__Reg1_2__ImmThumbSR1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ImmThumbSR }, },
  { 736 /* lsr */, ARM::tLSRri, Convert__Reg1_2__CCOut1_0__Reg1_3__ImmThumbSR1_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ImmThumbSR }, },
  { 736 /* lsr */, ARM::t2LSRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 736 /* lsr */, ARM::t2LSRri, Convert__Reg1_2__Reg1_2__ImmThumbSR1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ImmThumbSR }, },
  { 736 /* lsr */, ARM::LSRr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 736 /* lsr */, ARM::LSRi, Convert__Reg1_2__Reg1_2__Imm0_321_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_32 }, },
  { 736 /* lsr */, ARM::t2LSRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 736 /* lsr */, ARM::t2LSRri, Convert__Reg1_3__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_ImmThumbSR }, },
  { 736 /* lsr */, ARM::t2LSRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 736 /* lsr */, ARM::t2LSRri, Convert__Reg1_2__Reg1_3__ImmThumbSR1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 736 /* lsr */, ARM::LSRr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 736 /* lsr */, ARM::LSRi, Convert__Reg1_2__Reg1_3__Imm0_321_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_32 }, },
  { 736 /* lsr */, ARM::t2LSRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 736 /* lsr */, ARM::t2LSRri, Convert__Reg1_3__Reg1_4__ImmThumbSR1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_ImmThumbSR }, },
  { 740 /* lsrl */, ARM::MVE_LSRL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 745 /* mcr */, ARM::MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 745 /* mcr */, ARM::t2MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 745 /* mcr */, ARM::MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 745 /* mcr */, ARM::t2MCR, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 749 /* mcr2 */, ARM::MCR2, Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__imm_95_0, AMFBS_IsARM, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 749 /* mcr2 */, ARM::t2MCR2, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 749 /* mcr2 */, ARM::MCR2, Convert__CoprocNum1_0__Imm0_71_1__Reg1_2__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 749 /* mcr2 */, ARM::t2MCR2, Convert__CoprocNum1_1__Imm0_71_2__Reg1_3__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 754 /* mcrr */, ARM::MCRR, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 754 /* mcrr */, ARM::t2MCRR, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 759 /* mcrr2 */, ARM::MCRR2, Convert__CoprocNum1_0__Imm0_151_1__Reg1_2__Reg1_3__CoprocReg1_4, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 759 /* mcrr2 */, ARM::t2MCRR2, Convert__CoprocNum1_1__Imm0_151_2__Reg1_3__Reg1_4__CoprocReg1_5__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 765 /* mla */, ARM::t2MLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 765 /* mla */, ARM::MLA, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 765 /* mla */, ARM::MLA, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 769 /* mls */, ARM::t2MLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 769 /* mls */, ARM::MLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 773 /* mov */, ARM::tMOVr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 773 /* mov */, ARM::tMOVi8, Convert__Reg1_2__CCOut1_0__Imm0_255Expr1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255Expr }, },
  { 773 /* mov */, ARM::MOVPCLR, Convert__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_PC, MCK_GPRlr }, },
  { 773 /* mov */, ARM::t2MOVi16, Convert__Reg1_1__Imm256_65535Expr1_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm256_65535Expr }, },
  { 773 /* mov */, ARM::t2MOVsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 773 /* mov */, ARM::t2MOVsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedReg }, },
  { 773 /* mov */, ARM::t2MOVi, Convert__Reg1_1__T2SOImm1_2__CondCode2_0__reg0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 773 /* mov */, ARM::t2MVNi, Convert__Reg1_1__T2SOImmNot1_2__CondCode2_0__reg0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 773 /* mov */, ARM::MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Imm0_65535Expr }, },
  { 773 /* mov */, ARM::MOVr_TC, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_tcGPR, MCK_tcGPR }, },
  { 773 /* mov */, ARM::MVNi, Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ModImmNot }, },
  { 773 /* mov */, ARM::MOVsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 773 /* mov */, ARM::MOVr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 773 /* mov */, ARM::MOVi, Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 773 /* mov */, ARM::MOVsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 773 /* mov */, ARM::t2MOVsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 773 /* mov */, ARM::t2MOVsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedReg }, },
  { 773 /* mov */, ARM::t2MOVi, Convert__Reg1_2__T2SOImm1_3__CondCode2_0__reg0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 773 /* mov */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_0__reg0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 773 /* mov */, ARM::t2MOVi, Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 773 /* mov */, ARM::t2MOVr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 777 /* movs */, ARM::tMOVSr, Convert__Reg1_0__Reg1_1, AMFBS_IsThumb, { MCK_tGPR, MCK_tGPR }, },
  { 777 /* movs */, ARM::tMOVi8, Convert__Reg1_0__regCPSR__Imm0_255Expr1_1__imm_95_14__reg0, AMFBS_IsThumb, { MCK_tGPR, MCK_Imm0_255Expr }, },
  { 777 /* movs */, ARM::t2SUBS_PC_LR, Convert__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_PC, MCK_GPRlr }, },
  { 777 /* movs */, ARM::t2MOVSsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 777 /* movs */, ARM::t2MOVSsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedReg }, },
  { 777 /* movs */, ARM::t2MOVi, Convert__Reg1_1__T2SOImm1_2__CondCode2_0__regCPSR, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 777 /* movs */, ARM::t2MOVr, Convert__Reg1_1__Reg1_2__CondCode2_0__regCPSR, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 777 /* movs */, ARM::t2SUBS_PC_LR, Convert__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_PC, MCK_GPRlr }, },
  { 777 /* movs */, ARM::t2MOVSsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 777 /* movs */, ARM::t2MOVSsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedReg }, },
  { 777 /* movs */, ARM::t2MOVi, Convert__Reg1_2__T2SOImm1_3__CondCode2_0__regCPSR, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 777 /* movs */, ARM::t2MOVr, Convert__Reg1_2__Reg1_3__CondCode2_0__regCPSR, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc }, },
  { 782 /* movt */, ARM::t2MOVTi16, Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm0_65535Expr }, },
  { 782 /* movt */, ARM::MOVTi16, Convert__Reg1_1__Tie0_1_1__Imm0_65535Expr1_2__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_65535Expr }, },
  { 787 /* movw */, ARM::t2MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_Imm0_65535Expr }, },
  { 787 /* movw */, ARM::MOVi16, Convert__Reg1_1__Imm0_65535Expr1_2__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_Imm0_65535Expr }, },
  { 792 /* mrc */, ARM::MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 792 /* mrc */, ARM::t2MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 792 /* mrc */, ARM::MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 792 /* mrc */, ARM::t2MRC, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 796 /* mrc2 */, ARM::MRC2, Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__imm_95_0, AMFBS_IsARM, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 796 /* mrc2 */, ARM::t2MRC2, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg }, },
  { 796 /* mrc2 */, ARM::MRC2, Convert__Reg1_2__CoprocNum1_0__Imm0_71_1__CoprocReg1_3__CoprocReg1_4__Imm0_71_5, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 796 /* mrc2 */, ARM::t2MRC2, Convert__Reg1_3__CoprocNum1_1__Imm0_71_2__CoprocReg1_4__CoprocReg1_5__Imm0_71_6__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_7, MCK_GPRwithAPSR, MCK_CoprocReg, MCK_CoprocReg, MCK_Imm0_7 }, },
  { 801 /* mrrc */, ARM::MRRC, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 801 /* mrrc */, ARM::t2MRRC, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 806 /* mrrc2 */, ARM::MRRC2, Convert__Reg1_2__Reg1_3__CoprocNum1_0__Imm0_151_1__CoprocReg1_4, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_Imm0_15, MCK_GPRnopc, MCK_GPRnopc, MCK_CoprocReg }, },
  { 806 /* mrrc2 */, ARM::t2MRRC2, Convert__Reg1_3__Reg1_4__CoprocNum1_1__Imm0_151_2__CoprocReg1_5__CondCode2_0, AMFBS_IsThumb2_PreV8, { MCK_CondCode, MCK_CoprocNum, MCK_Imm0_15, MCK_GPR, MCK_GPR, MCK_CoprocReg }, },
  { 812 /* mrs */, ARM::t2MRSbanked, Convert__Reg1_1__BankedReg1_2__CondCode2_0, AMFBS_IsThumb_HasVirtualization, { MCK_CondCode, MCK_rGPR, MCK_BankedReg }, },
  { 812 /* mrs */, ARM::t2MRS_M, Convert__Reg1_1__MSRMask1_2__CondCode2_0, AMFBS_IsThumb_IsMClass, { MCK_CondCode, MCK_rGPR, MCK_MSRMask }, },
  { 812 /* mrs */, ARM::MRS, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_APSR }, },
  { 812 /* mrs */, ARM::MRS, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_CCR }, },
  { 812 /* mrs */, ARM::MRSsys, Convert__Reg1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_SPSR }, },
  { 812 /* mrs */, ARM::MRSbanked, Convert__Reg1_1__BankedReg1_2__CondCode2_0, AMFBS_IsARM_HasVirtualization, { MCK_CondCode, MCK_GPRnopc, MCK_BankedReg }, },
  { 812 /* mrs */, ARM::t2MRS_AR, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK_APSR }, },
  { 812 /* mrs */, ARM::t2MRS_AR, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_CCR }, },
  { 812 /* mrs */, ARM::t2MRSsys_AR, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK_SPSR }, },
  { 816 /* msr */, ARM::t2MSRbanked, Convert__BankedReg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasVirtualization, { MCK_CondCode, MCK_BankedReg, MCK_rGPR }, },
  { 816 /* msr */, ARM::MSRbanked, Convert__BankedReg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasVirtualization, { MCK_CondCode, MCK_BankedReg, MCK_GPRnopc }, },
  { 816 /* msr */, ARM::t2MSR_AR, Convert__MSRMask1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_MSRMask, MCK_rGPR }, },
  { 816 /* msr */, ARM::t2MSR_M, Convert__MSRMask1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_IsMClass, { MCK_CondCode, MCK_MSRMask, MCK_rGPR }, },
  { 816 /* msr */, ARM::MSR, Convert__MSRMask1_1__Reg1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_MSRMask, MCK_GPR }, },
  { 816 /* msr */, ARM::MSRi, Convert__MSRMask1_1__ModImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_MSRMask, MCK_ModImm }, },
  { 820 /* mul */, ARM::tMUL, ConvertCustom_cvtThumbMultiply, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 820 /* mul */, ARM::tMUL, ConvertCustom_cvtThumbMultiply, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 820 /* mul */, ARM::t2MUL, Convert__Reg1_1__Reg1_2__Reg1_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 820 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 820 /* mul */, ARM::t2MUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 820 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 820 /* mul */, ARM::MUL, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 824 /* mvn */, ARM::tMVN, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 824 /* mvn */, ARM::t2MVNr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 824 /* mvn */, ARM::MOVi, Convert__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_ModImmNot }, },
  { 824 /* mvn */, ARM::t2MVNs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 824 /* mvn */, ARM::t2MVNi, Convert__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 824 /* mvn */, ARM::t2MOVi, Convert__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 824 /* mvn */, ARM::MVNsr, Convert__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 824 /* mvn */, ARM::MVNr, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 824 /* mvn */, ARM::MVNi, Convert__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 824 /* mvn */, ARM::MVNsi, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 824 /* mvn */, ARM::t2MVNr, Convert__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 824 /* mvn */, ARM::t2MVNs, Convert__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 824 /* mvn */, ARM::t2MVNi, Convert__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 828 /* neg */, ARM::tRSB, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 828 /* neg */, ARM::t2RSBri, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 828 /* neg */, ARM::RSBri, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 832 /* nop */, ARM::tMOVr, Convert__regR8__regR8__imm_95_14__reg0, AMFBS_IsThumb, {  }, },
  { 832 /* nop */, ARM::tHINT, Convert__imm_95_0__CondCode2_0, AMFBS_IsThumb_HasV6M, { MCK_CondCode }, },
  { 832 /* nop */, ARM::HINT, Convert__imm_95_0__CondCode2_0, AMFBS_IsARM_HasV6K, { MCK_CondCode }, },
  { 832 /* nop */, ARM::MOVr, Convert__regR0__regR0__CondCode2_0__reg0, AMFBS_IsARM, { MCK_CondCode }, },
  { 832 /* nop */, ARM::t2HINT, Convert__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 836 /* orn */, ARM::t2ORNrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 836 /* orn */, ARM::t2ORNrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 836 /* orn */, ARM::t2ORNri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 836 /* orn */, ARM::t2ORRri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 836 /* orn */, ARM::t2ORNrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 836 /* orn */, ARM::t2ORNrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 836 /* orn */, ARM::t2ORNri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 836 /* orn */, ARM::t2ORRri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 836 /* orn */, ARM::t2ORNrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 836 /* orn */, ARM::t2ORNrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 836 /* orn */, ARM::t2ORNri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 840 /* orr */, ARM::tORR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 840 /* orr */, ARM::t2ORRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 840 /* orr */, ARM::t2ORRrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::t2ORRri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 840 /* orr */, ARM::t2ORNri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 840 /* orr */, ARM::ORRrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 840 /* orr */, ARM::ORRri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 840 /* orr */, ARM::ORRrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::ORRrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 840 /* orr */, ARM::t2ORRrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 840 /* orr */, ARM::t2ORRrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::t2ORRri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 840 /* orr */, ARM::t2ORRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 840 /* orr */, ARM::t2ORRrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::t2ORRri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 840 /* orr */, ARM::t2ORNri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 840 /* orr */, ARM::ORRrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 840 /* orr */, ARM::ORRri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 840 /* orr */, ARM::ORRrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::ORRrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 840 /* orr */, ARM::t2ORRrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 840 /* orr */, ARM::t2ORRrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 840 /* orr */, ARM::t2ORRri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 844 /* pac */, ARM::t2PAC, Convert_NoOperands, AMFBS_HasV7_IsMClass, { MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 844 /* pac */, ARM::t2HINT, Convert__imm_95_29__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 848 /* pacbti */, ARM::t2PACBTI, Convert_NoOperands, AMFBS_HasV7_IsMClass, { MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 848 /* pacbti */, ARM::t2HINT, Convert__imm_95_13__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_R12, MCK_GPRlr, MCK_GPRsp }, },
  { 855 /* pacg */, ARM::t2PACG, Convert__Reg1_1__CondCode2_0__Reg1_2__Reg1_3, AMFBS_IsThumb2_HasV8_1MMainline_HasPACBTI, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_GPRnopc }, },
  { 860 /* pkhbt */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 860 /* pkhbt */, ARM::PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 860 /* pkhbt */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_PKHLSLImm }, },
  { 860 /* pkhbt */, ARM::PKHBT, Convert__Reg1_1__Reg1_2__Reg1_3__PKHLSLImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_PKHLSLImm }, },
  { 866 /* pkhtb */, ARM::t2PKHBT, Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 866 /* pkhtb */, ARM::PKHBT, Convert__Reg1_1__Reg1_3__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 866 /* pkhtb */, ARM::t2PKHTB, Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_PKHASRImm }, },
  { 866 /* pkhtb */, ARM::PKHTB, Convert__Reg1_1__Reg1_2__Reg1_3__PKHASRImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_PKHASRImm }, },
  { 872 /* pld */, ARM::PLDi12, Convert__MemImm12Offset2_0, AMFBS_IsARM, { MCK_MemImm12Offset }, },
  { 872 /* pld */, ARM::PLDrs, Convert__MemRegOffset3_0, AMFBS_IsARM, { MCK_MemRegOffset }, },
  { 872 /* pld */, ARM::t2PLDpci, Convert__Imm1_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm }, },
  { 872 /* pld */, ARM::t2PLDi8, Convert__MemNegImm8Offset2_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 872 /* pld */, ARM::t2PLDi12, Convert__MemUImm12Offset2_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 872 /* pld */, ARM::t2PLDs, Convert__T2MemRegOffset3_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 872 /* pld */, ARM::t2PLDpci, Convert__MemPCRelImm121_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_MemPCRelImm12 }, },
  { 872 /* pld */, ARM::t2PLDpci, Convert__Imm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_Imm }, },
  { 872 /* pld */, ARM::t2PLDi8, Convert__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_MemNegImm8Offset }, },
  { 872 /* pld */, ARM::t2PLDi12, Convert__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_MemUImm12Offset }, },
  { 872 /* pld */, ARM::t2PLDs, Convert__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_T2MemRegOffset }, },
  { 872 /* pld */, ARM::t2PLDpci, Convert__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_MemPCRelImm12 }, },
  { 876 /* pldw */, ARM::PLDWi12, Convert__MemImm12Offset2_0, AMFBS_IsARM_HasV7_HasMP, { MCK_MemImm12Offset }, },
  { 876 /* pldw */, ARM::PLDWrs, Convert__MemRegOffset3_0, AMFBS_IsARM_HasV7_HasMP, { MCK_MemRegOffset }, },
  { 876 /* pldw */, ARM::t2PLDWi8, Convert__MemNegImm8Offset2_1__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 876 /* pldw */, ARM::t2PLDWi12, Convert__MemUImm12Offset2_1__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 876 /* pldw */, ARM::t2PLDWs, Convert__T2MemRegOffset3_1__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 876 /* pldw */, ARM::t2PLDWi8, Convert__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK__DOT_w, MCK_MemNegImm8Offset }, },
  { 876 /* pldw */, ARM::t2PLDWi12, Convert__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK__DOT_w, MCK_MemUImm12Offset }, },
  { 876 /* pldw */, ARM::t2PLDWs, Convert__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2_HasV7_HasMP, { MCK_CondCode, MCK__DOT_w, MCK_T2MemRegOffset }, },
  { 881 /* pli */, ARM::PLIi12, Convert__MemImm12Offset2_0, AMFBS_IsARM_HasV7, { MCK_MemImm12Offset }, },
  { 881 /* pli */, ARM::PLIrs, Convert__MemRegOffset3_0, AMFBS_IsARM_HasV7, { MCK_MemRegOffset }, },
  { 881 /* pli */, ARM::t2PLIpci, Convert__Imm1_1__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK_Imm }, },
  { 881 /* pli */, ARM::t2PLIi8, Convert__MemNegImm8Offset2_1__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK_MemNegImm8Offset }, },
  { 881 /* pli */, ARM::t2PLIi12, Convert__MemUImm12Offset2_1__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK_MemUImm12Offset }, },
  { 881 /* pli */, ARM::t2PLIs, Convert__T2MemRegOffset3_1__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK_T2MemRegOffset }, },
  { 881 /* pli */, ARM::t2PLIpci, Convert__MemPCRelImm121_1__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK_MemPCRelImm12 }, },
  { 881 /* pli */, ARM::t2PLIpci, Convert__Imm1_2__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK__DOT_w, MCK_Imm }, },
  { 881 /* pli */, ARM::t2PLIi8, Convert__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK__DOT_w, MCK_MemNegImm8Offset }, },
  { 881 /* pli */, ARM::t2PLIi12, Convert__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK__DOT_w, MCK_MemUImm12Offset }, },
  { 881 /* pli */, ARM::t2PLIs, Convert__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK__DOT_w, MCK_T2MemRegOffset }, },
  { 881 /* pli */, ARM::t2PLIpci, Convert__MemPCRelImm121_2__CondCode2_0, AMFBS_IsThumb2_HasV7, { MCK_CondCode, MCK__DOT_w, MCK_MemPCRelImm12 }, },
  { 885 /* pop */, ARM::tPOP, Convert__CondCode2_0__RegList1_1, AMFBS_IsThumb, { MCK_CondCode, MCK_RegList }, },
  { 885 /* pop */, ARM::t2LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, AMFBS_IsThumb2, { MCK_CondCode, MCK_RegList }, },
  { 885 /* pop */, ARM::LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, AMFBS_IsARM, { MCK_CondCode, MCK_RegList }, },
  { 885 /* pop */, ARM::t2LDMIA_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_RegList }, },
  { 889 /* pssbb */, ARM::t2DSB, Convert__imm_95_4__imm_95_14__reg0, AMFBS_HasDB_IsThumb2, {  }, },
  { 889 /* pssbb */, ARM::DSB, Convert__imm_95_4, AMFBS_IsARM_HasDB, {  }, },
  { 895 /* push */, ARM::tPUSH, Convert__CondCode2_0__RegList1_1, AMFBS_IsThumb, { MCK_CondCode, MCK_RegList }, },
  { 895 /* push */, ARM::t2STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, AMFBS_IsThumb2, { MCK_CondCode, MCK_RegList }, },
  { 895 /* push */, ARM::STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_1, AMFBS_IsARM, { MCK_CondCode, MCK_RegList }, },
  { 895 /* push */, ARM::t2STMDB_UPD, Convert__regSP__Tie0_1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_RegList }, },
  { 900 /* qadd */, ARM::t2QADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 900 /* qadd */, ARM::QADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 905 /* qadd16 */, ARM::t2QADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 905 /* qadd16 */, ARM::QADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 912 /* qadd8 */, ARM::t2QADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 912 /* qadd8 */, ARM::QADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 918 /* qasx */, ARM::t2QASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 918 /* qasx */, ARM::QASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 923 /* qdadd */, ARM::t2QDADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 923 /* qdadd */, ARM::QDADD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 929 /* qdsub */, ARM::t2QDSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 929 /* qdsub */, ARM::QDSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 935 /* qsax */, ARM::t2QSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 935 /* qsax */, ARM::QSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 940 /* qsub */, ARM::t2QSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 940 /* qsub */, ARM::QSUB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 945 /* qsub16 */, ARM::t2QSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 945 /* qsub16 */, ARM::QSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 952 /* qsub8 */, ARM::t2QSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 952 /* qsub8 */, ARM::QSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 958 /* rbit */, ARM::t2RBIT, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 958 /* rbit */, ARM::RBIT, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 963 /* rev */, ARM::tREV, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 963 /* rev */, ARM::t2REV, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 963 /* rev */, ARM::REV, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 963 /* rev */, ARM::t2REV, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 967 /* rev16 */, ARM::tREV16, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 967 /* rev16 */, ARM::t2REV16, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 967 /* rev16 */, ARM::REV16, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 967 /* rev16 */, ARM::t2REV16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 973 /* revsh */, ARM::tREVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 973 /* revsh */, ARM::t2REVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 973 /* revsh */, ARM::REVSH, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 973 /* revsh */, ARM::t2REVSH, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 979 /* rfeda */, ARM::RFEDA, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR }, },
  { 979 /* rfeda */, ARM::RFEDA_UPD, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 985 /* rfedb */, ARM::RFEDB, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR }, },
  { 985 /* rfedb */, ARM::RFEDB_UPD, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 985 /* rfedb */, ARM::t2RFEDB, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR }, },
  { 985 /* rfedb */, ARM::t2RFEDBW, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_ }, },
  { 991 /* rfeia */, ARM::RFEIA, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR }, },
  { 991 /* rfeia */, ARM::RFEIA_UPD, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 991 /* rfeia */, ARM::t2RFEIA, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR }, },
  { 991 /* rfeia */, ARM::t2RFEIAW, Convert__Reg1_1__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_ }, },
  { 997 /* rfeib */, ARM::RFEIB, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR }, },
  { 997 /* rfeib */, ARM::RFEIB_UPD, Convert__Reg1_0, AMFBS_IsARM, { MCK_GPR, MCK__EXCLAIM_ }, },
  { 1003 /* ror */, ARM::tROR, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1003 /* ror */, ARM::t2RORrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1003 /* ror */, ARM::t2RORri, Convert__Reg1_2__Reg1_2__Imm1_311_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_Imm1_31 }, },
  { 1003 /* ror */, ARM::RORr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1003 /* ror */, ARM::RORi, Convert__Reg1_2__Reg1_2__Imm0_311_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_Imm0_31 }, },
  { 1003 /* ror */, ARM::t2RORrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1003 /* ror */, ARM::t2RORri, Convert__Reg1_3__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_Imm1_31 }, },
  { 1003 /* ror */, ARM::t2RORrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1003 /* ror */, ARM::t2RORri, Convert__Reg1_2__Reg1_3__Imm1_311_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 1003 /* ror */, ARM::RORr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1003 /* ror */, ARM::RORi, Convert__Reg1_2__Reg1_3__Imm0_311_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_Imm0_31 }, },
  { 1003 /* ror */, ARM::t2RORrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1003 /* ror */, ARM::t2RORri, Convert__Reg1_3__Reg1_4__Imm1_311_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_Imm1_31 }, },
  { 1007 /* rrx */, ARM::t2RRX, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1007 /* rrx */, ARM::RRXi, Convert__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1011 /* rsb */, ARM::tRSB, Convert__Reg1_2__CCOut1_0__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK__HASH_0 }, },
  { 1011 /* rsb */, ARM::t2RSBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1011 /* rsb */, ARM::t2RSBrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1011 /* rsb */, ARM::t2RSBri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 1011 /* rsb */, ARM::RSBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1011 /* rsb */, ARM::RSBri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1011 /* rsb */, ARM::RSBrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1011 /* rsb */, ARM::RSBrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 1011 /* rsb */, ARM::t2RSBrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1011 /* rsb */, ARM::t2RSBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1011 /* rsb */, ARM::t2RSBrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1011 /* rsb */, ARM::t2RSBri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 1011 /* rsb */, ARM::RSBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1011 /* rsb */, ARM::RSBri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 1011 /* rsb */, ARM::RSBrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 1011 /* rsb */, ARM::RSBrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 1011 /* rsb */, ARM::t2RSBrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1011 /* rsb */, ARM::t2RSBrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1011 /* rsb */, ARM::t2RSBri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 1015 /* rsc */, ARM::RSCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1015 /* rsc */, ARM::RSCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1015 /* rsc */, ARM::RSCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1015 /* rsc */, ARM::RSCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 1015 /* rsc */, ARM::RSCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1015 /* rsc */, ARM::RSCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 1015 /* rsc */, ARM::RSCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 1015 /* rsc */, ARM::RSCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 1019 /* sadd16 */, ARM::t2SADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1019 /* sadd16 */, ARM::SADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1026 /* sadd8 */, ARM::t2SADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1026 /* sadd8 */, ARM::SADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1032 /* sasx */, ARM::t2SASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1032 /* sasx */, ARM::SASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1037 /* sb */, ARM::SB, Convert_NoOperands, AMFBS_IsARM_HasSB, {  }, },
  { 1037 /* sb */, ARM::t2SB, Convert_NoOperands, AMFBS_IsThumb2_HasSB, {  }, },
  { 1040 /* sbc */, ARM::tSBC, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1040 /* sbc */, ARM::t2SBCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1040 /* sbc */, ARM::t2SBCrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1040 /* sbc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 1040 /* sbc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_2__T2SOImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImmNot }, },
  { 1040 /* sbc */, ARM::SBCrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1040 /* sbc */, ARM::SBCrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1040 /* sbc */, ARM::SBCri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1040 /* sbc */, ARM::ADCri, Convert__Reg1_2__Reg1_2__ModImmNot1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNot }, },
  { 1040 /* sbc */, ARM::SBCrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1040 /* sbc */, ARM::t2SBCrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1040 /* sbc */, ARM::t2SBCrs, Convert__Reg1_3__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1040 /* sbc */, ARM::t2SBCri, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 1040 /* sbc */, ARM::t2SBCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1040 /* sbc */, ARM::t2SBCrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1040 /* sbc */, ARM::t2SBCri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImm }, },
  { 1040 /* sbc */, ARM::t2ADCri, Convert__Reg1_2__Reg1_3__T2SOImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_T2SOImmNot }, },
  { 1040 /* sbc */, ARM::SBCrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1040 /* sbc */, ARM::SBCrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1040 /* sbc */, ARM::SBCri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 1040 /* sbc */, ARM::ADCri, Convert__Reg1_2__Reg1_3__ModImmNot1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNot }, },
  { 1040 /* sbc */, ARM::SBCrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 1040 /* sbc */, ARM::t2SBCrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1040 /* sbc */, ARM::t2SBCrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1044 /* sbfx */, ARM::t2SBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1044 /* sbfx */, ARM::SBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1049 /* sdiv */, ARM::t2SDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasDivideInThumb_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1049 /* sdiv */, ARM::SDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasDivideInARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1054 /* sel */, ARM::SEL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1054 /* sel */, ARM::t2SEL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1058 /* setend */, ARM::tSETEND, Convert__SetEndImm1_0, AMFBS_IsThumb_IsNotMClass, { MCK_SetEndImm }, },
  { 1058 /* setend */, ARM::SETEND, Convert__SetEndImm1_0, AMFBS_IsARM, { MCK_SetEndImm }, },
  { 1065 /* setpan */, ARM::t2SETPAN, Convert__Imm0_11_0, AMFBS_IsThumb2_HasV8_HasV8_1a, { MCK_Imm0_1 }, },
  { 1065 /* setpan */, ARM::SETPAN, Convert__Imm0_11_0, AMFBS_IsARM_HasV8_HasV8_1a, { MCK_Imm0_1 }, },
  { 1072 /* sev */, ARM::tHINT, Convert__imm_95_4__CondCode2_0, AMFBS_IsThumb_HasV6M, { MCK_CondCode }, },
  { 1072 /* sev */, ARM::HINT, Convert__imm_95_4__CondCode2_0, AMFBS_IsARM_HasV6K, { MCK_CondCode }, },
  { 1072 /* sev */, ARM::t2HINT, Convert__imm_95_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w }, },
  { 1076 /* sevl */, ARM::tHINT, Convert__imm_95_5__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode }, },
  { 1076 /* sevl */, ARM::HINT, Convert__imm_95_5__CondCode2_0, AMFBS_IsARM_HasV8, { MCK_CondCode }, },
  { 1076 /* sevl */, ARM::t2HINT, Convert__imm_95_5__CondCode2_0, AMFBS_IsThumb2_HasV8, { MCK_CondCode, MCK__DOT_w }, },
  { 1081 /* sg */, ARM::t2SG, Convert__CondCode2_0, AMFBS_Has8MSecExt, { MCK_CondCode }, },
  { 1084 /* sha1c */, ARM::SHA1C, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1090 /* sha1h */, ARM::SHA1H, Convert__Reg1_1__Reg1_2, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 1096 /* sha1m */, ARM::SHA1M, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1102 /* sha1p */, ARM::SHA1P, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1108 /* sha1su0 */, ARM::SHA1SU0, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1116 /* sha1su1 */, ARM::SHA1SU1, Convert__Reg1_1__Tie0_1_1__Reg1_2, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 1124 /* sha256h */, ARM::SHA256H, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1132 /* sha256h2 */, ARM::SHA256H2, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1141 /* sha256su0 */, ARM::SHA256SU0, Convert__Reg1_1__Tie0_1_1__Reg1_2, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 1151 /* sha256su1 */, ARM::SHA256SU1, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3, AMFBS_HasV8_HasSHA2, { MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 1161 /* shadd16 */, ARM::t2SHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1161 /* shadd16 */, ARM::SHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1169 /* shadd8 */, ARM::t2SHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1169 /* shadd8 */, ARM::SHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1176 /* shasx */, ARM::t2SHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1176 /* shasx */, ARM::SHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1182 /* shsax */, ARM::t2SHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1182 /* shsax */, ARM::SHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1188 /* shsub16 */, ARM::t2SHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1188 /* shsub16 */, ARM::SHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1196 /* shsub8 */, ARM::t2SHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1196 /* shsub8 */, ARM::SHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1203 /* smc */, ARM::SMC, Convert__Imm0_151_1__CondCode2_0, AMFBS_IsARM_HasTrustZone, { MCK_CondCode, MCK_Imm0_15 }, },
  { 1203 /* smc */, ARM::t2SMC, Convert__Imm0_151_1__CondCode2_0, AMFBS_IsThumb2_HasTrustZone, { MCK_CondCode, MCK_Imm0_15 }, },
  { 1207 /* smlabb */, ARM::t2SMLABB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1207 /* smlabb */, ARM::SMLABB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1214 /* smlabt */, ARM::t2SMLABT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1214 /* smlabt */, ARM::SMLABT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1221 /* smlad */, ARM::t2SMLAD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1221 /* smlad */, ARM::SMLAD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1227 /* smladx */, ARM::t2SMLADX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1227 /* smladx */, ARM::SMLADX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1234 /* smlal */, ARM::t2SMLAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1234 /* smlal */, ARM::SMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1234 /* smlal */, ARM::SMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1240 /* smlalbb */, ARM::t2SMLALBB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1240 /* smlalbb */, ARM::SMLALBB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1248 /* smlalbt */, ARM::t2SMLALBT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1248 /* smlalbt */, ARM::SMLALBT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1256 /* smlald */, ARM::t2SMLALD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1256 /* smlald */, ARM::SMLALD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1263 /* smlaldx */, ARM::t2SMLALDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1263 /* smlaldx */, ARM::SMLALDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1271 /* smlaltb */, ARM::t2SMLALTB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1271 /* smlaltb */, ARM::SMLALTB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1279 /* smlaltt */, ARM::t2SMLALTT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1279 /* smlaltt */, ARM::SMLALTT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1287 /* smlatb */, ARM::t2SMLATB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1287 /* smlatb */, ARM::SMLATB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1294 /* smlatt */, ARM::t2SMLATT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1294 /* smlatt */, ARM::SMLATT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1301 /* smlawb */, ARM::t2SMLAWB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1301 /* smlawb */, ARM::SMLAWB, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1308 /* smlawt */, ARM::t2SMLAWT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1308 /* smlawt */, ARM::SMLAWT, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1315 /* smlsd */, ARM::t2SMLSD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1315 /* smlsd */, ARM::SMLSD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1321 /* smlsdx */, ARM::t2SMLSDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1321 /* smlsdx */, ARM::SMLSDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPR }, },
  { 1328 /* smlsld */, ARM::t2SMLSLD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1328 /* smlsld */, ARM::SMLSLD, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1335 /* smlsldx */, ARM::t2SMLSLDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1335 /* smlsldx */, ARM::SMLSLDX, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1343 /* smmla */, ARM::t2SMMLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1343 /* smmla */, ARM::SMMLA, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1349 /* smmlar */, ARM::t2SMMLAR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1349 /* smmlar */, ARM::SMMLAR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1356 /* smmls */, ARM::t2SMMLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1356 /* smmls */, ARM::SMMLS, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1362 /* smmlsr */, ARM::t2SMMLSR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1362 /* smmlsr */, ARM::SMMLSR, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1369 /* smmul */, ARM::t2SMMUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1369 /* smmul */, ARM::SMMUL, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1375 /* smmulr */, ARM::t2SMMULR, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1375 /* smmulr */, ARM::SMMULR, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1382 /* smuad */, ARM::t2SMUAD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1382 /* smuad */, ARM::SMUAD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1388 /* smuadx */, ARM::t2SMUADX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1388 /* smuadx */, ARM::SMUADX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1395 /* smulbb */, ARM::t2SMULBB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1395 /* smulbb */, ARM::SMULBB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1402 /* smulbt */, ARM::t2SMULBT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1402 /* smulbt */, ARM::SMULBT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1409 /* smull */, ARM::t2SMULL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1409 /* smull */, ARM::SMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1409 /* smull */, ARM::SMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1415 /* smultb */, ARM::t2SMULTB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1415 /* smultb */, ARM::SMULTB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1422 /* smultt */, ARM::t2SMULTT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1422 /* smultt */, ARM::SMULTT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1429 /* smulwb */, ARM::t2SMULWB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1429 /* smulwb */, ARM::SMULWB, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1436 /* smulwt */, ARM::t2SMULWT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1436 /* smulwt */, ARM::SMULWT, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1443 /* smusd */, ARM::t2SMUSD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1443 /* smusd */, ARM::SMUSD, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1449 /* smusdx */, ARM::t2SMUSDX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1449 /* smusdx */, ARM::SMUSDX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1456 /* sqrshr */, ARM::MVE_SQRSHR, Convert__Reg1_1__Tie0_2_2__Reg1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1463 /* sqrshrl */, ARM::MVE_SQRSHRL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_4__MveSaturate1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MveSaturate, MCK_rGPR }, },
  { 1471 /* sqshl */, ARM::MVE_SQSHL, Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_MVELongShift }, },
  { 1477 /* sqshll */, ARM::MVE_SQSHLL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 1484 /* srsda */, ARM::SRSDA, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31 }, },
  { 1484 /* srsda */, ARM::SRSDA, Convert__Imm0_311_1, AMFBS_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1484 /* srsda */, ARM::SRSDA_UPD, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1484 /* srsda */, ARM::SRSDA_UPD, Convert__Imm0_311_2, AMFBS_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::SRSDB, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::SRSDB, Convert__Imm0_311_1, AMFBS_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::t2SRSDB, Convert__Imm0_311_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::SRSDB_UPD, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1490 /* srsdb */, ARM::SRSDB_UPD, Convert__Imm0_311_2, AMFBS_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::t2SRSDB, Convert__Imm0_311_2__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_31 }, },
  { 1490 /* srsdb */, ARM::t2SRSDB_UPD, Convert__Imm0_311_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1490 /* srsdb */, ARM::t2SRSDB_UPD, Convert__Imm0_311_3__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1496 /* srshr */, ARM::MVE_SRSHR, Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_MVELongShift }, },
  { 1502 /* srshrl */, ARM::MVE_SRSHRL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 1509 /* srsia */, ARM::SRSIA, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31 }, },
  { 1509 /* srsia */, ARM::SRSIA, Convert__Imm0_311_1, AMFBS_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1509 /* srsia */, ARM::t2SRSIA, Convert__Imm0_311_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_31 }, },
  { 1509 /* srsia */, ARM::SRSIA_UPD, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1509 /* srsia */, ARM::SRSIA_UPD, Convert__Imm0_311_2, AMFBS_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1509 /* srsia */, ARM::t2SRSIA, Convert__Imm0_311_2__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_31 }, },
  { 1509 /* srsia */, ARM::t2SRSIA_UPD, Convert__Imm0_311_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1509 /* srsia */, ARM::t2SRSIA_UPD, Convert__Imm0_311_3__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1515 /* srsib */, ARM::SRSIB, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31 }, },
  { 1515 /* srsib */, ARM::SRSIB, Convert__Imm0_311_1, AMFBS_IsARM, { MCK_GPRsp, MCK_Imm0_31 }, },
  { 1515 /* srsib */, ARM::SRSIB_UPD, Convert__Imm0_311_0, AMFBS_IsARM, { MCK_Imm0_31, MCK__EXCLAIM_ }, },
  { 1515 /* srsib */, ARM::SRSIB_UPD, Convert__Imm0_311_2, AMFBS_IsARM, { MCK_GPRsp, MCK__EXCLAIM_, MCK_Imm0_31 }, },
  { 1521 /* ssat */, ARM::t2SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm1_32, MCK_rGPR }, },
  { 1521 /* ssat */, ARM::SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_32, MCK_GPRnopc }, },
  { 1521 /* ssat */, ARM::t2SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm1_32, MCK_rGPR, MCK_ShifterImm }, },
  { 1521 /* ssat */, ARM::SSAT, Convert__Reg1_1__Imm1_321_2__Reg1_3__ShifterImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_32, MCK_GPRnopc, MCK_ShifterImm }, },
  { 1526 /* ssat16 */, ARM::t2SSAT16, Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_Imm1_16, MCK_rGPR }, },
  { 1526 /* ssat16 */, ARM::SSAT16, Convert__Reg1_1__Imm1_161_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm1_16, MCK_GPRnopc }, },
  { 1533 /* ssax */, ARM::t2SSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1533 /* ssax */, ARM::SSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1538 /* ssbb */, ARM::t2DSB, Convert__imm_95_0__imm_95_14__reg0, AMFBS_HasDB_IsThumb2, {  }, },
  { 1538 /* ssbb */, ARM::DSB, Convert__imm_95_0, AMFBS_IsARM_HasDB, {  }, },
  { 1543 /* ssub16 */, ARM::t2SSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1543 /* ssub16 */, ARM::SSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1550 /* ssub8 */, ARM::t2SSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1550 /* ssub8 */, ARM::SSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1556 /* stc */, ARM::STC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1556 /* stc */, ARM::t2STC_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1556 /* stc */, ARM::STC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1556 /* stc */, ARM::t2STC_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1556 /* stc */, ARM::STC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1556 /* stc */, ARM::t2STC_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1556 /* stc */, ARM::STC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1556 /* stc */, ARM::t2STC_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1560 /* stc2 */, ARM::STC2_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1560 /* stc2 */, ARM::t2STC2_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1560 /* stc2 */, ARM::STC2_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1560 /* stc2 */, ARM::STC2_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1560 /* stc2 */, ARM::STC2_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1560 /* stc2 */, ARM::t2STC2_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1560 /* stc2 */, ARM::t2STC2_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1560 /* stc2 */, ARM::t2STC2_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1565 /* stc2l */, ARM::STC2L_OFFSET, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1565 /* stc2l */, ARM::t2STC2L_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1565 /* stc2l */, ARM::STC2L_PRE, Convert__CoprocNum1_0__CoprocReg1_1__AddrMode52_2, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1565 /* stc2l */, ARM::STC2L_OPTION, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__CoprocOption1_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1565 /* stc2l */, ARM::STC2L_POST, Convert__CoprocNum1_0__CoprocReg1_1__MemNoOffset1_2__PostIdxImm8s41_3, AMFBS_IsARM_PreV8, { MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1565 /* stc2l */, ARM::t2STC2L_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1565 /* stc2l */, ARM::t2STC2L_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1565 /* stc2l */, ARM::t2STC2L_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_PreV8_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1571 /* stcl */, ARM::STCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1571 /* stcl */, ARM::t2STCL_OFFSET, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5 }, },
  { 1571 /* stcl */, ARM::STCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1571 /* stcl */, ARM::t2STCL_PRE, Convert__CoprocNum1_1__CoprocReg1_2__AddrMode52_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_AddrMode5, MCK__EXCLAIM_ }, },
  { 1571 /* stcl */, ARM::STCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1571 /* stcl */, ARM::t2STCL_OPTION, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__CoprocOption1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_CoprocOption }, },
  { 1571 /* stcl */, ARM::STCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1571 /* stcl */, ARM::t2STCL_POST, Convert__CoprocNum1_1__CoprocReg1_2__MemNoOffset1_3__PostIdxImm8s41_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_CoprocNum, MCK_CoprocReg, MCK_MemNoOffset, MCK_PostIdxImm8s4 }, },
  { 1576 /* stl */, ARM::t2STL, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1576 /* stl */, ARM::STL, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1580 /* stlb */, ARM::t2STLB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1580 /* stlb */, ARM::STLB, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1585 /* stlex */, ARM::t2STLEX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1585 /* stlex */, ARM::STLEX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1591 /* stlexb */, ARM::t2STLEXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1591 /* stlexb */, ARM::STLEXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1598 /* stlexd */, ARM::STLEXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPRPair, MCK_MemNoOffset }, },
  { 1598 /* stlexd */, ARM::t2STLEXD, Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1605 /* stlexh */, ARM::t2STLEXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1605 /* stlexh */, ARM::STLEXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_HasAcquireRelease_HasV7Clrex, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1612 /* stlh */, ARM::t2STLH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsThumb_HasAcquireRelease, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset }, },
  { 1612 /* stlh */, ARM::STLH, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM_HasAcquireRelease, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1617 /* stm */, ARM::tSTMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1617 /* stm */, ARM::STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1617 /* stm */, ARM::t2STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1617 /* stm */, ARM::t2STMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1617 /* stm */, ARM::t2STMIA, Convert__Reg1_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 1617 /* stm */, ARM::STMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1617 /* stm */, ARM::t2STMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1617 /* stm */, ARM::sysSTMIA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1617 /* stm */, ARM::t2STMIA_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1617 /* stm */, ARM::sysSTMIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1621 /* stmda */, ARM::STMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1621 /* stmda */, ARM::STMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1621 /* stmda */, ARM::sysSTMDA, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1621 /* stmda */, ARM::sysSTMDA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1627 /* stmdb */, ARM::STMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::t2STMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::t2STMDB, Convert__Reg1_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::STMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::t2STMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::sysSTMDB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1627 /* stmdb */, ARM::t2STMDB_UPD, Convert__Reg1_2__Tie0_3_3__CondCode2_0__RegList1_4, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1627 /* stmdb */, ARM::sysSTMDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1633 /* stmib */, ARM::STMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList }, },
  { 1633 /* stmib */, ARM::STMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList }, },
  { 1633 /* stmib */, ARM::sysSTMIB, Convert__Reg1_1__CondCode2_0__RegList1_2, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegList, MCK__94_ }, },
  { 1633 /* stmib */, ARM::sysSTMIB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__RegList1_3, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_RegList, MCK__94_ }, },
  { 1639 /* str */, ARM::tSTRi, Convert__Reg1_1__MemThumbRIs42_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs4 }, },
  { 1639 /* str */, ARM::tSTRr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1639 /* str */, ARM::tSTRspi, Convert__Reg1_1__MemThumbSPI2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbSPI }, },
  { 1639 /* str */, ARM::STRi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset }, },
  { 1639 /* str */, ARM::t2STRi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 1639 /* str */, ARM::STRrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset }, },
  { 1639 /* str */, ARM::t2STRi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_MemUImm12Offset }, },
  { 1639 /* str */, ARM::t2STRs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPR, MCK_T2MemRegOffset }, },
  { 1639 /* str */, ARM::t2STRi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemUImm12Offset }, },
  { 1639 /* str */, ARM::t2STRs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_T2MemRegOffset }, },
  { 1639 /* str */, ARM::t2STR_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1639 /* str */, ARM::t2STR_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRnopc, MCK_MemNoOffset, MCK_Imm }, },
  { 1639 /* str */, ARM::STR_PRE_IMM, Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 1639 /* str */, ARM::STR_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1639 /* str */, ARM::STR_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1639 /* str */, ARM::STR_PRE_REG, Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 1639 /* str */, ARM::t2STR_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1639 /* str */, ARM::t2STR_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1643 /* strb */, ARM::tSTRBi, Convert__Reg1_1__MemThumbRIs12_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs1 }, },
  { 1643 /* strb */, ARM::tSTRBr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1643 /* strb */, ARM::t2STRBi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNegImm8Offset }, },
  { 1643 /* strb */, ARM::t2STRBi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1643 /* strb */, ARM::t2STRBs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1643 /* strb */, ARM::STRBi12, Convert__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemImm12Offset }, },
  { 1643 /* strb */, ARM::STRBrs, Convert__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_MemRegOffset }, },
  { 1643 /* strb */, ARM::t2STRBi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1643 /* strb */, ARM::t2STRBs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1643 /* strb */, ARM::t2STRB_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 1643 /* strb */, ARM::t2STRB_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1643 /* strb */, ARM::t2STRB_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1643 /* strb */, ARM::STRB_PRE_IMM, Convert__imm_95_0__Reg1_1__MemImm12Offset2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemImm12Offset, MCK__EXCLAIM_ }, },
  { 1643 /* strb */, ARM::STRB_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1643 /* strb */, ARM::STRB_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1643 /* strb */, ARM::STRB_PRE_REG, Convert__imm_95_0__Reg1_1__MemRegOffset3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemRegOffset, MCK__EXCLAIM_ }, },
  { 1643 /* strb */, ARM::t2STRB_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1643 /* strb */, ARM::t2STRB_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1648 /* strbt */, ARM::t2STRBT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 1648 /* strbt */, ARM::STRBT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1648 /* strbt */, ARM::STRBT_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1648 /* strbt */, ARM::STRBT_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1654 /* strd */, ARM::t2STRDi8, Convert__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset }, },
  { 1654 /* strd */, ARM::STRD, Convert__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, AMFBS_IsARM_HasV5TE, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3 }, },
  { 1654 /* strd */, ARM::t2STRD_PRE, Convert__imm_95_0__Reg1_1__Reg1_2__MemImm8s4Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm8s4Offset, MCK__EXCLAIM_ }, },
  { 1654 /* strd */, ARM::t2STRD_POST, Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1654 /* strd */, ARM::STRD_PRE, Convert__imm_95_0__Reg1_1__Reg1_2__AddrMode33_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 1654 /* strd */, ARM::STRD_POST, Convert__MemNoOffset1_3__Reg1_1__Reg1_2__Tie0_4_4__AM3Offset2_4__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 1659 /* strex */, ARM::t2STREX, Convert__Reg1_1__Reg1_2__MemImm0_1020s4Offset2_3__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemImm0_1020s4Offset }, },
  { 1659 /* strex */, ARM::STREX, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1665 /* strexb */, ARM::t2STREXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1665 /* strexb */, ARM::STREXB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1672 /* strexd */, ARM::STREXD, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPRPair, MCK_MemNoOffset }, },
  { 1672 /* strexd */, ARM::t2STREXD, Convert__Reg1_1__Reg1_2__Reg1_3__MemNoOffset1_4__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1679 /* strexh */, ARM::t2STREXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_MemNoOffset }, },
  { 1679 /* strexh */, ARM::STREXH, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_MemNoOffset }, },
  { 1686 /* strh */, ARM::tSTRHi, Convert__Reg1_1__MemThumbRIs22_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRIs2 }, },
  { 1686 /* strh */, ARM::tSTRHr, Convert__Reg1_1__MemThumbRR2_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_MemThumbRR }, },
  { 1686 /* strh */, ARM::t2STRHi8, Convert__Reg1_1__MemNegImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNegImm8Offset }, },
  { 1686 /* strh */, ARM::t2STRHi12, Convert__Reg1_1__MemUImm12Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1686 /* strh */, ARM::t2STRHs, Convert__Reg1_1__T2MemRegOffset3_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1686 /* strh */, ARM::STRH, Convert__Reg1_1__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3 }, },
  { 1686 /* strh */, ARM::t2STRHi12, Convert__Reg1_2__MemUImm12Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_MemUImm12Offset }, },
  { 1686 /* strh */, ARM::t2STRHs, Convert__Reg1_2__T2MemRegOffset3_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2MemRegOffset }, },
  { 1686 /* strh */, ARM::t2STRH_OFFSET_imm, Convert__Reg1_2__MemNegImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNegImm8Offset }, },
  { 1686 /* strh */, ARM::t2STRH_PRE, Convert__imm_95_0__Reg1_1__MemImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1686 /* strh */, ARM::t2STRH_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__Imm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1686 /* strh */, ARM::STRH_PRE, Convert__imm_95_0__Reg1_1__AddrMode33_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_AddrMode3, MCK__EXCLAIM_ }, },
  { 1686 /* strh */, ARM::STRH_POST, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM3Offset2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM3Offset }, },
  { 1686 /* strh */, ARM::t2STRH_PRE_imm, Convert__Reg1_2__MemImm8Offset2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemImm8Offset, MCK__EXCLAIM_ }, },
  { 1686 /* strh */, ARM::t2STRH_POST_imm, Convert__Reg1_2__MemNoOffset1_3__Imm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_GPR, MCK_MemNoOffset, MCK_Imm }, },
  { 1691 /* strht */, ARM::t2STRHT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 1691 /* strht */, ARM::STRHTi, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxImm81_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxImm8 }, },
  { 1691 /* strht */, ARM::STRHTr, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxReg2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxReg }, },
  { 1697 /* strt */, ARM::t2STRT, Convert__Reg1_1__MemPosImm8Offset2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_MemPosImm8Offset }, },
  { 1697 /* strt */, ARM::STRT_POST, Convert__Reg1_1__MemNoOffset1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset }, },
  { 1697 /* strt */, ARM::STRT_POST_IMM, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__AM2OffsetImm2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_AM2OffsetImm }, },
  { 1697 /* strt */, ARM::STRT_POST_REG, Convert__MemNoOffset1_2__Reg1_1__Tie0_3_3__PostIdxRegShifted2_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_MemNoOffset, MCK_PostIdxRegShifted }, },
  { 1702 /* sub */, ARM::tSUBspi, Convert__Reg1_1__Tie0_1_1__Imm0_508s41_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 1702 /* sub */, ARM::tSUBrr, Convert__Reg1_2__CCOut1_0__Reg1_2__Reg1_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1702 /* sub */, ARM::tSUBi8, Convert__Reg1_2__CCOut1_0__Tie0_1_1__Imm0_2551_3__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_Imm0_255 }, },
  { 1702 /* sub */, ARM::tADDi8, Convert__Reg1_2__CCOut1_0__Tie0_3_3__ThumbModImmNeg8_2551_3__CondCode2_1, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_ThumbModImmNeg8_255 }, },
  { 1702 /* sub */, ARM::tSUBspi, Convert__regSP__Tie0_1_1__Imm0_508s41_3__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_508s4 }, },
  { 1702 /* sub */, ARM::tSUBrr, Convert__Reg1_2__CCOut1_0__Reg1_3__Reg1_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_tGPR }, },
  { 1702 /* sub */, ARM::tSUBi3, Convert__Reg1_2__CCOut1_0__Reg1_3__Imm0_71_4__CondCode2_1, AMFBS_IsThumb, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_Imm0_7 }, },
  { 1702 /* sub */, ARM::tADDi3, Convert__Reg1_2__CCOut1_0__Reg1_3__ThumbModImmNeg1_71_4__CondCode2_1, AMFBS_IsThumb_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_tGPR, MCK_tGPR, MCK_ThumbModImmNeg1_7 }, },
  { 1702 /* sub */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 1702 /* sub */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095 }, },
  { 1702 /* sub */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2SUBri, Convert__Reg1_2__Reg1_2__T2SOImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2SUBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_rGPR }, },
  { 1702 /* sub */, ARM::t2SUBrs, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1702 /* sub */, ARM::SUBrr, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1702 /* sub */, ARM::SUBri, Convert__Reg1_2__Reg1_2__ModImm1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1702 /* sub */, ARM::ADDri, Convert__Reg1_2__Reg1_2__ModImmNeg1_3__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_ModImmNeg }, },
  { 1702 /* sub */, ARM::SUBrsi, Convert__Reg1_2__Reg1_2__RegShiftedImm2_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1702 /* sub */, ARM::SUBrsr, Convert__Reg1_2__Reg1_2__RegShiftedReg3_3__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_RegShiftedReg }, },
  { 1702 /* sub */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 1702 /* sub */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 1702 /* sub */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095 }, },
  { 1702 /* sub */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 1702 /* sub */, ARM::t2SUBspImm, Convert__Reg1_3__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2SUBrr, Convert__Reg1_3__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_rGPR }, },
  { 1702 /* sub */, ARM::t2SUBspImm, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2ADDspImm, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 1702 /* sub */, ARM::t2SUBri, Convert__Reg1_2__Reg1_3__T2SOImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2ADDri, Convert__Reg1_2__Reg1_3__T2SOImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 1702 /* sub */, ARM::t2SUBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 1702 /* sub */, ARM::t2SUBrs, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1702 /* sub */, ARM::SUBrr, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1702 /* sub */, ARM::SUBri, Convert__Reg1_2__Reg1_3__ModImm1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImm }, },
  { 1702 /* sub */, ARM::ADDri, Convert__Reg1_2__Reg1_3__ModImmNeg1_4__CondCode2_1__CCOut1_0, AMFBS_IsARM_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_ModImmNeg }, },
  { 1702 /* sub */, ARM::SUBrsi, Convert__Reg1_2__Reg1_3__RegShiftedImm2_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedImm }, },
  { 1702 /* sub */, ARM::SUBrsr, Convert__Reg1_2__Reg1_3__RegShiftedReg3_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_RegShiftedReg }, },
  { 1702 /* sub */, ARM::t2SUBspImm, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2ADDspImm, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRsp, MCK_GPRsp, MCK_T2SOImmNeg }, },
  { 1702 /* sub */, ARM::t2SUBri, Convert__Reg1_3__Reg1_4__T2SOImm1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImm }, },
  { 1702 /* sub */, ARM::t2ADDri, Convert__Reg1_3__Reg1_4__T2SOImmNeg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_GPRnopc, MCK_T2SOImmNeg }, },
  { 1702 /* sub */, ARM::t2SUBrr, Convert__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_rGPR }, },
  { 1702 /* sub */, ARM::t2SUBrs, Convert__Reg1_3__Reg1_4__RegShiftedImm2_5__CondCode2_1__CCOut1_0, AMFBS_IsThumb2, { MCK_CCOut, MCK_CondCode, MCK__DOT_w, MCK_GPRnopc, MCK_GPRnopc, MCK_RegShiftedImm }, },
  { 1706 /* subs */, ARM::t2SUBS_PC_LR, Convert__Imm0_2551_3__CondCode2_0, AMFBS_IsThumb2_IsNotMClass, { MCK_CondCode, MCK_PC, MCK_GPRlr, MCK_Imm0_255 }, },
  { 1711 /* subw */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 1711 /* subw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_1__Imm0_40951_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_4095 }, },
  { 1711 /* subw */, ARM::t2SUBspImm12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095 }, },
  { 1711 /* subw */, ARM::t2ADDspImm12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_GPRsp, MCK_GPRsp, MCK_Imm0_4095Neg }, },
  { 1711 /* subw */, ARM::t2SUBri12, Convert__Reg1_1__Reg1_2__Imm0_40951_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095 }, },
  { 1711 /* subw */, ARM::t2ADDri12, Convert__Reg1_1__Reg1_2__Imm0_4095Neg1_3__CondCode2_0, AMFBS_IsThumb2_UseNegativeImmediates, { MCK_CondCode, MCK_rGPR, MCK_GPR, MCK_Imm0_4095Neg }, },
  { 1716 /* svc */, ARM::tSVC, Convert__Imm0_2551_1__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_Imm0_255 }, },
  { 1716 /* svc */, ARM::SVC, Convert__Imm24bit1_1__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_Imm24bit }, },
  { 1720 /* swp */, ARM::SWP, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_PreV8, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_MemNoOffset }, },
  { 1724 /* swpb */, ARM::SWPB, Convert__Reg1_1__Reg1_2__MemNoOffset1_3__CondCode2_0, AMFBS_IsARM_PreV8, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_MemNoOffset }, },
  { 1729 /* sxtab */, ARM::t2SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1729 /* sxtab */, ARM::SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1729 /* sxtab */, ARM::t2SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1729 /* sxtab */, ARM::SXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1735 /* sxtab16 */, ARM::t2SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1735 /* sxtab16 */, ARM::SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1735 /* sxtab16 */, ARM::t2SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1735 /* sxtab16 */, ARM::SXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1743 /* sxtah */, ARM::t2SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1743 /* sxtah */, ARM::SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 1743 /* sxtah */, ARM::t2SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1743 /* sxtah */, ARM::SXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 1749 /* sxtb */, ARM::tSXTB, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1749 /* sxtb */, ARM::t2SXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1749 /* sxtb */, ARM::SXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1749 /* sxtb */, ARM::t2SXTB, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1749 /* sxtb */, ARM::t2SXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1749 /* sxtb */, ARM::SXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1749 /* sxtb */, ARM::t2SXTB, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1754 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1754 /* sxtb16 */, ARM::SXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1754 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1754 /* sxtb16 */, ARM::t2SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1754 /* sxtb16 */, ARM::SXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1761 /* sxth */, ARM::tSXTH, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1761 /* sxth */, ARM::t2SXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1761 /* sxth */, ARM::SXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1761 /* sxth */, ARM::t2SXTH, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1761 /* sxth */, ARM::t2SXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1761 /* sxth */, ARM::SXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 1761 /* sxth */, ARM::t2SXTH, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 1766 /* tbb */, ARM::t2TBB, Convert__MemTBB2_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_MemTBB }, },
  { 1770 /* tbh */, ARM::t2TBH, Convert__MemTBH2_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_MemTBH }, },
  { 1774 /* teq */, ARM::t2TEQrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1774 /* teq */, ARM::t2TEQrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1774 /* teq */, ARM::t2TEQri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 1774 /* teq */, ARM::TEQrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1774 /* teq */, ARM::TEQrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1774 /* teq */, ARM::TEQri, Convert__Reg1_1__ModImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1774 /* teq */, ARM::TEQrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1774 /* teq */, ARM::t2TEQrr, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1774 /* teq */, ARM::t2TEQrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1774 /* teq */, ARM::t2TEQri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 1778 /* trap */, ARM::tTRAP, Convert_NoOperands, AMFBS_IsThumb, {  }, },
  { 1778 /* trap */, ARM::TRAPNaCl, Convert_NoOperands, AMFBS_IsARM_UseNaClTrap, {  }, },
  { 1778 /* trap */, ARM::TRAP, Convert_NoOperands, AMFBS_IsARM, {  }, },
  { 1783 /* tsb */, ARM::TSB, Convert__TraceSyncBarrierOpt1_0, AMFBS_IsARM_HasV8_4a, { MCK_TraceSyncBarrierOpt }, },
  { 1783 /* tsb */, ARM::t2TSB, Convert__TraceSyncBarrierOpt1_1__CondCode2_0, AMFBS_IsThumb_HasV8_4a, { MCK_CondCode, MCK_TraceSyncBarrierOpt }, },
  { 1787 /* tst */, ARM::tTST, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 1787 /* tst */, ARM::t2TSTrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1787 /* tst */, ARM::t2TSTrs, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1787 /* tst */, ARM::t2TSTri, Convert__Reg1_1__T2SOImm1_2__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_T2SOImm }, },
  { 1787 /* tst */, ARM::TSTrsr, Convert__Reg1_1__RegShiftedReg3_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_RegShiftedReg }, },
  { 1787 /* tst */, ARM::TSTrr, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_GPR }, },
  { 1787 /* tst */, ARM::TSTri, Convert__Reg1_1__ModImm1_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_ModImm }, },
  { 1787 /* tst */, ARM::TSTrsi, Convert__Reg1_1__RegShiftedImm2_2__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPR, MCK_RegShiftedImm }, },
  { 1787 /* tst */, ARM::t2TSTrr, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 1787 /* tst */, ARM::t2TSTrs, Convert__Reg1_2__RegShiftedImm2_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_RegShiftedImm }, },
  { 1787 /* tst */, ARM::t2TSTri, Convert__Reg1_2__T2SOImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_T2SOImm }, },
  { 1791 /* tt */, ARM::t2TT, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1794 /* tta */, ARM::t2TTA, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1798 /* ttat */, ARM::t2TTAT, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1803 /* ttt */, ARM::t2TTT, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_Has8MSecExt, { MCK_CondCode, MCK_rGPR, MCK_GPRnopc }, },
  { 1807 /* uadd16 */, ARM::t2UADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1807 /* uadd16 */, ARM::UADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1814 /* uadd8 */, ARM::t2UADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1814 /* uadd8 */, ARM::UADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1820 /* uasx */, ARM::t2UASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1820 /* uasx */, ARM::UASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1825 /* ubfx */, ARM::t2UBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1825 /* ubfx */, ARM::UBFX, Convert__Reg1_1__Reg1_2__Imm0_311_3__Imm1_321_4__CondCode2_0, AMFBS_IsARM_HasV6T2, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_Imm0_31, MCK_Imm1_32 }, },
  { 1830 /* udf */, ARM::tUDF, Convert__Imm0_2551_0, AMFBS_IsThumb, { MCK_Imm0_255 }, },
  { 1830 /* udf */, ARM::UDF, Convert__Imm0_655351_0, AMFBS_IsARM, { MCK_Imm0_65535 }, },
  { 1830 /* udf */, ARM::t2UDF, Convert__Imm0_655351_1, AMFBS_IsThumb2, { MCK__DOT_w, MCK_Imm0_65535 }, },
  { 1834 /* udiv */, ARM::t2UDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasDivideInThumb_IsThumb_HasV8MBaseline, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1834 /* udiv */, ARM::UDIV, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasDivideInARM, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1839 /* uhadd16 */, ARM::t2UHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1839 /* uhadd16 */, ARM::UHADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1847 /* uhadd8 */, ARM::t2UHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1847 /* uhadd8 */, ARM::UHADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1854 /* uhasx */, ARM::t2UHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1854 /* uhasx */, ARM::UHASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1860 /* uhsax */, ARM::t2UHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1860 /* uhsax */, ARM::UHSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1866 /* uhsub16 */, ARM::t2UHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1866 /* uhsub16 */, ARM::UHSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1874 /* uhsub8 */, ARM::t2UHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1874 /* uhsub8 */, ARM::UHSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1881 /* umaal */, ARM::t2UMAAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1881 /* umaal */, ARM::UMAAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1887 /* umlal */, ARM::t2UMLAL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__Tie0_1_1__Tie1_1_1__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1887 /* umlal */, ARM::UMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_1_1__Tie1_1_1__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1887 /* umlal */, ARM::UMLAL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__Tie0_3_3__Tie1_4_4__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1893 /* umull */, ARM::t2UMULL, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1893 /* umull */, ARM::UMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM_HasV6, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1893 /* umull */, ARM::UMULL, Convert__Reg1_2__Reg1_3__Reg1_4__Reg1_5__CondCode2_1__CCOut1_0, AMFBS_IsARM, { MCK_CCOut, MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1899 /* uqadd16 */, ARM::t2UQADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1899 /* uqadd16 */, ARM::UQADD16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1907 /* uqadd8 */, ARM::t2UQADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1907 /* uqadd8 */, ARM::UQADD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1914 /* uqasx */, ARM::t2UQASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1914 /* uqasx */, ARM::UQASX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1920 /* uqrshl */, ARM::MVE_UQRSHL, Convert__Reg1_1__Tie0_2_2__Reg1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 1927 /* uqrshll */, ARM::MVE_UQRSHLL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__Reg1_4__MveSaturate1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MveSaturate, MCK_rGPR }, },
  { 1935 /* uqsax */, ARM::t2UQSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1935 /* uqsax */, ARM::UQSAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1941 /* uqshl */, ARM::MVE_UQSHL, Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_MVELongShift }, },
  { 1947 /* uqshll */, ARM::MVE_UQSHLL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 1954 /* uqsub16 */, ARM::t2UQSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1954 /* uqsub16 */, ARM::UQSUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1962 /* uqsub8 */, ARM::t2UQSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1962 /* uqsub8 */, ARM::UQSUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 1969 /* urshr */, ARM::MVE_URSHR, Convert__Reg1_1__Tie0_2_2__MVELongShift1_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_rGPR, MCK_MVELongShift }, },
  { 1975 /* urshrl */, ARM::MVE_URSHRL, Convert__Reg1_1__Reg1_2__Tie0_1_1__Tie1_1_1__MVELongShift1_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_tGPREven, MCK_tGPROdd, MCK_MVELongShift }, },
  { 1982 /* usad8 */, ARM::t2USAD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1982 /* usad8 */, ARM::USAD8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1988 /* usada8 */, ARM::t2USADA8, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 1988 /* usada8 */, ARM::USADA8, Convert__Reg1_1__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1995 /* usat */, ARM::t2USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_31, MCK_rGPR }, },
  { 1995 /* usat */, ARM::USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_31, MCK_GPRnopc }, },
  { 1995 /* usat */, ARM::t2USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_Imm0_31, MCK_rGPR, MCK_ShifterImm }, },
  { 1995 /* usat */, ARM::USAT, Convert__Reg1_1__Imm0_311_2__Reg1_3__ShifterImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_31, MCK_GPRnopc, MCK_ShifterImm }, },
  { 2000 /* usat16 */, ARM::t2USAT16, Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_Imm0_15, MCK_rGPR }, },
  { 2000 /* usat16 */, ARM::USAT16, Convert__Reg1_1__Imm0_151_2__Reg1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_Imm0_15, MCK_GPRnopc }, },
  { 2007 /* usax */, ARM::t2USAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2007 /* usax */, ARM::USAX, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2012 /* usub16 */, ARM::t2USUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2012 /* usub16 */, ARM::USUB16, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2019 /* usub8 */, ARM::t2USUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsThumb2_HasDSP, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2019 /* usub8 */, ARM::USUB8, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2025 /* uxtab */, ARM::t2UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2025 /* uxtab */, ARM::UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 2025 /* uxtab */, ARM::t2UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2025 /* uxtab */, ARM::UXTAB, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 2031 /* uxtab16 */, ARM::t2UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2031 /* uxtab16 */, ARM::UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 2031 /* uxtab16 */, ARM::t2UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2031 /* uxtab16 */, ARM::UXTAB16, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 2039 /* uxtah */, ARM::t2UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR }, },
  { 2039 /* uxtah */, ARM::UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc }, },
  { 2039 /* uxtah */, ARM::t2UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2039 /* uxtah */, ARM::UXTAH, Convert__Reg1_1__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPR, MCK_GPRnopc, MCK_RotImm }, },
  { 2045 /* uxtb */, ARM::tUXTB, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 2045 /* uxtb */, ARM::t2UXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 2045 /* uxtb */, ARM::UXTB, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2045 /* uxtb */, ARM::t2UXTB, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 2045 /* uxtb */, ARM::t2UXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2045 /* uxtb */, ARM::UXTB, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 2045 /* uxtb */, ARM::t2UXTB, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2050 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 2050 /* uxtb16 */, ARM::UXTB16, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2050 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2050 /* uxtb16 */, ARM::t2UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_HasDSP_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2050 /* uxtb16 */, ARM::UXTB16, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 2057 /* uxth */, ARM::tUXTH, Convert__Reg1_1__Reg1_2__CondCode2_0, AMFBS_IsThumb_HasV6, { MCK_CondCode, MCK_tGPR, MCK_tGPR }, },
  { 2057 /* uxth */, ARM::t2UXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR }, },
  { 2057 /* uxth */, ARM::UXTH, Convert__Reg1_1__Reg1_2__imm_95_0__CondCode2_0, AMFBS_IsARM, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc }, },
  { 2057 /* uxth */, ARM::t2UXTH, Convert__Reg1_2__Reg1_3__imm_95_0__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR }, },
  { 2057 /* uxth */, ARM::t2UXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2057 /* uxth */, ARM::UXTH, Convert__Reg1_1__Reg1_2__RotImm1_3__CondCode2_0, AMFBS_IsARM_HasV6, { MCK_CondCode, MCK_GPRnopc, MCK_GPRnopc, MCK_RotImm }, },
  { 2057 /* uxth */, ARM::t2UXTH, Convert__Reg1_2__Reg1_3__RotImm1_4__CondCode2_0, AMFBS_IsThumb2, { MCK_CondCode, MCK__DOT_w, MCK_rGPR, MCK_rGPR, MCK_RotImm }, },
  { 2062 /* vaba */, ARM::VABAsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAsv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2062 /* vaba */, ARM::VABAsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAsv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2062 /* vaba */, ARM::VABAsv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAsv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2062 /* vaba */, ARM::VABAuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAuv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2062 /* vaba */, ARM::VABAuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAuv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2062 /* vaba */, ARM::VABAuv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2062 /* vaba */, ARM::VABAuv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALsv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALsv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALsv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALuv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALuv2i64, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2067 /* vabal */, ARM::VABALuv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVs16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVs32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVs8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVu16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVu32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2073 /* vabav */, ARM::MVE_VABAVu8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_rGPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::VABDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::VABDhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2079 /* vabd */, ARM::VABDhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDf32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2079 /* vabd */, ARM::MVE_VABDf16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2084 /* vabdl */, ARM::VABDLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2084 /* vabdl */, ARM::VABDLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2084 /* vabdl */, ARM::VABDLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2084 /* vabdl */, ARM::VABDLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2084 /* vabdl */, ARM::VABDLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2084 /* vabdl */, ARM::VABDLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2090 /* vabs */, ARM::VABSv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2090 /* vabs */, ARM::VABSv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2090 /* vabs */, ARM::VABSv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSfq, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2090 /* vabs */, ARM::VABSfd, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSS, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2090 /* vabs */, ARM::VABSD, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABShq, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2090 /* vabs */, ARM::VABShd, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2090 /* vabs */, ARM::VABSH, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2090 /* vabs */, ARM::MVE_VABSs16, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR }, },
  { 2090 /* vabs */, ARM::MVE_VABSs32, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR }, },
  { 2090 /* vabs */, ARM::MVE_VABSs8, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR }, },
  { 2090 /* vabs */, ARM::MVE_VABSf32, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2090 /* vabs */, ARM::MVE_VABSf16, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2095 /* vacge */, ARM::VACGEfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2095 /* vacge */, ARM::VACGEfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2095 /* vacge */, ARM::VACGEhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2095 /* vacge */, ARM::VACGEhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2095 /* vacge */, ARM::VACGEfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2095 /* vacge */, ARM::VACGEfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2095 /* vacge */, ARM::VACGEhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2095 /* vacge */, ARM::VACGEhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2101 /* vacgt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2101 /* vacgt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2101 /* vacgt */, ARM::VACGThq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2101 /* vacgt */, ARM::VACGThd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2101 /* vacgt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2101 /* vacgt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2101 /* vacgt */, ARM::VACGThq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2101 /* vacgt */, ARM::VACGThd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2107 /* vacle */, ARM::VACGEfq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2107 /* vacle */, ARM::VACGEfd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2107 /* vacle */, ARM::VACGEhq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2107 /* vacle */, ARM::VACGEhd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2107 /* vacle */, ARM::VACGEfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2107 /* vacle */, ARM::VACGEfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2107 /* vacle */, ARM::VACGEhq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2107 /* vacle */, ARM::VACGEhd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2113 /* vaclt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2113 /* vaclt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2113 /* vaclt */, ARM::VACGThq, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2113 /* vaclt */, ARM::VACGThd, Convert__Reg1_2__Reg1_3__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2113 /* vaclt */, ARM::VACGTfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2113 /* vaclt */, ARM::VACGTfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2113 /* vaclt */, ARM::VACGThq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2113 /* vaclt */, ARM::VACGThd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2119 /* vadc */, ARM::MVE_VADC, Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__imm_95_0__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2124 /* vadci */, ARM::MVE_VADCI, Convert__Reg1_2__imm_95_0__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::VADDfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2130 /* vadd */, ARM::VADDD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv1i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2130 /* vadd */, ARM::VADDfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2130 /* vadd */, ARM::VADDD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv1i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2130 /* vadd */, ARM::VADDhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2130 /* vadd */, ARM::VADDH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2130 /* vadd */, ARM::MVE_VADDf32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::MVE_VADD_qr_f32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2130 /* vadd */, ARM::MVE_VADDi16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::MVE_VADD_qr_i16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2130 /* vadd */, ARM::MVE_VADDi32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::MVE_VADD_qr_i32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2130 /* vadd */, ARM::MVE_VADDi8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::MVE_VADD_qr_i8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2130 /* vadd */, ARM::MVE_VADDf16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2130 /* vadd */, ARM::MVE_VADD_qr_f16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2135 /* vaddhn */, ARM::VADDHNv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2135 /* vaddhn */, ARM::VADDHNv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2135 /* vaddhn */, ARM::VADDHNv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i64, MCK_DPR, MCK_QPR, MCK_QPR }, },
  { 2142 /* vaddl */, ARM::VADDLsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2142 /* vaddl */, ARM::VADDLsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2142 /* vaddl */, ARM::VADDLsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2142 /* vaddl */, ARM::VADDLuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2142 /* vaddl */, ARM::VADDLuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2142 /* vaddl */, ARM::VADDLuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2148 /* vaddlv */, ARM::MVE_VADDLVs32no_acc, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_tGPROdd, MCK_MQPR }, },
  { 2148 /* vaddlv */, ARM::MVE_VADDLVu32no_acc, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_tGPROdd, MCK_MQPR }, },
  { 2155 /* vaddlva */, ARM::MVE_VADDLVs32acc, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_tGPROdd, MCK_MQPR }, },
  { 2155 /* vaddlva */, ARM::MVE_VADDLVu32acc, Convert__Reg1_2__Reg1_3__Tie0_1_1__Tie1_1_1__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_tGPROdd, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVs16no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVs32no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVs8no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_tGPREven, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVu16no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_tGPREven, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVu32no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_MQPR }, },
  { 2163 /* vaddv */, ARM::MVE_VADDVu8no_acc, Convert__Reg1_2__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVs16acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVs32acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVs8acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVu16acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVu32acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_MQPR }, },
  { 2169 /* vaddva */, ARM::MVE_VADDVu8acc, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_tGPREven, MCK_MQPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv2i64, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv2i64, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2176 /* vaddw */, ARM::VADDWuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VBICiv8i16, Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splatNot }, },
  { 2182 /* vand */, ARM::VBICiv4i16, Convert__Reg1_2__NEONi16splatNot1_3__Tie0_3_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splatNot }, },
  { 2182 /* vand */, ARM::VBICiv4i32, Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32splatNot }, },
  { 2182 /* vand */, ARM::VBICiv2i32, Convert__Reg1_2__NEONi32splatNot1_3__Tie0_3_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32splatNot }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::MVE_VBICimmi16, Convert__Reg1_2__Tie0_3_3__NEONi16splatNot1_3__VPTPredN3_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredN, MCK__DOT_i16, MCK_MQPR, MCK_NEONi16splatNot }, },
  { 2182 /* vand */, ARM::MVE_VBICimmi32, Convert__Reg1_2__Tie0_3_3__NEONi32splatNot1_3__VPTPredN3_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredN, MCK__DOT_i32, MCK_MQPR, MCK_NEONi32splatNot }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::VANDq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2182 /* vand */, ARM::VANDd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2182 /* vand */, ARM::MVE_VAND, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::VBICiv8i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_NEONi16splat }, },
  { 2187 /* vbic */, ARM::VBICiv4i16, Convert__Reg1_2__NEONi16splat1_3__Tie0_1_1__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_NEONi16splat }, },
  { 2187 /* vbic */, ARM::VBICiv4i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_NEONi32splat }, },
  { 2187 /* vbic */, ARM::VBICiv2i32, Convert__Reg1_2__NEONi32splat1_3__Tie0_1_1__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_NEONi32splat }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::MVE_VBICimmi16, Convert__Reg1_2__Tie0_1_1__NEONi16splat1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i16, MCK_MQPR, MCK_NEONi16splat }, },
  { 2187 /* vbic */, ARM::MVE_VBICimmi32, Convert__Reg1_2__Tie0_1_1__NEONi32splat1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i32, MCK_MQPR, MCK_NEONi32splat }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::VBICq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2187 /* vbic */, ARM::VBICd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2187 /* vbic */, ARM::MVE_VBIC, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2192 /* vbif */, ARM::VBIFq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2192 /* vbif */, ARM::VBIFd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2192 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2192 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2192 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2192 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2192 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2192 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2192 /* vbif */, ARM::VBIFq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2192 /* vbif */, ARM::VBIFd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2197 /* vbit */, ARM::VBITq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2197 /* vbit */, ARM::VBITd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2197 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2197 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2197 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2197 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2197 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2197 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2197 /* vbit */, ARM::VBITq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2197 /* vbit */, ARM::VBITd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2202 /* vbrsr */, ARM::MVE_VBRSR16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2202 /* vbrsr */, ARM::MVE_VBRSR32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2202 /* vbrsr */, ARM::MVE_VBRSR8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2208 /* vbsl */, ARM::VBSLq, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2208 /* vbsl */, ARM::VBSLd, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2208 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2208 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2208 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2208 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2208 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2208 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2208 /* vbsl */, ARM::VBSLq, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2208 /* vbsl */, ARM::VBSLd, Convert__Reg1_2__Tie0_3_3__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2213 /* vcadd */, ARM::VCADDv4f32, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::VCADDv2f32, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::VCADDv8f16, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::VCADDv4f16, Convert__Reg1_1__Reg1_2__Reg1_3__ComplexRotationOdd1_4, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::MVE_VCADDf32, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::MVE_VCADDi16, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::MVE_VCADDi32, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::MVE_VCADDi8, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2213 /* vcadd */, ARM::MVE_VCADDf16, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2219 /* vceq */, ARM::VCEQzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2219 /* vceq */, ARM::VCEQzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2219 /* vceq */, ARM::VCEQzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2219 /* vceq */, ARM::VCEQhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2224 /* vcge */, ARM::VCGEzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2224 /* vcge */, ARM::VCGEzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2224 /* vcge */, ARM::VCGEhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGThq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGThd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGThq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2229 /* vcgt */, ARM::VCGTzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2229 /* vcgt */, ARM::VCGThd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCLEzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCLEzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCLEzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCLEzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCLEzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCLEzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCLEzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEsv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCGEuv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCGEuv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCGEuv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCGEuv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCGEuv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCGEuv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCLEzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCLEzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2234 /* vcle */, ARM::VCLEzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEhq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2234 /* vcle */, ARM::VCLEzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2234 /* vcle */, ARM::VCGEhd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2239 /* vcls */, ARM::VCLSv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2239 /* vcls */, ARM::VCLSv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2239 /* vcls */, ARM::VCLSv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2239 /* vcls */, ARM::VCLSv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2239 /* vcls */, ARM::VCLSv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2239 /* vcls */, ARM::VCLSv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2239 /* vcls */, ARM::MVE_VCLSs16, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR }, },
  { 2239 /* vcls */, ARM::MVE_VCLSs32, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR }, },
  { 2239 /* vcls */, ARM::MVE_VCLSs8, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR }, },
  { 2244 /* vclt */, ARM::VCLTzv8i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv4i16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv4i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv2i32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv16i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv8i8, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv4f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv2f32, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv8f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv4f16, Convert__Reg1_2__Reg1_2__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCLTzv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCLTzv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCLTzv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCLTzv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCLTzv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCLTzv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTsv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCGTuv8i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCGTuv4i16, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCGTuv4i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCGTuv2i32, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCGTuv16i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCGTuv8i8, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCLTzv4f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTfq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCLTzv2f32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGTfd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2244 /* vclt */, ARM::VCLTzv8f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGThq, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2244 /* vclt */, ARM::VCLTzv4f16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2244 /* vclt */, ARM::VCGThd, Convert__Reg1_2__Reg1_4__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2249 /* vclz */, ARM::VCLZv8i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR }, },
  { 2249 /* vclz */, ARM::VCLZv4i16, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR }, },
  { 2249 /* vclz */, ARM::VCLZv4i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR }, },
  { 2249 /* vclz */, ARM::VCLZv2i32, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR }, },
  { 2249 /* vclz */, ARM::VCLZv16i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR }, },
  { 2249 /* vclz */, ARM::VCLZv8i8, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR }, },
  { 2249 /* vclz */, ARM::MVE_VCLZs16, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR }, },
  { 2249 /* vclz */, ARM::MVE_VCLZs32, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR }, },
  { 2249 /* vclz */, ARM::MVE_VCLZs8, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR }, },
  { 2254 /* vcmla */, ARM::VCMLAv4f32, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv2f32, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv8f16, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv4f16, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__ComplexRotationEven1_4, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv4f32_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR, MCK_VectorIndex64, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv2f32_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex641_4__ComplexRotationEven1_5, AMFBS_HasNEON_HasV8_3a, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_VectorIndex64, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv8f16_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::VCMLAv4f16_indexed, Convert__Reg1_1__Tie0_1_1__Reg1_2__Reg1_3__VectorIndex321_4__ComplexRotationEven1_5, AMFBS_HasNEON_HasV8_3a_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::MVE_VCMLAf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationEven }, },
  { 2254 /* vcmla */, ARM::MVE_VCMLAf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationEven }, },
  { 2260 /* vcmp */, ARM::VCMPZS, Convert__Reg1_2__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK__HASH_0 }, },
  { 2260 /* vcmp */, ARM::VCMPS, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2260 /* vcmp */, ARM::VCMPZD, Convert__Reg1_2__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK__HASH_0 }, },
  { 2260 /* vcmp */, ARM::VCMPD, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2260 /* vcmp */, ARM::VCMPZH, Convert__Reg1_2__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK__HASH_0 }, },
  { 2260 /* vcmp */, ARM::VCMPH, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs16, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs16r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs32, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs32r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs8, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPs8r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedS1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_CondCodeRestrictedS, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu16, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu16r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu32, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu32r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu8, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPu8r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedU1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_CondCodeRestrictedU, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPf32, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_CondCodeRestrictedFP, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPf32r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_CondCodeRestrictedFP, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi16, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i16, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi16r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i16, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi32, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i32, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi32r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i32, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi8, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i8, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPi8r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedI1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i8, MCK_CondCodeRestrictedI, MCK_MQPR, MCK_GPRwithZR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPf16, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_CondCodeRestrictedFP, MCK_MQPR, MCK_MQPR }, },
  { 2260 /* vcmp */, ARM::MVE_VCMPf16r, Convert__imm_95_0__Reg1_3__Reg1_4__CondCodeRestrictedFP1_2__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_CondCodeRestrictedFP, MCK_MQPR, MCK_GPRwithZR }, },
  { 2265 /* vcmpe */, ARM::VCMPEZS, Convert__Reg1_2__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK__HASH_0 }, },
  { 2265 /* vcmpe */, ARM::VCMPES, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2265 /* vcmpe */, ARM::VCMPEZD, Convert__Reg1_2__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK__HASH_0 }, },
  { 2265 /* vcmpe */, ARM::VCMPED, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2265 /* vcmpe */, ARM::VCMPEZH, Convert__Reg1_2__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK__HASH_0 }, },
  { 2265 /* vcmpe */, ARM::VCMPEH, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2271 /* vcmul */, ARM::MVE_VCMULf32, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationEven }, },
  { 2271 /* vcmul */, ARM::MVE_VCMULf16, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationEven1_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationEven }, },
  { 2277 /* vcnt */, ARM::VCNTq, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2277 /* vcnt */, ARM::VCNTd, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2282 /* vctp */, ARM::MVE_VCTP16, Convert__imm_95_0__Reg1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_16, MCK_rGPR }, },
  { 2282 /* vctp */, ARM::MVE_VCTP32, Convert__imm_95_0__Reg1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_32, MCK_rGPR }, },
  { 2282 /* vctp */, ARM::MVE_VCTP64, Convert__imm_95_0__Reg1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_64, MCK_rGPR }, },
  { 2282 /* vctp */, ARM::MVE_VCTP8, Convert__imm_95_0__Reg1_2__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_8, MCK_rGPR }, },
  { 2287 /* vcvt */, ARM::VCVTh2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTh2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VCVTf2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTf2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VTOSIZS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VTOSIZD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VTOSIZH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTh2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTh2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VCVTf2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTf2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VTOUIZS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VTOUIZD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VTOUIZH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTs2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTs2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VSITOS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTu2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTu2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VUITOS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTSD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VCVTh2f, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_QPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VSITOD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s32, MCK_DPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VUITOD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u32, MCK_DPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTDS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f32, MCK_DPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::BF16_VCVT, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasBF16_HasNEON, { MCK_CondCode, MCK__DOT_bf16, MCK__DOT_f32, MCK_DPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTs2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTs2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VSITOH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTu2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::VCVTu2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2287 /* vcvt */, ARM::VUITOH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u32, MCK_HPR, MCK_HPR }, },
  { 2287 /* vcvt */, ARM::VCVTf2h, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_DPR, MCK_QPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTs16f16z, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTs32f32z, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTu16f16z, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTu32f32z, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf32s32n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_s32, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf32u32n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_u32, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf16s16n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK__DOT_s16, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf16u16n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK__DOT_u16, MCK_MQPR, MCK_MQPR }, },
  { 2287 /* vcvt */, ARM::VTOSHS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VTOSHD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTh2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTh2xsq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTh2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTh2xsd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VTOSHH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_s16, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTf2sq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTf2xsq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTf2sd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTf2xsd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VTOSLS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VTOSLD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VTOSLH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VTOUHS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VTOUHD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTh2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTh2xuq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTh2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTh2xud, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VTOUHH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_u16, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTf2uq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTf2xuq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTf2ud, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTf2xud, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VTOULS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VTOULD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VTOULH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VSHTOS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTs2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxs2fq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTs2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxs2fd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VSLTOS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_s32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VUHTOS, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VCVTu2fq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxu2fq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTu2fd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxu2fd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VULTOS, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_u32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VSHTOD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VSLTOD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VUHTOD, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VULTOD, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VCVTs2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxs2hq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTs2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxs2hd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VSHTOH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VSLTOH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_s32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::VCVTu2hq, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxu2hq, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VCVTu2hd, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK__HASH_0 }, },
  { 2287 /* vcvt */, ARM::VCVTxu2hd, Convert__Reg1_3__Reg1_4__Imm1_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_Imm }, },
  { 2287 /* vcvt */, ARM::VUHTOH, Convert__Reg1_3__Tie0_4_5__FBits161_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u16, MCK_HPR, MCK_HPR, MCK_FBits16 }, },
  { 2287 /* vcvt */, ARM::VULTOH, Convert__Reg1_3__Tie0_4_5__FBits321_5__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_u32, MCK_HPR, MCK_HPR, MCK_FBits32 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTs16f16_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm16 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTs32f32_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm32 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTu16f16_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm16 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTu32f32_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm32 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf32s32_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm32 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf32u32_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm321_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm32 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf16s16_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm16 }, },
  { 2287 /* vcvt */, ARM::MVE_VCVTf16u16_fix, Convert__Reg1_3__Reg1_4__MVEVcvtImm161_5__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MVEVcvtImm16 }, },
  { 2292 /* vcvta */, ARM::VCVTANSQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2292 /* vcvta */, ARM::VCVTANSDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTANSQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2292 /* vcvta */, ARM::VCVTANSDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTASS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2292 /* vcvta */, ARM::VCVTASD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTASH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2292 /* vcvta */, ARM::VCVTANUQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2292 /* vcvta */, ARM::VCVTANUDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTANUQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2292 /* vcvta */, ARM::VCVTANUDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTAUS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2292 /* vcvta */, ARM::VCVTAUD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2292 /* vcvta */, ARM::VCVTAUH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2292 /* vcvta */, ARM::MVE_VCVTs16f16a, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2292 /* vcvta */, ARM::MVE_VCVTs32f32a, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2292 /* vcvta */, ARM::MVE_VCVTu16f16a, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2292 /* vcvta */, ARM::MVE_VCVTu32f32a, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2298 /* vcvtb */, ARM::VCVTBHS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2298 /* vcvtb */, ARM::VCVTBHD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFPARMv8_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f16, MCK_DPR, MCK_HPR }, },
  { 2298 /* vcvtb */, ARM::BF16_VCVTB, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasBF16, { MCK_CondCode, MCK__DOT_bf16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2298 /* vcvtb */, ARM::VCVTBSH, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2298 /* vcvtb */, ARM::VCVTBDH, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasFPARMv8_HasDPVFP, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2298 /* vcvtb */, ARM::MVE_VCVTf16f32bh, Convert__Reg1_3__Tie0_1_1__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2298 /* vcvtb */, ARM::MVE_VCVTf32f16bh, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNSQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNSDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNSQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNSDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMSS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMSD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMSH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNUQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNUDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNUQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMNUDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMUS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMUD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2304 /* vcvtm */, ARM::VCVTMUH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2304 /* vcvtm */, ARM::MVE_VCVTs16f16m, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2304 /* vcvtm */, ARM::MVE_VCVTs32f32m, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2304 /* vcvtm */, ARM::MVE_VCVTu16f16m, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2304 /* vcvtm */, ARM::MVE_VCVTu32f32m, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNSQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNSDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNSQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNSDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNSS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNSD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNSH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNUQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNUDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNUQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNNUDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNUS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNUD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2310 /* vcvtn */, ARM::VCVTNUH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2310 /* vcvtn */, ARM::MVE_VCVTs16f16n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2310 /* vcvtn */, ARM::MVE_VCVTs32f32n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2310 /* vcvtn */, ARM::MVE_VCVTu16f16n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2310 /* vcvtn */, ARM::MVE_VCVTu32f32n, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNSQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNSDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_s16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNSQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNSDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_s32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPSS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPSD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPSH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNUQh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNUDh, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON_HasFullFP16, { MCK__DOT_u16, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNUQf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPNUDf, Convert__Reg1_2__Reg1_3, AMFBS_HasV8_HasNEON, { MCK__DOT_u32, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPUS, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPUD, Convert__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2316 /* vcvtp */, ARM::VCVTPUH, Convert__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2316 /* vcvtp */, ARM::MVE_VCVTs16f16p, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2316 /* vcvtp */, ARM::MVE_VCVTs32f32p, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_s32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2316 /* vcvtp */, ARM::MVE_VCVTu16f16p, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u16, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2316 /* vcvtp */, ARM::MVE_VCVTu32f32p, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_u32, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2322 /* vcvtr */, ARM::VTOSIRS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2322 /* vcvtr */, ARM::VTOSIRD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2322 /* vcvtr */, ARM::VTOSIRH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2322 /* vcvtr */, ARM::VTOUIRS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2322 /* vcvtr */, ARM::VTOUIRD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2322 /* vcvtr */, ARM::VTOUIRH, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_u32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2328 /* vcvtt */, ARM::VCVTTHS, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFP16, { MCK_CondCode, MCK__DOT_f32, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2328 /* vcvtt */, ARM::VCVTTHD, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFPARMv8_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK__DOT_f16, MCK_DPR, MCK_HPR }, },
  { 2328 /* vcvtt */, ARM::BF16_VCVTT, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasBF16, { MCK_CondCode, MCK__DOT_bf16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2328 /* vcvtt */, ARM::VCVTTSH, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasFP16, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2328 /* vcvtt */, ARM::VCVTTDH, Convert__Reg1_3__Tie0_1_1__Reg1_4__CondCode2_0, AMFBS_HasFPARMv8_HasDPVFP, { MCK_CondCode, MCK__DOT_f16, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2328 /* vcvtt */, ARM::MVE_VCVTf16f32th, Convert__Reg1_3__Tie0_1_1__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2328 /* vcvtt */, ARM::MVE_VCVTf32f16th, Convert__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2334 /* vcx1 */, ARM::CDE_VCX1_fpdp, Convert__Reg1_1__CoprocNum1_0__Imm11b1_2, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_Imm11b }, },
  { 2334 /* vcx1 */, ARM::CDE_VCX1_fpsp, Convert__Reg1_1__CoprocNum1_0__Imm11b1_2, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_Imm11b }, },
  { 2334 /* vcx1 */, ARM::CDE_VCX1_vec, Convert__Reg1_2__CoprocNum1_1__Imm12b1_3__VPTPredR4_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredR, MCK_CoprocNum, MCK_MQPR, MCK_Imm12b }, },
  { 2339 /* vcx1a */, ARM::CDE_VCX1A_fpdp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Imm11b1_2, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_Imm11b }, },
  { 2339 /* vcx1a */, ARM::CDE_VCX1A_fpsp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Imm11b1_2, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_Imm11b }, },
  { 2339 /* vcx1a */, ARM::CDE_VCX1A_vec, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Imm12b1_3__VPTPredN3_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredN, MCK_CoprocNum, MCK_MQPR, MCK_Imm12b }, },
  { 2345 /* vcx2 */, ARM::CDE_VCX2_fpdp, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm6b1_3, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_Imm6b }, },
  { 2345 /* vcx2 */, ARM::CDE_VCX2_fpsp, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Imm6b1_3, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_HPR, MCK_Imm6b }, },
  { 2345 /* vcx2 */, ARM::CDE_VCX2_vec, Convert__Reg1_2__CoprocNum1_1__Reg1_3__Imm7b1_4__VPTPredR4_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredR, MCK_CoprocNum, MCK_MQPR, MCK_MQPR, MCK_Imm7b }, },
  { 2350 /* vcx2a */, ARM::CDE_VCX2A_fpdp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Imm6b1_3, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_Imm6b }, },
  { 2350 /* vcx2a */, ARM::CDE_VCX2A_fpsp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Imm6b1_3, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_HPR, MCK_Imm6b }, },
  { 2350 /* vcx2a */, ARM::CDE_VCX2A_vec, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Imm7b1_4__VPTPredN3_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredN, MCK_CoprocNum, MCK_MQPR, MCK_MQPR, MCK_Imm7b }, },
  { 2356 /* vcx3 */, ARM::CDE_VCX3_fpdp, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm3b1_4, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_Imm3b }, },
  { 2356 /* vcx3 */, ARM::CDE_VCX3_fpsp, Convert__Reg1_1__CoprocNum1_0__Reg1_2__Reg1_3__Imm3b1_4, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_HPR, MCK_HPR, MCK_Imm3b }, },
  { 2356 /* vcx3 */, ARM::CDE_VCX3_vec, Convert__Reg1_2__CoprocNum1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredR4_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredR, MCK_CoprocNum, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_Imm4b }, },
  { 2361 /* vcx3a */, ARM::CDE_VCX3A_fpdp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Reg1_3__Imm3b1_4, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_DPR_VFP2, MCK_Imm3b }, },
  { 2361 /* vcx3a */, ARM::CDE_VCX3A_fpsp, Convert__Reg1_1__CoprocNum1_0__Tie0_1_1__Reg1_2__Reg1_3__Imm3b1_4, AMFBS_HasCDE_HasFPRegs, { MCK_CoprocNum, MCK_HPR, MCK_HPR, MCK_HPR, MCK_Imm3b }, },
  { 2361 /* vcx3a */, ARM::CDE_VCX3A_vec, Convert__Reg1_2__CoprocNum1_1__Tie0_1_1__Reg1_3__Reg1_4__Imm4b1_5__VPTPredN3_0, AMFBS_HasCDE_HasMVEInt, { MCK_VPTPredN, MCK_CoprocNum, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_Imm4b }, },
  { 2367 /* vddup */, ARM::MVE_VDDUPu16, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2367 /* vddup */, ARM::MVE_VDDUPu32, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2367 /* vddup */, ARM::MVE_VDDUPu8, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2373 /* vdiv */, ARM::VDIVS, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR }, },
  { 2373 /* vdiv */, ARM::VDIVD, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR }, },
  { 2373 /* vdiv */, ARM::VDIVH, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2373 /* vdiv */, ARM::VDIVS, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2373 /* vdiv */, ARM::VDIVD, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2373 /* vdiv */, ARM::VDIVH, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2378 /* vdot */, ARM::BF16VDOTS_VDOTQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2378 /* vdot */, ARM::BF16VDOTS_VDOTD, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2378 /* vdot */, ARM::BF16VDOTI_VDOTQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2378 /* vdot */, ARM::BF16VDOTI_VDOTD, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex321_4, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2383 /* vdup */, ARM::VDUP16q, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::VDUP16d, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::VDUP32q, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::VDUP32d, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::VDUP8q, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::VDUP8d, Convert__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_GPR }, },
  { 2383 /* vdup */, ARM::MVE_VDUP16, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_16, MCK_MQPR, MCK_rGPR }, },
  { 2383 /* vdup */, ARM::MVE_VDUP32, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_32, MCK_MQPR, MCK_rGPR }, },
  { 2383 /* vdup */, ARM::MVE_VDUP8, Convert__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_8, MCK_MQPR, MCK_rGPR }, },
  { 2383 /* vdup */, ARM::VDUPLN16q, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 2383 /* vdup */, ARM::VDUPLN16d, Convert__Reg1_2__Reg1_3__VectorIndex161_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_VectorIndex16 }, },
  { 2383 /* vdup */, ARM::VDUPLN32q, Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_DPR, MCK_VectorIndex32 }, },
  { 2383 /* vdup */, ARM::VDUPLN32d, Convert__Reg1_2__Reg1_3__VectorIndex321_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_VectorIndex32 }, },
  { 2383 /* vdup */, ARM::VDUPLN8q, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 2383 /* vdup */, ARM::VDUPLN8d, Convert__Reg1_2__Reg1_3__VectorIndex81_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_VectorIndex8 }, },
  { 2388 /* vdwdup */, ARM::MVE_VDWDUPu16, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2388 /* vdwdup */, ARM::MVE_VDWDUPu32, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2388 /* vdwdup */, ARM::MVE_VDWDUPu8, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_1__Reg1_1__Reg1_2__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_1__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_1__Reg1_2__Reg1_3__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::VEORq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2395 /* veor */, ARM::VEORd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2395 /* veor */, ARM::MVE_VEOR, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt_IsThumb, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2400 /* vext */, ARM::VEXTq16, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_Imm0_7 }, },
  { 2400 /* vext */, ARM::VEXTd16, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_Imm0_3 }, },
  { 2400 /* vext */, ARM::VEXTq32, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_31_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_Imm0_3 }, },
  { 2400 /* vext */, ARM::VEXTd32, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_Imm0_1 }, },
  { 2400 /* vext */, ARM::VEXTq64, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_11_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_Imm0_1 }, },
  { 2400 /* vext */, ARM::VEXTq8, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_151_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 2400 /* vext */, ARM::VEXTd8, Convert__Reg1_2__Reg1_2__Reg1_3__Imm0_71_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_Imm0_7 }, },
  { 2400 /* vext */, ARM::VEXTq16, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_7 }, },
  { 2400 /* vext */, ARM::VEXTd16, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_3 }, },
  { 2400 /* vext */, ARM::VEXTq32, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_31_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_3 }, },
  { 2400 /* vext */, ARM::VEXTd32, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_1 }, },
  { 2400 /* vext */, ARM::VEXTq64, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_11_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_1 }, },
  { 2400 /* vext */, ARM::VEXTq8, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_151_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_QPR, MCK_QPR, MCK_QPR, MCK_Imm0_15 }, },
  { 2400 /* vext */, ARM::VEXTd8, Convert__Reg1_2__Reg1_3__Reg1_4__Imm0_71_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_DPR, MCK_DPR, MCK_DPR, MCK_Imm0_7 }, },
  { 2405 /* vfma */, ARM::VFMAfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2405 /* vfma */, ARM::VFMAfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2405 /* vfma */, ARM::VFMAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2405 /* vfma */, ARM::VFMAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2405 /* vfma */, ARM::VFMAhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2405 /* vfma */, ARM::VFMAhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2405 /* vfma */, ARM::VFMAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2405 /* vfma */, ARM::MVE_VFMAf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2405 /* vfma */, ARM::MVE_VFMA_qr_f32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2405 /* vfma */, ARM::MVE_VFMAf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2405 /* vfma */, ARM::MVE_VFMA_qr_f16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2410 /* vfmab */, ARM::VBF16MALBQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2410 /* vfmab */, ARM::VBF16MALBQI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex161_4, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2416 /* vfmal */, ARM::VFMALQ, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2416 /* vfmal */, ARM::VFMALD, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_DPR, MCK_HPR, MCK_HPR }, },
  { 2416 /* vfmal */, ARM::VFMALQI, Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex161_4, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2416 /* vfmal */, ARM::VFMALDI, Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex321_4, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_DPR, MCK_HPR, MCK_SPR_8, MCK_VectorIndex32 }, },
  { 2422 /* vfmas */, ARM::MVE_VFMA_qr_Sf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2422 /* vfmas */, ARM::MVE_VFMA_qr_Sf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2428 /* vfmat */, ARM::VBF16MALTQ, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2428 /* vfmat */, ARM::VBF16MALTQI, Convert__Reg1_1__Tie0_2_2__Reg1_2__Reg1_3__VectorIndex161_4, AMFBS_HasBF16_HasNEON, { MCK__DOT_bf16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2434 /* vfms */, ARM::VFMSfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2434 /* vfms */, ARM::VFMSfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2434 /* vfms */, ARM::VFMSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2434 /* vfms */, ARM::VFMSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2434 /* vfms */, ARM::VFMShq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2434 /* vfms */, ARM::VFMShd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2434 /* vfms */, ARM::VFMSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2434 /* vfms */, ARM::MVE_VFMSf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2434 /* vfms */, ARM::MVE_VFMSf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2439 /* vfmsl */, ARM::VFMSLQ, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_QPR, MCK_DPR, MCK_DPR }, },
  { 2439 /* vfmsl */, ARM::VFMSLD, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_DPR, MCK_HPR, MCK_HPR }, },
  { 2439 /* vfmsl */, ARM::VFMSLQI, Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex161_4, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_QPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2439 /* vfmsl */, ARM::VFMSLDI, Convert__Reg1_1__Reg1_2__Reg1_3__VectorIndex321_4, AMFBS_HasNEON_HasFP16FML, { MCK__DOT_f16, MCK_DPR, MCK_HPR, MCK_SPR_8, MCK_VectorIndex32 }, },
  { 2445 /* vfnma */, ARM::VFNMAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2445 /* vfnma */, ARM::VFNMAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2445 /* vfnma */, ARM::VFNMAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2451 /* vfnms */, ARM::VFNMSS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2451 /* vfnms */, ARM::VFNMSD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP4_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2451 /* vfnms */, ARM::VFNMSH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2457 /* vhadd */, ARM::VHADDuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_s16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_s32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_s8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_u16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_u32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADDu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2457 /* vhadd */, ARM::MVE_VHADD_qr_u8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2463 /* vhcadd */, ARM::MVE_VHCADDs16, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2463 /* vhcadd */, ARM::MVE_VHCADDs32, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2463 /* vhcadd */, ARM::MVE_VHCADDs8, Convert__Reg1_2__Reg1_3__Reg1_4__ComplexRotationOdd1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR, MCK_ComplexRotationOdd }, },
  { 2470 /* vhsub */, ARM::VHSUBsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2470 /* vhsub */, ARM::VHSUBuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_s16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_s32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_s8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_u16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_u32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUBu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2470 /* vhsub */, ARM::MVE_VHSUB_qr_u8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2476 /* vidup */, ARM::MVE_VIDUPu16, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2476 /* vidup */, ARM::MVE_VIDUPu32, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2476 /* vidup */, ARM::MVE_VIDUPu8, Convert__Reg1_2__Reg1_3__Tie1_1_1__VIDUP_imm1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_tGPREven, MCK_VIDUP_imm }, },
  { 2482 /* vins */, ARM::VINSH, Convert__Reg1_1__Tie0_1_1__Reg1_2, AMFBS_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR }, },
  { 2487 /* viwdup */, ARM::MVE_VIWDUPu16, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2487 /* viwdup */, ARM::MVE_VIWDUPu32, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2487 /* viwdup */, ARM::MVE_VIWDUPu8, Convert__Reg1_2__Reg1_3__Tie1_1_1__Reg1_4__VIDUP_imm1_5__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_tGPREven, MCK_tGPROdd, MCK_VIDUP_imm }, },
  { 2494 /* vjcvt */, ARM::VJCVT, Convert__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFPARMv8_HasV8_3a, { MCK_CondCode, MCK__DOT_s32, MCK__DOT_f64, MCK_HPR, MCK_DPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq16, Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16 }, },
  { 2500 /* vld1 */, ARM::VLD1q16, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2500 /* vld1 */, ARM::VLD1d16Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd16, Convert__VecListOneDAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16 }, },
  { 2500 /* vld1 */, ARM::VLD1d16, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1LNdAsm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16 }, },
  { 2500 /* vld1 */, ARM::VLD1d16T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq32, Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32 }, },
  { 2500 /* vld1 */, ARM::VLD1q32, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2500 /* vld1 */, ARM::VLD1d32Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd32, Convert__VecListOneDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32 }, },
  { 2500 /* vld1 */, ARM::VLD1d32, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1LNdAsm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32 }, },
  { 2500 /* vld1 */, ARM::VLD1d32T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1q64, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2500 /* vld1 */, ARM::VLD1d64Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2500 /* vld1 */, ARM::VLD1d64, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1d64T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq8, Convert__VecListDPairAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2500 /* vld1 */, ARM::VLD1q8, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2500 /* vld1 */, ARM::VLD1d8Q, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd8, Convert__VecListOneDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2500 /* vld1 */, ARM::VLD1d8, Convert__VecListOneD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1LNdAsm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2500 /* vld1 */, ARM::VLD1d8T, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq16wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq16wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1q16wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1q16wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d16Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d16Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd16wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd16wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d16wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d16wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_register_Asm_16, Convert__VecListOneDHWordIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListOneDHWordIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d16Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d16Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq32wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq32wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1q32wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1q32wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d32Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d32Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd32wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd32wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d32wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d32wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_register_Asm_32, Convert__VecListOneDWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListOneDWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d32Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d32Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1q64wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1q64wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d64Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d64Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d64wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d64wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d64Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d64Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_64, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq8wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPq8wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1q8wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1q8wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d8Qwb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d8Qwb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd8wb_fixed, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1DUPd8wb_register, Convert__VecListOneDAllLanes1_2__imm_95_0__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d8wb_fixed, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d8wb_register, Convert__VecListOneD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_fixed_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1LNdWB_register_Asm_8, Convert__VecListOneDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListOneDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1d8Twb_fixed, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2500 /* vld1 */, ARM::VLD1d8Twb_register, Convert__VecListThreeD1_2__imm_95_0__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2500 /* vld1 */, ARM::VLD1LNd16, Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2500 /* vld1 */, ARM::VLD1LNd8, Convert__Reg1_3__AlignedMemory2_8__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2500 /* vld1 */, ARM::VLD1LNd16_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2500 /* vld1 */, ARM::VLD1LNd32, Convert__Reg1_3__Reg1_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_GPR, MCK_Imm }, },
  { 2500 /* vld1 */, ARM::VLD1LNd32_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2500 /* vld1 */, ARM::VLD1LNd8_UPD, Convert__Reg1_3__imm_95_0__AlignedMemory2_8__Imm1_9__Tie0_1_1__Imm1_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK_Imm, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16, Convert__VecListDPairAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32 }, },
  { 2505 /* vld2 */, ARM::VLD2d16, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32 }, },
  { 2505 /* vld2 */, ARM::VLD2b16, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2q16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2505 /* vld2 */, ARM::VLD2LNdAsm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32 }, },
  { 2505 /* vld2 */, ARM::VLD2LNqAsm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32, Convert__VecListDPairAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64 }, },
  { 2505 /* vld2 */, ARM::VLD2d32, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64 }, },
  { 2505 /* vld2 */, ARM::VLD2b32, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2q32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2505 /* vld2 */, ARM::VLD2LNdAsm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64 }, },
  { 2505 /* vld2 */, ARM::VLD2LNqAsm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8, Convert__VecListDPairAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16 }, },
  { 2505 /* vld2 */, ARM::VLD2d8, Convert__VecListDPair1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8x2, Convert__VecListDPairSpacedAllLanes1_2__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16 }, },
  { 2505 /* vld2 */, ARM::VLD2b8, Convert__VecListDPairSpaced1_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128 }, },
  { 2505 /* vld2 */, ARM::VLD2q8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2505 /* vld2 */, ARM::VLD2LNdAsm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16 }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2d16wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2d16wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd16x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2b16wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2b16wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2q16wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2q16wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_register_Asm_16, Convert__VecListTwoDHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoDHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2LNqWB_fixed_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2LNqWB_register_Asm_16, Convert__VecListTwoQHWordIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListTwoQHWordIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2d32wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2d32wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd32x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2b32wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2b32wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2q32wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2q32wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_register_Asm_32, Convert__VecListTwoDWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoDWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2LNqWB_fixed_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2LNqWB_register_Asm_32, Convert__VecListTwoQWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListTwoQWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8wb_fixed, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8wb_register, Convert__VecListDPairAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2d8wb_fixed, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2d8wb_register, Convert__VecListDPair1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPair, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8x2wb_fixed, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2DUPd8x2wb_register, Convert__VecListDPairSpacedAllLanes1_2__imm_95_0__DupAlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpacedAllLanes, MCK_DupAlignedMemory16, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2b8wb_fixed, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2b8wb_register, Convert__VecListDPairSpaced1_2__imm_95_0__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListDPairSpaced, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2q8wb_fixed, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2q8wb_register, Convert__VecListFourD1_2__imm_95_0__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_fixed_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK__EXCLAIM_ }, },
  { 2505 /* vld2 */, ARM::VLD2LNdWB_register_Asm_8, Convert__VecListTwoDByteIndexed2_2__AlignedMemory162_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListTwoDByteIndexed, MCK_AlignedMemory16, MCK_rGPR }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_16, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_32, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_8, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_16_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_32_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2510 /* vld20 */, ARM::MVE_VLD20_8_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_16, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_32, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_8, Convert__VecListTwoMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListTwoMQ, MCK_MemNoOffsetT2 }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_16_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_32_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2516 /* vld21 */, ARM::MVE_VLD21_8_wb, Convert__VecListTwoMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListTwoMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdAsm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3dAsm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3LNdAsm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqAsm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3qAsm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3LNqAsm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdAsm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3dAsm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3LNdAsm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqAsm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3qAsm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3LNqAsm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdAsm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3dAsm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3LNdAsm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqAsm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone }, },
  { 2522 /* vld3 */, ARM::VLD3qAsm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64 }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_16, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_fixed_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_register_Asm_16, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_register_Asm_16, Convert__VecListThreeDHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeDHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_16, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_fixed_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_register_Asm_16, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3LNqWB_fixed_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3LNqWB_register_Asm_16, Convert__VecListThreeQHWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListThreeQHWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_32, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_fixed_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_register_Asm_32, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_register_Asm_32, Convert__VecListThreeDWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeDWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_32, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_fixed_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_register_Asm_32, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3LNqWB_fixed_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3LNqWB_register_Asm_32, Convert__VecListThreeQWordIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListThreeQWordIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_fixed_Asm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPdWB_register_Asm_8, Convert__VecListThreeDAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_fixed_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3dWB_register_Asm_8, Convert__VecListThreeD1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeD, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_fixed_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3LNdWB_register_Asm_8, Convert__VecListThreeDByteIndexed2_2__AlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeDByteIndexed, MCK_AlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_fixed_Asm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3DUPqWB_register_Asm_8, Convert__VecListThreeQAllLanes1_2__DupAlignedMemoryNone2_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQAllLanes, MCK_DupAlignedMemoryNone, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_fixed_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2522 /* vld3 */, ARM::VLD3qWB_register_Asm_8, Convert__VecListThreeQ1_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListThreeQ, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2522 /* vld3 */, ARM::VLD3d16, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3q16, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3d32, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3q32, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3d8, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3q8, Convert__Reg1_3__Reg1_4__Reg1_5__AlignedMemory2_7__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3d16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3q16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3d32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3q32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3d8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3q8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__imm_95_0__AlignedMemory2_7__Imm1_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd16, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq16, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd32, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq32, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd8, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq8, Convert__Reg1_3__Reg1_6__Reg1_9__AlignedMemory2_13__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPd8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2522 /* vld3 */, ARM::VLD3DUPq8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__imm_95_0__DupAlignedMemory642_13__Imm1_14__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_DupAlignedMemory64, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdAsm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64 }, },
  { 2527 /* vld4 */, ARM::VLD4dAsm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4LNdAsm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqAsm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64 }, },
  { 2527 /* vld4 */, ARM::VLD4qAsm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4LNqAsm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdAsm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128 }, },
  { 2527 /* vld4 */, ARM::VLD4dAsm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4LNdAsm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqAsm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128 }, },
  { 2527 /* vld4 */, ARM::VLD4qAsm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4LNqAsm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdAsm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32 }, },
  { 2527 /* vld4 */, ARM::VLD4dAsm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4LNdAsm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqAsm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32 }, },
  { 2527 /* vld4 */, ARM::VLD4qAsm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256 }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_16, Convert__VecListFourDAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_fixed_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_register_Asm_16, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_register_Asm_16, Convert__VecListFourDHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourDHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_16, Convert__VecListFourQAllLanes1_2__DupAlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_fixed_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_register_Asm_16, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4LNqWB_fixed_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4LNqWB_register_Asm_16, Convert__VecListFourQHWordIndexed2_2__AlignedMemory642_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK_VecListFourQHWordIndexed, MCK_AlignedMemory64, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_32, Convert__VecListFourDAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory64or128, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_fixed_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_register_Asm_32, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_register_Asm_32, Convert__VecListFourDWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourDWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_32, Convert__VecListFourQAllLanes1_2__DupAlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory64or128, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_fixed_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_register_Asm_32, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4LNqWB_fixed_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4LNqWB_register_Asm_32, Convert__VecListFourQWordIndexed2_2__AlignedMemory64or1282_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK_VecListFourQWordIndexed, MCK_AlignedMemory64or128, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_fixed_Asm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPdWB_register_Asm_8, Convert__VecListFourDAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_fixed_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4dWB_register_Asm_8, Convert__VecListFourD1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourD, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_fixed_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4LNdWB_register_Asm_8, Convert__VecListFourDByteIndexed2_2__AlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourDByteIndexed, MCK_AlignedMemory32, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_fixed_Asm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4DUPqWB_register_Asm_8, Convert__VecListFourQAllLanes1_2__DupAlignedMemory322_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQAllLanes, MCK_DupAlignedMemory32, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_fixed_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK__EXCLAIM_ }, },
  { 2527 /* vld4 */, ARM::VLD4qWB_register_Asm_8, Convert__VecListFourQ1_2__AlignedMemory64or128or2562_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK_VecListFourQ, MCK_AlignedMemory64or128or256, MCK_rGPR }, },
  { 2527 /* vld4 */, ARM::VLD4d16, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4q16, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4d32, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4q32, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4d8, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4q8, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__AlignedMemory2_8__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4d16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4q16_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4d32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4q32_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4d8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4q8_UPD, Convert__Reg1_3__Reg1_4__Reg1_5__Reg1_6__imm_95_0__AlignedMemory2_8__Imm1_9__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK_DPR, MCK_DPR, MCK_DPR, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd16, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq16, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd32, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq32, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd8, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq8, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__AlignedMemory2_16__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq16_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_16, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq32_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_32, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPd8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2527 /* vld4 */, ARM::VLD4DUPq8_UPD, Convert__Reg1_3__Reg1_6__Reg1_9__Reg1_12__imm_95_0__AlignedMemory2_16__Imm1_17__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_8, MCK__123_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK_DPR, MCK__91_, MCK__93_, MCK__125_, MCK_AlignedMemory, MCK_Imm }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_16, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_32, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_8, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_16_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_32_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2532 /* vld40 */, ARM::MVE_VLD40_8_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_16, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_32, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_8, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_16_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_32_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2538 /* vld41 */, ARM::MVE_VLD41_8_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_16, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_32, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_8, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_16_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_32_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2544 /* vld42 */, ARM::MVE_VLD42_8_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_16, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_32, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_8, Convert__VecListFourMQ1_1__Tie0_1_1__MemNoOffsetT21_2, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2 }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_16_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_16, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_32_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_32, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2550 /* vld43 */, ARM::MVE_VLD43_8_wb, Convert__VecListFourMQ1_1__MemNoOffsetT2NoSp1_2__Tie0_1_1__Tie1_3_3, AMFBS_HasMVEInt, { MCK__DOT_8, MCK_VecListFourMQ, MCK_MemNoOffsetT2NoSp, MCK__EXCLAIM_ }, },
  { 2556 /* vldmdb */, ARM::VLDMDDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2556 /* vldmdb */, ARM::VLDMSDB_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2563 /* vldmia */, ARM::VLDMDIA, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK_DPRRegList }, },
  { 2563 /* vldmia */, ARM::VLDMSIA, Convert__Reg1_1__CondCode2_0__SPRRegList1_2, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK_SPRRegList }, },
  { 2563 /* vldmia */, ARM::VLDMDIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__DPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_DPRRegList }, },
  { 2563 /* vldmia */, ARM::VLDMSIA_UPD, Convert__Reg1_1__Tie0_2_2__CondCode2_0__SPRRegList1_3, AMFBS_HasFPRegs, { MCK_CondCode, MCK_GPR, MCK__EXCLAIM_, MCK_SPRRegList }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTNS_off, Convert__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTRegs, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTS_off, Convert__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTS, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_off, Convert__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_NZCVQC_off, Convert__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR_NZCVQC, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDR_P0_off, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_P0, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDR_VPR_off, Convert__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_VCCR, MCK_MemImm7s4Offset }, },
  { 2570 /* vldr */, ARM::VLDRD, Convert__Reg1_1__AddrMode52_2__CondCode2_0, AMFBS_HasFPRegs, { MCK_CondCode, MCK_DPR, MCK_AddrMode5 }, },
  { 2570 /* vldr */, ARM::VLDRS, Convert__Reg1_1__AddrMode52_2__CondCode2_0, AMFBS_HasFPRegs, { MCK_CondCode, MCK_HPR, MCK_AddrMode5 }, },
  { 2570 /* vldr */, ARM::VLDRH, Convert__Reg1_2__AddrMode5FP162_3__CondCode2_0, AMFBS_HasFPRegs16, { MCK_CondCode, MCK__DOT_16, MCK_HPR, MCK_AddrMode5FP16 }, },
  { 2570 /* vldr */, ARM::VLDRS, Convert__Reg1_2__AddrMode52_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_32, MCK_HPR, MCK_AddrMode5 }, },
  { 2570 /* vldr */, ARM::VLDRD, Convert__Reg1_2__AddrMode52_3__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_64, MCK_DPR, MCK_AddrMode5 }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTNS_pre, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTRegs, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTNS_post, Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTRegs, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTS_pre, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTS, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_FPCXTS_post, Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_FPCXTS, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_pre, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_post, Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_NZCVQC_pre, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR_NZCVQC, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_FPSCR_NZCVQC_post, Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasFPRegs_HasV8_1MMainline, { MCK_CondCode, MCK_FPSCR_NZCVQC, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2570 /* vldr */, ARM::VLDR_P0_pre, Convert__imm_95_0__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_P0, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_P0_post, Convert__imm_95_0__MemNoOffsetT21_2__Tie1_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_P0, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2570 /* vldr */, ARM::VLDR_VPR_pre, Convert__imm_95_0__MemImm7s4Offset2_2__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_VCCR, MCK_MemImm7s4Offset, MCK__EXCLAIM_ }, },
  { 2570 /* vldr */, ARM::VLDR_VPR_post, Convert__MemNoOffsetT21_2__Tie0_3_3__Imm7s41_3__CondCode2_0, AMFBS_HasV8_1MMainline_HasMVEInt, { MCK_CondCode, MCK_VCCR, MCK_MemNoOffsetT2, MCK_Imm7s4 }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS16_rq, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS16, Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_TMemImm7Shift0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS32_rq, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS32, Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_TMemImm7Shift0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU16_rq, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU16, Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_TMemImm7Shift0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU32_rq, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU32, Convert__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_TMemImm7Shift0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU8, Convert__Reg1_2__MemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_MQPR, MCK_MemImm7Shift0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU8_rq, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS16_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift0 }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS16_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_TMemImm7Shift0Offset, MCK__EXCLAIM_ }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS32_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift0 }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBS32_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_TMemImm7Shift0Offset, MCK__EXCLAIM_ }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU16_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift0 }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU16_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_TMemImm7Shift0Offset, MCK__EXCLAIM_ }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU32_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift0 }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU32_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_TMemImm7Shift0Offset, MCK__EXCLAIM_ }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU8_pre, Convert__imm_95_0__Reg1_2__MemImm7Shift0OffsetWB2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_MQPR, MCK_MemImm7Shift0OffsetWB, MCK__EXCLAIM_ }, },
  { 2575 /* vldrb */, ARM::MVE_VLDRBU8_post, Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift01_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_MQPR, MCK_MemNoOffsetT2NoSp, MCK_Imm7Shift0 }, },
  { 2581 /* vldrd */, ARM::MVE_VLDRDU64_qi, Convert__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u64, MCK_MQPR, MCK_MemRegQS3Offset }, },
  { 2581 /* vldrd */, ARM::MVE_VLDRDU64_rq_u, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u64, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2581 /* vldrd */, ARM::MVE_VLDRDU64_rq, Convert__Reg1_2__MemRegRQS3Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u64, MCK_MQPR, MCK_MemRegRQS3Offset }, },
  { 2581 /* vldrd */, ARM::MVE_VLDRDU64_qi_pre, Convert__imm_95_0__Reg1_2__MemRegQS3Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u64, MCK_MQPR, MCK_MemRegQS3Offset, MCK__EXCLAIM_ }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHS32_rq_u, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHS32_rq, Convert__Reg1_2__MemRegRQS1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MemRegRQS1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHS32, Convert__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_TMemImm7Shift1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU16, Convert__Reg1_2__MemImm7Shift1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemImm7Shift1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU16_rq_u, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU16_rq, Convert__Reg1_2__MemRegRQS1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemRegRQS1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU32_rq_u, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU32_rq, Convert__Reg1_2__MemRegRQS1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegRQS1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU32, Convert__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_TMemImm7Shift1Offset }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHS32_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift1 }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHS32_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_TMemImm7Shift1Offset, MCK__EXCLAIM_ }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU16_pre, Convert__imm_95_0__Reg1_2__MemImm7Shift1OffsetWB2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemImm7Shift1OffsetWB, MCK__EXCLAIM_ }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU16_post, Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_MQPR, MCK_MemNoOffsetT2NoSp, MCK_Imm7Shift1 }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU32_post, Convert__MemNoOffsetT1_3__Reg1_2__Tie0_4_4__Imm7Shift11_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemNoOffsetT, MCK_Imm7Shift1 }, },
  { 2587 /* vldrh */, ARM::MVE_VLDRHU32_pre, Convert__imm_95_0__Reg1_2__TMemImm7Shift1Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_TMemImm7Shift1Offset, MCK__EXCLAIM_ }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32, Convert__Reg1_2__MemImm7Shift2Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemImm7Shift2Offset }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_qi, Convert__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegQS2Offset }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_rq_u, Convert__Reg1_2__MemRegRQS0Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegRQS0Offset }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_rq, Convert__Reg1_2__MemRegRQS2Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegRQS2Offset }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_pre, Convert__imm_95_0__Reg1_2__MemImm7Shift2OffsetWB2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemImm7Shift2OffsetWB, MCK__EXCLAIM_ }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_post, Convert__MemNoOffsetT2NoSp1_3__Reg1_2__Tie0_4_4__Imm7Shift21_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemNoOffsetT2NoSp, MCK_Imm7Shift2 }, },
  { 2593 /* vldrw */, ARM::MVE_VLDRWU32_qi_pre, Convert__imm_95_0__Reg1_2__MemRegQS2Offset2_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_MQPR, MCK_MemRegQS2Offset, MCK__EXCLAIM_ }, },
  { 2599 /* vlldm */, ARM::VLLDM, Convert__Reg1_1__CondCode2_0__imm_95_0, AMFBS_HasV8MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 2599 /* vlldm */, ARM::VLLDM, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasV8MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc, MCK_DPRRegList }, },
  { 2599 /* vlldm */, ARM::VLLDM_T2, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc, MCK_DPRRegList }, },
  { 2605 /* vlstm */, ARM::VLSTM, Convert__Reg1_1__CondCode2_0__imm_95_0, AMFBS_HasV8MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc }, },
  { 2605 /* vlstm */, ARM::VLSTM, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasV8MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc, MCK_DPRRegList }, },
  { 2605 /* vlstm */, ARM::VLSTM_T2, Convert__Reg1_1__CondCode2_0__DPRRegList1_2, AMFBS_HasV8_1MMainline_Has8MSecExt, { MCK_CondCode, MCK_GPRnopc, MCK_DPRRegList }, },
  { 2611 /* vmax */, ARM::VMAXsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::VMAXhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2611 /* vmax */, ARM::VMAXhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2611 /* vmax */, ARM::MVE_VMAXu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2616 /* vmaxa */, ARM::MVE_VMAXAs16, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_MQPR }, },
  { 2616 /* vmaxa */, ARM::MVE_VMAXAs32, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MQPR }, },
  { 2616 /* vmaxa */, ARM::MVE_VMAXAs8, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_MQPR, MCK_MQPR }, },
  { 2622 /* vmaxav */, ARM::MVE_VMAXAVs16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_rGPR, MCK_MQPR }, },
  { 2622 /* vmaxav */, ARM::MVE_VMAXAVs32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_rGPR, MCK_MQPR }, },
  { 2622 /* vmaxav */, ARM::MVE_VMAXAVs8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_rGPR, MCK_MQPR }, },
  { 2629 /* vmaxnm */, ARM::NEON_VMAXNMNQf, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2629 /* vmaxnm */, ARM::NEON_VMAXNMNDf, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2629 /* vmaxnm */, ARM::VFP_VMAXNMS, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2629 /* vmaxnm */, ARM::VFP_VMAXNMD, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2629 /* vmaxnm */, ARM::NEON_VMAXNMNQh, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2629 /* vmaxnm */, ARM::NEON_VMAXNMNDh, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2629 /* vmaxnm */, ARM::VFP_VMAXNMH, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2629 /* vmaxnm */, ARM::MVE_VMAXNMf32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2629 /* vmaxnm */, ARM::MVE_VMAXNMf16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2636 /* vmaxnma */, ARM::MVE_VMAXNMAf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2636 /* vmaxnma */, ARM::MVE_VMAXNMAf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2644 /* vmaxnmav */, ARM::MVE_VMAXNMAVf32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_rGPR, MCK_MQPR }, },
  { 2644 /* vmaxnmav */, ARM::MVE_VMAXNMAVf16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_rGPR, MCK_MQPR }, },
  { 2653 /* vmaxnmv */, ARM::MVE_VMAXNMVf32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_rGPR, MCK_MQPR }, },
  { 2653 /* vmaxnmv */, ARM::MVE_VMAXNMVf16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVs16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVs32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVs8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVu16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVu32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_rGPR, MCK_MQPR }, },
  { 2661 /* vmaxv */, ARM::MVE_VMAXVu8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_rGPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::VMINsv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINsv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINsv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv8i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv4i16, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv4i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv2i32, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv16i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv8i8, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINfq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINfd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINhq, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINhd, Convert__Reg1_2__Reg1_2__Reg1_3__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINsv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINsv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINsv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINsv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_s8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv8i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv4i16, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv4i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv2i32, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINuv16i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINuv8i8, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_u8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINfq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINfd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::VMINhq, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2667 /* vmin */, ARM::VMINhd, Convert__Reg1_2__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_s8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2667 /* vmin */, ARM::MVE_VMINu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEInt, { MCK_VPTPredR, MCK__DOT_u8, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2672 /* vmina */, ARM::MVE_VMINAs16, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_MQPR, MCK_MQPR }, },
  { 2672 /* vmina */, ARM::MVE_VMINAs32, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_MQPR, MCK_MQPR }, },
  { 2672 /* vmina */, ARM::MVE_VMINAs8, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_MQPR, MCK_MQPR }, },
  { 2678 /* vminav */, ARM::MVE_VMINAVs16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_rGPR, MCK_MQPR }, },
  { 2678 /* vminav */, ARM::MVE_VMINAVs32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_rGPR, MCK_MQPR }, },
  { 2678 /* vminav */, ARM::MVE_VMINAVs8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_rGPR, MCK_MQPR }, },
  { 2685 /* vminnm */, ARM::NEON_VMINNMNQf, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON, { MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2685 /* vminnm */, ARM::NEON_VMINNMNDf, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON, { MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2685 /* vminnm */, ARM::VFP_VMINNMS, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8, { MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2685 /* vminnm */, ARM::VFP_VMINNMD, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasDPVFP, { MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2685 /* vminnm */, ARM::NEON_VMINNMNQh, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON_HasFullFP16, { MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2685 /* vminnm */, ARM::NEON_VMINNMNDh, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFPARMv8_HasNEON_HasFullFP16, { MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2685 /* vminnm */, ARM::VFP_VMINNMH, Convert__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasFullFP16, { MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2685 /* vminnm */, ARM::MVE_VMINNMf32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f32, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2685 /* vminnm */, ARM::MVE_VMINNMf16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredR4_0, AMFBS_HasMVEFloat, { MCK_VPTPredR, MCK__DOT_f16, MCK_MQPR, MCK_MQPR, MCK_MQPR }, },
  { 2692 /* vminnma */, ARM::MVE_VMINNMAf32, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_MQPR, MCK_MQPR }, },
  { 2692 /* vminnma */, ARM::MVE_VMINNMAf16, Convert__Reg1_2__Tie0_1_1__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_MQPR, MCK_MQPR }, },
  { 2700 /* vminnmav */, ARM::MVE_VMINNMAVf32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_rGPR, MCK_MQPR }, },
  { 2700 /* vminnmav */, ARM::MVE_VMINNMAVf16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_rGPR, MCK_MQPR }, },
  { 2709 /* vminnmv */, ARM::MVE_VMINNMVf32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f32, MCK_rGPR, MCK_MQPR }, },
  { 2709 /* vminnmv */, ARM::MVE_VMINNMVf16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEFloat, { MCK_VPTPredN, MCK__DOT_f16, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVs16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVs32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVs8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVu16, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVu32, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_rGPR, MCK_MQPR }, },
  { 2717 /* vminv */, ARM::MVE_VMINVu8, Convert__Reg1_2__Tie0_3_3__Reg1_3__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_rGPR, MCK_MQPR }, },
  { 2723 /* vmla */, ARM::VMLAfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2723 /* vmla */, ARM::VMLAfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAS, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2, { MCK_CondCode, MCK__DOT_f32, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2723 /* vmla */, ARM::VMLAD, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasVFP2_HasDPVFP, { MCK_CondCode, MCK__DOT_f64, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2723 /* vmla */, ARM::VMLAv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2723 /* vmla */, ARM::VMLAv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAv16i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2723 /* vmla */, ARM::VMLAv8i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i8, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_QPR }, },
  { 2723 /* vmla */, ARM::VMLAhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR }, },
  { 2723 /* vmla */, ARM::VMLAH, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__CondCode2_0, AMFBS_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_HPR, MCK_HPR, MCK_HPR }, },
  { 2723 /* vmla */, ARM::MVE_VMLA_qr_i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i16, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2723 /* vmla */, ARM::MVE_VMLA_qr_i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i32, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2723 /* vmla */, ARM::MVE_VMLA_qr_i8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_i8, MCK_MQPR, MCK_MQPR, MCK_rGPR }, },
  { 2723 /* vmla */, ARM::VMLAslfq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2723 /* vmla */, ARM::VMLAslfd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_f32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2723 /* vmla */, ARM::VMLAslv8i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2723 /* vmla */, ARM::VMLAslv4i16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2723 /* vmla */, ARM::VMLAslv4i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_QPR, MCK_QPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2723 /* vmla */, ARM::VMLAslv2i32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex321_5__CondCode2_0, AMFBS_HasNEON, { MCK_CondCode, MCK__DOT_i32, MCK_DPR, MCK_DPR, MCK_DPR_VFP2, MCK_VectorIndex32 }, },
  { 2723 /* vmla */, ARM::VMLAslhq, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_QPR, MCK_QPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2723 /* vmla */, ARM::VMLAslhd, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VectorIndex161_5__CondCode2_0, AMFBS_HasNEON_HasFullFP16, { MCK_CondCode, MCK__DOT_f16, MCK_DPR, MCK_DPR, MCK_DPR_8, MCK_VectorIndex16 }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVs8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVu16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVu32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2728 /* vmladav */, ARM::MVE_VMLADAVu8, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVas16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVas32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVas8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVau16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVau32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u32, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2736 /* vmladava */, ARM::MVE_VMLADAVau8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_u8, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2745 /* vmladavax */, ARM::MVE_VMLADAVaxs16, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2745 /* vmladavax */, ARM::MVE_VMLADAVaxs32, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s32, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2745 /* vmladavax */, ARM::MVE_VMLADAVaxs8, Convert__Reg1_2__Tie0_1_1__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s8, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2755 /* vmladavx */, ARM::MVE_VMLADAVxs16, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt, { MCK_VPTPredN, MCK__DOT_s16, MCK_tGPREven, MCK_MQPR, MCK_MQPR }, },
  { 2755 /* vmladavx */, ARM::MVE_VMLADAVxs32, Convert__Reg1_2__Reg1_3__Reg1_4__VPTPredN3_0, AMFBS_HasMVEInt,